/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.detector.api;

import com.android.tools.lint.client.api.LintClient;
import com.android.tools.lint.client.api.LintFixPerformer;
import com.android.tools.lint.detector.api.ApiConstraint;
import com.android.tools.lint.detector.api.Context;
import com.android.tools.lint.detector.api.DefaultPosition;
import com.android.tools.lint.detector.api.Location;
import com.android.tools.lint.detector.api.Position;
import com.android.utils.XmlUtils;
import com.google.common.base.Splitter;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiTypeElement;
import com.intellij.util.text.StringKt;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.intellij.lang.annotations.RegExp;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.asJava.elements.KtLightElement;
import org.jetbrains.kotlin.psi.KtModifierList;
import org.jetbrains.kotlin.psi.KtNamedFunction;
import org.jetbrains.kotlin.psi.KtProperty;
import org.w3c.dom.Attr;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u000b\n\u0002\b\u0016\b\u0016\u0018\u0000 $2\u00020\u0001:\u0011\u0014\u0015\u0016\u0017\u0018\u0019\u001a\u001b\u001c\u001d\u001e\u001f !\"#$B-\b\u0004\u0012\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u0012\n\b\u0002\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\n\u0010\r\u001a\u0004\u0018\u00010\u0003H\u0016J\u0006\u0010\u000e\u001a\u00020\u000fJ\b\u0010\u0010\u001a\u0004\u0018\u00010\u0003J\u0018\u0010\u0013\u001a\u00020\u00002\u0006\u0010\u0011\u001a\u00020\u000f2\u0006\u0010\u0012\u001a\u00020\u000fH\u0016J\u0006\u0010\u0013\u001a\u00020\u0000R\u0014\u0010\u0002\u001a\u0004\u0018\u00010\u00038\u0002@\u0002X\u0083\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0004\u001a\u0004\u0018\u00010\u00038\u0002@\u0002X\u0083\u000e\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\t\u0010\n\"\u0004\b\u000b\u0010\fR\u0012\u0010\u0011\u001a\u00020\u000f8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0012\u001a\u00020\u000f8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006%"}, d2={"Lcom/android/tools/lint/detector/api/LintFix;", "", "displayName", "", "familyName", "range", "Lcom/android/tools/lint/detector/api/Location;", "<init>", "(Ljava/lang/String;Ljava/lang/String;Lcom/android/tools/lint/detector/api/Location;)V", "getRange", "()Lcom/android/tools/lint/detector/api/Location;", "setRange", "(Lcom/android/tools/lint/detector/api/Location;)V", "getDisplayName", "hasDisplayName", "", "getFamilyName", "robot", "independent", "autoFix", "Builder", "AnnotateBuilder", "GroupType", "GroupBuilder", "ReplaceStringBuilder", "CreateFileBuilder", "UrlBuilder", "SetAttributeBuilder", "FixMapBuilder", "DataMap", "ShowUrl", "AnnotateFix", "LintFixGroup", "SetAttribute", "ReplaceString", "CreateFileFix", "Companion", "lint-api"})
public class LintFix {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nls
    @Nullable
    private String displayName;
    @Nls
    @Nullable
    private String familyName;
    @Nullable
    private Location range;
    @JvmField
    public boolean robot;
    @JvmField
    public boolean independent;
    @NotNull
    public static final String TODO = "TODO";

    protected LintFix(@Nullable String displayName, @Nullable String familyName, @Nullable Location range) {
        this.displayName = displayName;
        this.familyName = familyName;
        this.range = range;
    }

    public /* synthetic */ LintFix(String string, String string2, Location location2, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            string = null;
        }
        if ((n & 2) != 0) {
            string2 = null;
        }
        if ((n & 4) != 0) {
            location2 = null;
        }
        this(string, string2, location2);
    }

    @Nullable
    public Location getRange() {
        return this.range;
    }

    public void setRange(@Nullable Location location2) {
        this.range = location2;
    }

    @Nullable
    public String getDisplayName() {
        return this.displayName;
    }

    public final boolean hasDisplayName() {
        return this.displayName != null;
    }

    @Nullable
    public final String getFamilyName() {
        return this.familyName;
    }

    @NotNull
    public LintFix autoFix(boolean robot, boolean independent) {
        this.robot = robot;
        this.independent = independent;
        return this;
    }

    @NotNull
    public final LintFix autoFix() {
        this.autoFix(true, true);
        return this;
    }

    protected LintFix() {
        this(null, null, null, 7, null);
    }

    @JvmStatic
    @NotNull
    public static final Builder create() {
        return Companion.create();
    }

    @JvmStatic
    @Contract(value="_, _, !null -> !null")
    @Nullable
    public static final String getString(@Nullable LintFix fix, @NotNull String key, @Nullable String defaultValue) {
        return Companion.getString(fix, key, defaultValue);
    }

    @JvmStatic
    @Nullable
    public static final List<String> getStringList(@Nullable LintFix fix, @NotNull String key) {
        return Companion.getStringList(fix, key);
    }

    @JvmStatic
    @Nullable
    public static final Throwable getThrowable(@Nullable LintFix fix, @NotNull String key) {
        return Companion.getThrowable(fix, key);
    }

    @JvmStatic
    public static final int getInt(@Nullable LintFix fix, @NotNull String key, int defaultValue) {
        return Companion.getInt(fix, key, defaultValue);
    }

    @JvmStatic
    @Contract(value="_, _, !null -> !null")
    @Nullable
    public static final ApiConstraint getApiConstraint(@Nullable LintFix fix, @NotNull String key, @Nullable ApiConstraint defaultValue) {
        return Companion.getApiConstraint(fix, key, defaultValue);
    }

    @JvmStatic
    public static final boolean getBoolean(@Nullable LintFix fix, @NotNull String key, boolean defaultValue) {
        return Companion.getBoolean(fix, key, defaultValue);
    }

    @JvmStatic
    @Nullable
    public static final PsiMethod getMethod(@Nullable LintFix fix, @NotNull String key) {
        return Companion.getMethod(fix, key);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001BQ\b\u0000\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\n\b\u0002\u0010\b\u001a\u0004\u0018\u00010\t\u0012\n\b\u0002\u0010\n\u001a\u0004\u0018\u00010\u000b\u0012\n\b\u0002\u0010\f\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0004\b\r\u0010\u000eJ\u000e\u0010\u000f\u001a\u00020\u00002\u0006\u0010\u000f\u001a\u00020\u0010J\u0006\u0010\u0013\u001a\u00020\u0000J\u0016\u0010\u0013\u001a\u00020\u00002\u0006\u0010\u0011\u001a\u00020\u00072\u0006\u0010\u0012\u001a\u00020\u0007J\u0012\u0010\u0014\u001a\u00020\u00002\n\b\u0001\u0010\f\u001a\u0004\u0018\u00010\u0003J\u0006\u0010\u0015\u001a\u00020\u0016R\u0012\u0010\u0002\u001a\u0004\u0018\u00010\u00038\u0002X\u0083\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0004\u001a\u0004\u0018\u00010\u00038\u0002@\u0002X\u0083\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\b\u001a\u0004\u0018\u00010\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\n\u001a\u0004\u0018\u00010\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\f\u001a\u0004\u0018\u00010\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000f\u001a\u0004\u0018\u00010\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lcom/android/tools/lint/detector/api/LintFix$AnnotateBuilder;", "", "displayName", "", "familyName", "annotation", "replace", "", "context", "Lcom/android/tools/lint/detector/api/Context;", "element", "Lcom/intellij/psi/PsiElement;", "selectPattern", "<init>", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;ZLcom/android/tools/lint/detector/api/Context;Lcom/intellij/psi/PsiElement;Ljava/lang/String;)V", "range", "Lcom/android/tools/lint/detector/api/Location;", "robot", "independent", "autoFix", "select", "build", "Lcom/android/tools/lint/detector/api/LintFix;", "lint-api"})
    public static final class AnnotateBuilder {
        @Nls
        @Nullable
        private final String displayName;
        @Nls
        @Nullable
        private String familyName;
        private final boolean replace;
        @Nullable
        private final Context context;
        @Nullable
        private final PsiElement element;
        @Nullable
        private String selectPattern;
        @NotNull
        private final String annotation;
        @Nullable
        private Location range;
        private boolean robot;
        private boolean independent;

        /*
         * WARNING - void declaration
         */
        public AnnotateBuilder(@Nullable String displayName, @Nullable String familyName, @NotNull String annotation, boolean replace, @Nullable Context context2, @Nullable PsiElement element, @Nullable String selectPattern) {
            Location location2;
            Intrinsics.checkNotNullParameter((Object)annotation, (String)"annotation");
            this.displayName = displayName;
            this.familyName = familyName;
            this.replace = replace;
            this.context = context2;
            this.element = element;
            this.selectPattern = selectPattern;
            this.annotation = StringsKt.startsWith$default((String)annotation, (String)"@", (boolean)false, (int)2, null) ? annotation : "@" + annotation;
            AnnotateBuilder annotateBuilder = this;
            if (this.context == null || this.element == null) {
                location2 = null;
            } else {
                PsiElement psiElement;
                PsiElement anchorElement;
                PsiElement psiElement2;
                PsiElement psiElement3 = this.element;
                if (psiElement3 instanceof KtNamedFunction) {
                    KtModifierList ktModifierList = ((KtNamedFunction)this.element).getModifierList();
                    if (ktModifierList != null) {
                        psiElement2 = (PsiElement)ktModifierList;
                    } else {
                        psiElement2 = ((KtNamedFunction)this.element).getFunKeyword();
                        if (psiElement2 == null) {
                            psiElement2 = this.element;
                        }
                    }
                } else if (psiElement3 instanceof PsiMethod) {
                    psiElement2 = (PsiElement)((PsiMethod)this.element).getModifierList();
                } else if (psiElement3 instanceof KtProperty) {
                    KtModifierList ktModifierList = ((KtProperty)this.element).getModifierList();
                    psiElement2 = ktModifierList != null ? (PsiElement)ktModifierList : ((KtProperty)this.element).getValOrVarKeyword();
                } else if (psiElement3 instanceof PsiField) {
                    PsiModifierList psiModifierList = ((PsiField)this.element).getModifierList();
                    if (psiModifierList != null) {
                        psiElement2 = (PsiElement)psiModifierList;
                    } else {
                        PsiTypeElement psiTypeElement = ((PsiField)this.element).getTypeElement();
                        psiElement2 = psiTypeElement != null ? (PsiElement)psiTypeElement : this.element;
                    }
                } else {
                    psiElement2 = anchorElement = null;
                }
                if (anchorElement instanceof KtLightElement) {
                    anchorElement = (PsiElement)((KtLightElement)anchorElement).getKotlinOrigin();
                }
                if ((psiElement = anchorElement) == null) {
                    psiElement = this.element;
                }
                Position position = Context.getLocation$default(this.context, psiElement, null, 2, null).getStart();
                if (position != null) {
                    Location location3;
                    Position position2 = position;
                    AnnotateBuilder annotateBuilder2 = annotateBuilder;
                    boolean bl = false;
                    Position position3 = Context.getLocation$default(this.context, this.element, null, 2, null).getEnd();
                    if (position3 != null) {
                        void start;
                        Position end = position3;
                        boolean bl2 = false;
                        location3 = Companion.extractOffsets(Location.Companion.create(this.context.file, (Position)start, end));
                    } else {
                        location3 = null;
                    }
                    location2 = location3;
                    annotateBuilder = annotateBuilder2;
                } else {
                    location2 = null;
                }
            }
            annotateBuilder.range = location2;
        }

        public /* synthetic */ AnnotateBuilder(String string, String string2, String string3, boolean bl, Context context2, PsiElement psiElement, String string4, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 0x10) != 0) {
                context2 = null;
            }
            if ((n & 0x20) != 0) {
                psiElement = null;
            }
            if ((n & 0x40) != 0) {
                string4 = null;
            }
            this(string, string2, string3, bl, context2, psiElement, string4);
        }

        @NotNull
        public final AnnotateBuilder range(@NotNull Location range) {
            Intrinsics.checkNotNullParameter((Object)range, (String)"range");
            this.range = Companion.extractOffsets(range);
            return this;
        }

        @NotNull
        public final AnnotateBuilder autoFix() {
            this.autoFix(true, true);
            return this;
        }

        @NotNull
        public final AnnotateBuilder autoFix(boolean robot, boolean independent) {
            this.robot = robot;
            this.independent = independent;
            return this;
        }

        @NotNull
        public final AnnotateBuilder select(@RegExp @Nullable String selectPattern) {
            this.selectPattern = selectPattern;
            return this;
        }

        @NotNull
        public final LintFix build() {
            Object desc = null;
            if (this.displayName != null) {
                desc = this.displayName;
            } else {
                Object object;
                int last;
                int index = StringsKt.indexOf$default((CharSequence)this.annotation, (char)'(', (int)0, (boolean)false, (int)6, null);
                int n = last = index != -1 ? StringsKt.lastIndexOf$default((CharSequence)this.annotation, (char)'.', (int)index, (boolean)false, (int)4, null) : StringsKt.lastIndexOf$default((CharSequence)this.annotation, (char)'.', (int)0, (boolean)false, (int)6, null);
                if (last != -1) {
                    if (index != -1) {
                        String string = this.annotation.substring(last + 1, index);
                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
                        object = "@" + string;
                    } else {
                        String string = this.annotation.substring(last + 1);
                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
                        object = "@" + string;
                    }
                } else {
                    object = this.annotation;
                }
                String simpleName = object;
                desc = "Annotate with " + simpleName;
            }
            return new AnnotateFix((String)desc, this.familyName, this.annotation, this.replace, this.range, this.selectPattern, this.robot, this.independent);
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000b\u0018\u00002\u00020\u0001BQ\b\u0000\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\b\u0010\b\u001a\u0004\u0018\u00010\t\u0012\b\u0010\n\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u000b\u001a\u00020\u0007\u0012\u0006\u0010\f\u001a\u00020\u0007\u00a2\u0006\u0004\b\r\u0010\u000eR\u0011\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0013\u0010\n\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0010\u00a8\u0006\u0014"}, d2={"Lcom/android/tools/lint/detector/api/LintFix$AnnotateFix;", "Lcom/android/tools/lint/detector/api/LintFix;", "displayName", "", "familyName", "annotation", "replace", "", "range", "Lcom/android/tools/lint/detector/api/Location;", "selectPattern", "robot", "independent", "<init>", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;ZLcom/android/tools/lint/detector/api/Location;Ljava/lang/String;ZZ)V", "getAnnotation", "()Ljava/lang/String;", "getReplace", "()Z", "getSelectPattern", "lint-api"})
    public static final class AnnotateFix
    extends LintFix {
        @NotNull
        private final String annotation;
        private final boolean replace;
        @Nullable
        private final String selectPattern;

        public AnnotateFix(@Nullable String displayName, @Nullable String familyName, @NotNull String annotation, boolean replace, @Nullable Location range, @Nullable String selectPattern, boolean robot, boolean independent) {
            Intrinsics.checkNotNullParameter((Object)annotation, (String)"annotation");
            super(displayName, familyName, range);
            this.annotation = annotation;
            this.replace = replace;
            this.selectPattern = selectPattern;
            this.robot = robot;
            this.independent = independent;
        }

        @NotNull
        public final String getAnnotation() {
            return this.annotation;
        }

        public final boolean getReplace() {
            return this.replace;
        }

        @Nullable
        public final String getSelectPattern() {
            return this.selectPattern;
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0088\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0007\u001a\u00020\u00002\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005J\u0016\u0010\u0007\u001a\u00020\u00002\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0005J\u0016\u0010\u0007\u001a\u00020\u00002\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\b\u001a\u00020\tJ\u0010\u0010\n\u001a\u00020\u00002\b\u0010\u0006\u001a\u0004\u0018\u00010\u0005J\u0010\u0010\u000b\u001a\u00020\u00002\b\u0010\u0006\u001a\u0004\u0018\u00010\u0005J\u0006\u0010\f\u001a\u00020\rJ\u0006\u0010\u000e\u001a\u00020\rJ\u0006\u0010\u000f\u001a\u00020\rJ#\u0010\u000f\u001a\u00020\u00102\u0016\u0010\u0011\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010\u00100\u0012\"\u0004\u0018\u00010\u0010\u00a2\u0006\u0002\u0010\u0013J\u0016\u0010\u000f\u001a\u00020\u00102\u000e\u0010\u0011\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00100\u0014J#\u0010\f\u001a\u00020\u00102\u0016\u0010\u0011\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010\u00100\u0012\"\u0004\u0018\u00010\u0010\u00a2\u0006\u0002\u0010\u0013J#\u0010\u000e\u001a\u00020\u00102\u0016\u0010\u0011\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010\u00100\u0012\"\u0004\u0018\u00010\u0010\u00a2\u0006\u0002\u0010\u0013J\u0006\u0010\u0015\u001a\u00020\u0016J\u0016\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u0005J\u0016\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001cJ\u000e\u0010\u001d\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001aJ\u0006\u0010\u001e\u001a\u00020\u001fJ\u0006\u0010 \u001a\u00020\u001fJ%\u0010\u001e\u001a\u00020\u001f2\b\u0010!\u001a\u0004\u0018\u00010\u00052\u0006\u0010\"\u001a\u00020\u00052\b\u0010#\u001a\u0004\u0018\u00010\u0005H\u0086\u0002J\u0018\u0010 \u001a\u00020\u001f2\b\u0010!\u001a\u0004\u0018\u00010\u00052\u0006\u0010\"\u001a\u00020\u0005J\"\u0010$\u001a\u00020\r2\u0006\u0010%\u001a\u00020\u00052\u0006\u0010&\u001a\u00020\u00052\n\b\u0002\u0010'\u001a\u0004\u0018\u00010(J.\u0010)\u001a\u00020\r2\u0006\u0010\"\u001a\u00020*2\n\b\u0002\u0010+\u001a\u0004\u0018\u00010\u00052\b\b\u0002\u0010,\u001a\u00020\u00052\b\b\u0002\u0010-\u001a\u00020\u0005JB\u0010)\u001a\u00020\r2\b\u0010!\u001a\u0004\u0018\u00010\u00052\u0006\u0010\"\u001a\u00020\u00052\u0006\u0010-\u001a\u00020\u00052\n\b\u0002\u0010+\u001a\u0004\u0018\u00010\u00052\b\b\u0002\u0010,\u001a\u00020\u00052\n\b\u0002\u0010.\u001a\u0004\u0018\u00010\u0005J\u0006\u0010/\u001a\u000200J%\u0010/\u001a\u0002002\u0016\u00101\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010\u00010\u0012\"\u0004\u0018\u00010\u0001H\u0002\u00a2\u0006\u0002\u00102J#\u00103\u001a\u00020\u00102\u0016\u00101\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010\u00010\u0012\"\u0004\u0018\u00010\u0001\u00a2\u0006\u0002\u00104J\u0006\u00105\u001a\u000206J\u000e\u00105\u001a\u0002062\u0006\u00105\u001a\u00020\u0005J\u001a\u00107\u001a\u0002082\u0006\u00109\u001a\u00020\u00052\b\b\u0002\u0010\u0015\u001a\u00020\tH\u0007J.\u00107\u001a\u0002082\u0006\u00109\u001a\u00020\u00052\b\u0010:\u001a\u0004\u0018\u00010;2\b\u0010<\u001a\u0004\u0018\u00010=2\b\b\u0002\u0010\u0015\u001a\u00020\tH\u0007R\u0014\u0010\u0004\u001a\u0004\u0018\u00010\u00058\u0002@\u0002X\u0083\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\u0004\u0018\u00010\u00058\u0002@\u0002X\u0083\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006>"}, d2={"Lcom/android/tools/lint/detector/api/LintFix$Builder;", "", "<init>", "()V", "displayName", "", "familyName", "name", "useAsFamilyNameToo", "", "sharedName", "family", "group", "Lcom/android/tools/lint/detector/api/LintFix$GroupBuilder;", "alternatives", "composite", "Lcom/android/tools/lint/detector/api/LintFix;", "fixes", "", "([Lcom/android/tools/lint/detector/api/LintFix;)Lcom/android/tools/lint/detector/api/LintFix;", "", "replace", "Lcom/android/tools/lint/detector/api/LintFix$ReplaceStringBuilder;", "newFile", "Lcom/android/tools/lint/detector/api/LintFix$CreateFileBuilder;", "file", "Ljava/io/File;", "contents", "", "deleteFile", "set", "Lcom/android/tools/lint/detector/api/LintFix$SetAttributeBuilder;", "unset", "namespace", "attribute", "value", "renameTag", "current", "newName", "range", "Lcom/android/tools/lint/detector/api/Location;", "replaceAttribute", "Lorg/w3c/dom/Attr;", "newNamespace", "newAttribute", "newValue", "newNamespacePrefix", "map", "Lcom/android/tools/lint/detector/api/LintFix$FixMapBuilder;", "args", "([Ljava/lang/Object;)Lcom/android/tools/lint/detector/api/LintFix$FixMapBuilder;", "data", "([Ljava/lang/Object;)Lcom/android/tools/lint/detector/api/LintFix;", "url", "Lcom/android/tools/lint/detector/api/LintFix$UrlBuilder;", "annotate", "Lcom/android/tools/lint/detector/api/LintFix$AnnotateBuilder;", "source", "context", "Lcom/android/tools/lint/detector/api/Context;", "element", "Lcom/intellij/psi/PsiElement;", "lint-api"})
    @SourceDebugExtension(value={"SMAP\nLintFix.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LintFix.kt\ncom/android/tools/lint/detector/api/LintFix$Builder\n+ 2 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,2197:1\n37#2:2198\n36#2,3:2199\n37#2:2202\n36#2,3:2203\n37#2:2206\n36#2,3:2207\n37#2:2210\n36#2,3:2211\n1#3:2214\n*S KotlinDebug\n*F\n+ 1 LintFix.kt\ncom/android/tools/lint/detector/api/LintFix$Builder\n*L\n246#1:2198\n246#1:2199,3\n262#1:2202\n262#1:2203,3\n275#1:2206\n275#1:2207,3\n295#1:2210\n295#1:2211,3\n*E\n"})
    public static final class Builder {
        @Nls
        @Nullable
        private String displayName;
        @Nls
        @Nullable
        private String familyName;

        @NotNull
        public final Builder name(@Nullable String displayName) {
            this.displayName = displayName;
            return this;
        }

        @NotNull
        public final Builder name(@NotNull String displayName, @NotNull String familyName) {
            Intrinsics.checkNotNullParameter((Object)displayName, (String)"displayName");
            Intrinsics.checkNotNullParameter((Object)familyName, (String)"familyName");
            this.displayName = displayName;
            this.familyName = familyName;
            return this;
        }

        @NotNull
        public final Builder name(@NotNull String displayName, boolean useAsFamilyNameToo) {
            Intrinsics.checkNotNullParameter((Object)displayName, (String)"displayName");
            this.displayName = displayName;
            if (useAsFamilyNameToo) {
                this.familyName = displayName;
            }
            return this;
        }

        @NotNull
        public final Builder sharedName(@Nullable String familyName) {
            this.familyName = familyName;
            return this;
        }

        @NotNull
        public final Builder family(@Nullable String familyName) {
            this.familyName = familyName;
            return this;
        }

        @NotNull
        public final GroupBuilder group() {
            return new GroupBuilder(this.displayName, this.familyName).type(GroupType.ALTERNATIVES);
        }

        @NotNull
        public final GroupBuilder alternatives() {
            return this.group();
        }

        @NotNull
        public final GroupBuilder composite() {
            return new GroupBuilder(this.displayName, this.familyName).type(GroupType.COMPOSITE);
        }

        @NotNull
        public final LintFix composite(LintFix ... fixes) {
            Intrinsics.checkNotNullParameter((Object)fixes, (String)"fixes");
            Collection $this$toTypedArray$iv = ArraysKt.filterNotNull((Object[])fixes);
            boolean $i$f$toTypedArray = false;
            Collection thisCollection$iv = $this$toTypedArray$iv;
            LintFix[] lintFixArray = thisCollection$iv.toArray(new LintFix[0]);
            return new GroupBuilder(this.displayName, this.familyName).type(GroupType.COMPOSITE).join(Arrays.copyOf(lintFixArray, lintFixArray.length)).build();
        }

        @NotNull
        public final LintFix composite(@NotNull List<? extends LintFix> fixes) {
            Intrinsics.checkNotNullParameter(fixes, (String)"fixes");
            Collection $this$toTypedArray$iv = CollectionsKt.filterNotNull((Iterable)fixes);
            boolean $i$f$toTypedArray = false;
            Collection thisCollection$iv = $this$toTypedArray$iv;
            LintFix[] lintFixArray = thisCollection$iv.toArray(new LintFix[0]);
            return new GroupBuilder(this.displayName, this.familyName).type(GroupType.COMPOSITE).join(Arrays.copyOf(lintFixArray, lintFixArray.length)).build();
        }

        @NotNull
        public final LintFix group(LintFix ... fixes) {
            Intrinsics.checkNotNullParameter((Object)fixes, (String)"fixes");
            Collection $this$toTypedArray$iv = ArraysKt.filterNotNull((Object[])fixes);
            boolean $i$f$toTypedArray = false;
            Collection thisCollection$iv = $this$toTypedArray$iv;
            LintFix[] lintFixArray = thisCollection$iv.toArray(new LintFix[0]);
            return new GroupBuilder(this.displayName, this.familyName).join(Arrays.copyOf(lintFixArray, lintFixArray.length)).build();
        }

        @NotNull
        public final LintFix alternatives(LintFix ... fixes) {
            LintFix lintFix;
            Intrinsics.checkNotNullParameter((Object)fixes, (String)"fixes");
            List availableFixes = ArraysKt.filterNotNull((Object[])fixes);
            if (availableFixes.isEmpty()) {
                lintFix = this.map().build();
            } else if (availableFixes.size() == 1) {
                lintFix = (LintFix)availableFixes.get(0);
            } else {
                Collection $this$toTypedArray$iv = availableFixes;
                boolean $i$f$toTypedArray = false;
                Collection thisCollection$iv = $this$toTypedArray$iv;
                LintFix[] lintFixArray = thisCollection$iv.toArray(new LintFix[0]);
                lintFix = this.group(Arrays.copyOf(lintFixArray, lintFixArray.length));
            }
            return lintFix;
        }

        @NotNull
        public final ReplaceStringBuilder replace() {
            return new ReplaceStringBuilder(this.displayName, this.familyName);
        }

        @NotNull
        public final CreateFileBuilder newFile(@NotNull File file, @NotNull String contents) {
            Intrinsics.checkNotNullParameter((Object)file, (String)"file");
            Intrinsics.checkNotNullParameter((Object)contents, (String)"contents");
            return new CreateFileBuilder(this.displayName, this.familyName).file(file).contents(contents);
        }

        @NotNull
        public final CreateFileBuilder newFile(@NotNull File file, @NotNull byte[] contents) {
            Intrinsics.checkNotNullParameter((Object)file, (String)"file");
            Intrinsics.checkNotNullParameter((Object)contents, (String)"contents");
            return new CreateFileBuilder(this.displayName, this.familyName).file(file).contents(contents);
        }

        @NotNull
        public final CreateFileBuilder deleteFile(@NotNull File file) {
            Intrinsics.checkNotNullParameter((Object)file, (String)"file");
            return new CreateFileBuilder(this.displayName, this.familyName).delete(file);
        }

        @NotNull
        public final SetAttributeBuilder set() {
            return new SetAttributeBuilder(this.displayName, this.familyName);
        }

        @NotNull
        public final SetAttributeBuilder unset() {
            return new SetAttributeBuilder(this.displayName, this.familyName).value(null);
        }

        @NotNull
        public final SetAttributeBuilder set(@Nullable String namespace, @NotNull String attribute, @Nullable String value) {
            Intrinsics.checkNotNullParameter((Object)attribute, (String)"attribute");
            return new SetAttributeBuilder(this.displayName, this.familyName).namespace(namespace).attribute(attribute).value(value);
        }

        @NotNull
        public final SetAttributeBuilder unset(@Nullable String namespace, @NotNull String attribute) {
            Intrinsics.checkNotNullParameter((Object)attribute, (String)"attribute");
            return new SetAttributeBuilder(this.displayName, this.familyName).namespace(namespace).attribute(attribute).value(null);
        }

        @NotNull
        public final GroupBuilder renameTag(@NotNull String current, @NotNull String newName, @Nullable Location range) {
            ReplaceStringBuilder replaceStringBuilder;
            ReplaceStringBuilder replaceStringBuilder2;
            Intrinsics.checkNotNullParameter((Object)current, (String)"current");
            Intrinsics.checkNotNullParameter((Object)newName, (String)"newName");
            ReplaceStringBuilder $this$renameTag_u24lambda_u240 = replaceStringBuilder2 = this.replace().pattern("<(" + current + ")\\b").with(newName);
            boolean bl = false;
            if (range != null) {
                $this$renameTag_u24lambda_u240.range(range);
            }
            LintFix open = replaceStringBuilder2.build();
            ReplaceStringBuilder $this$renameTag_u24lambda_u241 = replaceStringBuilder = ReplaceStringBuilder.optional$default(this.replace().pattern("</(" + current + ")\\s*>").with(newName), false, 1, null);
            boolean bl2 = false;
            if (range != null) {
                $this$renameTag_u24lambda_u241.range(range);
            }
            LintFix close = replaceStringBuilder.build();
            return this.name("Replace with `<" + newName + ">`").composite().add(open).add(close);
        }

        public static /* synthetic */ GroupBuilder renameTag$default(Builder builder, String string, String string2, Location location2, int n, Object object) {
            if ((n & 4) != 0) {
                location2 = null;
            }
            return builder.renameTag(string, string2, location2);
        }

        @NotNull
        public final GroupBuilder replaceAttribute(@NotNull Attr attribute, @Nullable String newNamespace, @NotNull String newAttribute, @NotNull String newValue) {
            String string;
            Intrinsics.checkNotNullParameter((Object)attribute, (String)"attribute");
            Intrinsics.checkNotNullParameter((Object)newAttribute, (String)"newAttribute");
            Intrinsics.checkNotNullParameter((Object)newValue, (String)"newValue");
            if (newNamespace != null) {
                string = attribute.lookupPrefix(newNamespace);
                if (string == null) {
                    string = LintFixPerformer.Companion.suggestNamespacePrefix(newNamespace);
                }
            } else {
                string = null;
            }
            String prefix = string;
            String string2 = StringKt.nullize$default((String)attribute.getNamespaceURI(), (boolean)false, (int)1, null);
            String string3 = attribute.getLocalName();
            if (string3 == null) {
                string3 = attribute.getName();
            }
            String string4 = string3;
            Intrinsics.checkNotNull((Object)string4);
            return this.replaceAttribute(string2, string4, newValue, newNamespace, newAttribute, prefix);
        }

        public static /* synthetic */ GroupBuilder replaceAttribute$default(Builder builder, Attr attr, String string, String string2, String string3, int n, Object object) {
            if ((n & 2) != 0) {
                string = StringKt.nullize$default((String)attr.getNamespaceURI(), (boolean)false, (int)1, null);
            }
            if ((n & 4) != 0) {
                String string4 = attr.getLocalName();
                if (string4 == null) {
                    String string5 = attr.getName();
                    string4 = string5;
                    Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"getName(...)");
                }
                string2 = string4;
            }
            if ((n & 8) != 0) {
                string3 = attr.getValue();
            }
            return builder.replaceAttribute(attr, string, string2, string3);
        }

        @NotNull
        public final GroupBuilder replaceAttribute(@Nullable String namespace, @NotNull String attribute, @NotNull String newValue, @Nullable String newNamespace, @NotNull String newAttribute, @Nullable String newNamespacePrefix) {
            Intrinsics.checkNotNullParameter((Object)attribute, (String)"attribute");
            Intrinsics.checkNotNullParameter((Object)newValue, (String)"newValue");
            Intrinsics.checkNotNullParameter((Object)newAttribute, (String)"newAttribute");
            GroupBuilder groupBuilder = this.composite();
            Object object = this.displayName;
            if (object == null) {
                CharSequence charSequence = newNamespacePrefix;
                object = !(charSequence == null || StringsKt.isBlank((CharSequence)charSequence)) ? "Update to `" + newNamespacePrefix + ":" + newAttribute + "`" : (!Intrinsics.areEqual((Object)newAttribute, (Object)attribute) ? "Update to `" + newAttribute + "`" : (namespace != null ? "Drop namespace prefix" : "Replace attribute"));
            }
            return groupBuilder.name((String)object).add(this.unset(namespace, attribute).build()).add(this.set(newNamespace, newAttribute, newValue).build());
        }

        public static /* synthetic */ GroupBuilder replaceAttribute$default(Builder builder, String string, String string2, String string3, String string4, String string5, String string6, int n, Object object) {
            if ((n & 8) != 0) {
                string4 = string;
            }
            if ((n & 0x10) != 0) {
                string5 = string2;
            }
            if ((n & 0x20) != 0) {
                string6 = LintFixPerformer.Companion.suggestNamespacePrefix(string4);
            }
            return builder.replaceAttribute(string, string2, string3, string4, string5, string6);
        }

        @NotNull
        public final FixMapBuilder map() {
            return new FixMapBuilder(this.displayName, this.familyName);
        }

        private final FixMapBuilder map(Object ... args) {
            boolean bl;
            FixMapBuilder builder = this.map();
            Map<String, Object> map = builder.getMap$lint_api();
            boolean bl2 = bl = args.length % 2 == 0;
            if (_Assertions.ENABLED && !bl) {
                String string = "Assertion failed";
                throw new AssertionError((Object)string);
            }
            for (int i = 0; i < args.length; i += 2) {
                boolean bl3;
                String key = String.valueOf(args[i]);
                Object value = args[i + 1];
                if (value == null) continue;
                Object previous = map.put(key, value);
                boolean bl4 = bl3 = previous == null;
                if (!_Assertions.ENABLED || bl3) continue;
                String string = "Assertion failed";
                throw new AssertionError((Object)string);
            }
            return builder;
        }

        @NotNull
        public final LintFix data(Object ... args) {
            Intrinsics.checkNotNullParameter((Object)args, (String)"args");
            return this.map(Arrays.copyOf(args, args.length)).build();
        }

        @NotNull
        public final UrlBuilder url() {
            return new UrlBuilder(this.displayName, this.familyName, null);
        }

        @NotNull
        public final UrlBuilder url(@NotNull String url) {
            Intrinsics.checkNotNullParameter((Object)url, (String)"url");
            return new UrlBuilder(this.displayName, this.familyName, url);
        }

        @Deprecated(message="Use annotate(String, Context?, PsiElement?, Boolean = true) instead.")
        @JvmOverloads
        @NotNull
        public final AnnotateBuilder annotate(@NotNull String source, boolean replace) {
            Intrinsics.checkNotNullParameter((Object)source, (String)"source");
            return new AnnotateBuilder(this.displayName, this.familyName, source, replace, null, null, null, 112, null);
        }

        public static /* synthetic */ AnnotateBuilder annotate$default(Builder builder, String string, boolean bl, int n, Object object) {
            if ((n & 2) != 0) {
                bl = true;
            }
            return builder.annotate(string, bl);
        }

        @JvmOverloads
        @NotNull
        public final AnnotateBuilder annotate(@NotNull String source, @Nullable Context context2, @Nullable PsiElement element, boolean replace) {
            Intrinsics.checkNotNullParameter((Object)source, (String)"source");
            return new AnnotateBuilder(this.displayName, this.familyName, source, replace, context2, element, null, 64, null);
        }

        public static /* synthetic */ AnnotateBuilder annotate$default(Builder builder, String string, Context context2, PsiElement psiElement, boolean bl, int n, Object object) {
            if ((n & 8) != 0) {
                bl = true;
            }
            return builder.annotate(string, context2, psiElement, bl);
        }

        @Deprecated(message="Use annotate(String, Context?, PsiElement?, Boolean = true) instead.")
        @JvmOverloads
        @NotNull
        public final AnnotateBuilder annotate(@NotNull String source) {
            Intrinsics.checkNotNullParameter((Object)source, (String)"source");
            return Builder.annotate$default(this, source, false, 2, null);
        }

        @JvmOverloads
        @NotNull
        public final AnnotateBuilder annotate(@NotNull String source, @Nullable Context context2, @Nullable PsiElement element) {
            Intrinsics.checkNotNullParameter((Object)source, (String)"source");
            return Builder.annotate$default(this, source, context2, element, false, 8, null);
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0000\n\u0002\u0010\u0003\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0006\u001a\u00020\u0007H\u0007J&\u0010\b\u001a\u0004\u0018\u00010\u00052\b\u0010\t\u001a\u0004\u0018\u00010\n2\u0006\u0010\u000b\u001a\u00020\u00052\b\u0010\f\u001a\u0004\u0018\u00010\u0005H\u0007J\"\u0010\r\u001a\n\u0012\u0004\u0012\u00020\u0005\u0018\u00010\u000e2\b\u0010\t\u001a\u0004\u0018\u00010\n2\u0006\u0010\u000b\u001a\u00020\u0005H\u0007J\u001c\u0010\u000f\u001a\u0004\u0018\u00010\u00102\b\u0010\t\u001a\u0004\u0018\u00010\n2\u0006\u0010\u000b\u001a\u00020\u0005H\u0007J\"\u0010\u0011\u001a\u00020\u00122\b\u0010\t\u001a\u0004\u0018\u00010\n2\u0006\u0010\u000b\u001a\u00020\u00052\u0006\u0010\f\u001a\u00020\u0012H\u0007J(\u0010\u0013\u001a\u0004\u0018\u00010\u00142\b\u0010\t\u001a\u0004\u0018\u00010\n2\u0006\u0010\u000b\u001a\u00020\u00052\n\b\u0002\u0010\f\u001a\u0004\u0018\u00010\u0014H\u0007J\"\u0010\u0015\u001a\u00020\u00162\b\u0010\t\u001a\u0004\u0018\u00010\n2\u0006\u0010\u000b\u001a\u00020\u00052\u0006\u0010\f\u001a\u00020\u0016H\u0007J\u001c\u0010\u0017\u001a\u0004\u0018\u00010\u00182\b\u0010\t\u001a\u0004\u0018\u00010\n2\u0006\u0010\u000b\u001a\u00020\u0005H\u0007J\u0010\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001aH\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lcom/android/tools/lint/detector/api/LintFix$Companion;", "", "<init>", "()V", "TODO", "", "create", "Lcom/android/tools/lint/detector/api/LintFix$Builder;", "getString", "fix", "Lcom/android/tools/lint/detector/api/LintFix;", "key", "defaultValue", "getStringList", "", "getThrowable", "", "getInt", "", "getApiConstraint", "Lcom/android/tools/lint/detector/api/ApiConstraint;", "getBoolean", "", "getMethod", "Lcom/intellij/psi/PsiMethod;", "extractOffsets", "Lcom/android/tools/lint/detector/api/Location;", "range", "lint-api"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final Builder create() {
            return new Builder();
        }

        @JvmStatic
        @Contract(value="_, _, !null -> !null")
        @Nullable
        public final String getString(@Nullable LintFix fix, @NotNull String key, @Nullable String defaultValue) {
            Intrinsics.checkNotNullParameter((Object)key, (String)"key");
            return fix instanceof DataMap ? ((DataMap)fix).getString(key, defaultValue) : defaultValue;
        }

        @JvmStatic
        @Nullable
        public final List<String> getStringList(@Nullable LintFix fix, @NotNull String key) {
            Intrinsics.checkNotNullParameter((Object)key, (String)"key");
            return fix instanceof DataMap ? ((DataMap)fix).getStringList(key) : null;
        }

        @JvmStatic
        @Nullable
        public final Throwable getThrowable(@Nullable LintFix fix, @NotNull String key) {
            Intrinsics.checkNotNullParameter((Object)key, (String)"key");
            return fix instanceof DataMap ? ((DataMap)fix).getThrowable(key) : null;
        }

        @JvmStatic
        public final int getInt(@Nullable LintFix fix, @NotNull String key, int defaultValue) {
            Intrinsics.checkNotNullParameter((Object)key, (String)"key");
            return fix instanceof DataMap ? ((DataMap)fix).getInt(key, defaultValue) : defaultValue;
        }

        @JvmStatic
        @Contract(value="_, _, !null -> !null")
        @Nullable
        public final ApiConstraint getApiConstraint(@Nullable LintFix fix, @NotNull String key, @Nullable ApiConstraint defaultValue) {
            ApiConstraint apiConstraint;
            Intrinsics.checkNotNullParameter((Object)key, (String)"key");
            if (fix instanceof DataMap) {
                apiConstraint = ((DataMap)fix).getApiConstraint(key);
                if (apiConstraint == null) {
                    apiConstraint = defaultValue;
                }
            } else {
                apiConstraint = defaultValue;
            }
            return apiConstraint;
        }

        public static /* synthetic */ ApiConstraint getApiConstraint$default(Companion companion, LintFix lintFix, String string, ApiConstraint apiConstraint, int n, Object object) {
            if ((n & 4) != 0) {
                apiConstraint = ApiConstraint.UNKNOWN;
            }
            return companion.getApiConstraint(lintFix, string, apiConstraint);
        }

        @JvmStatic
        public final boolean getBoolean(@Nullable LintFix fix, @NotNull String key, boolean defaultValue) {
            Intrinsics.checkNotNullParameter((Object)key, (String)"key");
            return fix instanceof DataMap ? ((DataMap)fix).getBoolean(key, defaultValue) : defaultValue;
        }

        @JvmStatic
        @Nullable
        public final PsiMethod getMethod(@Nullable LintFix fix, @NotNull String key) {
            Intrinsics.checkNotNullParameter((Object)key, (String)"key");
            return fix instanceof DataMap ? ((DataMap)fix).getMethod(key) : null;
        }

        private final Location extractOffsets(Location range) {
            Location location2;
            Position start = range.getStart();
            Position end = range.getEnd();
            if (start != null && end != null) {
                location2 = Location.Companion.create(range.getFile(), new DefaultPosition(-1, -1, start.getOffset()), new DefaultPosition(-1, -1, end.getOffset()));
            } else {
                DefaultPosition pos = new DefaultPosition(-1, -1, 0);
                location2 = Location.Companion.create(range.getFile(), pos, pos);
            }
            return location2;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0002\b\n\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u001d\b\u0000\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u001e\u0010\u0012\u001a\u00020\u00002\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u00032\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0003J\u000e\u0010\n\u001a\u00020\u00002\u0006\u0010\n\u001a\u00020\u000bJ\u000e\u0010\b\u001a\u00020\u00002\u0006\u0010\n\u001a\u00020\u000bJ\u000e\u0010\u0013\u001a\u00020\u00002\u0006\u0010\u0013\u001a\u00020\u0003J\u000e\u0010\u0013\u001a\u00020\u00002\u0006\u0010\u0013\u001a\u00020\rJ\u0012\u0010\u0014\u001a\u00020\u00002\n\b\u0001\u0010\u0007\u001a\u0004\u0018\u00010\u0003J\u0006\u0010\u0015\u001a\u00020\u0000J\u000e\u0010\u000f\u001a\u00020\u00002\u0006\u0010\u000f\u001a\u00020\tJ\u000e\u0010\u0010\u001a\u00020\u00002\u0006\u0010\u0010\u001a\u00020\tJ\u000e\u0010\u0011\u001a\u00020\u00002\u0006\u0010\u0011\u001a\u00020\tJ\u0016\u0010\u0016\u001a\u00020\u00002\u0006\u0010\u0010\u001a\u00020\t2\u0006\u0010\u0011\u001a\u00020\tJ\u0006\u0010\u0016\u001a\u00020\u0000J\u0006\u0010\u0017\u001a\u00020\u0018R\u0014\u0010\u0002\u001a\u0004\u0018\u00010\u00038\u0002@\u0002X\u0083\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0004\u001a\u0004\u0018\u00010\u00038\u0002@\u0002X\u0083\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0007\u001a\u0004\u0018\u00010\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\n\u001a\u0004\u0018\u00010\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\f\u001a\u0004\u0018\u00010\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000e\u001a\u0004\u0018\u00010\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lcom/android/tools/lint/detector/api/LintFix$CreateFileBuilder;", "", "displayName", "", "familyName", "<init>", "(Ljava/lang/String;Ljava/lang/String;)V", "selectPattern", "delete", "", "file", "Ljava/io/File;", "binary", "", "text", "reformat", "robot", "independent", "name", "contents", "select", "open", "autoFix", "build", "Lcom/android/tools/lint/detector/api/LintFix;", "lint-api"})
    public static final class CreateFileBuilder {
        @Nls
        @Nullable
        private String displayName;
        @Nls
        @Nullable
        private String familyName;
        @Nullable
        private String selectPattern;
        private boolean delete;
        @Nullable
        private File file;
        @Nullable
        private byte[] binary;
        @Nullable
        private String text;
        private boolean reformat;
        private boolean robot;
        private boolean independent;

        public CreateFileBuilder(@Nullable String displayName, @Nullable String familyName) {
            this.displayName = displayName;
            this.familyName = familyName;
        }

        @NotNull
        public final CreateFileBuilder name(@Nullable String displayName, @Nullable String familyName) {
            this.displayName = displayName;
            this.familyName = familyName;
            return this;
        }

        public static /* synthetic */ CreateFileBuilder name$default(CreateFileBuilder createFileBuilder, String string, String string2, int n, Object object) {
            if ((n & 1) != 0) {
                string = null;
            }
            if ((n & 2) != 0) {
                string2 = null;
            }
            return createFileBuilder.name(string, string2);
        }

        @NotNull
        public final CreateFileBuilder file(@NotNull File file) {
            boolean bl;
            Intrinsics.checkNotNullParameter((Object)file, (String)"file");
            boolean bl2 = bl = this.file == null;
            if (_Assertions.ENABLED && !bl) {
                String string = "Assertion failed";
                throw new AssertionError((Object)string);
            }
            this.file = file;
            return this;
        }

        @NotNull
        public final CreateFileBuilder delete(@NotNull File file) {
            boolean bl;
            Intrinsics.checkNotNullParameter((Object)file, (String)"file");
            boolean bl2 = bl = this.file == null && this.binary == null && this.text == null;
            if (_Assertions.ENABLED && !bl) {
                String string = "Assertion failed";
                throw new AssertionError((Object)string);
            }
            this.file = file;
            this.delete = true;
            return this;
        }

        @NotNull
        public final CreateFileBuilder contents(@NotNull String contents) {
            boolean bl;
            Intrinsics.checkNotNullParameter((Object)contents, (String)"contents");
            boolean bl2 = bl = this.binary == null && !this.delete;
            if (_Assertions.ENABLED && !bl) {
                String string = "Assertion failed";
                throw new AssertionError((Object)string);
            }
            this.text = contents;
            return this;
        }

        @NotNull
        public final CreateFileBuilder contents(@NotNull byte[] contents) {
            boolean bl;
            Intrinsics.checkNotNullParameter((Object)contents, (String)"contents");
            boolean bl2 = bl = this.text == null && !this.delete;
            if (_Assertions.ENABLED && !bl) {
                String string = "Assertion failed";
                throw new AssertionError((Object)string);
            }
            this.binary = contents;
            return this;
        }

        @NotNull
        public final CreateFileBuilder select(@RegExp @Nullable String selectPattern) {
            this.selectPattern = selectPattern;
            return this;
        }

        @NotNull
        public final CreateFileBuilder open() {
            this.selectPattern = "()";
            return this;
        }

        @NotNull
        public final CreateFileBuilder reformat(boolean reformat) {
            this.reformat = reformat;
            return this;
        }

        @NotNull
        public final CreateFileBuilder robot(boolean robot) {
            this.robot = robot;
            return this;
        }

        @NotNull
        public final CreateFileBuilder independent(boolean independent) {
            this.independent = independent;
            return this;
        }

        @NotNull
        public final CreateFileBuilder autoFix(boolean robot, boolean independent) {
            this.robot(robot);
            this.independent(independent);
            return this;
        }

        @NotNull
        public final CreateFileBuilder autoFix() {
            this.autoFix(true, true);
            return this;
        }

        @NotNull
        public final LintFix build() {
            File file = this.file;
            Intrinsics.checkNotNull((Object)file);
            return new CreateFileFix(this.displayName, this.familyName, this.selectPattern, this.delete, file, this.binary, this.text, this.reformat, this.robot, this.independent);
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0012\u0018\u00002\u00020\u0001Ba\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\b\u0010\n\u001a\u0004\u0018\u00010\u000b\u0012\b\u0010\f\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\r\u001a\u00020\u0007\u0012\u0006\u0010\u000e\u001a\u00020\u0007\u0012\u0006\u0010\u000f\u001a\u00020\u0007\u00a2\u0006\u0004\b\u0010\u0010\u0011J\b\u0010\u001c\u001a\u00020\u0003H\u0016R\u0013\u0010\u0005\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u0013\u0010\n\u001a\u0004\u0018\u00010\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R\u0013\u0010\f\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u0013R\u0011\u0010\r\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u0015\u00a8\u0006\u001d"}, d2={"Lcom/android/tools/lint/detector/api/LintFix$CreateFileFix;", "Lcom/android/tools/lint/detector/api/LintFix;", "displayName", "", "familyName", "selectPattern", "delete", "", "file", "Ljava/io/File;", "binary", "", "text", "reformat", "robot", "independent", "<init>", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;ZLjava/io/File;[BLjava/lang/String;ZZZ)V", "getSelectPattern", "()Ljava/lang/String;", "getDelete", "()Z", "getFile", "()Ljava/io/File;", "getBinary", "()[B", "getText", "getReformat", "getDisplayName", "lint-api"})
    public static final class CreateFileFix
    extends LintFix {
        @Nullable
        private final String selectPattern;
        private final boolean delete;
        @NotNull
        private final File file;
        @Nullable
        private final byte[] binary;
        @Nullable
        private final String text;
        private final boolean reformat;

        public CreateFileFix(@Nullable String displayName, @Nullable String familyName, @Nullable String selectPattern, boolean delete, @NotNull File file, @Nullable byte[] binary, @Nullable String text, boolean reformat, boolean robot, boolean independent) {
            Intrinsics.checkNotNullParameter((Object)file, (String)"file");
            super(displayName, familyName, Location.Companion.create(file));
            this.selectPattern = selectPattern;
            this.delete = delete;
            this.file = file;
            this.binary = binary;
            this.text = text;
            this.reformat = reformat;
            this.robot = robot;
            this.independent = independent;
        }

        @Nullable
        public final String getSelectPattern() {
            return this.selectPattern;
        }

        public final boolean getDelete() {
            return this.delete;
        }

        @NotNull
        public final File getFile() {
            return this.file;
        }

        @Nullable
        public final byte[] getBinary() {
            return this.binary;
        }

        @Nullable
        public final String getText() {
            return this.text;
        }

        public final boolean getReformat() {
            return this.reformat;
        }

        @Override
        @NotNull
        public String getDisplayName() {
            String string = super.getDisplayName();
            if (string == null) {
                return this.delete ? "Delete " + this.file.getName() : "Create " + this.file.getName();
            }
            return string;
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\b\u0004\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0003\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B/\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u0012\u0012\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00070\u0006\u00a2\u0006\u0004\b\b\u0010\tJ\u000e\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u0003J\u0013\u0010\r\u001a\u0004\u0018\u00010\u00072\u0006\u0010\f\u001a\u00020\u0003H\u0086\u0002J\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00030\u000fJ\b\u0010\u0010\u001a\u00020\u0003H\u0016J\u001c\u0010\u0011\u001a\u0004\u0018\u00010\u00032\u0006\u0010\f\u001a\u00020\u00032\b\u0010\u0012\u001a\u0004\u0018\u00010\u0003H\u0007J\u0016\u0010\u0013\u001a\n\u0012\u0004\u0012\u00020\u0003\u0018\u00010\u00142\u0006\u0010\f\u001a\u00020\u0003J\u001c\u0010\u0015\u001a\u0004\u0018\u00010\u00162\u0006\u0010\f\u001a\u00020\u00032\b\u0010\u0012\u001a\u0004\u0018\u00010\u0016H\u0007J\u0016\u0010\u0017\u001a\u00020\u00182\u0006\u0010\f\u001a\u00020\u00032\u0006\u0010\u0012\u001a\u00020\u0018J\u0016\u0010\u0019\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u00032\u0006\u0010\u0012\u001a\u00020\u000bJ\u0010\u0010\u001a\u001a\u0004\u0018\u00010\u001b2\u0006\u0010\f\u001a\u00020\u0003J\u0010\u0010\u001c\u001a\u0004\u0018\u00010\u001d2\u0006\u0010\f\u001a\u00020\u0003J\u0010\u0010\u001e\u001a\u0004\u0018\u00010\u001f2\u0006\u0010\f\u001a\u00020\u0003R\u001a\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Lcom/android/tools/lint/detector/api/LintFix$DataMap;", "Lcom/android/tools/lint/detector/api/LintFix;", "displayName", "", "familyName", "map", "", "", "<init>", "(Ljava/lang/String;Ljava/lang/String;Ljava/util/Map;)V", "hasKey", "", "key", "get", "keys", "", "toString", "getString", "defaultValue", "getStringList", "", "getFile", "Ljava/io/File;", "getInt", "", "getBoolean", "getMethod", "Lcom/intellij/psi/PsiMethod;", "getThrowable", "", "getApiConstraint", "Lcom/android/tools/lint/detector/api/ApiConstraint;", "lint-api"})
    public static final class DataMap
    extends LintFix {
        @NotNull
        private final Map<String, Object> map;

        public DataMap(@Nullable String displayName, @Nullable String familyName, @NotNull Map<String, ? extends Object> map) {
            Intrinsics.checkNotNullParameter(map, (String)"map");
            super(displayName, familyName, null, 4, null);
            this.map = map;
        }

        public final boolean hasKey(@NotNull String key) {
            Intrinsics.checkNotNullParameter((Object)key, (String)"key");
            return this.map.containsKey(key);
        }

        @Nullable
        public final Object get(@NotNull String key) {
            Intrinsics.checkNotNullParameter((Object)key, (String)"key");
            return this.map.get(key);
        }

        @NotNull
        public final Set<String> keys() {
            return this.map.keySet();
        }

        @NotNull
        public String toString() {
            return this.map.toString();
        }

        @Contract(value="_, !null -> !null")
        @Nullable
        public final String getString(@NotNull String key, @Nullable String defaultValue) {
            Intrinsics.checkNotNullParameter((Object)key, (String)"key");
            Object value = this.map.get(key);
            Object object = value;
            if (object == null || (object = object.toString()) == null) {
                object = defaultValue;
            }
            return object;
        }

        @Nullable
        public final List<String> getStringList(@NotNull String key) {
            Intrinsics.checkNotNullParameter((Object)key, (String)"key");
            Object value = this.map.get(key);
            if (value instanceof List) {
                return (List)value;
            }
            if (value instanceof String) {
                return Splitter.on((String)",").splitToList((CharSequence)value);
            }
            return null;
        }

        @Contract(value="_, !null -> !null")
        @Nullable
        public final File getFile(@NotNull String key, @Nullable File defaultValue) {
            Intrinsics.checkNotNullParameter((Object)key, (String)"key");
            Object value = this.map.get(key);
            if (value != null) {
                if (value instanceof File) {
                    return (File)value;
                }
                if (value instanceof String) {
                    return new File((String)value);
                }
            }
            return defaultValue;
        }

        public final int getInt(@NotNull String key, int defaultValue) {
            Intrinsics.checkNotNullParameter((Object)key, (String)"key");
            Object value = this.map.get(key);
            if (value != null) {
                if (value instanceof Number) {
                    return ((Number)value).intValue();
                }
                if (value instanceof String) {
                    try {
                        return Integer.parseInt((String)value);
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                }
            }
            return defaultValue;
        }

        public final boolean getBoolean(@NotNull String key, boolean defaultValue) {
            Intrinsics.checkNotNullParameter((Object)key, (String)"key");
            Object value = this.map.get(key);
            if (value != null) {
                if (value instanceof Boolean) {
                    return (Boolean)value;
                }
                if (value instanceof String) {
                    return Intrinsics.areEqual((Object)"true", (Object)value);
                }
            }
            return defaultValue;
        }

        @Nullable
        public final PsiMethod getMethod(@NotNull String key) {
            Intrinsics.checkNotNullParameter((Object)key, (String)"key");
            Object value = this.map.get(key);
            return value instanceof PsiMethod ? (PsiMethod)value : null;
        }

        @Nullable
        public final Throwable getThrowable(@NotNull String key) {
            Intrinsics.checkNotNullParameter((Object)key, (String)"key");
            Object value = this.map.get(key);
            return value instanceof Throwable ? (Throwable)value : null;
        }

        @Nullable
        public final ApiConstraint getApiConstraint(@NotNull String key) {
            Intrinsics.checkNotNullParameter((Object)key, (String)"key");
            Object value = this.map.get(key);
            if (value instanceof ApiConstraint) {
                return (ApiConstraint)value;
            }
            if (value instanceof String) {
                return ApiConstraint.Companion.deserialize((String)value);
            }
            return null;
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010%\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0003\n\u0002\u0010\b\n\u0002\u0010\u000b\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u001d\b\u0000\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0018\u0010\u000b\u001a\u00020\u00002\u0006\u0010\f\u001a\u00020\u00032\b\u0010\r\u001a\u0004\u0018\u00010\u0003J\u0018\u0010\u000b\u001a\u00020\u00002\u0006\u0010\f\u001a\u00020\u00032\b\u0010\r\u001a\u0004\u0018\u00010\u000eJ\u0018\u0010\u000b\u001a\u00020\u00002\u0006\u0010\f\u001a\u00020\u00032\b\u0010\u000f\u001a\u0004\u0018\u00010\u0010J\u0016\u0010\u000b\u001a\u00020\u00002\u0006\u0010\f\u001a\u00020\u00032\u0006\u0010\r\u001a\u00020\u0011J\u0016\u0010\u000b\u001a\u00020\u00002\u0006\u0010\f\u001a\u00020\u00032\u0006\u0010\r\u001a\u00020\u0012J\u001e\u0010\u000b\u001a\u00020\u00002\u0006\u0010\f\u001a\u00020\u00032\u000e\u0010\r\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00030\u0013J\u0006\u0010\u0014\u001a\u00020\u0015R\u0012\u0010\u0002\u001a\u0004\u0018\u00010\u00038\u0002X\u0083\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0004\u001a\u0004\u0018\u00010\u00038\u0002X\u0083\u0004\u00a2\u0006\u0002\n\u0000R \u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00010\bX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0016"}, d2={"Lcom/android/tools/lint/detector/api/LintFix$FixMapBuilder;", "", "displayName", "", "familyName", "<init>", "(Ljava/lang/String;Ljava/lang/String;)V", "map", "", "getMap$lint_api", "()Ljava/util/Map;", "put", "key", "value", "Lcom/intellij/psi/PsiMethod;", "throwable", "", "", "", "", "build", "Lcom/android/tools/lint/detector/api/LintFix;", "lint-api"})
    public static final class FixMapBuilder {
        @Nls
        @Nullable
        private final String displayName;
        @Nls
        @Nullable
        private final String familyName;
        @NotNull
        private final Map<String, Object> map;

        public FixMapBuilder(@Nullable String displayName, @Nullable String familyName) {
            this.displayName = displayName;
            this.familyName = familyName;
            HashMap hashMap = Maps.newHashMapWithExpectedSize((int)4);
            Intrinsics.checkNotNullExpressionValue((Object)hashMap, (String)"newHashMapWithExpectedSize(...)");
            this.map = hashMap;
        }

        @NotNull
        public final Map<String, Object> getMap$lint_api() {
            return this.map;
        }

        @NotNull
        public final FixMapBuilder put(@NotNull String key, @Nullable String value) {
            boolean bl;
            Intrinsics.checkNotNullParameter((Object)key, (String)"key");
            if (value == null) {
                return this;
            }
            boolean bl2 = bl = !this.map.containsKey(key);
            if (_Assertions.ENABLED && !bl) {
                String string = "Assertion failed";
                throw new AssertionError((Object)string);
            }
            this.map.put(key, value);
            return this;
        }

        @NotNull
        public final FixMapBuilder put(@NotNull String key, @Nullable PsiMethod value) {
            boolean bl;
            Intrinsics.checkNotNullParameter((Object)key, (String)"key");
            if (value == null) {
                return this;
            }
            boolean bl2 = bl = !this.map.containsKey(key);
            if (_Assertions.ENABLED && !bl) {
                String string = "Assertion failed";
                throw new AssertionError((Object)string);
            }
            this.map.put(key, value);
            return this;
        }

        @NotNull
        public final FixMapBuilder put(@NotNull String key, @Nullable Throwable throwable) {
            boolean bl;
            Intrinsics.checkNotNullParameter((Object)key, (String)"key");
            if (throwable == null) {
                return this;
            }
            boolean bl2 = bl = !this.map.containsKey(key);
            if (_Assertions.ENABLED && !bl) {
                String string = "Assertion failed";
                throw new AssertionError((Object)string);
            }
            this.map.put(key, throwable);
            return this;
        }

        @NotNull
        public final FixMapBuilder put(@NotNull String key, int value) {
            boolean bl;
            Intrinsics.checkNotNullParameter((Object)key, (String)"key");
            boolean bl2 = bl = !this.map.containsKey(key);
            if (_Assertions.ENABLED && !bl) {
                String string = "Assertion failed";
                throw new AssertionError((Object)string);
            }
            Integer n = value;
            this.map.put(key, n);
            return this;
        }

        @NotNull
        public final FixMapBuilder put(@NotNull String key, boolean value) {
            boolean bl;
            Intrinsics.checkNotNullParameter((Object)key, (String)"key");
            boolean bl2 = bl = !this.map.containsKey(key);
            if (_Assertions.ENABLED && !bl) {
                String string = "Assertion failed";
                throw new AssertionError((Object)string);
            }
            Boolean bl3 = value;
            this.map.put(key, bl3);
            return this;
        }

        @NotNull
        public final FixMapBuilder put(@NotNull String key, @NotNull List<String> value) {
            boolean bl;
            Intrinsics.checkNotNullParameter((Object)key, (String)"key");
            Intrinsics.checkNotNullParameter(value, (String)"value");
            boolean bl2 = bl = !this.map.containsKey(key);
            if (_Assertions.ENABLED && !bl) {
                String string = "Assertion failed";
                throw new AssertionError((Object)string);
            }
            this.map.put(key, value);
            return this;
        }

        @NotNull
        public final LintFix build() {
            return new DataMap(this.displayName, this.familyName, this.map);
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0010\u0011\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u001d\b\u0000\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0010\u0010\u000f\u001a\u00020\u00002\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003J\u0016\u0010\u000f\u001a\u00020\u00002\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0003J\u0010\u0010\u0010\u001a\u00020\u00002\b\u0010\u0004\u001a\u0004\u0018\u00010\u0003J\u0016\u0010\u0011\u001a\u00020\u00002\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\rJ\u0006\u0010\u0011\u001a\u00020\u0000J\u001f\u0010\u0012\u001a\u00020\u00002\u0012\u0010\u0013\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u000b0\u0014\"\u00020\u000b\u00a2\u0006\u0002\u0010\u0015J\u000e\u0010\u0016\u001a\u00020\u00002\u0006\u0010\u0017\u001a\u00020\u000bJ\u000e\u0010\u0007\u001a\u00020\u00002\u0006\u0010\u0007\u001a\u00020\bJ\u000e\u0010\u0018\u001a\u00020\u00002\u0006\u0010\u0018\u001a\u00020\u0019J\u0006\u0010\u001a\u001a\u00020\u000bR\u0014\u0010\u0002\u001a\u0004\u0018\u00010\u00038\u0002@\u0002X\u0083\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0004\u001a\u0004\u0018\u00010\u00038\u0002@\u0002X\u0083\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lcom/android/tools/lint/detector/api/LintFix$GroupBuilder;", "", "displayName", "", "familyName", "<init>", "(Ljava/lang/String;Ljava/lang/String;)V", "type", "Lcom/android/tools/lint/detector/api/LintFix$GroupType;", "list", "", "Lcom/android/tools/lint/detector/api/LintFix;", "robot", "", "independent", "name", "sharedName", "autoFix", "join", "fixes", "", "([Lcom/android/tools/lint/detector/api/LintFix;)Lcom/android/tools/lint/detector/api/LintFix$GroupBuilder;", "add", "fix", "range", "Lcom/android/tools/lint/detector/api/Location;", "build", "lint-api"})
    @SourceDebugExtension(value={"SMAP\nLintFix.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LintFix.kt\ncom/android/tools/lint/detector/api/LintFix$GroupBuilder\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,2197:1\n13472#2,2:2198\n1869#3,2:2200\n*S KotlinDebug\n*F\n+ 1 LintFix.kt\ncom/android/tools/lint/detector/api/LintFix$GroupBuilder\n*L\n748#1:2198,2\n757#1:2200,2\n*E\n"})
    public static final class GroupBuilder {
        @Nls
        @Nullable
        private String displayName;
        @Nls
        @Nullable
        private String familyName;
        @NotNull
        private GroupType type;
        @NotNull
        private final List<LintFix> list;
        private boolean robot;
        private boolean independent;

        public GroupBuilder(@Nullable String displayName, @Nullable String familyName) {
            this.displayName = displayName;
            this.familyName = familyName;
            this.type = GroupType.ALTERNATIVES;
            ArrayList arrayList = Lists.newArrayListWithExpectedSize((int)4);
            Intrinsics.checkNotNullExpressionValue((Object)arrayList, (String)"newArrayListWithExpectedSize(...)");
            this.list = arrayList;
        }

        @NotNull
        public final GroupBuilder name(@Nullable String displayName) {
            this.displayName = displayName;
            return this;
        }

        @NotNull
        public final GroupBuilder name(@NotNull String displayName, @NotNull String familyName) {
            Intrinsics.checkNotNullParameter((Object)displayName, (String)"displayName");
            Intrinsics.checkNotNullParameter((Object)familyName, (String)"familyName");
            this.displayName = displayName;
            this.familyName = familyName;
            return this;
        }

        @NotNull
        public final GroupBuilder sharedName(@Nullable String familyName) {
            this.familyName = familyName;
            return this;
        }

        @NotNull
        public final GroupBuilder autoFix(boolean robot, boolean independent) {
            this.robot = robot;
            this.independent = independent;
            for (LintFix fix : this.list) {
                fix.autoFix(robot, independent);
            }
            return this;
        }

        @NotNull
        public final GroupBuilder autoFix() {
            this.autoFix(true, true);
            return this;
        }

        @NotNull
        public final GroupBuilder join(LintFix ... fixes) {
            Intrinsics.checkNotNullParameter((Object)fixes, (String)"fixes");
            LintFix[] $this$forEach$iv = fixes;
            boolean $i$f$forEach = false;
            int n = $this$forEach$iv.length;
            for (int i = 0; i < n; ++i) {
                LintFix element$iv;
                LintFix it = element$iv = $this$forEach$iv[i];
                boolean bl = false;
                this.add(it);
            }
            return this;
        }

        @NotNull
        public final GroupBuilder add(@NotNull LintFix fix) {
            Intrinsics.checkNotNullParameter((Object)fix, (String)"fix");
            if (this.type == GroupType.COMPOSITE && fix instanceof LintFixGroup) {
                if (((LintFixGroup)fix).getType() == GroupType.COMPOSITE) {
                    Iterable $this$forEach$iv = ((LintFixGroup)fix).getFixes();
                    boolean $i$f$forEach = false;
                    for (Object element$iv : $this$forEach$iv) {
                        LintFix it = (LintFix)element$iv;
                        boolean bl = false;
                        this.add(it);
                    }
                    return this;
                }
                throw new IllegalStateException("Cannot place alternatives-groups inside composite groups".toString());
            }
            this.list.add(fix);
            return this;
        }

        @NotNull
        public final GroupBuilder type(@NotNull GroupType type) {
            Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
            this.type = type;
            return this;
        }

        @NotNull
        public final GroupBuilder range(@NotNull Location range) {
            Intrinsics.checkNotNullParameter((Object)range, (String)"range");
            boolean found = false;
            for (LintFix fix : this.list) {
                if (fix.getRange() != null) continue;
                fix.setRange(range);
                found = true;
            }
            if (!found) {
                throw new IllegalStateException("All the nested fixes already have a custom range set. Make sure this method is called after adding all the nested fixes. (If the fixes all have appropriate ranges setting it on the group is not necessary.)".toString());
            }
            return this;
        }

        @NotNull
        public final LintFix build() {
            boolean bl;
            boolean bl2 = bl = !((Collection)this.list).isEmpty();
            if (_Assertions.ENABLED && !bl) {
                String string = "Assertion failed";
                throw new AssertionError((Object)string);
            }
            if (this.list.size() == 1) {
                LintFix single = this.list.get(0);
                String string = this.displayName;
                if (string != null) {
                    String it = string;
                    boolean bl3 = false;
                    single.displayName = it;
                    single.familyName = this.familyName;
                }
                return single;
            }
            return new LintFixGroup(this.displayName, this.familyName, this.type, this.list, this.robot, this.independent);
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0005\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003j\u0002\b\u0004j\u0002\b\u0005\u00a8\u0006\u0006"}, d2={"Lcom/android/tools/lint/detector/api/LintFix$GroupType;", "", "<init>", "(Ljava/lang/String;I)V", "COMPOSITE", "ALTERNATIVES", "lint-api"})
    public static final class GroupType
    extends Enum<GroupType> {
        public static final /* enum */ GroupType COMPOSITE = new GroupType();
        public static final /* enum */ GroupType ALTERNATIVES = new GroupType();
        private static final /* synthetic */ GroupType[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static GroupType[] values() {
            return (GroupType[])$VALUES.clone();
        }

        public static GroupType valueOf(String value) {
            return Enum.valueOf(GroupType.class, value);
        }

        @NotNull
        public static EnumEntries<GroupType> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = groupTypeArray = new GroupType[]{GroupType.COMPOSITE, GroupType.ALTERNATIVES};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0010\u000b\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\b\u0018\u00002\u00020\u0001BA\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00010\b\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\n\u00a2\u0006\u0004\b\f\u0010\rJ\n\u0010\u0019\u001a\u0004\u0018\u00010\u0003H\u0017J\u0018\u0010\u001a\u001a\u00020\u00012\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\nH\u0016R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0017\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00010\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R(\u0010\u0014\u001a\u0004\u0018\u00010\u00132\b\u0010\u0012\u001a\u0004\u0018\u00010\u0013@VX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0015\u0010\u0016\"\u0004\b\u0017\u0010\u0018\u00a8\u0006\u001b"}, d2={"Lcom/android/tools/lint/detector/api/LintFix$LintFixGroup;", "Lcom/android/tools/lint/detector/api/LintFix;", "displayName", "", "familyName", "type", "Lcom/android/tools/lint/detector/api/LintFix$GroupType;", "fixes", "", "robot", "", "independent", "<init>", "(Ljava/lang/String;Ljava/lang/String;Lcom/android/tools/lint/detector/api/LintFix$GroupType;Ljava/util/List;ZZ)V", "getType", "()Lcom/android/tools/lint/detector/api/LintFix$GroupType;", "getFixes", "()Ljava/util/List;", "value", "Lcom/android/tools/lint/detector/api/Location;", "range", "getRange", "()Lcom/android/tools/lint/detector/api/Location;", "setRange", "(Lcom/android/tools/lint/detector/api/Location;)V", "getDisplayName", "autoFix", "lint-api"})
    @SourceDebugExtension(value={"SMAP\nLintFix.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LintFix.kt\ncom/android/tools/lint/detector/api/LintFix$LintFixGroup\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,2197:1\n1617#2,9:2198\n1869#2:2207\n1870#2:2209\n1626#2:2210\n1#3:2208\n*S KotlinDebug\n*F\n+ 1 LintFix.kt\ncom/android/tools/lint/detector/api/LintFix$LintFixGroup\n*L\n1838#1:2198,9\n1838#1:2207\n1838#1:2209\n1838#1:2210\n1838#1:2208\n*E\n"})
    public static final class LintFixGroup
    extends LintFix {
        @NotNull
        private final GroupType type;
        @NotNull
        private final List<LintFix> fixes;
        @Nullable
        private Location range;

        public LintFixGroup(@Nullable String displayName, @Nullable String familyName, @NotNull GroupType type, @NotNull List<? extends LintFix> fixes, boolean robot, boolean independent) {
            Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
            Intrinsics.checkNotNullParameter(fixes, (String)"fixes");
            super(displayName, familyName, null, 4, null);
            this.type = type;
            this.fixes = fixes;
            this.robot = robot;
            this.independent = independent;
            if (displayName == null && this.type == GroupType.COMPOSITE && LintClient.Companion.isUnitTest()) {
                throw new IllegalStateException("You should explicitly set a display name for composite group actions; unlike string replacement, set attribute, etc. it cannot produce a good default on its own".toString());
            }
        }

        @NotNull
        public final GroupType getType() {
            return this.type;
        }

        @NotNull
        public final List<LintFix> getFixes() {
            return this.fixes;
        }

        @Override
        @Nullable
        public Location getRange() {
            return this.range;
        }

        @Override
        public void setRange(@Nullable Location value) {
            this.range = value;
            throw new IllegalStateException("Groups can't define an error range; should be set on each member".toString());
        }

        /*
         * WARNING - void declaration
         */
        @Override
        @Nls
        @Nullable
        public String getDisplayName() {
            String displayName = super.getDisplayName();
            if (displayName == null && this.type == GroupType.COMPOSITE) {
                void $this$mapNotNullTo$iv$iv;
                Iterable $this$mapNotNull$iv = this.fixes;
                boolean $i$f$mapNotNull = false;
                Iterable iterable = $this$mapNotNull$iv;
                Collection destination$iv$iv = new ArrayList();
                boolean $i$f$mapNotNullTo = false;
                void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
                boolean $i$f$forEach = false;
                Iterator iterator = $this$forEach$iv$iv$iv.iterator();
                while (iterator.hasNext()) {
                    String it$iv$iv;
                    Object element$iv$iv$iv;
                    Object element$iv$iv = element$iv$iv$iv = iterator.next();
                    boolean bl = false;
                    LintFix it = (LintFix)element$iv$iv;
                    boolean bl2 = false;
                    if (it.getDisplayName() == null) continue;
                    boolean bl3 = false;
                    destination$iv$iv.add(it$iv$iv);
                }
                return CollectionsKt.joinToString$default((Iterable)((List)destination$iv$iv), (CharSequence)" and ", null, null, (int)0, null, null, (int)62, null);
            }
            return displayName;
        }

        @Override
        @NotNull
        public LintFix autoFix(boolean robot, boolean independent) {
            for (LintFix fix : this.fixes) {
                fix.autoFix(robot, independent);
            }
            return super.autoFix(robot, independent);
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0019\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 ,2\u00020\u0001:\u0001,B\u009b\u0001\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0003\u0012\n\b\u0001\u0010\u0006\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\b\u0010\t\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\n\u001a\u00020\u0003\u0012\u0006\u0010\u000b\u001a\u00020\f\u0012\u0006\u0010\r\u001a\u00020\f\u0012\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00030\u000f\u0012\b\u0010\u0010\u001a\u0004\u0018\u00010\u0011\u0012\u0006\u0010\u0012\u001a\u00020\f\u0012\u0006\u0010\u0013\u001a\u00020\f\u0012\u0006\u0010\u0014\u001a\u00020\f\u0012\u0006\u0010\u0015\u001a\u00020\f\u0012\u0006\u0010\u0016\u001a\u00020\b\u00a2\u0006\u0004\b\u0017\u0010\u0018J\b\u0010(\u001a\u00020\u0003H\u0016J\u000e\u0010)\u001a\u00020\u00032\u0006\u0010*\u001a\u00020+R\u0013\u0010\u0005\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001aR\u0013\u0010\u0006\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u001aR\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u001dR\u0013\u0010\t\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u001aR\u0011\u0010\n\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010\u001aR\u0011\u0010\u000b\u001a\u00020\f\u00a2\u0006\b\n\u0000\u001a\u0004\b \u0010!R\u0011\u0010\r\u001a\u00020\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\"\u0010!R\u0017\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00030\u000f\u00a2\u0006\b\n\u0000\u001a\u0004\b#\u0010$R\u0011\u0010\u0012\u001a\u00020\f\u00a2\u0006\b\n\u0000\u001a\u0004\b%\u0010!R\u0011\u0010\u0013\u001a\u00020\f\u00a2\u0006\b\n\u0000\u001a\u0004\b&\u0010!R\u0011\u0010\u0016\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b'\u0010\u001d\u00a8\u0006-"}, d2={"Lcom/android/tools/lint/detector/api/LintFix$ReplaceString;", "Lcom/android/tools/lint/detector/api/LintFix;", "displayName", "", "familyName", "oldString", "oldPattern", "patternFlags", "", "selectPattern", "replacement", "shortenNames", "", "reformat", "imports", "", "range", "Lcom/android/tools/lint/detector/api/Location;", "globally", "optional", "robot", "independent", "sortPriority", "<init>", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;ILjava/lang/String;Ljava/lang/String;ZZLjava/util/List;Lcom/android/tools/lint/detector/api/Location;ZZZZI)V", "getOldString", "()Ljava/lang/String;", "getOldPattern", "getPatternFlags", "()I", "getSelectPattern", "getReplacement", "getShortenNames", "()Z", "getReformat", "getImports", "()Ljava/util/List;", "getGlobally", "getOptional", "getSortPriority", "getDisplayName", "expandBackReferences", "matcher", "Ljava/util/regex/Matcher;", "Companion", "lint-api"})
    public static final class ReplaceString
    extends LintFix {
        @NotNull
        public static final Companion Companion = new Companion(null);
        @Nullable
        private final String oldString;
        @Nullable
        private final String oldPattern;
        private final int patternFlags;
        @Nullable
        private final String selectPattern;
        @NotNull
        private final String replacement;
        private final boolean shortenNames;
        private final boolean reformat;
        @NotNull
        private final List<String> imports;
        private final boolean globally;
        private final boolean optional;
        private final int sortPriority;
        @NotNull
        public static final String INSERT_BEGINNING = "_lint_insert_begin_";
        @NotNull
        public static final String INSERT_END = "_lint_insert_end_";

        public ReplaceString(@Nullable String displayName, @Nullable String familyName, @Nullable String oldString, @RegExp @Nullable String oldPattern, int patternFlags, @Nullable String selectPattern, @NotNull String replacement, boolean shortenNames, boolean reformat, @NotNull List<String> imports, @Nullable Location range, boolean globally, boolean optional, boolean robot, boolean independent, int sortPriority) {
            Intrinsics.checkNotNullParameter((Object)replacement, (String)"replacement");
            Intrinsics.checkNotNullParameter(imports, (String)"imports");
            super(displayName, familyName, range);
            this.oldString = oldString;
            this.oldPattern = oldPattern;
            this.patternFlags = patternFlags;
            this.selectPattern = selectPattern;
            this.replacement = replacement;
            this.shortenNames = shortenNames;
            this.reformat = reformat;
            this.imports = imports;
            this.globally = globally;
            this.optional = optional;
            this.sortPriority = sortPriority;
            this.robot = robot;
            this.independent = independent;
        }

        @Nullable
        public final String getOldString() {
            return this.oldString;
        }

        @Nullable
        public final String getOldPattern() {
            return this.oldPattern;
        }

        public final int getPatternFlags() {
            return this.patternFlags;
        }

        @Nullable
        public final String getSelectPattern() {
            return this.selectPattern;
        }

        @NotNull
        public final String getReplacement() {
            return this.replacement;
        }

        public final boolean getShortenNames() {
            return this.shortenNames;
        }

        public final boolean getReformat() {
            return this.reformat;
        }

        @NotNull
        public final List<String> getImports() {
            return this.imports;
        }

        public final boolean getGlobally() {
            return this.globally;
        }

        public final boolean getOptional() {
            return this.optional;
        }

        public final int getSortPriority() {
            return this.sortPriority;
        }

        @Override
        @NotNull
        public String getDisplayName() {
            Object object;
            String displayName = super.getDisplayName();
            if (displayName != null) {
                object = displayName;
            } else {
                if (((CharSequence)this.replacement).length() == 0) {
                    return this.oldString != null ? "Delete \"" + this.oldString + "\"" : "Delete";
                }
                Object preview = this.replacement;
                int lineIndex = StringsKt.indexOf$default((CharSequence)((CharSequence)preview), (char)'\n', (int)0, (boolean)false, (int)6, null);
                if (lineIndex != -1) {
                    String string = ((String)preview).substring(0, lineIndex);
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
                    preview = string + "...";
                }
                object = "Replace with " + (String)preview;
            }
            return object;
        }

        @NotNull
        public final String expandBackReferences(@NotNull Matcher matcher) {
            Intrinsics.checkNotNullParameter((Object)matcher, (String)"matcher");
            return Companion.expandBackReferences(this.replacement, matcher);
        }

        @JvmStatic
        @NotNull
        public static final String expandBackReferences(@NotNull String replacement, @NotNull Matcher matcher) {
            return Companion.expandBackReferences(replacement, matcher);
        }

        @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0007\u001a\u00020\u00052\u0006\u0010\b\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\nH\u0007R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lcom/android/tools/lint/detector/api/LintFix$ReplaceString$Companion;", "", "<init>", "()V", "INSERT_BEGINNING", "", "INSERT_END", "expandBackReferences", "replacement", "matcher", "Ljava/util/regex/Matcher;", "lint-api"})
        public static final class Companion {
            private Companion() {
            }

            @JvmStatic
            @NotNull
            public final String expandBackReferences(@NotNull String replacement, @NotNull Matcher matcher) {
                Intrinsics.checkNotNullParameter((Object)replacement, (String)"replacement");
                Intrinsics.checkNotNullParameter((Object)matcher, (String)"matcher");
                if (!StringsKt.contains$default((CharSequence)replacement, (CharSequence)"\\k<", (boolean)false, (int)2, null)) {
                    return replacement;
                }
                StringBuilder sb = new StringBuilder();
                int begin = 0;
                while (true) {
                    int end;
                    if ((end = StringsKt.indexOf$default((CharSequence)replacement, (String)"\\k<", (int)begin, (boolean)false, (int)4, null)) == -1) break;
                    int next = StringsKt.indexOf$default((CharSequence)replacement, (char)'>', (int)(end + 3), (boolean)false, (int)4, null);
                    if (next != -1 && Character.isDigit(replacement.charAt(end + 3))) {
                        String groupString;
                        sb.append(replacement, begin, end);
                        Intrinsics.checkNotNullExpressionValue((Object)replacement.substring(end + 3, next), (String)"substring(...)");
                        int group = Integer.parseInt(groupString);
                        if (group > matcher.groupCount()) {
                            throw new IllegalStateException(("Invalid backreference " + group + " in `" + replacement + "`: there are only " + matcher.groupCount() + " matches in this matcher, " + matcher).toString());
                        }
                        sb.append(matcher.group(group));
                        begin = next + 1;
                        continue;
                    }
                    sb.append(replacement, begin, end += 3);
                    begin = end;
                }
                String string = replacement.substring(begin);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
                sb.append(string);
                String string2 = sb.toString();
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toString(...)");
                return string2;
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010!\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010\u0011\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u001d\b\u0000\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0010\u0010\u0019\u001a\u00020\u00002\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003J\u0016\u0010\u0019\u001a\u00020\u00002\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0003J\u0010\u0010\u001a\u001a\u00020\u00002\b\u0010\u0004\u001a\u0004\u0018\u00010\u0003J\u0012\u0010\u001b\u001a\u00020\u00002\n\b\u0001\u0010\u0015\u001a\u0004\u0018\u00010\u0003J\u001a\u0010\u001b\u001a\u00020\u00002\n\b\u0001\u0010\u0015\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u001c\u001a\u00020\u0014J\u0010\u0010\u001d\u001a\u00020\u00002\b\u0010\b\u001a\u0004\u0018\u00010\u0003J\u000e\u0010\u0017\u001a\u00020\u00002\u0006\u0010\u0017\u001a\u00020\u0018J\u000e\u0010\u001e\u001a\u00020\u00002\u0006\u0010\u001e\u001a\u00020\u0014J\u0006\u0010\u001f\u001a\u00020\u0000J\u0006\u0010 \u001a\u00020\u0000J\u0006\u0010!\u001a\u00020\u0000J\u0012\u0010\"\u001a\u00020\u00002\n\b\u0001\u0010\t\u001a\u0004\u0018\u00010\u0003J\u0010\u0010#\u001a\u00020\u00002\b\u0010\u0007\u001a\u0004\u0018\u00010\u0003J\u001f\u0010\u000f\u001a\u00020\u00002\u0012\u0010\u000f\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00030$\"\u00020\u0003\u00a2\u0006\u0002\u0010%J\u0006\u0010\n\u001a\u00020\u0000J\u000e\u0010\n\u001a\u00020\u00002\u0006\u0010&\u001a\u00020\u000bJ\u000e\u0010\f\u001a\u00020\u00002\u0006\u0010\f\u001a\u00020\u000bJ\u000e\u0010\r\u001a\u00020\u00002\u0006\u0010\r\u001a\u00020\u000bJ\u000e\u0010\u000e\u001a\u00020\u00002\u0006\u0010\u000e\u001a\u00020\u000bJ\u0016\u0010'\u001a\u00020\u00002\u0006\u0010\r\u001a\u00020\u000b2\u0006\u0010\u000e\u001a\u00020\u000bJ\u0006\u0010'\u001a\u00020\u0000J\u0010\u0010\u0011\u001a\u00020\u00002\b\b\u0002\u0010(\u001a\u00020\u000bJ\u0010\u0010\u0012\u001a\u00020\u00002\b\b\u0002\u0010(\u001a\u00020\u000bJ\u0006\u0010)\u001a\u00020*R\u0014\u0010\u0002\u001a\u0004\u0018\u00010\u00038\u0002@\u0002X\u0083\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0004\u001a\u0004\u0018\u00010\u00038\u0002@\u0002X\u0083\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0007\u001a\u0004\u0018\u00010\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\b\u001a\u0004\u0018\u00010\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\t\u001a\u0004\u0018\u00010\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u000f\u001a\n\u0012\u0004\u0012\u00020\u0003\u0018\u00010\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0015\u001a\u0004\u0018\u00010\u00038\u0002@\u0002X\u0083\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0014X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0017\u001a\u0004\u0018\u00010\u0018X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006+"}, d2={"Lcom/android/tools/lint/detector/api/LintFix$ReplaceStringBuilder;", "", "displayName", "", "familyName", "<init>", "(Ljava/lang/String;Ljava/lang/String;)V", "newText", "oldText", "selectPattern", "shortenNames", "", "reformat", "robot", "independent", "imports", "", "repeatedly", "optional", "sortPriority", "", "oldPattern", "patternFlags", "range", "Lcom/android/tools/lint/detector/api/Location;", "name", "sharedName", "pattern", "flags", "text", "priority", "all", "beginning", "end", "select", "with", "", "([Ljava/lang/String;)Lcom/android/tools/lint/detector/api/LintFix$ReplaceStringBuilder;", "shorten", "autoFix", "value", "build", "Lcom/android/tools/lint/detector/api/LintFix;", "lint-api"})
    @SourceDebugExtension(value={"SMAP\nLintFix.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LintFix.kt\ncom/android/tools/lint/detector/api/LintFix$ReplaceStringBuilder\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,2197:1\n1#2:2198\n*E\n"})
    public static final class ReplaceStringBuilder {
        @Nls
        @Nullable
        private String displayName;
        @Nls
        @Nullable
        private String familyName;
        @Nullable
        private String newText;
        @Nullable
        private String oldText;
        @Nullable
        private String selectPattern;
        private boolean shortenNames;
        private boolean reformat;
        private boolean robot;
        private boolean independent;
        @Nullable
        private List<String> imports;
        private boolean repeatedly;
        private boolean optional;
        private int sortPriority;
        @RegExp
        @Nullable
        private String oldPattern;
        private int patternFlags;
        @Nullable
        private Location range;

        public ReplaceStringBuilder(@Nullable String displayName, @Nullable String familyName) {
            this.displayName = displayName;
            this.familyName = familyName;
        }

        @NotNull
        public final ReplaceStringBuilder name(@Nullable String displayName) {
            this.displayName = displayName;
            return this;
        }

        @NotNull
        public final ReplaceStringBuilder name(@NotNull String displayName, @NotNull String familyName) {
            Intrinsics.checkNotNullParameter((Object)displayName, (String)"displayName");
            Intrinsics.checkNotNullParameter((Object)familyName, (String)"familyName");
            this.displayName = displayName;
            this.familyName = familyName;
            return this;
        }

        @NotNull
        public final ReplaceStringBuilder sharedName(@Nullable String familyName) {
            this.familyName = familyName;
            return this;
        }

        @NotNull
        public final ReplaceStringBuilder pattern(@RegExp @Nullable String oldPattern) {
            return this.pattern(oldPattern, 0);
        }

        @NotNull
        public final ReplaceStringBuilder pattern(@RegExp @Nullable String oldPattern, int flags) {
            boolean bl;
            if (oldPattern == null) {
                this.oldPattern = null;
                return this;
            }
            boolean bl2 = bl = this.oldText == null;
            if (_Assertions.ENABLED && !bl) {
                String string = "Assertion failed";
                throw new AssertionError((Object)string);
            }
            boolean bl3 = bl = this.oldPattern == null;
            if (_Assertions.ENABLED && !bl) {
                String string = "Assertion failed";
                throw new AssertionError((Object)string);
            }
            this.oldPattern = StringsKt.indexOf$default((CharSequence)oldPattern, (char)'(', (int)0, (boolean)false, (int)6, null) == -1 ? "(" + oldPattern + ")" : oldPattern;
            this.patternFlags = flags;
            return this;
        }

        @NotNull
        public final ReplaceStringBuilder text(@Nullable String oldText) {
            boolean bl;
            if (oldText == null) {
                this.oldText = null;
                return this;
            }
            boolean bl2 = bl = this.oldText == null;
            if (_Assertions.ENABLED && !bl) {
                boolean bl3 = false;
                String string = "Should not call text, beginning or end more than once";
                throw new AssertionError((Object)string);
            }
            boolean bl4 = bl = this.oldPattern == null;
            if (_Assertions.ENABLED && !bl) {
                String string = "Assertion failed";
                throw new AssertionError((Object)string);
            }
            this.oldText = oldText;
            return this;
        }

        @NotNull
        public final ReplaceStringBuilder range(@NotNull Location range) {
            Intrinsics.checkNotNullParameter((Object)range, (String)"range");
            this.range = Companion.extractOffsets(range);
            return this;
        }

        @NotNull
        public final ReplaceStringBuilder priority(int priority) {
            this.sortPriority = priority;
            return this;
        }

        @NotNull
        public final ReplaceStringBuilder all() {
            return this;
        }

        @NotNull
        public final ReplaceStringBuilder beginning() {
            this.oldText = "_lint_insert_begin_";
            return this;
        }

        @NotNull
        public final ReplaceStringBuilder end() {
            this.oldText = "_lint_insert_end_";
            return this;
        }

        @NotNull
        public final ReplaceStringBuilder select(@RegExp @Nullable String selectPattern) {
            this.selectPattern = selectPattern;
            return this;
        }

        @NotNull
        public final ReplaceStringBuilder with(@Nullable String newText) {
            boolean bl;
            boolean bl2 = bl = this.newText == null;
            if (_Assertions.ENABLED && !bl) {
                String string = "Assertion failed";
                throw new AssertionError((Object)string);
            }
            this.newText = newText;
            return this;
        }

        @NotNull
        public final ReplaceStringBuilder imports(String ... imports) {
            Intrinsics.checkNotNullParameter((Object)imports, (String)"imports");
            List list = this.imports;
            if (list == null) {
                List list2;
                List it = list2 = (List)new ArrayList();
                boolean bl = false;
                this.imports = it;
                list = list2;
            }
            List existing = list;
            CollectionsKt.addAll((Collection)existing, (Object[])imports);
            return this;
        }

        @NotNull
        public final ReplaceStringBuilder shortenNames() {
            this.shortenNames = true;
            return this;
        }

        @NotNull
        public final ReplaceStringBuilder shortenNames(boolean shorten) {
            this.shortenNames = shorten;
            return this;
        }

        @NotNull
        public final ReplaceStringBuilder reformat(boolean reformat) {
            this.reformat = reformat;
            return this;
        }

        @NotNull
        public final ReplaceStringBuilder robot(boolean robot) {
            this.robot = robot;
            return this;
        }

        @NotNull
        public final ReplaceStringBuilder independent(boolean independent) {
            this.independent = independent;
            return this;
        }

        @NotNull
        public final ReplaceStringBuilder autoFix(boolean robot, boolean independent) {
            this.robot(robot);
            this.independent(independent);
            return this;
        }

        @NotNull
        public final ReplaceStringBuilder autoFix() {
            this.autoFix(true, true);
            return this;
        }

        @NotNull
        public final ReplaceStringBuilder repeatedly(boolean value) {
            this.repeatedly = value;
            return this;
        }

        public static /* synthetic */ ReplaceStringBuilder repeatedly$default(ReplaceStringBuilder replaceStringBuilder, boolean bl, int n, Object object) {
            if ((n & 1) != 0) {
                bl = true;
            }
            return replaceStringBuilder.repeatedly(bl);
        }

        @NotNull
        public final ReplaceStringBuilder optional(boolean value) {
            this.optional = value;
            return this;
        }

        public static /* synthetic */ ReplaceStringBuilder optional$default(ReplaceStringBuilder replaceStringBuilder, boolean bl, int n, Object object) {
            if ((n & 1) != 0) {
                bl = true;
            }
            return replaceStringBuilder.optional(bl);
        }

        @NotNull
        public final LintFix build() {
            List list;
            String string = this.newText;
            if (string == null) {
                string = "";
            }
            if ((list = this.imports) == null) {
                list = CollectionsKt.emptyList();
            }
            return new ReplaceString(this.displayName, this.familyName, this.oldText, this.oldPattern, this.patternFlags, this.selectPattern, string, this.shortenNames, this.reformat, list, this.range, this.repeatedly, this.optional, this.robot, this.independent, this.sortPriority);
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\r\u0018\u00002\u00020\u0001Be\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0003\u0012\b\u0010\u0007\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\b\u001a\u0004\u0018\u00010\t\u0012\b\u0010\n\u001a\u0004\u0018\u00010\u000b\u0012\b\u0010\f\u001a\u0004\u0018\u00010\u000b\u0012\u0006\u0010\r\u001a\u00020\u000e\u0012\u0006\u0010\u000f\u001a\u00020\u000e\u00a2\u0006\u0004\b\u0010\u0010\u0011J\b\u0010\u001a\u001a\u00020\u0003H\u0016R\u0013\u0010\u0005\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0011\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0013R\u0013\u0010\u0007\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0013R\u0015\u0010\n\u001a\u0004\u0018\u00010\u000b\u00a2\u0006\n\n\u0002\u0010\u0018\u001a\u0004\b\u0016\u0010\u0017R\u0015\u0010\f\u001a\u0004\u0018\u00010\u000b\u00a2\u0006\n\n\u0002\u0010\u0018\u001a\u0004\b\u0019\u0010\u0017\u00a8\u0006\u001b"}, d2={"Lcom/android/tools/lint/detector/api/LintFix$SetAttribute;", "Lcom/android/tools/lint/detector/api/LintFix;", "displayName", "", "familyName", "namespace", "attribute", "value", "range", "Lcom/android/tools/lint/detector/api/Location;", "point", "", "mark", "robot", "", "independent", "<init>", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Lcom/android/tools/lint/detector/api/Location;Ljava/lang/Integer;Ljava/lang/Integer;ZZ)V", "getNamespace", "()Ljava/lang/String;", "getAttribute", "getValue", "getPoint", "()Ljava/lang/Integer;", "Ljava/lang/Integer;", "getMark", "getDisplayName", "lint-api"})
    public static final class SetAttribute
    extends LintFix {
        @Nullable
        private final String namespace;
        @NotNull
        private final String attribute;
        @Nullable
        private final String value;
        @Nullable
        private final Integer point;
        @Nullable
        private final Integer mark;

        public SetAttribute(@Nullable String displayName, @Nullable String familyName, @Nullable String namespace, @NotNull String attribute, @Nullable String value, @Nullable Location range, @Nullable Integer point, @Nullable Integer mark, boolean robot, boolean independent) {
            Intrinsics.checkNotNullParameter((Object)attribute, (String)"attribute");
            super(displayName, familyName, range);
            this.namespace = namespace;
            this.attribute = attribute;
            this.value = value;
            this.point = point;
            this.mark = mark;
            this.robot = robot;
            this.independent = independent;
        }

        @Nullable
        public final String getNamespace() {
            return this.namespace;
        }

        @NotNull
        public final String getAttribute() {
            return this.attribute;
        }

        @Nullable
        public final String getValue() {
            return this.value;
        }

        @Nullable
        public final Integer getPoint() {
            return this.point;
        }

        @Nullable
        public final Integer getMark() {
            return this.mark;
        }

        @Override
        @NotNull
        public String getDisplayName() {
            Object object = super.getDisplayName();
            if (object == null) {
                object = this.value != null ? (((CharSequence)this.value).length() == 0 || this.point != null && this.point > 0 ? "Set " + this.attribute : "Set " + this.attribute + "=\"" + this.value + "\"") : "Delete " + this.attribute;
            }
            return object;
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0011\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u001d\b\u0000\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0010\u0010\u0013\u001a\u00020\u00002\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003J\u0016\u0010\u0013\u001a\u00020\u00002\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0003J\u0010\u0010\u0014\u001a\u00020\u00002\b\u0010\u0004\u001a\u0004\u0018\u00010\u0003J\u0006\u0010\u0015\u001a\u00020\u0000J\u0010\u0010\b\u001a\u00020\u00002\b\u0010\b\u001a\u0004\u0018\u00010\u0003J\u0010\u0010\t\u001a\u00020\u00002\b\u0010\t\u001a\u0004\u0018\u00010\u0003J\u000e\u0010\u0007\u001a\u00020\u00002\u0006\u0010\u0007\u001a\u00020\u0003J\u000e\u0010\u0016\u001a\u00020\u00002\u0006\u0010\u0007\u001a\u00020\u0003J\u0006\u0010\u0017\u001a\u00020\u0000J2\u0010\u0018\u001a\u00020\u00002\b\u0010\b\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u0007\u001a\u00020\u00032\n\b\u0002\u0010\u0019\u001a\u0004\u0018\u00010\u00032\n\b\u0002\u0010\u001a\u001a\u0004\u0018\u00010\u0003H\u0007J\u0010\u0010\u0011\u001a\u00020\u00002\b\u0010\u0011\u001a\u0004\u0018\u00010\u0012J\u0016\u0010\u001b\u001a\u00020\u00002\u0006\u0010\u001c\u001a\u00020\u000b2\u0006\u0010\u001d\u001a\u00020\u000bJ\u000e\u0010\u001e\u001a\u00020\u00002\u0006\u0010\u001f\u001a\u00020\u000bJ\u0006\u0010 \u001a\u00020\u0000J\u0006\u0010!\u001a\u00020\u0000J\u000e\u0010\u000e\u001a\u00020\u00002\u0006\u0010\u000e\u001a\u00020\u000fJ\u000e\u0010\u0010\u001a\u00020\u00002\u0006\u0010\u0010\u001a\u00020\u000fJ\u0016\u0010\"\u001a\u00020\u00002\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000fJ\u0006\u0010\"\u001a\u00020\u0000J\u0006\u0010#\u001a\u00020$R\u0014\u0010\u0002\u001a\u0004\u0018\u00010\u00038\u0002@\u0002X\u0083\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0004\u001a\u0004\u0018\u00010\u00038\u0002@\u0002X\u0083\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0007\u001a\u0004\u0018\u00010\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\b\u001a\u0004\u0018\u00010\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\t\u001a\u0004\u0018\u00010\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\n\u001a\u0004\u0018\u00010\u000bX\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\fR\u0012\u0010\r\u001a\u0004\u0018\u00010\u000bX\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\fR\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0011\u001a\u0004\u0018\u00010\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006%"}, d2={"Lcom/android/tools/lint/detector/api/LintFix$SetAttributeBuilder;", "", "displayName", "", "familyName", "<init>", "(Ljava/lang/String;Ljava/lang/String;)V", "attribute", "namespace", "value", "mark", "", "Ljava/lang/Integer;", "point", "robot", "", "independent", "range", "Lcom/android/tools/lint/detector/api/Location;", "name", "sharedName", "android", "remove", "selectAll", "todo", "prefix", "suffix", "select", "start", "end", "caret", "valueStartDelta", "caretBegin", "caretEnd", "autoFix", "build", "Lcom/android/tools/lint/detector/api/LintFix;", "lint-api"})
    @SourceDebugExtension(value={"SMAP\nLintFix.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LintFix.kt\ncom/android/tools/lint/detector/api/LintFix$SetAttributeBuilder\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,2197:1\n1#2:2198\n*E\n"})
    public static final class SetAttributeBuilder {
        @Nls
        @Nullable
        private String displayName;
        @Nls
        @Nullable
        private String familyName;
        @Nullable
        private String attribute;
        @Nullable
        private String namespace;
        @Nullable
        private String value;
        @Nullable
        private Integer mark;
        @Nullable
        private Integer point;
        private boolean robot;
        private boolean independent;
        @Nullable
        private Location range;

        public SetAttributeBuilder(@Nullable String displayName, @Nullable String familyName) {
            this.displayName = displayName;
            this.familyName = familyName;
            this.value = "";
        }

        @NotNull
        public final SetAttributeBuilder name(@Nullable String displayName) {
            this.displayName = displayName;
            return this;
        }

        @NotNull
        public final SetAttributeBuilder name(@NotNull String displayName, @NotNull String familyName) {
            Intrinsics.checkNotNullParameter((Object)displayName, (String)"displayName");
            Intrinsics.checkNotNullParameter((Object)familyName, (String)"familyName");
            this.displayName = displayName;
            this.familyName = familyName;
            return this;
        }

        @NotNull
        public final SetAttributeBuilder sharedName(@Nullable String familyName) {
            this.familyName = familyName;
            return this;
        }

        @NotNull
        public final SetAttributeBuilder android() {
            boolean bl;
            boolean bl2 = bl = this.namespace == null;
            if (_Assertions.ENABLED && !bl) {
                String string = "Assertion failed";
                throw new AssertionError((Object)string);
            }
            this.namespace = "http://schemas.android.com/apk/res/android";
            return this;
        }

        @NotNull
        public final SetAttributeBuilder namespace(@Nullable String namespace) {
            boolean bl;
            boolean bl2 = bl = this.namespace == null;
            if (_Assertions.ENABLED && !bl) {
                String string = "Assertion failed";
                throw new AssertionError((Object)string);
            }
            this.namespace = namespace;
            return this;
        }

        @NotNull
        public final SetAttributeBuilder value(@Nullable String value) {
            this.value = value;
            if (value != null && ((CharSequence)value).length() == 0) {
                this.caret(0);
            }
            return this;
        }

        @NotNull
        public final SetAttributeBuilder attribute(@NotNull String attribute) {
            boolean bl;
            Intrinsics.checkNotNullParameter((Object)attribute, (String)"attribute");
            boolean bl2 = bl = StringsKt.indexOf$default((CharSequence)attribute, (char)':', (int)0, (boolean)false, (int)6, null) == -1 || StringsKt.startsWith$default((String)attribute, (String)"xmlns:", (boolean)false, (int)2, null);
            if (_Assertions.ENABLED && !bl) {
                boolean bl3 = false;
                String string = attribute;
                throw new AssertionError((Object)string);
            }
            boolean bl4 = bl = this.attribute == null;
            if (_Assertions.ENABLED && !bl) {
                String string = "Assertion failed";
                throw new AssertionError((Object)string);
            }
            this.attribute = attribute;
            return this;
        }

        @NotNull
        public final SetAttributeBuilder remove(@NotNull String attribute) {
            boolean bl;
            Intrinsics.checkNotNullParameter((Object)attribute, (String)"attribute");
            boolean bl2 = bl = this.attribute == null;
            if (_Assertions.ENABLED && !bl) {
                String string = "Assertion failed";
                throw new AssertionError((Object)string);
            }
            this.attribute = attribute;
            this.value = null;
            return this;
        }

        @NotNull
        public final SetAttributeBuilder selectAll() {
            String string = this.value;
            Intrinsics.checkNotNull((Object)string);
            this.point = XmlUtils.toXmlAttributeValue((String)string).length();
            this.mark = 0;
            return this;
        }

        @JvmOverloads
        @NotNull
        public final SetAttributeBuilder todo(@Nullable String namespace, @NotNull String attribute, @Nullable String prefix, @Nullable String suffix) {
            Intrinsics.checkNotNullParameter((Object)attribute, (String)"attribute");
            this.namespace(namespace);
            this.attribute(attribute);
            StringBuilder sb = new StringBuilder();
            if (prefix != null) {
                sb.append(prefix);
            }
            int start = sb.length();
            sb.append(LintFix.TODO);
            int end = sb.length();
            if (suffix != null) {
                sb.append(suffix);
            }
            this.value(sb.toString());
            this.select(start, end);
            return this;
        }

        public static /* synthetic */ SetAttributeBuilder todo$default(SetAttributeBuilder setAttributeBuilder, String string, String string2, String string3, String string4, int n, Object object) {
            if ((n & 4) != 0) {
                string3 = null;
            }
            if ((n & 8) != 0) {
                string4 = null;
            }
            return setAttributeBuilder.todo(string, string2, string3, string4);
        }

        @NotNull
        public final SetAttributeBuilder range(@Nullable Location range) {
            Location location2 = range;
            this.range = location2 != null ? Companion.extractOffsets(location2) : null;
            return this;
        }

        @NotNull
        public final SetAttributeBuilder select(int start, int end) {
            this.mark = Math.min(start, end);
            this.point = Math.max(start, end);
            return this;
        }

        @NotNull
        public final SetAttributeBuilder caret(int valueStartDelta) {
            this.mark = this.point = Integer.valueOf(valueStartDelta);
            return this;
        }

        @NotNull
        public final SetAttributeBuilder caretBegin() {
            return this.caret(0);
        }

        @NotNull
        public final SetAttributeBuilder caretEnd() {
            boolean bl;
            boolean bl2 = bl = this.value != null;
            if (_Assertions.ENABLED && !bl) {
                String string = "Assertion failed";
                throw new AssertionError((Object)string);
            }
            String string = this.value;
            Intrinsics.checkNotNull((Object)string);
            return this.caret(string.length());
        }

        @NotNull
        public final SetAttributeBuilder robot(boolean robot) {
            this.robot = robot;
            return this;
        }

        @NotNull
        public final SetAttributeBuilder independent(boolean independent) {
            this.independent = independent;
            return this;
        }

        @NotNull
        public final SetAttributeBuilder autoFix(boolean robot, boolean independent) {
            this.robot(robot);
            this.independent(independent);
            return this;
        }

        @NotNull
        public final SetAttributeBuilder autoFix() {
            this.autoFix(true, true);
            return this;
        }

        @NotNull
        public final LintFix build() {
            String string = this.attribute;
            Intrinsics.checkNotNull((Object)string);
            return new SetAttribute(this.displayName, this.familyName, this.namespace, string, this.value, this.range, this.point, this.mark, this.robot, this.independent);
        }

        @JvmOverloads
        @NotNull
        public final SetAttributeBuilder todo(@Nullable String namespace, @NotNull String attribute, @Nullable String prefix) {
            Intrinsics.checkNotNullParameter((Object)attribute, (String)"attribute");
            return SetAttributeBuilder.todo$default(this, namespace, attribute, prefix, null, 8, null);
        }

        @JvmOverloads
        @NotNull
        public final SetAttributeBuilder todo(@Nullable String namespace, @NotNull String attribute) {
            Intrinsics.checkNotNullParameter((Object)attribute, (String)"attribute");
            return SetAttributeBuilder.todo$default(this, namespace, attribute, null, null, 12, null);
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0007\u0018\u00002\u00020\u0001B3\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u0012\u0010\b\u0002\u0010\u0006\u001a\n\u0012\u0004\u0012\u00020\b\u0018\u00010\u0007\u00a2\u0006\u0004\b\t\u0010\nR\u0011\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0019\u0010\u0006\u001a\n\u0012\u0004\u0012\u00020\b\u0018\u00010\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u000f"}, d2={"Lcom/android/tools/lint/detector/api/LintFix$ShowUrl;", "Lcom/android/tools/lint/detector/api/LintFix;", "displayName", "", "familyName", "url", "onUrlOpen", "Lkotlin/Function0;", "", "<init>", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Lkotlin/jvm/functions/Function0;)V", "getUrl", "()Ljava/lang/String;", "getOnUrlOpen", "()Lkotlin/jvm/functions/Function0;", "lint-api"})
    public static final class ShowUrl
    extends LintFix {
        @NotNull
        private final String url;
        @Nullable
        private final Function0<Unit> onUrlOpen;

        public ShowUrl(@NotNull String displayName, @Nullable String familyName, @NotNull String url, @Nullable Function0<Unit> onUrlOpen) {
            Intrinsics.checkNotNullParameter((Object)displayName, (String)"displayName");
            Intrinsics.checkNotNullParameter((Object)url, (String)"url");
            super(displayName, familyName, null, 4, null);
            this.url = url;
            this.onUrlOpen = onUrlOpen;
        }

        public /* synthetic */ ShowUrl(String string, String string2, String string3, Function0 function0, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 8) != 0) {
                function0 = null;
            }
            this(string, string2, string3, (Function0<Unit>)function0);
        }

        @NotNull
        public final String getUrl() {
            return this.url;
        }

        @Nullable
        public final Function0<Unit> getOnUrlOpen() {
            return this.onUrlOpen;
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B'\b\u0000\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0010\u0010\u0005\u001a\u00020\u00002\b\b\u0001\u0010\u0005\u001a\u00020\u0003J\u0006\u0010\b\u001a\u00020\tR\u0014\u0010\u0002\u001a\u0004\u0018\u00010\u00038\u0002@\u0002X\u0083\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0004\u001a\u0004\u0018\u00010\u00038\u0002@\u0002X\u0083\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0005\u001a\u0004\u0018\u00010\u00038\u0002@\u0002X\u0083\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lcom/android/tools/lint/detector/api/LintFix$UrlBuilder;", "", "displayName", "", "familyName", "url", "<init>", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;)V", "build", "Lcom/android/tools/lint/detector/api/LintFix;", "lint-api"})
    public static final class UrlBuilder {
        @Nls
        @Nullable
        private String displayName;
        @Nls
        @Nullable
        private String familyName;
        @NonNls
        @Nullable
        private String url;

        public UrlBuilder(@Nullable String displayName, @Nullable String familyName, @Nullable String url) {
            this.displayName = displayName;
            this.familyName = familyName;
            this.url = url;
        }

        @NotNull
        public final UrlBuilder url(@NonNls @NotNull String url) {
            Intrinsics.checkNotNullParameter((Object)url, (String)"url");
            this.url = url;
            return this;
        }

        @NotNull
        public final LintFix build() {
            Object object = this.displayName;
            if (object == null) {
                object = "Show " + this.url;
            }
            String string = this.url;
            Intrinsics.checkNotNull((Object)string);
            return new ShowUrl((String)object, this.familyName, string, null, 8, null);
        }
    }
}

