/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.client.api;

import com.android.tools.lint.client.api.Configuration;
import com.android.tools.lint.client.api.LintClient;
import com.android.tools.lint.client.api.LintDriver;
import com.android.tools.lint.client.api.Vendor;
import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.Detector;
import com.android.tools.lint.detector.api.Implementation;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.Lint;
import com.android.tools.lint.detector.api.Platform;
import com.android.tools.lint.detector.api.PlatformKt;
import com.android.tools.lint.detector.api.Project;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import com.android.tools.lint.detector.api.VersionChecks;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000~\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0010!\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010$\n\u0002\b\u0006\b&\u0018\u0000 =2\u00020\u0001:\u0001=B\t\b\u0004\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\u001b\u001a\u00020\t2\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u001e0\u001dH\u0014J\u001c\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u00120\u00112\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u001e0\u001dH\u0014Jc\u0010 \u001a\b\u0012\u0004\u0012\u00020!0\u00112\u0006\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020%2\u0006\u0010&\u001a\u00020'2\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u001e0\u001d2\f\u0010(\u001a\b\u0012\u0004\u0012\u00020)0\u001d2\u001a\u0010*\u001a\u0016\u0012\u0004\u0012\u00020\u001e\u0012\n\u0012\b\u0012\u0004\u0012\u00020!0,\u0018\u00010+H\u0000\u00a2\u0006\u0002\b-J\u000e\u0010.\u001a\u00020\u00192\u0006\u0010/\u001a\u00020\u0016J\u000e\u00100\u001a\u00020\u00192\u0006\u00101\u001a\u00020\u0016J\f\u00102\u001a\b\u0012\u0004\u0012\u0002030\u0011J\u000e\u00104\u001a\b\u0012\u0004\u0012\u0002030\u0011H\u0002J\u0010\u00105\u001a\u0004\u0018\u00010\u00122\u0006\u0010/\u001a\u00020\u0016J\u0014\u00106\u001a\b\u0012\u0004\u0012\u00020\u00160\u00112\u0006\u0010/\u001a\u00020\u0016J\u0014\u00107\u001a\u000e\u0012\u0004\u0012\u00020\u0016\u0012\u0004\u0012\u00020\u001208H\u0002J\b\u0010<\u001a\u00020\u0019H\u0014R\u0016\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0014\u0010\b\u001a\u00020\tX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0014\u0010\f\u001a\u00020\t8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000bR\u0014\u0010\u000e\u001a\u00020\t8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u000bR\u0018\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u0011X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0014R\u001a\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00160\u0011X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0014R\u0014\u0010\u0018\u001a\u00020\u0019X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u001aR\u0016\u00109\u001a\n\u0012\u0004\u0012\u000203\u0018\u00010\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001c\u0010:\u001a\u0010\u0012\u0004\u0012\u00020\u0016\u0012\u0004\u0012\u00020\u0012\u0018\u000108X\u0082\u000e\u00a2\u0006\u0002\n\u0000R&\u0010;\u001a\u001a\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u001e0\u001d\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00120\u00110+X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006>"}, d2={"Lcom/android/tools/lint/client/api/IssueRegistry;", "", "<init>", "()V", "vendor", "Lcom/android/tools/lint/client/api/Vendor;", "getVendor", "()Lcom/android/tools/lint/client/api/Vendor;", "api", "", "getApi", "()I", "minApi", "getMinApi", "maxApi", "getMaxApi", "issues", "", "Lcom/android/tools/lint/detector/api/Issue;", "getIssues", "()Ljava/util/List;", "deletedIssues", "", "getDeletedIssues", "isUpToDate", "", "()Z", "getIssueCapacity", "scope", "Ljava/util/EnumSet;", "Lcom/android/tools/lint/detector/api/Scope;", "getIssuesForScope", "createDetectors", "Lcom/android/tools/lint/detector/api/Detector;", "driver", "Lcom/android/tools/lint/client/api/LintDriver;", "project", "Lcom/android/tools/lint/detector/api/Project;", "configuration", "Lcom/android/tools/lint/client/api/Configuration;", "platforms", "Lcom/android/tools/lint/detector/api/Platform;", "scopeToDetectors", "", "", "createDetectors$lint_api", "isIssueId", "id", "isCategoryName", "name", "getCategories", "Lcom/android/tools/lint/detector/api/Category;", "createCategoryList", "getIssue", "getIdSpellingSuggestions", "createIdToIssueMap", "", "categories", "idToIssue", "scopeIssues", "cacheable", "Companion", "lint-api"})
@SourceDebugExtension(value={"SMAP\nIssueRegistry.kt\nKotlin\n*S Kotlin\n*F\n+ 1 IssueRegistry.kt\ncom/android/tools/lint/client/api/IssueRegistry\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,643:1\n1#2:644\n1869#3,2:645\n*S KotlinDebug\n*F\n+ 1 IssueRegistry.kt\ncom/android/tools/lint/client/api/IssueRegistry\n*L\n355#1:645,2\n*E\n"})
public abstract class IssueRegistry {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private final Vendor vendor;
    private final int api;
    @NotNull
    private final List<String> deletedIssues;
    private final boolean isUpToDate;
    @Nullable
    private volatile List<Category> categories;
    @Nullable
    private volatile Map<String, Issue> idToIssue;
    @NotNull
    private Map<EnumSet<Scope>, List<Issue>> scopeIssues;
    @Nullable
    private static volatile List<Category> cachedCategories;
    @Nullable
    private static volatile Map<String, Issue> cachedIdToIssue;
    @NotNull
    private static Map<EnumSet<Scope>, List<Issue>> cachedScopeIssues;
    @NotNull
    private static final Implementation EMPTY_IMPLEMENTATION;
    @NotNull
    private static Set<String> deletedIds;
    @NotNull
    private static Map<String, String> renamedIds;
    @JvmField
    @NotNull
    public static final Issue PARSER_ERROR;
    @JvmField
    @NotNull
    public static final Issue LINT_ERROR;
    @JvmField
    @NotNull
    public static final Issue LINT_WARNING;
    @JvmField
    @NotNull
    public static final Issue UNKNOWN_ISSUE_ID;
    @JvmField
    @NotNull
    public static final Issue CANNOT_ENABLE_HIDDEN;
    @JvmField
    @NotNull
    public static final Issue BASELINE_USED;
    @JvmField
    @NotNull
    public static final Issue BASELINE_FIXED;
    @JvmField
    @NotNull
    public static final Issue OBSOLETE_LINT_CHECK;
    @NotNull
    private static final Vendor AOSP_VENDOR;

    protected IssueRegistry() {
        LintClient.Companion.ensureClientNameInitialized();
        this.api = -1;
        this.deletedIssues = CollectionsKt.emptyList();
        this.isUpToDate = true;
        if (this.cacheable()) {
            this.scopeIssues = cachedScopeIssues;
            this.idToIssue = cachedIdToIssue;
            this.categories = cachedCategories;
        } else {
            HashMap hashMap = Maps.newHashMap();
            Intrinsics.checkNotNullExpressionValue((Object)hashMap, (String)"newHashMap(...)");
            this.scopeIssues = hashMap;
            this.idToIssue = null;
            this.categories = null;
        }
    }

    @Nullable
    public Vendor getVendor() {
        return this.vendor;
    }

    public int getApi() {
        return this.api;
    }

    public int getMinApi() {
        return this.getApi();
    }

    public int getMaxApi() {
        return Integer.MAX_VALUE;
    }

    @NotNull
    public abstract List<Issue> getIssues();

    @NotNull
    public List<String> getDeletedIssues() {
        return this.deletedIssues;
    }

    public boolean isUpToDate() {
        return this.isUpToDate;
    }

    protected int getIssueCapacity(@NotNull EnumSet<Scope> scope) {
        Intrinsics.checkNotNullParameter(scope, (String)"scope");
        return 20;
    }

    @NotNull
    protected List<Issue> getIssuesForScope(@NotNull EnumSet<Scope> scope) {
        Intrinsics.checkNotNullParameter(scope, (String)"scope");
        List list = this.scopeIssues.get(scope);
        if (list == null) {
            List<Issue> issues2 = this.getIssues();
            if (Intrinsics.areEqual(scope, Scope.ALL)) {
                list = issues2;
            } else {
                list = new ArrayList(this.getIssueCapacity(scope));
                for (Issue issue : issues2) {
                    if (!issue.getImplementation().isAdequate(scope)) continue;
                    ((ArrayList)list).add(issue);
                }
            }
            this.scopeIssues.put(scope, list);
        }
        return list;
    }

    @NotNull
    public final List<Detector> createDetectors$lint_api(@NotNull LintDriver driver, @NotNull Project project, @NotNull Configuration configuration, @NotNull EnumSet<Scope> scope, @NotNull EnumSet<Platform> platforms, @Nullable Map<Scope, List<Detector>> scopeToDetectors) {
        Intrinsics.checkNotNullParameter((Object)driver, (String)"driver");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)configuration, (String)"configuration");
        Intrinsics.checkNotNullParameter(scope, (String)"scope");
        Intrinsics.checkNotNullParameter(platforms, (String)"platforms");
        List<Issue> issues2 = this.getIssuesForScope(scope);
        if (issues2.isEmpty()) {
            return CollectionsKt.emptyList();
        }
        HashSet<Class<? extends Detector>> detectorClasses = new HashSet<Class<? extends Detector>>();
        HashMap detectorToScope = new HashMap();
        for (Issue issue : issues2) {
            Class<? extends Detector> detectorClass;
            EnumSet<Scope> enumSet;
            if (!PlatformKt.isApplicableTo(platforms, issue)) continue;
            Implementation implementation = issue.getImplementation();
            Intrinsics.checkNotNullExpressionValue(implementation.getDetectorClass(), (String)"getDetectorClass(...)");
            Object it = implementation.getScope();
            boolean bl = false;
            if (!((AbstractCollection)it).contains((Object)Scope.TEST_SOURCES) && configuration.isIncludeInTests(issue)) {
                EnumSet<Scope> enumSet2;
                EnumSet<Scope> $this$createDetectors_u24lambda_u241_u24lambda_u240 = enumSet2 = EnumSet.copyOf(it);
                boolean bl2 = false;
                $this$createDetectors_u24lambda_u241_u24lambda_u240.add(Scope.TEST_SOURCES);
                enumSet = enumSet2;
            } else {
                enumSet = it;
            }
            EnumSet<Scope> issueScope = enumSet;
            if (!detectorClasses.contains(detectorClass)) {
                if (!configuration.isEnabled(issue)) continue;
                boolean bl3 = implementation.isAdequate(scope);
                if (_Assertions.ENABLED && !bl3) {
                    it = "Assertion failed";
                    throw new AssertionError(it);
                }
                detectorClasses.add(detectorClass);
            }
            if (scopeToDetectors == null) continue;
            EnumSet s = (EnumSet)detectorToScope.get(detectorClass);
            if (s == null) {
                ((Map)detectorToScope).put(detectorClass, issueScope);
                continue;
            }
            Intrinsics.checkNotNull(issueScope);
            if (s.containsAll((Collection)issueScope)) continue;
            EnumSet union = EnumSet.copyOf(s);
            union.addAll(issueScope);
            ((Map)detectorToScope).put(detectorClass, union);
        }
        ArrayList<Detector> detectors = new ArrayList<Detector>(detectorClasses.size());
        Iterator iterator = detectorClasses.iterator();
        Intrinsics.checkNotNullExpressionValue(iterator, (String)"iterator(...)");
        Iterator iterator2 = iterator;
        while (iterator2.hasNext()) {
            Object e = iterator2.next();
            Intrinsics.checkNotNullExpressionValue(e, (String)"next(...)");
            Class clz = (Class)e;
            try {
                Iterator iterator3;
                EnumSet union;
                Detector detector = (Detector)clz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                detectors.add(detector);
                if (scopeToDetectors == null || (EnumSet)detectorToScope.get(clz) == null) continue;
                Intrinsics.checkNotNullExpressionValue(union.iterator(), (String)"iterator(...)");
                while (iterator3.hasNext()) {
                    Scope s = (Scope)((Object)iterator3.next());
                    List list = scopeToDetectors.get((Object)s);
                    if (list == null) {
                        list = new ArrayList();
                        scopeToDetectors.put(s, list);
                    }
                    Intrinsics.checkNotNull((Object)detector);
                    list.add(detector);
                }
            }
            catch (Throwable t) {
                LintDriver.Companion.handleDetectorError(driver, t, "Can't initialize detector " + clz.getName() + ".\n", null, project);
            }
        }
        return detectors;
    }

    public final boolean isIssueId(@NotNull String id) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        return this.getIssue(id) != null;
    }

    public final boolean isCategoryName(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        return Category.Companion.getCategory(name) != null;
    }

    @NotNull
    public final List<Category> getCategories() {
        List<Category> categories = this.categories;
        if (categories == null) {
            this.categories = categories = Collections.unmodifiableList(this.createCategoryList());
            if (this.cacheable()) {
                cachedCategories = categories;
            }
        }
        List<Category> list = categories;
        Intrinsics.checkNotNull(list);
        return list;
    }

    private final List<Category> createCategoryList() {
        HashSet categorySet = Sets.newHashSetWithExpectedSize((int)20);
        for (Issue issue : this.getIssues()) {
            Category element = issue.getCategory();
            categorySet.add(element);
            for (Category parent = element.getParent(); parent != null; parent = parent.getParent()) {
                categorySet.add(parent);
            }
        }
        ArrayList sorted = new ArrayList(categorySet);
        CollectionsKt.sort((List)sorted);
        return sorted;
    }

    @Nullable
    public final Issue getIssue(@NotNull String id) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        Map<String, Issue> map = this.idToIssue;
        if (map == null) {
            this.idToIssue = map = this.createIdToIssueMap();
            if (this.cacheable()) {
                cachedIdToIssue = map;
            }
        }
        return map.get(id);
    }

    @NotNull
    public final List<String> getIdSpellingSuggestions(@NotNull String id) {
        String matchWith;
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        int maxDistance = id.length() >= 4 ? 2 : 1;
        Set matches = new LinkedHashSet();
        for (Issue issue : this.getIssues()) {
            matchWith = issue.getId();
            int distance = Lint.editDistance(id, matchWith, maxDistance);
            if (distance <= maxDistance) {
                matches.add(matchWith);
            }
            if (!StringsKt.equals((String)matchWith, (String)id, (boolean)true)) continue;
            matches.add(matchWith);
        }
        if (matches.isEmpty()) {
            for (Issue issue : this.getIssues()) {
                matchWith = issue.getId();
                if (!StringsKt.contains$default((CharSequence)matchWith, (CharSequence)id, (boolean)false, (int)2, null) && !StringsKt.contains$default((CharSequence)id, (CharSequence)matchWith, (boolean)false, (int)2, null)) continue;
                matches.add(matchWith);
            }
        }
        if (matches.isEmpty()) {
            return CollectionsKt.emptyList();
        }
        return SequencesKt.toList((Sequence)SequencesKt.sorted((Sequence)CollectionsKt.asSequence((Iterable)matches)));
    }

    private final Map<String, Issue> createIdToIssueMap() {
        List<Issue> issues2 = this.getIssues();
        HashMap map = Maps.newHashMapWithExpectedSize((int)(issues2.size() + 20));
        for (Issue issue : issues2) {
            Intrinsics.checkNotNull((Object)map);
            ((Map)map).put(issue.getId(), issue);
            Iterable $this$forEach$iv = issue.getAliases();
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                String alias = (String)element$iv;
                boolean bl = false;
                ((Map)map).put(alias, issue);
                renamedIds.put(alias, issue.getId());
            }
        }
        for (String id : this.getDeletedIssues()) {
            deletedIds.add(id);
        }
        Intrinsics.checkNotNull((Object)map);
        ((Map)map).put(PARSER_ERROR.getId(), PARSER_ERROR);
        ((Map)map).put(LINT_ERROR.getId(), LINT_ERROR);
        ((Map)map).put(LINT_WARNING.getId(), LINT_WARNING);
        ((Map)map).put(BASELINE_USED.getId(), BASELINE_USED);
        ((Map)map).put(BASELINE_FIXED.getId(), BASELINE_FIXED);
        ((Map)map).put(UNKNOWN_ISSUE_ID.getId(), UNKNOWN_ISSUE_ID);
        ((Map)map).put(CANNOT_ENABLE_HIDDEN.getId(), CANNOT_ENABLE_HIDDEN);
        ((Map)map).put(OBSOLETE_LINT_CHECK.getId(), OBSOLETE_LINT_CHECK);
        ((Map)map).put(VersionChecks.SDK_INT_VERSION_DATA.getId(), VersionChecks.SDK_INT_VERSION_DATA);
        return map;
    }

    protected boolean cacheable() {
        return false;
    }

    static {
        HashMap hashMap = Maps.newHashMap();
        Intrinsics.checkNotNullExpressionValue((Object)hashMap, (String)"newHashMap(...)");
        cachedScopeIssues = hashMap;
        EMPTY_IMPLEMENTATION = new Implementation(Detector.class, EnumSet.noneOf(Scope.class));
        deletedIds = new LinkedHashSet();
        renamedIds = new LinkedHashMap();
        PARSER_ERROR = Issue.Companion.create("ParserError", "Parser Errors", "\n                Lint will ignore any files that contain fatal parsing errors. These may \\\n                contain other errors, or contain code which affects issues in other files.", Category.LINT, 10, Severity.ERROR, EMPTY_IMPLEMENTATION);
        LINT_ERROR = Issue.Companion.create("LintError", "Lint Failure", "\n                This issue type represents a problem running lint itself. Examples include \\\n                failure to find bytecode for source files (which means certain detectors \\\n                could not be run), parsing errors in lint configuration files, etc.\n\n                These errors are not errors in your own code, but they are shown to make it \\\n                clear that some checks were not completed.\n                ", Category.LINT, 10, Severity.ERROR, EMPTY_IMPLEMENTATION);
        LINT_WARNING = Issue.Companion.create("LintWarning", "Lint Failure", "\n                This issue type represents a problem running lint itself. Examples include \\\n                unsupported tags in configuration files, etc.\n\n                These errors are not errors in your own code, but they are shown to make it \\\n                clear that some checks were not completed.\n                ", Category.LINT, 5, Severity.WARNING, EMPTY_IMPLEMENTATION);
        UNKNOWN_ISSUE_ID = Issue.Companion.create("UnknownIssueId", "Unknown Lint Issue Id", "\n                Lint will report this issue if it is configured with an issue id it does \\\n                not recognize in for example Gradle files or `lint.xml` configuration files.\n                ", Category.LINT, 1, Severity.WARNING, EMPTY_IMPLEMENTATION);
        CANNOT_ENABLE_HIDDEN = Issue.Companion.create("CannotEnableHidden", "Issue Already Disabled", "\n                Any issues that are specifically disabled in a library cannot be re-enabled \\\n                in a dependent project. To fix this you need to also enable the issue in \\\n                the library project.\n\n                (This also applies for issues that are off by default; they cannot just be \\\n                enabled in a dependent project; they must also be enabled in all the \\\n                libraries the project depends on.)\n                ", Category.LINT, 1, Severity.WARNING, EMPTY_IMPLEMENTATION);
        BASELINE_USED = Issue.Companion.create("LintBaseline", "Baseline Applied", "\n          Lint can be configured with a \"baseline\"; a set of current issues found \\\n          in a codebase, which future runs of lint will silently ignore. Only new \\\n          issues not found in the baseline are reported.\n\n          Note that while opening files in the IDE, baseline issues are not \\\n          filtered out; the purpose of baselines is to allow you to get started \\\n          using lint and break the build on all newly introduced errors, without \\\n          having to go back and fix the entire codebase up front. However, when \\\n          you open up existing files you still want to be aware of and fix issues \\\n          as you come across them.\n\n          This issue type is used to emit an informational-only warning if any \\\n          issues were filtered out due to baseline matching. That way, you don't \\\n          have a false sense of security if you forgot that you've checked in a \\\n          baseline file.\n          ", Category.LINT, 10, Severity.INFORMATIONAL, EMPTY_IMPLEMENTATION);
        BASELINE_FIXED = Issue.Companion.create("LintBaselineFixed", "Baselined Issues Fixed", "\n          If a lint baseline describes a problem which is no longer reported, \\\n          then the problem has either been fixed, or perhaps the issue type has \\\n          been disabled. In any case, the entry can be removed from the baseline \\\n          (such that if the issue is reintroduced at some point, lint will \\\n          complain rather than just silently starting to match the old baseline \\\n          entry again.)\n          ", Category.LINT, 10, Severity.INFORMATIONAL, EMPTY_IMPLEMENTATION);
        OBSOLETE_LINT_CHECK = Issue.Companion.create("ObsoleteLintCustomCheck", "Obsolete custom lint check", "\n                Lint can be extended with \"custom checks\": additional checks implemented \\\n                by developers and libraries to for example enforce specific API usages \\\n                required by a library or a company coding style guideline.\n\n                The Lint APIs are not yet stable, so these checks may either cause a \\\n                performance degradation, or stop working, or provide wrong results.\n\n                This warning flags custom lint checks that are found to be using obsolete \\\n                APIs and will need to be updated to run in the current lint environment.\n\n                It may also flag issues found to be using a **newer** version of the API, \\\n                meaning that you need to use a newer version of lint (or Android Studio \\\n                or Gradle plugin etc) to work with these checks.", Category.LINT, 10, Severity.WARNING, EMPTY_IMPLEMENTATION);
        AOSP_VENDOR = new Vendor("Android Open Source Project", null, "https://issuetracker.google.com/issues/new?component=192708", "https://groups.google.com/g/lint-dev", 2, null);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010#\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\tJ\u0010\u0010\u0017\u001a\u0004\u0018\u00010\t2\u0006\u0010\u0016\u001a\u00020\tJ\u0006\u0010$\u001a\u00020%R\u0016\u0010\u0004\u001a\n\u0012\u0004\u0012\u00020\u0006\u0018\u00010\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0007\u001a\u0010\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n\u0018\u00010\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R&\u0010\u000b\u001a\u001a\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000e0\r\u0012\n\u0012\b\u0012\u0004\u0012\u00020\n0\u00050\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\t0\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0013\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\t0\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0018\u001a\u00020\n8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0019\u001a\u00020\n8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u001a\u001a\u00020\n8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u001b\u001a\u00020\n8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u001c\u001a\u00020\n8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u001d\u001a\u00020\n8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u001e\u001a\u00020\n8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u001f\u001a\u00020\n8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010 \u001a\u00020!\u00a2\u0006\b\n\u0000\u001a\u0004\b\"\u0010#\u00a8\u0006&"}, d2={"Lcom/android/tools/lint/client/api/IssueRegistry$Companion;", "", "<init>", "()V", "cachedCategories", "", "Lcom/android/tools/lint/detector/api/Category;", "cachedIdToIssue", "", "", "Lcom/android/tools/lint/detector/api/Issue;", "cachedScopeIssues", "", "Ljava/util/EnumSet;", "Lcom/android/tools/lint/detector/api/Scope;", "EMPTY_IMPLEMENTATION", "Lcom/android/tools/lint/detector/api/Implementation;", "deletedIds", "", "renamedIds", "isDeletedIssueId", "", "id", "getNewId", "PARSER_ERROR", "LINT_ERROR", "LINT_WARNING", "UNKNOWN_ISSUE_ID", "CANNOT_ENABLE_HIDDEN", "BASELINE_USED", "BASELINE_FIXED", "OBSOLETE_LINT_CHECK", "AOSP_VENDOR", "Lcom/android/tools/lint/client/api/Vendor;", "getAOSP_VENDOR", "()Lcom/android/tools/lint/client/api/Vendor;", "reset", "", "lint-api"})
    public static final class Companion {
        private Companion() {
        }

        public final boolean isDeletedIssueId(@NotNull String id) {
            Intrinsics.checkNotNullParameter((Object)id, (String)"id");
            return deletedIds.contains(id);
        }

        @Nullable
        public final String getNewId(@NotNull String id) {
            Intrinsics.checkNotNullParameter((Object)id, (String)"id");
            return (String)renamedIds.get(id);
        }

        @NotNull
        public final Vendor getAOSP_VENDOR() {
            return AOSP_VENDOR;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final void reset() {
            Class<IssueRegistry> clazz = IssueRegistry.class;
            synchronized (clazz) {
                boolean bl = false;
                cachedIdToIssue = null;
                cachedCategories = null;
                HashMap hashMap = Maps.newHashMap();
                Intrinsics.checkNotNullExpressionValue((Object)hashMap, (String)"newHashMap(...)");
                cachedScopeIssues = hashMap;
                Unit unit = Unit.INSTANCE;
            }
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

