/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.helpers;

import java.io.Closeable;
import java.io.EOFException;
import java.io.InputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipInputStream;
import kotlin.Metadata;
import kotlin.io.ByteStreamsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000$\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\u001a\u0018\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0002\u001a\u0012\u0010\u0006\u001a\u00020\u0001*\u00020\u00072\u0006\u0010\b\u001a\u00020\t\u001a\u0012\u0010\u0006\u001a\u00020\u0001*\u00020\n2\u0006\u0010\b\u001a\u00020\t\u00a8\u0006\u000b"}, d2={"toByteArray", "", "stream", "Ljava/io/InputStream;", "expectedSize", "", "readAllBytes", "Ljava/util/zip/ZipFile;", "entry", "Ljava/util/zip/ZipEntry;", "Ljava/util/zip/ZipInputStream;", "lint-api"})
public final class ZipStreamsKt {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public static final byte[] readAllBytes(@NotNull ZipFile $this$readAllBytes, @NotNull ZipEntry entry) {
        Intrinsics.checkNotNullParameter((Object)$this$readAllBytes, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)entry, (String)"entry");
        Closeable closeable = $this$readAllBytes.getInputStream(entry);
        Throwable throwable = null;
        try {
            InputStream stream = (InputStream)closeable;
            boolean bl = false;
            if (entry.getSize() != -1L && entry.getSize() <= 65535L) {
                Intrinsics.checkNotNull((Object)stream);
                byte[] byArray = ZipStreamsKt.toByteArray(stream, (int)entry.getSize());
                return byArray;
            }
            Intrinsics.checkNotNull((Object)stream);
            byte[] byArray = ByteStreamsKt.readBytes((InputStream)stream);
            return byArray;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
    }

    @NotNull
    public static final byte[] readAllBytes(@NotNull ZipInputStream $this$readAllBytes, @NotNull ZipEntry entry) {
        Intrinsics.checkNotNullParameter((Object)$this$readAllBytes, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)entry, (String)"entry");
        return entry.getSize() != -1L && entry.getSize() <= 65535L ? ZipStreamsKt.toByteArray($this$readAllBytes, (int)entry.getSize()) : ByteStreamsKt.readBytes((InputStream)$this$readAllBytes);
    }

    private static final byte[] toByteArray(InputStream stream, int expectedSize) {
        byte[] bytes = new byte[expectedSize];
        int bytesRead = stream.readNBytes(bytes, 0, expectedSize);
        if (expectedSize != bytesRead) {
            throw new EOFException("Expected:" + expectedSize + ", read:" + bytesRead);
        }
        if (stream.read() != -1) {
            throw new EOFException("Expected:" + expectedSize + ", but stream have extra bytes");
        }
        return bytes;
    }
}

