/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.checks;

import com.android.tools.lint.client.api.UElementHandler;
import com.android.tools.lint.detector.api.Context;
import com.android.tools.lint.detector.api.Detector;
import com.android.tools.lint.detector.api.Implementation;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.JavaContext;
import com.android.tools.lint.detector.api.Lint;
import com.android.tools.lint.detector.api.Location;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.SourceCodeScanner;
import com.intellij.lang.Language;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import kotlin.KotlinNothingValueException;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.analysis.api.KaSession;
import org.jetbrains.kotlin.analysis.api.resolution.KaApplicableCallCandidateInfo;
import org.jetbrains.kotlin.analysis.api.resolution.KaCall;
import org.jetbrains.kotlin.analysis.api.resolution.KaCallCandidateInfo;
import org.jetbrains.kotlin.analysis.api.resolution.KaCallKt;
import org.jetbrains.kotlin.analysis.api.resolution.KaCallableMemberCall;
import org.jetbrains.kotlin.analysis.api.resolution.KaCompoundArrayAccessCall;
import org.jetbrains.kotlin.analysis.api.resolution.KaCompoundVariableAccessCall;
import org.jetbrains.kotlin.analysis.api.resolution.KaPartiallyAppliedSymbol;
import org.jetbrains.kotlin.analysis.api.resolution.KaPartiallyAppliedSymbolKt;
import org.jetbrains.kotlin.analysis.api.session.KaSessionProvider;
import org.jetbrains.kotlin.analysis.api.signatures.KaCallableSignature;
import org.jetbrains.kotlin.analysis.api.symbols.KaCallableSymbol;
import org.jetbrains.kotlin.analysis.api.symbols.KaClassSymbol;
import org.jetbrains.kotlin.analysis.api.symbols.KaDeclarationSymbol;
import org.jetbrains.kotlin.analysis.api.symbols.KaSymbol;
import org.jetbrains.kotlin.analysis.api.symbols.KaSymbolKt;
import org.jetbrains.kotlin.builtins.StandardNames;
import org.jetbrains.kotlin.idea.references.ReferenceUtilsKt;
import org.jetbrains.kotlin.name.CallableId;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtImportDirective;
import org.jetbrains.kotlin.psi.KtReferenceExpression;
import org.jetbrains.kotlin.psi.psiUtil.KtPsiUtilKt;
import org.jetbrains.uast.UCallExpression;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UImportStatement;
import org.jetbrains.uast.USimpleNameReferenceExpression;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u00132\u00020\u00012\u00020\u0002:\u0001\u0013B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0016\u0010\u0005\u001a\u0010\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020\b0\u00070\u0006H\u0016J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u000e\u001a\u00020\u0012H\u0016R\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lcom/android/tools/lint/checks/MemberExtensionConflictDetector;", "Lcom/android/tools/lint/detector/api/Detector;", "Lcom/android/tools/lint/detector/api/SourceCodeScanner;", "<init>", "()V", "getApplicableUastTypes", "", "Ljava/lang/Class;", "Lorg/jetbrains/uast/UElement;", "explicitlyImportedExtensions", "", "Lorg/jetbrains/kotlin/name/CallableId;", "afterCheckFile", "", "context", "Lcom/android/tools/lint/detector/api/Context;", "createUastHandler", "Lcom/android/tools/lint/client/api/UElementHandler;", "Lcom/android/tools/lint/detector/api/JavaContext;", "Companion", "lint-checks"})
public final class MemberExtensionConflictDetector
extends Detector
implements SourceCodeScanner {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Set<CallableId> explicitlyImportedExtensions = new LinkedHashSet();
    @NotNull
    private static final Implementation IMPLEMENTATION = new Implementation(MemberExtensionConflictDetector.class, Scope.JAVA_FILE_SCOPE);
    @NotNull
    private static final String MSG = "Conflict applicable candidates of member and extension";
    @JvmField
    @NotNull
    public static final Issue ISSUE = Issue.Companion.create$default((Issue.Companion)Issue.Companion, (String)"MemberExtensionConflict", (String)"Conflict applicable candidates of member and extension", (String)"\n            When both member and extension declarations are applicable, the resolution takes the member. \\\n            This also implies that, if an extension existed first, but then a member is added later, \\\n            the same call-site may end up with different call resolutions depending on target environment. \\\n            This results in a potential runtime exception if the generated binary (library or app) targets \\\n            earlier environment (i.e., without the new member, but only extension). More concrete example \\\n            is found at: https://issuetracker.google.com/issues/350432371\n          ", (Implementation)IMPLEMENTATION, null, null, (int)0, null, (boolean)false, null, null, null, (int)3824, null);

    @NotNull
    public List<Class<? extends UElement>> getApplicableUastTypes() {
        Object[] objectArray = new Class[]{UImportStatement.class, UCallExpression.class, USimpleNameReferenceExpression.class};
        return CollectionsKt.listOf((Object[])objectArray);
    }

    public void afterCheckFile(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this.explicitlyImportedExtensions.clear();
    }

    @NotNull
    public UElementHandler createUastHandler(@NotNull JavaContext context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        return new UElementHandler(this, context){
            final /* synthetic */ MemberExtensionConflictDetector this$0;
            final /* synthetic */ JavaContext $context;
            {
                this.this$0 = $receiver;
                this.$context = $context;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * WARNING - void declaration
             */
            public void visitImportStatement(UImportStatement node) {
                void this_$iv$iv;
                Intrinsics.checkNotNullParameter((Object)node, (String)"node");
                if (node.isOnDemand()) {
                    return;
                }
                PsiElement psiElement = node.getSourcePsi();
                KtImportDirective ktImportDirective = psiElement instanceof KtImportDirective ? (KtImportDirective)psiElement : null;
                if (ktImportDirective == null) {
                    return;
                }
                KtImportDirective importDirective = ktImportDirective;
                KtExpression ktExpression = importDirective.getImportedReference();
                if (ktExpression == null) {
                    return;
                }
                KtExpression importedReference = ktExpression;
                KtElement ktElement = KtPsiUtilKt.getQualifiedElementSelector((KtElement)((KtElement)importedReference));
                KtReferenceExpression ktReferenceExpression = ktElement instanceof KtReferenceExpression ? (KtReferenceExpression)ktElement : null;
                if (ktReferenceExpression == null) {
                    return;
                }
                KtReferenceExpression ktReference = ktReferenceExpression;
                MemberExtensionConflictDetector memberExtensionConflictDetector = this.this$0;
                boolean $i$f$analyze = false;
                Project project = ((KtElement)ktReference).getProject();
                Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
                KaSessionProvider kaSessionProvider = KaSessionProvider.Companion.getInstance(project);
                boolean $i$f$analyze2 = false;
                KaSession analysisSession$iv$iv = this_$iv$iv.getAnalysisSession((KtElement)ktReference);
                this_$iv$iv.beforeEnteringAnalysis(analysisSession$iv$iv, (KtElement)ktReference);
                try {
                    Unit unit;
                    Object lock$iv$iv;
                    Object object = lock$iv$iv = new Object();
                    synchronized (object) {
                        KaSession $this$visitImportStatement_u24lambda_u241;
                        block15: {
                            boolean bl = false;
                            $this$visitImportStatement_u24lambda_u241 = analysisSession$iv$iv;
                            boolean bl2 = false;
                            if (this.isK2($this$visitImportStatement_u24lambda_u241)) break block15;
                            return;
                        }
                        Collection symbols = $this$visitImportStatement_u24lambda_u241.resolveToSymbols(ReferenceUtilsKt.getMainReference((KtReferenceExpression)ktReference));
                        for (KaSymbol symbol : symbols) {
                            CallableId it;
                            if (!(symbol instanceof KaCallableSymbol) || !((KaCallableSymbol)symbol).isExtension()) continue;
                            if (((KaCallableSymbol)symbol).getCallableId() == null) continue;
                            boolean bl = false;
                            MemberExtensionConflictDetector.access$getExplicitlyImportedExtensions$p(memberExtensionConflictDetector).add(it);
                        }
                        unit = Unit.INSTANCE;
                    }
                    Unit unit2 = unit;
                }
                catch (Throwable throwable$iv$iv) {
                    this_$iv$iv.handleAnalysisException(throwable$iv$iv, analysisSession$iv$iv, (KtElement)ktReference);
                    throw new KotlinNothingValueException();
                }
                finally {
                    this_$iv$iv.afterLeavingAnalysis(analysisSession$iv$iv, (KtElement)ktReference);
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * WARNING - void declaration
             */
            public void visitCallExpression(UCallExpression node) {
                void this_$iv$iv;
                Intrinsics.checkNotNullParameter((Object)node, (String)"node");
                if (!Lint.isKotlin((Language)node.getLang())) {
                    return;
                }
                PsiElement psiElement = node.getSourcePsi();
                KtElement ktElement = psiElement instanceof KtElement ? (KtElement)psiElement : null;
                if (ktElement == null) {
                    return;
                }
                KtElement sourcePsi = ktElement;
                boolean $i$f$analyze = false;
                Project project = sourcePsi.getProject();
                Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
                psiElement = KaSessionProvider.Companion.getInstance(project);
                boolean $i$f$analyze2 = false;
                KaSession analysisSession$iv$iv = this_$iv$iv.getAnalysisSession(sourcePsi);
                this_$iv$iv.beforeEnteringAnalysis(analysisSession$iv$iv, sourcePsi);
                try {
                    Unit unit;
                    Object lock$iv$iv;
                    Object object = lock$iv$iv = new Object();
                    synchronized (object) {
                        KaSession $this$visitCallExpression_u24lambda_u242;
                        block12: {
                            boolean bl = false;
                            $this$visitCallExpression_u24lambda_u242 = analysisSession$iv$iv;
                            boolean bl2 = false;
                            if (this.isK2($this$visitCallExpression_u24lambda_u242)) break block12;
                            return;
                        }
                        this.checkKtElement($this$visitCallExpression_u24lambda_u242, (UElement)node, sourcePsi);
                        unit = Unit.INSTANCE;
                    }
                    Unit unit2 = unit;
                }
                catch (Throwable throwable$iv$iv) {
                    this_$iv$iv.handleAnalysisException(throwable$iv$iv, analysisSession$iv$iv, sourcePsi);
                    throw new KotlinNothingValueException();
                }
                finally {
                    this_$iv$iv.afterLeavingAnalysis(analysisSession$iv$iv, sourcePsi);
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * WARNING - void declaration
             */
            public void visitSimpleNameReferenceExpression(USimpleNameReferenceExpression node) {
                void this_$iv$iv;
                Intrinsics.checkNotNullParameter((Object)node, (String)"node");
                if (!Lint.isKotlin((Language)node.getLang())) {
                    return;
                }
                PsiElement psiElement = node.getSourcePsi();
                KtElement ktElement = psiElement instanceof KtElement ? (KtElement)psiElement : null;
                if (ktElement == null) {
                    return;
                }
                KtElement sourcePsi = ktElement;
                boolean $i$f$analyze = false;
                Project project = sourcePsi.getProject();
                Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
                psiElement = KaSessionProvider.Companion.getInstance(project);
                boolean $i$f$analyze2 = false;
                KaSession analysisSession$iv$iv = this_$iv$iv.getAnalysisSession(sourcePsi);
                this_$iv$iv.beforeEnteringAnalysis(analysisSession$iv$iv, sourcePsi);
                try {
                    Unit unit;
                    Object lock$iv$iv;
                    Object object = lock$iv$iv = new Object();
                    synchronized (object) {
                        KaSession $this$visitSimpleNameReferenceExpression_u24lambda_u243;
                        block12: {
                            boolean bl = false;
                            $this$visitSimpleNameReferenceExpression_u24lambda_u243 = analysisSession$iv$iv;
                            boolean bl2 = false;
                            if (this.isK2($this$visitSimpleNameReferenceExpression_u24lambda_u243)) break block12;
                            return;
                        }
                        this.checkKtElement($this$visitSimpleNameReferenceExpression_u24lambda_u243, (UElement)node, sourcePsi);
                        unit = Unit.INSTANCE;
                    }
                    Unit unit2 = unit;
                }
                catch (Throwable throwable$iv$iv) {
                    this_$iv$iv.handleAnalysisException(throwable$iv$iv, analysisSession$iv$iv, sourcePsi);
                    throw new KotlinNothingValueException();
                }
                finally {
                    this_$iv$iv.afterLeavingAnalysis(analysisSession$iv$iv, sourcePsi);
                }
            }

            private final boolean isK2(KaSession $this$isK2) {
                return Intrinsics.areEqual((Object)Reflection.getOrCreateKotlinClass($this$isK2.getClass()).getSimpleName(), (Object)"KaFirSession");
            }

            /*
             * WARNING - void declaration
             */
            private final void checkKtElement(KaSession $this$checkKtElement, UElement node, KtElement ktElement) {
                void $this$filterTo$iv$iv;
                Object v1;
                List extensions;
                block9: {
                    void $this$filterIsInstanceTo$iv$iv;
                    void $this$filterIsInstance$iv;
                    Iterable iterable = $this$checkKtElement.resolveToCallCandidates(ktElement);
                    boolean $i$f$filterIsInstance = false;
                    void var7_7 = $this$filterIsInstance$iv;
                    Collection destination$iv$iv = new ArrayList<E>();
                    boolean $i$f$filterIsInstanceTo = false;
                    for (T element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
                        if (!(element$iv$iv instanceof KaApplicableCallCandidateInfo)) continue;
                        destination$iv$iv.add(element$iv$iv);
                    }
                    List candidates = (List)destination$iv$iv;
                    if (candidates.size() <= 1) {
                        return;
                    }
                    Iterable $this$partition$iv = candidates;
                    boolean $i$f$partition = false;
                    ArrayList<T> first$iv = new ArrayList<T>();
                    ArrayList<T> second$iv = new ArrayList<T>();
                    for (T element$iv : $this$partition$iv) {
                        KaApplicableCallCandidateInfo it = (KaApplicableCallCandidateInfo)element$iv;
                        boolean bl = false;
                        boolean bl2 = this.hasExtensionReceiver(it) ? first$iv.add(element$iv) : second$iv.add(element$iv);
                    }
                    iterable = new Pair(first$iv, second$iv);
                    extensions = (List)iterable.component1();
                    List members = (List)iterable.component2();
                    if (members.isEmpty()) {
                        return;
                    }
                    Iterable $this$singleOrNull$iv = members;
                    boolean $i$f$singleOrNull = false;
                    Object single$iv = null;
                    boolean found$iv = false;
                    for (T element$iv : $this$singleOrNull$iv) {
                        KaApplicableCallCandidateInfo member = (KaApplicableCallCandidateInfo)element$iv;
                        boolean bl = false;
                        if (!(member.isInBestCandidates() && this.callableId(member) != null)) continue;
                        if (found$iv) {
                            v1 = null;
                            break block9;
                        }
                        single$iv = element$iv;
                        found$iv = true;
                    }
                    v1 = !found$iv ? null : single$iv;
                }
                KaApplicableCallCandidateInfo filteredMember = v1;
                if (filteredMember == null) {
                    return;
                }
                Iterable $this$filter$iv = extensions;
                boolean $i$f$filter = false;
                Iterable found$iv = $this$filter$iv;
                Collection destination$iv$iv = new ArrayList<E>();
                boolean $i$f$filterTo = false;
                for (T element$iv$iv : $this$filterTo$iv$iv) {
                    KaApplicableCallCandidateInfo it = (KaApplicableCallCandidateInfo)element$iv$iv;
                    boolean bl = false;
                    if (!(!this.isFromKotlinBuiltIns(it) || this.isExplicitlyImported(it))) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                List filteredExtensions = (List)destination$iv$iv;
                if (filteredExtensions.isEmpty()) {
                    return;
                }
                this.reportConflict($this$checkKtElement, node, (KaCallCandidateInfo)filteredMember, (KaCallCandidateInfo)CollectionsKt.first((List)filteredExtensions));
            }

            private final KaPartiallyAppliedSymbol<?, ?> partialSymbol(KaApplicableCallCandidateInfo $this$partialSymbol) {
                KaCall kaCall = $this$partialSymbol.getCandidate();
                KaCallableMemberCall kaCallableMemberCall = kaCall instanceof KaCallableMemberCall ? (KaCallableMemberCall)kaCall : null;
                return kaCallableMemberCall != null ? kaCallableMemberCall.getPartiallyAppliedSymbol() : null;
            }

            private final CallableId callableId(KaApplicableCallCandidateInfo $this$callableId) {
                KaCallableSignature kaCallableSignature = this.partialSymbol($this$callableId);
                return kaCallableSignature != null && (kaCallableSignature = kaCallableSignature.getSignature()) != null ? kaCallableSignature.getCallableId() : null;
            }

            private final boolean hasExtensionReceiver(KaApplicableCallCandidateInfo $this$hasExtensionReceiver) {
                KaPartiallyAppliedSymbol<?, ?> kaPartiallyAppliedSymbol = this.partialSymbol($this$hasExtensionReceiver);
                return (kaPartiallyAppliedSymbol != null ? kaPartiallyAppliedSymbol.getExtensionReceiver() : null) != null;
            }

            private final boolean isExplicitlyImported(KaApplicableCallCandidateInfo $this$isExplicitlyImported) {
                CallableId callableId = this.callableId($this$isExplicitlyImported);
                if (callableId == null) {
                    return false;
                }
                CallableId callableId2 = callableId;
                return MemberExtensionConflictDetector.access$getExplicitlyImportedExtensions$p(this.this$0).contains(callableId2);
            }

            private final boolean isFromKotlinBuiltIns(KaApplicableCallCandidateInfo $this$isFromKotlinBuiltIns) {
                CallableId callableId = this.callableId($this$isFromKotlinBuiltIns);
                if (callableId == null) {
                    return false;
                }
                CallableId callableId2 = callableId;
                return callableId2.getPackageName().startsWith(StandardNames.BUILT_INS_PACKAGE_FQ_NAME);
            }

            private final void reportConflict(KaSession $this$reportConflict, UElement node, KaCallCandidateInfo member, KaCallCandidateInfo extension) {
                KaSymbol mem = this.symbol(member.getCandidate());
                Object object = this.symbol(extension.getCandidate());
                KaCallableSymbol kaCallableSymbol = object instanceof KaCallableSymbol ? (KaCallableSymbol)object : null;
                if (kaCallableSymbol == null) {
                    return;
                }
                KaCallableSymbol ext = kaCallableSymbol;
                Object $this$reportConflict_u24lambda_u247 = object = new StringBuilder();
                boolean bl = false;
                Object object2 = KaSymbolKt.getName((KaSymbol)mem);
                if (object2 == null || (object2 = object2.asString()) == null) {
                    object2 = "<unnamed>";
                }
                ((StringBuilder)$this$reportConflict_u24lambda_u247).append("`" + (String)object2 + "`");
                ((StringBuilder)$this$reportConflict_u24lambda_u247).append(" is defined both as a member in class ");
                KaDeclarationSymbol kaDeclarationSymbol = $this$reportConflict.getContainingDeclaration(mem);
                KaClassSymbol classSymbol = kaDeclarationSymbol instanceof KaClassSymbol ? (KaClassSymbol)kaDeclarationSymbol : null;
                Object object3 = classSymbol;
                if (object3 == null || (object3 = object3.getClassId()) == null || (object3 = object3.asFqNameString()) == null) {
                    object3 = "<unknown>";
                }
                ((StringBuilder)$this$reportConflict_u24lambda_u247).append("`" + (String)object3 + "`");
                ((StringBuilder)$this$reportConflict_u24lambda_u247).append(" and an extension in package ");
                Object object4 = ext.getCallableId();
                if (object4 == null || (object4 = object4.getPackageName()) == null || (object4 = object4.asString()) == null) {
                    object4 = "<unknown>";
                }
                ((StringBuilder)$this$reportConflict_u24lambda_u247).append("`" + (String)object4 + "`. ");
                ((StringBuilder)$this$reportConflict_u24lambda_u247).append("The defined behavior for this is to use the member, ");
                ((StringBuilder)$this$reportConflict_u24lambda_u247).append("but since the extension is explicitly imported into this file, ");
                ((StringBuilder)$this$reportConflict_u24lambda_u247).append("there's a chance that this was not expected. ");
                ((StringBuilder)$this$reportConflict_u24lambda_u247).append("(One common way this happens is for members to be added to a class ");
                ((StringBuilder)$this$reportConflict_u24lambda_u247).append("after code was already written to use an extension).");
                String message2 = ((StringBuilder)object).toString();
                JavaContext.report$default((JavaContext)this.$context, (Issue)MemberExtensionConflictDetector.ISSUE, (UElement)node, (Location)this.$context.getLocation(node), (String)message2, null, (int)16, null);
            }

            private final KaSymbol symbol(KaCall $this$symbol) {
                KaSymbol kaSymbol;
                KaCall kaCall = $this$symbol;
                if (kaCall instanceof KaCompoundVariableAccessCall) {
                    kaSymbol = (KaSymbol)KaPartiallyAppliedSymbolKt.getSymbol((KaPartiallyAppliedSymbol)((KaCompoundVariableAccessCall)$this$symbol).getCompoundOperation().getOperationPartiallyAppliedSymbol());
                } else if (kaCall instanceof KaCompoundArrayAccessCall) {
                    kaSymbol = (KaSymbol)KaPartiallyAppliedSymbolKt.getSymbol((KaPartiallyAppliedSymbol)((KaCompoundArrayAccessCall)$this$symbol).getCompoundOperation().getOperationPartiallyAppliedSymbol());
                } else if (kaCall instanceof KaCallableMemberCall) {
                    kaSymbol = (KaSymbol)KaCallKt.getSymbol((KaCallableMemberCall)((KaCallableMemberCall)$this$symbol));
                } else {
                    throw new NoWhenBranchMatchedException();
                }
                return kaSymbol;
            }
        };
    }

    public static final /* synthetic */ Set access$getExplicitlyImportedExtensions$p(MemberExtensionConflictDetector $this) {
        return $this.explicitlyImportedExtensions;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000R\u0010\u0010\b\u001a\u00020\t8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lcom/android/tools/lint/checks/MemberExtensionConflictDetector$Companion;", "", "<init>", "()V", "IMPLEMENTATION", "Lcom/android/tools/lint/detector/api/Implementation;", "MSG", "", "ISSUE", "Lcom/android/tools/lint/detector/api/Issue;", "lint-checks"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

