/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.checks;

import com.android.ide.common.resources.configuration.LocaleQualifier;
import com.android.resources.ResourceFolderType;
import com.android.tools.lint.checks.TypoLookup;
import com.android.tools.lint.client.api.LintClient;
import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.Context;
import com.android.tools.lint.detector.api.Implementation;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.Lint;
import com.android.tools.lint.detector.api.LintFix;
import com.android.tools.lint.detector.api.Location;
import com.android.tools.lint.detector.api.ResourceXmlDetector;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import com.android.tools.lint.detector.api.XmlContext;
import com.android.utils.DomExtensions;
import com.android.utils.StringHelper;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.CharsKt;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0010\u0012\n\u0002\b\b\u0018\u0000 12\u00020\u0001:\u00011B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\u0010\u0010\u0013\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0014H\u0016J\u000e\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00070\u0016H\u0016J\u0018\u0010\u0017\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0018\u001a\u00020\u0019H\u0016J \u0010\u001a\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u001b\u001a\u00020\u00192\u0006\u0010\u001c\u001a\u00020\u001dH\u0002J(\u0010\u001e\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001f\u001a\u00020\u0007H\u0002J0\u0010 \u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001f\u001a\u00020\u00072\u0006\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020\"H\u0002JH\u0010$\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001f\u001a\u00020\u00072\u0006\u0010%\u001a\u00020\"2\u0006\u0010&\u001a\u00020\"2\u0006\u0010#\u001a\u00020\"2\u0006\u0010'\u001a\u00020\"H\u0002JH\u0010(\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010)\u001a\u00020*2\u0006\u0010+\u001a\u00020\"2\u0006\u0010,\u001a\u00020\"2\u0006\u0010\u001f\u001a\u00020\u00072\u0006\u0010-\u001a\u00020\"H\u0002J6\u0010.\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001f\u001a\u00020\u00072\u0006\u0010#\u001a\u00020\"2\f\u0010/\u001a\b\u0012\u0004\u0012\u00020\u00070\u0016H\u0002J8\u00100\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001f\u001a\u00020\u00072\u0006\u0010%\u001a\u00020\"2\u0006\u0010#\u001a\u00020\"2\u0006\u0010'\u001a\u00020\"H\u0002R\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\b\u001a\u0004\u0018\u00010\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\t\u001a\u0004\u0018\u00010\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\n\u001a\u0004\u0018\u00010\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u00062"}, d2={"Lcom/android/tools/lint/checks/TypoDetector;", "Lcom/android/tools/lint/detector/api/ResourceXmlDetector;", "<init>", "()V", "lookup", "Lcom/android/tools/lint/checks/TypoLookup;", "lastLanguage", "", "lastRegion", "language", "region", "appliesTo", "", "folderType", "Lcom/android/resources/ResourceFolderType;", "initLocale", "", "context", "Lcom/android/tools/lint/detector/api/XmlContext;", "beforeCheckFile", "Lcom/android/tools/lint/detector/api/Context;", "getApplicableElements", "", "visitElement", "element", "Lorg/w3c/dom/Element;", "visit", "parent", "node", "Lorg/w3c/dom/Node;", "check", "text", "checkForExclamation", "index", "", "begin", "checkRepeatedWords", "lastWordBegin", "lastWordEnd", "end", "checkUtf8Text", "utf8Text", "", "byteStart", "byteEnd", "charStart", "reportTypo", "replacements", "reportRepeatedWord", "Companion", "lint-checks"})
@SourceDebugExtension(value={"SMAP\nTypoDetector.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TypoDetector.kt\ncom/android/tools/lint/checks/TypoDetector\n+ 2 _Strings.kt\nkotlin/text/StringsKt___StringsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,484:1\n158#2,6:485\n1#3:491\n*S KotlinDebug\n*F\n+ 1 TypoDetector.kt\ncom/android/tools/lint/checks/TypoDetector\n*L\n121#1:485,6\n*E\n"})
public final class TypoDetector
extends ResourceXmlDetector {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private TypoLookup lookup;
    @Nullable
    private String lastLanguage;
    @Nullable
    private String lastRegion;
    @Nullable
    private String language;
    @Nullable
    private String region;
    @JvmField
    @NotNull
    public static final Issue ISSUE = Issue.Companion.create("Typos", "Spelling error", "\n                This check looks through the string definitions, and if it finds any words \\\n                that look like likely misspellings, they are flagged.", Category.MESSAGES, 7, Severity.WARNING, new Implementation(TypoDetector.class, Scope.RESOURCE_FILE_SCOPE));

    public boolean appliesTo(@NotNull ResourceFolderType folderType) {
        Intrinsics.checkNotNullParameter((Object)folderType, (String)"folderType");
        return folderType == ResourceFolderType.VALUES;
    }

    private final void initLocale(XmlContext context) {
        LocaleQualifier locale;
        LocaleQualifier localeQualifier = locale = Lint.getLocale((XmlContext)context);
        boolean bl = localeQualifier != null ? localeQualifier.hasLanguage() : false;
        if (bl) {
            this.language = locale.getLanguage();
            this.region = locale.hasRegion() ? locale.getRegion() : null;
        }
    }

    public void beforeCheckFile(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this.initLocale((XmlContext)context);
        String string = this.language;
        if (string == null) {
            string = this.language = "en";
        }
        if (Intrinsics.areEqual((Object)this.lastLanguage, (Object)this.language) || this.region == null || !Intrinsics.areEqual((Object)this.lastRegion, (Object)this.region)) {
            LintClient lintClient = context.getClient();
            String string2 = this.language;
            Intrinsics.checkNotNull((Object)string2);
            this.lookup = TypoLookup.Companion.get(lintClient, string2, this.region);
            this.lastLanguage = this.language;
            this.lastRegion = this.region;
        }
    }

    @NotNull
    public List<String> getApplicableElements() {
        Object[] objectArray = new String[]{"string", "string-array", "plurals"};
        return CollectionsKt.listOf((Object[])objectArray);
    }

    public void visitElement(@NotNull XmlContext context, @NotNull Element element) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        if (this.lookup == null) {
            return;
        }
        this.visit(context, element, element);
    }

    private final void visit(XmlContext context, Element parent, Node node) {
        short nodeType = node.getNodeType();
        if (nodeType == 3 || nodeType == 4) {
            String string = node.getNodeValue();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getNodeValue(...)");
            this.check(context, parent, node, string);
        } else {
            Iterator iterator = DomExtensions.childrenIterator((Node)node);
            while (iterator.hasNext()) {
                Node child = (Node)iterator.next();
                this.visit(context, parent, child);
            }
        }
    }

    private final void check(XmlContext context, Element element, Node node, String text) {
        int wordStart;
        boolean checkedTypos;
        int lastWordEnd;
        int lastWordBegin;
        int max;
        block14: {
            int n;
            if (!TypoDetector.Companion.isTranslatable(element)) {
                return;
            }
            max = text.length();
            lastWordBegin = -1;
            lastWordEnd = -1;
            checkedTypos = false;
            CharSequence $this$indexOfFirst$iv = text;
            boolean $i$f$indexOfFirst = false;
            int n2 = $this$indexOfFirst$iv.length();
            for (int index$iv = 0; index$iv < n2; ++index$iv) {
                char it = $this$indexOfFirst$iv.charAt(index$iv);
                boolean bl = false;
                if (!(!CharsKt.isWhitespace((char)it))) continue;
                n = index$iv;
                break block14;
            }
            n = wordStart = -1;
        }
        if (wordStart == -1) {
            return;
        }
        char it = text.charAt(wordStart);
        boolean bl = false;
        boolean bl2 = it == '@' || it == '?';
        if (bl2) {
            return;
        }
        int index2 = wordStart;
        while (index2 < max) {
            char c2;
            while (index2 < max) {
                char c3 = text.charAt(index2);
                if (c3 == '\\') {
                    index2 += 2;
                    continue;
                }
                if (Character.isLetter(c3)) break;
                ++index2;
            }
            if (index2 >= max) {
                return;
            }
            int begin = index2;
            while (index2 < max && (c2 = text.charAt(index2)) != '\\') {
                if (!Character.isLetter(c2) && c2 != '_') {
                    if (c2 != '1' && c2 != '!' || index2 <= begin + 1) break;
                    this.checkForExclamation(context, node, text, index2, begin);
                    break;
                }
                if (text.charAt(index2) >= '\u0080') {
                    if (checkedTypos) {
                        String string = text.substring(begin);
                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
                        byte[] byArray = string.getBytes(Charsets.UTF_8);
                        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getBytes(...)");
                        byte[] utf8Text = byArray;
                        this.checkUtf8Text(context, element, node, utf8Text, 0, utf8Text.length, text, begin);
                    } else {
                        byte[] byArray = text.getBytes(Charsets.UTF_8);
                        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getBytes(...)");
                        byte[] utf8Text = byArray;
                        this.checkUtf8Text(context, element, node, utf8Text, 0, utf8Text.length, text, 0);
                    }
                    return;
                }
                ++index2;
            }
            int end = ++index2;
            checkedTypos = true;
            TypoLookup typoLookup = this.lookup;
            Intrinsics.checkNotNull((Object)typoLookup);
            List<String> replacements = typoLookup.getTypos(text, begin, end);
            if (replacements != null) {
                this.reportTypo(context, node, text, begin, replacements);
            }
            this.checkRepeatedWords(context, element, node, text, lastWordBegin, lastWordEnd, begin, end);
            lastWordBegin = begin;
            lastWordEnd = end;
            index2 = end + 1;
        }
    }

    private final void checkForExclamation(XmlContext context, Node node, String text, int index2, int begin) {
        char ch;
        boolean problem = true;
        boolean found1 = text.charAt(index2) == '1';
        int end = index2 + 1;
        CharSequence charSequence = text.subSequence(index2 + 1, text.length());
        for (int i = 0; i < charSequence.length() && (ch = charSequence.charAt(i)) != '\n'; ++i) {
            if (ch == '1') {
                found1 = true;
            } else if (ch != '!' && !CharsKt.isWhitespace((char)ch)) {
                if (Character.isLowerCase(ch) || Character.isDigit(ch)) {
                    problem = false;
                    break;
                }
                if (ch != ',' && ch != '.' && ch != ':' && ch != ';') break;
                problem = false;
                break;
            }
            ++end;
        }
        if (problem && found1) {
            String string = text.substring(begin, end);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
            String actual = string;
            String intended = StringsKt.replace$default((String)actual, (char)'1', (char)'!', (boolean)false, (int)4, null);
            LintFix fix2 = this.fix().name("Replace with \"" + intended + "\"").replace().text(actual).with(intended).range(context.getLocation(node)).build();
            context.report(ISSUE, node, context.getLocation(node, begin, end), "Did you mean \"" + intended + "\" instead of \"" + actual + "\"?", fix2);
        }
    }

    private final void checkRepeatedWords(XmlContext context, Element element, Node node, String text, int lastWordBegin, int lastWordEnd, int begin, int end) {
        if (lastWordBegin != -1 && end - begin == lastWordEnd - lastWordBegin && end - begin > 1) {
            boolean different = false;
            int i = lastWordBegin;
            int j = begin;
            while (i < lastWordEnd) {
                if (text.charAt(i) != text.charAt(j)) {
                    different = true;
                    break;
                }
                ++i;
                ++j;
            }
            if (!different && TypoDetector.Companion.onlySpace(text, lastWordEnd, begin) && TypoDetector.Companion.isTranslatable(element)) {
                this.reportRepeatedWord(context, node, text, lastWordBegin, begin, end);
            }
        }
    }

    private final void checkUtf8Text(XmlContext context, Element element, Node node, byte[] utf8Text, int byteStart, int byteEnd, String text, int charStart) {
        int charStart2 = charStart;
        int lastWordBegin = -1;
        int lastWordEnd = -1;
        int index2 = byteStart;
        while (index2 < byteEnd) {
            while (index2 < byteEnd) {
                byte b = utf8Text[index2];
                if (b == 92) {
                    ++charStart2;
                    if (++index2 < byteEnd) {
                        b = utf8Text[index2];
                    }
                } else if (TypoLookup.Companion.isLetter(b)) break;
                ++index2;
                if ((b & 0x80) != 0 && (b & 0xC0) != 192) continue;
                ++charStart2;
            }
            if (index2 >= byteEnd) {
                return;
            }
            int charEnd = charStart2;
            int begin = index2;
            while (index2 < byteEnd) {
                byte b = utf8Text[index2];
                if (b == 92) {
                    ++charEnd;
                    if (++index2 >= byteEnd || ((b = utf8Text[index2++]) & 0x80) != 0 && (b & 0xC0) != 192) break;
                    ++charEnd;
                    break;
                }
                if (!TypoLookup.Companion.isLetter(b)) break;
                ++index2;
                if ((b & 0x80) != 0 && (b & 0xC0) != 192) continue;
                ++charEnd;
            }
            int end = index2;
            TypoLookup typoLookup = this.lookup;
            Intrinsics.checkNotNull((Object)typoLookup);
            List<String> replacements = typoLookup.getTypos(utf8Text, begin, end);
            if (replacements != null && TypoDetector.Companion.isTranslatable(element)) {
                this.reportTypo(context, node, text, charStart2, replacements);
            }
            this.checkRepeatedWords(context, element, node, text, lastWordBegin, lastWordEnd, charStart2, charEnd);
            lastWordBegin = charStart2;
            lastWordEnd = charEnd;
            charStart2 = charEnd;
        }
    }

    private final void reportTypo(XmlContext context, Node node, String text, int begin, List<String> replacements) {
        String string;
        if (replacements.size() < 2) {
            return;
        }
        String typo = replacements.get(0);
        String string2 = text.substring(begin, begin + typo.length());
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
        String word = string2;
        String first = null;
        String message2 = null;
        LintFix.GroupBuilder fixBuilder = this.fix().alternatives();
        boolean isCapitalized = Character.isUpperCase(word.charAt(0));
        StringBuilder sb = new StringBuilder(40);
        int n = replacements.size();
        for (int i = 1; i < n; ++i) {
            String replacement = replacements.get(i);
            if (first == null) {
                first = replacement;
            }
            if (sb.length() > 0) {
                sb.append(" or ");
            }
            sb.append('\"');
            if (isCapitalized) {
                replacement = StringHelper.usLocaleCapitalize((String)replacement);
            }
            sb.append(replacement);
            fixBuilder.add(this.fix().name("Replace with \"" + replacement + "\"").replace().text(word).with(replacement).build());
            sb.append('\"');
        }
        LintFix fix2 = fixBuilder.build();
        if (first != null && StringsKt.equals((String)first, (String)word, (boolean)true)) {
            if (Intrinsics.areEqual((Object)first, (Object)word)) {
                return;
            }
            string = "\"" + word + "\" is usually capitalized as \"" + first + "\"";
        } else {
            string = "\"" + word + "\" is a common misspelling; did you mean " + sb + "?";
        }
        message2 = string;
        int end = begin + word.length();
        context.report(ISSUE, node, context.getLocation(node, begin, end), message2, fix2);
    }

    private final void reportRepeatedWord(XmlContext context, Node node, String text, int lastWordBegin, int begin, int end) {
        String string = text.substring(begin, end);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
        String word = string;
        if (TypoDetector.Companion.isAllowed(word)) {
            return;
        }
        String message2 = "Repeated word \"" + word + "\" in message: possible typo";
        String replace = lastWordBegin > 1 && text.charAt(lastWordBegin - 1) == ' ' ? " " + word : (end < text.length() - 1 && text.charAt(end) == ' ' ? word + " " : word);
        LintFix fix2 = this.fix().name("Delete repeated word").replace().text(replace).with("").build();
        Location location = context.getLocation(node, lastWordBegin, end);
        context.report(ISSUE, node, location, message2, fix2);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J \u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u000bH\u0002J\u0010\u0010\r\u001a\u00020\u00072\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\u0010\u0010\u0010\u001a\u00020\u00072\u0006\u0010\u0011\u001a\u00020\tH\u0002R\u0010\u0010\u0004\u001a\u00020\u00058\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lcom/android/tools/lint/checks/TypoDetector$Companion;", "", "<init>", "()V", "ISSUE", "Lcom/android/tools/lint/detector/api/Issue;", "onlySpace", "", "text", "", "fromInclusive", "", "toExclusive", "isTranslatable", "element", "Lorg/w3c/dom/Element;", "isAllowed", "word", "lint-checks"})
    public static final class Companion {
        private Companion() {
        }

        private final boolean onlySpace(String text, int fromInclusive, int toExclusive) {
            for (int i = fromInclusive; i < toExclusive; ++i) {
                if (CharsKt.isWhitespace((char)text.charAt(i))) continue;
                return false;
            }
            return true;
        }

        private final boolean isTranslatable(Element element) {
            Attr translatable = element.getAttributeNode("translatable");
            return translatable == null || Intrinsics.areEqual((Object)translatable.getValue(), (Object)"true");
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private final boolean isAllowed(String word) {
            if (Character.isUpperCase(word.charAt(0))) {
                return true;
            }
            String string = word;
            switch (string.hashCode()) {
                case 99456: {
                    if (string.equals("die")) return true;
                    return false;
                }
                case 3558823: {
                    if (string.equals("that")) return true;
                    return false;
                }
                case 3521: {
                    if (string.equals("no")) return true;
                    return false;
                }
                case 104817688: {
                    if (string.equals("night")) return true;
                    return false;
                }
                case 99657: {
                    if (string.equals("dot")) return true;
                    return false;
                }
                case 3052805: {
                    if (string.equals("choo")) return true;
                    return false;
                }
                case 115148: {
                    if (string.equals("tsk")) return true;
                    return false;
                }
                case 114735065: {
                    if (string.equals("yadda")) return true;
                    return false;
                }
                case 98030: {
                    if (!string.equals("bye")) return false;
                    return true;
                }
            }
            return false;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

