/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.checks;

import com.android.ide.common.rendering.api.ResourceNamespace;
import com.android.ide.common.rendering.api.ResourceValue;
import com.android.ide.common.resources.ResourceItem;
import com.android.ide.common.resources.ResourceRepository;
import com.android.resources.ResourceUrl;
import com.android.tools.lint.checks.AndroidPatternMatcher;
import com.android.tools.lint.checks.AppLinksValidDetector;
import com.android.tools.lint.client.api.LintClient;
import com.android.tools.lint.client.api.ResourceRepositoryScope;
import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.Context;
import com.android.tools.lint.detector.api.Detector;
import com.android.tools.lint.detector.api.Implementation;
import com.android.tools.lint.detector.api.IncidentKt;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.Lint;
import com.android.tools.lint.detector.api.LintFix;
import com.android.tools.lint.detector.api.LintMap;
import com.android.tools.lint.detector.api.Location;
import com.android.tools.lint.detector.api.PartialResult;
import com.android.tools.lint.detector.api.Position;
import com.android.tools.lint.detector.api.Project;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import com.android.tools.lint.detector.api.XmlContext;
import com.android.tools.lint.detector.api.XmlScanner;
import com.android.utils.DomExtensions;
import com.android.utils.XmlUtils;
import com.google.common.base.Joiner;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.LazyThreadSafetyMode;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IntIterator;
import kotlin.collections.SetsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.jvm.internal.markers.KMappedMarker;
import kotlin.ranges.RangesKt;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.Charsets;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.VisibleForTesting;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u008c\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u001e\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 92\u00020\u00012\u00020\u0002:\u00019B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u000e\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006H\u0016J\u0018\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J\u0018\u0010\u000e\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u000f\u001a\u00020\rH\u0002J\u0018\u0010\u0010\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0002J4\u0010\u0011\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00072\n\b\u0002\u0010\u0017\u001a\u0004\u0018\u00010\u0018H\u0002J4\u0010\u0019\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00072\n\b\u0002\u0010\u0017\u001a\u0004\u0018\u00010\u0018H\u0002J(\u0010\u001a\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0007H\u0002J \u0010\u001b\u001a\u0004\u0018\u00010\u00072\u0006\u0010\u001c\u001a\u00020\u001d2\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020 0\u001fH\u0007J\u0018\u0010!\u001a\u00020 2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u000f\u001a\u00020\rH\u0002J0\u0010\"\u001a\u00020\t2\u0006\u0010#\u001a\u00020 2\u0006\u0010\u000f\u001a\u00020\r2\u0006\u0010$\u001a\u00020%2\u0006\u0010&\u001a\u00020'2\u0006\u0010\n\u001a\u00020\u000bH\u0002JJ\u0010(\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u000f\u001a\u00020\r2\u0006\u0010)\u001a\u00020*2\f\u0010+\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\u0006\u0010\u0016\u001a\u00020\u00072\u0012\u0010,\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020.0-H\u0002J\u0018\u0010/\u001a\u00020\t2\u0006\u0010\n\u001a\u0002002\u0006\u00101\u001a\u000202H\u0016J\u0010\u00103\u001a\u00020\t2\u0006\u0010\n\u001a\u000200H\u0016J \u00104\u001a\u00020.2\u0006\u00105\u001a\u0002062\u0006\u00107\u001a\u00020\u00072\u0006\u00108\u001a\u00020\u0007H\u0016\u00a8\u0006:"}, d2={"Lcom/android/tools/lint/checks/AppLinksValidDetector;", "Lcom/android/tools/lint/detector/api/Detector;", "Lcom/android/tools/lint/detector/api/XmlScanner;", "<init>", "()V", "getApplicableElements", "", "", "visitElement", "", "context", "Lcom/android/tools/lint/detector/api/XmlContext;", "element", "Lorg/w3c/dom/Element;", "checkIntentFilter", "intentFilter", "checkActivity", "reportUrlError", "node", "Lorg/w3c/dom/Node;", "location", "Lcom/android/tools/lint/detector/api/Location;", "message", "quickfixData", "Lcom/android/tools/lint/detector/api/LintFix;", "reportUrlWarning", "reportTestUrlFailure", "checkTestUrlMatchesAtLeastOneInfo", "testUrl", "Ljava/net/URL;", "infos", "", "Lcom/android/tools/lint/checks/AppLinksValidDetector$Companion$IntentFilterData;", "handleIntentFilterInActivity", "handlePath", "intentFilterData", "dataTag", "Lcom/android/tools/lint/checks/AppLinksValidDetector$Companion$TagWrapper;", "path", "Lcom/android/tools/lint/checks/AppLinksValidDetector$Companion$AttributeWrapper;", "suggestRemovingAttributes", "dataTagInfo", "Lcom/android/tools/lint/checks/AppLinksValidDetector$Companion$DataTagInfo;", "attrNames", "isPermitted", "Lkotlin/Function1;", "", "checkPartialResults", "Lcom/android/tools/lint/detector/api/Context;", "partialResults", "Lcom/android/tools/lint/detector/api/PartialResult;", "checkMergedProject", "sameMessage", "issue", "Lcom/android/tools/lint/detector/api/Issue;", "new", "old", "Companion", "lint-checks"})
@SourceDebugExtension(value={"SMAP\nAppLinksValidDetector.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AppLinksValidDetector.kt\ncom/android/tools/lint/checks/AppLinksValidDetector\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Strings.kt\nkotlin/text/StringsKt___StringsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,2047:1\n1563#2:2048\n1634#2,3:2049\n1761#2,3:2052\n1617#2,9:2061\n1869#2:2070\n1870#2:2072\n1626#2:2073\n1617#2,9:2074\n1869#2:2083\n1870#2:2085\n1626#2:2086\n1740#2,3:2087\n2746#2,3:2091\n2746#2,3:2094\n774#2:2097\n865#2,2:2098\n827#2:2100\n855#2,2:2101\n1634#2,3:2103\n1761#2,3:2106\n1563#2:2109\n1634#2,3:2110\n360#2,7:2113\n1011#2,2:2120\n3307#2,10:2122\n1563#2:2132\n1634#2,3:2133\n1761#2,3:2136\n1088#3,2:2055\n1088#3,2:2057\n1088#3,2:2059\n1#4:2071\n1#4:2084\n1#4:2090\n*S KotlinDebug\n*F\n+ 1 AppLinksValidDetector.kt\ncom/android/tools/lint/checks/AppLinksValidDetector\n*L\n173#1:2048\n173#1:2049,3\n181#1:2052,3\n473#1:2061,9\n473#1:2070\n473#1:2072\n473#1:2073\n492#1:2074,9\n492#1:2083\n492#1:2085\n492#1:2086\n526#1:2087,3\n586#1:2091,3\n603#1:2094,3\n683#1:2097\n683#1:2098,2\n684#1:2100\n684#1:2101,2\n784#1:2103,3\n871#1:2106,3\n964#1:2109\n964#1:2110,3\n970#1:2113,7\n974#1:2120,2\n1070#1:2122,10\n1125#1:2132\n1125#1:2133,3\n1137#1:2136,3\n337#1:2055,2\n371#1:2057,2\n413#1:2059,2\n473#1:2071\n492#1:2084\n*E\n"})
public final class AppLinksValidDetector
extends Detector
implements XmlScanner {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    public static final String ACTION_VIEW = "android.intent.action.VIEW";
    @NotNull
    public static final String CATEGORY_BROWSABLE = "android.intent.category.BROWSABLE";
    @NotNull
    public static final String CATEGORY_DEFAULT = "android.intent.category.DEFAULT";
    @NotNull
    private static final Set<String> IMPLICIT_SCHEMES;
    @NotNull
    private static final List<String> PATH_ATTRIBUTES;
    @NotNull
    private static final List<String> QUERY_ATTRIBUTES;
    @NotNull
    private static final List<String> FRAGMENT_ATTRIBUTES;
    @NotNull
    private static final String HTTP = "http";
    @NotNull
    private static final String HTTPS = "https";
    private static final int DEFAULT_INDENT_AMOUNT = 4;
    @NotNull
    private static final Implementation IMPLEMENTATION;
    @JvmField
    @NotNull
    public static final Issue TEST_URL;
    @JvmField
    @NotNull
    public static final Issue VALIDATION;
    @JvmField
    @NotNull
    public static final Issue URI_RELATIVE_FILTER_GROUP;
    @JvmField
    @NotNull
    public static final Issue APP_LINK_WARNING;
    @NotNull
    private static final Issue _OLD_ISSUE_URL;
    @JvmField
    @NotNull
    public static final Issue INTENT_FILTER_UNIQUE_DATA_ATTRIBUTES;
    @JvmField
    @NotNull
    public static final Issue APP_LINK_SPLIT_TO_WEB_AND_CUSTOM;
    @NotNull
    private static final String TAG_VALIDATION = "validation";
    @NotNull
    private static final String KEY_SPLIT_TO_WEB_AND_CUSTOM_NAME_LOCATION = "SPLIT_TO_WEB_AND_CUSTOM_NAME_LOCATION";
    @NotNull
    private static final String KEY_SPLIT_TO_WEB_AND_CUSTOM_REPLACEMENT_RANGE = "SPLIT_TO_WEB_AND_CUSTOM_RANGE";
    @NotNull
    private static final String KEY_SPLIT_TO_WEB_AND_CUSTOM_REPLACEMENT_TEXT = "SPLIT_TO_WEB_AND_CUSTOM_REPLACEMENT_TEXT";
    @NotNull
    private static final String KEY_SPLIT_TO_WEB_AND_CUSTOM_HOSTS = "SPLIT_TO_WEB_AND_CUSTOM_HOSTS";
    @NotNull
    public static final String KEY_SHOW_APP_LINKS_ASSISTANT = "SHOW_APP_LINKS_ASSISTANT";
    @NotNull
    private static final List<String> INTENT_FILTER_DATA_SORT_REFERENCE;

    @NotNull
    public Collection<String> getApplicableElements() {
        Object[] objectArray = new String[]{"activity", "activity-alias", "intent-filter"};
        return CollectionsKt.listOf((Object[])objectArray);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void visitElement(@NotNull XmlContext context, @NotNull Element element) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        String tag = element.getTagName();
        if (tag == null) throw new IllegalStateException(("Unhandled tag " + tag).toString());
        int n = -1;
        switch (tag.hashCode()) {
            case -1655966961: {
                if (tag.equals("activity")) {
                    n = 1;
                }
                break;
            }
            case -1029793847: {
                if (tag.equals("intent-filter")) {
                    n = 2;
                }
                break;
            }
            case 790287890: {
                if (tag.equals("activity-alias")) {
                    n = 1;
                }
                break;
            }
        }
        switch (n) {
            case 2: {
                this.checkIntentFilter(context, element);
                return;
            }
            case 1: {
                this.checkActivity(context, element);
                return;
            }
            default: {
                throw new IllegalStateException(("Unhandled tag " + tag).toString());
            }
        }
    }

    private final void checkIntentFilter(XmlContext context, Element intentFilter) {
        String namespace;
        Companion.IntentFilterData intentFilterData = Companion.getIntentFilterData(new Companion.ElementWrapper(intentFilter, (Context)context));
        String string = intentFilter.lookupPrefix("http://schemas.android.com/apk/res/android");
        if (string == null) {
            string = namespace = "android";
        }
        if (intentFilterData.getDataTags().getDataTagElements().size() <= 1) {
            return;
        }
        for (Companion.TagWrapper dataTag : intentFilterData.getDataTags()) {
            Object object;
            Object object2 = dataTag instanceof Companion.ElementWrapper ? (Companion.ElementWrapper)dataTag : null;
            if (object2 == null || (object2 = ((Companion.ElementWrapper)object2).getElement()) == null) continue;
            Object node = object2;
            Location location = context.getLocation((Node)node);
            Position position = location.getStart();
            int indentAmount = position != null ? position.getColumn() : 4;
            List subTags = new ArrayList();
            Object object3 = ((Companion.ElementWrapper)dataTag).getAttributeWrapper("scheme");
            if (object3 != null && (object3 = ((Companion.AttrWrapper)object3).getRawValue()) != null) {
                Object it = object3;
                boolean bl = false;
                subTags.add("<data " + namespace + ":scheme=\"" + (String)it + "\" />");
            }
            if ((object = ((Companion.ElementWrapper)dataTag).getAttributeWrapper("host")) != null && (object = ((Companion.AttrWrapper)object).getRawValue()) != null) {
                String port;
                Object host = object;
                boolean bl = false;
                Companion.AttrWrapper attrWrapper = ((Companion.ElementWrapper)dataTag).getAttributeWrapper("port");
                String string2 = port = attrWrapper != null ? attrWrapper.getRawValue() : null;
                Object portIfNeeded = string2 == null ? "" : " " + namespace + ":port=\"" + string2 + "\"";
                subTags.add("<data " + namespace + ":host=\"" + (String)host + "\"" + (String)portIfNeeded + " />");
            }
            for (String pathAttribute : PATH_ATTRIBUTES) {
                Object object4 = ((Companion.ElementWrapper)dataTag).getAttributeWrapper(pathAttribute);
                if (object4 == null || (object4 = ((Companion.AttrWrapper)object4).getRawValue()) == null) continue;
                Object it = object4;
                boolean bl = false;
                subTags.add("<data " + namespace + ":" + pathAttribute + "=\"" + (String)it + "\" />");
            }
            if (subTags.size() <= 1) continue;
            context.report(INTENT_FILTER_UNIQUE_DATA_ATTRIBUTES, (Node)node, context.getLocation((Node)node), "Consider splitting data tag into multiple tags with individual attributes to avoid confusion", this.fix().replace().with(CollectionsKt.joinToString$default((Iterable)subTags, (CharSequence)("\n" + AppLinksValidDetector.Companion.indentation(indentAmount)), null, null, (int)0, null, null, (int)62, null)).robot(true).independent(false).build());
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void checkActivity(XmlContext context, Element element) {
        void $this$mapTo$iv$iv;
        Iterable iterable = XmlUtils.getSubTagsByName((Node)element, (String)"intent-filter");
        Intrinsics.checkNotNullExpressionValue((Object)iterable, (String)"getSubTagsByName(...)");
        Iterable $this$map$iv = iterable;
        boolean $i$f$map = false;
        Iterable iterable2 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo22 = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Element element2 = (Element)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            Intrinsics.checkNotNull((Object)it);
            collection.add(this.handleIntentFilterInActivity(context, (Element)it));
        }
        List infos = (List)destination$iv$iv;
        Attr attr = element.getAttributeNodeNS("http://schemas.android.com/apk/res/android", "exported");
        String it = attr != null ? attr.getValue() : null;
        boolean bl = false;
        CharSequence $i$f$mapTo22 = it;
        boolean isExported = $i$f$mapTo22 == null || StringsKt.isBlank((CharSequence)$i$f$mapTo22) || Intrinsics.areEqual((Object)it, (Object)"true");
        if (!isExported) {
            boolean bl2;
            block14: {
                Iterable $this$any$iv = infos;
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl2 = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        Companion.IntentFilterData it2 = (Companion.IntentFilterData)element$iv;
                        boolean bl3 = false;
                        if (!it2.getActionSet().contains(ACTION_VIEW)) continue;
                        bl2 = true;
                        break block14;
                    }
                    bl2 = false;
                }
            }
            if (bl2) {
                AppLinksValidDetector.reportUrlError$default(this, context, element, context.getLocation((Node)element), "Activity supporting ACTION_VIEW is not exported", null, 16, null);
            }
        }
        Element current = XmlUtils.getFirstSubTagByName((Node)element, (String)TAG_VALIDATION);
        while (current != null) {
            if (Intrinsics.areEqual((Object)"http://schemas.android.com/tools", (Object)current.getNamespaceURI())) {
                Attr testUrlAttr = current.getAttributeNode("testUrl");
                if (testUrlAttr == null) {
                    String message2 = "Expected `testUrl` attribute";
                    AppLinksValidDetector.reportUrlError$default(this, context, current, context.getLocation((Node)current), message2, null, 16, null);
                } else {
                    String testUrlString = testUrlAttr.getValue();
                    try {
                        URL testUrl = new URL(testUrlString);
                        String reason = this.checkTestUrlMatchesAtLeastOneInfo(testUrl, infos);
                        if (reason != null) {
                            this.reportTestUrlFailure(context, testUrlAttr, context.getValueLocation(testUrlAttr), reason);
                        }
                    }
                    catch (MalformedURLException e) {
                        String message3 = "Invalid test URL: " + e.getLocalizedMessage();
                        this.reportTestUrlFailure(context, testUrlAttr, context.getValueLocation(testUrlAttr), message3);
                    }
                }
            } else {
                this.reportTestUrlFailure(context, current, context.getNameLocation((Node)current), "Validation nodes should be in the `tools:` namespace to ensure they are removed from the manifest at build time");
            }
            current = XmlUtils.getNextTagByName((Node)current, (String)TAG_VALIDATION);
        }
    }

    private final void reportUrlError(XmlContext context, Node node, Location location, String message2, LintFix quickfixData) {
        if (context.getDriver().isSuppressed(context, _OLD_ISSUE_URL, node)) {
            return;
        }
        context.report(VALIDATION, node, location, message2, quickfixData);
    }

    static /* synthetic */ void reportUrlError$default(AppLinksValidDetector appLinksValidDetector, XmlContext xmlContext, Node node, Location location, String string, LintFix lintFix, int n, Object object) {
        if ((n & 0x10) != 0) {
            lintFix = null;
        }
        appLinksValidDetector.reportUrlError(xmlContext, node, location, string, lintFix);
    }

    private final void reportUrlWarning(XmlContext context, Node node, Location location, String message2, LintFix quickfixData) {
        context.report(APP_LINK_WARNING, node, location, message2, quickfixData);
    }

    static /* synthetic */ void reportUrlWarning$default(AppLinksValidDetector appLinksValidDetector, XmlContext xmlContext, Node node, Location location, String string, LintFix lintFix, int n, Object object) {
        if ((n & 0x10) != 0) {
            lintFix = null;
        }
        appLinksValidDetector.reportUrlWarning(xmlContext, node, location, string, lintFix);
    }

    private final void reportTestUrlFailure(XmlContext context, Node node, Location location, String message2) {
        XmlContext.report$default((XmlContext)context, (Issue)TEST_URL, (Node)node, (Location)location, (String)message2, null, (int)16, null);
    }

    @VisibleForTesting
    @Nullable
    public final String checkTestUrlMatchesAtLeastOneInfo(@NotNull URL testUrl, @NotNull List<Companion.IntentFilterData> infos) {
        Intrinsics.checkNotNullParameter((Object)testUrl, (String)"testUrl");
        Intrinsics.checkNotNullParameter(infos, (String)"infos");
        List reasons = new ArrayList();
        for (Companion.IntentFilterData info : infos) {
            String reason;
            if (info.match(testUrl) == null) {
                return null;
            }
            if (reasons.contains(reason)) continue;
            reasons.add(reason);
        }
        return !((Collection)reasons).isEmpty() ? "Test URL " + Joiner.on((String)" or ").join((Iterable)reasons) : null;
    }

    /*
     * Could not resolve type clashes
     * Unable to fully structure code
     */
    private final Companion.IntentFilterData handleIntentFilterInActivity(XmlContext context, Element intentFilter) {
        block96: {
            block95: {
                block94: {
                    block92: {
                        block91: {
                            intentFilterData = AppLinksValidDetector.Companion.getIntentFilterData(new Companion.ElementWrapper(intentFilter, (Context)context));
                            hasActionView = intentFilterData.getActionSet().contains("android.intent.action.VIEW");
                            hasCategoryBrowsable = intentFilterData.getCategorySet().contains("android.intent.category.BROWSABLE");
                            if (intentFilterData.getDataTags().isEmpty() && hasCategoryBrowsable && !Intrinsics.areEqual((Object)intentFilterData.getAutoVerify(), (Object)"true")) {
                                AppLinksValidDetector.reportUrlError$default(this, context, intentFilter, context.getLocation((Node)intentFilter), "Missing data element", null, 16, null);
                            }
                            for (Companion.AttributeWrapper mimeTypeElement : intentFilterData.getDataTags().getMimeTypeElements()) {
                                block87: {
                                    var9_14 = mimeTypeElement instanceof Companion.AttrWrapper != false ? (Companion.AttrWrapper)mimeTypeElement : null;
                                    v0 = var9_14;
                                    if (v0 == null || (v0 = (var10_15 = v0.getAttr())) == null) continue;
                                    node = v0;
                                    var10_15 = ((Companion.AttrWrapper)mimeTypeElement).getSubstitutedValue();
                                    if (var10_15 == null || com.android.tools.lint.checks.AppLinksValidDetector$Companion.access$isSubstituted(AppLinksValidDetector.Companion, (String)value)) continue;
                                    $this$any$iv = (CharSequence)value;
                                    $i$f$any = false;
                                    for (var12_36 = 0; var12_36 < $this$any$iv.length(); ++var12_36) {
                                        p0 = element$iv = $this$any$iv.charAt(var12_36);
                                        $i$a$-any-AppLinksValidDetector$handleIntentFilterInActivity$1 = false;
                                        if (!Character.isUpperCase(p0)) continue;
                                        v1 = true;
                                        break block87;
                                    }
                                    v1 = false;
                                }
                                if (!v1) continue;
                                resolvedValueMessage = Intrinsics.areEqual((Object)((Companion.AttrWrapper)mimeTypeElement).getRawValue(), (Object)value) == false ? " (without placeholders, value is `" + (String)value + "`)" : "";
                                AppLinksValidDetector.reportUrlError$default(this, context, (Node)node, context.getValueLocation((Attr)node), "Mime-type matching is case sensitive and should only use lower-case characters" + (String)resolvedValueMessage, null, 16, null);
                            }
                            for (Companion.AttributeWrapper schemeElement : intentFilterData.getDataTags().getSchemeElements()) {
                                block88: {
                                    value = schemeElement instanceof Companion.AttrWrapper != false ? (Companion.AttrWrapper)schemeElement : null;
                                    v2 = value;
                                    if (v2 == null || (v2 = (resolvedValueMessage = v2.getAttr())) == null) continue;
                                    node = v2;
                                    v3 = resolvedValueMessage = ((Companion.AttrWrapper)schemeElement).getSubstitutedValue();
                                    if (v3 == null || com.android.tools.lint.checks.AppLinksValidDetector$Companion.access$isSubstituted(AppLinksValidDetector.Companion, (String)(value = v3))) continue;
                                    if (StringsKt.isBlank((CharSequence)((CharSequence)value))) {
                                        AppLinksValidDetector.reportUrlError$default(this, context, (Node)node, context.getLocation((Node)node), "`" + node.getName() + "` cannot be empty", null, 16, null);
                                        continue;
                                    }
                                    if (StringsKt.endsWith$default((String)value, (String)":", (boolean)false, (int)2, null)) {
                                        AppLinksValidDetector.reportUrlError$default(this, context, (Node)node, context.getValueLocation((Attr)node), "Don't include trailing colon in the `scheme` declaration", null, 16, null);
                                        continue;
                                    }
                                    $this$any$iv = (CharSequence)value;
                                    $i$f$any = false;
                                    for (var12_36 = 0; var12_36 < $this$any$iv.length(); ++var12_36) {
                                        p0 = element$iv = $this$any$iv.charAt(var12_36);
                                        $i$a$-any-AppLinksValidDetector$handleIntentFilterInActivity$2 = false;
                                        if (!Character.isUpperCase(p0)) continue;
                                        v4 = true;
                                        break block88;
                                    }
                                    v4 = false;
                                }
                                if (!v4) continue;
                                AppLinksValidDetector.reportUrlError$default(this, context, (Node)node, context.getValueLocation((Attr)node), "Scheme matching is case sensitive and should only use lower-case characters", null, 16, null);
                            }
                            for (Companion.AttributeWrapper hostElement : intentFilterData.getDataTags().getHostElements()) {
                                value = hostElement instanceof Companion.AttrWrapper != false ? (Companion.AttrWrapper)hostElement : null;
                                v5 = value;
                                if (v5 == null || (v5 = ($this$any$iv = v5.getAttr())) == null) continue;
                                node = v5;
                                v6 = $this$any$iv = ((Companion.AttrWrapper)hostElement).getSubstitutedValue();
                                if (v6 == null || com.android.tools.lint.checks.AppLinksValidDetector$Companion.access$isSubstituted(AppLinksValidDetector.Companion, (String)(value = v6))) continue;
                                if (StringsKt.isBlank((CharSequence)((CharSequence)value))) {
                                    AppLinksValidDetector.reportUrlError$default(this, context, (Node)node, context.getLocation((Node)node), "`" + node.getName() + "` cannot be empty", null, 16, null);
                                    continue;
                                }
                                if (StringsKt.lastIndexOf$default((CharSequence)((CharSequence)value), (char)'*', (int)0, (boolean)false, (int)6, null) > 0) {
                                    AppLinksValidDetector.reportUrlError$default(this, context, (Node)node, context.getValueLocation((Attr)node), "The host wildcard (`*`) can only be the first character", null, 16, null);
                                } else {
                                    block89: {
                                        $this$any$iv = (CharSequence)value;
                                        $i$f$any = false;
                                        for (var12_36 = 0; var12_36 < $this$any$iv.length(); ++var12_36) {
                                            p0 = element$iv = $this$any$iv.charAt(var12_36);
                                            $i$a$-any-AppLinksValidDetector$handleIntentFilterInActivity$3 = false;
                                            if (!Character.isUpperCase(p0)) continue;
                                            v7 = true;
                                            break block89;
                                        }
                                        v7 = false;
                                    }
                                    if (v7) {
                                        AppLinksValidDetector.reportUrlError$default(this, context, (Node)node, context.getValueLocation((Attr)node), "Host matching is case sensitive and should only use lower-case characters", null, 16, null);
                                    }
                                }
                                if (!Intrinsics.areEqual((Object)intentFilterData.getAutoVerify(), (Object)"true") || com.android.tools.lint.checks.AppLinksValidDetector$Companion.access$isSubstituted(AppLinksValidDetector.Companion, (String)value) || StringsKt.contains$default((CharSequence)((CharSequence)value), (CharSequence)".", (boolean)false, (int)2, null)) continue;
                                AppLinksValidDetector.reportUrlError$default(this, context, (Node)node, context.getValueLocation((Attr)node), "Android App Links' `host` attributes must be valid web domains", null, 16, null);
                            }
                            for (Companion.AttributeWrapper portElement : intentFilterData.getDataTags().getPortElements()) {
                                value = portElement instanceof Companion.AttrWrapper != false ? (Companion.AttrWrapper)portElement : null;
                                v8 = value;
                                if (v8 == null || (v8 = ($this$any$iv = v8.getAttr())) == null) continue;
                                node = v8;
                                v9 = $this$any$iv = ((Companion.AttrWrapper)portElement).getSubstitutedValue();
                                if (v9 == null || com.android.tools.lint.checks.AppLinksValidDetector$Companion.access$isSubstituted(AppLinksValidDetector.Companion, (String)(value = v9))) continue;
                                if (StringsKt.isBlank((CharSequence)((CharSequence)value))) {
                                    AppLinksValidDetector.reportUrlError$default(this, context, (Node)node, context.getLocation((Node)node), "`" + node.getName() + "` cannot be empty", null, 16, null);
                                    continue;
                                }
                                try {
                                    port = Integer.parseInt((String)value);
                                    if (port >= 1 && port <= 65535) continue;
                                    throw new NumberFormatException();
                                }
                                catch (NumberFormatException e) {
                                    AppLinksValidDetector.reportUrlError$default(this, context, (Node)node, context.getValueLocation((Attr)node), "not a valid port number", null, 16, null);
                                }
                            }
                            for (Companion.TagWrapper dataTag : intentFilterData.getDataTags()) {
                                port = dataTag.getAttributeWrapper("port");
                                if ((port != null ? port.getSubstitutedValue() : null) == null || dataTag.getAttributeWrapper("host") != null || (v10 = (e = port instanceof Companion.AttrWrapper != false ? (Companion.AttrWrapper)port : null)) == null || (v10 = ($i$f$any = v10.getAttr())) == null) continue;
                                node = v10;
                                AppLinksValidDetector.reportUrlError$default(this, context, (Node)node, context.getValueLocation((Attr)node), "The port must be specified in the same `<data>` element as the `host`", null, 16, null);
                            }
                            for (Companion.TagWrapper dataTag : intentFilterData.getDataTags()) {
                                $this$mapNotNull$iv = AppLinksValidDetector.PATH_ATTRIBUTES;
                                $i$f$mapNotNull = false;
                                $i$f$any = $this$mapNotNull$iv;
                                destination$iv$iv = new ArrayList<E>();
                                $i$f$mapNotNullTo = false;
                                $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
                                $i$f$forEach = false;
                                for (T element$iv$iv$iv : $this$forEach$iv$iv$iv) {
                                    element$iv$iv = element$iv$iv$iv;
                                    $i$a$-forEach-CollectionsKt___CollectionsKt$mapNotNullTo$1$iv$iv = false;
                                    it = (String)element$iv$iv;
                                    $i$a$-mapNotNull-AppLinksValidDetector$handleIntentFilterInActivity$4 = false;
                                    if (dataTag.getAttributeWrapper(it) == null) continue;
                                    $i$a$-let-CollectionsKt___CollectionsKt$mapNotNullTo$1$1$iv$iv = false;
                                    destination$iv$iv.add(it$iv$iv);
                                }
                                for (Companion.AttributeWrapper path : (List)destination$iv$iv) {
                                    this.handlePath(intentFilterData, intentFilter, dataTag, path, context);
                                }
                            }
                            for (Object group : intentFilterData.getUriRelativeFilterGroups()) {
                                port = new String[]{"scheme", "host", "port", "mimeType"};
                                this.suggestRemovingAttributes(context, intentFilter, group.getDataTagInfo(), CollectionsKt.listOf((Object[])port), "Attributes not starting with `path`, `query`, or `fragment` in `uri-relative-filter-group` are ignored", (Function1<? super String, Boolean>)((Function1)handleIntentFilterInActivity.5.INSTANCE));
                                for (Companion.TagWrapper dataTag : group.getDataTagInfo()) {
                                    $this$mapNotNull$iv = AppLinksValidDetector.PATH_ATTRIBUTES;
                                    $i$f$mapNotNull = false;
                                    $i$f$mapNotNullTo = $this$mapNotNull$iv;
                                    destination$iv$iv = new ArrayList<E>();
                                    $i$f$mapNotNullTo = false;
                                    $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
                                    $i$f$forEach = false;
                                    for (E element$iv$iv$iv : $this$forEach$iv$iv$iv) {
                                        element$iv$iv = element$iv$iv$iv;
                                        $i$a$-forEach-CollectionsKt___CollectionsKt$mapNotNullTo$1$iv$iv = false;
                                        it = (String)element$iv$iv;
                                        $i$a$-mapNotNull-AppLinksValidDetector$handleIntentFilterInActivity$6 = false;
                                        if (dataTag.getAttributeWrapper(it) == null) continue;
                                        $i$a$-let-CollectionsKt___CollectionsKt$mapNotNullTo$1$1$iv$iv = false;
                                        destination$iv$iv.add(it$iv$iv);
                                    }
                                    for (Object path : (List)destination$iv$iv) {
                                        this.handlePath(intentFilterData, intentFilter, dataTag, (Companion.AttributeWrapper)path, context);
                                    }
                                }
                                for (Companion.AttributeWrapper query : group.getQueryElements()) {
                                    path = query instanceof Companion.AttrWrapper != false ? (Companion.AttrWrapper)query : null;
                                    if (path == null || !((path = (CharSequence)node.getSubstitutedValue()) == null || StringsKt.isBlank((CharSequence)path) != false)) continue;
                                    XmlContext.report$default((XmlContext)context, (Issue)AppLinksValidDetector.URI_RELATIVE_FILTER_GROUP, (Node)node.getAttr(), (Location)context.getLocation((Node)node.getAttr()), (String)("`" + node.getName() + "` cannot be empty"), null, (int)16, null);
                                }
                                for (Object fragment : group.getFragmentElements()) {
                                    path = fragment instanceof Companion.AttrWrapper != false ? (Companion.AttrWrapper)fragment : null;
                                    if (path == null || !((path = (CharSequence)node.getSubstitutedValue()) == null || StringsKt.isBlank((CharSequence)path) != false)) continue;
                                    XmlContext.report$default((XmlContext)context, (Issue)AppLinksValidDetector.URI_RELATIVE_FILTER_GROUP, (Node)node.getAttr(), (Location)context.getLocation((Node)node.getAttr()), (String)("`" + node.getName() + "` cannot be empty"), null, (int)16, null);
                                }
                            }
                            if (((Collection)intentFilterData.getDataTags().getSchemes()).isEmpty() == false) {
                                block90: {
                                    var6_6 = intentFilterData.getDataTags().getSchemes();
                                    group = AppLinksValidDetector.Companion;
                                    $i$f$all = false;
                                    if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                                        v11 = true;
                                    } else {
                                        for (E element$iv : $this$all$iv) {
                                            p0 = (String)element$iv;
                                            $i$a$-all-AppLinksValidDetector$handleIntentFilterInActivity$7 = false;
                                            if (group.isWebScheme(p0)) continue;
                                            v11 = false;
                                            break block90;
                                        }
                                        v11 = true;
                                    }
                                }
                                if (v11 && ((Collection)intentFilterData.getDataTags().getHostPortPairs()).isEmpty() == false && hasActionView && hasCategoryBrowsable && intentFilterData.getCategorySet().contains("android.intent.category.DEFAULT") && !Intrinsics.areEqual((Object)intentFilterData.getAutoVerify(), (Object)"true") && !Intrinsics.areEqual((Object)intentFilterData.getAutoVerify(), (Object)"false")) {
                                    this.reportUrlWarning(context, intentFilter, context.getNameLocation((Node)intentFilter), "This intent filter has the format of an Android App Link but is \\\nmissing the `autoVerify` attribute; add `android:autoVerify=\"true\"` \\\nto ensure your domain will be validated and enable App Link-related \\\nLint warnings. If you do not want clicked URLs to bring the user to \\\nyour app, remove the `android.intent.category.BROWSABLE` category, or \\\nset `android:autoVerify=\"false\"` to make it clear this is not intended \\\nto be an Android App Link.", this.fix().set("http://schemas.android.com/apk/res/android", "autoVerify", "true").autoFix().build());
                                }
                            }
                            if (!AppLinksValidDetector.Companion.hasAutoVerifyButInvalidAppLink(intentFilterData)) break block94;
                            contentToInsert = new StringBuilder();
                            insertionDescriptions = new ArrayList<E>();
                            fragment = XmlUtils.getFirstSubTag((Node)intentFilter);
                            v12 = fragment;
                            if (v12 == null) ** GOTO lbl-1000
                            it = p0 = v12;
                            $i$a$-let-AppLinksValidDetector$handleIntentFilterInActivity$innerIndent$1 = false;
                            v13 = context.getLocation((Node)it).getStart();
                            element$iv = v13 != null ? Integer.valueOf(v13.getColumn()) : null;
                            v12 = element$iv;
                            if (v12 != null) {
                                v14 = v12.intValue();
                            } else lbl-1000:
                            // 2 sources

                            {
                                v15 = p0 = context.getLocation((Node)intentFilter).getStart();
                                v14 = (v15 != null ? (it = v15.getColumn()) : 0) + 4;
                            }
                            innerIndent = v14;
                            newLineAndInnerIndent = "\n" + com.android.tools.lint.checks.AppLinksValidDetector$Companion.access$indentation(AppLinksValidDetector.Companion, innerIndent);
                            p0 = intentFilter.lookupPrefix("http://schemas.android.com/apk/res/android");
                            v16 = p0;
                            if (v16 == null) {
                                v16 = namespace = "android";
                            }
                            if (!intentFilterData.getActionSet().contains("android.intent.action.VIEW")) {
                                contentToInsert.append((String)newLineAndInnerIndent).append("<action " + (String)namespace + ":name=\"android.intent.action.VIEW\" />");
                                insertionDescriptions.add("VIEW action");
                            }
                            it = new String[]{"android.intent.category.BROWSABLE", "android.intent.category.DEFAULT"};
                            for (String categoryName : SequencesKt.sequenceOf((Object[])it)) {
                                if (intentFilterData.getCategorySet().contains(categoryName)) continue;
                                contentToInsert.append((String)newLineAndInnerIndent).append("<category " + (String)namespace + ":name=\"" + categoryName + "\" />");
                                insertionDescriptions.add(StringsKt.substringAfter$default((String)categoryName, (String)"android.intent.category.", null, (int)2, null) + " category");
                            }
                            $this$none$iv = intentFilterData.getDataTags().getSchemes();
                            $i$f$none = false;
                            if ($this$none$iv instanceof Collection && ((Collection)$this$none$iv).isEmpty()) {
                                v17 = true;
                            } else {
                                for (T element$iv : $this$none$iv) {
                                    it = (String)element$iv;
                                    $i$a$-none-AppLinksValidDetector$handleIntentFilterInActivity$8 = false;
                                    if (!(com.android.tools.lint.checks.AppLinksValidDetector$Companion.access$isSubstituted(AppLinksValidDetector.Companion, it) != false || AppLinksValidDetector.Companion.isWebScheme(it) != false)) continue;
                                    v17 = false;
                                    break block91;
                                }
                                v17 = true;
                            }
                        }
                        if (!(!v17 || intentFilterData.getDataTags().getSchemes().isEmpty() && ((Collection)intentFilterData.getDataTags().getHostPortPairs()).isEmpty() == false)) {
                            contentToInsert.append((String)newLineAndInnerIndent).append("<data " + (String)namespace + ":scheme=\"http\" />").append((String)newLineAndInnerIndent).append("<data " + (String)namespace + ":scheme=\"https\" />");
                            insertionDescriptions.add("`http(s)` scheme");
                        }
                        if (!intentFilterData.getDataTags().getHostPortPairs().isEmpty()) ** GOTO lbl-1000
                        $this$none$iv = intentFilterData.getDataTags().getDataTagElements();
                        $i$f$none = false;
                        if ($this$none$iv instanceof Collection && ((Collection)$this$none$iv).isEmpty()) {
                            v18 = true;
                        } else {
                            for (T element$iv : $this$none$iv) {
                                it = (Companion.TagWrapper)element$iv;
                                $i$a$-none-AppLinksValidDetector$handleIntentFilterInActivity$needsHostFix$1 = false;
                                if (!(it.getAttributeWrapper("port") != null && it.getAttributeWrapper("host") == null)) continue;
                                v18 = false;
                                break block92;
                            }
                            v18 = true;
                        }
                    }
                    if (v18) {
                        v19 = true;
                    } else lbl-1000:
                    // 2 sources

                    {
                        v19 = needsHostFix = false;
                    }
                    if (needsHostFix) {
                        contentToInsert.append((String)newLineAndInnerIndent).append("<data " + (String)namespace + ":host=\"TODO\" />");
                        insertionDescriptions.add("`host` attribute");
                    }
                    $i$f$none = intentFilter.getFirstChild();
                    Intrinsics.checkNotNullExpressionValue((Object)$i$f$none, (String)"getFirstChild(...)");
                    firstChildStart = context.getLocation($i$f$none).getStart();
                    if (((CharSequence)contentToInsert).length() > 0 && firstChildStart != null) {
                        element$iv = insertionDescriptions.size();
                        switch (element$iv) {
                            case 1: {
                                v20 = CollectionsKt.single((List)insertionDescriptions) + " is missing, but is required for Android App Links";
                                break;
                            }
                            case 2: {
                                v20 = CollectionsKt.first((List)insertionDescriptions) + " and " + CollectionsKt.last((List)insertionDescriptions) + " are missing, but are required for Android App Links";
                                break;
                            }
                            default: {
                                v20 = "Several elements/attributes (such as " + CollectionsKt.first((List)insertionDescriptions) + ") required for Android App Links are missing";
                            }
                        }
                        message = v20;
                        element$iv = insertionDescriptions.size();
                        switch (element$iv) {
                            case 1: {
                                v21 = "Add " + CollectionsKt.single((List)insertionDescriptions);
                                break;
                            }
                            case 2: {
                                v21 = "Add " + CollectionsKt.first((List)insertionDescriptions) + " and " + CollectionsKt.last((List)insertionDescriptions);
                                break;
                            }
                            default: {
                                v21 = "Add missing elements/attributes";
                            }
                        }
                        fixName = v21;
                        it = this.fix().name(fixName).replace().with(contentToInsert.toString());
                        $this$handleIntentFilterInActivity_u24lambda_u2414 = it;
                        $i$a$-apply-AppLinksValidDetector$handleIntentFilterInActivity$fix$1 = false;
                        if (needsHostFix) {
                            $this$handleIntentFilterInActivity_u24lambda_u2414.select("TODO");
                        }
                        fix = it.range(Location.Companion.create(context.file, firstChildStart, firstChildStart).withSource((Object)intentFilter)).robot(needsHostFix == false).independent(true).build();
                        v22 = intentFilter;
                        v23 = context.getNameLocation((Node)intentFilter);
                        if (LintClient.Companion.isStudio()) {
                            it = new LintFix[2];
                            $this$handleIntentFilterInActivity_u24lambda_u2414 = new Object[]{"SHOW_APP_LINKS_ASSISTANT", true};
                            it[0] = this.fix().data($this$handleIntentFilterInActivity_u24lambda_u2414);
                            it[1] = fix;
                            v24 = this.fix().group(it);
                        } else {
                            v24 = fix;
                        }
                        this.reportUrlError(context, v22, v23, message, v24);
                    }
                    this.suggestRemovingAttributes(context, intentFilter, intentFilterData.getDataTags(), CollectionsKt.listOf((Object)"mimeType"), "MIME types prevent Android App Links from matching", (Function1<? super String, Boolean>)((Function1)handleIntentFilterInActivity.9.INSTANCE));
                    $this$filter$iv = intentFilterData.getDataTags().getSchemes();
                    $i$f$filter = false;
                    it = $this$filter$iv;
                    destination$iv$iv /* !! */  = new ArrayList<E>();
                    $i$f$filterTo = false;
                    for (Object element$iv$iv : $this$filterTo$iv$iv) {
                        it = (String)element$iv$iv;
                        $i$a$-filter-AppLinksValidDetector$handleIntentFilterInActivity$webSchemes$1 = false;
                        if (!AppLinksValidDetector.Companion.isWebScheme(it)) continue;
                        destination$iv$iv /* !! */ .add(element$iv$iv);
                    }
                    webSchemes = (List)destination$iv$iv /* !! */ ;
                    $this$filterNot$iv = intentFilterData.getDataTags().getSchemes();
                    $i$f$filterNot = false;
                    destination$iv$iv /* !! */  = $this$filterNot$iv;
                    destination$iv$iv = new ArrayList<E>();
                    $i$f$filterNotTo = false;
                    element$iv$iv = $this$filterNotTo$iv$iv.iterator();
                    while (element$iv$iv.hasNext()) {
                        element$iv$iv = element$iv$iv.next();
                        it = (String)element$iv$iv;
                        $i$a$-filterNot-AppLinksValidDetector$handleIntentFilterInActivity$customSchemes$1 = false;
                        if (AppLinksValidDetector.Companion.isWebScheme(it)) continue;
                        destination$iv$iv.add(element$iv$iv);
                    }
                    customSchemes = (List)destination$iv$iv;
                    if (!(((Collection)webSchemes).isEmpty() == false) || !(((Collection)customSchemes).isEmpty() == false) || !(((Collection)intentFilterData.getDataTags().getHostPortPairs()).isEmpty() == false)) break block94;
                    v25 = $i$f$filterNot = context.getLocation((Node)intentFilter).getStart();
                    intentFilterIndentAmount = v25 != null ? ($this$filterNotTo$iv$iv = v25.getColumn()) : 0;
                    destination$iv$iv = CollectionsKt.first(intentFilterData.getDataTags().getDataTagElements());
                    $this$filterNotTo$iv$iv = destination$iv$iv instanceof Companion.ElementWrapper != false ? (Companion.ElementWrapper)destination$iv$iv : null;
                    v26 = $this$filterNotTo$iv$iv;
                    if (v26 == null || (v26 = (destination$iv$iv = v26.getElement())) == null) ** GOTO lbl-1000
                    it = element$iv$iv = v26;
                    $i$a$-let-AppLinksValidDetector$handleIntentFilterInActivity$intentFilterChildIndentAmount$1 = false;
                    v27 = context.getLocation((Node)it).getStart();
                    $i$f$filterNotTo = v27 != null ? Integer.valueOf(v27.getColumn()) : null;
                    v26 = $i$f$filterNotTo;
                    if (v26 != null) {
                        v28 = v26.intValue();
                    } else lbl-1000:
                    // 2 sources

                    {
                        v28 = 4;
                    }
                    intentFilterChildIndentAmount = v28;
                    indentDiff = intentFilterChildIndentAmount - intentFilterIndentAmount;
                    startIndent = com.android.tools.lint.checks.AppLinksValidDetector$Companion.access$indentation(AppLinksValidDetector.Companion, intentFilterIndentAmount);
                    intentFilterChildIndent = com.android.tools.lint.checks.AppLinksValidDetector$Companion.access$indentation(AppLinksValidDetector.Companion, intentFilterChildIndentAmount);
                    it = intentFilter.lookupPrefix("http://schemas.android.com/apk/res/android");
                    v29 = it;
                    if (v29 == null) {
                        v29 = "android";
                    }
                    namespace = v29;
                    webSchemeIntentFilterText = new StringBuilder("<");
                    com.android.tools.lint.checks.AppLinksValidDetector$Companion.access$copyTagWithAttributes(AppLinksValidDetector.Companion, intentFilter, webSchemeIntentFilterText);
                    webSchemeIntentFilterText.append(">");
                    customSchemeIntentFilterText = new StringBuilder("<intent-filter");
                    it$iv$iv = intentFilter.getAttributes().getLength();
                    for (i = 0; i < it$iv$iv; ++i) {
                        item = intentFilter.getAttributes().item(i);
                        var26_120 /* !! */  = item.getNodeName();
                        Intrinsics.checkNotNullExpressionValue((Object)var26_120 /* !! */ , (String)"getNodeName(...)");
                        if (StringsKt.endsWith$default((String)var26_120 /* !! */ , (String)"autoVerify", (boolean)false, (int)2, null)) continue;
                        customSchemeIntentFilterText.append(" ");
                        customSchemeIntentFilterText.append(item.getNodeName());
                        customSchemeIntentFilterText.append("=\"");
                        var26_120 /* !! */  = item.getNodeValue();
                        Intrinsics.checkNotNullExpressionValue((Object)var26_120 /* !! */ , (String)"getNodeValue(...)");
                        customSchemeIntentFilterText.append(com.android.tools.lint.checks.AppLinksValidDetector$Companion.access$xmlEscape(AppLinksValidDetector.Companion, (String)var26_120 /* !! */ ));
                        customSchemeIntentFilterText.append('\"');
                    }
                    customSchemeIntentFilterText.append(">");
                    i = DomExtensions.iterator((Element)intentFilter);
                    while (i.hasNext()) {
                        subTag = (Element)i.next();
                        if (Intrinsics.areEqual((Object)subTag.getTagName(), (Object)"data")) continue;
                        var26_120 /* !! */  = new StringBuilder[]{webSchemeIntentFilterText, customSchemeIntentFilterText};
                        for (StringBuilder sb : SequencesKt.sequenceOf((Object[])var26_120 /* !! */ )) {
                            sb.append("\n");
                            sb.append(intentFilterChildIndent);
                            com.android.tools.lint.checks.AppLinksValidDetector$Companion.access$recursivelyCopy(AppLinksValidDetector.Companion, subTag, intentFilterChildIndentAmount, indentDiff, sb);
                        }
                    }
                    for (String scheme : CollectionsKt.sorted((Iterable)webSchemes)) {
                        webSchemeIntentFilterText.append("\n");
                        webSchemeIntentFilterText.append(intentFilterChildIndent);
                        webSchemeIntentFilterText.append("<data " + namespace + ":scheme=\"" + scheme + "\" />");
                    }
                    for (String scheme : CollectionsKt.sorted((Iterable)customSchemes)) {
                        customSchemeIntentFilterText.append("\n");
                        customSchemeIntentFilterText.append(intentFilterChildIndent);
                        customSchemeIntentFilterText.append("<data " + namespace + ":scheme=\"" + scheme + "\" />");
                    }
                    intentFilterTextAfterSchemes = new StringBuilder();
                    item = new Comparator(){

                        public final int compare(T a, T b) {
                            Pair it = (Pair)a;
                            boolean bl = false;
                            Comparable comparable = (Comparable)it.getFirst();
                            it = (Pair)b;
                            Comparable comparable2 = comparable;
                            bl = false;
                            return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)((Comparable)it.getFirst()));
                        }
                    };
                    for (Comparator item : CollectionsKt.sortedWith((Iterable)intentFilterData.getDataTags().getHostPortPairs(), (Comparator)new Comparator(item){
                        final /* synthetic */ Comparator $this_thenBy;
                        {
                            this.$this_thenBy = $receiver;
                        }

                        public final int compare(T a, T b) {
                            int n;
                            int previousCompare = this.$this_thenBy.compare(a, b);
                            if (previousCompare != 0) {
                                n = previousCompare;
                            } else {
                                Pair it = (Pair)a;
                                boolean bl = false;
                                Comparable comparable = (Comparable)it.getSecond();
                                it = (Pair)b;
                                Comparable comparable2 = comparable;
                                bl = false;
                                n = ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)((Comparable)it.getSecond()));
                            }
                            return n;
                        }
                    })) {
                        host = (String)item.component1();
                        port = (String)item.component2();
                        intentFilterTextAfterSchemes.append("\n");
                        intentFilterTextAfterSchemes.append(intentFilterChildIndent);
                        intentFilterTextAfterSchemes.append("<data " + namespace + ":host=\"" + (String)host + "\"");
                        var28_122 = (CharSequence)port;
                        if (!(var28_122 == null || StringsKt.isBlank((CharSequence)var28_122) != false)) {
                            intentFilterTextAfterSchemes.append(" " + namespace + ":port=\"" + (String)port + "\"");
                        }
                        intentFilterTextAfterSchemes.append(" />");
                    }
                    for (Companion.Path path : CollectionsKt.sorted((Iterable)intentFilterData.getDataTags().getRawPaths())) {
                        intentFilterTextAfterSchemes.append("\n");
                        intentFilterTextAfterSchemes.append(intentFilterChildIndent);
                        intentFilterTextAfterSchemes.append("<data " + namespace + ":" + path.getAttributeName() + "=\"" + com.android.tools.lint.checks.AppLinksValidDetector$Companion.access$xmlEscape(AppLinksValidDetector.Companion, path.getAttributeValue()) + "\" />");
                    }
                    for (String mimeType : CollectionsKt.sorted((Iterable)intentFilterData.getDataTags().getRawMimeTypes())) {
                        intentFilterTextAfterSchemes.append("\n");
                        intentFilterTextAfterSchemes.append(intentFilterChildIndent);
                        intentFilterTextAfterSchemes.append("<data " + namespace + ":mimeType=\"" + mimeType + "\" />");
                    }
                    intentFilterTextAfterSchemes.append("\n");
                    intentFilterTextAfterSchemes.append(startIndent);
                    intentFilterTextAfterSchemes.append("</intent-filter>");
                    replacementText = webSchemeIntentFilterText;
                    replacementText.append((CharSequence)intentFilterTextAfterSchemes);
                    replacementText.append("\n");
                    replacementText.append(startIndent);
                    replacementText.append((CharSequence)customSchemeIntentFilterText);
                    replacementText.append((CharSequence)intentFilterTextAfterSchemes);
                    if (!context.getDriver().isSuppressed(context, AppLinksValidDetector.APP_LINK_SPLIT_TO_WEB_AND_CUSTOM, (Node)intentFilter)) {
                        host = intentFilterData.getDataTags().getHostPortPairs();
                        port = new LinkedHashSet<E>();
                        $i$f$mapTo = false;
                        for (T item$iv : $this$mapTo$iv) {
                            var31_126 = (Pair)item$iv;
                            var33_128 = destination$iv;
                            $i$a$-mapTo-AppLinksValidDetector$handleIntentFilterInActivity$hosts$1 = false;
                            var34_129 = (String)it.getFirst();
                            var33_128.add(var34_129);
                        }
                        hosts = CollectionsKt.joinToString$default((Iterable)((Iterable)destination$iv), (CharSequence)",", null, null, (int)0, null, null, (int)62, null);
                        map = context.getPartialResults(AppLinksValidDetector.APP_LINK_SPLIT_TO_WEB_AND_CUSTOM).map();
                        v30 = String.valueOf(map.getSize());
                        v31 = this.map().put("SPLIT_TO_WEB_AND_CUSTOM_NAME_LOCATION", context.getNameLocation((Node)intentFilter)).put("SPLIT_TO_WEB_AND_CUSTOM_RANGE", context.getLocation((Node)intentFilter));
                        var27_121 = replacementText.toString();
                        Intrinsics.checkNotNullExpressionValue((Object)var27_121, (String)"toString(...)");
                        map.put(v30, v31.put("SPLIT_TO_WEB_AND_CUSTOM_REPLACEMENT_TEXT", var27_121).put("SPLIT_TO_WEB_AND_CUSTOM_HOSTS", hosts));
                    }
                }
                showMissingSchemeCheck = intentFilterData.getDataTags().getSchemes().isEmpty() != false && (((Collection)intentFilterData.getDataTags().getPaths()).isEmpty() == false != false || ((Collection)intentFilterData.getDataTags().getHostPortPairs()).isEmpty() == false != false);
                newLineAndInnerIndent = CollectionsKt.firstOrNull((Iterable)intentFilterData.getDataTags());
                innerIndent = newLineAndInnerIndent instanceof Companion.ElementWrapper != false ? (Companion.ElementWrapper)newLineAndInnerIndent : null;
                v32 = innerIndent;
                if (v32 == null) break block95;
                newLineAndInnerIndent = v32.getElement();
                v32 = newLineAndInnerIndent;
                if (newLineAndInnerIndent != null) break block96;
            }
            return intentFilterData;
        }
        firstData = v32;
        if (showMissingSchemeCheck) {
            this.reportUrlError(context, (Node)firstData, context.getLocation((Node)firstData), "At least one `scheme` must be specified", LintFix.SetAttributeBuilder.todo$default((LintFix.SetAttributeBuilder)this.fix().set(), (String)"http://schemas.android.com/apk/res/android", (String)"scheme", null, null, (int)12, null).independent(true).build());
        }
        v33 = showMissingUriCheck = hasActionView != false && intentFilterData.getDataTags().getSchemes().isEmpty() != false && intentFilterData.getDataTags().getMimeTypes().isEmpty() != false;
        if (!showMissingSchemeCheck && showMissingUriCheck) {
            newLineAndInnerIndent = new LintFix[]{LintFix.SetAttributeBuilder.todo$default((LintFix.SetAttributeBuilder)this.fix().set(), (String)"http://schemas.android.com/apk/res/android", (String)"scheme", null, null, (int)12, null).build(), LintFix.SetAttributeBuilder.todo$default((LintFix.SetAttributeBuilder)this.fix().set(), (String)"http://schemas.android.com/apk/res/android", (String)"mimeType", null, null, (int)12, null).build()};
            this.reportUrlError(context, (Node)firstData, context.getLocation((Node)firstData), "VIEW actions require a URI", this.fix().alternatives(newLineAndInnerIndent));
        }
        if (((Collection)intentFilterData.getDataTags().getPaths()).isEmpty() == false && intentFilterData.getDataTags().getHostPortPairs().isEmpty()) {
            fix = LintFix.SetAttributeBuilder.todo$default((LintFix.SetAttributeBuilder)LintFix.Companion.create().set(), (String)"http://schemas.android.com/apk/res/android", (String)"host", null, null, (int)12, null).build();
            this.reportUrlError(context, (Node)firstData, context.getLocation((Node)firstData), "At least one `host` must be specified", (LintFix)fix);
        }
        if (hasActionView) {
            block93: {
                fix = intentFilterData.getDataTags().getSchemes();
                var10_27 = AppLinksValidDetector.Companion;
                $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    v34 = false;
                } else {
                    for (T element$iv : $this$any$iv) {
                        p0 = (String)element$iv;
                        $i$a$-any-AppLinksValidDetector$handleIntentFilterInActivity$12 = false;
                        if (!var10_27.isWebScheme(p0)) continue;
                        v34 = true;
                        break block93;
                    }
                    v34 = false;
                }
            }
            if (v34 && !hasCategoryBrowsable) {
                AppLinksValidDetector.reportUrlError$default(this, context, intentFilter, context.getLocation((Node)intentFilter), "Activity supporting ACTION_VIEW is not set as BROWSABLE", null, 16, null);
            }
        }
        return intentFilterData;
    }

    /*
     * WARNING - void declaration
     */
    private final void handlePath(Companion.IntentFilterData intentFilterData, Element intentFilter, Companion.TagWrapper dataTag, Companion.AttributeWrapper path, XmlContext context) {
        Object object = path instanceof Companion.AttrWrapper ? (Companion.AttrWrapper)path : null;
        if (object == null || (object = ((Companion.AttrWrapper)object).getAttr()) == null) {
            return;
        }
        Object attribute = object;
        String name = ((Companion.AttrWrapper)path).getName();
        String rawValue2 = ((Companion.AttrWrapper)path).getRawValue();
        String substitutedValue2 = ((Companion.AttrWrapper)path).getSubstitutedValue();
        Object[] objectArray = (Object[])rawValue2;
        if (objectArray == null || StringsKt.isBlank((CharSequence)objectArray) || (objectArray = (CharSequence)substitutedValue2) == null || StringsKt.isBlank((CharSequence)objectArray)) {
            AppLinksValidDetector.reportUrlError$default(this, context, (Node)attribute, context.getLocation((Node)attribute), "`" + attribute.getName() + "` cannot be empty", null, 16, null);
            return;
        }
        if (AppLinksValidDetector.Companion.isSubstituted(substitutedValue2)) {
            return;
        }
        if (!StringsKt.startsWith$default((String)substitutedValue2, (String)"/", (boolean)false, (int)2, null) && SetsKt.setOf((Object[])(objectArray = new String[]{"path", "pathPrefix"})).contains(name)) {
            LintFix fix2 = LintFix.Companion.create().replace().text(rawValue2).with("/" + rawValue2).build();
            this.reportUrlError(context, (Node)attribute, context.getValueLocation((Attr)attribute), "`" + attribute.getName() + "` attribute should start with `/`, but it is `" + substitutedValue2 + "`", fix2);
        }
        if (!StringsKt.startsWith$default((String)substitutedValue2, (String)"/", (boolean)false, (int)2, null) && !StringsKt.startsWith$default((String)substitutedValue2, (String)".*", (boolean)false, (int)2, null) && Intrinsics.areEqual((Object)name, (Object)"pathPattern")) {
            AppLinksValidDetector.reportUrlError$default(this, context, (Node)attribute, context.getValueLocation((Attr)attribute), "`" + attribute.getName() + "` attribute should start with `/` or `.*`, but it is `" + substitutedValue2 + "`", null, 16, null);
        }
        if (Intrinsics.areEqual((Object)intentFilterData.getAutoVerify(), (Object)"true")) {
            Object[] objectArray2 = new char[]{'?'};
            Object it = StringsKt.split$default((CharSequence)substitutedValue2, (char[])objectArray2, (boolean)false, (int)0, (int)6, null);
            boolean bl = false;
            objectArray2 = new String[2];
            objectArray2[0] = (char)"&amp;";
            objectArray2[1] = (char)"&";
            Set queryParameters2 = SequencesKt.toSet((Sequence)SequencesKt.filter((Sequence)StringsKt.splitToSequence$default((CharSequence)StringsKt.substringBefore$default((String)(it.size() == 2 ? (String)it.get(1) : ""), (char)'#', null, (int)2, null), (String[])objectArray2, (boolean)false, (int)0, (int)6, null), (Function1)handlePath.queryParameters.2.INSTANCE));
            it = new char[1];
            it[0] = 35;
            List it2 = StringsKt.split$default((CharSequence)substitutedValue2, (char[])it, (boolean)false, (int)0, (int)6, null);
            boolean bl2 = false;
            String fragmentInUri = StringsKt.substringBefore$default((String)(it2.size() == 2 ? (String)it2.get(1) : ""), (char)'?', null, (int)2, null);
            if (!((Collection)queryParameters2).isEmpty() || !StringsKt.isBlank((CharSequence)fragmentInUri)) {
                String string;
                List $i$f$indexOfFirst2;
                int n;
                String newLineAndDataIndent;
                int dataIndent;
                Element parent;
                Object dataElement;
                String pathBeforeQueryAndFragment;
                List queries2;
                String namespace;
                block19: {
                    void $this$mapTo$iv$iv;
                    String string2 = intentFilter.lookupPrefix("http://schemas.android.com/apk/res/android");
                    if (string2 == null) {
                        string2 = "android";
                    }
                    namespace = string2;
                    Iterable $this$map$iv = CollectionsKt.sorted((Iterable)queryParameters2);
                    boolean $i$f$map22 = false;
                    Iterable iterable = $this$map$iv;
                    Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                    boolean $i$f$mapTo22 = false;
                    for (Object item$iv$iv : $this$mapTo$iv$iv) {
                        void it3;
                        String string3 = (String)item$iv$iv;
                        Collection collection = destination$iv$iv;
                        boolean bl3 = false;
                        collection.add("<data " + namespace + ":query=\"" + (String)it3 + "\" />");
                    }
                    queries2 = (List)destination$iv$iv;
                    char[] $i$f$map22 = new char[]{'?', '#'};
                    pathBeforeQueryAndFragment = (String)StringsKt.split$default((CharSequence)substitutedValue2, (char[])$i$f$map22, (boolean)false, (int)0, (int)6, null).get(0);
                    Object object2 = dataTag instanceof Companion.ElementWrapper ? (Companion.ElementWrapper)dataTag : null;
                    if (object2 == null || (object2 = ((Companion.ElementWrapper)object2).getElement()) == null) {
                        return;
                    }
                    dataElement = object2;
                    Node $i$f$mapTo22 = dataElement.getParentNode();
                    Element element = $i$f$mapTo22 instanceof Element ? (Element)$i$f$mapTo22 : null;
                    if (element == null) {
                        return;
                    }
                    parent = element;
                    Position position = context.getLocation((Node)dataElement).getStart();
                    dataIndent = position != null ? position.getColumn() : 4;
                    newLineAndDataIndent = "\n" + AppLinksValidDetector.Companion.indentation(dataIndent);
                    Iterable $this$indexOfFirst$iv = ((Companion.ElementWrapper)dataTag).getAttributes();
                    boolean $i$f$indexOfFirst2 = false;
                    int index$iv = 0;
                    for (Object item$iv : $this$indexOfFirst$iv) {
                        Companion.AttrWrapper it4 = (Companion.AttrWrapper)item$iv;
                        boolean bl4 = false;
                        if (Intrinsics.areEqual((Object)it4.getRawValue(), (Object)((Companion.AttrWrapper)path).getRawValue())) {
                            n = index$iv;
                            break block19;
                        }
                        ++index$iv;
                    }
                    n = -1;
                }
                int indexOfThisPath = n;
                List $this$handlePath_u24lambda_u2427 = $i$f$indexOfFirst2 = CollectionsKt.toMutableList((Collection)((Collection)((Companion.ElementWrapper)dataTag).getAttributes()));
                boolean bl5 = false;
                $this$handlePath_u24lambda_u2427.remove(indexOfThisPath);
                List $this$sortBy$iv = $this$handlePath_u24lambda_u2427;
                boolean $i$f$sortBy = false;
                if ($this$sortBy$iv.size() > 1) {
                    CollectionsKt.sortWith((List)$this$sortBy$iv, (Comparator)new Comparator(){

                        public final int compare(T a, T b) {
                            Companion.AttrWrapper it = (Companion.AttrWrapper)a;
                            boolean bl = false;
                            Comparable comparable = (Comparable)((Object)it.getName());
                            it = (Companion.AttrWrapper)b;
                            Comparable comparable2 = comparable;
                            bl = false;
                            return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)((Comparable)((Object)it.getName())));
                        }
                    });
                }
                List otherAttributesInThisDataTag = $i$f$indexOfFirst2;
                String otherAttributesText2 = otherAttributesInThisDataTag.isEmpty() ? "" : "<data " + CollectionsKt.joinToString$default((Iterable)otherAttributesInThisDataTag, (CharSequence)" ", null, null, (int)0, null, (Function1)((Function1)new Function1<Companion.AttrWrapper, CharSequence>(namespace){
                    final /* synthetic */ String $namespace;
                    {
                        this.$namespace = $namespace;
                        super(1);
                    }

                    public final CharSequence invoke(Companion.AttrWrapper it) {
                        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                        return this.$namespace + ":" + it.getName() + "=\"" + it.getRawValue() + "\"";
                    }
                }), (int)30, null) + " />" + newLineAndDataIndent;
                String message2 = Intrinsics.areEqual((Object)parent.getTagName(), (Object)"uri-relative-filter-group") ? "`path` attributes do not support query parameters or fragments" : "App link matching does not support query parameters or fragments, unless using `<uri-relative-filter-group>` (introduced in Android 15)";
                String string4 = parent.getTagName();
                if (Intrinsics.areEqual((Object)string4, (Object)"uri-relative-filter-group")) {
                    String newLineAndIndentedFragment = Intrinsics.areEqual((Object)fragmentInUri, (Object)"") ? "" : newLineAndDataIndent + "<data " + namespace + ":fragment=\"" + fragmentInUri + "\" />";
                    string = otherAttributesText2 + "<data " + namespace + ":" + name + "=\"" + pathBeforeQueryAndFragment + "\" />" + AppLinksValidDetector.Companion.concatenateWithIndent(queries2, newLineAndDataIndent) + newLineAndIndentedFragment;
                } else if (Intrinsics.areEqual((Object)string4, (Object)"intent-filter")) {
                    Position position = context.getLocation((Node)parent).getStart();
                    int parentIndent = position != null ? position.getColumn() : 0;
                    String startingIndent = AppLinksValidDetector.Companion.indentation(dataIndent);
                    int innerIndentAmount = 2 * dataIndent - parentIndent;
                    String newLineAndInnerIndent = "\n" + AppLinksValidDetector.Companion.indentation(innerIndentAmount);
                    String newLineAndIndentedFragment = Intrinsics.areEqual((Object)fragmentInUri, (Object)"") ? "" : newLineAndInnerIndent + "<data " + namespace + ":fragment=\"" + fragmentInUri + "\" />";
                    string = otherAttributesText2 + "<uri-relative-filter-group>" + newLineAndInnerIndent + "<data " + namespace + ":" + name + "=\"" + pathBeforeQueryAndFragment + "\" />" + AppLinksValidDetector.Companion.concatenateWithIndent(queries2, newLineAndInnerIndent) + newLineAndIndentedFragment + "\n" + startingIndent + "</uri-relative-filter-group>";
                } else {
                    string = null;
                }
                String fixText = string;
                this.reportUrlError(context, (Node)dataElement, context.getLocation((Node)dataElement), message2, context.getProject().getBuildSdk() < 35 || context.getProject().getTargetSdk() < 35 || fixText == null ? null : this.fix().replace().with(fixText).robot(true).independent(false).build());
            }
        }
        if (StringsKt.contains$default((CharSequence)substitutedValue2, (CharSequence)"?", (boolean)false, (int)2, null) && SetsKt.setOf((Object[])(objectArray = new String[]{"pathPattern", "pathAdvancedPattern"})).contains(name)) {
            AppLinksValidDetector.reportUrlError$default(this, context, (Node)attribute, context.getValueLocation((Attr)attribute), name + " does not support `?` as a Regex character", null, 16, null);
        }
    }

    private final void suggestRemovingAttributes(XmlContext context, Element intentFilter, Companion.DataTagInfo dataTagInfo2, Collection<String> attrNames, String message2, Function1<? super String, Boolean> isPermitted) {
        for (Companion.TagWrapper dataTag : dataTagInfo2) {
            Object object = dataTag instanceof Companion.ElementWrapper ? (Companion.ElementWrapper)dataTag : null;
            if (object == null || (object = ((Companion.ElementWrapper)object).getElement()) == null) continue;
            Object dataElement = object;
            Iterable $this$partition$iv = ((Companion.ElementWrapper)dataTag).getAttributes();
            boolean $i$f$partition = false;
            ArrayList first$iv = new ArrayList();
            ArrayList second$iv = new ArrayList();
            for (Object element$iv : $this$partition$iv) {
                Companion.AttrWrapper it = (Companion.AttrWrapper)element$iv;
                boolean bl = false;
                boolean bl2 = (Boolean)isPermitted.invoke((Object)it.getName()) != false ? first$iv.add(element$iv) : second$iv.add(element$iv);
            }
            Pair pair = new Pair(first$iv, second$iv);
            List permitted = (List)pair.component1();
            List notPermitted = (List)pair.component2();
            if (permitted.isEmpty()) {
                if (!(!((Collection)notPermitted).isEmpty())) continue;
                context.report(URI_RELATIVE_FILTER_GROUP, (Node)dataElement, context.getLocation((Node)dataElement), message2, this.fix().replace().with("").autoFix().build());
                continue;
            }
            if (!(!((Collection)notPermitted).isEmpty())) continue;
            String string = intentFilter.lookupPrefix("http://schemas.android.com/apk/res/android");
            if (string == null) {
                string = "android";
            }
            String namespace = string;
            context.report(URI_RELATIVE_FILTER_GROUP, (Node)dataElement, context.getLocation((Node)dataElement), message2, this.fix().replace().pattern("(" + namespace + ":(" + CollectionsKt.joinToString$default((Iterable)attrNames, (CharSequence)"|", null, null, (int)0, null, null, (int)62, null) + ")=((\"[^\"]*\")|('[^']*')))").with("").repeatedly(true).reformat(true).autoFix().build());
        }
    }

    /*
     * WARNING - void declaration
     */
    public void checkPartialResults(@NotNull Context context, @NotNull PartialResult partialResults) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)partialResults, (String)"partialResults");
        if (context.getProject().isLibrary()) {
            return;
        }
        if (!Intrinsics.areEqual((Object)partialResults.getIssue(), (Object)APP_LINK_SPLIT_TO_WEB_AND_CUSTOM)) {
            return;
        }
        Node node = context.getMainProject().getMergedManifest();
        if (node == null || (node = node.getDocumentElement()) == null) {
            return;
        }
        Node mergedManifestDocumentElement = node;
        Set hostsThatRequestAutoVerify = new LinkedHashSet();
        Iterator iterator = DomExtensions.iterator((Element)mergedManifestDocumentElement);
        while (iterator.hasNext()) {
            Element node2 = (Element)iterator.next();
            if (!Intrinsics.areEqual((Object)node2.getTagName(), (Object)"application")) continue;
            Iterator iterator2 = DomExtensions.iterator((Element)node2);
            while (iterator2.hasNext()) {
                Element applicationChild = (Element)iterator2.next();
                Object object = new String[]{"activity", "activity-alias"};
                if (!SetsKt.setOf((Object[])object).contains(applicationChild.getTagName())) continue;
                object = DomExtensions.iterator((Element)applicationChild);
                while (object.hasNext()) {
                    void $this$mapTo$iv$iv;
                    void $this$map$iv;
                    Companion.IntentFilterData data;
                    Element activityChild = (Element)object.next();
                    if (!Intrinsics.areEqual((Object)activityChild.getTagName(), (Object)"intent-filter") || !AppLinksValidDetector.Companion.isValidAppLink(data = AppLinksValidDetector.Companion.getIntentFilterData(new Companion.ElementWrapper(activityChild, context)))) continue;
                    Iterable iterable = data.getDataTags().getHostPortPairs();
                    Set set = hostsThatRequestAutoVerify;
                    boolean $i$f$map = false;
                    void var14_17 = $this$map$iv;
                    Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                    boolean $i$f$mapTo = false;
                    for (Object item$iv$iv : $this$mapTo$iv$iv) {
                        void it;
                        Pair pair = (Pair)item$iv$iv;
                        Collection collection = destination$iv$iv;
                        boolean bl = false;
                        collection.add((String)it.getFirst());
                    }
                    set.addAll((List)destination$iv$iv);
                }
            }
        }
        for (LintMap lintMap : partialResults.maps()) {
            for (String incidentIdx : lintMap) {
                Location replacementRange;
                String replacementText;
                Location nameLocation;
                boolean bl;
                LintMap partialResult;
                block12: {
                    Object $i$f$map;
                    Object object;
                    if (lintMap.getMap(incidentIdx) == null || (object = LintMap.getString$default((LintMap)partialResult, (String)KEY_SPLIT_TO_WEB_AND_CUSTOM_HOSTS, null, (int)2, null)) == null || (object = StringsKt.split$default((CharSequence)((CharSequence)object), (String[])($i$f$map = new String[]{","}), (boolean)false, (int)0, (int)6, null)) == null) continue;
                    Object hosts = object;
                    Iterable $this$any$iv = (Iterable)hosts;
                    boolean $i$f$any = false;
                    if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                        bl = false;
                    } else {
                        $i$f$map = $this$any$iv.iterator();
                        while ($i$f$map.hasNext()) {
                            Object element$iv = $i$f$map.next();
                            String it = (String)element$iv;
                            boolean bl2 = false;
                            if (!(!hostsThatRequestAutoVerify.contains(it))) continue;
                            bl = true;
                            break block12;
                        }
                        bl = false;
                    }
                }
                if (!bl || partialResult.getLocation(KEY_SPLIT_TO_WEB_AND_CUSTOM_NAME_LOCATION) == null || partialResult.getLocation(KEY_SPLIT_TO_WEB_AND_CUSTOM_REPLACEMENT_RANGE) == null || LintMap.getString$default((LintMap)partialResult, (String)KEY_SPLIT_TO_WEB_AND_CUSTOM_REPLACEMENT_TEXT, null, (int)2, null) == null) continue;
                context.report(IncidentKt.Incident((Context)context).issue(APP_LINK_SPLIT_TO_WEB_AND_CUSTOM).location(nameLocation).message("Split your `http(s)` and custom schemes into separate intent filters").fix(this.fix().replace().with(replacementText.toString()).range(replacementRange).robot(true).independent(false).build()));
            }
        }
    }

    public void checkMergedProject(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        if (context.isGlobalAnalysis()) {
            this.checkPartialResults(context, context.getPartialResults(APP_LINK_SPLIT_TO_WEB_AND_CUSTOM));
        }
    }

    public boolean sameMessage(@NotNull Issue issue, @NotNull String string, @NotNull String old) {
        CharSequence charSequence;
        Intrinsics.checkNotNullParameter((Object)issue, (String)"issue");
        Intrinsics.checkNotNullParameter((Object)string, (String)"new");
        Intrinsics.checkNotNullParameter((Object)old, (String)"old");
        if (Intrinsics.areEqual((Object)issue, (Object)VALIDATION) && Intrinsics.areEqual((Object)old, (Object)"Missing URL") && Intrinsics.areEqual((Object)string, (Object)"VIEW actions require a URI")) {
            return true;
        }
        if (Intrinsics.areEqual((Object)issue, (Object)VALIDATION) && Intrinsics.areEqual((Object)old, (Object)"Missing required elements/attributes for Android App Links") && new Regex("(.* is missing, but is required for Android App Links)|(.* and .* are missing, but are required for Android App Links)|(Several elements/attributes \\(such as .*\\) required for Android App Links are missing)").matches(charSequence = (CharSequence)string)) {
            return true;
        }
        return super.sameMessage(issue, string, old);
    }

    static {
        Object[] objectArray = new String[]{"file", "content"};
        IMPLICIT_SCHEMES = SetsKt.setOf((Object[])objectArray);
        objectArray = new String[]{"path", "pathPrefix", "pathPattern", "pathAdvancedPattern", "pathSuffix"};
        PATH_ATTRIBUTES = CollectionsKt.listOf((Object[])objectArray);
        objectArray = new String[]{"query", "queryPrefix", "queryPattern", "queryAdvancedPattern", "querySuffix"};
        QUERY_ATTRIBUTES = CollectionsKt.listOf((Object[])objectArray);
        objectArray = new String[]{"fragment", "fragmentPrefix", "fragmentPattern", "fragmentAdvancedPattern", "fragmentSuffix"};
        FRAGMENT_ATTRIBUTES = CollectionsKt.listOf((Object[])objectArray);
        IMPLEMENTATION = new Implementation(AppLinksValidDetector.class, Scope.MANIFEST_SCOPE);
        TEST_URL = Issue.Companion.create("TestAppLink", "Unmatched URLs", "\n                Using one or more `tools:validation testUrl=\"some url\"/>` elements in your manifest allows \\\n                the link attributes in your intent filter to be checked for matches.\n                ", Category.CORRECTNESS, 5, Severity.FATAL, IMPLEMENTATION);
        objectArray = Issue.Companion;
        Category category = Category.CORRECTNESS;
        Severity severity = Severity.ERROR;
        Implementation implementation = IMPLEMENTATION;
        VALIDATION = Issue.Companion.create$default((Issue.Companion)objectArray, (String)"AppLinkUrlError", (String)"URI invalid", (String)"\n                Ensure your intent filter has the documented elements for deep links, web links, or Android \\\n                App Links.", (Implementation)implementation, (String)"https://developer.android.com/training/app-links", (Category)category, (int)5, (Severity)severity, (boolean)false, null, null, null, (int)3840, null).addMoreInfo("https://g.co/AppIndexing/AndroidStudio");
        objectArray = Issue.Companion;
        category = Category.CORRECTNESS;
        severity = Severity.ERROR;
        implementation = IMPLEMENTATION;
        URI_RELATIVE_FILTER_GROUP = Issue.Companion.create$default((Issue.Companion)objectArray, (String)"AppLinkUriRelativeFilterGroupError", (String)"URI relative filter group invalid", (String)"Ensure that your URI relative filter group is correctly configured.", (Implementation)implementation, (String)"https://developer.android.com/guide/topics/manifest/uri-relative-filter-group-element?utm_source=lint", (Category)category, (int)5, (Severity)severity, (boolean)false, null, null, null, (int)3840, null);
        objectArray = Issue.Companion;
        category = Category.CORRECTNESS;
        severity = Severity.WARNING;
        implementation = IMPLEMENTATION;
        APP_LINK_WARNING = Issue.Companion.create$default((Issue.Companion)objectArray, (String)"AppLinkWarning", (String)"App Link warning", (String)"From Android 12, intent filters that use the HTTP and HTTPS schemes will no longer \\\n              bring the user to your app when the user clicks a link, unless the intent filter is \\\n              an Android App Link. Such intent filters must include certain elements, and at least \\\n              one Android App Link for each domain must have `android:autoVerify=\"true\"` to verify \\\n              ownership of the domain. We recommend adding `android:autoVerify=\"true\"` to any intent \\\n              filter that is intended to be an App Link, in case the other App Links are modified.", (Implementation)implementation, (String)"https://developer.android.com/training/app-links", (Category)category, (int)5, (Severity)severity, (boolean)false, null, null, null, (int)3840, null).addMoreInfo("https://g.co/AppIndexing/AndroidStudio");
        _OLD_ISSUE_URL = Issue.Companion.create("GoogleAppIndexingUrlError", "?", "?", Category.USABILITY, 5, Severity.ERROR, IMPLEMENTATION);
        objectArray = Issue.Companion;
        category = Category.CORRECTNESS;
        severity = Severity.WARNING;
        implementation = IMPLEMENTATION;
        INTENT_FILTER_UNIQUE_DATA_ATTRIBUTES = Issue.Companion.create$default((Issue.Companion)objectArray, (String)"IntentFilterUniqueDataAttributes", (String)"Data tags should only declare unique attributes", (String)"\n                `<intent-filter>` `<data>` tags should only declare a single unique attribute \\\n                (i.e. scheme OR host, but not both). This better matches the runtime behavior of \\\n                intent filters, as they combine all of the declared data attributes into a single \\\n                matcher which is allowed to handle any combination across attribute types.\n\n                For example, the following two `<intent-filter>` declarations are the same:\n                ```xml\n                <intent-filter>\n                    <data android:scheme=\"http\" android:host=\"example.com\" />\n                    <data android:scheme=\"https\" android:host=\"example.org\" />\n                </intent-filter>\n                ```\n\n                ```xml\n                <intent-filter>\n                    <data android:scheme=\"http\"/>\n                    <data android:scheme=\"https\"/>\n                    <data android:host=\"example.com\" />\n                    <data android:host=\"example.org\" />\n                </intent-filter>\n                ```\n\n                They both handle all of the following:\n                * http://example.com\n                * https://example.com\n                * http://example.org\n                * https://example.org\n\n                The second one better communicates the combining behavior and is clearer to an \\\n                external reader that one should not rely on the scheme/host being self contained. \\\n                It is not obvious in the first that http://example.org is also matched, which can \\\n                lead to confusion (or incorrect behavior) with a more complex set of schemes/hosts.\n\n                Note that this does not apply to host + port, as those must be declared in the same \\\n                `<data>` tag and are only associated with each other.\n                ", (Implementation)implementation, (String)"https://developer.android.com/guide/components/intents-filters", (Category)category, (int)0, (Severity)severity, (boolean)false, null, null, null, (int)3904, null);
        objectArray = Issue.Companion;
        category = Category.CORRECTNESS;
        severity = Severity.ERROR;
        implementation = IMPLEMENTATION;
        APP_LINK_SPLIT_TO_WEB_AND_CUSTOM = Issue.Companion.create$default((Issue.Companion)objectArray, (String)"AppLinkSplitToWebAndCustom", (String)"Android App links should only use http(s) schemes", (String)"\n          In order for Android App Links to open in your app, Android must perform domain \\\n          verification. However, Android only sends domain verification requests for \\\n          `<intent-filter>`s that only contain http(s) schemes.\n\n          To ensure correct behavior, please split your http(s) schemes and other schemes \\\n          into two different `<intent-filter>`s.\n        ", (Implementation)implementation, (String)"https://developer.android.com/training/app-links/verify-android-applinks#add-intent-filters", (Category)category, (int)0, (Severity)severity, (boolean)false, null, null, null, (int)3904, null);
        objectArray = new String[]{"scheme", "host", "port", "path", "pathPrefix", "pathPattern", "pathSuffix", "pathAdvancedPattern", "mimeType"};
        INTENT_FILTER_DATA_SORT_REFERENCE = CollectionsKt.listOf((Object[])objectArray);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000p\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\t\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u001b\b\u0086\u0003\u0018\u00002\u00020\u0001:\nRSTUVWXYZ[B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0018\u001a\u00020\u00052\u0006\u0010\u0019\u001a\u00020\u0017H\u0002J\u001a\u0010\u001a\u001a\u00020\u00052\b\u0010\u001b\u001a\u0004\u0018\u00010\u001c2\u0006\u0010\u001d\u001a\u00020\u0005H\u0002J\u0015\u0010\u001e\u001a\u00020\u00172\u0006\u0010\u001f\u001a\u00020\u0005H\u0000\u00a2\u0006\u0002\b J\u000e\u0010!\u001a\u00020\u00052\u0006\u0010\"\u001a\u00020\u0017J\u000e\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020\u0005J\u000e\u0010&\u001a\u00020'2\u0006\u0010(\u001a\u00020)J\u000e\u0010*\u001a\u00020$2\u0006\u0010(\u001a\u00020)J\u000e\u0010*\u001a\u00020$2\u0006\u0010+\u001a\u00020'J\u0010\u0010,\u001a\u00020$2\u0006\u0010+\u001a\u00020'H\u0002J\u0010\u0010-\u001a\u00020$2\u0006\u0010+\u001a\u00020'H\u0002J\u0010\u0010.\u001a\u00020$2\u0006\u0010+\u001a\u00020'H\u0002J\u001e\u0010/\u001a\u00020\u00052\f\u00100\u001a\b\u0012\u0004\u0012\u00020\u00050\r2\u0006\u00101\u001a\u00020\u0005H\u0002J\u001e\u00102\u001a\u0002032\u0006\u00104\u001a\u0002052\f\b\u0002\u00106\u001a\u000607j\u0002`8H\u0002J.\u00109\u001a\u0002032\u0006\u00104\u001a\u0002052\u0006\u0010:\u001a\u00020\u00172\u0006\u0010;\u001a\u00020\u00172\f\b\u0002\u00106\u001a\u000607j\u0002`8H\u0002J\u0010\u0010<\u001a\u00020\u00052\u0006\u0010=\u001a\u00020\u0005H\u0002J\u0010\u0010P\u001a\u00020$2\u0006\u0010Q\u001a\u00020\u0005H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0080T\u00a2\u0006\u0002\n\u0000R\u001a\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00050\tX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u001a\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00050\rX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u001a\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00050\rX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u000fR\u001a\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00050\rX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u000fR\u000e\u0010\u0014\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0017X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010>\u001a\u00020?X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010@\u001a\u00020A8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010B\u001a\u00020A8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010C\u001a\u00020A8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010D\u001a\u00020A8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010E\u001a\u00020AX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010F\u001a\u00020A8\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u0012\u0004\bG\u0010\u0003R\u0010\u0010H\u001a\u00020A8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010I\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010J\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010K\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010L\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010M\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010N\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u0014\u0010O\u001a\b\u0012\u0004\u0012\u00020\u00050\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\\"}, d2={"Lcom/android/tools/lint/checks/AppLinksValidDetector$Companion;", "", "<init>", "()V", "ACTION_VIEW", "", "CATEGORY_BROWSABLE", "CATEGORY_DEFAULT", "IMPLICIT_SCHEMES", "", "getIMPLICIT_SCHEMES$lint_checks", "()Ljava/util/Set;", "PATH_ATTRIBUTES", "", "getPATH_ATTRIBUTES$lint_checks", "()Ljava/util/List;", "QUERY_ATTRIBUTES", "getQUERY_ATTRIBUTES$lint_checks", "FRAGMENT_ATTRIBUTES", "getFRAGMENT_ATTRIBUTES$lint_checks", "HTTP", "HTTPS", "DEFAULT_INDENT_AMOUNT", "", "indentation", "indentAmount", "replaceUrlWithValue", "context", "Lcom/android/tools/lint/detector/api/XmlContext;", "str", "attrToAndroidPatternMatcher", "attr", "attrToAndroidPatternMatcher$lint_checks", "androidPatternMatcherToAttr", "androidPatternMatcherConstant", "isWebScheme", "", "scheme", "getIntentFilterData", "Lcom/android/tools/lint/checks/AppLinksValidDetector$Companion$IntentFilterData;", "intentFilter", "Lcom/android/tools/lint/checks/AppLinksValidDetector$Companion$TagWrapper;", "hasAutoVerifyButInvalidAppLink", "data", "hasElementsRequiredForAppLinks", "hasNoElementsForbiddenForAppLinks", "isValidAppLink", "concatenateWithIndent", "inputs", "newLineAndIndentString", "copyTagWithAttributes", "", "element", "Lorg/w3c/dom/Element;", "sb", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "recursivelyCopy", "startingIndentAmount", "indentDiff", "xmlEscape", "s", "IMPLEMENTATION", "Lcom/android/tools/lint/detector/api/Implementation;", "TEST_URL", "Lcom/android/tools/lint/detector/api/Issue;", "VALIDATION", "URI_RELATIVE_FILTER_GROUP", "APP_LINK_WARNING", "_OLD_ISSUE_URL", "INTENT_FILTER_UNIQUE_DATA_ATTRIBUTES", "getINTENT_FILTER_UNIQUE_DATA_ATTRIBUTES$annotations", "APP_LINK_SPLIT_TO_WEB_AND_CUSTOM", "TAG_VALIDATION", "KEY_SPLIT_TO_WEB_AND_CUSTOM_NAME_LOCATION", "KEY_SPLIT_TO_WEB_AND_CUSTOM_REPLACEMENT_RANGE", "KEY_SPLIT_TO_WEB_AND_CUSTOM_REPLACEMENT_TEXT", "KEY_SPLIT_TO_WEB_AND_CUSTOM_HOSTS", "KEY_SHOW_APP_LINKS_ASSISTANT", "INTENT_FILTER_DATA_SORT_REFERENCE", "isSubstituted", "expression", "Path", "Query", "Fragment", "TagWrapper", "AttributeWrapper", "ElementWrapper", "AttrWrapper", "IntentFilterData", "DataTagInfo", "UriRelativeFilterGroup", "lint-checks"})
    @SourceDebugExtension(value={"SMAP\nAppLinksValidDetector.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AppLinksValidDetector.kt\ncom/android/tools/lint/checks/AppLinksValidDetector$Companion\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,2047:1\n1#2:2048\n1761#3,3:2049\n1740#3,3:2052\n*S KotlinDebug\n*F\n+ 1 AppLinksValidDetector.kt\ncom/android/tools/lint/checks/AppLinksValidDetector$Companion\n*L\n1764#1:2049,3\n1769#1:2052,3\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Set<String> getIMPLICIT_SCHEMES$lint_checks() {
            return IMPLICIT_SCHEMES;
        }

        @NotNull
        public final List<String> getPATH_ATTRIBUTES$lint_checks() {
            return PATH_ATTRIBUTES;
        }

        @NotNull
        public final List<String> getQUERY_ATTRIBUTES$lint_checks() {
            return QUERY_ATTRIBUTES;
        }

        @NotNull
        public final List<String> getFRAGMENT_ATTRIBUTES$lint_checks() {
            return FRAGMENT_ATTRIBUTES;
        }

        private final String indentation(int indentAmount) {
            return StringsKt.repeat((CharSequence)" ", (int)indentAmount);
        }

        private final String replaceUrlWithValue(XmlContext context, String str2) {
            String string;
            if (context == null) {
                return str2;
            }
            LintClient client = context.getClient();
            ResourceUrl url = ResourceUrl.parse((String)str2);
            if (url == null || url.isFramework()) {
                return str2;
            }
            Project project = context.getProject();
            ResourceRepository resources = client.getResources(project, ResourceRepositoryScope.ALL_DEPENDENCIES);
            List items = resources.getResources(ResourceNamespace.TODO(), url.type, url.name);
            if (items.isEmpty()) {
                return str2;
            }
            ResourceValue resourceValue = ((ResourceItem)items.get(0)).getResourceValue();
            if (resourceValue == null) {
                return str2;
            }
            ResourceValue resourceValue2 = resourceValue;
            if (resourceValue2.getValue() == null) {
                string = str2;
            } else {
                String string2 = resourceValue2.getValue();
                string = string2;
                Intrinsics.checkNotNull((Object)string2);
            }
            return string;
        }

        public final int attrToAndroidPatternMatcher$lint_checks(@NotNull String attr) {
            int n;
            Intrinsics.checkNotNullParameter((Object)attr, (String)"attr");
            switch (attr) {
                case "query": 
                case "path": 
                case "fragment": {
                    n = 0;
                    break;
                }
                case "pathPrefix": 
                case "queryPrefix": 
                case "fragmentPrefix": {
                    n = 1;
                    break;
                }
                case "queryPattern": 
                case "fragmentPattern": 
                case "pathPattern": {
                    n = 2;
                    break;
                }
                case "pathAdvancedPattern": 
                case "fragmentAdvancedPattern": 
                case "queryAdvancedPattern": {
                    n = 3;
                    break;
                }
                case "querySuffix": 
                case "fragmentSuffix": 
                case "pathSuffix": {
                    n = 4;
                    break;
                }
                default: {
                    throw new AssertionError((Object)("Input was required to be one of the <data> path attributes, but was " + attr));
                }
            }
            return n;
        }

        @NotNull
        public final String androidPatternMatcherToAttr(int androidPatternMatcherConstant) {
            String string;
            switch (androidPatternMatcherConstant) {
                case 0: {
                    string = "path";
                    break;
                }
                case 1: {
                    string = "pathPrefix";
                    break;
                }
                case 2: {
                    string = "pathPattern";
                    break;
                }
                case 3: {
                    string = "pathAdvancedPattern";
                    break;
                }
                case 4: {
                    string = "pathSuffix";
                    break;
                }
                default: {
                    throw new AssertionError((Object)("Input was required to be an AndroidPatternMatcher constant but was " + androidPatternMatcherConstant));
                }
            }
            return string;
        }

        public final boolean isWebScheme(@NotNull String scheme) {
            Intrinsics.checkNotNullParameter((Object)scheme, (String)"scheme");
            return Intrinsics.areEqual((Object)scheme, (Object)AppLinksValidDetector.HTTP) || Intrinsics.areEqual((Object)scheme, (Object)AppLinksValidDetector.HTTPS);
        }

        /*
         * Unable to fully structure code
         */
        @NotNull
        public final IntentFilterData getIntentFilterData(@NotNull TagWrapper intentFilter) {
            Intrinsics.checkNotNullParameter((Object)intentFilter, (String)"intentFilter");
            v0 = intentFilter.getAttributeWrapper("autoVerify");
            autoVerify = v0 != null ? v0.getSubstitutedValue() : null;
            var4_3 = intentFilter.getAttributeWrapper("order");
            if (var4_3 == null || (var5_5 = var4_3.getSubstitutedValue()) == null) ** GOTO lbl-1000
            var7_6 = (CharSequence)var5_5;
            if (var7_6.length() == 0) {
                $i$a$-ifEmpty-AppLinksValidDetector$Companion$getIntentFilterData$order$1 = false;
                v1 = "0";
            } else {
                v1 = var7_6;
            }
            var7_6 = StringsKt.toIntOrNull((String)((String)v1));
            if (var7_6 != null) {
                v2 = var7_6.intValue();
            } else lbl-1000:
            // 2 sources

            {
                v2 = 0;
            }
            order = v2;
            var5_5 = intentFilter.getAttributeWrapper("priority");
            if (var5_5 == null || (var6_11 = var5_5.getSubstitutedValue()) == null) ** GOTO lbl-1000
            $i$a$-ifEmpty-AppLinksValidDetector$Companion$getIntentFilterData$order$1 = var6_11;
            if ($i$a$-ifEmpty-AppLinksValidDetector$Companion$getIntentFilterData$order$1.length() == 0) {
                $i$a$-ifEmpty-AppLinksValidDetector$Companion$getIntentFilterData$priority$1 = false;
                v3 = "0";
            } else {
                v3 = $i$a$-ifEmpty-AppLinksValidDetector$Companion$getIntentFilterData$order$1;
            }
            $i$a$-ifEmpty-AppLinksValidDetector$Companion$getIntentFilterData$order$1 = StringsKt.toIntOrNull((String)((String)v3));
            if ($i$a$-ifEmpty-AppLinksValidDetector$Companion$getIntentFilterData$order$1 != null) {
                v4 = $i$a$-ifEmpty-AppLinksValidDetector$Companion$getIntentFilterData$order$1.intValue();
            } else lbl-1000:
            // 2 sources

            {
                v4 = 0;
            }
            priority = v4;
            actions = new ArrayList<E>();
            categories = new ArrayList<E>();
            dataTagElements = new ArrayList<E>();
            uriRelativeFilterGroups = new ArrayList<E>();
            for (TagWrapper subTag : intentFilter.getSubTags()) {
                var11_15 = subTag.getName();
                tmp = -1;
                switch (var11_15.hashCode()) {
                    case 3076010: {
                        if (var11_15.equals("data")) {
                            tmp = 1;
                        }
                        break;
                    }
                    case -1422950858: {
                        if (var11_15.equals("action")) {
                            tmp = 2;
                        }
                        break;
                    }
                    case -1194267734: {
                        if (var11_15.equals("uri-relative-filter-group")) {
                            tmp = 3;
                        }
                        break;
                    }
                    case 50511102: {
                        if (var11_15.equals("category")) {
                            tmp = 4;
                        }
                        break;
                    }
                }
                switch (tmp) {
                    case 2: {
                        if (subTag.getAttributeWrapper("name") != null) {
                            $i$a$-let-AppLinksValidDetector$Companion$getIntentFilterData$1 = false;
                            actions.add(it);
                        }
                        break;
                    }
                    case 4: {
                        if (subTag.getAttributeWrapper("name") != null) {
                            $i$a$-let-AppLinksValidDetector$Companion$getIntentFilterData$2 = false;
                            categories.add(it);
                        }
                        break;
                    }
                    case 1: {
                        dataTagElements.add(subTag);
                        break;
                    }
                    case 3: {
                        uriRelativeFilterGroups.add(new UriRelativeFilterGroup(subTag));
                    }
                }
            }
            return new IntentFilterData(autoVerify, order, priority, actions, categories, new DataTagInfo(dataTagElements), uriRelativeFilterGroups);
        }

        public final boolean hasAutoVerifyButInvalidAppLink(@NotNull TagWrapper intentFilter) {
            Intrinsics.checkNotNullParameter((Object)intentFilter, (String)"intentFilter");
            return this.hasAutoVerifyButInvalidAppLink(this.getIntentFilterData(intentFilter));
        }

        public final boolean hasAutoVerifyButInvalidAppLink(@NotNull IntentFilterData data) {
            Intrinsics.checkNotNullParameter((Object)data, (String)"data");
            return Intrinsics.areEqual((Object)data.getAutoVerify(), (Object)"true") && (!this.hasElementsRequiredForAppLinks(data) || !this.hasNoElementsForbiddenForAppLinks(data));
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private final boolean hasElementsRequiredForAppLinks(IntentFilterData data) {
            String it;
            if (!data.getActionSet().contains(AppLinksValidDetector.ACTION_VIEW)) return false;
            if (!data.getCategorySet().contains(AppLinksValidDetector.CATEGORY_DEFAULT)) return false;
            if (!data.getCategorySet().contains(AppLinksValidDetector.CATEGORY_BROWSABLE)) return false;
            Iterable $this$any$iv = data.getDataTags().getSchemes();
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                return false;
            }
            Iterator iterator = $this$any$iv.iterator();
            do {
                if (!iterator.hasNext()) return false;
                Object element$iv = iterator.next();
                it = (String)element$iv;
                boolean bl = false;
            } while (!(Companion.isSubstituted(it) || Companion.isWebScheme(it)));
            boolean bl = true;
            if (!bl) return false;
            if (((Collection)data.getDataTags().getHostPortPairs()).isEmpty()) return false;
            return true;
        }

        private final boolean hasNoElementsForbiddenForAppLinks(IntentFilterData data) {
            boolean bl;
            block3: {
                Iterable $this$all$iv = data.getDataTags().getSchemes();
                boolean $i$f$all = false;
                if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                    bl = true;
                } else {
                    for (Object element$iv : $this$all$iv) {
                        String it = (String)element$iv;
                        boolean bl2 = false;
                        if (Companion.isSubstituted(it) || Companion.isWebScheme(it)) continue;
                        bl = false;
                        break block3;
                    }
                    bl = true;
                }
            }
            return bl && data.getDataTags().getMimeTypes().isEmpty();
        }

        private final boolean isValidAppLink(IntentFilterData data) {
            return Intrinsics.areEqual((Object)data.getAutoVerify(), (Object)"true") && this.hasElementsRequiredForAppLinks(data) && this.hasNoElementsForbiddenForAppLinks(data);
        }

        private final String concatenateWithIndent(List<String> inputs, String newLineAndIndentString) {
            return inputs.isEmpty() ? "" : CollectionsKt.joinToString$default((Iterable)inputs, (CharSequence)newLineAndIndentString, (CharSequence)newLineAndIndentString, null, (int)0, null, null, (int)60, null);
        }

        private final void copyTagWithAttributes(Element element, StringBuilder sb) {
            sb.append(element.getTagName());
            int n = element.getAttributes().getLength();
            for (int i = 0; i < n; ++i) {
                Node item = element.getAttributes().item(i);
                sb.append(" ");
                sb.append(item.getNodeName());
                sb.append("=\"");
                sb.append(item.getNodeValue());
                sb.append('\"');
            }
        }

        static /* synthetic */ void copyTagWithAttributes$default(Companion companion, Element element, StringBuilder stringBuilder, int n, Object object) {
            if ((n & 2) != 0) {
                stringBuilder = new StringBuilder();
            }
            companion.copyTagWithAttributes(element, stringBuilder);
        }

        private final void recursivelyCopy(Element element, int startingIndentAmount, int indentDiff, StringBuilder sb) {
            sb.append("<");
            this.copyTagWithAttributes(element, sb);
            if (DomExtensions.subtagCount((Element)element) == 0) {
                sb.append(" />");
                return;
            }
            sb.append(">");
            Iterator iterator = DomExtensions.iterator((Element)element);
            while (iterator.hasNext()) {
                Element subTag = (Element)iterator.next();
                sb.append("\n");
                int n = startingIndentAmount + indentDiff;
                for (int i = 0; i < n; ++i) {
                    sb.append(" ");
                }
                this.recursivelyCopy(subTag, startingIndentAmount + indentDiff, indentDiff, sb);
            }
            sb.append("\n");
            for (int i = 0; i < startingIndentAmount; ++i) {
                sb.append(" ");
            }
            sb.append("</" + element.getTagName() + ">");
        }

        static /* synthetic */ void recursivelyCopy$default(Companion companion, Element element, int n, int n2, StringBuilder stringBuilder, int n3, Object object) {
            if ((n3 & 8) != 0) {
                stringBuilder = new StringBuilder();
            }
            companion.recursivelyCopy(element, n, n2, stringBuilder);
        }

        private final String xmlEscape(String s) {
            String string = XmlUtils.toXmlAttributeValue((String)XmlUtils.fromXmlAttributeValue((String)s));
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toXmlAttributeValue(...)");
            return string;
        }

        public static /* synthetic */ void getINTENT_FILTER_UNIQUE_DATA_ATTRIBUTES$annotations() {
        }

        private final boolean isSubstituted(String expression) {
            return Lint.isDataBindingExpression((String)expression) || Lint.isManifestPlaceHolderExpression((String)expression);
        }

        public static final /* synthetic */ void access$copyTagWithAttributes(Companion $this, Element element, StringBuilder sb) {
            $this.copyTagWithAttributes(element, sb);
        }

        public static final /* synthetic */ String access$xmlEscape(Companion $this, String s) {
            return $this.xmlEscape(s);
        }

        public static final /* synthetic */ void access$recursivelyCopy(Companion $this, Element element, int startingIndentAmount, int indentDiff, StringBuilder sb) {
            $this.recursivelyCopy(element, startingIndentAmount, indentDiff, sb);
        }

        public static final /* synthetic */ String access$replaceUrlWithValue(Companion $this, XmlContext context, String str2) {
            return $this.replaceUrlWithValue(context, str2);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\n\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\u00020\u000bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u001d\u0010\u000e\u001a\u0004\u0018\u00010\u000b8VX\u0096\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0010\u0010\u0011\u001a\u0004\b\u000f\u0010\rR\u001d\u0010\u0012\u001a\u0004\u0018\u00010\u000b8VX\u0096\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0014\u0010\u0011\u001a\u0004\b\u0013\u0010\r\u00a8\u0006\u0015"}, d2={"Lcom/android/tools/lint/checks/AppLinksValidDetector$Companion$AttrWrapper;", "Lcom/android/tools/lint/checks/AppLinksValidDetector$Companion$AttributeWrapper;", "attr", "Lorg/w3c/dom/Attr;", "context", "Lcom/android/tools/lint/detector/api/Context;", "<init>", "(Lorg/w3c/dom/Attr;Lcom/android/tools/lint/detector/api/Context;)V", "getAttr", "()Lorg/w3c/dom/Attr;", "name", "", "getName", "()Ljava/lang/String;", "rawValue", "getRawValue", "rawValue$delegate", "Lkotlin/Lazy;", "substitutedValue", "getSubstitutedValue", "substitutedValue$delegate", "lint-checks"})
        public static final class AttrWrapper
        implements AttributeWrapper {
            @NotNull
            private final Attr attr;
            @NotNull
            private final Context context;
            @NotNull
            private final String name;
            @NotNull
            private final Lazy rawValue$delegate;
            @NotNull
            private final Lazy substitutedValue$delegate;

            public AttrWrapper(@NotNull Attr attr, @NotNull Context context) {
                Intrinsics.checkNotNullParameter((Object)attr, (String)"attr");
                Intrinsics.checkNotNullParameter((Object)context, (String)"context");
                this.attr = attr;
                this.context = context;
                String string = this.attr.getLocalName();
                if (string == null && (string = this.attr.getName()) == null) {
                    string = "";
                }
                this.name = string;
                this.rawValue$delegate = LazyKt.lazy((LazyThreadSafetyMode)LazyThreadSafetyMode.NONE, (Function0)((Function0)new Function0<String>(this){
                    final /* synthetic */ AttrWrapper this$0;
                    {
                        this.this$0 = $receiver;
                        super(0);
                    }

                    public final String invoke() {
                        String string;
                        String string2 = this.this$0.getAttr().getValue();
                        if (string2 != null) {
                            String it = string2;
                            boolean bl = false;
                            string = com.android.tools.lint.checks.AppLinksValidDetector$Companion.access$xmlEscape(AppLinksValidDetector.Companion, it);
                        } else {
                            string = null;
                        }
                        return string;
                    }
                }));
                this.substitutedValue$delegate = LazyKt.lazy((LazyThreadSafetyMode)LazyThreadSafetyMode.NONE, (Function0)((Function0)new Function0<String>(this){
                    final /* synthetic */ AttrWrapper this$0;
                    {
                        this.this$0 = $receiver;
                        super(0);
                    }

                    public final String invoke() {
                        String string = this.this$0.getAttr().getValue();
                        if (string == null) {
                            return null;
                        }
                        String attrValue = string;
                        String value = com.android.tools.lint.checks.AppLinksValidDetector$Companion.access$xmlEscape(AppLinksValidDetector.Companion, attrValue);
                        if (!(AttrWrapper.access$getContext$p(this.this$0) instanceof XmlContext)) {
                            return value;
                        }
                        if (StringsKt.startsWith$default((String)value, (String)"@", (boolean)false, (int)2, null) || StringsKt.startsWith$default((String)value, (String)"?", (boolean)false, (int)2, null)) {
                            return com.android.tools.lint.checks.AppLinksValidDetector$Companion.access$replaceUrlWithValue(AppLinksValidDetector.Companion, (XmlContext)AttrWrapper.access$getContext$p(this.this$0), value);
                        }
                        String string2 = Lint.resolvePlaceHolders$default((Project)AttrWrapper.access$getContext$p(this.this$0).getProject(), (String)value, null, null, (int)12, null);
                        if (string2 == null) {
                            string2 = value;
                        }
                        return string2;
                    }
                }));
            }

            @NotNull
            public final Attr getAttr() {
                return this.attr;
            }

            @Override
            @NotNull
            public String getName() {
                return this.name;
            }

            @Override
            @Nullable
            public String getRawValue() {
                Lazy lazy = this.rawValue$delegate;
                return (String)lazy.getValue();
            }

            @Override
            @Nullable
            public String getSubstitutedValue() {
                Lazy lazy = this.substitutedValue$delegate;
                return (String)lazy.getValue();
            }

            public static final /* synthetic */ Context access$getContext$p(AttrWrapper $this) {
                return $this.context;
            }
        }

        @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0007\bf\u0018\u00002\u00020\u0001R\u0012\u0010\u0002\u001a\u00020\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0004\u0010\u0005R\u0014\u0010\u0006\u001a\u0004\u0018\u00010\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\u0005R\u0014\u0010\b\u001a\u0004\u0018\u00010\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\u0005\u00a8\u0006\n\u00c0\u0006\u0003"}, d2={"Lcom/android/tools/lint/checks/AppLinksValidDetector$Companion$AttributeWrapper;", "", "name", "", "getName", "()Ljava/lang/String;", "rawValue", "getRawValue", "substitutedValue", "getSubstitutedValue", "lint-checks"})
        public static interface AttributeWrapper {
            @NotNull
            public String getName();

            @Nullable
            public String getRawValue();

            @Nullable
            public String getSubstitutedValue();
        }

        @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0010\u001c\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010#\n\u0002\u0010\u000e\n\u0002\b\r\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u000f\n\u0002\u0010(\n\u0002\b\u0004\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0015\u0012\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u000f\u0010:\u001a\b\u0012\u0004\u0012\u00020\u00020;H\u0096\u0002J\u000f\u0010<\u001a\b\u0012\u0004\u0012\u00020\u00020\u0004H\u00c6\u0003J\u0019\u0010=\u001a\u00020\u00002\u000e\b\u0002\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00020\u0004H\u00c6\u0001J\u0013\u0010>\u001a\u00020\n2\b\u0010?\u001a\u0004\u0018\u00010@H\u00d6\u0003J\t\u0010A\u001a\u00020BH\u00d6\u0001J\t\u0010C\u001a\u00020\u0013H\u00d6\u0001R\u0017\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\u000bR!\u0010\f\u001a\b\u0012\u0004\u0012\u00020\r0\u00048FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u000f\u0010\u0010\u001a\u0004\b\u000e\u0010\bR!\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u00128FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0016\u0010\u0010\u001a\u0004\b\u0014\u0010\u0015R!\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00130\u00128FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0019\u0010\u0010\u001a\u0004\b\u0018\u0010\u0015R!\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\r0\u00048FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u001c\u0010\u0010\u001a\u0004\b\u001b\u0010\bR!\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\r0\u00048FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u001f\u0010\u0010\u001a\u0004\b\u001e\u0010\bR/\u0010 \u001a\u0016\u0012\u0012\u0012\u0010\u0012\u0004\u0012\u00020\u0013\u0012\u0006\u0012\u0004\u0018\u00010\u00130!0\u00128FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b#\u0010\u0010\u001a\u0004\b\"\u0010\u0015R/\u0010$\u001a\u0016\u0012\u0012\u0012\u0010\u0012\u0004\u0012\u00020\u0013\u0012\u0006\u0012\u0004\u0018\u00010\u00130!0\u00048FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b&\u0010\u0010\u001a\u0004\b%\u0010\bR!\u0010'\u001a\b\u0012\u0004\u0012\u00020\r0\u00128FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b)\u0010\u0010\u001a\u0004\b(\u0010\u0015R!\u0010*\u001a\b\u0012\u0004\u0012\u00020+0\u00128FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b-\u0010\u0010\u001a\u0004\b,\u0010\u0015R!\u0010.\u001a\b\u0012\u0004\u0012\u00020+0\u00128FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b0\u0010\u0010\u001a\u0004\b/\u0010\u0015R!\u00101\u001a\b\u0012\u0004\u0012\u00020\r0\u00048FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b3\u0010\u0010\u001a\u0004\b2\u0010\bR!\u00104\u001a\b\u0012\u0004\u0012\u00020\u00130\u00128FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b6\u0010\u0010\u001a\u0004\b5\u0010\u0015R!\u00107\u001a\b\u0012\u0004\u0012\u00020\u00130\u00128FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b9\u0010\u0010\u001a\u0004\b8\u0010\u0015\u00a8\u0006D"}, d2={"Lcom/android/tools/lint/checks/AppLinksValidDetector$Companion$DataTagInfo;", "", "Lcom/android/tools/lint/checks/AppLinksValidDetector$Companion$TagWrapper;", "dataTagElements", "", "<init>", "(Ljava/util/List;)V", "getDataTagElements", "()Ljava/util/List;", "isEmpty", "", "()Z", "schemeElements", "Lcom/android/tools/lint/checks/AppLinksValidDetector$Companion$AttributeWrapper;", "getSchemeElements", "schemeElements$delegate", "Lkotlin/Lazy;", "schemes", "", "", "getSchemes", "()Ljava/util/Set;", "schemes$delegate", "rawSchemes", "getRawSchemes", "rawSchemes$delegate", "hostElements", "getHostElements", "hostElements$delegate", "portElements", "getPortElements", "portElements$delegate", "hostPortPairs", "Lkotlin/Pair;", "getHostPortPairs", "hostPortPairs$delegate", "rawHostPortPairs", "getRawHostPortPairs", "rawHostPortPairs$delegate", "pathElements", "getPathElements", "pathElements$delegate", "paths", "Lcom/android/tools/lint/checks/AppLinksValidDetector$Companion$Path;", "getPaths", "paths$delegate", "rawPaths", "getRawPaths", "rawPaths$delegate", "mimeTypeElements", "getMimeTypeElements", "mimeTypeElements$delegate", "mimeTypes", "getMimeTypes", "mimeTypes$delegate", "rawMimeTypes", "getRawMimeTypes", "rawMimeTypes$delegate", "iterator", "", "component1", "copy", "equals", "other", "", "hashCode", "", "toString", "lint-checks"})
        public static final class DataTagInfo
        implements Iterable<TagWrapper>,
        KMappedMarker {
            @NotNull
            private final List<TagWrapper> dataTagElements;
            private final boolean isEmpty;
            @NotNull
            private final Lazy schemeElements$delegate;
            @NotNull
            private final Lazy schemes$delegate;
            @NotNull
            private final Lazy rawSchemes$delegate;
            @NotNull
            private final Lazy hostElements$delegate;
            @NotNull
            private final Lazy portElements$delegate;
            @NotNull
            private final Lazy hostPortPairs$delegate;
            @NotNull
            private final Lazy rawHostPortPairs$delegate;
            @NotNull
            private final Lazy pathElements$delegate;
            @NotNull
            private final Lazy paths$delegate;
            @NotNull
            private final Lazy rawPaths$delegate;
            @NotNull
            private final Lazy mimeTypeElements$delegate;
            @NotNull
            private final Lazy mimeTypes$delegate;
            @NotNull
            private final Lazy rawMimeTypes$delegate;

            public DataTagInfo(@NotNull List<? extends TagWrapper> dataTagElements) {
                Intrinsics.checkNotNullParameter(dataTagElements, (String)"dataTagElements");
                this.dataTagElements = dataTagElements;
                this.isEmpty = this.dataTagElements.isEmpty();
                this.schemeElements$delegate = LazyKt.lazy((LazyThreadSafetyMode)LazyThreadSafetyMode.NONE, (Function0)((Function0)new Function0<List<? extends AttributeWrapper>>(this){
                    final /* synthetic */ DataTagInfo this$0;
                    {
                        this.this$0 = $receiver;
                        super(0);
                    }

                    /*
                     * WARNING - void declaration
                     */
                    public final List<AttributeWrapper> invoke() {
                        void $this$mapNotNullTo$iv$iv;
                        Iterable $this$mapNotNull$iv = this.this$0.getDataTagElements();
                        boolean $i$f$mapNotNull = false;
                        Iterable iterable = $this$mapNotNull$iv;
                        Collection destination$iv$iv = new ArrayList<E>();
                        boolean $i$f$mapNotNullTo = false;
                        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
                        boolean $i$f$forEach = false;
                        Iterator<T> iterator = $this$forEach$iv$iv$iv.iterator();
                        while (iterator.hasNext()) {
                            AttributeWrapper it$iv$iv;
                            T element$iv$iv$iv;
                            T element$iv$iv = element$iv$iv$iv = iterator.next();
                            boolean bl = false;
                            TagWrapper it = (TagWrapper)element$iv$iv;
                            boolean bl2 = false;
                            if (it.getAttributeWrapper("scheme") == null) continue;
                            boolean bl3 = false;
                            destination$iv$iv.add(it$iv$iv);
                        }
                        return (List)destination$iv$iv;
                    }
                }));
                this.schemes$delegate = LazyKt.lazy((LazyThreadSafetyMode)LazyThreadSafetyMode.NONE, (Function0)((Function0)new Function0<Set<String>>(this){
                    final /* synthetic */ DataTagInfo this$0;
                    {
                        this.this$0 = $receiver;
                        super(0);
                    }

                    /*
                     * WARNING - void declaration
                     */
                    public final Set<String> invoke() {
                        void var2_2;
                        void $this$mapNotNullTo$iv;
                        Iterable iterable = this.this$0.getSchemeElements();
                        Collection destination$iv = new LinkedHashSet<E>();
                        boolean $i$f$mapNotNullTo = false;
                        void $this$forEach$iv$iv = $this$mapNotNullTo$iv;
                        boolean $i$f$forEach = false;
                        Iterator<T> iterator = $this$forEach$iv$iv.iterator();
                        while (iterator.hasNext()) {
                            String it$iv;
                            T element$iv$iv;
                            T element$iv = element$iv$iv = iterator.next();
                            boolean bl = false;
                            AttributeWrapper it = (AttributeWrapper)element$iv;
                            boolean bl2 = false;
                            if (it.getSubstitutedValue() == null) continue;
                            boolean bl3 = false;
                            destination$iv.add(it$iv);
                        }
                        return (Set)var2_2;
                    }
                }));
                this.rawSchemes$delegate = LazyKt.lazy((LazyThreadSafetyMode)LazyThreadSafetyMode.NONE, (Function0)((Function0)new Function0<Set<String>>(this){
                    final /* synthetic */ DataTagInfo this$0;
                    {
                        this.this$0 = $receiver;
                        super(0);
                    }

                    /*
                     * WARNING - void declaration
                     */
                    public final Set<String> invoke() {
                        void var2_2;
                        void $this$mapNotNullTo$iv;
                        Iterable iterable = this.this$0.getSchemeElements();
                        Collection destination$iv = new LinkedHashSet<E>();
                        boolean $i$f$mapNotNullTo = false;
                        void $this$forEach$iv$iv = $this$mapNotNullTo$iv;
                        boolean $i$f$forEach = false;
                        Iterator<T> iterator = $this$forEach$iv$iv.iterator();
                        while (iterator.hasNext()) {
                            String it$iv;
                            T element$iv$iv;
                            T element$iv = element$iv$iv = iterator.next();
                            boolean bl = false;
                            AttributeWrapper it = (AttributeWrapper)element$iv;
                            boolean bl2 = false;
                            if (it.getRawValue() == null) continue;
                            boolean bl3 = false;
                            destination$iv.add(it$iv);
                        }
                        return (Set)var2_2;
                    }
                }));
                this.hostElements$delegate = LazyKt.lazy((LazyThreadSafetyMode)LazyThreadSafetyMode.NONE, (Function0)((Function0)new Function0<List<? extends AttributeWrapper>>(this){
                    final /* synthetic */ DataTagInfo this$0;
                    {
                        this.this$0 = $receiver;
                        super(0);
                    }

                    /*
                     * WARNING - void declaration
                     */
                    public final List<AttributeWrapper> invoke() {
                        void $this$mapNotNullTo$iv$iv;
                        Iterable $this$mapNotNull$iv = this.this$0.getDataTagElements();
                        boolean $i$f$mapNotNull = false;
                        Iterable iterable = $this$mapNotNull$iv;
                        Collection destination$iv$iv = new ArrayList<E>();
                        boolean $i$f$mapNotNullTo = false;
                        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
                        boolean $i$f$forEach = false;
                        Iterator<T> iterator = $this$forEach$iv$iv$iv.iterator();
                        while (iterator.hasNext()) {
                            AttributeWrapper it$iv$iv;
                            T element$iv$iv$iv;
                            T element$iv$iv = element$iv$iv$iv = iterator.next();
                            boolean bl = false;
                            TagWrapper it = (TagWrapper)element$iv$iv;
                            boolean bl2 = false;
                            if (it.getAttributeWrapper("host") == null) continue;
                            boolean bl3 = false;
                            destination$iv$iv.add(it$iv$iv);
                        }
                        return (List)destination$iv$iv;
                    }
                }));
                this.portElements$delegate = LazyKt.lazy((LazyThreadSafetyMode)LazyThreadSafetyMode.NONE, (Function0)((Function0)new Function0<List<? extends AttributeWrapper>>(this){
                    final /* synthetic */ DataTagInfo this$0;
                    {
                        this.this$0 = $receiver;
                        super(0);
                    }

                    /*
                     * WARNING - void declaration
                     */
                    public final List<AttributeWrapper> invoke() {
                        void $this$mapNotNullTo$iv$iv;
                        Iterable $this$mapNotNull$iv = this.this$0.getDataTagElements();
                        boolean $i$f$mapNotNull = false;
                        Iterable iterable = $this$mapNotNull$iv;
                        Collection destination$iv$iv = new ArrayList<E>();
                        boolean $i$f$mapNotNullTo = false;
                        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
                        boolean $i$f$forEach = false;
                        Iterator<T> iterator = $this$forEach$iv$iv$iv.iterator();
                        while (iterator.hasNext()) {
                            AttributeWrapper it$iv$iv;
                            T element$iv$iv$iv;
                            T element$iv$iv = element$iv$iv$iv = iterator.next();
                            boolean bl = false;
                            TagWrapper it = (TagWrapper)element$iv$iv;
                            boolean bl2 = false;
                            if (it.getAttributeWrapper("port") == null) continue;
                            boolean bl3 = false;
                            destination$iv$iv.add(it$iv$iv);
                        }
                        return (List)destination$iv$iv;
                    }
                }));
                this.hostPortPairs$delegate = LazyKt.lazy((LazyThreadSafetyMode)LazyThreadSafetyMode.NONE, (Function0)((Function0)new Function0<Set<Pair<? extends String, ? extends String>>>(this){
                    final /* synthetic */ DataTagInfo this$0;
                    {
                        this.this$0 = $receiver;
                        super(0);
                    }

                    /*
                     * WARNING - void declaration
                     */
                    public final Set<Pair<String, String>> invoke() {
                        void var2_2;
                        void $this$mapNotNullTo$iv;
                        Iterable iterable = this.this$0.getDataTagElements();
                        Collection destination$iv = new LinkedHashSet<E>();
                        boolean $i$f$mapNotNullTo = false;
                        void $this$forEach$iv$iv = $this$mapNotNullTo$iv;
                        boolean $i$f$forEach = false;
                        Iterator<T> iterator = $this$forEach$iv$iv.iterator();
                        while (iterator.hasNext()) {
                            Pair pair;
                            T element$iv$iv;
                            T element$iv = element$iv$iv = iterator.next();
                            boolean bl = false;
                            TagWrapper it = (TagWrapper)element$iv;
                            boolean bl2 = false;
                            Object object = it.getAttributeWrapper("host");
                            if (object == null || (object = object.getSubstitutedValue()) == null) {
                                pair = null;
                            } else {
                                Object host = object;
                                AttributeWrapper attributeWrapper = it.getAttributeWrapper("port");
                                pair = new Pair(host, (Object)(attributeWrapper != null ? attributeWrapper.getSubstitutedValue() : null));
                            }
                            if (pair == null) continue;
                            Pair it$iv = pair;
                            boolean bl3 = false;
                            destination$iv.add(it$iv);
                        }
                        return (Set)var2_2;
                    }
                }));
                this.rawHostPortPairs$delegate = LazyKt.lazy((LazyThreadSafetyMode)LazyThreadSafetyMode.NONE, (Function0)((Function0)new Function0<List<? extends Pair<? extends String, ? extends String>>>(this){
                    final /* synthetic */ DataTagInfo this$0;
                    {
                        this.this$0 = $receiver;
                        super(0);
                    }

                    /*
                     * WARNING - void declaration
                     */
                    public final List<Pair<String, String>> invoke() {
                        void $this$mapNotNullTo$iv$iv;
                        Iterable $this$mapNotNull$iv = this.this$0.getDataTagElements();
                        boolean $i$f$mapNotNull = false;
                        Iterable iterable = $this$mapNotNull$iv;
                        Collection destination$iv$iv = new ArrayList<E>();
                        boolean $i$f$mapNotNullTo = false;
                        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
                        boolean $i$f$forEach = false;
                        Iterator<T> iterator = $this$forEach$iv$iv$iv.iterator();
                        while (iterator.hasNext()) {
                            Pair pair;
                            T element$iv$iv$iv;
                            T element$iv$iv = element$iv$iv$iv = iterator.next();
                            boolean bl = false;
                            TagWrapper it = (TagWrapper)element$iv$iv;
                            boolean bl2 = false;
                            Object object = it.getAttributeWrapper("host");
                            if (object == null || (object = object.getRawValue()) == null) {
                                pair = null;
                            } else {
                                Object host = object;
                                AttributeWrapper attributeWrapper = it.getAttributeWrapper("port");
                                pair = new Pair(host, (Object)(attributeWrapper != null ? attributeWrapper.getRawValue() : null));
                            }
                            if (pair == null) continue;
                            Pair it$iv$iv = pair;
                            boolean bl3 = false;
                            destination$iv$iv.add(it$iv$iv);
                        }
                        return (List)destination$iv$iv;
                    }
                }));
                this.pathElements$delegate = LazyKt.lazy((LazyThreadSafetyMode)LazyThreadSafetyMode.NONE, (Function0)((Function0)new Function0<Set<AttributeWrapper>>(this){
                    final /* synthetic */ DataTagInfo this$0;
                    {
                        this.this$0 = $receiver;
                        super(0);
                    }

                    public final Set<AttributeWrapper> invoke() {
                        Set result = new LinkedHashSet<E>();
                        for (TagWrapper subTag : this.this$0.getDataTagElements()) {
                            for (String value : AppLinksValidDetector.Companion.getPATH_ATTRIBUTES$lint_checks()) {
                                AttributeWrapper it;
                                if (subTag.getAttributeWrapper(value) == null) continue;
                                boolean bl = false;
                                result.add(it);
                            }
                        }
                        return result;
                    }
                }));
                this.paths$delegate = LazyKt.lazy((LazyThreadSafetyMode)LazyThreadSafetyMode.NONE, (Function0)((Function0)new Function0<Set<Path>>(this){
                    final /* synthetic */ DataTagInfo this$0;
                    {
                        this.this$0 = $receiver;
                        super(0);
                    }

                    /*
                     * WARNING - void declaration
                     */
                    public final Set<Path> invoke() {
                        void var2_2;
                        void $this$mapNotNullTo$iv;
                        Iterable iterable = this.this$0.getPathElements();
                        Collection destination$iv = new LinkedHashSet<E>();
                        boolean $i$f$mapNotNullTo = false;
                        void $this$forEach$iv$iv = $this$mapNotNullTo$iv;
                        boolean $i$f$forEach = false;
                        Iterator<T> iterator = $this$forEach$iv$iv.iterator();
                        while (iterator.hasNext()) {
                            Path path;
                            T element$iv$iv;
                            T element$iv = element$iv$iv = iterator.next();
                            boolean bl = false;
                            AttributeWrapper attr = (AttributeWrapper)element$iv;
                            boolean bl2 = false;
                            if (attr.getSubstitutedValue() != null) {
                                String it;
                                boolean bl3 = false;
                                path = new Path(it, attr.getName());
                            } else {
                                path = null;
                            }
                            if (path == null) continue;
                            Path it$iv = path;
                            boolean bl4 = false;
                            destination$iv.add(it$iv);
                        }
                        return (Set)var2_2;
                    }
                }));
                this.rawPaths$delegate = LazyKt.lazy((LazyThreadSafetyMode)LazyThreadSafetyMode.NONE, (Function0)((Function0)new Function0<Set<Path>>(this){
                    final /* synthetic */ DataTagInfo this$0;
                    {
                        this.this$0 = $receiver;
                        super(0);
                    }

                    /*
                     * WARNING - void declaration
                     */
                    public final Set<Path> invoke() {
                        void var2_2;
                        void $this$mapNotNullTo$iv;
                        Iterable iterable = this.this$0.getPathElements();
                        Collection destination$iv = new LinkedHashSet<E>();
                        boolean $i$f$mapNotNullTo = false;
                        void $this$forEach$iv$iv = $this$mapNotNullTo$iv;
                        boolean $i$f$forEach = false;
                        Iterator<T> iterator = $this$forEach$iv$iv.iterator();
                        while (iterator.hasNext()) {
                            Path path;
                            T element$iv$iv;
                            T element$iv = element$iv$iv = iterator.next();
                            boolean bl = false;
                            AttributeWrapper attr = (AttributeWrapper)element$iv;
                            boolean bl2 = false;
                            if (attr.getRawValue() != null) {
                                String it;
                                boolean bl3 = false;
                                path = new Path(it, attr.getName());
                            } else {
                                path = null;
                            }
                            if (path == null) continue;
                            Path it$iv = path;
                            boolean bl4 = false;
                            destination$iv.add(it$iv);
                        }
                        return (Set)var2_2;
                    }
                }));
                this.mimeTypeElements$delegate = LazyKt.lazy((LazyThreadSafetyMode)LazyThreadSafetyMode.NONE, (Function0)((Function0)new Function0<List<? extends AttributeWrapper>>(this){
                    final /* synthetic */ DataTagInfo this$0;
                    {
                        this.this$0 = $receiver;
                        super(0);
                    }

                    /*
                     * WARNING - void declaration
                     */
                    public final List<AttributeWrapper> invoke() {
                        void $this$mapNotNullTo$iv$iv;
                        Iterable $this$mapNotNull$iv = this.this$0.getDataTagElements();
                        boolean $i$f$mapNotNull = false;
                        Iterable iterable = $this$mapNotNull$iv;
                        Collection destination$iv$iv = new ArrayList<E>();
                        boolean $i$f$mapNotNullTo = false;
                        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
                        boolean $i$f$forEach = false;
                        Iterator<T> iterator = $this$forEach$iv$iv$iv.iterator();
                        while (iterator.hasNext()) {
                            AttributeWrapper it$iv$iv;
                            T element$iv$iv$iv;
                            T element$iv$iv = element$iv$iv$iv = iterator.next();
                            boolean bl = false;
                            TagWrapper it = (TagWrapper)element$iv$iv;
                            boolean bl2 = false;
                            if (it.getAttributeWrapper("mimeType") == null) continue;
                            boolean bl3 = false;
                            destination$iv$iv.add(it$iv$iv);
                        }
                        return (List)destination$iv$iv;
                    }
                }));
                this.mimeTypes$delegate = LazyKt.lazy((LazyThreadSafetyMode)LazyThreadSafetyMode.NONE, (Function0)((Function0)new Function0<Set<String>>(this){
                    final /* synthetic */ DataTagInfo this$0;
                    {
                        this.this$0 = $receiver;
                        super(0);
                    }

                    /*
                     * WARNING - void declaration
                     */
                    public final Set<String> invoke() {
                        void var2_2;
                        void $this$mapNotNullTo$iv;
                        Iterable iterable = this.this$0.getMimeTypeElements();
                        Collection destination$iv = new LinkedHashSet<E>();
                        boolean $i$f$mapNotNullTo = false;
                        void $this$forEach$iv$iv = $this$mapNotNullTo$iv;
                        boolean $i$f$forEach = false;
                        Iterator<T> iterator = $this$forEach$iv$iv.iterator();
                        while (iterator.hasNext()) {
                            String it$iv;
                            T element$iv$iv;
                            T element$iv = element$iv$iv = iterator.next();
                            boolean bl = false;
                            AttributeWrapper it = (AttributeWrapper)element$iv;
                            boolean bl2 = false;
                            if (it.getSubstitutedValue() == null) continue;
                            boolean bl3 = false;
                            destination$iv.add(it$iv);
                        }
                        return (Set)var2_2;
                    }
                }));
                this.rawMimeTypes$delegate = LazyKt.lazy((LazyThreadSafetyMode)LazyThreadSafetyMode.NONE, (Function0)((Function0)new Function0<Set<String>>(this){
                    final /* synthetic */ DataTagInfo this$0;
                    {
                        this.this$0 = $receiver;
                        super(0);
                    }

                    /*
                     * WARNING - void declaration
                     */
                    public final Set<String> invoke() {
                        void var2_2;
                        void $this$mapNotNullTo$iv;
                        Iterable iterable = this.this$0.getMimeTypeElements();
                        Collection destination$iv = new LinkedHashSet<E>();
                        boolean $i$f$mapNotNullTo = false;
                        void $this$forEach$iv$iv = $this$mapNotNullTo$iv;
                        boolean $i$f$forEach = false;
                        Iterator<T> iterator = $this$forEach$iv$iv.iterator();
                        while (iterator.hasNext()) {
                            String it$iv;
                            T element$iv$iv;
                            T element$iv = element$iv$iv = iterator.next();
                            boolean bl = false;
                            AttributeWrapper it = (AttributeWrapper)element$iv;
                            boolean bl2 = false;
                            if (it.getRawValue() == null) continue;
                            boolean bl3 = false;
                            destination$iv.add(it$iv);
                        }
                        return (Set)var2_2;
                    }
                }));
            }

            @NotNull
            public final List<TagWrapper> getDataTagElements() {
                return this.dataTagElements;
            }

            public final boolean isEmpty() {
                return this.isEmpty;
            }

            @NotNull
            public final List<AttributeWrapper> getSchemeElements() {
                Lazy lazy = this.schemeElements$delegate;
                return (List)lazy.getValue();
            }

            @NotNull
            public final Set<String> getSchemes() {
                Lazy lazy = this.schemes$delegate;
                return (Set)lazy.getValue();
            }

            @NotNull
            public final Set<String> getRawSchemes() {
                Lazy lazy = this.rawSchemes$delegate;
                return (Set)lazy.getValue();
            }

            @NotNull
            public final List<AttributeWrapper> getHostElements() {
                Lazy lazy = this.hostElements$delegate;
                return (List)lazy.getValue();
            }

            @NotNull
            public final List<AttributeWrapper> getPortElements() {
                Lazy lazy = this.portElements$delegate;
                return (List)lazy.getValue();
            }

            @NotNull
            public final Set<Pair<String, String>> getHostPortPairs() {
                Lazy lazy = this.hostPortPairs$delegate;
                return (Set)lazy.getValue();
            }

            @NotNull
            public final List<Pair<String, String>> getRawHostPortPairs() {
                Lazy lazy = this.rawHostPortPairs$delegate;
                return (List)lazy.getValue();
            }

            @NotNull
            public final Set<AttributeWrapper> getPathElements() {
                Lazy lazy = this.pathElements$delegate;
                return (Set)lazy.getValue();
            }

            @NotNull
            public final Set<Path> getPaths() {
                Lazy lazy = this.paths$delegate;
                return (Set)lazy.getValue();
            }

            @NotNull
            public final Set<Path> getRawPaths() {
                Lazy lazy = this.rawPaths$delegate;
                return (Set)lazy.getValue();
            }

            @NotNull
            public final List<AttributeWrapper> getMimeTypeElements() {
                Lazy lazy = this.mimeTypeElements$delegate;
                return (List)lazy.getValue();
            }

            @NotNull
            public final Set<String> getMimeTypes() {
                Lazy lazy = this.mimeTypes$delegate;
                return (Set)lazy.getValue();
            }

            @NotNull
            public final Set<String> getRawMimeTypes() {
                Lazy lazy = this.rawMimeTypes$delegate;
                return (Set)lazy.getValue();
            }

            @Override
            @NotNull
            public Iterator<TagWrapper> iterator() {
                return this.dataTagElements.iterator();
            }

            @NotNull
            public final List<TagWrapper> component1() {
                return this.dataTagElements;
            }

            @NotNull
            public final DataTagInfo copy(@NotNull List<? extends TagWrapper> dataTagElements) {
                Intrinsics.checkNotNullParameter(dataTagElements, (String)"dataTagElements");
                return new DataTagInfo(dataTagElements);
            }

            public static /* synthetic */ DataTagInfo copy$default(DataTagInfo dataTagInfo2, List list, int n, Object object) {
                if ((n & 1) != 0) {
                    list = dataTagInfo2.dataTagElements;
                }
                return dataTagInfo2.copy(list);
            }

            @NotNull
            public String toString() {
                return "DataTagInfo(dataTagElements=" + this.dataTagElements + ")";
            }

            public int hashCode() {
                return ((Object)this.dataTagElements).hashCode();
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof DataTagInfo)) {
                    return false;
                }
                DataTagInfo dataTagInfo2 = (DataTagInfo)other;
                return Intrinsics.areEqual(this.dataTagElements, dataTagInfo2.dataTagElements);
            }
        }

        @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0012\u0010\u0015\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u0016\u001a\u00020\u000bH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\u00020\u000bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u001a\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00000\u000fX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u001a\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00130\u000fX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0011\u00a8\u0006\u0017"}, d2={"Lcom/android/tools/lint/checks/AppLinksValidDetector$Companion$ElementWrapper;", "Lcom/android/tools/lint/checks/AppLinksValidDetector$Companion$TagWrapper;", "element", "Lorg/w3c/dom/Element;", "context", "Lcom/android/tools/lint/detector/api/Context;", "<init>", "(Lorg/w3c/dom/Element;Lcom/android/tools/lint/detector/api/Context;)V", "getElement", "()Lorg/w3c/dom/Element;", "name", "", "getName", "()Ljava/lang/String;", "subTags", "", "getSubTags", "()Ljava/util/List;", "attributes", "Lcom/android/tools/lint/checks/AppLinksValidDetector$Companion$AttrWrapper;", "getAttributes", "getAttributeWrapper", "attrName", "lint-checks"})
        @SourceDebugExtension(value={"SMAP\nAppLinksValidDetector.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AppLinksValidDetector.kt\ncom/android/tools/lint/checks/AppLinksValidDetector$Companion$ElementWrapper\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,2047:1\n1563#2:2048\n1634#2,3:2049\n1617#2,9:2052\n1869#2:2061\n1870#2:2064\n1626#2:2065\n1#3:2062\n1#3:2063\n*S KotlinDebug\n*F\n+ 1 AppLinksValidDetector.kt\ncom/android/tools/lint/checks/AppLinksValidDetector$Companion$ElementWrapper\n*L\n1382#1:2048\n1382#1:2049,3\n1385#1:2052,9\n1385#1:2061\n1385#1:2064\n1385#1:2065\n1385#1:2063\n*E\n"})
        public static final class ElementWrapper
        implements TagWrapper {
            @NotNull
            private final Element element;
            @NotNull
            private final Context context;
            @NotNull
            private final String name;
            @NotNull
            private final List<ElementWrapper> subTags;
            @NotNull
            private final List<AttrWrapper> attributes;

            /*
             * WARNING - void declaration
             */
            public ElementWrapper(@NotNull Element element, @NotNull Context context) {
                void $this$mapNotNullTo$iv$iv;
                void $this$mapNotNull$iv;
                Object object;
                void $this$mapTo$iv$iv;
                Iterable $this$map$iv;
                Intrinsics.checkNotNullParameter((Object)element, (String)"element");
                Intrinsics.checkNotNullParameter((Object)context, (String)"context");
                this.element = element;
                this.context = context;
                String string = this.element.getTagName();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getTagName(...)");
                this.name = string;
                Iterable iterable = XmlUtils.getSubTags((Node)this.element);
                Intrinsics.checkNotNullExpressionValue((Object)iterable, (String)"getSubTags(...)");
                Iterable iterable2 = iterable;
                ElementWrapper elementWrapper = this;
                boolean $i$f$map = false;
                void var5_6 = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void it;
                    object = (Element)item$iv$iv;
                    Collection collection = destination$iv$iv;
                    boolean bl = false;
                    Intrinsics.checkNotNull((Object)it);
                    collection.add(new ElementWrapper((Element)it, this.context));
                }
                elementWrapper.subTags = (List)destination$iv$iv;
                $this$map$iv = (Iterable)RangesKt.until((int)0, (int)this.element.getAttributes().getLength());
                elementWrapper = this;
                boolean $i$f$mapNotNull = false;
                $this$mapTo$iv$iv = $this$mapNotNull$iv;
                destination$iv$iv = new ArrayList();
                boolean $i$f$mapNotNullTo = false;
                void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
                boolean $i$f$forEach = false;
                object = $this$forEach$iv$iv$iv.iterator();
                while (object.hasNext()) {
                    AttrWrapper attrWrapper;
                    int element$iv$iv$iv;
                    int element$iv$iv = element$iv$iv$iv = ((IntIterator)object).nextInt();
                    boolean bl = false;
                    int idx = element$iv$iv;
                    boolean bl2 = false;
                    Node node = this.element.getAttributes().item(idx);
                    if ((node instanceof Attr ? (Attr)node : null) != null) {
                        Attr it;
                        it = it;
                        boolean bl3 = false;
                        attrWrapper = new AttrWrapper(it, this.context);
                    } else {
                        attrWrapper = null;
                    }
                    if (attrWrapper == null) continue;
                    AttrWrapper it$iv$iv = attrWrapper;
                    boolean bl4 = false;
                    destination$iv$iv.add(it$iv$iv);
                }
                elementWrapper.attributes = (List)destination$iv$iv;
            }

            @NotNull
            public final Element getElement() {
                return this.element;
            }

            @Override
            @NotNull
            public String getName() {
                return this.name;
            }

            @NotNull
            public List<ElementWrapper> getSubTags() {
                return this.subTags;
            }

            @NotNull
            public List<AttrWrapper> getAttributes() {
                return this.attributes;
            }

            @Override
            @Nullable
            public AttrWrapper getAttributeWrapper(@NotNull String attrName) {
                AttrWrapper attrWrapper;
                Intrinsics.checkNotNullParameter((Object)attrName, (String)"attrName");
                Attr attr = this.element.getAttributeNodeNS("http://schemas.android.com/apk/res/android", attrName);
                if (attr != null) {
                    Attr it = attr;
                    boolean bl = false;
                    attrWrapper = new AttrWrapper(it, this.context);
                } else {
                    attrWrapper = null;
                }
                return attrWrapper;
            }
        }

        @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u000f\n\u0000\n\u0002\u0010\u000e\n\u0002\b\b\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0010\u0000\n\u0002\b\u0002\b\u0086\b\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0011\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u0000H\u0096\u0002J\u000e\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0003J\b\u0010\u0011\u001a\u00020\u0003H\u0016J\t\u0010\u0012\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0013\u001a\u00020\u0003H\u00c6\u0003J\u001d\u0010\u0014\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\u0015\u001a\u00020\u000f2\b\u0010\r\u001a\u0004\u0018\u00010\u0016H\u00d6\u0003J\t\u0010\u0017\u001a\u00020\fH\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\bR\u000e\u0010\n\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lcom/android/tools/lint/checks/AppLinksValidDetector$Companion$Fragment;", "", "attributeValue", "", "attributeName", "<init>", "(Ljava/lang/String;Ljava/lang/String;)V", "getAttributeValue", "()Ljava/lang/String;", "getAttributeName", "patternTypeString", "compareTo", "", "other", "match", "", "fragmentString", "toString", "component1", "component2", "copy", "equals", "", "hashCode", "lint-checks"})
        public static final class Fragment
        implements Comparable<Fragment> {
            @NotNull
            private final String attributeValue;
            @NotNull
            private final String attributeName;
            @NotNull
            private final String patternTypeString;

            public Fragment(@NotNull String attributeValue, @NotNull String attributeName) {
                String string;
                Intrinsics.checkNotNullParameter((Object)attributeValue, (String)"attributeValue");
                Intrinsics.checkNotNullParameter((Object)attributeName, (String)"attributeName");
                this.attributeValue = attributeValue;
                switch (this.attributeName = attributeName) {
                    case "fragment": {
                        string = "LITERAL";
                        break;
                    }
                    case "fragmentPrefix": {
                        string = "PREFIX";
                        break;
                    }
                    case "fragmentPattern": {
                        string = "GLOB";
                        break;
                    }
                    case "fragmentAdvancedPattern": {
                        string = "ADVANCED_GLOB";
                        break;
                    }
                    case "fragmentSuffix": {
                        string = "SUFFIX";
                        break;
                    }
                    default: {
                        string = "UNKNOWN";
                    }
                }
                this.patternTypeString = string;
            }

            @NotNull
            public final String getAttributeValue() {
                return this.attributeValue;
            }

            @NotNull
            public final String getAttributeName() {
                return this.attributeName;
            }

            @Override
            public int compareTo(@NotNull Fragment other) {
                Intrinsics.checkNotNullParameter((Object)other, (String)"other");
                Function1[] function1Array = new Function1[]{compareTo.1.INSTANCE, compareTo.2.INSTANCE};
                return ComparisonsKt.compareValuesBy((Object)this, (Object)other, (Function1[])function1Array);
            }

            public final boolean match(@NotNull String fragmentString) {
                Intrinsics.checkNotNullParameter((Object)fragmentString, (String)"fragmentString");
                return new AndroidPatternMatcher(this.attributeValue, Companion.attrToAndroidPatternMatcher$lint_checks(this.attributeName)).match(URLDecoder.decode(fragmentString, Charsets.UTF_8));
            }

            @NotNull
            public String toString() {
                return "UriRelativeFilter { uriPart = FRAGMENT, patternType = " + this.patternTypeString + ", filter = " + this.attributeValue + " }";
            }

            @NotNull
            public final String component1() {
                return this.attributeValue;
            }

            @NotNull
            public final String component2() {
                return this.attributeName;
            }

            @NotNull
            public final Fragment copy(@NotNull String attributeValue, @NotNull String attributeName) {
                Intrinsics.checkNotNullParameter((Object)attributeValue, (String)"attributeValue");
                Intrinsics.checkNotNullParameter((Object)attributeName, (String)"attributeName");
                return new Fragment(attributeValue, attributeName);
            }

            public static /* synthetic */ Fragment copy$default(Fragment fragment, String string, String string2, int n, Object object) {
                if ((n & 1) != 0) {
                    string = fragment.attributeValue;
                }
                if ((n & 2) != 0) {
                    string2 = fragment.attributeName;
                }
                return fragment.copy(string, string2);
            }

            public int hashCode() {
                int result = this.attributeValue.hashCode();
                result = result * 31 + this.attributeName.hashCode();
                return result;
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof Fragment)) {
                    return false;
                }
                Fragment fragment = (Fragment)other;
                if (!Intrinsics.areEqual((Object)this.attributeValue, (Object)fragment.attributeValue)) {
                    return false;
                }
                return Intrinsics.areEqual((Object)this.attributeName, (Object)fragment.attributeName);
            }
        }

        @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000e\n\u0002\u0010#\n\u0002\b\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u000f\b\u0086\b\u0018\u00002\u00020\u0001BS\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b\u0012\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\t0\b\u0012\u0006\u0010\u000b\u001a\u00020\f\u0012\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000e0\b\u00a2\u0006\u0004\b\u000f\u0010\u0010J\u0010\u0010%\u001a\u0004\u0018\u00010\u00032\u0006\u0010&\u001a\u00020'J\u0018\u0010(\u001a\u00020)2\u0006\u0010*\u001a\u00020\u00032\u0006\u0010+\u001a\u00020\u0003H\u0002J\u000b\u0010,\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\t\u0010-\u001a\u00020\u0005H\u00c6\u0003J\t\u0010.\u001a\u00020\u0005H\u00c6\u0003J\u000f\u0010/\u001a\b\u0012\u0004\u0012\u00020\t0\bH\u00c6\u0003J\u000f\u00100\u001a\b\u0012\u0004\u0012\u00020\t0\bH\u00c6\u0003J\t\u00101\u001a\u00020\fH\u00c6\u0003J\u000f\u00102\u001a\b\u0012\u0004\u0012\u00020\u000e0\bH\u00c6\u0003Jc\u00103\u001a\u00020\u00002\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u00052\u000e\b\u0002\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b2\u000e\b\u0002\u0010\n\u001a\b\u0012\u0004\u0012\u00020\t0\b2\b\b\u0002\u0010\u000b\u001a\u00020\f2\u000e\b\u0002\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000e0\bH\u00c6\u0001J\u0013\u00104\u001a\u00020)2\b\u00105\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u00106\u001a\u00020\u0005H\u00d6\u0001J\t\u00107\u001a\u00020\u0003H\u00d6\u0001R\u0013\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0011\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0014R\u0017\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u0017\u0010\n\u001a\b\u0012\u0004\u0012\u00020\t0\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0017R\u0011\u0010\u000b\u001a\u00020\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001aR\u0017\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000e0\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u0017R#\u0010\u001c\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00030\u001d8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b \u0010!\u001a\u0004\b\u001e\u0010\u001fR#\u0010\"\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00030\u001d8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b$\u0010!\u001a\u0004\b#\u0010\u001f\u00a8\u00068"}, d2={"Lcom/android/tools/lint/checks/AppLinksValidDetector$Companion$IntentFilterData;", "", "autoVerify", "", "order", "", "priority", "actions", "", "Lcom/android/tools/lint/checks/AppLinksValidDetector$Companion$AttributeWrapper;", "categories", "dataTags", "Lcom/android/tools/lint/checks/AppLinksValidDetector$Companion$DataTagInfo;", "uriRelativeFilterGroups", "Lcom/android/tools/lint/checks/AppLinksValidDetector$Companion$UriRelativeFilterGroup;", "<init>", "(Ljava/lang/String;IILjava/util/List;Ljava/util/List;Lcom/android/tools/lint/checks/AppLinksValidDetector$Companion$DataTagInfo;Ljava/util/List;)V", "getAutoVerify", "()Ljava/lang/String;", "getOrder", "()I", "getPriority", "getActions", "()Ljava/util/List;", "getCategories", "getDataTags", "()Lcom/android/tools/lint/checks/AppLinksValidDetector$Companion$DataTagInfo;", "getUriRelativeFilterGroups", "actionSet", "", "getActionSet", "()Ljava/util/Set;", "actionSet$delegate", "Lkotlin/Lazy;", "categorySet", "getCategorySet", "categorySet$delegate", "match", "testUrl", "Ljava/net/URL;", "matchesHost", "", "actualHost", "hostPattern", "component1", "component2", "component3", "component4", "component5", "component6", "component7", "copy", "equals", "other", "hashCode", "toString", "lint-checks"})
        @SourceDebugExtension(value={"SMAP\nAppLinksValidDetector.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AppLinksValidDetector.kt\ncom/android/tools/lint/checks/AppLinksValidDetector$Companion$IntentFilterData\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 _Strings.kt\nkotlin/text/StringsKt___StringsKt\n*L\n1#1,2047:1\n1761#2,3:2048\n1761#2,2:2051\n1763#2:2054\n1761#2,3:2055\n295#2,2:2058\n1869#2,2:2060\n1869#2,2:2062\n1761#2,2:2064\n1763#2:2068\n1761#2,3:2069\n1#3:2053\n1088#4,2:2066\n1088#4,2:2072\n*S KotlinDebug\n*F\n+ 1 AppLinksValidDetector.kt\ncom/android/tools/lint/checks/AppLinksValidDetector$Companion$IntentFilterData\n*L\n1444#1:2048,3\n1452#1:2051,2\n1452#1:2054\n1469#1:2055,3\n1475#1:2058,2\n1489#1:2060,2\n1490#1:2062,2\n1496#1:2064,2\n1496#1:2068\n1498#1:2069,3\n1497#1:2066,2\n1498#1:2072,2\n*E\n"})
        public static final class IntentFilterData {
            @Nullable
            private final String autoVerify;
            private final int order;
            private final int priority;
            @NotNull
            private final List<AttributeWrapper> actions;
            @NotNull
            private final List<AttributeWrapper> categories;
            @NotNull
            private final DataTagInfo dataTags;
            @NotNull
            private final List<UriRelativeFilterGroup> uriRelativeFilterGroups;
            @NotNull
            private final Lazy actionSet$delegate;
            @NotNull
            private final Lazy categorySet$delegate;

            public IntentFilterData(@Nullable String autoVerify, int order, int priority, @NotNull List<? extends AttributeWrapper> actions, @NotNull List<? extends AttributeWrapper> categories, @NotNull DataTagInfo dataTags, @NotNull List<UriRelativeFilterGroup> uriRelativeFilterGroups) {
                Intrinsics.checkNotNullParameter(actions, (String)"actions");
                Intrinsics.checkNotNullParameter(categories, (String)"categories");
                Intrinsics.checkNotNullParameter((Object)dataTags, (String)"dataTags");
                Intrinsics.checkNotNullParameter(uriRelativeFilterGroups, (String)"uriRelativeFilterGroups");
                this.autoVerify = autoVerify;
                this.order = order;
                this.priority = priority;
                this.actions = actions;
                this.categories = categories;
                this.dataTags = dataTags;
                this.uriRelativeFilterGroups = uriRelativeFilterGroups;
                this.actionSet$delegate = LazyKt.lazy((LazyThreadSafetyMode)LazyThreadSafetyMode.NONE, (Function0)((Function0)new Function0<Set<String>>(this){
                    final /* synthetic */ IntentFilterData this$0;
                    {
                        this.this$0 = $receiver;
                        super(0);
                    }

                    /*
                     * WARNING - void declaration
                     */
                    public final Set<String> invoke() {
                        void var2_2;
                        void $this$mapTo$iv;
                        Iterable iterable = this.this$0.getActions();
                        Collection destination$iv = new LinkedHashSet<E>();
                        boolean $i$f$mapTo = false;
                        for (T item$iv : $this$mapTo$iv) {
                            void it;
                            AttributeWrapper attributeWrapper = (AttributeWrapper)item$iv;
                            Collection collection = destination$iv;
                            boolean bl = false;
                            collection.add(it.getSubstitutedValue());
                        }
                        return (Set)var2_2;
                    }
                }));
                this.categorySet$delegate = LazyKt.lazy((LazyThreadSafetyMode)LazyThreadSafetyMode.NONE, (Function0)((Function0)new Function0<Set<String>>(this){
                    final /* synthetic */ IntentFilterData this$0;
                    {
                        this.this$0 = $receiver;
                        super(0);
                    }

                    /*
                     * WARNING - void declaration
                     */
                    public final Set<String> invoke() {
                        void var2_2;
                        void $this$mapTo$iv;
                        Iterable iterable = this.this$0.getCategories();
                        Collection destination$iv = new LinkedHashSet<E>();
                        boolean $i$f$mapTo = false;
                        for (T item$iv : $this$mapTo$iv) {
                            void it;
                            AttributeWrapper attributeWrapper = (AttributeWrapper)item$iv;
                            Collection collection = destination$iv;
                            boolean bl = false;
                            collection.add(it.getSubstitutedValue());
                        }
                        return (Set)var2_2;
                    }
                }));
            }

            @Nullable
            public final String getAutoVerify() {
                return this.autoVerify;
            }

            public final int getOrder() {
                return this.order;
            }

            public final int getPriority() {
                return this.priority;
            }

            @NotNull
            public final List<AttributeWrapper> getActions() {
                return this.actions;
            }

            @NotNull
            public final List<AttributeWrapper> getCategories() {
                return this.categories;
            }

            @NotNull
            public final DataTagInfo getDataTags() {
                return this.dataTags;
            }

            @NotNull
            public final List<UriRelativeFilterGroup> getUriRelativeFilterGroups() {
                return this.uriRelativeFilterGroups;
            }

            @NotNull
            public final Set<String> getActionSet() {
                Lazy lazy = this.actionSet$delegate;
                return (Set)lazy.getValue();
            }

            @NotNull
            public final Set<String> getCategorySet() {
                Lazy lazy = this.categorySet$delegate;
                return (Set)lazy.getValue();
            }

            /*
             * Unable to fully structure code
             */
            @Nullable
            public final String match(@NotNull URL testUrl) {
                block42: {
                    block45: {
                        block44: {
                            block39: {
                                block38: {
                                    block37: {
                                        block43: {
                                            block35: {
                                                block34: {
                                                    block40: {
                                                        block33: {
                                                            block41: {
                                                                block32: {
                                                                    Intrinsics.checkNotNullParameter((Object)testUrl, (String)"testUrl");
                                                                    schemesIncludingImplicitSchemes = this.dataTags.getSchemes().isEmpty() != false && ((Collection)this.dataTags.getMimeTypes()).isEmpty() == false != false ? AppLinksValidDetector.Companion.getIMPLICIT_SCHEMES$lint_checks() : this.dataTags.getSchemes();
                                                                    $this$any$iv = schemesIncludingImplicitSchemes;
                                                                    $i$f$any = false;
                                                                    if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                                                                        v0 = false;
                                                                    } else {
                                                                        for (Object element$iv : $this$any$iv) {
                                                                            scheme = (String)element$iv;
                                                                            $i$a$-any-AppLinksValidDetector$Companion$IntentFilterData$match$schemeOk$1 = false;
                                                                            if (!(Intrinsics.areEqual((Object)scheme, (Object)testUrl.getProtocol()) != false || com.android.tools.lint.checks.AppLinksValidDetector$Companion.access$isSubstituted(AppLinksValidDetector.Companion, scheme) != false)) continue;
                                                                            v0 = true;
                                                                            break block32;
                                                                        }
                                                                        v0 = schemeOk = false;
                                                                    }
                                                                }
                                                                if (!schemeOk) {
                                                                    return "did not match scheme " + Joiner.on((String)", ").join((Iterable)this.dataTags.getSchemes());
                                                                }
                                                                if (!(((Collection)this.dataTags.getHostPortPairs()).isEmpty() == false)) break block40;
                                                                $this$any$iv = this.dataTags.getHostPortPairs();
                                                                $i$f$any = false;
                                                                if (!($this$any$iv instanceof Collection) || !((Collection)$this$any$iv).isEmpty()) break block41;
                                                                v1 = false;
                                                                break block33;
                                                            }
                                                            for (Object element$iv : $this$any$iv) {
                                                                $i$a$-any-AppLinksValidDetector$Companion$IntentFilterData$match$schemeOk$1 = (Pair)element$iv;
                                                                $i$a$-any-AppLinksValidDetector$Companion$IntentFilterData$match$hostOk$1 = false;
                                                                host = (String)$i$a$-any-AppLinksValidDetector$Companion$IntentFilterData$match$schemeOk$1.component1();
                                                                port = (String)$i$a$-any-AppLinksValidDetector$Companion$IntentFilterData$match$schemeOk$1.component2();
                                                                it = host;
                                                                $i$a$-let-AppLinksValidDetector$Companion$IntentFilterData$match$hostOk$1$1 = false;
                                                                v2 = testUrl.getHost();
                                                                Intrinsics.checkNotNullExpressionValue((Object)v2, (String)"getHost(...)");
                                                                v3 = this.matchesHost(v2, it) || com.android.tools.lint.checks.AppLinksValidDetector$Companion.access$isSubstituted(AppLinksValidDetector.Companion, it);
                                                                if (!v3) ** GOTO lbl-1000
                                                                v4 = port;
                                                                if (v4 != null) {
                                                                    it = v4;
                                                                    $i$a$-let-AppLinksValidDetector$Companion$IntentFilterData$match$hostOk$1$2 = false;
                                                                    v5 = Intrinsics.areEqual((Object)String.valueOf(testUrl.getPort()), (Object)port) || com.android.tools.lint.checks.AppLinksValidDetector$Companion.access$isSubstituted(AppLinksValidDetector.Companion, port);
                                                                    v6 = !v5;
                                                                } else {
                                                                    v6 = false;
                                                                }
                                                                if (!v6) {
                                                                    v7 = true;
                                                                } else lbl-1000:
                                                                // 2 sources

                                                                {
                                                                    v7 = false;
                                                                }
                                                                if (!v7) continue;
                                                                v1 = true;
                                                                break block33;
                                                            }
                                                            v1 = hostOk = false;
                                                        }
                                                        if (!hostOk) {
                                                            return "did not match" + (this.dataTags.getHostPortPairs().size() > 1 ? " any of" : "") + " " + CollectionsKt.joinToString$default((Iterable)this.dataTags.getHostPortPairs(), (CharSequence)", ", null, null, (int)0, null, (Function1)match.1.INSTANCE, (int)30, null);
                                                        }
                                                    }
                                                    if (!(((Collection)this.dataTags.getPaths()).isEmpty() == false) && !(((Collection)this.uriRelativeFilterGroups).isEmpty() == false)) break block42;
                                                    testPath = testUrl.getPath();
                                                    $this$any$iv = this.dataTags.getPaths();
                                                    $i$f$any = false;
                                                    if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                                                        v8 = false;
                                                    } else {
                                                        for (E element$iv : $this$any$iv) {
                                                            it = (Path)element$iv;
                                                            $i$a$-any-AppLinksValidDetector$Companion$IntentFilterData$match$pathMatchFound$1 = false;
                                                            if (!(com.android.tools.lint.checks.AppLinksValidDetector$Companion.access$isSubstituted(AppLinksValidDetector.Companion, it.getAttributeValue()) != false || it.toPatternMatcher().match(testPath) != false)) continue;
                                                            v8 = true;
                                                            break block34;
                                                        }
                                                        v8 = pathMatchFound = false;
                                                    }
                                                }
                                                if (pathMatchFound) {
                                                    return null;
                                                }
                                                $this$firstOrNull$iv = this.uriRelativeFilterGroups;
                                                $i$f$firstOrNull = false;
                                                for (T element$iv : $this$firstOrNull$iv) {
                                                    it = (UriRelativeFilterGroup)element$iv;
                                                    $i$a$-firstOrNull-AppLinksValidDetector$Companion$IntentFilterData$match$matchedUriRelativeFilter$1 = false;
                                                    if (!it.match(testUrl)) continue;
                                                    v9 = element$iv;
                                                    break block35;
                                                }
                                                v9 = null;
                                            }
                                            matchedUriRelativeFilter = v9;
                                            if (matchedUriRelativeFilter != null) {
                                                if (!matchedUriRelativeFilter.getAllow()) {
                                                    return "matched exclusion rule " + matchedUriRelativeFilter;
                                                }
                                                return null;
                                            }
                                            sb = new StringBuilder();
                                            $this$forEach$iv = this.dataTags.getPaths();
                                            $i$f$forEach = false;
                                            for (T element$iv : $this$forEach$iv) {
                                                it = (Path)element$iv;
                                                $i$a$-forEach-AppLinksValidDetector$Companion$IntentFilterData$match$2 = false;
                                                sb.append("path ").append(it).append(", ");
                                            }
                                            $this$forEach$iv = this.uriRelativeFilterGroups;
                                            $i$f$forEach = false;
                                            for (T element$iv : $this$forEach$iv) {
                                                it = (UriRelativeFilterGroup)element$iv;
                                                $i$a$-forEach-AppLinksValidDetector$Companion$IntentFilterData$match$3 = false;
                                                sb.append(it).append(", ");
                                            }
                                            if (StringsKt.endsWith$default((CharSequence)sb, (CharSequence)", ", (boolean)false, (int)2, null)) {
                                                sb.setLength(sb.length() - 2);
                                            }
                                            message = "did not match " + sb;
                                            $this$any$iv = this.dataTags.getPaths();
                                            $i$f$any = false;
                                            if (!($this$any$iv instanceof Collection) || !((Collection)$this$any$iv).isEmpty()) break block43;
                                            v10 = false;
                                            break block37;
                                        }
                                        var11_27 = $this$any$iv.iterator();
                                        while (var11_27.hasNext()) {
                                            block36: {
                                                element$iv = var11_27.next();
                                                it = (Path)element$iv;
                                                $i$a$-any-AppLinksValidDetector$Companion$IntentFilterData$match$4 = false;
                                                if (com.android.tools.lint.checks.AppLinksValidDetector$Companion.access$isSubstituted(AppLinksValidDetector.Companion, it.getAttributeValue())) ** GOTO lbl-1000
                                                $this$any$iv = it.getAttributeValue();
                                                $i$f$any = false;
                                                for (var17_45 = 0; var17_45 < $this$any$iv.length(); ++var17_45) {
                                                    p0 = element$iv = $this$any$iv.charAt(var17_45);
                                                    $i$a$-any-AppLinksValidDetector$Companion$IntentFilterData$match$4$1 = false;
                                                    if (!Character.isUpperCase(p0)) continue;
                                                    v11 = true;
                                                    break block36;
                                                }
                                                v11 = false;
                                            }
                                            if (v11) {
                                                v12 = true;
                                            } else lbl-1000:
                                            // 2 sources

                                            {
                                                v12 = false;
                                            }
                                            if (!v12) continue;
                                            v10 = true;
                                            break block37;
                                        }
                                        v10 = false;
                                    }
                                    if (v10) break block44;
                                    $this$any$iv = this.uriRelativeFilterGroups;
                                    $i$f$any = false;
                                    if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                                        v13 = false;
                                    } else {
                                        var11_27 = $this$any$iv.iterator();
                                        while (var11_27.hasNext()) {
                                            element$iv = var11_27.next();
                                            it = (UriRelativeFilterGroup)element$iv;
                                            $i$a$-any-AppLinksValidDetector$Companion$IntentFilterData$match$5 = false;
                                            if (!it.getHasUppercase()) continue;
                                            v13 = true;
                                            break block38;
                                        }
                                        v13 = false;
                                    }
                                }
                                if (v13) break block44;
                                Intrinsics.checkNotNull((Object)testPath);
                                $this$any$iv = testPath;
                                $i$f$any = false;
                                for (var11_29 = 0; var11_29 < $this$any$iv.length(); ++var11_29) {
                                    p0 = element$iv = $this$any$iv.charAt(var11_29);
                                    $i$a$-any-AppLinksValidDetector$Companion$IntentFilterData$match$6 = false;
                                    if (!Character.isUpperCase(p0)) continue;
                                    v14 = true;
                                    break block39;
                                }
                                v14 = false;
                            }
                            if (!v14) break block45;
                        }
                        message = message + " Note that matching is case sensitive.";
                    }
                    return message;
                }
                return null;
            }

            private final boolean matchesHost(String actualHost, String hostPattern) {
                boolean bl;
                if (!StringsKt.startsWith$default((String)hostPattern, (String)"*", (boolean)false, (int)2, null)) {
                    bl = Intrinsics.areEqual((Object)actualHost, (Object)hostPattern);
                } else {
                    boolean bl2;
                    try {
                        String string = hostPattern.substring(1);
                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
                        Regex pattern = new Regex(".*" + Pattern.quote(string));
                        bl2 = pattern.matches((CharSequence)actualHost);
                    }
                    catch (Throwable throwable) {
                        bl2 = false;
                    }
                    bl = bl2;
                }
                return bl;
            }

            @Nullable
            public final String component1() {
                return this.autoVerify;
            }

            public final int component2() {
                return this.order;
            }

            public final int component3() {
                return this.priority;
            }

            @NotNull
            public final List<AttributeWrapper> component4() {
                return this.actions;
            }

            @NotNull
            public final List<AttributeWrapper> component5() {
                return this.categories;
            }

            @NotNull
            public final DataTagInfo component6() {
                return this.dataTags;
            }

            @NotNull
            public final List<UriRelativeFilterGroup> component7() {
                return this.uriRelativeFilterGroups;
            }

            @NotNull
            public final IntentFilterData copy(@Nullable String autoVerify, int order, int priority, @NotNull List<? extends AttributeWrapper> actions, @NotNull List<? extends AttributeWrapper> categories, @NotNull DataTagInfo dataTags, @NotNull List<UriRelativeFilterGroup> uriRelativeFilterGroups) {
                Intrinsics.checkNotNullParameter(actions, (String)"actions");
                Intrinsics.checkNotNullParameter(categories, (String)"categories");
                Intrinsics.checkNotNullParameter((Object)dataTags, (String)"dataTags");
                Intrinsics.checkNotNullParameter(uriRelativeFilterGroups, (String)"uriRelativeFilterGroups");
                return new IntentFilterData(autoVerify, order, priority, actions, categories, dataTags, uriRelativeFilterGroups);
            }

            public static /* synthetic */ IntentFilterData copy$default(IntentFilterData intentFilterData, String string, int n, int n2, List list, List list2, DataTagInfo dataTagInfo2, List list3, int n3, Object object) {
                if ((n3 & 1) != 0) {
                    string = intentFilterData.autoVerify;
                }
                if ((n3 & 2) != 0) {
                    n = intentFilterData.order;
                }
                if ((n3 & 4) != 0) {
                    n2 = intentFilterData.priority;
                }
                if ((n3 & 8) != 0) {
                    list = intentFilterData.actions;
                }
                if ((n3 & 0x10) != 0) {
                    list2 = intentFilterData.categories;
                }
                if ((n3 & 0x20) != 0) {
                    dataTagInfo2 = intentFilterData.dataTags;
                }
                if ((n3 & 0x40) != 0) {
                    list3 = intentFilterData.uriRelativeFilterGroups;
                }
                return intentFilterData.copy(string, n, n2, list, list2, dataTagInfo2, list3);
            }

            @NotNull
            public String toString() {
                return "IntentFilterData(autoVerify=" + this.autoVerify + ", order=" + this.order + ", priority=" + this.priority + ", actions=" + this.actions + ", categories=" + this.categories + ", dataTags=" + this.dataTags + ", uriRelativeFilterGroups=" + this.uriRelativeFilterGroups + ")";
            }

            public int hashCode() {
                int result = this.autoVerify == null ? 0 : this.autoVerify.hashCode();
                result = result * 31 + Integer.hashCode(this.order);
                result = result * 31 + Integer.hashCode(this.priority);
                result = result * 31 + ((Object)this.actions).hashCode();
                result = result * 31 + ((Object)this.categories).hashCode();
                result = result * 31 + this.dataTags.hashCode();
                result = result * 31 + ((Object)this.uriRelativeFilterGroups).hashCode();
                return result;
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof IntentFilterData)) {
                    return false;
                }
                IntentFilterData intentFilterData = (IntentFilterData)other;
                if (!Intrinsics.areEqual((Object)this.autoVerify, (Object)intentFilterData.autoVerify)) {
                    return false;
                }
                if (this.order != intentFilterData.order) {
                    return false;
                }
                if (this.priority != intentFilterData.priority) {
                    return false;
                }
                if (!Intrinsics.areEqual(this.actions, intentFilterData.actions)) {
                    return false;
                }
                if (!Intrinsics.areEqual(this.categories, intentFilterData.categories)) {
                    return false;
                }
                if (!Intrinsics.areEqual((Object)this.dataTags, (Object)intentFilterData.dataTags)) {
                    return false;
                }
                return Intrinsics.areEqual(this.uriRelativeFilterGroups, intentFilterData.uriRelativeFilterGroups);
            }
        }

        @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u000f\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\u0010\u0000\n\u0002\b\u0002\b\u0086\b\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0006\u0010\n\u001a\u00020\u000bJ\u0011\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u0000H\u0096\u0002J\b\u0010\u000f\u001a\u00020\u0003H\u0016J\t\u0010\u0010\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0011\u001a\u00020\u0003H\u00c6\u0003J\u001d\u0010\u0012\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\u0013\u001a\u00020\u00142\b\u0010\u000e\u001a\u0004\u0018\u00010\u0015H\u00d6\u0003J\t\u0010\u0016\u001a\u00020\rH\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\b\u00a8\u0006\u0017"}, d2={"Lcom/android/tools/lint/checks/AppLinksValidDetector$Companion$Path;", "", "attributeValue", "", "attributeName", "<init>", "(Ljava/lang/String;Ljava/lang/String;)V", "getAttributeValue", "()Ljava/lang/String;", "getAttributeName", "toPatternMatcher", "Lcom/android/tools/lint/checks/AndroidPatternMatcher;", "compareTo", "", "other", "toString", "component1", "component2", "copy", "equals", "", "", "hashCode", "lint-checks"})
        public static final class Path
        implements Comparable<Path> {
            @NotNull
            private final String attributeValue;
            @NotNull
            private final String attributeName;

            public Path(@NotNull String attributeValue, @NotNull String attributeName) {
                Intrinsics.checkNotNullParameter((Object)attributeValue, (String)"attributeValue");
                Intrinsics.checkNotNullParameter((Object)attributeName, (String)"attributeName");
                this.attributeValue = attributeValue;
                this.attributeName = attributeName;
            }

            @NotNull
            public final String getAttributeValue() {
                return this.attributeValue;
            }

            @NotNull
            public final String getAttributeName() {
                return this.attributeName;
            }

            @NotNull
            public final AndroidPatternMatcher toPatternMatcher() {
                return new AndroidPatternMatcher(this.attributeValue, Companion.attrToAndroidPatternMatcher$lint_checks(this.attributeName));
            }

            @Override
            public int compareTo(@NotNull Path other) {
                Intrinsics.checkNotNullParameter((Object)other, (String)"other");
                if (this.attributeName.compareTo(other.attributeName) < 0) {
                    return -1;
                }
                return this.attributeValue.compareTo(other.attributeValue);
            }

            @NotNull
            public String toString() {
                String string;
                switch (this.attributeName) {
                    case "path": {
                        string = "literal ";
                        break;
                    }
                    case "pathPrefix": {
                        string = "prefix ";
                        break;
                    }
                    case "pathPattern": {
                        string = "glob ";
                        break;
                    }
                    case "pathSuffix": {
                        string = "suffix ";
                        break;
                    }
                    case "pathAdvancedPattern": {
                        string = "advanced ";
                        break;
                    }
                    default: {
                        throw new AssertionError((Object)("Expected attributeName to be a path attribute but was " + this.attributeName));
                    }
                }
                return string + this.attributeValue;
            }

            @NotNull
            public final String component1() {
                return this.attributeValue;
            }

            @NotNull
            public final String component2() {
                return this.attributeName;
            }

            @NotNull
            public final Path copy(@NotNull String attributeValue, @NotNull String attributeName) {
                Intrinsics.checkNotNullParameter((Object)attributeValue, (String)"attributeValue");
                Intrinsics.checkNotNullParameter((Object)attributeName, (String)"attributeName");
                return new Path(attributeValue, attributeName);
            }

            public static /* synthetic */ Path copy$default(Path path, String string, String string2, int n, Object object) {
                if ((n & 1) != 0) {
                    string = path.attributeValue;
                }
                if ((n & 2) != 0) {
                    string2 = path.attributeName;
                }
                return path.copy(string, string2);
            }

            public int hashCode() {
                int result = this.attributeValue.hashCode();
                result = result * 31 + this.attributeName.hashCode();
                return result;
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof Path)) {
                    return false;
                }
                Path path = (Path)other;
                if (!Intrinsics.areEqual((Object)this.attributeValue, (Object)path.attributeValue)) {
                    return false;
                }
                return Intrinsics.areEqual((Object)this.attributeName, (Object)path.attributeName);
            }
        }

        @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u000f\n\u0000\n\u0002\u0010\u000e\n\u0002\b\b\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0010\u0000\n\u0002\b\u0002\b\u0086\b\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0011\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u0000H\u0096\u0002J\u000e\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0003J\b\u0010\u0011\u001a\u00020\u0003H\u0016J\t\u0010\u0012\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0013\u001a\u00020\u0003H\u00c6\u0003J\u001d\u0010\u0014\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\u0015\u001a\u00020\u000f2\b\u0010\r\u001a\u0004\u0018\u00010\u0016H\u00d6\u0003J\t\u0010\u0017\u001a\u00020\fH\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\bR\u000e\u0010\n\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lcom/android/tools/lint/checks/AppLinksValidDetector$Companion$Query;", "", "attributeValue", "", "attributeName", "<init>", "(Ljava/lang/String;Ljava/lang/String;)V", "getAttributeValue", "()Ljava/lang/String;", "getAttributeName", "patternTypeString", "compareTo", "", "other", "match", "", "queryString", "toString", "component1", "component2", "copy", "equals", "", "hashCode", "lint-checks"})
        @SourceDebugExtension(value={"SMAP\nAppLinksValidDetector.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AppLinksValidDetector.kt\ncom/android/tools/lint/checks/AppLinksValidDetector$Companion$Query\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,2047:1\n1761#2,3:2048\n*S KotlinDebug\n*F\n+ 1 AppLinksValidDetector.kt\ncom/android/tools/lint/checks/AppLinksValidDetector$Companion$Query\n*L\n1320#1:2048,3\n*E\n"})
        public static final class Query
        implements Comparable<Query> {
            @NotNull
            private final String attributeValue;
            @NotNull
            private final String attributeName;
            @NotNull
            private final String patternTypeString;

            public Query(@NotNull String attributeValue, @NotNull String attributeName) {
                String string;
                Intrinsics.checkNotNullParameter((Object)attributeValue, (String)"attributeValue");
                Intrinsics.checkNotNullParameter((Object)attributeName, (String)"attributeName");
                this.attributeValue = attributeValue;
                switch (this.attributeName = attributeName) {
                    case "query": {
                        string = "LITERAL";
                        break;
                    }
                    case "queryPrefix": {
                        string = "PREFIX";
                        break;
                    }
                    case "queryPattern": {
                        string = "GLOB";
                        break;
                    }
                    case "queryAdvancedPattern": {
                        string = "ADVANCED_GLOB";
                        break;
                    }
                    case "querySuffix": {
                        string = "SUFFIX";
                        break;
                    }
                    default: {
                        string = "UNKNOWN";
                    }
                }
                this.patternTypeString = string;
            }

            @NotNull
            public final String getAttributeValue() {
                return this.attributeValue;
            }

            @NotNull
            public final String getAttributeName() {
                return this.attributeName;
            }

            @Override
            public int compareTo(@NotNull Query other) {
                Intrinsics.checkNotNullParameter((Object)other, (String)"other");
                Function1[] function1Array = new Function1[]{compareTo.1.INSTANCE, compareTo.2.INSTANCE};
                return ComparisonsKt.compareValuesBy((Object)this, (Object)other, (Function1[])function1Array);
            }

            public final boolean match(@NotNull String queryString) {
                boolean bl;
                block4: {
                    Intrinsics.checkNotNullParameter((Object)queryString, (String)"queryString");
                    AndroidPatternMatcher patternMatcher = new AndroidPatternMatcher(this.attributeValue, Companion.attrToAndroidPatternMatcher$lint_checks(this.attributeName));
                    Object[] objectArray = new String[]{"&amp;", "&"};
                    List paramsToMatch = StringsKt.split$default((CharSequence)queryString, (String[])objectArray, (boolean)false, (int)0, (int)6, null);
                    if (paramsToMatch.size() == 1) {
                        objectArray = new char[1];
                        objectArray[0] = (String)59;
                        paramsToMatch = StringsKt.split$default((CharSequence)queryString, (char[])objectArray, (boolean)false, (int)0, (int)6, null);
                    }
                    Iterable $this$any$iv = paramsToMatch;
                    boolean $i$f$any = false;
                    if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                        bl = false;
                    } else {
                        for (Object element$iv : $this$any$iv) {
                            String it = (String)element$iv;
                            boolean bl2 = false;
                            if (!patternMatcher.match(URLDecoder.decode(it, Charsets.UTF_8))) continue;
                            bl = true;
                            break block4;
                        }
                        bl = false;
                    }
                }
                return bl;
            }

            @NotNull
            public String toString() {
                return "UriRelativeFilter { uriPart = QUERY, patternType = " + this.patternTypeString + ", filter = " + this.attributeValue + " }";
            }

            @NotNull
            public final String component1() {
                return this.attributeValue;
            }

            @NotNull
            public final String component2() {
                return this.attributeName;
            }

            @NotNull
            public final Query copy(@NotNull String attributeValue, @NotNull String attributeName) {
                Intrinsics.checkNotNullParameter((Object)attributeValue, (String)"attributeValue");
                Intrinsics.checkNotNullParameter((Object)attributeName, (String)"attributeName");
                return new Query(attributeValue, attributeName);
            }

            public static /* synthetic */ Query copy$default(Query query, String string, String string2, int n, Object object) {
                if ((n & 1) != 0) {
                    string = query.attributeValue;
                }
                if ((n & 2) != 0) {
                    string2 = query.attributeName;
                }
                return query.copy(string, string2);
            }

            public int hashCode() {
                int result = this.attributeValue.hashCode();
                result = result * 31 + this.attributeName.hashCode();
                return result;
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof Query)) {
                    return false;
                }
                Query query = (Query)other;
                if (!Intrinsics.areEqual((Object)this.attributeValue, (Object)query.attributeValue)) {
                    return false;
                }
                return Intrinsics.areEqual((Object)this.attributeName, (Object)query.attributeName);
            }
        }

        @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u001c\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\bf\u0018\u00002\u00020\u0001J\u0012\u0010\r\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\u000e\u001a\u00020\u0003H&R\u0012\u0010\u0002\u001a\u00020\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0004\u0010\u0005R\u0018\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00000\u0007X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\tR\u0018\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u000b0\u0007X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\t\u00a8\u0006\u000f\u00c0\u0006\u0003"}, d2={"Lcom/android/tools/lint/checks/AppLinksValidDetector$Companion$TagWrapper;", "", "name", "", "getName", "()Ljava/lang/String;", "subTags", "", "getSubTags", "()Ljava/lang/Iterable;", "attributes", "Lcom/android/tools/lint/checks/AppLinksValidDetector$Companion$AttributeWrapper;", "getAttributes", "getAttributeWrapper", "attrName", "lint-checks"})
        public static interface TagWrapper {
            @NotNull
            public String getName();

            @NotNull
            public Iterable<TagWrapper> getSubTags();

            @NotNull
            public Iterable<AttributeWrapper> getAttributes();

            @Nullable
            public AttributeWrapper getAttributeWrapper(@NotNull String var1);
        }

        @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\b\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u000e\u0010+\u001a\u00020\u00072\u0006\u0010,\u001a\u00020-J\b\u0010.\u001a\u00020/H\u0016J\t\u00100\u001a\u00020\u0003H\u00c2\u0003J\u0013\u00101\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0013\u00102\u001a\u00020\u00072\b\u00103\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u00104\u001a\u000205H\u00d6\u0001R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001b\u0010\u0006\u001a\u00020\u00078FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\n\u0010\u000b\u001a\u0004\b\b\u0010\tR\u001b\u0010\f\u001a\u00020\r8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0010\u0010\u000b\u001a\u0004\b\u000e\u0010\u000fR!\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u00128FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0016\u0010\u000b\u001a\u0004\b\u0014\u0010\u0015R!\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00130\u00128FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0019\u0010\u000b\u001a\u0004\b\u0018\u0010\u0015R!\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u001b0\u00128FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u001d\u0010\u000b\u001a\u0004\b\u001c\u0010\u0015R!\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u001f0\u00128FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b!\u0010\u000b\u001a\u0004\b \u0010\u0015R!\u0010\"\u001a\b\u0012\u0004\u0012\u00020\u001f0\u00128FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b$\u0010\u000b\u001a\u0004\b#\u0010\u0015R!\u0010%\u001a\b\u0012\u0004\u0012\u00020\u001b0\u00128FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b'\u0010\u000b\u001a\u0004\b&\u0010\u0015R\u001b\u0010(\u001a\u00020\u00078FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b*\u0010\u000b\u001a\u0004\b)\u0010\t\u00a8\u00066"}, d2={"Lcom/android/tools/lint/checks/AppLinksValidDetector$Companion$UriRelativeFilterGroup;", "", "tagWrapper", "Lcom/android/tools/lint/checks/AppLinksValidDetector$Companion$TagWrapper;", "<init>", "(Lcom/android/tools/lint/checks/AppLinksValidDetector$Companion$TagWrapper;)V", "allow", "", "getAllow", "()Z", "allow$delegate", "Lkotlin/Lazy;", "dataTagInfo", "Lcom/android/tools/lint/checks/AppLinksValidDetector$Companion$DataTagInfo;", "getDataTagInfo", "()Lcom/android/tools/lint/checks/AppLinksValidDetector$Companion$DataTagInfo;", "dataTagInfo$delegate", "queries", "", "Lcom/android/tools/lint/checks/AppLinksValidDetector$Companion$Query;", "getQueries", "()Ljava/util/Set;", "queries$delegate", "rawQueries", "getRawQueries", "rawQueries$delegate", "queryElements", "Lcom/android/tools/lint/checks/AppLinksValidDetector$Companion$AttributeWrapper;", "getQueryElements", "queryElements$delegate", "fragments", "Lcom/android/tools/lint/checks/AppLinksValidDetector$Companion$Fragment;", "getFragments", "fragments$delegate", "rawFragments", "getRawFragments", "rawFragments$delegate", "fragmentElements", "getFragmentElements", "fragmentElements$delegate", "hasUppercase", "getHasUppercase", "hasUppercase$delegate", "match", "url", "Ljava/net/URL;", "toString", "", "component1", "copy", "equals", "other", "hashCode", "", "lint-checks"})
        @SourceDebugExtension(value={"SMAP\nAppLinksValidDetector.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AppLinksValidDetector.kt\ncom/android/tools/lint/checks/AppLinksValidDetector$Companion$UriRelativeFilterGroup\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,2047:1\n1740#2,3:2048\n1740#2,3:2051\n1740#2,3:2054\n1869#2,2:2057\n1869#2,2:2059\n1869#2,2:2061\n*S KotlinDebug\n*F\n+ 1 AppLinksValidDetector.kt\ncom/android/tools/lint/checks/AppLinksValidDetector$Companion$UriRelativeFilterGroup\n*L\n1680#1:2048,3\n1686#1:2051,3\n1691#1:2054,3\n1704#1:2057,2\n1705#1:2059,2\n1706#1:2061,2\n*E\n"})
        public static final class UriRelativeFilterGroup {
            @NotNull
            private final TagWrapper tagWrapper;
            @NotNull
            private final Lazy allow$delegate;
            @NotNull
            private final Lazy dataTagInfo$delegate;
            @NotNull
            private final Lazy queries$delegate;
            @NotNull
            private final Lazy rawQueries$delegate;
            @NotNull
            private final Lazy queryElements$delegate;
            @NotNull
            private final Lazy fragments$delegate;
            @NotNull
            private final Lazy rawFragments$delegate;
            @NotNull
            private final Lazy fragmentElements$delegate;
            @NotNull
            private final Lazy hasUppercase$delegate;

            public UriRelativeFilterGroup(@NotNull TagWrapper tagWrapper) {
                Intrinsics.checkNotNullParameter((Object)tagWrapper, (String)"tagWrapper");
                this.tagWrapper = tagWrapper;
                this.allow$delegate = LazyKt.lazy((LazyThreadSafetyMode)LazyThreadSafetyMode.NONE, (Function0)((Function0)new Function0<Boolean>(this){
                    final /* synthetic */ UriRelativeFilterGroup this$0;
                    {
                        this.this$0 = $receiver;
                        super(0);
                    }

                    public final Boolean invoke() {
                        AttributeWrapper attributeWrapper = UriRelativeFilterGroup.access$getTagWrapper$p(this.this$0).getAttributeWrapper("allow");
                        String it = attributeWrapper != null ? attributeWrapper.getSubstitutedValue() : null;
                        boolean bl = false;
                        return it == null || Intrinsics.areEqual((Object)it, (Object)"true");
                    }
                }));
                this.dataTagInfo$delegate = LazyKt.lazy((LazyThreadSafetyMode)LazyThreadSafetyMode.NONE, (Function0)((Function0)new Function0<DataTagInfo>(this){
                    final /* synthetic */ UriRelativeFilterGroup this$0;
                    {
                        this.this$0 = $receiver;
                        super(0);
                    }

                    /*
                     * WARNING - void declaration
                     */
                    public final DataTagInfo invoke() {
                        void $this$filterTo$iv$iv;
                        Iterable<TagWrapper> $this$filter$iv = UriRelativeFilterGroup.access$getTagWrapper$p(this.this$0).getSubTags();
                        boolean $i$f$filter = false;
                        Iterable<TagWrapper> iterable = $this$filter$iv;
                        Collection destination$iv$iv = new ArrayList<E>();
                        boolean $i$f$filterTo = false;
                        for (T element$iv$iv : $this$filterTo$iv$iv) {
                            TagWrapper it = (TagWrapper)element$iv$iv;
                            boolean bl = false;
                            if (!Intrinsics.areEqual((Object)it.getName(), (Object)"data")) continue;
                            destination$iv$iv.add(element$iv$iv);
                        }
                        List list = (List)destination$iv$iv;
                        return new DataTagInfo(list);
                    }
                }));
                this.queries$delegate = LazyKt.lazy((LazyThreadSafetyMode)LazyThreadSafetyMode.NONE, (Function0)((Function0)new Function0<Set<Query>>(this){
                    final /* synthetic */ UriRelativeFilterGroup this$0;
                    {
                        this.this$0 = $receiver;
                        super(0);
                    }

                    /*
                     * WARNING - void declaration
                     */
                    public final Set<Query> invoke() {
                        void var2_2;
                        void $this$mapNotNullTo$iv;
                        Iterable iterable = this.this$0.getQueryElements();
                        Collection destination$iv = new LinkedHashSet<E>();
                        boolean $i$f$mapNotNullTo = false;
                        void $this$forEach$iv$iv = $this$mapNotNullTo$iv;
                        boolean $i$f$forEach = false;
                        Iterator<T> iterator = $this$forEach$iv$iv.iterator();
                        while (iterator.hasNext()) {
                            Query query;
                            T element$iv$iv;
                            T element$iv = element$iv$iv = iterator.next();
                            boolean bl = false;
                            AttributeWrapper attr = (AttributeWrapper)element$iv;
                            boolean bl2 = false;
                            if (attr.getSubstitutedValue() != null) {
                                String it;
                                boolean bl3 = false;
                                query = new Query(it, attr.getName());
                            } else {
                                query = null;
                            }
                            if (query == null) continue;
                            Query it$iv = query;
                            boolean bl4 = false;
                            destination$iv.add(it$iv);
                        }
                        return (Set)var2_2;
                    }
                }));
                this.rawQueries$delegate = LazyKt.lazy((LazyThreadSafetyMode)LazyThreadSafetyMode.NONE, (Function0)((Function0)new Function0<Set<Query>>(this){
                    final /* synthetic */ UriRelativeFilterGroup this$0;
                    {
                        this.this$0 = $receiver;
                        super(0);
                    }

                    /*
                     * WARNING - void declaration
                     */
                    public final Set<Query> invoke() {
                        void var2_2;
                        void $this$mapNotNullTo$iv;
                        Iterable iterable = this.this$0.getQueryElements();
                        Collection destination$iv = new LinkedHashSet<E>();
                        boolean $i$f$mapNotNullTo = false;
                        void $this$forEach$iv$iv = $this$mapNotNullTo$iv;
                        boolean $i$f$forEach = false;
                        Iterator<T> iterator = $this$forEach$iv$iv.iterator();
                        while (iterator.hasNext()) {
                            Query query;
                            T element$iv$iv;
                            T element$iv = element$iv$iv = iterator.next();
                            boolean bl = false;
                            AttributeWrapper attr = (AttributeWrapper)element$iv;
                            boolean bl2 = false;
                            if (attr.getRawValue() != null) {
                                String it;
                                boolean bl3 = false;
                                query = new Query(it, attr.getName());
                            } else {
                                query = null;
                            }
                            if (query == null) continue;
                            Query it$iv = query;
                            boolean bl4 = false;
                            destination$iv.add(it$iv);
                        }
                        return (Set)var2_2;
                    }
                }));
                this.queryElements$delegate = LazyKt.lazy((LazyThreadSafetyMode)LazyThreadSafetyMode.NONE, (Function0)((Function0)new Function0<Set<AttributeWrapper>>(this){
                    final /* synthetic */ UriRelativeFilterGroup this$0;
                    {
                        this.this$0 = $receiver;
                        super(0);
                    }

                    /*
                     * WARNING - void declaration
                     */
                    public final Set<AttributeWrapper> invoke() {
                        void $this$filterTo$iv$iv;
                        Set result = new LinkedHashSet<E>();
                        Iterable<TagWrapper> $this$filter$iv = UriRelativeFilterGroup.access$getTagWrapper$p(this.this$0).getSubTags();
                        boolean $i$f$filter = false;
                        Iterable<TagWrapper> iterable = $this$filter$iv;
                        Collection destination$iv$iv = new ArrayList<E>();
                        boolean $i$f$filterTo = false;
                        for (T element$iv$iv : $this$filterTo$iv$iv) {
                            TagWrapper it = (TagWrapper)element$iv$iv;
                            boolean bl = false;
                            if (!Intrinsics.areEqual((Object)it.getName(), (Object)"data")) continue;
                            destination$iv$iv.add(element$iv$iv);
                        }
                        for (TagWrapper subTag : (List)destination$iv$iv) {
                            for (String value : AppLinksValidDetector.Companion.getQUERY_ATTRIBUTES$lint_checks()) {
                                AttributeWrapper it;
                                if (subTag.getAttributeWrapper(value) == null) continue;
                                boolean bl = false;
                                result.add(it);
                            }
                        }
                        return result;
                    }
                }));
                this.fragments$delegate = LazyKt.lazy((LazyThreadSafetyMode)LazyThreadSafetyMode.NONE, (Function0)((Function0)new Function0<Set<Fragment>>(this){
                    final /* synthetic */ UriRelativeFilterGroup this$0;
                    {
                        this.this$0 = $receiver;
                        super(0);
                    }

                    /*
                     * WARNING - void declaration
                     */
                    public final Set<Fragment> invoke() {
                        void var2_2;
                        void $this$mapNotNullTo$iv;
                        Iterable iterable = this.this$0.getFragmentElements();
                        Collection destination$iv = new LinkedHashSet<E>();
                        boolean $i$f$mapNotNullTo = false;
                        void $this$forEach$iv$iv = $this$mapNotNullTo$iv;
                        boolean $i$f$forEach = false;
                        Iterator<T> iterator = $this$forEach$iv$iv.iterator();
                        while (iterator.hasNext()) {
                            Fragment fragment;
                            T element$iv$iv;
                            T element$iv = element$iv$iv = iterator.next();
                            boolean bl = false;
                            AttributeWrapper attr = (AttributeWrapper)element$iv;
                            boolean bl2 = false;
                            if (attr.getSubstitutedValue() != null) {
                                String it;
                                boolean bl3 = false;
                                fragment = new Fragment(it, attr.getName());
                            } else {
                                fragment = null;
                            }
                            if (fragment == null) continue;
                            Fragment it$iv = fragment;
                            boolean bl4 = false;
                            destination$iv.add(it$iv);
                        }
                        return (Set)var2_2;
                    }
                }));
                this.rawFragments$delegate = LazyKt.lazy((LazyThreadSafetyMode)LazyThreadSafetyMode.NONE, (Function0)((Function0)new Function0<Set<Fragment>>(this){
                    final /* synthetic */ UriRelativeFilterGroup this$0;
                    {
                        this.this$0 = $receiver;
                        super(0);
                    }

                    /*
                     * WARNING - void declaration
                     */
                    public final Set<Fragment> invoke() {
                        void var2_2;
                        void $this$mapNotNullTo$iv;
                        Iterable iterable = this.this$0.getFragmentElements();
                        Collection destination$iv = new LinkedHashSet<E>();
                        boolean $i$f$mapNotNullTo = false;
                        void $this$forEach$iv$iv = $this$mapNotNullTo$iv;
                        boolean $i$f$forEach = false;
                        Iterator<T> iterator = $this$forEach$iv$iv.iterator();
                        while (iterator.hasNext()) {
                            Fragment fragment;
                            T element$iv$iv;
                            T element$iv = element$iv$iv = iterator.next();
                            boolean bl = false;
                            AttributeWrapper attr = (AttributeWrapper)element$iv;
                            boolean bl2 = false;
                            if (attr.getRawValue() != null) {
                                String it;
                                boolean bl3 = false;
                                fragment = new Fragment(it, attr.getName());
                            } else {
                                fragment = null;
                            }
                            if (fragment == null) continue;
                            Fragment it$iv = fragment;
                            boolean bl4 = false;
                            destination$iv.add(it$iv);
                        }
                        return (Set)var2_2;
                    }
                }));
                this.fragmentElements$delegate = LazyKt.lazy((LazyThreadSafetyMode)LazyThreadSafetyMode.NONE, (Function0)((Function0)new Function0<Set<AttributeWrapper>>(this){
                    final /* synthetic */ UriRelativeFilterGroup this$0;
                    {
                        this.this$0 = $receiver;
                        super(0);
                    }

                    /*
                     * WARNING - void declaration
                     */
                    public final Set<AttributeWrapper> invoke() {
                        void $this$filterTo$iv$iv;
                        Set result = new LinkedHashSet<E>();
                        Iterable<TagWrapper> $this$filter$iv = UriRelativeFilterGroup.access$getTagWrapper$p(this.this$0).getSubTags();
                        boolean $i$f$filter = false;
                        Iterable<TagWrapper> iterable = $this$filter$iv;
                        Collection destination$iv$iv = new ArrayList<E>();
                        boolean $i$f$filterTo = false;
                        for (T element$iv$iv : $this$filterTo$iv$iv) {
                            TagWrapper it = (TagWrapper)element$iv$iv;
                            boolean bl = false;
                            if (!Intrinsics.areEqual((Object)it.getName(), (Object)"data")) continue;
                            destination$iv$iv.add(element$iv$iv);
                        }
                        for (TagWrapper subTag : (List)destination$iv$iv) {
                            for (String value : AppLinksValidDetector.Companion.getFRAGMENT_ATTRIBUTES$lint_checks()) {
                                AttributeWrapper it;
                                if (subTag.getAttributeWrapper(value) == null) continue;
                                boolean bl = false;
                                result.add(it);
                            }
                        }
                        return result;
                    }
                }));
                this.hasUppercase$delegate = LazyKt.lazy((LazyThreadSafetyMode)LazyThreadSafetyMode.NONE, (Function0)((Function0)new Function0<Boolean>(this){
                    final /* synthetic */ UriRelativeFilterGroup this$0;
                    {
                        this.this$0 = $receiver;
                        super(0);
                    }

                    /*
                     * Enabled aggressive block sorting
                     */
                    public final Boolean invoke() {
                        boolean bl;
                        block20: {
                            boolean bl2;
                            block14: {
                                boolean bl3;
                                char p0;
                                char element$iv;
                                int n;
                                boolean $i$f$any;
                                CharSequence $this$any$iv;
                                Comparable<Path> it;
                                T element$iv2;
                                Iterator<T> iterator;
                                Iterable $this$any$iv2;
                                block25: {
                                    boolean bl4;
                                    boolean $i$f$any2;
                                    block12: {
                                        boolean bl5;
                                        block21: {
                                            boolean bl6;
                                            block10: {
                                                boolean bl7;
                                                block16: {
                                                    $this$any$iv2 = this.this$0.getDataTagInfo().getPaths();
                                                    $i$f$any2 = false;
                                                    if (!($this$any$iv2 instanceof Collection) || !((Collection)$this$any$iv2).isEmpty()) break block16;
                                                    bl6 = false;
                                                    break block10;
                                                }
                                                iterator = $this$any$iv2.iterator();
                                                do {
                                                    block18: {
                                                        boolean bl8;
                                                        block11: {
                                                            block19: {
                                                                block17: {
                                                                    if (!iterator.hasNext()) break block17;
                                                                    element$iv2 = iterator.next();
                                                                    it = (Path)element$iv2;
                                                                    boolean bl9 = false;
                                                                    if (com.android.tools.lint.checks.AppLinksValidDetector$Companion.access$isSubstituted(AppLinksValidDetector.Companion, ((Path)it).getAttributeValue())) break block18;
                                                                    $this$any$iv = ((Path)it).getAttributeValue();
                                                                    $i$f$any = false;
                                                                    break block19;
                                                                }
                                                                bl6 = false;
                                                                break block10;
                                                            }
                                                            for (n = 0; n < $this$any$iv.length(); ++n) {
                                                                p0 = element$iv = $this$any$iv.charAt(n);
                                                                boolean bl10 = false;
                                                                if (!Character.isUpperCase(p0)) continue;
                                                                bl8 = true;
                                                                break block11;
                                                            }
                                                            bl8 = false;
                                                        }
                                                        if (bl8) {
                                                            bl7 = true;
                                                            continue;
                                                        }
                                                    }
                                                    bl7 = false;
                                                } while (!bl7);
                                                bl6 = true;
                                            }
                                            if (bl6) break block20;
                                            $this$any$iv2 = this.this$0.getQueries();
                                            $i$f$any2 = false;
                                            if (!($this$any$iv2 instanceof Collection) || !((Collection)$this$any$iv2).isEmpty()) break block21;
                                            bl4 = false;
                                            break block12;
                                        }
                                        iterator = $this$any$iv2.iterator();
                                        do {
                                            block23: {
                                                boolean bl11;
                                                block13: {
                                                    block24: {
                                                        block22: {
                                                            if (!iterator.hasNext()) break block22;
                                                            element$iv2 = iterator.next();
                                                            it = (Query)element$iv2;
                                                            boolean bl12 = false;
                                                            if (com.android.tools.lint.checks.AppLinksValidDetector$Companion.access$isSubstituted(AppLinksValidDetector.Companion, ((Query)it).getAttributeValue())) break block23;
                                                            $this$any$iv = ((Query)it).getAttributeValue();
                                                            $i$f$any = false;
                                                            break block24;
                                                        }
                                                        bl4 = false;
                                                        break block12;
                                                    }
                                                    for (n = 0; n < $this$any$iv.length(); ++n) {
                                                        p0 = element$iv = $this$any$iv.charAt(n);
                                                        boolean bl13 = false;
                                                        if (!Character.isUpperCase(p0)) continue;
                                                        bl11 = true;
                                                        break block13;
                                                    }
                                                    bl11 = false;
                                                }
                                                if (bl11) {
                                                    bl5 = true;
                                                    continue;
                                                }
                                            }
                                            bl5 = false;
                                        } while (!bl5);
                                        bl4 = true;
                                    }
                                    if (bl4) break block20;
                                    $this$any$iv2 = this.this$0.getFragments();
                                    $i$f$any2 = false;
                                    if (!($this$any$iv2 instanceof Collection) || !((Collection)$this$any$iv2).isEmpty()) break block25;
                                    bl2 = false;
                                    break block14;
                                }
                                iterator = $this$any$iv2.iterator();
                                do {
                                    block27: {
                                        boolean bl14;
                                        block15: {
                                            block28: {
                                                block26: {
                                                    if (!iterator.hasNext()) break block26;
                                                    element$iv2 = iterator.next();
                                                    it = (Fragment)element$iv2;
                                                    boolean bl15 = false;
                                                    if (com.android.tools.lint.checks.AppLinksValidDetector$Companion.access$isSubstituted(AppLinksValidDetector.Companion, ((Fragment)it).getAttributeValue())) break block27;
                                                    $this$any$iv = ((Fragment)it).getAttributeValue();
                                                    $i$f$any = false;
                                                    break block28;
                                                }
                                                bl2 = false;
                                                break block14;
                                            }
                                            for (n = 0; n < $this$any$iv.length(); ++n) {
                                                p0 = element$iv = $this$any$iv.charAt(n);
                                                boolean bl16 = false;
                                                if (!Character.isUpperCase(p0)) continue;
                                                bl14 = true;
                                                break block15;
                                            }
                                            bl14 = false;
                                        }
                                        if (bl14) {
                                            bl3 = true;
                                            continue;
                                        }
                                    }
                                    bl3 = false;
                                } while (!bl3);
                                bl2 = true;
                            }
                            if (!bl2) {
                                bl = false;
                                return bl;
                            }
                        }
                        bl = true;
                        return bl;
                    }
                }));
            }

            public final boolean getAllow() {
                Lazy lazy = this.allow$delegate;
                return (Boolean)lazy.getValue();
            }

            @NotNull
            public final DataTagInfo getDataTagInfo() {
                Lazy lazy = this.dataTagInfo$delegate;
                return (DataTagInfo)lazy.getValue();
            }

            @NotNull
            public final Set<Query> getQueries() {
                Lazy lazy = this.queries$delegate;
                return (Set)lazy.getValue();
            }

            @NotNull
            public final Set<Query> getRawQueries() {
                Lazy lazy = this.rawQueries$delegate;
                return (Set)lazy.getValue();
            }

            @NotNull
            public final Set<AttributeWrapper> getQueryElements() {
                Lazy lazy = this.queryElements$delegate;
                return (Set)lazy.getValue();
            }

            @NotNull
            public final Set<Fragment> getFragments() {
                Lazy lazy = this.fragments$delegate;
                return (Set)lazy.getValue();
            }

            @NotNull
            public final Set<Fragment> getRawFragments() {
                Lazy lazy = this.rawFragments$delegate;
                return (Set)lazy.getValue();
            }

            @NotNull
            public final Set<AttributeWrapper> getFragmentElements() {
                Lazy lazy = this.fragmentElements$delegate;
                return (Set)lazy.getValue();
            }

            public final boolean getHasUppercase() {
                Lazy lazy = this.hasUppercase$delegate;
                return (Boolean)lazy.getValue();
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final boolean match(@NotNull URL url) {
                boolean bl;
                boolean queryOk;
                boolean bl2;
                boolean pathOk;
                boolean bl3;
                Intrinsics.checkNotNullParameter((Object)url, (String)"url");
                Iterable $this$all$iv = this.getDataTagInfo().getPaths();
                boolean $i$f$all = false;
                if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                    bl3 = true;
                } else {
                    for (Object element$iv : $this$all$iv) {
                        Path it = (Path)element$iv;
                        boolean bl4 = false;
                        if (!Companion.isSubstituted(it.getAttributeValue())) {
                            if (url.getPath() == null) return false;
                            if (!it.toPatternMatcher().match(url.getPath())) return false;
                        }
                        boolean bl5 = true;
                        if (bl5) continue;
                        return false;
                    }
                    bl3 = pathOk = true;
                }
                if (!pathOk) {
                    return false;
                }
                Iterable $this$all$iv2 = this.getQueries();
                boolean $i$f$all2 = false;
                if ($this$all$iv2 instanceof Collection && ((Collection)$this$all$iv2).isEmpty()) {
                    bl2 = true;
                } else {
                    for (Object element$iv : $this$all$iv2) {
                        Query it = (Query)element$iv;
                        boolean bl6 = false;
                        if (!Companion.isSubstituted(it.getAttributeValue())) {
                            if (url.getQuery() == null) return false;
                            String string = url.getQuery();
                            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getQuery(...)");
                            if (!it.match(string)) return false;
                        }
                        boolean bl7 = true;
                        if (bl7) continue;
                        return false;
                    }
                    bl2 = queryOk = true;
                }
                if (!queryOk) {
                    return false;
                }
                Iterable $this$all$iv3 = this.getFragments();
                boolean $i$f$all3 = false;
                if ($this$all$iv3 instanceof Collection && ((Collection)$this$all$iv3).isEmpty()) {
                    return true;
                }
                Iterator iterator = $this$all$iv3.iterator();
                do {
                    if (!iterator.hasNext()) return true;
                    Object element$iv = iterator.next();
                    Fragment it = (Fragment)element$iv;
                    boolean bl8 = false;
                    if (!Companion.isSubstituted(it.getAttributeValue())) {
                        if (url.getRef() == null) return false;
                        String string = url.getRef();
                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getRef(...)");
                        if (!it.match(string)) return false;
                    }
                    bl = true;
                } while (bl);
                return false;
            }

            @NotNull
            public String toString() {
                Comparable<Path> it;
                StringBuilder sb = new StringBuilder("UriRelativeFilterGroup { allow = ").append(this.getAllow()).append(", uri_filters = ");
                Iterable $this$forEach$iv = this.getDataTagInfo().getPaths();
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    it = (Path)element$iv;
                    boolean bl = false;
                    sb.append(it).append(", ");
                }
                $this$forEach$iv = this.getQueries();
                $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    it = (Query)element$iv;
                    boolean bl = false;
                    sb.append(it).append(", ");
                }
                $this$forEach$iv = this.getFragments();
                $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    it = (Fragment)element$iv;
                    boolean bl = false;
                    sb.append(it).append(", ");
                }
                Intrinsics.checkNotNull((Object)sb);
                if (StringsKt.endsWith$default((CharSequence)sb, (CharSequence)", ", (boolean)false, (int)2, null)) {
                    sb.setLength(sb.length() - 2);
                }
                sb.append(" }");
                String string = sb.toString();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
                return string;
            }

            private final TagWrapper component1() {
                return this.tagWrapper;
            }

            @NotNull
            public final UriRelativeFilterGroup copy(@NotNull TagWrapper tagWrapper) {
                Intrinsics.checkNotNullParameter((Object)tagWrapper, (String)"tagWrapper");
                return new UriRelativeFilterGroup(tagWrapper);
            }

            public static /* synthetic */ UriRelativeFilterGroup copy$default(UriRelativeFilterGroup uriRelativeFilterGroup, TagWrapper tagWrapper, int n, Object object) {
                if ((n & 1) != 0) {
                    tagWrapper = uriRelativeFilterGroup.tagWrapper;
                }
                return uriRelativeFilterGroup.copy(tagWrapper);
            }

            public int hashCode() {
                return this.tagWrapper.hashCode();
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof UriRelativeFilterGroup)) {
                    return false;
                }
                UriRelativeFilterGroup uriRelativeFilterGroup = (UriRelativeFilterGroup)other;
                return Intrinsics.areEqual((Object)this.tagWrapper, (Object)uriRelativeFilterGroup.tagWrapper);
            }

            public static final /* synthetic */ TagWrapper access$getTagWrapper$p(UriRelativeFilterGroup $this) {
                return $this.tagWrapper;
            }
        }
    }
}

