/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.checks;

import com.android.ide.common.fonts.DownloadableParseResult;
import com.android.ide.common.fonts.FontDetail;
import com.android.ide.common.fonts.FontFamily;
import com.android.ide.common.fonts.FontLoader;
import com.android.ide.common.fonts.FontProvider;
import com.android.ide.common.fonts.FontQueryParserError;
import com.android.ide.common.fonts.MutableFontDetail;
import com.android.ide.common.fonts.QueryResolver;
import com.android.ide.common.gradle.Module;
import com.android.ide.common.gradle.Version;
import com.android.resources.ResourceFolderType;
import com.android.sdklib.AndroidVersion;
import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.Context;
import com.android.tools.lint.detector.api.Implementation;
import com.android.tools.lint.detector.api.Incident;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.Lint;
import com.android.tools.lint.detector.api.LintFix;
import com.android.tools.lint.detector.api.LintMap;
import com.android.tools.lint.detector.api.Location;
import com.android.tools.lint.detector.api.ResourceXmlDetector;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import com.android.tools.lint.detector.api.XmlContext;
import com.android.tools.lint.model.LintModelExternalLibrary;
import com.android.tools.lint.model.LintModelLibrary;
import com.android.tools.lint.model.LintModelMavenName;
import com.android.tools.lint.model.LintModelVariant;
import com.android.utils.XmlUtils;
import com.google.common.base.Joiner;
import com.intellij.openapi.util.text.StringUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class FontDetector
extends ResourceXmlDetector {
    public static final int FUTURE_API_VERSION_WHERE_DOWNLOADABLE_FONTS_WORK_IN_FRAMEWORK = 46;
    public static final String KEY_ARTIFACT_ID = "artifact";
    public static final String KEY_UNEXPECTED_NAMESPACE = "unexpected-ns";
    public static final String KEY_APP_NAMESPACE = "app-namespace";
    private static final Implementation IMPLEMENTATION = new Implementation(FontDetector.class, Scope.RESOURCE_FILE_SCOPE);
    public static final Issue FONT_VALIDATION = Issue.create((String)"FontValidation", (String)"Validation of font files", (String)"Look for problems in various font files.", (Category)Category.CORRECTNESS, (int)8, (Severity)Severity.ERROR, (Implementation)IMPLEMENTATION).addMoreInfo("https://developer.android.com/guide/topics/text/downloadable-fonts.html").setAliases(Arrays.asList("FontValidationWarning", "FontValidationError"));
    public static final Module APPSUPPORT_MODULE = new Module("com.android.support", "appcompat-v7");
    private static final Version MIN_APPSUPPORT_VERSION = Version.parse((String)"26.0.0");
    private FontLoader mFontLoader;

    public boolean appliesTo(ResourceFolderType folderType) {
        return folderType == ResourceFolderType.FONT;
    }

    public Collection<String> getApplicableElements() {
        return Arrays.asList("font-family", "font");
    }

    public void beforeCheckRootProject(Context context) {
        if (this.mFontLoader == null) {
            this.mFontLoader = FontLoader.getInstance((File)context.getClient().getSdkHome());
        }
    }

    public void visitElement(XmlContext context, Element element) {
        boolean downloadableFontFile;
        Attr authority = element.getAttributeNodeNS("http://schemas.android.com/apk/res/android", "fontProviderAuthority");
        Attr query = element.getAttributeNodeNS("http://schemas.android.com/apk/res/android", "fontProviderQuery");
        Attr androidPackage = element.getAttributeNodeNS("http://schemas.android.com/apk/res/android", "fontProviderPackage");
        Attr certs = element.getAttributeNodeNS("http://schemas.android.com/apk/res/android", "fontProviderCerts");
        Attr appAuthority = element.getAttributeNodeNS("http://schemas.android.com/apk/res-auto", "fontProviderAuthority");
        Attr appQuery = element.getAttributeNodeNS("http://schemas.android.com/apk/res-auto", "fontProviderQuery");
        Attr appPackage = element.getAttributeNodeNS("http://schemas.android.com/apk/res-auto", "fontProviderPackage");
        Attr appCerts = element.getAttributeNodeNS("http://schemas.android.com/apk/res-auto", "fontProviderCerts");
        Attr firstAndroidAttribute = (Attr)Lint.coalesce((Object[])new Attr[]{authority, query, androidPackage, certs});
        Attr firstAppAttribute = (Attr)Lint.coalesce((Object[])new Attr[]{appAuthority, appQuery, appPackage, appCerts});
        List<String> missingAndroidAttributes = FontDetector.findMissingAttributes(authority, query, androidPackage, certs);
        List<String> missingAppAttributes = FontDetector.findMissingAttributes(appAuthority, appQuery, appPackage, appCerts);
        Element fontTag = XmlUtils.getFirstSubTagByName((Node)element, (String)"font");
        boolean bl = downloadableFontFile = Lint.coalesce((Object[])new Attr[]{firstAndroidAttribute, firstAppAttribute}) != null;
        if (downloadableFontFile) {
            FontDetector.checkSupportLibraryVersion(context, element);
            if (FontDetector.reportMisplacedFontTag(context, fontTag)) {
                return;
            }
            this.reportUnexpectedNamespace(context, firstAndroidAttribute, firstAppAttribute);
            FontProvider provider = this.reportUnknownProvider(context, authority, appAuthority);
            if (provider != null) {
                FontDetector.reportUnknownPackage(context, androidPackage, appPackage, provider);
                this.reportQueryProblem(context, query, appQuery, provider);
            }
            this.reportMissingAttribute(context, firstAndroidAttribute, firstAppAttribute, missingAndroidAttributes, missingAppAttributes, provider);
        }
    }

    private static List<String> findMissingAttributes(Attr authority, Attr query, Attr packageName, Attr certs) {
        if (authority != null && query != null && packageName != null && certs != null) {
            return Collections.emptyList();
        }
        ArrayList<String> missing = new ArrayList<String>();
        if (authority == null) {
            missing.add("fontProviderAuthority");
        }
        if (query == null) {
            missing.add("fontProviderQuery");
        }
        if (packageName == null) {
            missing.add("fontProviderPackage");
        }
        if (certs == null) {
            missing.add("fontProviderCerts");
        }
        return missing;
    }

    private static void checkSupportLibraryVersion(XmlContext context, Element element) {
        LintModelVariant variant = context.getProject().getBuildVariant();
        if (variant == null) {
            return;
        }
        LintModelLibrary library = variant.getArtifact().findCompileDependency("com.android.support:appcompat-v7");
        if (!(library instanceof LintModelExternalLibrary)) {
            return;
        }
        LintModelExternalLibrary extLibrary = (LintModelExternalLibrary)library;
        LintModelMavenName rc = extLibrary.getResolvedCoordinates();
        Version version = Version.parse((String)rc.getVersion());
        if (version.compareTo(MIN_APPSUPPORT_VERSION) < 0) {
            String message2 = "Using version " + version + " of the appcompat-v7 library. Required version for using downloadable fonts: " + MIN_APPSUPPORT_VERSION + " or higher.";
            LintFix fix2 = LintFix.create().data(new Object[]{KEY_ARTIFACT_ID, "appcompat-v7"});
            FontDetector.reportError(context, element, message2, context.getNameLocation((Node)element), fix2);
        }
    }

    private static boolean reportMisplacedFontTag(XmlContext context, Element fontTag) {
        if (fontTag == null) {
            return false;
        }
        LintFix fix2 = LintFix.create().replace().with("").range(context.getLocation((Node)fontTag)).build();
        FontDetector.reportError(context, fontTag, "A downloadable font cannot have a `<font>` sub tag", context.getElementLocation(fontTag), fix2);
        return true;
    }

    private void reportUnexpectedNamespace(XmlContext context, Attr firstAndroidAttribute, Attr firstAppAttribute) {
        if (context.getProject().getMinSdk() < 46 && firstAndroidAttribute != null) {
            this.reportUnexpectedNamespace(context, firstAndroidAttribute, true);
        }
        if (firstAppAttribute != null) {
            this.reportUnexpectedNamespace(context, firstAppAttribute, false);
        }
    }

    private void reportUnexpectedNamespace(XmlContext context, Attr first, boolean appNamespace) {
        AndroidVersion minSdk = context.getProject().getMinSdkVersion();
        String message2 = FontDetector.createUnexpectedAttributeMessage(appNamespace, minSdk);
        LintFix fix2 = LintFix.create().unset(first.getNamespaceURI(), first.getLocalName()).build();
        Incident incident = new Incident(FONT_VALIDATION, message2, context.getLocation((Node)first), (Object)first, fix2).overrideSeverity(Severity.WARNING);
        context.report(incident, this.map().put(KEY_UNEXPECTED_NAMESPACE, appNamespace));
    }

    private static String createUnexpectedAttributeMessage(boolean appNamespace, AndroidVersion minSdk) {
        String formatString = "For `minSdkVersion`=%1$d only `%2$s:` attributes should be used";
        String prefix = appNamespace ? "app" : "android";
        return String.format(Locale.US, formatString, minSdk.getApiLevel(), prefix);
    }

    public boolean filterIncident(Context context, Incident incident, LintMap map) {
        if (map.containsKey(KEY_UNEXPECTED_NAMESPACE)) {
            boolean app = map.getBoolean(KEY_UNEXPECTED_NAMESPACE, Boolean.valueOf(false));
            AndroidVersion minSdk = context.getMainProject().getMinSdkVersion();
            if (minSdk.getApiLevel() >= 46 ? app : !app) {
                return false;
            }
            String message2 = FontDetector.createUnexpectedAttributeMessage(app, minSdk);
            incident.setMessage(message2);
            return true;
        }
        if (map.containsKey(KEY_APP_NAMESPACE)) {
            boolean app = map.getBoolean(KEY_APP_NAMESPACE, Boolean.valueOf(false));
            AndroidVersion minSdk = context.getMainProject().getMinSdkVersion();
            if (minSdk.getFeatureLevel() <= 27) {
                return app;
            }
            return !app;
        }
        return false;
    }

    private void reportMissingAttribute(XmlContext context, Attr firstAndroidAttribute, Attr firstAppAttribute, List<String> missingAndroidAttributes, List<String> missingAppAttributes, FontProvider provider) {
        AndroidVersion minSdk = context.getProject().getMinSdkVersion();
        if (minSdk.getFeatureLevel() <= 27 && firstAppAttribute != null && !missingAppAttributes.isEmpty()) {
            this.reportMissingAppAttribute(context, firstAppAttribute, missingAppAttributes, true, provider);
        }
        if (firstAndroidAttribute != null && !missingAndroidAttributes.isEmpty()) {
            this.reportMissingAppAttribute(context, firstAndroidAttribute, missingAndroidAttributes, false, provider);
        }
    }

    private void reportMissingAppAttribute(XmlContext context, Attr firstFontAttribute, List<String> missingAttributes, boolean appNamespace, FontProvider provider) {
        String namespaceUri = appNamespace ? "http://schemas.android.com/apk/res-auto" : "http://schemas.android.com/apk/res/android";
        String namespacePrefix = appNamespace ? "app" : "android";
        String message2 = String.format("Missing required %1$s: %2$s:%3$s", StringUtil.pluralize((String)"attribute", (int)missingAttributes.size()), namespacePrefix, Joiner.on((String)(", " + namespacePrefix + ":")).join(missingAttributes));
        LintFix fix2 = this.makeMissingAttributeFix(missingAttributes, namespaceUri, provider);
        Element element = firstFontAttribute.getOwnerElement();
        Incident incident = new Incident(FONT_VALIDATION, (Object)element, context.getElementLocation(element), message2, fix2);
        context.report(incident, this.map().put(KEY_APP_NAMESPACE, appNamespace));
    }

    private LintFix makeMissingAttributeFix(List<String> missingAttributes, String namespaceUri, FontProvider provider) {
        if (provider == null) {
            provider = this.mFontLoader.findOnlyKnownProvider();
        }
        LintFix.GroupBuilder fix2 = this.fix().composite().name("Set missing attributes");
        for (String missingAttribute : missingAttributes) {
            String value = FontDetector.generateNewValue(missingAttribute, provider);
            if (value == null) {
                fix2.add(this.fix().set().todo(namespaceUri, missingAttribute).build());
                continue;
            }
            fix2.add(this.fix().set(namespaceUri, missingAttribute, value).build());
        }
        return fix2.build();
    }

    private static String generateNewValue(String missingAttribute, FontProvider provider) {
        if (provider == null) {
            return null;
        }
        switch (missingAttribute) {
            case "fontProviderAuthority": {
                return provider.getAuthority();
            }
            case "fontProviderPackage": {
                return provider.getPackageName();
            }
            case "fontProviderCerts": {
                return "@array/" + provider.getCertificateResourceName();
            }
        }
        return null;
    }

    private FontProvider reportUnknownProvider(XmlContext context, Attr attrAuthority, Attr attrAppAuthority) {
        String authority = attrAuthority != null ? attrAuthority.getValue() : null;
        String appAuthority = attrAppAuthority != null ? attrAppAuthority.getValue() : null;
        FontProvider provider = null;
        if (authority != null) {
            provider = this.reportUnknownProvider(context, attrAuthority, authority);
        } else if (appAuthority != null) {
            provider = this.reportUnknownProvider(context, attrAppAuthority, appAuthority);
        }
        return provider;
    }

    private FontProvider reportUnknownProvider(XmlContext context, Attr attrAuthority, String authority) {
        FontProvider provider = this.mFontLoader.findProvider(authority);
        if (provider != null) {
            return provider;
        }
        LintFix fix2 = null;
        FontProvider onlyKnownProvider = this.mFontLoader.findOnlyKnownProvider();
        if (onlyKnownProvider != null) {
            fix2 = this.fix().name("Replace with " + onlyKnownProvider.getAuthority()).replace().text(authority).with(onlyKnownProvider.getAuthority()).build();
        }
        FontDetector.reportError(context, attrAuthority, "Unknown font provider authority", context.getValueLocation(attrAuthority), fix2);
        return null;
    }

    private static void reportUnknownPackage(XmlContext context, Attr attrAndroidPackage, Attr attrAppPackage, FontProvider provider) {
        String appPackage;
        String androidPackage = attrAndroidPackage != null ? attrAndroidPackage.getValue() : null;
        String string = appPackage = attrAppPackage != null ? attrAppPackage.getValue() : null;
        if (androidPackage != null && !androidPackage.equals(provider.getPackageName())) {
            FontDetector.reportUnknownPackage(context, attrAndroidPackage, androidPackage, provider);
        } else if (appPackage != null && !appPackage.equals(provider.getPackageName())) {
            FontDetector.reportUnknownPackage(context, attrAppPackage, appPackage, provider);
        }
    }

    private static void reportUnknownPackage(XmlContext context, Attr attrPackage, String packageName, FontProvider provider) {
        if (provider.getPackageName().equals(packageName)) {
            return;
        }
        LintFix fix2 = LintFix.create().name("Replace with " + provider.getPackageName()).replace().text(packageName).with(provider.getPackageName()).build();
        FontDetector.reportError(context, attrPackage, "Unexpected font provider package", context.getValueLocation(attrPackage), fix2);
    }

    private void reportQueryProblem(XmlContext context, Attr androidQueryAttr, Attr appQueryAttr, FontProvider provider) {
        String appQuery;
        String androidQuery = androidQueryAttr != null ? androidQueryAttr.getValue() : null;
        String string = appQuery = appQueryAttr != null ? appQueryAttr.getValue() : null;
        if (androidQuery != null) {
            this.reportQueryProblem(context, androidQueryAttr, androidQuery, provider);
        } else if (appQuery != null) {
            this.reportQueryProblem(context, appQueryAttr, appQuery, provider);
        }
    }

    private void reportQueryProblem(XmlContext context, Attr queryAttr, String query, FontProvider provider) {
        if (query.isEmpty()) {
            LintFix fix2 = this.fix().set().todo(queryAttr.getNamespaceURI(), queryAttr.getLocalName()).build();
            FontDetector.reportError(context, queryAttr, "Missing provider query", context.getLocation((Node)queryAttr), fix2);
            return;
        }
        try {
            DownloadableParseResult result = QueryResolver.parseDownloadableFont((String)provider.getAuthority(), (String)XmlUtils.fromXmlAttributeValue((String)query));
            if (!this.mFontLoader.fontsLoaded()) {
                return;
            }
            for (String fontName : result.getFonts().keySet()) {
                FontFamily family = this.mFontLoader.findFont(provider, fontName);
                if (family == null) {
                    FontDetector.reportError(context, queryAttr, "Unknown font: " + fontName, context.getValueLocation(queryAttr), null);
                    continue;
                }
                for (MutableFontDetail detail : result.getFonts().get((Object)fontName)) {
                    FontDetail best = detail.findBestMatch((Collection)family.getFonts());
                    if (best == null || detail.match(best) == 0.0f) continue;
                    LintFix fix3 = null;
                    if (result.getFonts().size() == 1) {
                        boolean isV11;
                        if (!detail.getExact()) {
                            MutableFontDetail builder = best.toMutableFontDetail();
                            builder.setExact(false);
                            best = new FontDetail(best.getFamily(), builder);
                        }
                        String better = (isV11 = query.startsWith("name=")) ? best.generateQueryV11() : best.generateQueryV12();
                        fix3 = this.fix().name("Replace with closest font: " + better).set(queryAttr.getNamespaceURI(), queryAttr.getLocalName(), better).build();
                    }
                    if (detail.getExact()) {
                        FontDetector.reportError(context, queryAttr, "No exact match found for: " + fontName, context.getValueLocation(queryAttr), fix3);
                        continue;
                    }
                    FontDetector.reportWarning(context, queryAttr, "No exact match found for: " + fontName, context.getValueLocation(queryAttr), fix3);
                }
            }
        }
        catch (FontQueryParserError ex) {
            FontDetector.reportError(context, queryAttr, ex.getMessage(), context.getValueLocation(queryAttr), null);
        }
    }

    private static void reportError(XmlContext context, Node node, String message2, Location location, LintFix fix2) {
        Incident incident = new Incident(FONT_VALIDATION, (Object)node, location, message2, fix2).overrideSeverity(Severity.ERROR);
        context.report(incident);
    }

    private static void reportWarning(XmlContext context, Node node, String message2, Location location, LintFix fix2) {
        Incident incident = new Incident(FONT_VALIDATION, (Object)node, location, message2, fix2).overrideSeverity(Severity.WARNING);
        context.report(incident);
    }
}

