/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.checks;

import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.Detector;
import com.android.tools.lint.detector.api.Implementation;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.JavaContext;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import com.android.tools.lint.detector.api.SourceCodeScanner;
import com.intellij.psi.PsiMethod;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.uast.UCallExpression;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UExpression;
import org.jetbrains.uast.ULiteralExpression;

public class NonInternationalizedSmsDetector
extends Detector
implements SourceCodeScanner {
    public static final Issue ISSUE = Issue.create((String)"UnlocalizedSms", (String)"SMS phone number missing country code", (String)"SMS destination numbers must start with a country code or the application code must ensure that the SMS is only sent when the user is in the same country as the receiver.", (Category)Category.CORRECTNESS, (int)5, (Severity)Severity.WARNING, (Implementation)new Implementation(NonInternationalizedSmsDetector.class, Scope.JAVA_FILE_SCOPE)).setAndroidSpecific(true);

    public List<String> getApplicableMethodNames() {
        ArrayList<String> methodNames = new ArrayList<String>(2);
        methodNames.add("sendTextMessage");
        methodNames.add("sendMultipartTextMessage");
        return methodNames;
    }

    public void visitMethodCall(JavaContext context, UCallExpression call2, PsiMethod method) {
        if (call2.getReceiver() == null) {
            return;
        }
        List args = call2.getValueArguments();
        if (args.size() != 5) {
            return;
        }
        UExpression destinationAddress = (UExpression)args.get(0);
        if (!(destinationAddress instanceof ULiteralExpression)) {
            return;
        }
        Object literal = ((ULiteralExpression)destinationAddress).getValue();
        if (!(literal instanceof String)) {
            return;
        }
        String number = (String)literal;
        if (number.startsWith("+")) {
            return;
        }
        context.report(ISSUE, (UElement)call2, context.getLocation((UElement)destinationAddress), "To make sure the SMS can be sent by all users, please start the SMS number with a + and a country code or restrict the code invocation to people in the country you are targeting");
    }
}

