/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.checks;

import com.android.ide.common.gradle.Dependency;
import com.android.ide.common.gradle.Version;
import com.android.ide.common.pagealign.PageAlignUtilsKt;
import com.android.tools.lint.checks.GradleDetector;
import com.android.tools.lint.checks.Lint;
import com.android.tools.lint.client.api.LintClient;
import com.android.tools.lint.client.api.LintTomlDocument;
import com.android.tools.lint.client.api.LintTomlMapValue;
import com.android.tools.lint.client.api.LintTomlParser;
import com.android.tools.lint.client.api.LintTomlValue;
import com.android.tools.lint.client.api.TomlContext;
import com.android.tools.lint.client.api.TomlScanner;
import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.Context;
import com.android.tools.lint.detector.api.Detector;
import com.android.tools.lint.detector.api.GradleContext;
import com.android.tools.lint.detector.api.GradleScanner;
import com.android.tools.lint.detector.api.Implementation;
import com.android.tools.lint.detector.api.Incident;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.Location;
import com.android.tools.lint.detector.api.Project;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import com.android.tools.lint.model.LintModelAndroidLibrary;
import com.android.tools.lint.model.LintModelArtifact;
import com.android.tools.lint.model.LintModelDependencies;
import com.android.tools.lint.model.LintModelLibrary;
import com.android.tools.lint.model.LintModelMavenName;
import com.android.tools.lint.model.LintModelVariant;
import java.io.BufferedInputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000h\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 ,2\u00020\u00012\u00020\u00022\u00020\u0003:\u0001,B\u0007\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J\u0018\u0010\u000e\u001a\u00020\t2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\bH\u0002J\u0018\u0010\u0012\u001a\u00020\u000b2\u0006\u0010\u0013\u001a\u00020\b2\u0006\u0010\u0014\u001a\u00020\tH\u0002J\u0010\u0010\u0015\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016JJ\u0010\u0016\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u00192\u0006\u0010\u001b\u001a\u00020\u00192\b\u0010\u001c\u001a\u0004\u0018\u00010\u00192\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\u001e2\u0006\u0010 \u001a\u00020\u001eH\u0016J\u0018\u0010!\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\"2\u0006\u0010#\u001a\u00020$H\u0016J\u0018\u0010%\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010#\u001a\u00020$H\u0002J0\u0010&\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\b\u0010'\u001a\u0004\u0018\u00010\u00192\u0006\u0010(\u001a\u00020\u00192\f\u0010)\u001a\b\u0012\u0004\u0012\u00020+0*H\u0002R\u001c\u0010\u0006\u001a\u0010\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t\u0018\u00010\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006-"}, d2={"Lcom/android/tools/lint/checks/PageAlignmentDetector;", "Lcom/android/tools/lint/detector/api/Detector;", "Lcom/android/tools/lint/detector/api/GradleScanner;", "Lcom/android/tools/lint/client/api/TomlScanner;", "<init>", "()V", "reportCoordinates", "", "Lcom/android/tools/lint/model/LintModelMavenName;", "Lcom/android/tools/lint/detector/api/Incident;", "beforeCheckRootProject", "", "context", "Lcom/android/tools/lint/detector/api/Context;", "createIncident", "sharedLibrary", "Ljava/io/File;", "coordinates", "recordIncident", "coordinate", "incident", "afterCheckRootProject", "checkDslPropertyAssignment", "Lcom/android/tools/lint/detector/api/GradleContext;", "property", "", "value", "parent", "parentParent", "propertyCookie", "", "valueCookie", "statementCookie", "visitTomlDocument", "Lcom/android/tools/lint/client/api/TomlContext;", "document", "Lcom/android/tools/lint/client/api/LintTomlDocument;", "checkTomlDocument", "checkArtifactReference", "groupId", "artifactId", "locationProvider", "Lkotlin/Function0;", "Lcom/android/tools/lint/detector/api/Location;", "Companion", "lint-checks"})
@SourceDebugExtension(value={"SMAP\nPageAlignmentDetector.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PageAlignmentDetector.kt\ncom/android/tools/lint/checks/PageAlignmentDetector\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,487:1\n1#2:488\n*E\n"})
public final class PageAlignmentDetector
extends Detector
implements GradleScanner,
TomlScanner {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private Map<LintModelMavenName, Incident> reportCoordinates;
    @NotNull
    private static final File ALIGNED = new File("16kb-aligned");
    @NotNull
    private static final HashMap<LintModelMavenName, File> alignedCache = new HashMap();
    @JvmField
    @NotNull
    public static final Issue ISSUE;

    public void beforeCheckRootProject(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        if (context.getDriver().isIsolated()) {
            return;
        }
        Project project = context.getProject();
        LintModelVariant variant = project.getBuildVariant();
        if (variant != null) {
            LintModelArtifact artifact = variant.getArtifact();
            LintModelDependencies dependencies = artifact.getDependencies();
            for (LintModelLibrary androidLibrary : dependencies.getAll()) {
                File unalignedLibrary;
                if (!(androidLibrary instanceof LintModelAndroidLibrary) || (unalignedLibrary = PageAlignmentDetector.Companion.getUnalignedLibraryFile((LintModelAndroidLibrary)androidLibrary)) == null) continue;
                LintModelMavenName coordinates = ((LintModelAndroidLibrary)androidLibrary).getResolvedCoordinates();
                Incident incident = this.createIncident(unalignedLibrary, coordinates);
                this.recordIncident(coordinates, incident);
            }
        }
    }

    private final Incident createIncident(File sharedLibrary, LintModelMavenName coordinates) {
        Location location = Location.Companion.create(sharedLibrary);
        File file = sharedLibrary.getParentFile();
        String libraryName = (file != null ? file.getName() : null) + "/" + sharedLibrary.getName();
        String message2 = "The native library `" + libraryName + "` (from `" + coordinates + "`) is not 16 KB aligned";
        Incident incident = new Incident(ISSUE, location, message2);
        return incident;
    }

    private final void recordIncident(LintModelMavenName coordinate, Incident incident) {
        Map map = this.reportCoordinates;
        if (map == null) {
            Map map2;
            Map it = map2 = (Map)new LinkedHashMap();
            boolean bl = false;
            this.reportCoordinates = it;
            map = map2;
        }
        Map targetList = map;
        targetList.put((LintModelMavenName)coordinate, (Incident)incident);
    }

    public void afterCheckRootProject(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Map<LintModelMavenName, Incident> map = this.reportCoordinates;
        if (map == null) {
            return;
        }
        Map<LintModelMavenName, Incident> targets = map;
        if (targets.isEmpty()) {
            return;
        }
        if (LintClient.Companion.isStudio()) {
            File catalog;
            LintClient client = context.getClient();
            Location location = null;
            File file = context.getProject().getDir();
            Intrinsics.checkNotNullExpressionValue((Object)file, (String)"getDir(...)");
            File gradleRoot = com.android.tools.lint.detector.api.Lint.findGradleRootDir((File)file);
            if (gradleRoot != null && (catalog = new File(gradleRoot, "gradle/libs.versions.toml")).isFile()) {
                location = Location.Companion.create(catalog);
                CharSequence contents = client.readFile(catalog);
                LintTomlDocument document = LintTomlParser.parse$default((LintTomlParser)client.getTomlParser(), (File)catalog, (CharSequence)contents, null, (int)4, null);
                this.checkTomlDocument(context, document);
                Map<LintModelMavenName, Incident> map2 = this.reportCoordinates;
                if (map2 == null) {
                    return;
                }
                targets = map2;
            }
            if (location == null) {
                location = com.android.tools.lint.detector.api.Lint.guessGradleLocation((Project)context.getProject());
            }
            Iterator<Map.Entry<LintModelMavenName, Incident>> iterator = targets.entrySet().iterator();
            while (iterator.hasNext()) {
                Incident incident = iterator.next().getValue();
                incident.setLocation(location);
            }
        }
        Iterator<Map.Entry<LintModelMavenName, Incident>> iterator = targets.entrySet().iterator();
        while (iterator.hasNext()) {
            Incident incident = iterator.next().getValue();
            context.report(incident);
            iterator.remove();
        }
        this.reportCoordinates = null;
    }

    public void checkDslPropertyAssignment(@NotNull GradleContext context, @NotNull String property, @NotNull String value, @NotNull String parent, @Nullable String parentParent, @NotNull Object propertyCookie, @NotNull Object valueCookie, @NotNull Object statementCookie) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)property, (String)"property");
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        Intrinsics.checkNotNullParameter((Object)parent, (String)"parent");
        Intrinsics.checkNotNullParameter((Object)propertyCookie, (String)"propertyCookie");
        Intrinsics.checkNotNullParameter((Object)valueCookie, (String)"valueCookie");
        Intrinsics.checkNotNullParameter((Object)statementCookie, (String)"statementCookie");
        Map<LintModelMavenName, Incident> targets = this.reportCoordinates;
        if (!context.getDriver().isIsolated() && targets == null) {
            return;
        }
        if (Intrinsics.areEqual((Object)parent, (Object)"dependencies") || Intrinsics.areEqual((Object)parent, (Object)"declarativeDependencies")) {
            String dependencyString;
            String string = GradleContext.Companion.getStringLiteralValue(value, valueCookie);
            if (string == null) {
                string = GradleDetector.Companion.getNamedDependency(value);
            }
            if ((dependencyString = string) != null) {
                Dependency dependency = Dependency.Companion.parse(dependencyString);
                String string2 = dependency.getGroup();
                if (string2 == null) {
                    return;
                }
                String groupId = string2;
                String artifactId = dependency.getName();
                if (targets == null) {
                    this.checkArtifactReference((Context)context, groupId, dependency.getName(), (Function0<? extends Location>)((Function0)new Function0<Location>(context, valueCookie){
                        final /* synthetic */ GradleContext $context;
                        final /* synthetic */ Object $valueCookie;
                        {
                            this.$context = $context;
                            this.$valueCookie = $valueCookie;
                            super(0);
                        }

                        public final Location invoke() {
                            return this.$context.getLocation(this.$valueCookie);
                        }
                    }));
                } else {
                    for (Map.Entry<LintModelMavenName, Incident> entry : targets.entrySet()) {
                        LintModelMavenName coordinate = entry.getKey();
                        Incident incident = entry.getValue();
                        if (!Intrinsics.areEqual((Object)coordinate.getGroupId(), (Object)groupId) || !Intrinsics.areEqual((Object)coordinate.getArtifactId(), (Object)artifactId)) continue;
                        incident.setLocation(context.getLocation(valueCookie));
                        context.report(incident);
                        targets.remove(coordinate);
                        return;
                    }
                }
            }
        }
    }

    public void visitTomlDocument(@NotNull TomlContext context, @NotNull LintTomlDocument document) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)document, (String)"document");
        this.checkTomlDocument((Context)context, document);
    }

    private final void checkTomlDocument(Context context, LintTomlDocument document) {
        LintTomlMapValue libraries;
        Map<LintModelMavenName, Incident> targets = this.reportCoordinates;
        if (!context.getDriver().isIsolated() && targets == null) {
            return;
        }
        LintTomlValue lintTomlValue = document.getValue("libraries");
        LintTomlMapValue lintTomlMapValue = libraries = lintTomlValue instanceof LintTomlMapValue ? (LintTomlMapValue)lintTomlValue : null;
        if (libraries != null) {
            Object object = document.getValue("versions");
            LintTomlMapValue versions = object instanceof LintTomlMapValue ? (LintTomlMapValue)object : null;
            object = libraries.getMappedValues().entrySet().iterator();
            while (object.hasNext()) {
                String groupId;
                String coordinate;
                Dependency dependency;
                LintTomlValue library = (LintTomlValue)((Map.Entry)object.next()).getValue();
                Pair<String, LintTomlValue> pair = Lint.getLibraryFromTomlEntry(versions, library);
                if (pair == null || (dependency = Dependency.Companion.parse(coordinate = (String)pair.component1())).getGroup() == null) continue;
                String artifactId = dependency.getName();
                if (targets != null) {
                    for (Map.Entry<LintModelMavenName, Incident> entry : targets.entrySet()) {
                        LintModelMavenName coordinate2 = entry.getKey();
                        Incident incident = entry.getValue();
                        if (!Intrinsics.areEqual((Object)coordinate2.getGroupId(), (Object)groupId) || !Intrinsics.areEqual((Object)coordinate2.getArtifactId(), (Object)artifactId)) continue;
                        incident.setLocation(Context.getLocation$default((Context)context, (Object)library, null, (int)2, null));
                        context.report(incident);
                        targets.remove(coordinate2);
                        return;
                    }
                    continue;
                }
                this.checkArtifactReference(context, groupId, artifactId, (Function0<? extends Location>)((Function0)new Function0<Location>(context, library){
                    final /* synthetic */ Context $context;
                    final /* synthetic */ LintTomlValue $library;
                    {
                        this.$context = $context;
                        this.$library = $library;
                        super(0);
                    }

                    public final Location invoke() {
                        return Context.getLocation$default((Context)this.$context, (Object)this.$library, null, (int)2, null);
                    }
                }));
            }
        }
    }

    private final void checkArtifactReference(Context context, String groupId, String artifactId, Function0<? extends Location> locationProvider) {
        File unalignedLibrary;
        LintModelLibrary androidLibrary;
        if (groupId == null) {
            return;
        }
        boolean full = context.isGlobalAnalysis();
        Project project = full ? context.getMainProject() : context.getProject();
        LintModelVariant lintModelVariant = project.getBuildVariant();
        LintModelLibrary lintModelLibrary = lintModelVariant != null && (lintModelVariant = lintModelVariant.getArtifact()) != null ? lintModelVariant.findCompileDependency(groupId, artifactId) : (androidLibrary = null);
        if (androidLibrary instanceof LintModelAndroidLibrary && (unalignedLibrary = PageAlignmentDetector.Companion.getUnalignedLibraryFile((LintModelAndroidLibrary)androidLibrary)) != null) {
            LintModelMavenName coordinates = ((LintModelAndroidLibrary)androidLibrary).getResolvedCoordinates();
            Incident incident = this.createIncident(unalignedLibrary, coordinates);
            incident.setLocation((Location)locationProvider.invoke());
            context.report(incident);
        }
    }

    static {
        Issue.Companion companion = Issue.Companion;
        Category category = Category.CORRECTNESS;
        Severity severity = Severity.WARNING;
        EnumSet[] enumSetArray = new EnumSet[]{Scope.GRADLE_SCOPE, Scope.TOML_SCOPE};
        Implementation implementation = new Implementation(PageAlignmentDetector.class, Scope.GRADLE_AND_TOML_SCOPE, enumSetArray);
        ISSUE = Issue.Companion.create$default((Issue.Companion)companion, (String)"Aligned16KB", (String)"Native library dependency not 16 KB aligned", (String)"\n          Android has traditionally used 4 KB memory page sizes. However, to support \\\n          future devices that only work with 16 KB aligned libraries apps containing \\\n          native libraries need to be built with 16 KB alignment.\n\n          Apps with 4 KB aligned native libraries may not work correctly on devices \\\n          requiring 16 KB alignment. To ensure compatibility and future-proof your \\\n          app, it is strongly recommended that your native libraries are aligned to 16 \\\n          KB boundaries.\n\n          If your app uses any NDK libraries, directly or indirectly through an SDK, \\\n          you should rebuild your app to meet this recommendation. Make sure all \\\n          native libraries within your application, including those from dependencies, \\\n          are built with 16 KB page alignment.\n\n          This lint check looks at all native libraries that your app depends on. If \\\n          any are found to be aligned to 4 KB instead of 16 KB, you will need to \\\n          address this.\n\n          When a library is flagged, first try to update to a newer version that \\\n          supports 16 KB alignment. If an updated version is not available, contact \\\n          the library vendor to ask about their plans for 16 KB support and request a \\\n          compatible version. Updating your libraries proactively will help ensure \\\n          your app works properly on a wider range of devices.\n          ", (Implementation)implementation, (String)"https://developer.android.com/guide/practices/page-sizes", (Category)category, (int)2, (Severity)severity, (boolean)false, (Boolean)true, null, null, (int)3328, null);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0012\u0010\n\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u001e\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u0012\u001a\u00020\u0010R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R*\u0010\u0006\u001a\u001e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\u00050\u0007j\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\u0005`\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0013\u001a\u00020\u00148\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lcom/android/tools/lint/checks/PageAlignmentDetector$Companion;", "", "<init>", "()V", "ALIGNED", "Ljava/io/File;", "alignedCache", "Ljava/util/HashMap;", "Lcom/android/tools/lint/model/LintModelMavenName;", "Lkotlin/collections/HashMap;", "getUnalignedLibraryFile", "library", "Lcom/android/tools/lint/model/LintModelAndroidLibrary;", "isSafe", "", "group", "", "artifact", "version", "ISSUE", "Lcom/android/tools/lint/detector/api/Issue;", "lint-checks"})
    public static final class Companion {
        private Companion() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final File getUnalignedLibraryFile(LintModelAndroidLibrary library) {
            File folder;
            File jniFolder;
            String version;
            String artifact;
            LintModelMavenName coordinate = library.getResolvedCoordinates();
            String group = coordinate.getGroupId();
            if (this.isSafe(group, artifact = coordinate.getArtifactId(), version = coordinate.getVersion())) {
                return null;
            }
            boolean useCache = LintClient.Companion.isStudio();
            if (useCache) {
                File cached = (File)alignedCache.get(coordinate);
                if (cached != null) {
                    return cached == ALIGNED ? null : cached;
                }
                ((Map)alignedCache).put(coordinate, ALIGNED);
            }
            if ((jniFolder = new File(folder = library.getFolder(), "jni")).isDirectory()) {
                File unalignedLibrary = null;
                File[] fileArray = jniFolder.listFiles();
                Intrinsics.checkNotNullExpressionValue((Object)fileArray, (String)"listFiles(...)");
                for (File abiFolder : ArraysKt.sorted((Comparable[])fileArray)) {
                    File[] fileArray2 = abiFolder.listFiles();
                    Intrinsics.checkNotNullExpressionValue((Object)fileArray2, (String)"listFiles(...)");
                    for (File sharedLibrary : ArraysKt.sorted((Comparable[])fileArray2)) {
                        if (!sharedLibrary.isFile()) continue;
                        Intrinsics.checkNotNull((Object)sharedLibrary);
                        Closeable closeable = new FileInputStream(sharedLibrary);
                        int n = 8192;
                        BufferedInputStream input = closeable instanceof BufferedInputStream ? (BufferedInputStream)closeable : new BufferedInputStream((InputStream)closeable, n);
                        closeable = input;
                        Throwable throwable = null;
                        try {
                            long minimumLoadSectionAlignment;
                            BufferedInputStream it = (BufferedInputStream)closeable;
                            boolean bl = false;
                            if (PageAlignUtilsKt.hasElfMagicNumber((InputStream)input) && (minimumLoadSectionAlignment = PageAlignUtilsKt.readElfMinimumLoadSectionAlignment((InputStream)input)) != -1L && !PageAlignUtilsKt.is16kAligned((long)minimumLoadSectionAlignment)) {
                                unalignedLibrary = sharedLibrary;
                            }
                            Unit unit = Unit.INSTANCE;
                        }
                        catch (Throwable throwable2) {
                            throwable = throwable2;
                            throw throwable2;
                        }
                        finally {
                            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
                        }
                        if (unalignedLibrary == null) continue;
                    }
                }
                if (useCache && unalignedLibrary != null) {
                    ((Map)alignedCache).put(coordinate, unalignedLibrary);
                }
                return unalignedLibrary;
            }
            return null;
        }

        /*
         * Unable to fully structure code
         */
        public final boolean isSafe(@NotNull String group, @NotNull String artifact, @NotNull String version) {
            Intrinsics.checkNotNullParameter((Object)group, (String)"group");
            Intrinsics.checkNotNullParameter((Object)artifact, (String)"artifact");
            Intrinsics.checkNotNullParameter((Object)version, (String)"version");
            var5_4 = group;
            tmp = -1;
            switch (var5_4.hashCode()) {
                case 2047842351: {
                    if (var5_4.equals("com.google.mlkit")) {
                        tmp = 1;
                    }
                    break;
                }
                case -254881046: {
                    if (var5_4.equals("com.google.mediapipe")) {
                        tmp = 2;
                    }
                    break;
                }
                case 1221386052: {
                    if (var5_4.equals("androidx.appsearch")) {
                        tmp = 3;
                    }
                    break;
                }
                case -1525145678: {
                    if (var5_4.equals("androidx.datastore")) {
                        tmp = 4;
                    }
                    break;
                }
                case 1157070781: {
                    if (var5_4.equals("androidx.tracing")) {
                        tmp = 5;
                    }
                    break;
                }
                case 325967270: {
                    if (var5_4.equals("com.google.android.gms")) {
                        tmp = 6;
                    }
                    break;
                }
                case 479675259: {
                    if (var5_4.equals("com.google.ar.sceneform")) {
                        tmp = 7;
                    }
                    break;
                }
                case -775692273: {
                    if (var5_4.equals("org.chromium.net")) {
                        tmp = 8;
                    }
                    break;
                }
                case 339729136: {
                    if (var5_4.equals("androidx.graphics")) {
                        tmp = 9;
                    }
                    break;
                }
                case -284053597: {
                    if (var5_4.equals("com.google.ai.edge.litert")) {
                        tmp = 10;
                    }
                    break;
                }
                case 117701712: {
                    if (var5_4.equals("com.google.android.libraries.navigation")) {
                        tmp = 11;
                    }
                    break;
                }
                case -225004625: {
                    if (var5_4.equals("com.google.firebase")) {
                        tmp = 12;
                    }
                    break;
                }
                case -278426150: {
                    if (var5_4.equals("com.google.android.games")) {
                        tmp = 13;
                    }
                    break;
                }
                case 891759577: {
                    if (var5_4.equals("com.google.ar")) {
                        tmp = 14;
                    }
                    break;
                }
                case 1067882489: {
                    if (var5_4.equals("com.crashlytics.sdk.android")) {
                        tmp = 15;
                    }
                    break;
                }
            }
            block17 : switch (tmp) {
                case 3: {
                    if (Intrinsics.areEqual((Object)artifact, (Object)"appsearch-local-storage")) {
                        v0 = "1.1.0-alpha03";
                        break;
                    }
                    v0 = null;
                    break;
                }
                case 4: {
                    if (Intrinsics.areEqual((Object)artifact, (Object)"datastore-core-android")) {
                        v0 = "1.1.0-beta01";
                        break;
                    }
                    v0 = null;
                    break;
                }
                case 9: {
                    var6_5 = artifact;
                    if (Intrinsics.areEqual((Object)var6_5, (Object)"graphics-core")) {
                        v0 = "1.0.0-beta01";
                        break;
                    }
                    if (Intrinsics.areEqual((Object)var6_5, (Object)"graphics-path")) {
                        v0 = "1.0.0-beta02";
                        break;
                    }
                    v0 = null;
                    break;
                }
                case 5: {
                    if (Intrinsics.areEqual((Object)artifact, (Object)"tracing-perfetto-binary")) {
                        v0 = "1.0.0";
                        break;
                    }
                    v0 = null;
                    break;
                }
                case 15: {
                    if (Intrinsics.areEqual((Object)artifact, (Object)"crashlytics-ndk")) {
                        v0 = "2.1.1";
                        break;
                    }
                    v0 = null;
                    break;
                }
                case 10: {
                    var6_5 = artifact;
                    if (Intrinsics.areEqual((Object)var6_5, (Object)"litert-gpu")) {
                        v0 = "1.0.1";
                        break;
                    }
                    if (Intrinsics.areEqual((Object)var6_5, (Object)"litert")) {
                        v0 = "1.0.1";
                        break;
                    }
                    v0 = null;
                    break;
                }
                case 13: {
                    if (Intrinsics.areEqual((Object)artifact, (Object)"memory-advice")) {
                        v0 = "0.24";
                        break;
                    }
                    v0 = null;
                    break;
                }
                case 6: {
                    var6_5 = artifact;
                    switch (var6_5.hashCode()) {
                        case 1686863899: {
                            if (!var6_5.equals("play-services-vision-image-labeling-internal")) {
                                ** break;
                            }
                            ** GOTO lbl151
                        }
                        case -1982033711: {
                            if (var6_5.equals("play-services-vision-face-contour-internal")) break;
                            ** break;
                        }
                        case 1956074425: {
                            if (!var6_5.equals("play-services-tflite-java")) ** break;
                            v0 = "16.2.0-beta02";
                            break block17;
                        }
                    }
                    v0 = "16.1.0";
                    break;
lbl151:
                    // 1 sources

                    v0 = "16.1.0";
                    break;
lbl153:
                    // 4 sources

                    v0 = null;
                    break;
                }
                case 11: {
                    if (Intrinsics.areEqual((Object)artifact, (Object)"navigation")) {
                        v0 = "5.2.5";
                        break;
                    }
                    v0 = null;
                    break;
                }
                case 14: {
                    if (Intrinsics.areEqual((Object)artifact, (Object)"core")) {
                        v0 = "1.42.0";
                        break;
                    }
                    v0 = null;
                    break;
                }
                case 7: {
                    var6_5 = artifact;
                    switch (var6_5.hashCode()) {
                        case 3059615: {
                            if (!var6_5.equals("core")) {
                                ** break;
                            }
                            ** GOTO lbl187
                        }
                        case -1408207997: {
                            if (var6_5.equals("assets")) break;
                            ** break;
                        }
                        case -1627426184: {
                            if (!var6_5.equals("filament-android")) {
                                ** break;
                            }
                            ** GOTO lbl189
                        }
                        case 1118509956: {
                            if (!var6_5.equals("animation")) ** break;
                            v0 = "1.17.1";
                            break block17;
                        }
                    }
                    v0 = "1.17.1";
                    break;
lbl187:
                    // 1 sources

                    v0 = "1.17.1";
                    break;
lbl189:
                    // 1 sources

                    v0 = "1.17.1";
                    break;
lbl191:
                    // 5 sources

                    v0 = null;
                    break;
                }
                case 12: {
                    var6_5 = artifact;
                    tmp = -1;
                    switch (var6_5.hashCode()) {
                        case 1420790011: {
                            if (var6_5.equals("firebase-crashlytics-ndk")) {
                                tmp = 1;
                            }
                            break;
                        }
                        case -1920513181: {
                            if (var6_5.equals("firebase-ml-natural-language-language-id-model")) {
                                tmp = 2;
                            }
                            break;
                        }
                        case 886441025: {
                            if (var6_5.equals("firebase-ml-natural-language-translate-model")) {
                                tmp = 3;
                            }
                            break;
                        }
                        case -577192929: {
                            if (var6_5.equals("firebase-ml-vision-barcode-model")) {
                                tmp = 4;
                            }
                            break;
                        }
                        case -1122989799: {
                            if (var6_5.equals("firebase-ml-natural-language-smart-reply-model")) {
                                tmp = 5;
                            }
                            break;
                        }
                        case -384492440: {
                            if (var6_5.equals("firebase-ml-vision-internal-vkp")) {
                                tmp = 6;
                            }
                            break;
                        }
                    }
                    switch (tmp) {
                        case 1: {
                            v0 = "19.0.1";
                            break block17;
                        }
                        case 2: {
                            v0 = "20.0.8";
                            break block17;
                        }
                        case 5: {
                            v0 = "20.0.8";
                            break block17;
                        }
                        case 3: {
                            v0 = "20.0.9";
                            break block17;
                        }
                        case 4: {
                            v0 = "16.1.2";
                            break block17;
                        }
                        case 6: {
                            v0 = "17.0.2";
                            break block17;
                        }
                    }
                    v0 = null;
                    break;
                }
                case 2: {
                    var6_5 = artifact;
                    switch (var6_5.hashCode()) {
                        case 1656213255: {
                            if (!var6_5.equals("tasks-vision")) {
                                ** break;
                            }
                            ** GOTO lbl283
                        }
                        case 588564695: {
                            if (var6_5.equals("tasks-audio")) break;
                            ** break;
                        }
                        case -1991421413: {
                            if (!var6_5.equals("tasks-vision-image-generator")) {
                                ** break;
                            }
                            ** GOTO lbl281
                        }
                        case 1820652556: {
                            if (!var6_5.equals("tasks-text")) {
                                ** break;
                            }
                            ** GOTO lbl279
                        }
                        case 593638521: {
                            if (!var6_5.equals("tasks-genai")) {
                                ** break;
                            }
                            ** GOTO lbl277
                        }
                        case 1769867123: {
                            if (!var6_5.equals("solution-core")) ** break;
                            v0 = "0.10.20";
                            break block17;
                        }
                    }
                    v0 = "0.20230731";
                    break;
lbl277:
                    // 1 sources

                    v0 = "0.10.20";
                    break;
lbl279:
                    // 1 sources

                    v0 = "0.20230731";
                    break;
lbl281:
                    // 1 sources

                    v0 = "0.10.20";
                    break;
lbl283:
                    // 1 sources

                    v0 = "0.20230731";
                    break;
lbl285:
                    // 7 sources

                    v0 = null;
                    break;
                }
                case 1: {
                    var6_5 = artifact;
                    tmp = -1;
                    switch (var6_5.hashCode()) {
                        case -222362786: {
                            if (var6_5.equals("barcode-scanning")) {
                                tmp = 1;
                            }
                            break;
                        }
                        case 421773072: {
                            if (var6_5.equals("vision-internal-vkp")) {
                                tmp = 2;
                            }
                            break;
                        }
                        case 48982892: {
                            if (var6_5.equals("text-recognition-bundled-common")) {
                                tmp = 3;
                            }
                            break;
                        }
                        case -1175895120: {
                            if (var6_5.equals("language-id")) {
                                tmp = 4;
                            }
                            break;
                        }
                        case 711666705: {
                            if (var6_5.equals("entity-extraction")) {
                                tmp = 5;
                            }
                            break;
                        }
                        case 1248022168: {
                            if (var6_5.equals("mediapipe-internal")) {
                                tmp = 6;
                            }
                            break;
                        }
                        case -1552531813: {
                            if (var6_5.equals("digital-ink-recognition")) {
                                tmp = 7;
                            }
                            break;
                        }
                        case -1580695066: {
                            if (var6_5.equals("smart-reply")) {
                                tmp = 8;
                            }
                            break;
                        }
                        case 1052832078: {
                            if (var6_5.equals("translate")) {
                                tmp = 9;
                            }
                            break;
                        }
                    }
                    switch (tmp) {
                        case 1: {
                            v0 = "17.2.0";
                            break block17;
                        }
                        case 7: {
                            v0 = "18.1.0";
                            break block17;
                        }
                        case 5: {
                            v0 = "16.0.0-beta5";
                            break block17;
                        }
                        case 4: {
                            v0 = "17.0.5";
                            break block17;
                        }
                        case 6: {
                            v0 = "17.0.0-beta9";
                            break block17;
                        }
                        case 8: {
                            v0 = "17.0.3";
                            break block17;
                        }
                        case 3: {
                            v0 = "16.0.0";
                            break block17;
                        }
                        case 9: {
                            v0 = "17.0.2";
                            break block17;
                        }
                        case 2: {
                            v0 = "18.2.2";
                            break block17;
                        }
                    }
                    v0 = null;
                    break;
                }
                case 8: {
                    if (Intrinsics.areEqual((Object)artifact, (Object)"cronet-embedded")) {
                        v0 = "119.6045.31";
                        break;
                    }
                    v0 = null;
                    break;
                }
                default: {
                    v0 = lastBroken = null;
                }
            }
            if (lastBroken == null) {
                return StringsKt.startsWith$default((String)group, (String)"androidx.", (boolean)false, (int)2, null) != false || StringsKt.startsWith$default((String)group, (String)"com.google.", (boolean)false, (int)2, null) != false || StringsKt.startsWith$default((String)group, (String)"com.android.", (boolean)false, (int)2, null) != false || Intrinsics.areEqual((Object)group, (Object)"org.chromium.net") != false || StringsKt.startsWith$default((String)group, (String)"com.crashlytics.", (boolean)false, (int)2, null) != false;
            }
            parsedVersion = Version.Companion.parse(version);
            return parsedVersion.compareTo(parsedLastBrokenVersion = Version.Companion.parse(lastBroken)) > 0;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

