/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.checks;

import com.android.tools.lint.checks.UastImplementationDetector;
import com.android.tools.lint.client.api.UElementHandler;
import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.Detector;
import com.android.tools.lint.detector.api.Implementation;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.JavaContext;
import com.android.tools.lint.detector.api.Location;
import com.android.tools.lint.detector.api.Platform;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import com.android.tools.lint.detector.api.SourceCodeScanner;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.PsiTypesUtil;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.uast.UClassLiteralExpression;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UImportStatement;
import org.jetbrains.uast.UResolvable;
import org.jetbrains.uast.UTypeReferenceExpression;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \r2\u00020\u00012\u00020\u0002:\u0001\rB\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0016\u0010\u0005\u001a\u0010\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020\b0\u00070\u0006H\u0016J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016\u00a8\u0006\u000e"}, d2={"Lcom/android/tools/lint/checks/UastImplementationDetector;", "Lcom/android/tools/lint/detector/api/Detector;", "Lcom/android/tools/lint/detector/api/SourceCodeScanner;", "<init>", "()V", "getApplicableUastTypes", "", "Ljava/lang/Class;", "Lorg/jetbrains/uast/UElement;", "createUastHandler", "Lcom/android/tools/lint/client/api/UElementHandler;", "context", "Lcom/android/tools/lint/detector/api/JavaContext;", "Companion", "lint-checks"})
public final class UastImplementationDetector
extends Detector
implements SourceCodeScanner {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final Implementation IMPLEMENTATION = new Implementation(UastImplementationDetector.class, Scope.JAVA_FILE_SCOPE);
    @JvmField
    @NotNull
    public static final Issue ISSUE;
    @NotNull
    private static final String UAST_PREFIX = "org.jetbrains.uast.";
    @NotNull
    private static final String UAST_JAVA_PREFIX = "org.jetbrains.uast.java.";
    @NotNull
    private static final String UAST_KT_PREFIX = "org.jetbrains.uast.kotlin.";

    @NotNull
    public List<Class<? extends UElement>> getApplicableUastTypes() {
        Object[] objectArray = new Class[]{UClassLiteralExpression.class, UImportStatement.class, UTypeReferenceExpression.class};
        return CollectionsKt.listOf((Object[])objectArray);
    }

    @NotNull
    public UElementHandler createUastHandler(@NotNull JavaContext context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        return new UElementHandler(context){
            final /* synthetic */ JavaContext $context;
            {
                this.$context = $context;
            }

            public void visitClassLiteralExpression(UClassLiteralExpression node) {
                Intrinsics.checkNotNullParameter((Object)node, (String)"node");
                Object object = node.getType();
                if (object == null || (object = object.getCanonicalText()) == null) {
                    return;
                }
                Object fqName = object;
                if (com.android.tools.lint.checks.UastImplementationDetector$Companion.access$isNotAllowedUastImplementation(UastImplementationDetector.Companion, (String)fqName)) {
                    PsiType psiType = node.getType();
                    PsiClassType psiClassType = psiType instanceof PsiClassType ? (PsiClassType)psiType : null;
                    this.reportUastImplementation((UElement)node, (String)fqName, (PsiClass)(psiClassType != null ? psiClassType.resolve() : null));
                }
            }

            public void visitImportStatement(UImportStatement node) {
                Intrinsics.checkNotNullParameter((Object)node, (String)"node");
                this.checkUastImplementation((UResolvable)node);
            }

            public void visitTypeReferenceExpression(UTypeReferenceExpression node) {
                Intrinsics.checkNotNullParameter((Object)node, (String)"node");
                this.checkUastImplementation(node);
            }

            private final <T extends UResolvable & UElement> void checkUastImplementation(T uElement) {
                PsiElement resolvedElement = uElement.resolve();
                if (resolvedElement instanceof PsiClass) {
                    String string = ((PsiClass)resolvedElement).getQualifiedName();
                    if (string == null) {
                        return;
                    }
                    String fqName = string;
                    if (com.android.tools.lint.checks.UastImplementationDetector$Companion.access$isNotAllowedUastImplementation(UastImplementationDetector.Companion, fqName)) {
                        this.reportUastImplementation(uElement, fqName, (PsiClass)resolvedElement);
                    }
                } else if (resolvedElement instanceof PsiMember) {
                    PsiClass psiClass = ((PsiMember)resolvedElement).getContainingClass();
                    if (psiClass == null) {
                        return;
                    }
                    PsiClass containingClass = psiClass;
                    String string = containingClass.getQualifiedName();
                    if (string == null) {
                        return;
                    }
                    String fqName = string;
                    if (com.android.tools.lint.checks.UastImplementationDetector$Companion.access$isNotAllowedUastImplementation(UastImplementationDetector.Companion, fqName)) {
                        this.reportUastImplementation(uElement, fqName, containingClass);
                    }
                }
            }

            private final void checkUastImplementation(UTypeReferenceExpression node) {
                String string = node.getQualifiedName();
                if (string == null) {
                    return;
                }
                String fqName = string;
                if (com.android.tools.lint.checks.UastImplementationDetector$Companion.access$isNotAllowedUastImplementation(UastImplementationDetector.Companion, fqName)) {
                    this.reportUastImplementation((UElement)node, fqName, PsiTypesUtil.getPsiClass((PsiType)node.getType()));
                }
            }

            /*
             * Unable to fully structure code
             * Could not resolve type clashes
             */
            private final void reportUastImplementation(UElement node, String fqName, PsiClass psiClass) {
                v0 /* !! */  = psiClass;
                if (v0 /* !! */  == null) ** GOTO lbl-1000
                it = v0 /* !! */ ;
                $i$a$-let-UastImplementationDetector$createUastHandler$1$reportUastImplementation$superClasses$1 = false;
                v1 = InheritanceUtil.getSuperClasses((PsiClass)it);
                v0 /* !! */  = v1;
                if (v1 != null) {
                    v2 = (Set)v0 /* !! */ ;
                } else lbl-1000:
                // 2 sources

                {
                    v2 = SetsKt.emptySet();
                }
                superClasses = v2;
                var6_11 = superClasses;
                $i$f$filter = false;
                $i$a$-let-UastImplementationDetector$createUastHandler$1$reportUastImplementation$superClasses$1 = $this$filter$iv;
                destination$iv$iv = new ArrayList<E>();
                $i$f$filterTo = false;
                for (T element$iv$iv : $this$filterTo$iv$iv) {
                    it /* !! */  = (PsiClass)element$iv$iv;
                    $i$a$-filter-UastImplementationDetector$createUastHandler$1$reportUastImplementation$filtered$1 = false;
                    if (!it /* !! */ .isInterface()) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                $this$filter$iv = (List)destination$iv$iv;
                $i$f$filter = false;
                $this$filterTo$iv$iv = $this$filter$iv;
                destination$iv$iv = new ArrayList<E>();
                $i$f$filterTo = false;
                for (T element$iv$iv : $this$filterTo$iv$iv) {
                    it /* !! */  = (PsiClass)element$iv$iv;
                    $i$a$-filter-UastImplementationDetector$createUastHandler$1$reportUastImplementation$filtered$2 = false;
                    v3 = it /* !! */ .getQualifiedName();
                    if (v3 == null) {
                        v3 = "";
                    }
                    if (!(StringsKt.startsWith$default((String)(qualified = v3), (String)"org.jetbrains.uast.", (boolean)false, (int)2, null) != false && com.android.tools.lint.checks.UastImplementationDetector$Companion.access$isNotAllowedUastImplementation(UastImplementationDetector.Companion, qualified) == false)) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                $this$filter$iv = (List)destination$iv$iv;
                $i$f$map = false;
                $this$filterTo$iv$iv = $this$map$iv;
                destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                $i$f$mapTo = false;
                for (T item$iv$iv : $this$mapTo$iv$iv) {
                    it /* !! */  = (PsiClass)item$iv$iv;
                    var16_19 = destination$iv$iv;
                    $i$a$-map-UastImplementationDetector$createUastHandler$1$reportUastImplementation$filtered$3 = false;
                    var16_19.add(it /* !! */ .getName());
                }
                $this$map$iv = (List)destination$iv$iv;
                $i$f$filter = false;
                $this$mapTo$iv$iv = $this$filter$iv;
                destination$iv$iv = new ArrayList<E>();
                $i$f$filterTo = false;
                for (T element$iv$iv : $this$filterTo$iv$iv) {
                    it /* !! */  = (String)element$iv$iv;
                    $i$a$-filter-UastImplementationDetector$createUastHandler$1$reportUastImplementation$filtered$4 = false;
                    if (!(Intrinsics.areEqual((Object)it /* !! */ , (Object)"UElement") == false && Intrinsics.areEqual((Object)it /* !! */ , (Object)"UMultiResolvable") == false)) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                it = CollectionsKt.toList((Iterable)((List)destination$iv$iv));
                $i$a$-let-UastImplementationDetector$createUastHandler$1$reportUastImplementation$filtered$5 = false;
                filtered = CollectionsKt.joinToString$default((Iterable)CollectionsKt.toList((Iterable)new LinkedHashSet<E>(it)), (CharSequence)", ", null, null, (int)0, null, (Function1)createUastHandler.reportUastImplementation.filtered.6.INSTANCE, (int)30, null);
                message = fqName + " is UAST implementation. Consider using one of its corresponding UAST interfaces" + (String)(((CharSequence)filtered).length() == 0 != false ? "." : ": " + filtered);
                JavaContext.report$default((JavaContext)this.$context, (Issue)UastImplementationDetector.ISSUE, (UElement)node, (Location)this.$context.getLocation(node), (String)message, null, (int)16, null);
            }
        };
    }

    static {
        Issue.Companion companion = Issue.Companion;
        Category category = Category.CUSTOM_LINT_CHECKS;
        Severity severity = Severity.WARNING;
        Implementation implementation = IMPLEMENTATION;
        EnumSet enumSet = Platform.JDK_SET;
        ISSUE = Issue.Companion.create$default((Issue.Companion)companion, (String)"UastImplementation", (String)"Avoid using UAST implementation", (String)"\n                Use UAST interface whenever possible, and do not rely on UAST implementation, \\\n                which is subject to change. If language-specific information is needed, \\\n                the next option is to use PSI directly (though these APIs are less stable and \\\n                can depend on compiler internals, especially in the case of Kotlin).\n            ", (Implementation)implementation, null, (Category)category, (int)4, (Severity)severity, (boolean)false, null, (EnumSet)enumSet, null, (int)2832, null);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\tH\u0002J\u0010\u0010\u000f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\tH\u0002J\u0010\u0010\u0010\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\tH\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u00020\u00078\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\tX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\tX\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lcom/android/tools/lint/checks/UastImplementationDetector$Companion;", "", "<init>", "()V", "IMPLEMENTATION", "Lcom/android/tools/lint/detector/api/Implementation;", "ISSUE", "Lcom/android/tools/lint/detector/api/Issue;", "UAST_PREFIX", "", "UAST_JAVA_PREFIX", "UAST_KT_PREFIX", "isUastImplementation", "", "fqName", "isNotAllowedUastImplementation", "isAllowedUastImplementation", "lint-checks"})
    public static final class Companion {
        private Companion() {
        }

        private final boolean isUastImplementation(String fqName) {
            return StringsKt.startsWith$default((String)fqName, (String)UastImplementationDetector.UAST_JAVA_PREFIX, (boolean)false, (int)2, null) || StringsKt.startsWith$default((String)fqName, (String)UastImplementationDetector.UAST_KT_PREFIX, (boolean)false, (int)2, null);
        }

        private final boolean isNotAllowedUastImplementation(String fqName) {
            return this.isUastImplementation(fqName) && !this.isAllowedUastImplementation(fqName);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private final boolean isAllowedUastImplementation(String fqName) {
            String string = fqName;
            switch (string.hashCode()) {
                case 654813895: {
                    if (string.equals("org.jetbrains.uast.java.JavaUastLanguagePlugin")) return true;
                    return false;
                }
                case 587543973: {
                    if (string.equals("org.jetbrains.uast.kotlin.BaseKotlinUastResolveProviderService")) return true;
                    return false;
                }
                case 1187207280: {
                    if (string.equals("org.jetbrains.uast.kotlin.KotlinQualifiedExpressionAccessTypes")) return true;
                    return false;
                }
                case 469117247: {
                    if (string.equals("org.jetbrains.uast.kotlin.KotlinBinaryOperators")) return true;
                    return false;
                }
                case 742569609: {
                    if (string.equals("org.jetbrains.uast.kotlin.KotlinPostfixOperators")) return true;
                    return false;
                }
                case -51738793: {
                    if (string.equals("org.jetbrains.uast.kotlin.KotlinBinaryExpressionWithTypeKinds")) return true;
                    return false;
                }
                case -1182168297: {
                    if (string.equals("org.jetbrains.uast.java.JavaUDeclarationsExpression")) return true;
                    return false;
                }
                case -586176272: {
                    if (string.equals("org.jetbrains.uast.kotlin.BaseKotlinInternalUastUtilsKt")) return true;
                    return false;
                }
                case -68950452: {
                    if (!string.equals("org.jetbrains.uast.kotlin.kinds.KotlinSpecialExpressionKinds")) return false;
                    return true;
                }
            }
            return false;
        }

        public static final /* synthetic */ boolean access$isNotAllowedUastImplementation(Companion $this, String fqName) {
            return $this.isNotAllowedUastImplementation(fqName);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

