/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.checks;

import com.android.tools.lint.checks.DataFlowAnalyzer;
import com.android.tools.lint.checks.DataFlowAnalyzerKt;
import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.Detector;
import com.android.tools.lint.detector.api.Implementation;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.JavaContext;
import com.android.tools.lint.detector.api.Lint;
import com.android.tools.lint.detector.api.Location;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import com.android.tools.lint.detector.api.SourceCodeScanner;
import com.android.tools.lint.detector.api.UastLintUtilsKt;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiType;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.uast.UCallExpression;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UExpression;
import org.jetbrains.uast.ULocalVariable;
import org.jetbrains.uast.UMethod;
import org.jetbrains.uast.UQualifiedReferenceExpression;
import org.jetbrains.uast.UVariable;
import org.jetbrains.uast.UastUtils;
import org.jetbrains.uast.visitor.UastVisitor;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u00132\u00020\u00012\u00020\u0002:\u0001\u0013B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u000e\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006H\u0016J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002J \u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000b2\u0006\u0010\u0011\u001a\u00020\u0012H\u0016\u00a8\u0006\u0014"}, d2={"Lcom/android/tools/lint/checks/WorkManagerDetector;", "Lcom/android/tools/lint/detector/api/Detector;", "Lcom/android/tools/lint/detector/api/SourceCodeScanner;", "<init>", "()V", "getApplicableMethodNames", "", "", "isEnqueueCall", "", "call", "Lorg/jetbrains/uast/UCallExpression;", "visitMethodCall", "", "context", "Lcom/android/tools/lint/detector/api/JavaContext;", "node", "method", "Lcom/intellij/psi/PsiMethod;", "Companion", "lint-checks"})
public final class WorkManagerDetector
extends Detector
implements SourceCodeScanner {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final Implementation IMPLEMENTATION = new Implementation(WorkManagerDetector.class, Scope.JAVA_FILE_SCOPE);
    @JvmField
    @NotNull
    public static final Issue ISSUE;
    @NotNull
    private static final String CLASS_WORK_MANAGER = "androidx.work.WorkManager";
    @NotNull
    private static final String CLASS_WORK_CONTINUATION = "androidx.work.WorkContinuation";
    @NotNull
    private static final String METHOD_BEGIN_WITH = "beginWith";
    @NotNull
    private static final String METHOD_BEGIN_UNIQUE_WORK = "beginUniqueWork";
    @NotNull
    private static final String METHOD_ENQUEUE = "enqueue";
    @NotNull
    private static final String METHOD_ENQUEUE_SYNC = "enqueueSync";
    @NotNull
    private static final String METHOD_ENQUEUE_UNIQUE = "enqueueUniquePeriodicWork";
    @NotNull
    private static final String METHOD_THEN = "then";
    @NotNull
    private static final String METHOD_COMBINE = "combine";

    @NotNull
    public List<String> getApplicableMethodNames() {
        Object[] objectArray = new String[]{METHOD_BEGIN_WITH, METHOD_BEGIN_UNIQUE_WORK, METHOD_THEN, METHOD_COMBINE};
        return CollectionsKt.listOf((Object[])objectArray);
    }

    private final boolean isEnqueueCall(UCallExpression call2) {
        block16: {
            String methodName = Lint.getMethodName((UCallExpression)call2);
            if (methodName == null) break block16;
            int n = -1;
            switch (methodName.hashCode()) {
                case -1594257912: {
                    if (methodName.equals(METHOD_ENQUEUE)) {
                        n = 1;
                    }
                    break;
                }
                case 1310382275: {
                    if (methodName.equals(METHOD_ENQUEUE_SYNC)) {
                        n = 1;
                    }
                    break;
                }
                case 1078858469: {
                    if (methodName.equals(METHOD_ENQUEUE_UNIQUE)) {
                        n = 1;
                    }
                    break;
                }
                case 3558941: {
                    if (methodName.equals(METHOD_THEN)) {
                        n = 2;
                    }
                    break;
                }
                case 950074687: {
                    if (methodName.equals(METHOD_COMBINE)) {
                        n = 2;
                    }
                    break;
                }
            }
            switch (n) {
                case 1: {
                    return true;
                }
                case 2: {
                    return true;
                }
            }
        }
        return false;
    }

    public void visitMethodCall(@NotNull JavaContext context, @NotNull UCallExpression node, @NotNull PsiMethod method) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        Intrinsics.checkNotNullParameter((Object)method, (String)"method");
        if (!context.getEvaluator().isMemberInClass((PsiMember)method, CLASS_WORK_MANAGER) && !context.getEvaluator().isMemberInClass((PsiMember)method, CLASS_WORK_CONTINUATION)) {
            return;
        }
        UMethod uMethod = (UMethod)UastUtils.getParentOfType((UElement)((UElement)node), UMethod.class, (boolean)true);
        if (uMethod == null) {
            return;
        }
        UMethod surrounding = uMethod;
        PsiType psiType = surrounding.getReturnType();
        if (Intrinsics.areEqual((Object)(psiType != null ? psiType.getCanonicalText() : null), (Object)CLASS_WORK_CONTINUATION)) {
            return;
        }
        Ref.BooleanRef enqueued = new Ref.BooleanRef();
        List list = CollectionsKt.listOf((Object)node);
        DataFlowAnalyzer visitor2 = new DataFlowAnalyzer(this, enqueued, list){
            final /* synthetic */ WorkManagerDetector this$0;
            final /* synthetic */ Ref.BooleanRef $enqueued;
            {
                this.this$0 = $receiver;
                this.$enqueued = $enqueued;
                super($super_call_param$1, null, 2, null);
            }

            public void receiver(UCallExpression call2) {
                Intrinsics.checkNotNullParameter((Object)call2, (String)"call");
                if (WorkManagerDetector.access$isEnqueueCall(this.this$0, call2)) {
                    this.$enqueued.element = true;
                }
            }

            public void argument(UCallExpression call2, UElement reference) {
                Intrinsics.checkNotNullParameter((Object)call2, (String)"call");
                Intrinsics.checkNotNullParameter((Object)reference, (String)"reference");
                String methodName = Lint.getMethodName((UCallExpression)call2);
                if (Intrinsics.areEqual((Object)methodName, (Object)"combine")) {
                    this.$enqueued.element = true;
                } else {
                    UElement parent = UastUtils.skipParenthesizedExprUp((UElement)call2.getUastParent());
                    if (parent instanceof UQualifiedReferenceExpression) {
                        PsiElement listVariable = UastUtils.tryResolve((UElement)((UElement)UastUtils.skipParenthesizedExprDown((UExpression)((UQualifiedReferenceExpression)parent).getReceiver())));
                        if (listVariable instanceof PsiLocalVariable) {
                            this.getReferences().add(listVariable);
                        } else {
                            UElement parentParent = UastUtils.skipParenthesizedExprUp((UElement)((UQualifiedReferenceExpression)parent).getUastParent());
                            if (parentParent instanceof ULocalVariable) {
                                DataFlowAnalyzer.addVariableReference$default(this, (UVariable)parentParent, null, 2, null);
                            }
                        }
                    } else if (parent instanceof ULocalVariable) {
                        DataFlowAnalyzer.addVariableReference$default(this, (UVariable)parent, null, 2, null);
                    }
                }
            }

            public boolean returnsSelf(UCallExpression call2) {
                Intrinsics.checkNotNullParameter((Object)call2, (String)"call");
                String methodName = Lint.getMethodName((UCallExpression)call2);
                if (Intrinsics.areEqual((Object)methodName, (Object)"synchronous")) {
                    return true;
                }
                return super.returnsSelf(call2);
            }
        };
        surrounding.accept((UastVisitor)visitor2);
        if (!(enqueued.element || visitor2.getFailedResolve() && DataFlowAnalyzerKt.anyCall(surrounding, (Function1<? super UCallExpression, Boolean>)((Function1)new Function1<UCallExpression, Boolean>((Object)this){

            public final Boolean invoke(UCallExpression p0) {
                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                return WorkManagerDetector.access$isEnqueueCall((WorkManagerDetector)((Object)this.receiver), p0);
            }
        })))) {
            String name;
            UElement uElement = UastUtils.skipParenthesizedExprUp((UElement)node.getUastParent());
            UElement uElement2 = UastUtils.skipParenthesizedExprUp((UElement)(uElement != null ? uElement.getUastParent() : null));
            ULocalVariable uLocalVariable = uElement2 instanceof ULocalVariable ? (ULocalVariable)uElement2 : null;
            String string = name = uLocalVariable != null ? UastLintUtilsKt.getNameFromSource((UElement)((UElement)uLocalVariable)) : null;
            Object nameString = string != null ? "`" + string + "` " : "";
            JavaContext.report$default((JavaContext)context, (Issue)ISSUE, (UElement)((UElement)node), (Location)context.getLocation((UElement)node), (String)("WorkContinuation " + (String)nameString + "not enqueued: did you forget to call `enqueue()`?"), null, (int)16, null);
        }
    }

    public static final /* synthetic */ boolean access$isEnqueueCall(WorkManagerDetector $this, UCallExpression call2) {
        return $this.isEnqueueCall(call2);
    }

    static {
        Issue.Companion companion = Issue.Companion;
        Category category = Category.CORRECTNESS;
        Severity severity = Severity.WARNING;
        Implementation implementation = IMPLEMENTATION;
        ISSUE = Issue.Companion.create$default((Issue.Companion)companion, (String)"EnqueueWork", (String)"WorkManager Enqueue", (String)"\n                `WorkContinuations` cannot be enqueued automatically.  You must call `enqueue()` \\\n                on a `WorkContinuation` to have it and its parent continuations enqueued inside \\\n                `WorkManager`.\n            ", (Implementation)implementation, null, (Category)category, (int)6, (Severity)severity, (boolean)false, (Boolean)true, null, null, (int)3344, null);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\t\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u00020\u00078\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\tX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\tX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\tX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\tX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\tX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\tX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\tX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\tX\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lcom/android/tools/lint/checks/WorkManagerDetector$Companion;", "", "<init>", "()V", "IMPLEMENTATION", "Lcom/android/tools/lint/detector/api/Implementation;", "ISSUE", "Lcom/android/tools/lint/detector/api/Issue;", "CLASS_WORK_MANAGER", "", "CLASS_WORK_CONTINUATION", "METHOD_BEGIN_WITH", "METHOD_BEGIN_UNIQUE_WORK", "METHOD_ENQUEUE", "METHOD_ENQUEUE_SYNC", "METHOD_ENQUEUE_UNIQUE", "METHOD_THEN", "METHOD_COMBINE", "lint-checks"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

