/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.checks;

import com.android.tools.lint.checks.ApiLookup;
import com.android.tools.lint.checks.PrivateApiLookup;
import com.android.tools.lint.checks.Restriction;
import com.android.tools.lint.client.api.JavaEvaluator;
import com.android.tools.lint.client.api.LintClient;
import com.android.tools.lint.detector.api.ApiConstraint;
import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.ConstantEvaluator;
import com.android.tools.lint.detector.api.Context;
import com.android.tools.lint.detector.api.Detector;
import com.android.tools.lint.detector.api.Implementation;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.JavaContext;
import com.android.tools.lint.detector.api.Location;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import com.android.tools.lint.detector.api.SourceCodeScanner;
import com.android.tools.lint.detector.api.TypeEvaluator;
import com.android.tools.lint.detector.api.UastLintUtils;
import com.android.tools.lint.detector.api.VersionChecks;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiVariable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.uast.UCallExpression;
import org.jetbrains.uast.UClassLiteralExpression;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UExpression;
import org.jetbrains.uast.UParenthesizedExpression;
import org.jetbrains.uast.UQualifiedReferenceExpression;
import org.jetbrains.uast.UReferenceExpression;
import org.jetbrains.uast.USimpleNameReferenceExpression;
import org.jetbrains.uast.UastUtils;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u008a\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0005\u0018\u0000 :2\u00020\u00012\u00020\u0002:\u0001:B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\u000e\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00160\u0015H\u0016J\u000e\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00160\u0015H\u0016J \u0010\u0018\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001dH\u0016J \u0010\u001e\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00192\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\"H\u0016J\u0018\u0010#\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00192\u0006\u0010$\u001a\u00020\u001bH\u0002J(\u0010%\u001a\u0004\u0018\u00010\u00162\f\u0010&\u001a\b\u0012\u0004\u0012\u00020'0\u00152\u0006\u0010\u0012\u001a\u00020\u00192\u0006\u0010(\u001a\u00020\u0016H\u0002J\u0018\u0010)\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00192\u0006\u0010$\u001a\u00020\u001bH\u0002J\u0018\u0010*\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00192\u0006\u0010$\u001a\u00020\u001bH\u0002J\u0012\u0010+\u001a\u0004\u0018\u00010\u00162\u0006\u0010$\u001a\u00020\u001bH\u0002J\u0014\u0010,\u001a\u0004\u0018\u00010-2\b\u0010.\u001a\u0004\u0018\u00010/H\u0002J*\u00100\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00192\b\u00101\u001a\u0004\u0018\u0001022\u0006\u00103\u001a\u00020\u00162\u0006\u0010$\u001a\u00020\u001bH\u0002J(\u00104\u001a\u00020\n2\u0006\u0010\u0012\u001a\u00020\u00192\u0006\u0010.\u001a\u00020\u001b2\u0006\u00105\u001a\u0002062\u0006\u00107\u001a\u000206H\u0002J \u00108\u001a\u00020\u00112\u0006\u00109\u001a\u00020\u00162\u0006\u0010\u0012\u001a\u00020\u00192\u0006\u0010$\u001a\u00020\u001bH\u0002R\u0010\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000b\u001a\u0004\u0018\u00010\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\r\u001a\u0004\u0018\u00010\f8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006;"}, d2={"Lcom/android/tools/lint/checks/PrivateApiDetector;", "Lcom/android/tools/lint/detector/api/Detector;", "Lcom/android/tools/lint/detector/api/SourceCodeScanner;", "<init>", "()V", "client", "Lcom/android/tools/lint/client/api/LintClient;", "psiFactory", "Lcom/intellij/psi/PsiElementFactory;", "cachedApiDatabase", "", "privateApiDatabase", "Lcom/android/tools/lint/checks/PrivateApiLookup;", "apiDatabase", "getApiDatabase", "()Lcom/android/tools/lint/checks/PrivateApiLookup;", "beforeCheckRootProject", "", "context", "Lcom/android/tools/lint/detector/api/Context;", "getApplicableMethodNames", "", "", "getApplicableReferenceNames", "visitMethodCall", "Lcom/android/tools/lint/detector/api/JavaContext;", "node", "Lorg/jetbrains/uast/UCallExpression;", "method", "Lcom/intellij/psi/PsiMethod;", "visitReference", "reference", "Lorg/jetbrains/uast/UReferenceExpression;", "referenced", "Lcom/intellij/psi/PsiElement;", "checkGetDeclaredMethod", "call", "getMethodDescriptor", "arguments", "Lorg/jetbrains/uast/UExpression;", "methodName", "checkGetDeclaredField", "checkLoadClass", "getJavaClassFromMemberLookup", "getJavaClassType", "Lcom/intellij/psi/PsiType;", "element", "Lorg/jetbrains/uast/UElement;", "reportIssue", "restriction", "Lcom/android/tools/lint/checks/Restriction;", "api", "isAllowed", "targetSdk", "", "apiLevel", "reportUnknownMember", "cls", "Issues", "lint-checks"})
@SourceDebugExtension(value={"SMAP\nPrivateApiDetector.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PrivateApiDetector.kt\ncom/android/tools/lint/checks/PrivateApiDetector\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,507:1\n1617#2,9:508\n1869#2:517\n1870#2:519\n1626#2:520\n1#3:518\n37#4:521\n36#4,3:522\n*S KotlinDebug\n*F\n+ 1 PrivateApiDetector.kt\ncom/android/tools/lint/checks/PrivateApiDetector\n*L\n259#1:508,9\n259#1:517\n259#1:519\n259#1:520\n259#1:518\n259#1:521\n259#1:522,3\n*E\n"})
public final class PrivateApiDetector
extends Detector
implements SourceCodeScanner {
    @NotNull
    public static final Issues Issues = new Issues(null);
    @Nullable
    private LintClient client;
    @Nullable
    private PsiElementFactory psiFactory;
    private boolean cachedApiDatabase;
    @Nullable
    private PrivateApiLookup privateApiDatabase;
    @JvmField
    @NotNull
    public static final Issue PRIVATE_API;
    @JvmField
    @NotNull
    public static final Issue DISCOURAGED_PRIVATE_API;
    @JvmField
    @NotNull
    public static final Issue SOON_BLOCKED_PRIVATE_API;
    @JvmField
    @NotNull
    public static final Issue BLOCKED_PRIVATE_API;
    @NotNull
    private static final String LOAD_CLASS = "loadClass";
    @NotNull
    private static final String FOR_NAME = "forName";
    @NotNull
    private static final String GET_CLASS = "getClass";
    @NotNull
    private static final String GET_DECLARED_CONSTRUCTOR = "getDeclaredConstructor";
    @NotNull
    private static final String GET_DECLARED_METHOD = "getDeclaredMethod";
    @NotNull
    private static final String GET_DECLARED_FIELD = "getDeclaredField";
    @NotNull
    private static final List<String> KOTLIN_REFLECTION_METHODS;
    @NotNull
    private static final String ERROR_MESSAGE = "Accessing internal APIs via reflection is not supported and may not work on all devices or in the future";

    private final PrivateApiLookup getApiDatabase() {
        if (!this.cachedApiDatabase && this.privateApiDatabase == null && this.client != null) {
            LintClient lintClient = this.client;
            Intrinsics.checkNotNull((Object)lintClient);
            this.privateApiDatabase = PrivateApiLookup.Companion.get(lintClient);
            this.cachedApiDatabase = true;
        }
        return this.privateApiDatabase;
    }

    public void beforeCheckRootProject(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this.client = context.getClient();
        this.cachedApiDatabase = false;
        this.psiFactory = PsiElementFactory.getInstance((Project)context.getProject().getIdeaProject());
    }

    @NotNull
    public List<String> getApplicableMethodNames() {
        Object[] objectArray = new String[]{FOR_NAME, LOAD_CLASS, GET_DECLARED_CONSTRUCTOR, GET_DECLARED_METHOD, GET_DECLARED_FIELD};
        return CollectionsKt.listOf((Object[])objectArray);
    }

    @NotNull
    public List<String> getApplicableReferenceNames() {
        return KOTLIN_REFLECTION_METHODS;
    }

    public void visitMethodCall(@NotNull JavaContext context, @NotNull UCallExpression node, @NotNull PsiMethod method) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        Intrinsics.checkNotNullParameter((Object)method, (String)"method");
        JavaEvaluator evaluator = context.getEvaluator();
        String string = method.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
        String name = string;
        if (Intrinsics.areEqual((Object)LOAD_CLASS, (Object)name)) {
            if (evaluator.isMemberInClass((PsiMember)method, "java.lang.ClassLoader") || evaluator.isMemberInClass((PsiMember)method, "dalvik.system.DexFile")) {
                this.checkLoadClass(context, node);
            }
        } else {
            if (!evaluator.isMemberInClass((PsiMember)method, "java.lang.Class")) {
                return;
            }
            String string2 = name;
            if (Intrinsics.areEqual((Object)string2, (Object)GET_DECLARED_METHOD)) {
                this.checkGetDeclaredMethod(context, node);
            } else if (Intrinsics.areEqual((Object)string2, (Object)GET_DECLARED_FIELD)) {
                this.checkGetDeclaredField(context, node);
            } else {
                this.checkLoadClass(context, node);
            }
        }
    }

    public void visitReference(@NotNull JavaContext context, @NotNull UReferenceExpression reference, @NotNull PsiElement referenced) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)reference, (String)"reference");
        Intrinsics.checkNotNullParameter((Object)referenced, (String)"referenced");
    }

    private final void checkGetDeclaredMethod(JavaContext context, UCallExpression call2) {
        int targetSdk;
        String string = this.getJavaClassFromMemberLookup(call2);
        if (string == null) {
            return;
        }
        String cls = string;
        List arguments = call2.getValueArguments();
        if (arguments.isEmpty()) {
            return;
        }
        String methodName = ConstantEvaluator.evaluateString((JavaContext)context, (UElement)((UElement)arguments.get(0)), (boolean)false);
        PsiClass aClass = context.getEvaluator().findClass(cls);
        if (aClass != null && methodName != null) {
            PsiMethod[] psiMethodArray = aClass.findMethodsByName(methodName, true);
            Intrinsics.checkNotNullExpressionValue((Object)psiMethodArray, (String)"findMethodsByName(...)");
            if (!(((Object[])psiMethodArray).length == 0)) {
                Restriction restriction;
                String string2 = this.getMethodDescriptor(arguments, context, methodName);
                if (string2 == null) {
                    return;
                }
                String desc = string2;
                PrivateApiLookup privateApiLookup = this.getApiDatabase();
                Restriction restriction2 = restriction = privateApiLookup != null ? privateApiLookup.getMethodRestriction(cls, methodName, desc) : null;
                if (restriction != null) {
                    this.reportIssue(context, restriction, methodName, call2);
                }
                return;
            }
        }
        if ((targetSdk = context.getProject().getTargetSdk()) < 26) {
            this.reportUnknownMember(cls, context, call2);
        } else if (methodName != null) {
            String string3 = this.getMethodDescriptor(arguments, context, methodName);
            if (string3 == null) {
                return;
            }
            String desc = string3;
            PrivateApiLookup privateApiLookup = this.getApiDatabase();
            Restriction restriction = privateApiLookup != null ? privateApiLookup.getMethodRestriction(cls, methodName, desc) : null;
            this.reportIssue(context, restriction, methodName, call2);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final String getMethodDescriptor(List<? extends UExpression> arguments, JavaContext context, String methodName) {
        PsiType[] psiTypeArray;
        if (arguments.size() >= 2) {
            void $this$toTypedArray$iv;
            void $this$mapNotNullTo$iv$iv;
            Iterable $this$mapNotNull$iv = arguments.subList(1, arguments.size());
            boolean $i$f$mapNotNull = false;
            Iterable iterable = $this$mapNotNull$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach = false;
            Iterator iterator = $this$forEach$iv$iv$iv.iterator();
            while (iterator.hasNext()) {
                PsiType it$iv$iv;
                Object element$iv$iv$iv;
                Object element$iv$iv = element$iv$iv$iv = iterator.next();
                boolean bl = false;
                UExpression it = (UExpression)element$iv$iv;
                boolean bl2 = false;
                if (this.getJavaClassType((UElement)it) == null) continue;
                boolean bl3 = false;
                destination$iv$iv.add(it$iv$iv);
            }
            $this$mapNotNull$iv = (List)destination$iv$iv;
            boolean $i$f$toTypedArray = false;
            void thisCollection$iv = $this$toTypedArray$iv;
            psiTypeArray = thisCollection$iv.toArray(new PsiType[0]);
        } else {
            psiTypeArray = new PsiType[]{};
        }
        PsiType[] argTypes = psiTypeArray;
        return JavaEvaluator.constructMethodDescription$default((JavaEvaluator)context.getEvaluator(), (String)methodName, (boolean)false, (PsiType[])argTypes, null, (boolean)false, (int)26, null);
    }

    private final void checkGetDeclaredField(JavaContext context, UCallExpression call2) {
        String string = this.getJavaClassFromMemberLookup(call2);
        if (string == null) {
            return;
        }
        String cls = string;
        List arguments = call2.getValueArguments();
        if (arguments.isEmpty()) {
            return;
        }
        String fieldName = ConstantEvaluator.evaluateString((JavaContext)context, (UElement)((UElement)arguments.get(0)), (boolean)false);
        PsiClass aClass = context.getEvaluator().findClass(cls);
        if (aClass != null && fieldName != null && aClass.findFieldByName(fieldName, true) != null) {
            Restriction restriction;
            PrivateApiLookup privateApiLookup = this.getApiDatabase();
            Restriction restriction2 = restriction = privateApiLookup != null ? privateApiLookup.getFieldRestriction(cls, fieldName) : null;
            if (restriction != null) {
                this.reportIssue(context, restriction, fieldName, call2);
            }
            return;
        }
        int targetSdk = context.getProject().getTargetSdk();
        if (targetSdk < 26) {
            this.reportUnknownMember(cls, context, call2);
        } else if (fieldName != null) {
            PrivateApiLookup privateApiLookup = this.getApiDatabase();
            Restriction restriction = privateApiLookup != null ? privateApiLookup.getFieldRestriction(cls, fieldName) : null;
            this.reportIssue(context, restriction, fieldName, call2);
        }
    }

    private final void checkLoadClass(JavaContext context, UCallExpression call2) {
        List arguments = call2.getValueArguments();
        if (arguments.isEmpty()) {
            return;
        }
        Object object = ConstantEvaluator.evaluate((JavaContext)context, (UElement)((UElement)arguments.get(0)));
        String string = object instanceof String ? (String)object : null;
        if (string == null) {
            return;
        }
        String value = string;
        boolean isInternal = false;
        if (StringsKt.startsWith$default((String)value, (String)"com.android.internal.", (boolean)false, (int)2, null)) {
            isInternal = true;
        } else if (StringsKt.startsWith$default((String)value, (String)"com.android.", (boolean)false, (int)2, null) || StringsKt.startsWith$default((String)value, (String)"android.", (boolean)false, (int)2, null) && !StringsKt.startsWith$default((String)value, (String)"android.support.", (boolean)false, (int)2, null)) {
            PsiClass aClass = context.getEvaluator().findClass(value);
            if (aClass != null) {
                return;
            }
            ApiLookup apiLookup = ApiLookup.getOrNull(context.getClient(), context.getProject().getBuildTarget());
            if (apiLookup == null) {
                return;
            }
            ApiLookup apiLookup2 = apiLookup;
            boolean bl = isInternal = !apiLookup2.containsClass(value);
        }
        if (isInternal) {
            Location location = context.getLocation((UElement)call2);
            JavaContext.report$default((JavaContext)context, (Issue)PRIVATE_API, (UElement)((UElement)call2), (Location)location, (String)ERROR_MESSAGE, null, (int)16, null);
        }
    }

    private final String getJavaClassFromMemberLookup(UCallExpression call2) {
        PsiType psiType = this.getJavaClassType((UElement)call2.getReceiver());
        return psiType != null ? psiType.getCanonicalText() : null;
    }

    private final PsiType getJavaClassType(UElement element) {
        if (element instanceof UExpression) {
            if (element instanceof UParenthesizedExpression) {
                return this.getJavaClassType((UElement)((UParenthesizedExpression)element).getExpression());
            }
            PsiType type = ((UExpression)element).getExpressionType();
            if (type instanceof PsiClassType && ((PsiClassType)type).getParameterCount() == 1) {
                PsiType clazz = null;
                clazz = ((PsiClassType)type).getParameters()[0];
                if (clazz instanceof PsiClassType) {
                    PsiPrimitiveType psiPrimitiveType = PsiPrimitiveType.getUnboxedType((PsiType)clazz);
                    if (psiPrimitiveType != null) {
                        PsiPrimitiveType it = psiPrimitiveType;
                        boolean bl = false;
                        if (element instanceof UQualifiedReferenceExpression) {
                            String identifier;
                            UExpression uExpression = UastUtils.skipParenthesizedExprDown((UExpression)((UQualifiedReferenceExpression)element).getSelector());
                            USimpleNameReferenceExpression uSimpleNameReferenceExpression = uExpression instanceof USimpleNameReferenceExpression ? (USimpleNameReferenceExpression)uExpression : null;
                            String string = identifier = uSimpleNameReferenceExpression != null ? uSimpleNameReferenceExpression.getIdentifier() : null;
                            if (Intrinsics.areEqual((Object)identifier, (Object)"javaPrimitiveType") || Intrinsics.areEqual((Object)identifier, (Object)"TYPE")) {
                                clazz = it;
                            }
                        }
                        if (element instanceof UClassLiteralExpression && ((UClassLiteralExpression)element).evaluate() instanceof PsiPrimitiveType) {
                            clazz = it;
                        }
                    }
                    return clazz;
                }
            }
            if (element instanceof UReferenceExpression) {
                UExpression uExpression;
                PsiElement resolved = ((UReferenceExpression)element).resolve();
                if (resolved instanceof PsiVariable && (uExpression = UastLintUtils.Companion.findLastAssignment((PsiVariable)resolved, element)) != null) {
                    UExpression expression = uExpression;
                    boolean bl = false;
                    return this.getJavaClassType((UElement)expression);
                }
                if (element instanceof UQualifiedReferenceExpression && UastUtils.skipParenthesizedExprDown((UExpression)((UQualifiedReferenceExpression)element).getSelector()) instanceof UCallExpression) {
                    UExpression uExpression2 = UastUtils.skipParenthesizedExprDown((UExpression)((UQualifiedReferenceExpression)element).getSelector());
                    Intrinsics.checkNotNull((Object)uExpression2, (String)"null cannot be cast to non-null type org.jetbrains.uast.UCallExpression");
                    UCallExpression call2 = (UCallExpression)uExpression2;
                    String name = call2.getMethodName();
                    if (Intrinsics.areEqual((Object)FOR_NAME, (Object)name) || Intrinsics.areEqual((Object)LOAD_CLASS, (Object)name)) {
                        List arguments = call2.getValueArguments();
                        if (!((Collection)arguments).isEmpty()) {
                            PsiType psiType;
                            String string = ConstantEvaluator.evaluateString(null, (UElement)((UElement)arguments.get(0)), (boolean)false);
                            if (string != null) {
                                String it = string;
                                boolean bl = false;
                                PsiElementFactory psiElementFactory = this.psiFactory;
                                Intrinsics.checkNotNull((Object)psiElementFactory);
                                psiType = psiElementFactory.createTypeFromText(it, null);
                            } else {
                                psiType = null;
                            }
                            return psiType;
                        }
                    } else if (Intrinsics.areEqual((Object)GET_CLASS, (Object)name)) {
                        return TypeEvaluator.evaluate((UElement)((UElement)((UQualifiedReferenceExpression)element).getReceiver()));
                    }
                }
            }
        }
        return TypeEvaluator.evaluate((UElement)element);
    }

    private final void reportIssue(JavaContext context, Restriction restriction, String api2, UCallExpression call2) {
        int targetSdk = context.getProject().getTargetSdk();
        Restriction restriction2 = restriction;
        switch (restriction2 == null ? -1 : WhenMappings.$EnumSwitchMapping$0[restriction2.ordinal()]) {
            case 1: {
                PrivateApiDetector.reportIssue$fatal(context, call2, api2, targetSdk);
                break;
            }
            case 2: {
                if (this.isAllowed(context, call2, targetSdk, 26)) {
                    PrivateApiDetector.reportIssue$warning(context, call2, api2);
                    break;
                }
                PrivateApiDetector.reportIssue$error(context, call2, api2, targetSdk);
                break;
            }
            case 3: {
                if (this.isAllowed(context, call2, targetSdk, 28)) {
                    PrivateApiDetector.reportIssue$warning(context, call2, api2);
                    break;
                }
                PrivateApiDetector.reportIssue$error(context, call2, api2, targetSdk);
                break;
            }
            case 4: {
                if (this.isAllowed(context, call2, targetSdk, 29)) {
                    PrivateApiDetector.reportIssue$warning(context, call2, api2);
                    break;
                }
                PrivateApiDetector.reportIssue$error(context, call2, api2, targetSdk);
                break;
            }
            case 5: {
                if (this.isAllowed(context, call2, targetSdk, 30)) {
                    PrivateApiDetector.reportIssue$warning(context, call2, api2);
                    break;
                }
                PrivateApiDetector.reportIssue$error(context, call2, api2, targetSdk);
                break;
            }
            case 6: {
                PrivateApiDetector.reportIssue$warning(context, call2, api2);
                break;
            }
            default: {
                return;
            }
        }
    }

    private final boolean isAllowed(JavaContext context, UCallExpression element, int targetSdk, int apiLevel) {
        if (targetSdk <= apiLevel) {
            return true;
        }
        ApiConstraint apiConstraint = VersionChecks.Companion.getOuterVersionCheckConstraint(context, (UElement)element);
        if (apiConstraint == null) {
            return false;
        }
        ApiConstraint constraint = apiConstraint;
        return !constraint.everHigher(apiLevel);
    }

    private final void reportUnknownMember(String cls, JavaContext context, UCallExpression call2) {
        if (!StringsKt.startsWith$default((String)cls, (String)"com.android.", (boolean)false, (int)2, null) && !StringsKt.startsWith$default((String)cls, (String)"android.", (boolean)false, (int)2, null)) {
            return;
        }
        Location location = context.getLocation((UElement)call2);
        JavaContext.report$default((JavaContext)context, (Issue)PRIVATE_API, (UElement)((UElement)call2), (Location)location, (String)ERROR_MESSAGE, null, (int)16, null);
    }

    private static final void reportIssue$fatal(JavaContext $context, UCallExpression $call, String $api, int targetSdk) {
        JavaContext.report$default((JavaContext)$context, (Issue)BLOCKED_PRIVATE_API, (UElement)((UElement)$call), (Location)$context.getLocation((UElement)$call), (String)("Reflective access to " + $api + " is forbidden when targeting API " + targetSdk + " and above"), null, (int)16, null);
    }

    private static final void reportIssue$error(JavaContext $context, UCallExpression $call, String $api, int targetSdk) {
        JavaContext.report$default((JavaContext)$context, (Issue)SOON_BLOCKED_PRIVATE_API, (UElement)((UElement)$call), (Location)$context.getLocation((UElement)$call), (String)("Reflective access to " + $api + " will throw an exception when targeting API " + targetSdk + " and above"), null, (int)16, null);
    }

    private static final void reportIssue$warning(JavaContext $context, UCallExpression $call, String $api) {
        JavaContext.report$default((JavaContext)$context, (Issue)DISCOURAGED_PRIVATE_API, (UElement)((UElement)$call), (Location)$context.getLocation((UElement)$call), (String)("Reflective access to " + $api + ", which is not part of the public SDK and therefore likely to change in future Android releases"), null, (int)16, null);
    }

    static {
        Object[] objectArray = Issue.Companion;
        Category category = Category.CORRECTNESS;
        Severity severity = Severity.WARNING;
        Implementation implementation = new Implementation(PrivateApiDetector.class, Scope.JAVA_FILE_SCOPE);
        PRIVATE_API = Issue.Companion.create$default((Issue.Companion)objectArray, (String)"PrivateApi", (String)"Using Private APIs", (String)"\n            Using reflection to access hidden/private Android APIs is not safe; it will often not work on \\\n            devices from other vendors, and it may suddenly stop working (if the API is removed) or crash \\\n            spectacularly (if the API behavior changes, since there are no guarantees for compatibility).\n            ", (Implementation)implementation, (String)"https://developer.android.com/preview/restrictions-non-sdk-interfaces", (Category)category, (int)6, (Severity)severity, (boolean)false, (Boolean)true, null, null, (int)3328, null);
        objectArray = Issue.Companion;
        category = Category.CORRECTNESS;
        severity = Severity.WARNING;
        implementation = new Implementation(PrivateApiDetector.class, Scope.JAVA_FILE_SCOPE);
        DISCOURAGED_PRIVATE_API = Issue.Companion.create$default((Issue.Companion)objectArray, (String)"DiscouragedPrivateApi", (String)"Using Discouraged Private API", (String)"\n            Usage of restricted non-SDK interface may throw an exception at runtime. Accessing \\\n            non-SDK methods or fields through reflection has a high likelihood to break your app \\\n            between versions, and is being restricted to facilitate future app compatibility.\n            ", (Implementation)implementation, (String)"https://developer.android.com/preview/restrictions-non-sdk-interfaces", (Category)category, (int)6, (Severity)severity, (boolean)false, (Boolean)true, null, null, (int)3328, null);
        objectArray = Issue.Companion;
        category = Category.CORRECTNESS;
        severity = Severity.ERROR;
        implementation = new Implementation(PrivateApiDetector.class, Scope.JAVA_FILE_SCOPE);
        SOON_BLOCKED_PRIVATE_API = Issue.Companion.create$default((Issue.Companion)objectArray, (String)"SoonBlockedPrivateApi", (String)"Using Soon-to-Be Blocked Private API", (String)"\n            Usage of restricted non-SDK interface will throw an exception at runtime. Accessing \\\n            non-SDK methods or fields through reflection has a high likelihood to break your app \\\n            between versions, and is being restricted to facilitate future app compatibility.\n            ", (Implementation)implementation, (String)"https://developer.android.com/preview/restrictions-non-sdk-interfaces", (Category)category, (int)6, (Severity)severity, (boolean)false, (Boolean)true, null, null, (int)3328, null);
        objectArray = Issue.Companion;
        category = Category.CORRECTNESS;
        severity = Severity.FATAL;
        implementation = new Implementation(PrivateApiDetector.class, Scope.JAVA_FILE_SCOPE);
        BLOCKED_PRIVATE_API = Issue.Companion.create$default((Issue.Companion)objectArray, (String)"BlockedPrivateApi", (String)"Using Blocked Private API", (String)"\n            Usage of restricted non-SDK interface is forbidden for this targetSDK. Accessing \\\n            non-SDK methods or fields through reflection has a high likelihood to break your app \\\n            between versions, and is being restricted to facilitate future app compatibility.\n            ", (Implementation)implementation, (String)"https://developer.android.com/preview/restrictions-non-sdk-interfaces", (Category)category, (int)6, (Severity)severity, (boolean)false, (Boolean)true, null, null, (int)3328, null);
        objectArray = new String[]{"members", "declaredMembers", "declaredFunctions", "declaredMemberFunctions", "declaredMemberProperties"};
        KOTLIN_REFLECTION_METHODS = CollectionsKt.listOf((Object[])objectArray);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0010 \n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0010\u0010\u0004\u001a\u00020\u00058\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u00020\u00058\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0007\u001a\u00020\u00058\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\b\u001a\u00020\u00058\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\nX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\nX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\nX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\nX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\nX\u0082T\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\n0\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\nX\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lcom/android/tools/lint/checks/PrivateApiDetector$Issues;", "", "<init>", "()V", "PRIVATE_API", "Lcom/android/tools/lint/detector/api/Issue;", "DISCOURAGED_PRIVATE_API", "SOON_BLOCKED_PRIVATE_API", "BLOCKED_PRIVATE_API", "LOAD_CLASS", "", "FOR_NAME", "GET_CLASS", "GET_DECLARED_CONSTRUCTOR", "GET_DECLARED_METHOD", "GET_DECLARED_FIELD", "KOTLIN_REFLECTION_METHODS", "", "ERROR_MESSAGE", "lint-checks"})
    public static final class Issues {
        private Issues() {
        }

        public /* synthetic */ Issues(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 0, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[Restriction.values().length];
            try {
                nArray[Restriction.DENY.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Restriction.MAYBE_MAX_O.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Restriction.MAYBE_MAX_P.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Restriction.MAYBE_MAX_Q.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Restriction.MAYBE_MAX_R.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Restriction.MAYBE.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

