/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.checks.optional;

import com.android.tools.lint.checks.TypedefDetector;
import com.android.tools.lint.client.api.JavaEvaluator;
import com.android.tools.lint.detector.api.AnnotationInfo;
import com.android.tools.lint.detector.api.AnnotationOrigin;
import com.android.tools.lint.detector.api.AnnotationUsageInfo;
import com.android.tools.lint.detector.api.AnnotationUsageType;
import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.ConstantEvaluator;
import com.android.tools.lint.detector.api.Detector;
import com.android.tools.lint.detector.api.Implementation;
import com.android.tools.lint.detector.api.Incident;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.JavaContext;
import com.android.tools.lint.detector.api.Lint;
import com.android.tools.lint.detector.api.Location;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import com.android.tools.lint.detector.api.SourceCodeScanner;
import com.android.tools.lint.detector.api.UastLintUtilsKt;
import com.android.utils.SdkUtils;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiCompiledElement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiLiteralValue;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.PsiVariable;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.uast.UAnnotated;
import org.jetbrains.uast.UAnnotation;
import org.jetbrains.uast.UBlockExpression;
import org.jetbrains.uast.UCallExpression;
import org.jetbrains.uast.UClassLiteralExpression;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UExpression;
import org.jetbrains.uast.UFile;
import org.jetbrains.uast.UIfExpression;
import org.jetbrains.uast.ULiteralExpression;
import org.jetbrains.uast.UMethod;
import org.jetbrains.uast.UNamedExpression;
import org.jetbrains.uast.UParenthesizedExpression;
import org.jetbrains.uast.UPolyadicExpression;
import org.jetbrains.uast.UReferenceExpression;
import org.jetbrains.uast.UUnaryExpression;
import org.jetbrains.uast.UastBinaryOperator;
import org.jetbrains.uast.UastFacade;
import org.jetbrains.uast.UastLanguagePlugin;
import org.jetbrains.uast.UastPrefixOperator;
import org.jetbrains.uast.UastUtils;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000n\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u0000 12\u00020\u00012\u00020\u0002:\u000212B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u000e\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006H\u0016J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0010\u0010\f\u001a\u00020\t2\u0006\u0010\r\u001a\u00020\u0007H\u0016J(\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0016J\u0010\u0010\u0018\u001a\u00020\u00072\u0006\u0010\u0019\u001a\u00020\u0007H\u0002J \u0010\u001a\u001a\u00020\u000f2\u0006\u0010\r\u001a\u00020\u001b2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J0\u0010\u001c\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u001d\u001a\u00020\u00072\u0006\u0010\u0019\u001a\u00020\u00072\u0006\u0010\u001e\u001a\u00020\u0007H\u0002J\u001a\u0010\u001f\u001a\u0004\u0018\u00010 2\u0006\u0010!\u001a\u00020\"2\u0006\u0010\r\u001a\u00020\u001bH\u0002J\u0012\u0010#\u001a\u0004\u0018\u00010\u00072\u0006\u0010\r\u001a\u00020\u001bH\u0002J\u001a\u0010$\u001a\u0004\u0018\u00010 2\u0006\u0010!\u001a\u00020\"2\u0006\u0010%\u001a\u00020\u0007H\u0002J*\u0010&\u001a\u0004\u0018\u00010'2\u0006\u0010!\u001a\u00020\"2\u0006\u0010(\u001a\u00020\u00072\u0006\u0010)\u001a\u00020\u00072\u0006\u0010*\u001a\u00020\u0007H\u0002J\"\u0010+\u001a\u00020\t2\u0006\u0010!\u001a\u00020\"2\b\u0010\u0012\u001a\u0004\u0018\u00010\u00132\u0006\u0010%\u001a\u00020'H\u0002J*\u0010,\u001a\u00020\t2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010-\u001a\u00020.2\b\u0010/\u001a\u0004\u0018\u00010.2\u0006\u0010\u001e\u001a\u00020\u0007H\u0002J*\u00100\u001a\u00020\t2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010-\u001a\u00020.2\b\u0010/\u001a\u0004\u0018\u00010.2\u0006\u0010\u001e\u001a\u00020\u0007H\u0002\u00a8\u00063"}, d2={"Lcom/android/tools/lint/checks/optional/FlaggedApiDetector;", "Lcom/android/tools/lint/detector/api/Detector;", "Lcom/android/tools/lint/detector/api/SourceCodeScanner;", "<init>", "()V", "applicableAnnotations", "", "", "isApplicableAnnotationUsage", "", "type", "Lcom/android/tools/lint/detector/api/AnnotationUsageType;", "inheritAnnotation", "annotation", "visitAnnotationUsage", "", "context", "Lcom/android/tools/lint/detector/api/JavaContext;", "element", "Lorg/jetbrains/uast/UElement;", "annotationInfo", "Lcom/android/tools/lint/detector/api/AnnotationInfo;", "usageInfo", "Lcom/android/tools/lint/detector/api/AnnotationUsageInfo;", "getFlagMethodName", "flagName", "checkFlagApiDeclaration", "Lorg/jetbrains/uast/UAnnotation;", "reportError", "flagClassName", "flagMethodName", "getFlaggedApiFromSource", "Lcom/android/tools/lint/checks/optional/FlaggedApiDetector$OneOrTwoFlagFields;", "evaluator", "Lcom/android/tools/lint/client/api/JavaEvaluator;", "getFlaggedApiString", "getFlaggedApiFromString", "flag", "findFlagField", "Lcom/intellij/psi/PsiField;", "packageName", "className", "fieldName", "isAlreadyAnnotated", "isFlagChecked", "flagClass1", "Lcom/intellij/psi/PsiClass;", "flagClass2", "isFlagExpression", "Issues", "OneOrTwoFlagFields", "lint-checks"})
@SourceDebugExtension(value={"SMAP\nFlaggedApiDetector.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FlaggedApiDetector.kt\ncom/android/tools/lint/checks/optional/FlaggedApiDetector\n+ 2 UastUtils.kt\norg/jetbrains/uast/UastUtils__UastUtilsKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,493:1\n18#2:494\n1761#3,3:495\n*S KotlinDebug\n*F\n+ 1 FlaggedApiDetector.kt\ncom/android/tools/lint/checks/optional/FlaggedApiDetector\n*L\n239#1:494\n403#1:495,3\n*E\n"})
public final class FlaggedApiDetector
extends Detector
implements SourceCodeScanner {
    @NotNull
    public static final Issues Issues = new Issues(null);
    @NotNull
    private static final Implementation IMPLEMENTATION = new Implementation(FlaggedApiDetector.class, Scope.JAVA_FILE_SCOPE);
    @JvmField
    @NotNull
    public static final Issue ISSUE;
    @NotNull
    private static final String FLAGGED_API_ANNOTATION = "android.annotation.FlaggedApi";

    @NotNull
    public List<String> applicableAnnotations() {
        return CollectionsKt.listOf((Object)FLAGGED_API_ANNOTATION);
    }

    public boolean isApplicableAnnotationUsage(@NotNull AnnotationUsageType type) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        switch (WhenMappings.$EnumSwitchMapping$0[type.ordinal()]) {
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                bl = true;
                break;
            }
            default: {
                bl = false;
            }
        }
        return bl;
    }

    public boolean inheritAnnotation(@NotNull String annotation) {
        Intrinsics.checkNotNullParameter((Object)annotation, (String)"annotation");
        return false;
    }

    public void visitAnnotationUsage(@NotNull JavaContext context, @NotNull UElement element, @NotNull AnnotationInfo annotationInfo, @NotNull AnnotationUsageInfo usageInfo) {
        OneOrTwoFlagFields flags;
        OneOrTwoFlagFields oneOrTwoFlagFields;
        OneOrTwoFlagFields flag;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Intrinsics.checkNotNullParameter((Object)annotationInfo, (String)"annotationInfo");
        Intrinsics.checkNotNullParameter((Object)usageInfo, (String)"usageInfo");
        UAnnotation annotation = annotationInfo.getAnnotation();
        if (usageInfo.getType() == AnnotationUsageType.DEFINITION) {
            this.checkFlagApiDeclaration(annotation, context, usageInfo);
            return;
        }
        boolean compiled = usageInfo.getReferenced() instanceof PsiCompiledElement;
        JavaEvaluator evaluator = context.getEvaluator();
        if (compiled) {
            String flagString = this.getFlaggedApiString(annotation);
            OneOrTwoFlagFields oneOrTwoFlagFields2 = flag = flagString != null ? this.getFlaggedApiFromString(evaluator, flagString) : null;
            if (flag == null && flagString != null) {
                String flagClass = StringsKt.substringBeforeLast$default((String)flagString, (String)".", null, (int)2, null);
                String flagClassName = StringsKt.substringAfterLast$default((String)flagClass, (String)".", null, (int)2, null);
                String flagName = StringsKt.substringAfterLast$default((String)flagString, (String)".", null, (int)2, null);
                String flagMethodName = this.getFlagMethodName(flagName);
                this.reportError(context, element, flagClassName, flagName, flagMethodName);
                return;
            }
            oneOrTwoFlagFields = flag;
        } else {
            oneOrTwoFlagFields = this.getFlaggedApiFromSource(evaluator, annotation);
        }
        OneOrTwoFlagFields oneOrTwoFlagFields3 = flags = oneOrTwoFlagFields;
        if (oneOrTwoFlagFields3 == null) {
            return;
        }
        OneOrTwoFlagFields oneOrTwoFlagFields4 = oneOrTwoFlagFields3;
        flag = oneOrTwoFlagFields4.component1();
        PsiField flag2 = oneOrTwoFlagFields4.component2();
        if (annotationInfo.getOrigin() == AnnotationOrigin.SELF ? Intrinsics.areEqual((Object)annotationInfo.getQualifiedName(), (Object)FLAGGED_API_ANNOTATION) : this.isAlreadyAnnotated(evaluator, element, (PsiField)flag)) {
            return;
        }
        PsiClass psiClass = flag.getContainingClass();
        if (psiClass == null) {
            return;
        }
        PsiClass flagClass = psiClass;
        String string = flag.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
        String flagName = string;
        PsiField psiField = flag2;
        PsiClass flagClass2 = psiField != null ? psiField.getContainingClass() : null;
        String flagMethodName = this.getFlagMethodName(flagName);
        if (this.isFlagChecked(element, flagClass, flagClass2, flagMethodName)) {
            return;
        }
        String string2 = flagClass.getName();
        if (string2 == null) {
            string2 = "";
        }
        this.reportError(context, element, string2, flagName, flagMethodName);
    }

    private final String getFlagMethodName(String flagName) {
        String string = SdkUtils.constantNameToCamelCase((String)StringsKt.removePrefix((String)flagName, (CharSequence)"FLAG_"));
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"constantNameToCamelCase(...)");
        return string;
    }

    private final void checkFlagApiDeclaration(UAnnotation annotation, JavaContext context, AnnotationUsageInfo usageInfo) {
        UExpression expression;
        UNamedExpression uNamedExpression = (UNamedExpression)CollectionsKt.firstOrNull((List)annotation.getAttributeValues());
        Object object = expression = uNamedExpression != null ? uNamedExpression.getExpression() : null;
        if (expression instanceof ULiteralExpression) {
            String flagString = ConstantEvaluator.evaluateString((JavaContext)context, (UElement)((UElement)expression), (boolean)false);
            if (usageInfo.getType() == AnnotationUsageType.DEFINITION) {
                if (flagString != null && StringsKt.indexOf$default((CharSequence)flagString, (char)'.', (int)0, (boolean)false, (int)6, null) == -1) {
                    JavaContext.report$default((JavaContext)context, (Issue)ISSUE, (UElement)((UElement)expression), (Location)context.getLocation((UElement)expression), (String)"Invalid @FlaggedApi descriptor; should be `package.name`", null, (int)16, null);
                } else {
                    Incident incident = new Incident(ISSUE, (Object)expression, context.getLocation((UElement)expression), "@FlaggedApi should specify an actual flag constant; raw strings are discouraged (and more importantly, **not enforced**)");
                    incident.overrideSeverity(Severity.WARNING);
                    context.report(incident);
                }
            }
        }
    }

    private final void reportError(JavaContext context, UElement element, String flagClassName, String flagName, String flagMethodName) {
        UExpression uExpression;
        PsiElement referenced = UastUtils.tryResolve((UElement)element);
        String description = referenced instanceof PsiMethod ? "Method `" + ((PsiMethod)referenced).getName() + "()`" : (element instanceof UCallExpression ? "Method `" + Lint.getMethodName((UCallExpression)((UCallExpression)element)) + "()`" : (referenced instanceof PsiField ? "Field `" + ((PsiField)referenced).getName() + "`" : (referenced instanceof PsiClass ? "Class `" + ((PsiClass)referenced).getName() + "`" : (element instanceof UClassLiteralExpression ? "Class `" + ((uExpression = ((UClassLiteralExpression)element).getExpression()) != null && (uExpression = uExpression.getSourcePsi()) != null ? uExpression.getText() : null) + "`" : (referenced instanceof PsiNamedElement ? "Reference `" + ((PsiNamedElement)referenced).getName() + "`" : "This")))));
        UElement $this$getParentOfType_u24default$iv = element;
        boolean strict$iv = true;
        boolean $i$f$getParentOfType = false;
        Object object = (UMethod)UastUtils.getParentOfType((UElement)$this$getParentOfType_u24default$iv, UMethod.class, (boolean)strict$iv);
        if (object == null || (object = object.getName()) == null) {
            object = "?";
        }
        Object name = object;
        String message2 = description + " is a flagged API and should be inside an `if (" + flagClassName + "." + flagMethodName + "())` check (or annotate the surrounding method `" + (String)name + "` with `@FlaggedApi(" + flagClassName + "." + flagName + ") to transfer requirement to caller`)";
        JavaContext.report$default((JavaContext)context, (Issue)ISSUE, (UElement)element, (Location)context.getLocation(element), (String)message2, null, (int)16, null);
    }

    private final OneOrTwoFlagFields getFlaggedApiFromSource(JavaEvaluator evaluator, UAnnotation annotation) {
        String name;
        PsiField flag;
        UExpression expression;
        UNamedExpression uNamedExpression = (UNamedExpression)CollectionsKt.firstOrNull((List)annotation.getAttributeValues());
        UExpression uExpression = expression = uNamedExpression != null ? uNamedExpression.getExpression() : null;
        PsiElement psiElement = uExpression != null ? UastUtils.tryResolve((UElement)((UElement)uExpression)) : null;
        PsiField psiField = flag = psiElement instanceof PsiField ? (PsiField)psiElement : null;
        if (flag == null) {
            if (expression instanceof ULiteralExpression) {
                String string = UastUtils.evaluateString((UExpression)expression);
                if (string == null) {
                    return null;
                }
                String value = string;
                return this.getFlaggedApiFromString(evaluator, value);
            }
            return null;
        }
        PsiClass psiClass = flag.getContainingClass();
        String string = name = psiClass != null ? psiClass.getQualifiedName() : null;
        if (name != null && StringsKt.endsWith$default((String)name, (String)".Flags", (boolean)false, (int)2, null)) {
            String string2 = flag.getName();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getName(...)");
            String fieldName = string2;
            String packageName = StringsKt.substringBeforeLast$default((String)name, (String)".", null, (int)2, null);
            return new OneOrTwoFlagFields(flag, this.findFlagField(evaluator, packageName, "ExportedFlags", fieldName));
        }
        return new OneOrTwoFlagFields(flag, null);
    }

    private final String getFlaggedApiString(UAnnotation annotation) {
        PsiElement sourcePsi = annotation.getSourcePsi();
        if (sourcePsi instanceof PsiAnnotation) {
            PsiLiteralValue value;
            Object object = ((PsiAnnotation)sourcePsi).findAttributeValue("value");
            PsiLiteralValue psiLiteralValue = value = object instanceof PsiLiteralValue ? (PsiLiteralValue)object : null;
            object = psiLiteralValue != null ? psiLiteralValue.getValue() : null;
            return object instanceof String ? (String)object : null;
        }
        return null;
    }

    private final OneOrTwoFlagFields getFlaggedApiFromString(JavaEvaluator evaluator, String flag) {
        int separator = StringsKt.lastIndexOf$default((CharSequence)flag, (char)'.', (int)0, (boolean)false, (int)6, null);
        if (separator != -1) {
            String string = flag.substring(0, separator);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
            String packageName = string;
            String string2 = flag.substring(separator + 1);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
            String string3 = string2.toUpperCase(Locale.ROOT);
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"toUpperCase(...)");
            String fieldName = "FLAG_" + string3;
            PsiField primary = this.findFlagField(evaluator, packageName, "Flags", fieldName);
            PsiField secondary = this.findFlagField(evaluator, packageName, "ExportedFlags", fieldName);
            if (primary != null) {
                return new OneOrTwoFlagFields(primary, secondary);
            }
            if (secondary != null) {
                return new OneOrTwoFlagFields(secondary, null);
            }
        }
        return null;
    }

    private final PsiField findFlagField(JavaEvaluator evaluator, String packageName, String className, String fieldName) {
        PsiClass psiClass = evaluator.findClass(packageName + "." + className);
        return psiClass != null ? psiClass.findFieldByName(fieldName, true) : null;
    }

    private final boolean isAlreadyAnnotated(JavaEvaluator evaluator, UElement element, PsiField flag) {
        for (UElement current = element; current != null; current = current.getUastParent()) {
            PsiPackage pkg;
            if (current instanceof UAnnotated) {
                for (UAnnotation annotation : ((UAnnotated)current).getUAnnotations()) {
                    OneOrTwoFlagFields oneOrTwoFlagFields;
                    if (this.getFlaggedApiFromSource(evaluator, annotation) == null) continue;
                    PsiField flag1 = oneOrTwoFlagFields.component1();
                    PsiField flag2 = oneOrTwoFlagFields.component2();
                    if (!flag1.isEquivalentTo((PsiElement)flag) && (flag2 == null || !flag2.isEquivalentTo((PsiElement)flag))) continue;
                    return true;
                }
            }
            if (current instanceof UAnnotation) {
                if (!TypedefDetector.Companion.isTypeDef(((UAnnotation)current).getQualifiedName())) continue;
                return true;
            }
            if (!(current instanceof UFile)) continue;
            PsiElement psiElement = ((UFile)current).getJavaPsi();
            if (psiElement == null) {
                psiElement = (PsiElement)((UFile)current).getSourcePsi();
            }
            if ((pkg = evaluator.getPackage(psiElement)) == null) break;
            for (PsiAnnotation psiAnnotation : pkg.getAnnotations()) {
                OneOrTwoFlagFields oneOrTwoFlagFields;
                UAnnotation annotation;
                UastLanguagePlugin uastLanguagePlugin = (UastLanguagePlugin)UastFacade.INSTANCE;
                Intrinsics.checkNotNull((Object)psiAnnotation);
                UElement uElement = UastLanguagePlugin.convertElement$default((UastLanguagePlugin)uastLanguagePlugin, (PsiElement)((PsiElement)psiAnnotation), null, null, (int)4, null);
                UAnnotation uAnnotation = uElement instanceof UAnnotation ? (UAnnotation)uElement : null;
                if (uAnnotation == null || this.getFlaggedApiFromSource(evaluator, annotation = uAnnotation) == null) continue;
                PsiField flag1 = oneOrTwoFlagFields.component1();
                PsiField flag2 = oneOrTwoFlagFields.component2();
                if (!flag1.isEquivalentTo((PsiElement)flag) && (flag2 == null || !flag2.isEquivalentTo((PsiElement)flag))) continue;
                return true;
            }
            break;
        }
        return false;
    }

    private final boolean isFlagChecked(UElement element, PsiClass flagClass1, PsiClass flagClass2, String flagMethodName) {
        UElement uElement = element.getUastParent();
        if (uElement == null) {
            return false;
        }
        UElement curr = uElement;
        UElement prev = element;
        while (!(curr instanceof UFile)) {
            UExpression condition;
            UExpression first;
            UExpression body;
            Object condition2;
            if (curr instanceof UIfExpression) {
                condition2 = ((UIfExpression)curr).getCondition();
                if (prev != condition2) {
                    boolean fromThen = Intrinsics.areEqual((Object)prev, (Object)((UIfExpression)curr).getThenExpression());
                    if (fromThen) {
                        if (this.isFlagExpression((UElement)condition2, flagClass1, flagClass2, flagMethodName)) {
                            return true;
                        }
                    } else {
                        UExpression op = UastUtils.skipParenthesizedExprDown((UExpression)condition2);
                        if (op instanceof UUnaryExpression && Intrinsics.areEqual((Object)((UUnaryExpression)op).getOperator(), (Object)UastPrefixOperator.LOGICAL_NOT) && this.isFlagExpression((UElement)((UUnaryExpression)op).getOperand(), flagClass1, flagClass2, flagMethodName)) {
                            return true;
                        }
                        if (op instanceof UPolyadicExpression && Intrinsics.areEqual((Object)((UPolyadicExpression)op).getOperator(), (Object)UastBinaryOperator.LOGICAL_OR)) {
                            boolean bl;
                            block19: {
                                Iterable $this$any$iv = ((UPolyadicExpression)op).getOperands();
                                boolean $i$f$any = false;
                                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                                    bl = false;
                                } else {
                                    for (Object element$iv : $this$any$iv) {
                                        UExpression it = (UExpression)element$iv;
                                        boolean bl2 = false;
                                        UExpression nested = UastUtils.skipParenthesizedExprDown((UExpression)it);
                                        if (!(nested instanceof UUnaryExpression && Intrinsics.areEqual((Object)((UUnaryExpression)nested).getOperator(), (Object)UastPrefixOperator.LOGICAL_NOT) && this.isFlagExpression((UElement)((UUnaryExpression)nested).getOperand(), flagClass1, flagClass2, flagMethodName))) continue;
                                        bl = true;
                                        break block19;
                                    }
                                    bl = false;
                                }
                            }
                            if (bl) {
                                return true;
                            }
                        }
                    }
                }
            } else if (curr instanceof UPolyadicExpression && Intrinsics.areEqual((Object)((UPolyadicExpression)curr).getOperator(), (Object)UastBinaryOperator.LOGICAL_AND)) {
                UExpression operand;
                condition2 = ((UPolyadicExpression)curr).getOperands().iterator();
                while (condition2.hasNext() && (operand = (UExpression)condition2.next()) != curr) {
                    if (!this.isFlagExpression((UElement)operand, flagClass1, flagClass2, flagMethodName)) continue;
                    return true;
                }
            } else if (curr instanceof UMethod && (body = ((UMethod)curr).getUastBody()) instanceof UBlockExpression && ((UBlockExpression)body).getExpressions().size() > 1 && (first = (UExpression)((UBlockExpression)body).getExpressions().get(0)) instanceof UIfExpression && (condition = UastUtils.skipParenthesizedExprDown((UExpression)((UIfExpression)first).getCondition())) instanceof UUnaryExpression && Intrinsics.areEqual((Object)((UUnaryExpression)condition).getOperator(), (Object)UastPrefixOperator.LOGICAL_NOT) && this.isFlagExpression((UElement)((UUnaryExpression)condition).getOperand(), flagClass1, flagClass2, flagMethodName)) {
                UExpression then;
                UExpression uExpression = ((UIfExpression)first).getThenExpression();
                Object object = then = uExpression != null ? UastUtils.skipParenthesizedExprDown((UExpression)uExpression) : null;
                if (then != null && UastLintUtilsKt.isUnconditionalReturn((UExpression)then)) {
                    return true;
                }
            }
            prev = curr;
            if (curr.getUastParent() == null) break;
        }
        return false;
    }

    private final boolean isFlagExpression(UElement element, PsiClass flagClass1, PsiClass flagClass2, String flagMethodName) {
        if (element instanceof UReferenceExpression || element instanceof UCallExpression) {
            UExpression initializer;
            PsiElement resolved = UastUtils.tryResolve((UElement)element);
            if (resolved instanceof PsiMethod) {
                PsiClass cls;
                if (Intrinsics.areEqual((Object)((PsiMethod)resolved).getName(), (Object)flagMethodName) && (flagClass1.isEquivalentTo((PsiElement)(cls = ((PsiMethod)resolved).getContainingClass())) || flagClass2 != null && flagClass2.isEquivalentTo((PsiElement)cls))) {
                    return true;
                }
            } else if (resolved instanceof PsiField && (initializer = UastFacade.INSTANCE.getInitializerBody((PsiVariable)resolved)) != null) {
                return this.isFlagExpression((UElement)initializer, flagClass1, flagClass2, flagMethodName);
            }
        } else {
            if (element instanceof UParenthesizedExpression) {
                return this.isFlagExpression((UElement)((UParenthesizedExpression)element).getExpression(), flagClass1, flagClass2, flagMethodName);
            }
            if (element instanceof UPolyadicExpression && Intrinsics.areEqual((Object)((UPolyadicExpression)element).getOperator(), (Object)UastBinaryOperator.LOGICAL_AND)) {
                for (UExpression operand : ((UPolyadicExpression)element).getOperands()) {
                    if (!this.isFlagExpression((UElement)operand, flagClass1, flagClass2, flagMethodName)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    static {
        Issue.Companion companion = Issue.Companion;
        Category category = Category.CORRECTNESS;
        Severity severity = Severity.ERROR;
        Implementation implementation = IMPLEMENTATION;
        ISSUE = Issue.Companion.create$default((Issue.Companion)companion, (String)"FlaggedApi", (String)"FlaggedApi access without check", (String)"\n          This lint check looks for accesses of APIs marked with `@FlaggedApi(X)` without \\\n          a guarding `if (Flags.X)` check. See go/android-flagged-apis.\n          ", (Implementation)implementation, null, (Category)category, (int)6, (Severity)severity, (boolean)false, (Boolean)true, null, null, (int)3344, null);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u00020\u00078\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lcom/android/tools/lint/checks/optional/FlaggedApiDetector$Issues;", "", "<init>", "()V", "IMPLEMENTATION", "Lcom/android/tools/lint/detector/api/Implementation;", "ISSUE", "Lcom/android/tools/lint/detector/api/Issue;", "FLAGGED_API_ANNOTATION", "", "lint-checks"})
    public static final class Issues {
        private Issues() {
        }

        public /* synthetic */ Issues(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\b\u0002\u0018\u00002\u00020\u0001B\u0019\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J\t\u0010\n\u001a\u00020\u0003H\u0086\u0002J\u000b\u0010\u000b\u001a\u0004\u0018\u00010\u0003H\u0086\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\b\u00a8\u0006\f"}, d2={"Lcom/android/tools/lint/checks/optional/FlaggedApiDetector$OneOrTwoFlagFields;", "", "flag1", "Lcom/intellij/psi/PsiField;", "flag2", "<init>", "(Lcom/intellij/psi/PsiField;Lcom/intellij/psi/PsiField;)V", "getFlag1", "()Lcom/intellij/psi/PsiField;", "getFlag2", "component1", "component2", "lint-checks"})
    private static final class OneOrTwoFlagFields {
        @NotNull
        private final PsiField flag1;
        @Nullable
        private final PsiField flag2;

        public OneOrTwoFlagFields(@NotNull PsiField flag1, @Nullable PsiField flag2) {
            Intrinsics.checkNotNullParameter((Object)flag1, (String)"flag1");
            this.flag1 = flag1;
            this.flag2 = flag2;
        }

        @NotNull
        public final PsiField getFlag1() {
            return this.flag1;
        }

        @Nullable
        public final PsiField getFlag2() {
            return this.flag2;
        }

        @NotNull
        public final PsiField component1() {
            return this.flag1;
        }

        @Nullable
        public final PsiField component2() {
            return this.flag2;
        }
    }

    @Metadata(mv={2, 0, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[AnnotationUsageType.values().length];
            try {
                nArray[AnnotationUsageType.METHOD_CALL.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[AnnotationUsageType.METHOD_REFERENCE.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[AnnotationUsageType.FIELD_REFERENCE.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[AnnotationUsageType.CLASS_REFERENCE.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[AnnotationUsageType.ANNOTATION_REFERENCE.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[AnnotationUsageType.EXTENDS.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[AnnotationUsageType.DEFINITION.ordinal()] = 7;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

