/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.checks;

import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.Implementation;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.LayoutDetector;
import com.android.tools.lint.detector.api.Location;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import com.android.tools.lint.detector.api.XmlContext;
import com.android.utils.DomExtensions;
import java.util.Collection;
import java.util.Iterator;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u001e\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \r2\u00020\u0001:\u0001\rB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u0016J\u0018\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016\u00a8\u0006\u000e"}, d2={"Lcom/android/tools/lint/checks/ScrollViewChildDetector;", "Lcom/android/tools/lint/detector/api/LayoutDetector;", "<init>", "()V", "getApplicableElements", "", "", "visitElement", "", "context", "Lcom/android/tools/lint/detector/api/XmlContext;", "element", "Lorg/w3c/dom/Element;", "Companion", "lint-checks"})
@SourceDebugExtension(value={"SMAP\nScrollViewChildDetector.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ScrollViewChildDetector.kt\ncom/android/tools/lint/checks/ScrollViewChildDetector\n+ 2 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n*L\n1#1,86:1\n2275#2,2:87\n*S KotlinDebug\n*F\n+ 1 ScrollViewChildDetector.kt\ncom/android/tools/lint/checks/ScrollViewChildDetector\n*L\n56#1:87,2\n*E\n"})
public final class ScrollViewChildDetector
extends LayoutDetector {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @JvmField
    @NotNull
    public static final Issue ISSUE = Issue.Companion.create("ScrollViewSize", "ScrollView size validation", "\n          ScrollView children must set their `layout_width` or `layout_height` attributes \\\n          to `wrap_content` rather than `fill_parent` or `match_parent` in the scrolling \\\n          dimension.\n          ", Category.CORRECTNESS, 7, Severity.WARNING, new Implementation(ScrollViewChildDetector.class, Scope.RESOURCE_FILE_SCOPE));

    @NotNull
    public Collection<String> getApplicableElements() {
        Object[] objectArray = new String[]{"ScrollView", "HorizontalScrollView"};
        return CollectionsKt.listOf((Object[])objectArray);
    }

    public void visitElement(@NotNull XmlContext context, @NotNull Element element) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        boolean isHorizontal = Intrinsics.areEqual((Object)"HorizontalScrollView", (Object)element.getTagName());
        String attributeName = isHorizontal ? "layout_width" : "layout_height";
        Iterator iterator = DomExtensions.iterator((Element)element);
        while (iterator.hasNext()) {
            boolean bl;
            Attr sizeNode;
            Element child;
            block3: {
                child = (Element)iterator.next();
                if (child.getAttributeNodeNS("http://schemas.android.com/apk/res/android", attributeName) == null) {
                    return;
                }
                String value = sizeNode.getValue();
                if (!Intrinsics.areEqual((Object)"fill_parent", (Object)value) && !Intrinsics.areEqual((Object)"match_parent", (Object)value)) continue;
                Sequence $this$none$iv = SequencesKt.asSequence((Iterator)DomExtensions.childrenIterator((Node)child));
                boolean $i$f$none = false;
                for (Object element$iv : $this$none$iv) {
                    Node it = (Node)element$iv;
                    boolean bl2 = false;
                    if (!Intrinsics.areEqual((Object)it.getNodeName(), (Object)"WebView")) continue;
                    bl = false;
                    break block3;
                }
                bl = true;
            }
            if (!bl) continue;
            String msg = "This " + child.getTagName() + " should use `android:" + attributeName + "=\"wrap_content\"`";
            XmlContext.report$default((XmlContext)context, (Issue)ISSUE, (Node)sizeNode, (Location)context.getLocation((Node)sizeNode), (String)msg, null, (int)16, null);
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0010\u0010\u0004\u001a\u00020\u00058\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/android/tools/lint/checks/ScrollViewChildDetector$Companion;", "", "<init>", "()V", "ISSUE", "Lcom/android/tools/lint/detector/api/Issue;", "lint-checks"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

