/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.common.build;

import com.android.ide.common.build.GenericBuiltArtifact;
import com.android.ide.common.build.GenericBuiltArtifacts;
import com.android.ide.common.build.GenericFilterConfiguration;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0006\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J4\u0010\u0003\u001a\u0004\u0018\u00010\u00042\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00040\u00062\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\b0\u00062\u000e\u0010\t\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\b0\nJ2\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\f0\n2\u0006\u0010\u0005\u001a\u00020\r2\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\b0\u00062\u000e\u0010\t\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\b0\nJ \u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00042\u000e\u0010\u0011\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\b0\nH\u0002J\u001a\u0010\u0012\u001a\u0004\u0018\u00010\b2\u0006\u0010\u0013\u001a\u00020\u00042\u0006\u0010\u0014\u001a\u00020\bH\u0002J.\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00042\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\b0\u00062\u000e\u0010\t\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\b0\u0006H\u0002J!\u0010\u0018\u001a\u00020\u000f2\b\u0010\u0019\u001a\u0004\u0018\u00010\u000f2\b\u0010\u001a\u001a\u0004\u0018\u00010\u000fH\u0002\u00a2\u0006\u0002\u0010\u001b\u00a8\u0006\u001c"}, d2={"Lcom/android/ide/common/build/GenericBuiltArtifactsSplitOutputMatcher;", "", "()V", "computeBestArtifact", "Lcom/android/ide/common/build/GenericBuiltArtifact;", "outputs", "", "variantAbiFilters", "", "deviceAbis", "", "computeBestOutput", "Ljava/io/File;", "Lcom/android/ide/common/build/GenericBuiltArtifacts;", "getAbiPreferenceOrder", "", "builtArtifact", "deviceAbi", "getFilter", "variantOutput", "filterType", "isMainApkCompatibleWithDevice", "", "mainBuiltArtifact", "versionCodeDiff", "a", "b", "(Ljava/lang/Integer;Ljava/lang/Integer;)I", "sdk-common"})
@SourceDebugExtension(value={"SMAP\nGenericBuiltArtifactsSplitOutputMatcher.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GenericBuiltArtifactsSplitOutputMatcher.kt\ncom/android/ide/common/build/GenericBuiltArtifactsSplitOutputMatcher\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,162:1\n288#2,2:163\n*S KotlinDebug\n*F\n+ 1 GenericBuiltArtifactsSplitOutputMatcher.kt\ncom/android/ide/common/build/GenericBuiltArtifactsSplitOutputMatcher\n*L\n160#1:163,2\n*E\n"})
public final class GenericBuiltArtifactsSplitOutputMatcher {
    @NotNull
    public static final GenericBuiltArtifactsSplitOutputMatcher INSTANCE = new GenericBuiltArtifactsSplitOutputMatcher();

    private GenericBuiltArtifactsSplitOutputMatcher() {
    }

    @NotNull
    public final List<File> computeBestOutput(@NotNull GenericBuiltArtifacts outputs, @NotNull Collection<String> variantAbiFilters, @NotNull List<String> deviceAbis) {
        List list;
        ImmutableList immutableList;
        ImmutableList immutableList2;
        Intrinsics.checkNotNullParameter((Object)outputs, (String)"outputs");
        Intrinsics.checkNotNullParameter(variantAbiFilters, (String)"variantAbiFilters");
        Intrinsics.checkNotNullParameter(deviceAbis, (String)"deviceAbis");
        GenericBuiltArtifact genericBuiltArtifact = this.computeBestArtifact(outputs.getElements(), variantAbiFilters, deviceAbis);
        if (genericBuiltArtifact != null) {
            GenericBuiltArtifact it = genericBuiltArtifact;
            boolean bl = false;
            immutableList2 = ImmutableList.of((Object)new File(it.getOutputFile()));
        } else {
            immutableList2 = immutableList = null;
        }
        if (immutableList == null) {
            ImmutableList immutableList3 = ImmutableList.of();
            Intrinsics.checkNotNullExpressionValue((Object)immutableList3, (String)"of<File>()");
            list = (List)immutableList3;
        } else {
            list = (List)immutableList;
        }
        return list;
    }

    @Nullable
    public final GenericBuiltArtifact computeBestArtifact(@NotNull Collection<GenericBuiltArtifact> outputs, @NotNull Collection<String> variantAbiFilters, @NotNull List<String> deviceAbis) {
        Intrinsics.checkNotNullParameter(outputs, (String)"outputs");
        Intrinsics.checkNotNullParameter(variantAbiFilters, (String)"variantAbiFilters");
        Intrinsics.checkNotNullParameter(deviceAbis, (String)"deviceAbis");
        ArrayList arrayList = Lists.newArrayList();
        Intrinsics.checkNotNullExpressionValue((Object)arrayList, (String)"newArrayList()");
        List matches = arrayList;
        for (GenericBuiltArtifact builtArtifact : outputs) {
            String abiFilter = this.getFilter(builtArtifact, "ABI");
            if (abiFilter != null && !deviceAbis.contains(abiFilter)) continue;
            matches.add(builtArtifact);
        }
        if (matches.isEmpty()) {
            return null;
        }
        GenericBuiltArtifact match2 = (GenericBuiltArtifact)Collections.max(matches, new Comparator(deviceAbis){
            final /* synthetic */ List<String> $deviceAbis;
            {
                this.$deviceAbis = $deviceAbis;
            }

            public final int compare(@NotNull GenericBuiltArtifact splitOutput, @NotNull GenericBuiltArtifact splitOutput2) {
                Intrinsics.checkNotNullParameter((Object)splitOutput, (String)"splitOutput");
                Intrinsics.checkNotNullParameter((Object)splitOutput2, (String)"splitOutput2");
                int rc = GenericBuiltArtifactsSplitOutputMatcher.access$versionCodeDiff(GenericBuiltArtifactsSplitOutputMatcher.INSTANCE, splitOutput.getVersionCode(), splitOutput2.getVersionCode());
                if (rc != 0) {
                    return rc;
                }
                int abiOrder1 = GenericBuiltArtifactsSplitOutputMatcher.access$getAbiPreferenceOrder(GenericBuiltArtifactsSplitOutputMatcher.INSTANCE, splitOutput, this.$deviceAbis);
                int abiOrder2 = GenericBuiltArtifactsSplitOutputMatcher.access$getAbiPreferenceOrder(GenericBuiltArtifactsSplitOutputMatcher.INSTANCE, splitOutput2, this.$deviceAbis);
                return abiOrder1 - abiOrder2;
            }
        });
        Intrinsics.checkNotNullExpressionValue((Object)match2, (String)"match");
        return this.isMainApkCompatibleWithDevice(match2, variantAbiFilters, (Collection<String>)deviceAbis) ? match2 : null;
    }

    private final int versionCodeDiff(Integer a, Integer b) {
        Integer n = a;
        Integer n2 = b;
        return (n != null ? n : 1) - (n2 != null ? n2 : 1);
    }

    private final int getAbiPreferenceOrder(GenericBuiltArtifact builtArtifact, List<String> deviceAbi) {
        String abiFilter = this.getFilter(builtArtifact, "ABI");
        if (Strings.isNullOrEmpty((String)abiFilter)) {
            return deviceAbi.size() - 1;
        }
        int match2 = deviceAbi.indexOf(abiFilter);
        if (match2 == 0) {
            match2 = deviceAbi.size();
        } else if (match2 > 0) {
            match2 = deviceAbi.size() - match2 - 1;
        }
        return match2;
    }

    private final boolean isMainApkCompatibleWithDevice(GenericBuiltArtifact mainBuiltArtifact, Collection<String> variantAbiFilters, Collection<String> deviceAbis) {
        if (this.getFilter(mainBuiltArtifact, "ABI") == null && !variantAbiFilters.isEmpty()) {
            for (String abi : deviceAbis) {
                if (!CollectionsKt.contains((Iterable)variantAbiFilters, (Object)abi)) continue;
                return true;
            }
            return false;
        }
        return true;
    }

    private final String getFilter(GenericBuiltArtifact variantOutput, String filterType) {
        Object v0;
        block1: {
            Iterable $this$firstOrNull$iv = variantOutput.getFilters();
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                GenericFilterConfiguration it = (GenericFilterConfiguration)element$iv;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it.getFilterType(), (Object)filterType)) continue;
                v0 = element$iv;
                break block1;
            }
            v0 = null;
        }
        GenericFilterConfiguration genericFilterConfiguration = v0;
        return genericFilterConfiguration != null ? genericFilterConfiguration.getIdentifier() : null;
    }

    public static final /* synthetic */ int access$versionCodeDiff(GenericBuiltArtifactsSplitOutputMatcher $this, Integer a, Integer b) {
        return $this.versionCodeDiff(a, b);
    }

    public static final /* synthetic */ int access$getAbiPreferenceOrder(GenericBuiltArtifactsSplitOutputMatcher $this, GenericBuiltArtifact builtArtifact, List deviceAbi) {
        return $this.getAbiPreferenceOrder(builtArtifact, deviceAbi);
    }
}

