/*
 * Decompiled with CFR 0.152.
 */
package com.android.sdklib.repository.targets;

import com.android.repository.Revision;
import com.android.repository.api.RepoPackage;
import com.android.repository.impl.meta.TypeDetails;
import com.android.sdklib.AndroidVersion;
import com.android.sdklib.ISystemImage;
import com.android.sdklib.repository.IdDisplay;
import com.android.sdklib.repository.meta.DetailsTypes;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.collect.Comparators;
import com.google.common.collect.ImmutableList;
import java.nio.file.Path;
import java.util.Comparator;
import java.util.List;

public class SystemImage
implements ISystemImage {
    private final Path mLocation;
    private final ImmutableList<IdDisplay> mTags;
    private final IdDisplay mVendor;
    private final List<String> mAbis;
    private final List<String> mTranslatedAbis;
    private final ImmutableList<Path> mSkins;
    private final AndroidVersion mAndroidVersion;
    private final RepoPackage mPackage;

    public SystemImage(Path location, Iterable<IdDisplay> tags, IdDisplay vendor, List<String> abis, List<String> translatedAbis, List<Path> skins, RepoPackage pkg) {
        Preconditions.checkArgument((!abis.isEmpty() ? 1 : 0) != 0);
        this.mLocation = location;
        this.mTags = ImmutableList.copyOf(tags);
        this.mVendor = vendor;
        this.mAbis = ImmutableList.copyOf(abis);
        this.mTranslatedAbis = ImmutableList.copyOf(translatedAbis);
        this.mSkins = ImmutableList.copyOf(skins);
        this.mPackage = pkg;
        TypeDetails details = pkg.getTypeDetails();
        assert (details instanceof DetailsTypes.ApiDetailsType);
        this.mAndroidVersion = ((DetailsTypes.ApiDetailsType)details).getAndroidVersion();
    }

    public SystemImage(Path location, IdDisplay tag, IdDisplay vendor, List<String> abi, List<String> translatedAbi, List<Path> skins, RepoPackage pkg) {
        this(location, (Iterable<IdDisplay>)ImmutableList.of((Object)tag), vendor, abi, translatedAbi, skins, pkg);
    }

    @Override
    public Path getLocation() {
        return this.mLocation;
    }

    @Override
    public List<IdDisplay> getTags() {
        return this.mTags;
    }

    @Override
    public IdDisplay getAddonVendor() {
        return this.mVendor;
    }

    @Override
    public String getPrimaryAbiType() {
        return this.mAbis.get(0);
    }

    @Override
    public List<String> getAbiTypes() {
        return this.mAbis;
    }

    @Override
    public List<String> getTranslatedAbiTypes() {
        return this.mTranslatedAbis;
    }

    @Override
    public List<Path> getSkins() {
        return this.mSkins;
    }

    @Override
    public AndroidVersion getAndroidVersion() {
        return this.mAndroidVersion;
    }

    @Override
    public RepoPackage getPackage() {
        return this.mPackage;
    }

    @Override
    public boolean obsolete() {
        return this.mPackage.obsolete();
    }

    @Override
    public int compareTo(ISystemImage o) {
        return Comparator.comparing(ISystemImage::getTag).thenComparing(ISystemImage::getAbiTypes, Comparators.lexicographical(Comparator.naturalOrder())).thenComparing(ISystemImage::getTranslatedAbiTypes, Comparators.lexicographical(Comparator.naturalOrder())).thenComparing(ISystemImage::getAddonVendor, Comparator.nullsFirst(IdDisplay::compareTo)).thenComparing(ISystemImage::getLocation).thenComparing(ISystemImage::getSkins, Comparators.lexicographical(Comparator.naturalOrder())).compare(this, o);
    }

    public boolean equals(Object o) {
        if (!(o instanceof SystemImage)) {
            return false;
        }
        return this.compareTo((SystemImage)o) == 0;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.getTag(), this.getAbiTypes(), this.getTranslatedAbiTypes(), this.getAddonVendor(), this.getLocation(), this.getSkins()});
    }

    @Override
    public Revision getRevision() {
        return this.mPackage.getVersion();
    }
}

