/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.utp.plugins.host.emulatorcontrol;

import com.android.tools.utp.plugins.host.emulatorcontrol.EmulatorControlConfigUtilsKt;
import com.android.tools.utp.plugins.host.emulatorcontrol.EmulatorControlUtilsKt;
import com.android.tools.utp.plugins.host.emulatorcontrol.EmulatorGrpcInfo;
import com.android.tools.utp.plugins.host.emulatorcontrol.JwtConfig;
import com.android.tools.utp.plugins.host.emulatorcontrol.proto.EmulatorControlPluginProto;
import com.google.common.annotations.VisibleForTesting;
import com.google.protobuf.Any;
import com.google.protobuf.ByteString;
import com.google.protobuf.Message;
import com.google.protobuf.ProtocolStringList;
import com.google.testing.platform.api.config.ProtoConfig;
import com.google.testing.platform.api.context.Context;
import com.google.testing.platform.api.context.ContextExtKt;
import com.google.testing.platform.api.device.DeviceController;
import com.google.testing.platform.api.event.EventExtKt;
import com.google.testing.platform.api.event.Events;
import com.google.testing.platform.api.plugin.HostPlugin;
import com.google.testing.platform.lib.logging.jvm.LoggerExtKt;
import com.google.testing.platform.plugin.android.proto.InstrumentationTestOptionsPluginProto;
import com.google.testing.platform.plugin.android.proto.InstrumentationTestOptionsProvidedKt;
import com.google.testing.platform.proto.api.core.TestArtifactProto;
import com.google.testing.platform.proto.api.core.TestCaseProto;
import com.google.testing.platform.proto.api.core.TestResultProto;
import com.google.testing.platform.proto.api.core.TestSuiteResultProto;
import com.google.testing.platform.runtime.android.controller.ext.AndroidDeviceControllerExtKt;
import java.io.File;
import java.util.List;
import java.util.logging.Logger;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 &2\u00020\u0001:\u0001&B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\r\u001a\u00020\u000eH\u0016J \u0010\u0011\u001a\u00020\u00102\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00132\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J\u001a\u0010\u0017\u001a\u00020\u00102\b\u0010\u0018\u001a\u0004\u0018\u00010\u00192\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J\u0010\u0010\u001a\u001a\u00020\u00102\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J \u0010\u001b\u001a\u00020\u00102\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u001e\u001a\u00020\u001fH\u0016J \u0010 \u001a\u00020\u00102\u0006\u0010!\u001a\u00020\"2\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u001e\u001a\u00020\u001fH\u0016J\b\u0010#\u001a\u00020\u001fH\u0016J\u0010\u0010$\u001a\u00020%2\u0006\u0010\u0015\u001a\u00020\u0016H\u0002R$\u0010\u0004\u001a\u00020\u00058\u0006@\u0006X\u0087.\u00a2\u0006\u0014\n\u0000\u0012\u0004\b\u0006\u0010\u0003\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\nR\u000e\u0010\u000b\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082.\u00a2\u0006\u0002\n\u0000\u00a8\u0006'"}, d2={"Lcom/android/tools/utp/plugins/host/emulatorcontrol/EmulatorControlPlugin;", "Lcom/google/testing/platform/api/plugin/HostPlugin;", "<init>", "()V", "emulatorControlPluginConfig", "Lcom/android/tools/utp/plugins/host/emulatorcontrol/proto/EmulatorControlPluginProto$EmulatorControlPlugin;", "getEmulatorControlPluginConfig$annotations", "getEmulatorControlPluginConfig", "()Lcom/android/tools/utp/plugins/host/emulatorcontrol/proto/EmulatorControlPluginProto$EmulatorControlPlugin;", "setEmulatorControlPluginConfig", "(Lcom/android/tools/utp/plugins/host/emulatorcontrol/proto/EmulatorControlPluginProto$EmulatorControlPlugin;)V", "jwtConfig", "Lcom/android/tools/utp/plugins/host/emulatorcontrol/JwtConfig;", "context", "Lcom/google/testing/platform/api/context/Context;", "configure", "", "pushSourceIfExists", "source", "", "dest", "deviceController", "Lcom/google/testing/platform/api/device/DeviceController;", "beforeEach", "testCase", "Lcom/google/testing/platform/proto/api/core/TestCaseProto$TestCase;", "beforeAll", "afterAll", "testSuiteResult", "Lcom/google/testing/platform/proto/api/core/TestSuiteResultProto$TestSuiteResult;", "cancelled", "", "afterEach", "testResult", "Lcom/google/testing/platform/proto/api/core/TestResultProto$TestResult;", "canRun", "getGrpcInfo", "Lcom/android/tools/utp/plugins/host/emulatorcontrol/EmulatorGrpcInfo;", "Companion", "android-test-plugin-host-emulator-control"})
@SourceDebugExtension(value={"SMAP\nEmulatorControlPlugin.kt\nKotlin\n*S Kotlin\n*F\n+ 1 EmulatorControlPlugin.kt\ncom/android/tools/utp/plugins/host/emulatorcontrol/EmulatorControlPlugin\n+ 2 InstrumentationTestOptionsProvidedKt.kt\ncom/google/testing/platform/plugin/android/proto/InstrumentationTestOptionsProvidedKtKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,195:1\n10#2:196\n1#3:197\n*S KotlinDebug\n*F\n+ 1 EmulatorControlPlugin.kt\ncom/android/tools/utp/plugins/host/emulatorcontrol/EmulatorControlPlugin\n*L\n117#1:196\n117#1:197\n*E\n"})
public final class EmulatorControlPlugin
implements HostPlugin {
    @NotNull
    private static final Companion Companion = new Companion(null);
    public EmulatorControlPluginProto.EmulatorControlPlugin emulatorControlPluginConfig;
    @NotNull
    private JwtConfig jwtConfig = EmulatorControlUtilsKt.getINVALID_JWT_CONFIG();
    private Context context;
    @NotNull
    private static final Logger logger = LoggerExtKt.getLogger((Object)Companion);

    @NotNull
    public final EmulatorControlPluginProto.EmulatorControlPlugin getEmulatorControlPluginConfig() {
        EmulatorControlPluginProto.EmulatorControlPlugin emulatorControlPlugin = this.emulatorControlPluginConfig;
        if (emulatorControlPlugin != null) {
            return emulatorControlPlugin;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"emulatorControlPluginConfig");
        return null;
    }

    public final void setEmulatorControlPluginConfig(@NotNull EmulatorControlPluginProto.EmulatorControlPlugin emulatorControlPlugin) {
        Intrinsics.checkNotNullParameter((Object)emulatorControlPlugin, (String)"<set-?>");
        this.emulatorControlPluginConfig = emulatorControlPlugin;
    }

    @VisibleForTesting
    public static /* synthetic */ void getEmulatorControlPluginConfig$annotations() {
    }

    public void configure(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this.context = context;
        Object object = context.get("config");
        Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type com.google.testing.platform.api.config.ProtoConfig");
        ProtoConfig config = (ProtoConfig)object;
        Any any = config.getConfigProto();
        Intrinsics.checkNotNull((Object)any);
        this.setEmulatorControlPluginConfig(EmulatorControlPluginProto.EmulatorControlPlugin.parseFrom((ByteString)any.getValue()));
        String string = this.getEmulatorControlPluginConfig().getToken();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getToken(...)");
        String string2 = this.getEmulatorControlPluginConfig().getJwkFile();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getJwkFile(...)");
        this.jwtConfig = new JwtConfig(string, string2);
    }

    private final void pushSourceIfExists(String source, String dest, DeviceController deviceController) {
        TestArtifactProto.Artifact.Builder builder;
        CharSequence charSequence = source;
        if (charSequence == null || charSequence.length() == 0) {
            return;
        }
        TestArtifactProto.Artifact.Builder $this$pushSourceIfExists_u24lambda_u240 = builder = TestArtifactProto.Artifact.newBuilder();
        boolean bl = false;
        $this$pushSourceIfExists_u24lambda_u240.getSourcePathBuilder().setPath(source);
        $this$pushSourceIfExists_u24lambda_u240.getDestinationPathBuilder().setPath(dest);
        TestArtifactProto.Artifact artifact = builder.build();
        Intrinsics.checkNotNull((Object)artifact);
        deviceController.push(artifact);
        logger.fine("Pushed " + source + " to " + dest);
    }

    public void beforeEach(@Nullable TestCaseProto.TestCase testCase, @NotNull DeviceController deviceController) {
        Intrinsics.checkNotNullParameter((Object)deviceController, (String)"deviceController");
        logger.fine("Updating timestamp of " + this.getEmulatorControlPluginConfig().getJwkFile());
        if (!new File(this.jwtConfig.getJwkPath()).setLastModified(System.currentTimeMillis())) {
            logger.warning("Unable to update timestamp of " + this.jwtConfig.getJwkPath() + ", the emulator might delete the key!");
        }
    }

    /*
     * WARNING - void declaration
     */
    public void beforeAll(@NotNull DeviceController deviceController) {
        Intrinsics.checkNotNullParameter((Object)deviceController, (String)"deviceController");
        CharSequence charSequence = this.getEmulatorControlPluginConfig().getToken();
        if (charSequence == null || charSequence.length() == 0) {
            EmulatorGrpcInfo grpcInfo = this.getGrpcInfo(deviceController);
            ProtocolStringList protocolStringList = this.getEmulatorControlPluginConfig().getAllowedEndpointsList();
            Intrinsics.checkNotNullExpressionValue((Object)protocolStringList, (String)"getAllowedEndpointsList(...)");
            this.jwtConfig = EmulatorControlUtilsKt.createTokenConfig(CollectionsKt.toSet((Iterable)((Iterable)protocolStringList)), this.getEmulatorControlPluginConfig().getSecondsValid(), "gradle-utp-emulator-control", grpcInfo);
            if (Intrinsics.areEqual((Object)this.jwtConfig, (Object)EmulatorControlUtilsKt.getINVALID_JWT_CONFIG())) {
                logger.warning("Control of the emulator is not supported for emulators without security features enabled. Please upgrade to a later version of the emulator.");
            } else {
                void $this$beforeAll_u24lambda_u241;
                InstrumentationTestOptionsProvidedKt.Dsl dsl;
                Context context = this.context;
                if (context == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"context");
                    context = null;
                }
                Events events = ContextExtKt.getEvents((Context)context);
                boolean bl = false;
                InstrumentationTestOptionsPluginProto.InstrumentationTestOptionsProvided.Builder builder = InstrumentationTestOptionsPluginProto.InstrumentationTestOptionsProvided.newBuilder();
                Intrinsics.checkNotNullExpressionValue((Object)builder, (String)"newBuilder()");
                InstrumentationTestOptionsProvidedKt.Dsl $this$instrumentationTestOptionsProvided_u24lambda_u240$iv = dsl = InstrumentationTestOptionsProvidedKt.Dsl.Companion._create(builder);
                boolean bl2 = false;
                InstrumentationTestOptionsProvidedKt.Dsl dsl2 = $this$instrumentationTestOptionsProvided_u24lambda_u240$iv;
                Events events2 = events;
                boolean bl3 = false;
                Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"grpc.port", (Object)String.valueOf(grpcInfo.getPort())), TuplesKt.to((Object)"grpc.token", (Object)this.jwtConfig.getToken())};
                $this$beforeAll_u24lambda_u241.putAllTestOptions($this$beforeAll_u24lambda_u241.getTestOptionsMap(), MapsKt.mapOf((Pair[])pairArray));
                EventExtKt.send((Events)events2, (Message)((Message)dsl._build()));
            }
        }
        String string = this.getEmulatorControlPluginConfig().getEmulatorClientCaFilePath();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getEmulatorClientCaFilePath(...)");
        this.pushSourceIfExists(string, this.getEmulatorControlPluginConfig().getTlsCfgPrefix() + ".cer", deviceController);
        String string2 = this.getEmulatorControlPluginConfig().getEmulatorClientPrivateKeyFilePath();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getEmulatorClientPrivateKeyFilePath(...)");
        this.pushSourceIfExists(string2, this.getEmulatorControlPluginConfig().getTlsCfgPrefix() + ".key", deviceController);
        String string3 = this.getEmulatorControlPluginConfig().getTrustedCollectionRootPath();
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"getTrustedCollectionRootPath(...)");
        this.pushSourceIfExists(string3, this.getEmulatorControlPluginConfig().getTlsCfgPrefix() + ".ca", deviceController);
    }

    public void afterAll(@NotNull TestSuiteResultProto.TestSuiteResult testSuiteResult, @NotNull DeviceController deviceController, boolean cancelled) {
        Intrinsics.checkNotNullParameter((Object)testSuiteResult, (String)"testSuiteResult");
        Intrinsics.checkNotNullParameter((Object)deviceController, (String)"deviceController");
        logger.fine("Deleting " + this.jwtConfig.getJwkPath());
        new File(this.jwtConfig.getJwkPath()).delete();
        Object[] objectArray = new String[]{this.getEmulatorControlPluginConfig().getTlsCfgPrefix() + ".cer", this.getEmulatorControlPluginConfig().getTlsCfgPrefix() + ".cer", this.getEmulatorControlPluginConfig().getTlsCfgPrefix() + ".ca"};
        AndroidDeviceControllerExtKt.delete$default((DeviceController)deviceController, (List)CollectionsKt.listOf((Object[])objectArray), (boolean)false, null, (int)6, null);
    }

    public void afterEach(@NotNull TestResultProto.TestResult testResult, @NotNull DeviceController deviceController, boolean cancelled) {
        Intrinsics.checkNotNullParameter((Object)testResult, (String)"testResult");
        Intrinsics.checkNotNullParameter((Object)deviceController, (String)"deviceController");
    }

    public boolean canRun() {
        return true;
    }

    private final EmulatorGrpcInfo getGrpcInfo(DeviceController deviceController) {
        if (this.getEmulatorControlPluginConfig().getEmulatorGrpcPort() != 0) {
            return new EmulatorGrpcInfo(this.getEmulatorControlPluginConfig().getEmulatorGrpcPort(), this.getEmulatorControlPluginConfig().getToken(), "", "", "");
        }
        return EmulatorControlConfigUtilsKt.findGrpcInfo(deviceController.getDevice().getSerial());
    }

    @NotNull
    public static final Logger getLogger() {
        return Companion.getLogger();
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0082\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u001c\u0010\u0004\u001a\u00020\u00058\u0006X\u0087\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\u0006\u0010\u0003\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\t"}, d2={"Lcom/android/tools/utp/plugins/host/emulatorcontrol/EmulatorControlPlugin$Companion;", "", "<init>", "()V", "logger", "Ljava/util/logging/Logger;", "getLogger$annotations", "getLogger", "()Ljava/util/logging/Logger;", "android-test-plugin-host-emulator-control"})
    private static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Logger getLogger() {
            return logger;
        }

        @JvmStatic
        public static /* synthetic */ void getLogger$annotations() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

