/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.utp.plugins.host.emulatorcontrol;

import com.android.tools.utp.plugins.host.emulatorcontrol.EmulatorGrpcInfo;
import com.android.tools.utp.plugins.host.emulatorcontrol.JwtConfig;
import com.google.crypto.tink.KeyTemplate;
import com.google.crypto.tink.KeyTemplates;
import com.google.crypto.tink.KeysetHandle;
import com.google.crypto.tink.jwt.JwkSetConverter;
import com.google.crypto.tink.jwt.JwtPublicKeySign;
import com.google.crypto.tink.jwt.JwtSignatureConfig;
import com.google.crypto.tink.jwt.RawJwt;
import java.io.BufferedWriter;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.time.Instant;
import java.util.Collection;
import java.util.Set;
import java.util.UUID;
import java.util.logging.Logger;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000,\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u001a.\u0010\u0007\u001a\u00020\u00042\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\n2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000f\u001a.\u0010\u0010\u001a\u00020\u00042\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\n2\b\u0010\u0011\u001a\u0004\u0018\u00010\n\"\u0016\u0010\u0000\u001a\n \u0002*\u0004\u0018\u00010\u00010\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0012"}, d2={"LOG", "Ljava/util/logging/Logger;", "kotlin.jvm.PlatformType", "INVALID_JWT_CONFIG", "Lcom/android/tools/utp/plugins/host/emulatorcontrol/JwtConfig;", "getINVALID_JWT_CONFIG", "()Lcom/android/tools/utp/plugins/host/emulatorcontrol/JwtConfig;", "createTokenConfig", "aud", "", "", "validForSeconds", "", "iss", "info", "Lcom/android/tools/utp/plugins/host/emulatorcontrol/EmulatorGrpcInfo;", "createJwtConfig", "jwkDirectory", "android-test-plugin-host-emulator-control"})
@SourceDebugExtension(value={"SMAP\nEmulatorControlUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 EmulatorControlUtils.kt\ncom/android/tools/utp/plugins/host/emulatorcontrol/EmulatorControlUtilsKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,90:1\n1#2:91\n*E\n"})
public final class EmulatorControlUtilsKt {
    private static final Logger LOG = Logger.getLogger("EmulatorAccessUtils");
    @NotNull
    private static final JwtConfig INVALID_JWT_CONFIG = new JwtConfig("", "");

    @NotNull
    public static final JwtConfig getINVALID_JWT_CONFIG() {
        return INVALID_JWT_CONFIG;
    }

    @NotNull
    public static final JwtConfig createTokenConfig(@NotNull Set<String> aud, int validForSeconds, @NotNull String iss, @Nullable EmulatorGrpcInfo info) {
        Intrinsics.checkNotNullParameter(aud, (String)"aud");
        Intrinsics.checkNotNullParameter((Object)iss, (String)"iss");
        if (info == null) {
            return INVALID_JWT_CONFIG;
        }
        CharSequence charSequence = info.getJwks();
        if (charSequence == null || charSequence.length() == 0 || (charSequence = (CharSequence)info.getAllowlist()) == null || charSequence.length() == 0) {
            LOG.severe("This emulator is not protected with an allowlist, or jwt enabled");
            return INVALID_JWT_CONFIG;
        }
        return EmulatorControlUtilsKt.createJwtConfig(aud, validForSeconds, iss, info.getJwks());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public static final JwtConfig createJwtConfig(@NotNull Set<String> aud, int validForSeconds, @NotNull String iss, @Nullable String jwkDirectory) {
        Intrinsics.checkNotNullParameter(aud, (String)"aud");
        Intrinsics.checkNotNullParameter((Object)iss, (String)"iss");
        CharSequence charSequence = jwkDirectory;
        if (charSequence == null || charSequence.length() == 0) {
            return INVALID_JWT_CONFIG;
        }
        JwtSignatureConfig.register();
        KeyTemplate tinkTemplate = KeyTemplates.get((String)"JWT_ES512");
        KeysetHandle handle = KeysetHandle.generateNew((KeyTemplate)tinkTemplate);
        String jwkOutputFile = jwkDirectory + File.separator + handle.getPrimary().getId() + ".jwk";
        String jwk = JwkSetConverter.fromPublicKeysetHandle((KeysetHandle)handle.getPublicKeysetHandle());
        LOG.fine("Writing jwk: " + jwk + " to: " + jwkOutputFile);
        Object object = new File(jwkOutputFile);
        Object object2 = Charsets.UTF_8;
        int n = 8192;
        Object object3 = object;
        object3 = new OutputStreamWriter((OutputStream)new FileOutputStream((File)object3), (Charset)object2);
        object = object3 instanceof BufferedWriter ? (BufferedWriter)object3 : new BufferedWriter((Writer)object3, n);
        object2 = null;
        try {
            BufferedWriter out = (BufferedWriter)object;
            boolean bl = false;
            out.write(jwk);
            out = Unit.INSTANCE;
        }
        catch (Throwable bl) {
            object2 = bl;
            throw bl;
        }
        finally {
            CloseableKt.closeFinally((Closeable)object, (Throwable)object2);
        }
        Instant now = Instant.now();
        RawJwt.Builder claimSet = RawJwt.newBuilder().setIssuer(iss).setExpiration(now.plusSeconds(validForSeconds)).setNotBefore(now).setIssuedAt(now).setJwtId(UUID.randomUUID().toString());
        if (!((Collection)aud).isEmpty()) {
            claimSet.setAudiences(CollectionsKt.toList((Iterable)aud));
        }
        RawJwt rawJwt = claimSet.build();
        JwtPublicKeySign signer = (JwtPublicKeySign)handle.getPrimitive(JwtPublicKeySign.class);
        String signedJwt = signer.signAndEncode(rawJwt);
        LOG.fine("Signing claims: " + rawJwt + " with jwk: " + handle.getPrimary().getId());
        Intrinsics.checkNotNull((Object)signedJwt);
        return new JwtConfig(signedJwt, jwkOutputFile);
    }
}

