/*
 * Decompiled with CFR 0.152.
 */
package com.anggrayudi.storage.extension;

import android.content.Context;
import android.net.Uri;
import androidx.annotation.WorkerThread;
import androidx.documentfile.provider.DocumentFile;
import com.anggrayudi.storage.file.DocumentFileCompat;
import com.anggrayudi.storage.file.FileUtils;
import com.anggrayudi.storage.media.MediaFile;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import kotlin.Metadata;
import kotlin.jvm.JvmName;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=2, xi=48, d1={"\u00004\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\u0012\u0010\t\u001a\u00020\n*\u00020\u00022\u0006\u0010\u000b\u001a\u00020\f\u001a\u0016\u0010\r\u001a\u0004\u0018\u00010\u000e*\u00020\u00022\u0006\u0010\u000b\u001a\u00020\fH\u0007\u001a \u0010\u000f\u001a\u0004\u0018\u00010\u0010*\u00020\u00022\u0006\u0010\u000b\u001a\u00020\f2\b\b\u0002\u0010\u0011\u001a\u00020\u0001H\u0007\u001a\u0014\u0010\u0012\u001a\u0004\u0018\u00010\u0013*\u00020\u00022\u0006\u0010\u000b\u001a\u00020\f\u001a\u0014\u0010\u0014\u001a\u0004\u0018\u00010\u0015*\u00020\u00022\u0006\u0010\u000b\u001a\u00020\f\"\u0015\u0010\u0000\u001a\u00020\u0001*\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b\u0000\u0010\u0003\"\u0015\u0010\u0004\u001a\u00020\u0001*\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b\u0004\u0010\u0003\"\u0015\u0010\u0005\u001a\u00020\u0001*\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0003\"\u0015\u0010\u0006\u001a\u00020\u0001*\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0003\"\u0015\u0010\u0007\u001a\u00020\u0001*\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\u0003\"\u0015\u0010\b\u001a\u00020\u0001*\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\u0003\u00a8\u0006\u0016"}, d2={"isDownloadsDocument", "", "Landroid/net/Uri;", "(Landroid/net/Uri;)Z", "isExternalStorageDocument", "isMediaDocument", "isMediaFile", "isRawFile", "isTreeDocumentFile", "getStorageId", "", "context", "Landroid/content/Context;", "openInputStream", "Ljava/io/InputStream;", "openOutputStream", "Ljava/io/OutputStream;", "append", "toDocumentFile", "Landroidx/documentfile/provider/DocumentFile;", "toMediaFile", "Lcom/anggrayudi/storage/media/MediaFile;", "storage_release"})
@JvmName(name="UriUtils")
public final class UriUtils {
    @NotNull
    public static final String getStorageId(@NotNull Uri $this$getStorageId, @NotNull Context context) {
        String path;
        Intrinsics.checkNotNullParameter((Object)$this$getStorageId, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        String string2 = $this$getStorageId.getPath();
        if (string2 == null) {
            string2 = path = "";
        }
        return UriUtils.isRawFile($this$getStorageId) ? FileUtils.getStorageId(new File(path), context) : (UriUtils.isExternalStorageDocument($this$getStorageId) ? StringsKt.substringAfterLast$default((String)StringsKt.substringBefore((String)path, (char)':', (String)""), (char)'/', null, (int)2, null) : (UriUtils.isDownloadsDocument($this$getStorageId) ? "primary" : ""));
    }

    public static final boolean isTreeDocumentFile(@NotNull Uri $this$isTreeDocumentFile) {
        Intrinsics.checkNotNullParameter((Object)$this$isTreeDocumentFile, (String)"<this>");
        String string2 = $this$isTreeDocumentFile.getPath();
        return string2 == null ? false : StringsKt.startsWith$default((String)string2, (String)"/tree/", (boolean)false, (int)2, null);
    }

    public static final boolean isExternalStorageDocument(@NotNull Uri $this$isExternalStorageDocument) {
        Intrinsics.checkNotNullParameter((Object)$this$isExternalStorageDocument, (String)"<this>");
        return Intrinsics.areEqual((Object)$this$isExternalStorageDocument.getAuthority(), (Object)"com.android.externalstorage.documents");
    }

    public static final boolean isDownloadsDocument(@NotNull Uri $this$isDownloadsDocument) {
        Intrinsics.checkNotNullParameter((Object)$this$isDownloadsDocument, (String)"<this>");
        return Intrinsics.areEqual((Object)$this$isDownloadsDocument.getAuthority(), (Object)"com.android.providers.downloads.documents");
    }

    public static final boolean isMediaDocument(@NotNull Uri $this$isMediaDocument) {
        Intrinsics.checkNotNullParameter((Object)$this$isMediaDocument, (String)"<this>");
        return Intrinsics.areEqual((Object)$this$isMediaDocument.getAuthority(), (Object)"com.android.providers.media.documents");
    }

    public static final boolean isRawFile(@NotNull Uri $this$isRawFile) {
        Intrinsics.checkNotNullParameter((Object)$this$isRawFile, (String)"<this>");
        return Intrinsics.areEqual((Object)$this$isRawFile.getScheme(), (Object)"file");
    }

    public static final boolean isMediaFile(@NotNull Uri $this$isMediaFile) {
        Intrinsics.checkNotNullParameter((Object)$this$isMediaFile, (String)"<this>");
        return Intrinsics.areEqual((Object)$this$isMediaFile.getAuthority(), (Object)"media");
    }

    @Nullable
    public static final MediaFile toMediaFile(@NotNull Uri $this$toMediaFile, @NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)$this$toMediaFile, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        return UriUtils.isMediaFile($this$toMediaFile) ? new MediaFile(context, $this$toMediaFile) : null;
    }

    @Nullable
    public static final DocumentFile toDocumentFile(@NotNull Uri $this$toDocumentFile, @NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)$this$toDocumentFile, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        return DocumentFileCompat.fromUri(context, $this$toDocumentFile);
    }

    @JvmOverloads
    @WorkerThread
    @Nullable
    public static final OutputStream openOutputStream(@NotNull Uri $this$openOutputStream, @NotNull Context context, boolean append) {
        OutputStream outputStream;
        Intrinsics.checkNotNullParameter((Object)$this$openOutputStream, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        try {
            OutputStream outputStream2;
            if (UriUtils.isRawFile($this$openOutputStream)) {
                String string2 = $this$openOutputStream.getPath();
                if (string2 == null) {
                    return null;
                }
                outputStream2 = new FileOutputStream(new File(string2), append);
            } else {
                outputStream2 = context.getContentResolver().openOutputStream($this$openOutputStream, append && UriUtils.isTreeDocumentFile($this$openOutputStream) ? "wa" : "w");
            }
            outputStream = outputStream2;
        }
        catch (IOException e) {
            outputStream = null;
        }
        return outputStream;
    }

    public static /* synthetic */ OutputStream openOutputStream$default(Uri uri, Context context, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = true;
        }
        return UriUtils.openOutputStream(uri, context, bl);
    }

    @WorkerThread
    @Nullable
    public static final InputStream openInputStream(@NotNull Uri $this$openInputStream, @NotNull Context context) {
        InputStream inputStream;
        Intrinsics.checkNotNullParameter((Object)$this$openInputStream, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        try {
            InputStream inputStream2;
            if (UriUtils.isRawFile($this$openInputStream)) {
                String string2 = $this$openInputStream.getPath();
                if (string2 == null) {
                    return null;
                }
                inputStream2 = new FileInputStream(new File(string2));
            } else {
                inputStream2 = context.getContentResolver().openInputStream($this$openInputStream);
            }
            inputStream = inputStream2;
        }
        catch (IOException e) {
            inputStream = null;
        }
        return inputStream;
    }

    @JvmOverloads
    @WorkerThread
    @Nullable
    public static final OutputStream openOutputStream(@NotNull Uri $this$openOutputStream, @NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)$this$openOutputStream, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        return UriUtils.openOutputStream$default($this$openOutputStream, context, false, 2, null);
    }
}

