/*
 * Decompiled with CFR 0.152.
 */
package com.anggrayudi.storage.file;

import android.content.ContentResolver;
import android.content.Context;
import android.content.UriPermission;
import android.net.Uri;
import android.os.Build;
import android.os.Environment;
import android.os.ParcelFileDescriptor;
import android.os.StatFs;
import android.system.Os;
import android.system.StructStatVfs;
import androidx.annotation.WorkerThread;
import androidx.core.content.ContextCompat;
import androidx.documentfile.provider.DocumentFile;
import com.anggrayudi.storage.SimpleStorage;
import com.anggrayudi.storage.extension.ContextUtils;
import com.anggrayudi.storage.extension.TextUtils;
import com.anggrayudi.storage.extension.UriUtils;
import com.anggrayudi.storage.file.DocumentFileType;
import com.anggrayudi.storage.file.DocumentFileUtils;
import com.anggrayudi.storage.file.FileUtils;
import com.anggrayudi.storage.file.PublicDirectory;
import com.anggrayudi.storage.media.FileDescription;
import com.anggrayudi.storage.media.MediaFile;
import com.anggrayudi.storage.media.MediaStoreCompat;
import java.io.Closeable;
import java.io.File;
import java.io.FileDescriptor;
import java.io.IOException;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IntIterator;
import kotlin.io.CloseableKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000t\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0010\u001e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u000e\n\u0002\u0010\t\n\u0002\b\r\n\u0002\u0010\u0011\n\u0002\b\u0006\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u000e\u001a\u00020\u00042\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0004H\u0007J \u0010\u000e\u001a\u00020\u00042\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0012\u001a\u00020\u00042\u0006\u0010\u0013\u001a\u00020\u0004H\u0007J\u0018\u0010\u0014\u001a\u00020\u00042\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0015\u001a\u00020\u0004H\u0007J\u0018\u0010\u0014\u001a\u00020\u00042\u0006\u0010\u0012\u001a\u00020\u00042\u0006\u0010\u0013\u001a\u00020\u0004H\u0007J\u0010\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019H\u0002J\u001a\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u0012\u001a\u00020\u00042\b\b\u0002\u0010\u0013\u001a\u00020\u0004H\u0007J\u001a\u0010\u001c\u001a\u0004\u0018\u00010\u001b2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0018\u001a\u00020\u001dH\u0007J8\u0010\u001e\u001a\u0004\u0018\u00010\u001f2\u0006\u0010\u000f\u001a\u00020\u00102\b\b\u0002\u0010\u0012\u001a\u00020\u00042\u0006\u0010\u0013\u001a\u00020\u00042\b\b\u0002\u0010 \u001a\u00020\u00042\b\b\u0002\u0010!\u001a\u00020\u0017H\u0007J\u001a\u0010\"\u001a\u0004\u0018\u00010\u001b2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0018\u001a\u00020\u001dH\u0007J\u0018\u0010#\u001a\u00020\u00172\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010$\u001a\u00020\u0004H\u0007J\u0018\u0010%\u001a\u00020\u00172\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010$\u001a\u00020\u0004H\u0007J:\u0010&\u001a\u0004\u0018\u00010\u001f2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0012\u001a\u00020\u00042\u0006\u0010\u0013\u001a\u00020\u00042\u0006\u0010'\u001a\u00020(2\u0006\u0010)\u001a\u00020\u00172\u0006\u0010!\u001a\u00020\u0017H\u0002J$\u0010*\u001a\b\u0012\u0004\u0012\u00020\u00040+2\u0006\u0010\u000f\u001a\u00020\u00102\f\u0010,\u001a\b\u0012\u0004\u0012\u00020\u00040+H\u0007J$\u0010-\u001a\b\u0012\u0004\u0012\u00020\u00040+2\u0006\u0010\u000f\u001a\u00020\u00102\f\u0010.\u001a\b\u0012\u0004\u0012\u00020\u00040/H\u0007J$\u00100\u001a\b\u0012\u0004\u0012\u00020\u00040+2\u0006\u0010\u000f\u001a\u00020\u00102\f\u0010.\u001a\b\u0012\u0004\u0012\u00020\u00040/H\u0007J8\u00101\u001a\u0004\u0018\u00010\u001f2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0018\u001a\u00020\u00192\b\b\u0002\u0010'\u001a\u00020(2\b\b\u0002\u0010)\u001a\u00020\u00172\b\b\u0002\u0010!\u001a\u00020\u0017H\u0007J8\u00102\u001a\u0004\u0018\u00010\u001f2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010$\u001a\u00020\u00042\b\b\u0002\u0010'\u001a\u00020(2\b\b\u0002\u0010)\u001a\u00020\u00172\b\b\u0002\u0010!\u001a\u00020\u0017H\u0007J8\u00103\u001a\u0004\u0018\u00010\u001f2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u00104\u001a\u0002052\b\b\u0002\u00106\u001a\u00020\u00042\b\b\u0002\u0010)\u001a\u00020\u00172\b\b\u0002\u0010!\u001a\u00020\u0017H\u0007JD\u00107\u001a\u0004\u0018\u00010\u001f2\u0006\u0010\u000f\u001a\u00020\u00102\b\b\u0002\u0010\u0012\u001a\u00020\u00042\b\b\u0002\u0010\u0013\u001a\u00020\u00042\b\b\u0002\u0010'\u001a\u00020(2\b\b\u0002\u0010)\u001a\u00020\u00172\b\b\u0002\u0010!\u001a\u00020\u0017H\u0007J\u001a\u00108\u001a\u0004\u0018\u00010\u001f2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u00109\u001a\u00020\u001bH\u0007J.\u0010:\u001a\u0004\u0018\u00010\u001f2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010$\u001a\u00020\u00042\b\b\u0002\u0010)\u001a\u00020\u00172\b\b\u0002\u0010!\u001a\u00020\u0017H\u0007J\u0018\u0010;\u001a\u00020\u00042\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010$\u001a\u00020\u0004H\u0007J\u001b\u0010<\u001a\b\u0012\u0004\u0012\u00020\u00040+2\u0006\u0010=\u001a\u00020\u0004H\u0000\u00a2\u0006\u0002\b>J\u001a\u0010?\u001a\u0004\u0018\u00010\u001f2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0012\u001a\u00020\u0004H\u0002J\u0010\u0010@\u001a\u00020\u00042\u0006\u0010=\u001a\u00020\u0004H\u0002J\u0010\u0010A\u001a\u00020\u00042\u0006\u0010B\u001a\u00020\u0004H\u0007J\u0018\u0010C\u001a\u00020D2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0012\u001a\u00020\u0004H\u0007J\u0012\u0010E\u001a\u0004\u0018\u00010\u00042\u0006\u0010=\u001a\u00020\u0004H\u0002J.\u0010F\u001a\u0004\u0018\u00010\u001f2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0012\u001a\u00020\u00042\b\b\u0002\u0010)\u001a\u00020\u00172\b\b\u0002\u0010!\u001a\u00020\u0017H\u0007J$\u0010G\u001a\u0004\u0018\u00010\u00192\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0012\u001a\u00020\u00042\b\b\u0002\u0010)\u001a\u00020\u0017H\u0007J\u0016\u0010H\u001a\b\u0012\u0004\u0012\u00020\u00040+2\u0006\u0010\u000f\u001a\u00020\u0010H\u0007J\u0018\u0010I\u001a\u00020D2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0012\u001a\u00020\u0004H\u0007J\u0018\u0010J\u001a\u00020\u00042\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010$\u001a\u00020\u0004H\u0007J\u0016\u0010K\u001a\b\u0012\u0004\u0012\u00020\u00040+2\u0006\u0010\u000f\u001a\u00020\u0010H\u0007J\u0018\u0010L\u001a\u00020D2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0012\u001a\u00020\u0004H\u0007J\u0018\u0010M\u001a\u00020\u00172\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0012\u001a\u00020\u0004H\u0007J\u0010\u0010N\u001a\u00020\u00172\u0006\u0010\u000f\u001a\u00020\u0010H\u0007J\u0010\u0010O\u001a\u00020\u00172\u0006\u00109\u001a\u00020\u001bH\u0007J\"\u0010P\u001a\u00020\u00172\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0012\u001a\u00020\u00042\b\b\u0002\u0010\u0013\u001a\u00020\u0004H\u0007J.\u0010Q\u001a\u0004\u0018\u00010\u001f2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010$\u001a\u00020\u00042\b\b\u0002\u0010)\u001a\u00020\u00172\b\b\u0002\u0010!\u001a\u00020\u0017H\u0007J?\u0010Q\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u001f0R2\u0006\u0010\u000f\u001a\u00020\u00102\f\u0010,\u001a\b\u0012\u0004\u0012\u00020\u00040+2\b\b\u0002\u0010)\u001a\u00020\u00172\b\b\u0002\u0010!\u001a\u00020\u0017H\u0007\u00a2\u0006\u0002\u0010SJ*\u0010T\u001a\u0004\u0018\u00010\u001f2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0012\u001a\u00020\u00042\u0006\u0010\u0013\u001a\u00020\u00042\u0006\u0010!\u001a\u00020\u0017H\u0002J8\u0010U\u001a\u0004\u0018\u00010\u001f2\u0006\u0010\u000f\u001a\u00020\u00102\b\b\u0002\u0010\u0012\u001a\u00020\u00042\u0006\u0010\u0013\u001a\u00020\u00042\b\b\u0002\u0010 \u001a\u00020\u00042\b\b\u0002\u0010!\u001a\u00020\u0017H\u0007J\u0011\u0010V\u001a\u00020\u0004*\u00020\u0004H\u0000\u00a2\u0006\u0002\bWR\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u000b\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\nR\u000e\u0010\r\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006X"}, d2={"Lcom/anggrayudi/storage/file/DocumentFileCompat;", "", "()V", "DOWNLOADS_FOLDER_AUTHORITY", "", "DOWNLOADS_TREE_URI", "EXTERNAL_STORAGE_AUTHORITY", "FILE_NAME_DUPLICATION_REGEX_WITHOUT_EXTENSION", "Lkotlin/text/Regex;", "getFILE_NAME_DUPLICATION_REGEX_WITHOUT_EXTENSION", "()Lkotlin/text/Regex;", "FILE_NAME_DUPLICATION_REGEX_WITH_EXTENSION", "getFILE_NAME_DUPLICATION_REGEX_WITH_EXTENSION", "MEDIA_FOLDER_AUTHORITY", "buildAbsolutePath", "context", "Landroid/content/Context;", "simplePath", "storageId", "basePath", "buildSimplePath", "absolutePath", "create", "", "file", "Ljava/io/File;", "createDocumentUri", "Landroid/net/Uri;", "createDownloadWithMediaStoreFallback", "Lcom/anggrayudi/storage/media/FileDescription;", "createFile", "Landroidx/documentfile/provider/DocumentFile;", "mimeType", "considerRawFile", "createPictureWithMediaStoreFallback", "delete", "fullPath", "doesExist", "exploreFile", "documentType", "Lcom/anggrayudi/storage/file/DocumentFileType;", "requiresWriteAccess", "findInaccessibleStorageLocations", "", "fullPaths", "findUniqueDeepestSubFolders", "folderFullPaths", "", "findUniqueParents", "fromFile", "fromFullPath", "fromPublicFolder", "type", "Lcom/anggrayudi/storage/file/PublicDirectory;", "subFile", "fromSimplePath", "fromUri", "uri", "getAccessibleRootDocumentFile", "getBasePath", "getDirectorySequence", "path", "getDirectorySequence$storage_release", "getDocumentFileForStorageInfo", "getFileNameFromPath", "getFileNameFromUrl", "url", "getFreeSpace", "", "getParentPath", "getRootDocumentFile", "getRootRawFile", "getSdCardIds", "getStorageCapacity", "getStorageId", "getStorageIds", "getUsedSpace", "isAccessGranted", "isDownloadsUriPermissionGranted", "isRootUri", "isStorageUriPermissionGranted", "mkdirs", "", "(Landroid/content/Context;Ljava/util/List;ZZ)[Landroidx/documentfile/provider/DocumentFile;", "mkdirsParentDirectory", "recreate", "removeForbiddenCharsFromFilename", "removeForbiddenCharsFromFilename$storage_release", "storage_release"})
public final class DocumentFileCompat {
    @NotNull
    public static final DocumentFileCompat INSTANCE = new DocumentFileCompat();
    @NotNull
    public static final String EXTERNAL_STORAGE_AUTHORITY = "com.android.externalstorage.documents";
    @NotNull
    public static final String DOWNLOADS_FOLDER_AUTHORITY = "com.android.providers.downloads.documents";
    @NotNull
    public static final String MEDIA_FOLDER_AUTHORITY = "com.android.providers.media.documents";
    @NotNull
    public static final String DOWNLOADS_TREE_URI = "content://com.android.providers.downloads.documents/tree/downloads";
    @NotNull
    private static final Regex FILE_NAME_DUPLICATION_REGEX_WITH_EXTENSION = new Regex("(.*?) \\(\\d+\\)\\.[a-zA-Z0-9]+");
    @NotNull
    private static final Regex FILE_NAME_DUPLICATION_REGEX_WITHOUT_EXTENSION = new Regex("(.*?) \\(\\d+\\)");

    private DocumentFileCompat() {
    }

    @NotNull
    public final Regex getFILE_NAME_DUPLICATION_REGEX_WITH_EXTENSION() {
        return FILE_NAME_DUPLICATION_REGEX_WITH_EXTENSION;
    }

    @NotNull
    public final Regex getFILE_NAME_DUPLICATION_REGEX_WITHOUT_EXTENSION() {
        return FILE_NAME_DUPLICATION_REGEX_WITHOUT_EXTENSION;
    }

    @JvmStatic
    public static final boolean isRootUri(@NotNull Uri uri) {
        Intrinsics.checkNotNullParameter((Object)uri, (String)"uri");
        String string2 = uri.getPath();
        if (string2 == null) {
            return false;
        }
        String path = string2;
        return UriUtils.isExternalStorageDocument(uri) && StringsKt.indexOf$default((CharSequence)path, (char)':', (int)0, (boolean)false, (int)6, null) == path.length() - 1;
    }

    @JvmStatic
    @NotNull
    public static final String getStorageId(@NotNull Context context, @NotNull String fullPath) {
        String string2;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)fullPath, (String)"fullPath");
        if (StringsKt.startsWith$default((CharSequence)fullPath, (char)'/', (boolean)false, (int)2, null)) {
            if (StringsKt.startsWith$default((String)fullPath, (String)SimpleStorage.Companion.getExternalStoragePath(), (boolean)false, (int)2, null)) {
                string2 = "primary";
            } else {
                String string3 = FileUtils.getDataDirectory(context).getPath();
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"context.dataDirectory.path");
                string2 = StringsKt.startsWith$default((String)fullPath, (String)string3, (boolean)false, (int)2, null) ? "data" : StringsKt.substringBefore$default((String)StringsKt.substringAfter((String)fullPath, (String)"/storage/", (String)""), (char)'/', null, (int)2, null);
            }
        } else {
            string2 = StringsKt.substringAfterLast$default((String)StringsKt.substringBefore((String)fullPath, (char)':', (String)""), (char)'/', null, (int)2, null);
        }
        return string2;
    }

    @JvmStatic
    @NotNull
    public static final String getBasePath(@NotNull Context context, @NotNull String fullPath) {
        String string2;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)fullPath, (String)"fullPath");
        if (StringsKt.startsWith$default((CharSequence)fullPath, (char)'/', (boolean)false, (int)2, null)) {
            String dataDir = FileUtils.getDataDirectory(context).getPath();
            String externalStoragePath = SimpleStorage.Companion.getExternalStoragePath();
            if (StringsKt.startsWith$default((String)fullPath, (String)externalStoragePath, (boolean)false, (int)2, null)) {
                string2 = StringsKt.substringAfter$default((String)fullPath, (String)externalStoragePath, null, (int)2, null);
            } else {
                Intrinsics.checkNotNullExpressionValue((Object)dataDir, (String)"dataDir");
                string2 = StringsKt.startsWith$default((String)fullPath, (String)dataDir, (boolean)false, (int)2, null) ? StringsKt.substringAfter$default((String)fullPath, (String)dataDir, null, (int)2, null) : StringsKt.substringAfter((String)StringsKt.substringAfter((String)fullPath, (String)"/storage/", (String)""), (char)'/', (String)"");
            }
        } else {
            string2 = StringsKt.substringAfter((String)fullPath, (char)':', (String)"");
        }
        String basePath = string2;
        return INSTANCE.removeForbiddenCharsFromFilename$storage_release(TextUtils.trimFileSeparator(basePath));
    }

    /*
     * WARNING - void declaration
     */
    @JvmStatic
    @Nullable
    public static final DocumentFile fromUri(@NotNull Context context, @NotNull Uri uri) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)uri, (String)"uri");
        if (UriUtils.isRawFile(uri)) {
            String string2 = uri.getPath();
            if (string2 == null) {
                return null;
            }
            File $this$fromUri_u24lambda_u2d0 = new File(string2);
            boolean bl = false;
            object = $this$fromUri_u24lambda_u2d0.canRead() ? DocumentFile.fromFile((File)$this$fromUri_u24lambda_u2d0) : null;
        } else if (UriUtils.isTreeDocumentFile(uri)) {
            DocumentFile documentFile = ContextUtils.fromTreeUri(context, uri);
            if (documentFile == null) {
                object = null;
            } else {
                void var3_4;
                DocumentFile $this$fromUri_u24lambda_u2d1 = documentFile;
                boolean bl = false;
                object = DocumentFileUtils.isDownloadsDocument($this$fromUri_u24lambda_u2d1) ? DocumentFileUtils.toWritableDownloadsDocumentFile($this$fromUri_u24lambda_u2d1, context) : var3_4;
            }
        } else {
            object = ContextUtils.fromSingleUri(context, uri);
        }
        return object;
    }

    /*
     * Enabled aggressive block sorting
     */
    @JvmStatic
    @JvmOverloads
    @Nullable
    public static final DocumentFile fromSimplePath(@NotNull Context context, @NotNull String storageId, @NotNull String basePath, @NotNull DocumentFileType documentType, boolean requiresWriteAccess, boolean considerRawFile) {
        DocumentFile documentFile;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)storageId, (String)"storageId");
        Intrinsics.checkNotNullParameter((Object)basePath, (String)"basePath");
        Intrinsics.checkNotNullParameter((Object)((Object)documentType), (String)"documentType");
        if (Intrinsics.areEqual((Object)storageId, (Object)"data")) {
            return DocumentFile.fromFile((File)FileUtils.child(FileUtils.getDataDirectory(context), basePath));
        }
        if (((CharSequence)basePath).length() == 0) {
            documentFile = DocumentFileCompat.getRootDocumentFile(context, storageId, requiresWriteAccess, considerRawFile);
            return documentFile;
        }
        DocumentFile file = INSTANCE.exploreFile(context, storageId, basePath, documentType, requiresWriteAccess, considerRawFile);
        if (file == null) {
            String string2 = Environment.DIRECTORY_DOWNLOADS;
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"DIRECTORY_DOWNLOADS");
            if (StringsKt.startsWith$default((String)basePath, (String)string2, (boolean)false, (int)2, null) && Intrinsics.areEqual((Object)storageId, (Object)"primary")) {
                DocumentFile documentFile2;
                Uri uri = Uri.parse((String)DOWNLOADS_TREE_URI);
                Intrinsics.checkNotNullExpressionValue((Object)uri, (String)"parse(DOWNLOADS_TREE_URI)");
                DocumentFile documentFile3 = ContextUtils.fromTreeUri(context, uri);
                if (documentFile3 == null) {
                    return null;
                }
                Uri it = uri = documentFile3;
                boolean bl = false;
                if (!it.canRead()) return null;
                Uri uri2 = uri;
                if (uri2 == null) {
                    return null;
                }
                Uri downloads = uri2;
                DocumentFile documentFile4 = DocumentFileUtils.child$default((DocumentFile)downloads, context, StringsKt.substringAfter((String)basePath, (char)'/', (String)""), false, 4, null);
                if (documentFile4 == null) {
                    return null;
                }
                DocumentFile it2 = documentFile2 = documentFile4;
                boolean bl2 = false;
                if (!(documentType == DocumentFileType.ANY || documentType == DocumentFileType.FILE && it2.isFile())) {
                    if (documentType != DocumentFileType.FOLDER) return null;
                    if (!it2.isDirectory()) return null;
                }
                boolean bl3 = true;
                if (!bl3) return null;
                documentFile = documentFile2;
                return documentFile;
            }
        }
        documentFile = file;
        return documentFile;
    }

    public static /* synthetic */ DocumentFile fromSimplePath$default(Context context, String string2, String string3, DocumentFileType documentFileType, boolean bl, boolean bl2, int n, Object object) {
        if ((n & 2) != 0) {
            string2 = "primary";
        }
        if ((n & 4) != 0) {
            string3 = "";
        }
        if ((n & 8) != 0) {
            documentFileType = DocumentFileType.ANY;
        }
        if ((n & 0x10) != 0) {
            bl = false;
        }
        if ((n & 0x20) != 0) {
            bl2 = true;
        }
        return DocumentFileCompat.fromSimplePath(context, string2, string3, documentFileType, bl, bl2);
    }

    @JvmStatic
    @JvmOverloads
    @Nullable
    public static final DocumentFile fromFullPath(@NotNull Context context, @NotNull String fullPath, @NotNull DocumentFileType documentType, boolean requiresWriteAccess, boolean considerRawFile) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)fullPath, (String)"fullPath");
        Intrinsics.checkNotNullParameter((Object)((Object)documentType), (String)"documentType");
        return StringsKt.startsWith$default((CharSequence)fullPath, (char)'/', (boolean)false, (int)2, null) ? DocumentFileCompat.fromFile(context, new File(fullPath), documentType, requiresWriteAccess, considerRawFile) : DocumentFileCompat.fromSimplePath(context, StringsKt.substringBefore$default((String)fullPath, (char)':', null, (int)2, null), StringsKt.substringAfter$default((String)fullPath, (char)':', null, (int)2, null), documentType, requiresWriteAccess, considerRawFile);
    }

    public static /* synthetic */ DocumentFile fromFullPath$default(Context context, String string2, DocumentFileType documentFileType, boolean bl, boolean bl2, int n, Object object) {
        if ((n & 4) != 0) {
            documentFileType = DocumentFileType.ANY;
        }
        if ((n & 8) != 0) {
            bl = false;
        }
        if ((n & 0x10) != 0) {
            bl2 = true;
        }
        return DocumentFileCompat.fromFullPath(context, string2, documentFileType, bl, bl2);
    }

    @JvmStatic
    @JvmOverloads
    @Nullable
    public static final DocumentFile fromFile(@NotNull Context context, @NotNull File file, @NotNull DocumentFileType documentType, boolean requiresWriteAccess, boolean considerRawFile) {
        DocumentFile documentFile;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)((Object)documentType), (String)"documentType");
        if (FileUtils.checkRequirements(file, context, requiresWriteAccess, considerRawFile)) {
            documentFile = documentType == DocumentFileType.FILE && !file.isFile() || documentType == DocumentFileType.FOLDER && !file.isDirectory() ? null : DocumentFile.fromFile((File)file);
        } else {
            String basePath = TextUtils.trimFileSeparator(INSTANCE.removeForbiddenCharsFromFilename$storage_release(FileUtils.getBasePath(file, context)));
            DocumentFile documentFile2 = INSTANCE.exploreFile(context, FileUtils.getStorageId(file, context), basePath, documentType, requiresWriteAccess, considerRawFile);
            documentFile = documentFile2 == null ? DocumentFileCompat.fromSimplePath(context, FileUtils.getStorageId(file, context), basePath, documentType, requiresWriteAccess, considerRawFile) : documentFile2;
        }
        return documentFile;
    }

    public static /* synthetic */ DocumentFile fromFile$default(Context context, File file, DocumentFileType documentFileType, boolean bl, boolean bl2, int n, Object object) {
        if ((n & 4) != 0) {
            documentFileType = DocumentFileType.ANY;
        }
        if ((n & 8) != 0) {
            bl = false;
        }
        if ((n & 0x10) != 0) {
            bl2 = true;
        }
        return DocumentFileCompat.fromFile(context, file, documentFileType, bl, bl2);
    }

    @JvmStatic
    @JvmOverloads
    @Nullable
    public static final DocumentFile fromPublicFolder(@NotNull Context context, @NotNull PublicDirectory type, @NotNull String subFile, boolean requiresWriteAccess, boolean considerRawFile) {
        Object object;
        DocumentFile folder;
        DocumentFile documentFile;
        Object object2;
        Object object3;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
        Intrinsics.checkNotNullParameter((Object)subFile, (String)"subFile");
        File rawFile = Environment.getExternalStoragePublicDirectory((String)type.getFolderName());
        if (((CharSequence)subFile).length() > 0) {
            object3 = new char[1];
            object3[0] = 47;
            rawFile = new File(StringsKt.trimEnd((String)(rawFile + '/' + subFile), (char[])object3));
        }
        object3 = rawFile;
        Intrinsics.checkNotNullExpressionValue((Object)object3, (String)"rawFile");
        if (FileUtils.checkRequirements((File)object3, context, requiresWriteAccess, considerRawFile)) {
            return DocumentFile.fromFile((File)rawFile);
        }
        if (type == PublicDirectory.DOWNLOADS) {
            DocumentFile downloadFolder;
            object2 = Uri.parse((String)DOWNLOADS_TREE_URI);
            Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"parse(DOWNLOADS_TREE_URI)");
            DocumentFile documentFile2 = downloadFolder = ContextUtils.fromTreeUri(context, object2);
            if (documentFile2 == null ? false : documentFile2.canRead()) {
                documentFile = DocumentFileUtils.child(downloadFolder, context, subFile, requiresWriteAccess);
            } else {
                object2 = rawFile.getAbsolutePath();
                Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"rawFile.absolutePath");
                documentFile = DocumentFileCompat.fromFullPath$default(context, (String)object2, null, false, false, 12, null);
            }
        } else {
            String string2 = rawFile.getAbsolutePath();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"rawFile.absolutePath");
            documentFile = DocumentFileCompat.fromFullPath$default(context, string2, null, false, false, 12, null);
        }
        DocumentFile documentFile3 = folder = documentFile;
        if (documentFile3 == null) {
            object = null;
        } else {
            Uri it = object2 = documentFile3;
            boolean bl = false;
            object = it.canRead() && (requiresWriteAccess && DocumentFileUtils.isWritable(folder, context) || !requiresWriteAccess) ? object2 : null;
        }
        return object;
    }

    public static /* synthetic */ DocumentFile fromPublicFolder$default(Context context, PublicDirectory publicDirectory, String string2, boolean bl, boolean bl2, int n, Object object) {
        if ((n & 4) != 0) {
            string2 = "";
        }
        if ((n & 8) != 0) {
            bl = false;
        }
        if ((n & 0x10) != 0) {
            bl2 = true;
        }
        return DocumentFileCompat.fromPublicFolder(context, publicDirectory, string2, bl, bl2);
    }

    @JvmStatic
    @JvmOverloads
    @Nullable
    public static final DocumentFile getRootDocumentFile(@NotNull Context context, @NotNull String storageId, boolean requiresWriteAccess, boolean considerRawFile) {
        Object object;
        DocumentFile file;
        DocumentFile documentFile;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)storageId, (String)"storageId");
        if (Intrinsics.areEqual((Object)storageId, (Object)"data")) {
            return DocumentFile.fromFile((File)FileUtils.getDataDirectory(context));
        }
        if (considerRawFile) {
            DocumentFile documentFile2;
            File file2 = DocumentFileCompat.getRootRawFile(context, storageId, requiresWriteAccess);
            if (file2 == null) {
                documentFile2 = null;
            } else {
                File it = file2;
                boolean bl = false;
                documentFile2 = DocumentFile.fromFile((File)it);
            }
            DocumentFile documentFile3 = documentFile2;
            documentFile = documentFile3 == null ? ContextUtils.fromTreeUri(context, DocumentFileCompat.createDocumentUri$default(storageId, null, 2, null)) : documentFile3;
        } else {
            documentFile = ContextUtils.fromTreeUri(context, DocumentFileCompat.createDocumentUri$default(storageId, null, 2, null));
        }
        DocumentFile documentFile4 = file = documentFile;
        if (documentFile4 == null) {
            object = null;
        } else {
            DocumentFile documentFile5;
            DocumentFile it = documentFile5 = documentFile4;
            boolean bl = false;
            object = it.canRead() && (requiresWriteAccess && DocumentFileUtils.isWritable(it, context) || !requiresWriteAccess) ? documentFile5 : null;
        }
        return object;
    }

    public static /* synthetic */ DocumentFile getRootDocumentFile$default(Context context, String string2, boolean bl, boolean bl2, int n, Object object) {
        if ((n & 4) != 0) {
            bl = false;
        }
        if ((n & 8) != 0) {
            bl2 = true;
        }
        return DocumentFileCompat.getRootDocumentFile(context, string2, bl, bl2);
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    @JvmStatic
    @JvmOverloads
    @Nullable
    public static final DocumentFile getAccessibleRootDocumentFile(@NotNull Context context, @NotNull String fullPath, boolean requiresWriteAccess, boolean considerRawFile) {
        block8: {
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            Intrinsics.checkNotNullParameter((Object)fullPath, (String)"fullPath");
            if (considerRawFile && StringsKt.startsWith$default((CharSequence)fullPath, (char)'/', (boolean)false, (int)2, null) && (rootFile = FileUtils.getRootRawFile(new File(fullPath), context, requiresWriteAccess)) != null) {
                return DocumentFile.fromFile((File)rootFile);
            }
            storageId = DocumentFileCompat.getStorageId(context, fullPath);
            if (Intrinsics.areEqual((Object)storageId, (Object)"data")) {
                return DocumentFile.fromFile((File)FileUtils.getDataDirectory(context));
            }
            if (!(((CharSequence)storageId).length() > 0)) break block8;
            cleanBasePath = DocumentFileCompat.getBasePath(context, fullPath);
            downloadPath = Environment.getExternalStoragePublicDirectory((String)Environment.DIRECTORY_DOWNLOADS).getAbsolutePath();
            var7_7 /* !! */  = context.getContentResolver().getPersistedUriPermissions();
            Intrinsics.checkNotNullExpressionValue((Object)var7_7 /* !! */ , (String)"context.contentResolver.persistedUriPermissions");
            var7_7 /* !! */  = var7_7 /* !! */ ;
            $i$f$filter = false;
            var9_9 = $this$filter$iv;
            destination$iv$iv = new ArrayList<E>();
            $i$f$filterTo = false;
            for (T element$iv$iv : $this$filterTo$iv$iv) {
                it = (UriPermission)element$iv$iv /* !! */ ;
                $i$a$-filter-DocumentFileCompat$getAccessibleRootDocumentFile$1 = false;
                if (!it.isReadPermission() || !it.isWritePermission()) ** GOTO lbl-1000
                var16_19 = it.getUri();
                Intrinsics.checkNotNullExpressionValue((Object)var16_19, (String)"it.uri");
                if (UriUtils.isTreeDocumentFile(var16_19)) {
                    v0 = true;
                } else lbl-1000:
                // 2 sources

                {
                    v0 = false;
                }
                if (!v0) continue;
                destination$iv$iv.add(element$iv$iv /* !! */ );
            }
            $this$filter$iv = (List)destination$iv$iv;
            $i$f$forEach = false;
            for (T element$iv : $this$forEach$iv) {
                it = (UriPermission)element$iv;
                $i$a$-forEach-DocumentFileCompat$getAccessibleRootDocumentFile$2 = false;
                Intrinsics.checkNotNullExpressionValue((Object)downloadPath, (String)"downloadPath");
                if (StringsKt.startsWith$default((String)fullPath, (String)downloadPath, (boolean)false, (int)2, null)) {
                    element$iv$iv /* !! */  = it.getUri();
                    Intrinsics.checkNotNullExpressionValue(element$iv$iv /* !! */ , (String)"it.uri");
                    if (UriUtils.isDownloadsDocument(element$iv$iv /* !! */ )) {
                        element$iv$iv /* !! */  = Uri.parse((String)"content://com.android.providers.downloads.documents/tree/downloads");
                        Intrinsics.checkNotNullExpressionValue(element$iv$iv /* !! */ , (String)"parse(DOWNLOADS_TREE_URI)");
                        return ContextUtils.fromTreeUri(context, element$iv$iv /* !! */ );
                    }
                }
                if ((uriPath = it.getUri().getPath()) == null) continue;
                it = it.getUri();
                Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it.uri");
                if (!UriUtils.isExternalStorageDocument((Uri)it)) continue;
                currentStorageId = StringsKt.substringAfterLast$default((String)StringsKt.substringBefore$default((String)uriPath, (char)':', null, (int)2, null), (char)'/', null, (int)2, null);
                currentRootFolder = StringsKt.substringAfter((String)uriPath, (char)':', (String)"");
                if (!Intrinsics.areEqual((Object)currentStorageId, (Object)storageId) || !(((CharSequence)currentRootFolder).length() == 0) && !TextUtils.hasParent(cleanBasePath, currentRootFolder)) continue;
                var16_19 = it.getUri();
                Intrinsics.checkNotNullExpressionValue((Object)var16_19, (String)"it.uri");
                return ContextUtils.fromTreeUri(context, var16_19);
            }
        }
        return null;
    }

    public static /* synthetic */ DocumentFile getAccessibleRootDocumentFile$default(Context context, String string2, boolean bl, boolean bl2, int n, Object object) {
        if ((n & 4) != 0) {
            bl = false;
        }
        if ((n & 8) != 0) {
            bl2 = true;
        }
        return DocumentFileCompat.getAccessibleRootDocumentFile(context, string2, bl, bl2);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @JvmStatic
    @JvmOverloads
    @Nullable
    public static final File getRootRawFile(@NotNull Context context, @NotNull String storageId, boolean requiresWriteAccess) {
        Object object;
        block3: {
            block2: {
                Intrinsics.checkNotNullParameter((Object)context, (String)"context");
                Intrinsics.checkNotNullParameter((Object)storageId, (String)"storageId");
                object = storageId;
                File rootFile = Intrinsics.areEqual((Object)object, (Object)"primary") ? Environment.getExternalStorageDirectory() : (Intrinsics.areEqual((Object)object, (Object)"data") ? FileUtils.getDataDirectory(context) : new File(Intrinsics.stringPlus((String)"/storage/", (Object)storageId)));
                Object it = object = rootFile;
                boolean bl = false;
                if (!rootFile.canRead()) return null;
                if (!requiresWriteAccess) break block2;
                Intrinsics.checkNotNullExpressionValue((Object)rootFile, (String)"rootFile");
                if (FileUtils.isWritable(rootFile, context)) break block3;
            }
            if (requiresWriteAccess) return null;
        }
        boolean bl = true;
        if (!bl) return null;
        Object object2 = object;
        return object2;
    }

    public static /* synthetic */ File getRootRawFile$default(Context context, String string2, boolean bl, int n, Object object) {
        if ((n & 4) != 0) {
            bl = false;
        }
        return DocumentFileCompat.getRootRawFile(context, string2, bl);
    }

    @JvmStatic
    @NotNull
    public static final String buildAbsolutePath(@NotNull Context context, @NotNull String storageId, @NotNull String basePath) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)storageId, (String)"storageId");
        Intrinsics.checkNotNullParameter((Object)basePath, (String)"basePath");
        String cleanBasePath = INSTANCE.removeForbiddenCharsFromFilename$storage_release(basePath);
        Object object = storageId;
        String rootPath = Intrinsics.areEqual((Object)object, (Object)"primary") ? SimpleStorage.Companion.getExternalStoragePath() : (Intrinsics.areEqual((Object)object, (Object)"data") ? FileUtils.getDataDirectory(context).getPath() : Intrinsics.stringPlus((String)"/storage/", (Object)storageId));
        object = new char[1];
        object[0] = 47;
        return StringsKt.trimEnd((String)(rootPath + '/' + cleanBasePath), (char[])object);
    }

    @JvmStatic
    @NotNull
    public static final String buildAbsolutePath(@NotNull Context context, @NotNull String simplePath) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)simplePath, (String)"simplePath");
        char[] cArray = new char[]{'/'};
        String path = StringsKt.trimEnd((String)simplePath, (char[])cArray);
        return StringsKt.startsWith$default((CharSequence)path, (char)'/', (boolean)false, (int)2, null) ? INSTANCE.removeForbiddenCharsFromFilename$storage_release(path) : DocumentFileCompat.buildAbsolutePath(context, DocumentFileCompat.getStorageId(context, path), DocumentFileCompat.getBasePath(context, path));
    }

    @JvmStatic
    @NotNull
    public static final String buildSimplePath(@NotNull String storageId, @NotNull String basePath) {
        Intrinsics.checkNotNullParameter((Object)storageId, (String)"storageId");
        Intrinsics.checkNotNullParameter((Object)basePath, (String)"basePath");
        String cleanBasePath = TextUtils.trimFileSeparator(INSTANCE.removeForbiddenCharsFromFilename$storage_release(basePath));
        return storageId + ':' + cleanBasePath;
    }

    @JvmStatic
    @NotNull
    public static final String buildSimplePath(@NotNull Context context, @NotNull String absolutePath) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)absolutePath, (String)"absolutePath");
        return DocumentFileCompat.buildSimplePath(DocumentFileCompat.getStorageId(context, absolutePath), DocumentFileCompat.getBasePath(context, absolutePath));
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final Uri createDocumentUri(@NotNull String storageId, @NotNull String basePath) {
        Intrinsics.checkNotNullParameter((Object)storageId, (String)"storageId");
        Intrinsics.checkNotNullParameter((Object)basePath, (String)"basePath");
        Uri uri = Uri.parse((String)("content://" + EXTERNAL_STORAGE_AUTHORITY + "/tree/" + Uri.encode((String)(storageId + ':' + basePath))));
        Intrinsics.checkNotNullExpressionValue((Object)uri, (String)"parse(\"content://$EXTERN\u2026(\"$storageId:$basePath\"))");
        return uri;
    }

    public static /* synthetic */ Uri createDocumentUri$default(String string2, String string3, int n, Object object) {
        if ((n & 2) != 0) {
            string3 = "";
        }
        return DocumentFileCompat.createDocumentUri(string2, string3);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @JvmStatic
    public static final boolean isAccessGranted(@NotNull Context context, @NotNull String storageId) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)storageId, (String)"storageId");
        if (Intrinsics.areEqual((Object)storageId, (Object)"data")) return true;
        if (Intrinsics.areEqual((Object)storageId, (Object)"primary")) {
            if (Build.VERSION.SDK_INT < 29) return true;
        }
        if (DocumentFileCompat.getRootDocumentFile$default(context, storageId, true, false, 8, null) == null) return false;
        return true;
    }

    @JvmStatic
    public static final boolean doesExist(@NotNull Context context, @NotNull String fullPath) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)fullPath, (String)"fullPath");
        DocumentFile documentFile = DocumentFileCompat.fromFullPath$default(context, fullPath, null, false, false, 28, null);
        return documentFile == null ? false : documentFile.exists();
    }

    @JvmStatic
    public static final boolean delete(@NotNull Context context, @NotNull String fullPath) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)fullPath, (String)"fullPath");
        DocumentFile documentFile = DocumentFileCompat.fromFullPath$default(context, fullPath, null, false, false, 28, null);
        return documentFile == null ? false : documentFile.delete();
    }

    @JvmStatic
    @JvmOverloads
    public static final boolean isStorageUriPermissionGranted(@NotNull Context context, @NotNull String storageId, @NotNull String basePath) {
        boolean bl;
        block3: {
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            Intrinsics.checkNotNullParameter((Object)storageId, (String)"storageId");
            Intrinsics.checkNotNullParameter((Object)basePath, (String)"basePath");
            Uri root = DocumentFileCompat.createDocumentUri(storageId, basePath);
            List list = context.getContentResolver().getPersistedUriPermissions();
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"context.contentResolver.persistedUriPermissions");
            Iterable $this$any$iv = list;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    UriPermission it = (UriPermission)element$iv;
                    boolean bl2 = false;
                    if (!(it.isReadPermission() && it.isWritePermission() && Intrinsics.areEqual((Object)it.getUri(), (Object)root))) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return bl;
    }

    public static /* synthetic */ boolean isStorageUriPermissionGranted$default(Context context, String string2, String string3, int n, Object object) {
        if ((n & 4) != 0) {
            string3 = "";
        }
        return DocumentFileCompat.isStorageUriPermissionGranted(context, string2, string3);
    }

    @JvmStatic
    public static final boolean isDownloadsUriPermissionGranted(@NotNull Context context) {
        boolean bl;
        block3: {
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            Uri uri = Uri.parse((String)DOWNLOADS_TREE_URI);
            List list = context.getContentResolver().getPersistedUriPermissions();
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"context.contentResolver.persistedUriPermissions");
            Iterable $this$any$iv = list;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    UriPermission it = (UriPermission)element$iv;
                    boolean bl2 = false;
                    if (!(it.isReadPermission() && it.isWritePermission() && Intrinsics.areEqual((Object)it.getUri(), (Object)uri))) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return bl;
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    @JvmStatic
    @NotNull
    public static final List<String> getStorageIds(@NotNull Context context) {
        block8: {
            block7: {
                Intrinsics.checkNotNullParameter((Object)context, (String)"context");
                externalStoragePath = SimpleStorage.Companion.getExternalStoragePath();
                var3_2 = ContextCompat.getExternalFilesDirs((Context)context, null);
                Intrinsics.checkNotNullExpressionValue((Object)var3_2, (String)"getExternalFilesDirs(context, null)");
                $this$map$iv = ArraysKt.filterNotNull((Object[])var3_2);
                $i$f$map = false;
                var5_5 = $this$map$iv;
                destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    var10_15 = (File)item$iv$iv;
                    var21_23 = destination$iv$iv;
                    $i$a$-map-DocumentFileCompat$getStorageIds$storageIds$1 = false;
                    path = it.getPath();
                    Intrinsics.checkNotNullExpressionValue((Object)path, (String)"path");
                    var21_23.add(StringsKt.startsWith$default((String)path, (String)externalStoragePath, (boolean)false, (int)2, null) ? "primary" : StringsKt.substringBefore$default((String)StringsKt.substringAfter$default((String)path, (String)"/storage/", null, (int)2, null), (char)'/', null, (int)2, null));
                }
                storageIds = (List)destination$iv$iv;
                if (Build.VERSION.SDK_INT < 28) break block7;
                v0 = storageIds;
                break block8;
            }
            $i$f$map /* !! */  = context.getContentResolver().getPersistedUriPermissions();
            Intrinsics.checkNotNullExpressionValue((Object)$i$f$map /* !! */ , (String)"context.contentResolver.persistedUriPermissions");
            $i$f$map /* !! */  = $i$f$map /* !! */ ;
            $i$f$filter = false;
            destination$iv$iv = $this$filter$iv;
            destination$iv$iv = new ArrayList<E>();
            $i$f$filterTo = false;
            for (E element$iv$iv : $this$filterTo$iv$iv) {
                it = (UriPermission)element$iv$iv;
                $i$a$-filter-DocumentFileCompat$getStorageIds$persistedStorageIds$1 = false;
                if (!it.isReadPermission() || !it.isWritePermission()) ** GOTO lbl-1000
                var13_25 = it.getUri();
                Intrinsics.checkNotNullExpressionValue((Object)var13_25, (String)"it.uri");
                if (UriUtils.isExternalStorageDocument(var13_25)) {
                    v1 = true;
                } else lbl-1000:
                // 2 sources

                {
                    v1 = false;
                }
                if (!v1) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            $this$filter$iv = (List)destination$iv$iv;
            $i$f$mapNotNull = false;
            $this$filterTo$iv$iv = $this$mapNotNull$iv;
            destination$iv$iv = new ArrayList<E>();
            $i$f$mapNotNullTo = false;
            $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            $i$f$forEach = false;
            var11_19 = $this$forEach$iv$iv$iv.iterator();
            while (var11_19.hasNext()) {
                element$iv$iv = element$iv$iv$iv = var11_19.next();
                $i$a$-forEach-CollectionsKt___CollectionsKt$mapNotNullTo$1$iv$iv = false;
                it = (UriPermission)element$iv$iv;
                $i$a$-mapNotNull-DocumentFileCompat$getStorageIds$persistedStorageIds$2 = false;
                if (it.getUri().getPath() == null) {
                    v2 = null;
                } else {
                    $i$a$-run-DocumentFileCompat$getStorageIds$persistedStorageIds$2$1 = false;
                    v2 = StringsKt.substringAfterLast$default((String)StringsKt.substringBefore$default((String)$this$getStorageIds_u24lambda_u2d15_u24lambda_u2d14, (char)':', null, (int)2, null), (char)'/', null, (int)2, null);
                }
                if (v2 == null) continue;
                it$iv$iv = v2;
                $i$a$-let-CollectionsKt___CollectionsKt$mapNotNullTo$1$1$iv$iv = false;
                destination$iv$iv.add(it$iv$iv);
            }
            persistedStorageIds = (List)destination$iv$iv;
            $this$getStorageIds_u24lambda_u2d16 = CollectionsKt.toMutableList((Collection)storageIds);
            $i$a$-run-DocumentFileCompat$getStorageIds$1 = false;
            $this$getStorageIds_u24lambda_u2d16.addAll(persistedStorageIds);
            v0 = CollectionsKt.distinct((Iterable)$this$getStorageIds_u24lambda_u2d16);
        }
        return v0;
    }

    /*
     * WARNING - void declaration
     */
    @JvmStatic
    @NotNull
    public static final List<String> getSdCardIds(@NotNull Context context) {
        void $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Iterable $this$filter$iv = DocumentFileCompat.getStorageIds(context);
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            String it = (String)element$iv$iv;
            boolean bl = false;
            if (!(!Intrinsics.areEqual((Object)it, (Object)"primary"))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    @JvmStatic
    @JvmOverloads
    @Nullable
    public static final DocumentFile mkdirs(@NotNull Context context, @NotNull String fullPath, boolean requiresWriteAccess, boolean considerRawFile) {
        Function0 tryCreateWithRawFile2;
        block16: {
            block15: {
                Intrinsics.checkNotNullParameter((Object)context, (String)"context");
                Intrinsics.checkNotNullParameter((Object)fullPath, (String)"fullPath");
                tryCreateWithRawFile2 = (Function0)new Function0<DocumentFile>(fullPath, requiresWriteAccess, context){
                    final /* synthetic */ String $fullPath;
                    final /* synthetic */ boolean $requiresWriteAccess;
                    final /* synthetic */ Context $context;
                    {
                        this.$fullPath = $fullPath;
                        this.$requiresWriteAccess = $requiresWriteAccess;
                        this.$context = $context;
                        super(0);
                    }

                    @Nullable
                    public final DocumentFile invoke() {
                        File file;
                        File $this$invoke_u24lambda_u2d0 = file = new File(DocumentFileCompat.INSTANCE.removeForbiddenCharsFromFilename$storage_release(this.$fullPath));
                        boolean bl = false;
                        $this$invoke_u24lambda_u2d0.mkdirs();
                        File folder = file;
                        return folder.isDirectory() && folder.canRead() && (this.$requiresWriteAccess && FileUtils.isWritable(folder, this.$context) || !this.$requiresWriteAccess) ? DocumentFile.fromFile((File)folder) : null;
                    }
                };
                if (considerRawFile && StringsKt.startsWith$default((CharSequence)fullPath, (char)'/', (boolean)false, (int)2, null)) break block15;
                String string2 = FileUtils.getDataDirectory(context).getPath();
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"context.dataDirectory.path");
                if (!StringsKt.startsWith$default((String)fullPath, (String)string2, (boolean)false, (int)2, null)) break block16;
            }
            DocumentFile documentFile = (DocumentFile)tryCreateWithRawFile2.invoke();
            if (documentFile != null) {
                DocumentFile it = documentFile;
                boolean bl = false;
                return it;
            }
        }
        DocumentFile currentDirectory = null;
        DocumentFile documentFile = DocumentFileCompat.getAccessibleRootDocumentFile(context, fullPath, requiresWriteAccess, considerRawFile);
        if (documentFile == null) {
            return null;
        }
        currentDirectory = documentFile;
        if (DocumentFileUtils.isRawFile(currentDirectory)) {
            return (DocumentFile)tryCreateWithRawFile2.invoke();
        }
        ContentResolver resolver = context.getContentResolver();
        Iterable $this$forEach$iv = INSTANCE.getDirectorySequence$storage_release(DocumentFileCompat.getBasePath(context, fullPath));
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            String it = (String)element$iv;
            boolean bl = false;
            try {
                DocumentFile documentFile2;
                Intrinsics.checkNotNullExpressionValue((Object)resolver, (String)"resolver");
                DocumentFile directory = DocumentFileUtils.quickFindTreeFile(currentDirectory, context, resolver, it);
                if (directory == null) {
                    documentFile2 = currentDirectory.createDirectory(it);
                    if (documentFile2 == null) {
                        return null;
                    }
                } else if (directory.isDirectory() && directory.canRead()) {
                    documentFile2 = directory;
                } else {
                    return null;
                }
                currentDirectory = documentFile2;
            }
            catch (Exception e) {
                return null;
            }
        }
        return DocumentFileUtils.takeIfWritable(currentDirectory, context, requiresWriteAccess);
    }

    public static /* synthetic */ DocumentFile mkdirs$default(Context context, String string2, boolean bl, boolean bl2, int n, Object object) {
        if ((n & 4) != 0) {
            bl = true;
        }
        if ((n & 8) != 0) {
            bl2 = true;
        }
        return DocumentFileCompat.mkdirs(context, string2, bl, bl2);
    }

    /*
     * WARNING - void declaration
     */
    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final DocumentFile[] mkdirs(@NotNull Context context, @NotNull List<String> fullPaths, boolean requiresWriteAccess, boolean considerRawFile) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter(fullPaths, (String)"fullPaths");
        String dataDir = FileUtils.getDataDirectory(context).getPath();
        Object[] results = new DocumentFile[fullPaths.size()];
        Iterable $this$map$iv = fullPaths;
        boolean $i$f$map = false;
        Object object = $this$map$iv;
        Object destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            String string2 = (String)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(DocumentFileCompat.buildAbsolutePath(context, (String)it));
        }
        List cleanedFullPaths = (List)destination$iv$iv;
        for (String path : DocumentFileCompat.findUniqueDeepestSubFolders(context, cleanedFullPaths)) {
            block18: {
                block17: {
                    Object $this$mkdirs_u24lambda_u2d21 = destination$iv$iv = new File(path);
                    boolean bl = false;
                    ((File)$this$mkdirs_u24lambda_u2d21).mkdirs();
                    Object folder = destination$iv$iv;
                    if (considerRawFile && ((File)folder).isDirectory() && ((File)folder).canRead()) break block17;
                    Intrinsics.checkNotNullExpressionValue((Object)dataDir, (String)"dataDir");
                    if (!StringsKt.startsWith$default((String)path, (String)dataDir, (boolean)false, (int)2, null)) break block18;
                }
                Iterable $this$forEachIndexed$iv = cleanedFullPaths;
                boolean $i$f$forEachIndexed = false;
                int index$iv = 0;
                for (Object item$iv : $this$forEachIndexed$iv) {
                    void s;
                    int n = index$iv;
                    index$iv = n + 1;
                    if (n < 0) {
                        CollectionsKt.throwIndexOverflow();
                    }
                    String string3 = (String)item$iv;
                    int index = n;
                    boolean bl = false;
                    if (!TextUtils.hasParent(path, (String)s)) continue;
                    results[index] = DocumentFile.fromFile((File)new File(CollectionsKt.joinToString$default((Iterable)INSTANCE.getDirectorySequence$storage_release((String)s), (CharSequence)"/", (CharSequence)"/", null, (int)0, null, null, (int)60, null)));
                }
                continue;
            }
            DocumentFile currentDirectory = null;
            DocumentFile documentFile = DocumentFileCompat.getAccessibleRootDocumentFile(context, path, requiresWriteAccess, considerRawFile);
            if (documentFile == null) continue;
            currentDirectory = documentFile;
            boolean isRawFile = DocumentFileUtils.isRawFile(currentDirectory);
            ContentResolver resolver = context.getContentResolver();
            Iterable $this$forEach$iv = INSTANCE.getDirectorySequence$storage_release(DocumentFileCompat.getBasePath(context, path));
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                String it = (String)element$iv;
                boolean bl = false;
                try {
                    String s;
                    int index;
                    int n;
                    int index$iv;
                    boolean $i$f$forEachIndexed;
                    Iterable $this$forEachIndexed$iv;
                    String fullPath;
                    DocumentFile directory;
                    DocumentFile documentFile2;
                    if (isRawFile) {
                        documentFile2 = DocumentFileUtils.quickFindRawFile(currentDirectory, it);
                    } else {
                        Intrinsics.checkNotNullExpressionValue((Object)resolver, (String)"resolver");
                        documentFile2 = directory = DocumentFileUtils.quickFindTreeFile(currentDirectory, context, resolver, it);
                    }
                    if (directory == null) {
                        if (currentDirectory.createDirectory(it) == null) continue;
                        fullPath = DocumentFileUtils.getAbsolutePath(currentDirectory, context);
                        $this$forEachIndexed$iv = cleanedFullPaths;
                        $i$f$forEachIndexed = false;
                        index$iv = 0;
                        for (Object item$iv : $this$forEachIndexed$iv) {
                            n = index$iv;
                            index$iv = n + 1;
                            if (n < 0) {
                                CollectionsKt.throwIndexOverflow();
                            }
                            String string4 = (String)item$iv;
                            index = n;
                            boolean bl2 = false;
                            if (!Intrinsics.areEqual((Object)fullPath, (Object)s)) continue;
                            results[index] = currentDirectory;
                        }
                        continue;
                    }
                    if (!directory.isDirectory() || !directory.canRead()) continue;
                    currentDirectory = directory;
                    fullPath = DocumentFileUtils.getAbsolutePath(directory, context);
                    $this$forEachIndexed$iv = cleanedFullPaths;
                    $i$f$forEachIndexed = false;
                    index$iv = 0;
                    for (Object item$iv : $this$forEachIndexed$iv) {
                        n = index$iv;
                        index$iv = n + 1;
                        if (n < 0) {
                            CollectionsKt.throwIndexOverflow();
                        }
                        s = (String)item$iv;
                        index = n;
                        boolean bl3 = false;
                        if (!Intrinsics.areEqual((Object)fullPath, (Object)s)) continue;
                        results[index] = directory;
                    }
                }
                catch (Throwable e) {
                }
            }
        }
        Iterable $this$forEach$iv = (Iterable)ArraysKt.getIndices((Object[])results);
        boolean $i$f$forEach = false;
        object = $this$forEach$iv.iterator();
        while (object.hasNext()) {
            int element$iv;
            int index = element$iv = ((IntIterator)object).nextInt();
            boolean bl = false;
            Object object2 = results[index];
            results[index] = object2 == null ? null : DocumentFileUtils.takeIfWritable((DocumentFile)object2, context, requiresWriteAccess);
        }
        return results;
    }

    public static /* synthetic */ DocumentFile[] mkdirs$default(Context context, List list, boolean bl, boolean bl2, int n, Object object) {
        if ((n & 4) != 0) {
            bl = true;
        }
        if ((n & 8) != 0) {
            bl2 = true;
        }
        return DocumentFileCompat.mkdirs(context, list, bl, bl2);
    }

    @JvmStatic
    @Nullable
    public static final Uri createDownloadWithMediaStoreFallback(@NotNull Context context, @NotNull FileDescription file) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        DocumentFile publicFolder = DocumentFileCompat.fromPublicFolder$default(context, PublicDirectory.DOWNLOADS, null, true, false, 20, null);
        if (publicFolder == null && Build.VERSION.SDK_INT > 28) {
            MediaFile mediaFile = MediaStoreCompat.createDownload$default(context, file, null, 4, null);
            object = mediaFile == null ? null : mediaFile.getUri();
        } else {
            DocumentFile documentFile = publicFolder;
            if (documentFile == null) {
                object = null;
            } else {
                DocumentFile documentFile2 = DocumentFileUtils.makeFile$default(documentFile, context, file.getName(), file.getMimeType(), null, 8, null);
                object = documentFile2 == null ? null : documentFile2.getUri();
            }
        }
        return object;
    }

    @JvmStatic
    @Nullable
    public static final Uri createPictureWithMediaStoreFallback(@NotNull Context context, @NotNull FileDescription file) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        DocumentFile publicFolder = DocumentFileCompat.fromPublicFolder$default(context, PublicDirectory.PICTURES, null, true, false, 20, null);
        if (publicFolder == null && Build.VERSION.SDK_INT > 28) {
            MediaFile mediaFile = MediaStoreCompat.createImage$default(context, file, null, null, 12, null);
            object = mediaFile == null ? null : mediaFile.getUri();
        } else {
            DocumentFile documentFile = publicFolder;
            if (documentFile == null) {
                object = null;
            } else {
                DocumentFile documentFile2 = DocumentFileUtils.makeFile$default(documentFile, context, file.getName(), file.getMimeType(), null, 8, null);
                object = documentFile2 == null ? null : documentFile2.getUri();
            }
        }
        return object;
    }

    @JvmStatic
    @JvmOverloads
    @Nullable
    public static final DocumentFile createFile(@NotNull Context context, @NotNull String storageId, @NotNull String basePath, @NotNull String mimeType, boolean considerRawFile) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)storageId, (String)"storageId");
        Intrinsics.checkNotNullParameter((Object)basePath, (String)"basePath");
        Intrinsics.checkNotNullParameter((Object)mimeType, (String)"mimeType");
        if (Intrinsics.areEqual((Object)storageId, (Object)"data") || considerRawFile && Intrinsics.areEqual((Object)storageId, (Object)"primary") && Build.VERSION.SDK_INT < 29) {
            File file = new File(DocumentFileCompat.buildAbsolutePath(context, storageId, basePath));
            File file2 = file.getParentFile();
            if (file2 != null) {
                file2.mkdirs();
            }
            object = INSTANCE.create(file) ? DocumentFile.fromFile((File)file) : null;
        } else {
            DocumentFile documentFile;
            try {
                DocumentFile documentFile2;
                DocumentFile directory = INSTANCE.mkdirsParentDirectory(context, storageId, basePath, considerRawFile);
                String filename = INSTANCE.removeForbiddenCharsFromFilename$storage_release(INSTANCE.getFileNameFromPath(basePath));
                if (((CharSequence)filename).length() == 0) {
                    documentFile2 = null;
                } else {
                    DocumentFile documentFile3 = directory;
                    documentFile2 = documentFile3 == null ? null : DocumentFileUtils.makeFile$default(documentFile3, context, filename, mimeType, null, 8, null);
                }
                documentFile = documentFile2;
            }
            catch (Exception e) {
                documentFile = null;
            }
            object = documentFile;
        }
        return object;
    }

    public static /* synthetic */ DocumentFile createFile$default(Context context, String string2, String string3, String string4, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            string2 = "primary";
        }
        if ((n & 8) != 0) {
            string4 = "*/*";
        }
        if ((n & 0x10) != 0) {
            bl = true;
        }
        return DocumentFileCompat.createFile(context, string2, string3, string4, bl);
    }

    private final String getParentPath(String path) {
        List<String> it = this.getDirectorySequence$storage_release(path);
        boolean bl = false;
        return (String)CollectionsKt.getOrNull(it, (int)(it.size() - 2));
    }

    private final DocumentFile mkdirsParentDirectory(Context context, String storageId, String basePath, boolean considerRawFile) {
        String parentPath = this.getParentPath(basePath);
        return parentPath != null ? DocumentFileCompat.mkdirs$default(context, DocumentFileCompat.buildAbsolutePath(context, storageId, parentPath), considerRawFile, false, 8, null) : DocumentFileCompat.getRootDocumentFile(context, storageId, true, considerRawFile);
    }

    private final String getFileNameFromPath(String path) {
        char[] cArray = new char[]{'/'};
        return StringsKt.substringAfterLast$default((String)StringsKt.trimEnd((String)path, (char[])cArray), (char)'/', null, (int)2, null);
    }

    @JvmStatic
    @JvmOverloads
    @Nullable
    public static final DocumentFile recreate(@NotNull Context context, @NotNull String storageId, @NotNull String basePath, @NotNull String mimeType, boolean considerRawFile) {
        DocumentFile documentFile;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)storageId, (String)"storageId");
        Intrinsics.checkNotNullParameter((Object)basePath, (String)"basePath");
        Intrinsics.checkNotNullParameter((Object)mimeType, (String)"mimeType");
        File file = new File(DocumentFileCompat.buildAbsolutePath(context, storageId, basePath));
        file.delete();
        File file2 = file.getParentFile();
        if (file2 != null) {
            file2.mkdirs();
        }
        if ((considerRawFile || Intrinsics.areEqual((Object)storageId, (Object)"data")) && INSTANCE.create(file)) {
            return DocumentFile.fromFile((File)file);
        }
        DocumentFile directory = INSTANCE.mkdirsParentDirectory(context, storageId, basePath, considerRawFile);
        String filename = file.getName();
        CharSequence charSequence = filename;
        if (charSequence == null || charSequence.length() == 0) {
            return null;
        }
        DocumentFile documentFile2 = directory;
        if (documentFile2 == null) {
            documentFile = null;
        } else {
            DocumentFile $this$recreate_u24lambda_u2d28 = documentFile2;
            boolean bl = false;
            Intrinsics.checkNotNullExpressionValue((Object)filename, (String)"filename");
            DocumentFile documentFile3 = DocumentFileUtils.child$default($this$recreate_u24lambda_u2d28, context, filename, false, 4, null);
            if (documentFile3 != null) {
                documentFile3.delete();
            }
            documentFile = DocumentFileUtils.makeFile$default($this$recreate_u24lambda_u2d28, context, filename, mimeType, null, 8, null);
        }
        return documentFile;
    }

    public static /* synthetic */ DocumentFile recreate$default(Context context, String string2, String string3, String string4, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            string2 = "primary";
        }
        if ((n & 8) != 0) {
            string4 = "*/*";
        }
        if ((n & 0x10) != 0) {
            bl = true;
        }
        return DocumentFileCompat.recreate(context, string2, string3, string4, bl);
    }

    private final boolean create(File file) {
        boolean bl;
        try {
            bl = file.isFile() && file.length() == 0L || file.createNewFile();
        }
        catch (IOException e) {
            bl = false;
        }
        return bl;
    }

    @NotNull
    public final String removeForbiddenCharsFromFilename$storage_release(@NotNull String $this$removeForbiddenCharsFromFilename) {
        Intrinsics.checkNotNullParameter((Object)$this$removeForbiddenCharsFromFilename, (String)"<this>");
        return TextUtils.replaceCompletely(StringsKt.replace$default((String)$this$removeForbiddenCharsFromFilename, (String)":", (String)"_", (boolean)false, (int)4, null), "//", "/");
    }

    private final DocumentFile exploreFile(Context context, String storageId, String basePath, DocumentFileType documentType, boolean requiresWriteAccess, boolean considerRawFile) {
        Object object;
        DocumentFile file;
        DocumentFile documentFile;
        File rawFile = new File(DocumentFileCompat.buildAbsolutePath(context, storageId, basePath));
        if ((considerRawFile || Intrinsics.areEqual((Object)storageId, (Object)"data")) && rawFile.canRead() && FileUtils.shouldWritable(rawFile, context, requiresWriteAccess)) {
            return documentType == DocumentFileType.ANY || documentType == DocumentFileType.FILE && rawFile.isFile() || documentType == DocumentFileType.FOLDER && rawFile.isDirectory() ? DocumentFile.fromFile((File)rawFile) : (DocumentFile)null;
        }
        if (Build.VERSION.SDK_INT < 30) {
            DocumentFile documentFile2 = DocumentFileCompat.getRootDocumentFile(context, storageId, requiresWriteAccess, considerRawFile);
            documentFile = documentFile2 == null ? null : DocumentFileUtils.child$default(documentFile2, context, basePath, false, 4, null);
            if (documentFile == null) {
                return null;
            }
        } else {
            DocumentFile documentFile3;
            List directorySequence = CollectionsKt.toMutableList((Collection)this.getDirectorySequence$storage_release(basePath));
            ArrayList<Object> parentTree = new ArrayList<Object>(directorySequence.size());
            DocumentFile grantedFile = null;
            while (!((Collection)directorySequence).isEmpty()) {
                parentTree.add(CollectionsKt.removeFirst((List)directorySequence));
                String folderTree = CollectionsKt.joinToString$default((Iterable)parentTree, (CharSequence)"/", null, null, (int)0, null, null, (int)62, null);
                try {
                    DocumentFile documentFile4 = documentFile3 = (grantedFile = ContextUtils.fromTreeUri(context, DocumentFileCompat.createDocumentUri(storageId, folderTree)));
                    if (!(documentFile4 == null ? false : documentFile4.canRead())) continue;
                    break;
                }
                catch (SecurityException securityException) {
                }
            }
            if (grantedFile == null || directorySequence.isEmpty()) {
                documentFile = grantedFile;
            } else {
                String fileTree = CollectionsKt.joinToString$default((Iterable)directorySequence, (CharSequence)"/", (CharSequence)"/", null, (int)0, null, null, (int)60, null);
                documentFile3 = Uri.parse((String)Intrinsics.stringPlus((String)grantedFile.getUri().toString(), (Object)Uri.encode((String)fileTree)));
                Intrinsics.checkNotNullExpressionValue((Object)documentFile3, (String)"parse(grantedFile.uri.to\u2026) + Uri.encode(fileTree))");
                documentFile = ContextUtils.fromTreeUri(context, (Uri)documentFile3);
            }
        }
        DocumentFile documentFile5 = file = documentFile;
        if (documentFile5 == null) {
            object = null;
        } else {
            DocumentFile documentFile6;
            DocumentFile it = documentFile6 = documentFile5;
            boolean bl = false;
            object = it.canRead() && (documentType == DocumentFileType.ANY || documentType == DocumentFileType.FILE && it.isFile() || documentType == DocumentFileType.FOLDER && it.isDirectory()) ? documentFile6 : null;
        }
        return object;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<String> getDirectorySequence$storage_release(@NotNull String path) {
        void $this$filterNotTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        char[] cArray = new char[]{'/'};
        Iterable $this$filterNot$iv = StringsKt.split$default((CharSequence)path, (char[])cArray, (boolean)false, (int)0, (int)6, null);
        boolean $i$f$filterNot = false;
        Iterable iterable = $this$filterNot$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterNotTo = false;
        for (Object element$iv$iv : $this$filterNotTo$iv$iv) {
            String it = (String)element$iv$iv;
            boolean bl = false;
            if (StringsKt.isBlank((CharSequence)it)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    @JvmStatic
    @NotNull
    public static final List<String> findUniqueDeepestSubFolders(@NotNull Context context, @NotNull Collection<String> folderFullPaths) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter(folderFullPaths, (String)"folderFullPaths");
        Iterable $this$map$iv = folderFullPaths;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            String string2 = (String)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(DocumentFileCompat.buildAbsolutePath(context, (String)it));
        }
        List paths = CollectionsKt.distinct((Iterable)((List)destination$iv$iv));
        ArrayList results = new ArrayList(paths);
        Iterable $this$forEach$iv = paths;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            String it;
            Object v0;
            block3: {
                String path = (String)element$iv;
                boolean bl = false;
                for (Object t : (Iterable)paths) {
                    String it2 = (String)t;
                    boolean bl2 = false;
                    if (!(!Intrinsics.areEqual((Object)it2, (Object)path) && TextUtils.hasParent(path, it2))) continue;
                    v0 = t;
                    break block3;
                }
                v0 = null;
            }
            if ((String)v0 == null) continue;
            boolean bl = false;
            results.remove(it);
        }
        return results;
    }

    /*
     * WARNING - void declaration
     */
    @JvmStatic
    @NotNull
    public static final List<String> findUniqueParents(@NotNull Context context, @NotNull Collection<String> folderFullPaths) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter(folderFullPaths, (String)"folderFullPaths");
        Iterable $this$map$iv = folderFullPaths;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            String string2 = (String)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(DocumentFileCompat.buildAbsolutePath(context, (String)it));
        }
        List paths = CollectionsKt.distinct((Iterable)((List)destination$iv$iv));
        ArrayList<String> results = new ArrayList<String>(paths.size());
        Iterable $this$forEach$iv = paths;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            boolean bl;
            String path;
            block5: {
                path = (String)element$iv;
                boolean bl2 = false;
                Iterable $this$any$iv = paths;
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv2 : $this$any$iv) {
                        String it = (String)element$iv2;
                        boolean bl3 = false;
                        if (!(!Intrinsics.areEqual((Object)it, (Object)path) && TextUtils.hasParent(path, it))) continue;
                        bl = true;
                        break block5;
                    }
                    bl = false;
                }
            }
            if (bl) continue;
            results.add(path);
        }
        return results;
    }

    /*
     * WARNING - void declaration
     */
    @JvmStatic
    @WorkerThread
    @NotNull
    public static final List<String> findInaccessibleStorageLocations(@NotNull Context context, @NotNull List<String> fullPaths) {
        List list;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter(fullPaths, (String)"fullPaths");
        if (SimpleStorage.Companion.hasStoragePermission(context)) {
            List<String> uniqueParents = DocumentFileCompat.findUniqueParents(context, (Collection<String>)fullPaths);
            ArrayList<String> inaccessibleStorageLocations = new ArrayList<String>(uniqueParents.size());
            DocumentFile[] $this$forEachIndexed$iv = DocumentFileCompat.mkdirs$default(context, uniqueParents, false, false, 12, null);
            boolean $i$f$forEachIndexed = false;
            int index$iv = 0;
            for (DocumentFile item$iv : $this$forEachIndexed$iv) {
                void folder;
                int n = index$iv;
                index$iv = n + 1;
                DocumentFile documentFile = item$iv;
                int index = n;
                boolean bl = false;
                if (folder != null) continue;
                inaccessibleStorageLocations.add(uniqueParents.get(index));
            }
            list = inaccessibleStorageLocations;
        } else {
            void $this$mapTo$iv$iv;
            Iterable $this$map$iv = fullPaths;
            boolean $i$f$map = false;
            Iterable $this$forEachIndexed$iv = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                String string2 = (String)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(DocumentFileCompat.buildAbsolutePath(context, (String)it));
            }
            list = (List)destination$iv$iv;
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @JvmStatic
    public static final long getFreeSpace(@NotNull Context context, @NotNull String storageId) {
        long l;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)storageId, (String)"storageId");
        try {
            long l2;
            DocumentFile documentFile = INSTANCE.getDocumentFileForStorageInfo(context, storageId);
            if (documentFile == null) {
                return 0L;
            }
            DocumentFile file = documentFile;
            if (DocumentFileUtils.isRawFile(file)) {
                String string2 = file.getUri().getPath();
                Intrinsics.checkNotNull((Object)string2);
                l2 = new StatFs(string2).getAvailableBytes();
            } else if (Build.VERSION.SDK_INT >= 21) {
                ParcelFileDescriptor parcelFileDescriptor = context.getContentResolver().openFileDescriptor(file.getUri(), "r");
                if (parcelFileDescriptor == null) {
                    l2 = 0L;
                } else {
                    long l3;
                    long l4;
                    Closeable closeable = (Closeable)parcelFileDescriptor;
                    Throwable throwable = null;
                    try {
                        ParcelFileDescriptor it = (ParcelFileDescriptor)closeable;
                        boolean bl = false;
                        StructStatVfs stats = Os.fstatvfs((FileDescriptor)it.getFileDescriptor());
                        l4 = stats.f_bavail * stats.f_frsize;
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
                    }
                    l2 = l3 = l4;
                }
            } else {
                l2 = 0L;
            }
            l = l2;
        }
        catch (Throwable e) {
            l = 0L;
        }
        return l;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @JvmStatic
    public static final long getUsedSpace(@NotNull Context context, @NotNull String storageId) {
        long l;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)storageId, (String)"storageId");
        try {
            long l2;
            DocumentFile documentFile = INSTANCE.getDocumentFileForStorageInfo(context, storageId);
            if (documentFile == null) {
                return 0L;
            }
            DocumentFile file = documentFile;
            if (DocumentFileUtils.isRawFile(file)) {
                String string2 = file.getUri().getPath();
                Intrinsics.checkNotNull((Object)string2);
                StatFs $this$getUsedSpace_u24lambda_u2d41 = new StatFs(string2);
                boolean bl = false;
                l2 = $this$getUsedSpace_u24lambda_u2d41.getTotalBytes() - $this$getUsedSpace_u24lambda_u2d41.getAvailableBytes();
            } else if (Build.VERSION.SDK_INT >= 21) {
                ParcelFileDescriptor parcelFileDescriptor = context.getContentResolver().openFileDescriptor(file.getUri(), "r");
                if (parcelFileDescriptor == null) {
                    l2 = 0L;
                } else {
                    long $this$getUsedSpace_u24lambda_u2d41;
                    long l3;
                    Closeable closeable = (Closeable)parcelFileDescriptor;
                    Throwable throwable = null;
                    try {
                        ParcelFileDescriptor it = (ParcelFileDescriptor)closeable;
                        boolean bl = false;
                        StructStatVfs stats = Os.fstatvfs((FileDescriptor)it.getFileDescriptor());
                        l3 = stats.f_blocks * stats.f_frsize - stats.f_bavail * stats.f_frsize;
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
                    }
                    l2 = $this$getUsedSpace_u24lambda_u2d41 = l3;
                }
            } else {
                l2 = 0L;
            }
            l = l2;
        }
        catch (Throwable e) {
            l = 0L;
        }
        return l;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @JvmStatic
    public static final long getStorageCapacity(@NotNull Context context, @NotNull String storageId) {
        long l;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)storageId, (String)"storageId");
        try {
            long l2;
            DocumentFile documentFile = INSTANCE.getDocumentFileForStorageInfo(context, storageId);
            if (documentFile == null) {
                return 0L;
            }
            DocumentFile file = documentFile;
            if (DocumentFileUtils.isRawFile(file)) {
                String string2 = file.getUri().getPath();
                Intrinsics.checkNotNull((Object)string2);
                l2 = new StatFs(string2).getTotalBytes();
            } else if (Build.VERSION.SDK_INT >= 21) {
                ParcelFileDescriptor parcelFileDescriptor = context.getContentResolver().openFileDescriptor(file.getUri(), "r");
                if (parcelFileDescriptor == null) {
                    l2 = 0L;
                } else {
                    long l3;
                    long l4;
                    Closeable closeable = (Closeable)parcelFileDescriptor;
                    Throwable throwable = null;
                    try {
                        ParcelFileDescriptor it = (ParcelFileDescriptor)closeable;
                        boolean bl = false;
                        StructStatVfs stats = Os.fstatvfs((FileDescriptor)it.getFileDescriptor());
                        l4 = stats.f_blocks * stats.f_frsize;
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
                    }
                    l2 = l3 = l4;
                }
            } else {
                l2 = 0L;
            }
            l = l2;
        }
        catch (Throwable e) {
            l = 0L;
        }
        return l;
    }

    private final DocumentFile getDocumentFileForStorageInfo(Context context, String storageId) {
        DocumentFile documentFile;
        String string2 = storageId;
        if (Intrinsics.areEqual((Object)string2, (Object)"primary")) {
            File file = context.getExternalFilesDir(null);
            if (file == null) {
                return null;
            }
            File directory = file;
            documentFile = DocumentFile.fromFile((File)directory);
        } else if (Intrinsics.areEqual((Object)string2, (Object)"data")) {
            documentFile = DocumentFile.fromFile((File)FileUtils.getDataDirectory(context));
        } else {
            File folder = new File("/storage/" + storageId + "/Android/data/" + context.getPackageName() + "/files");
            folder.mkdirs();
            if (folder.canRead()) {
                documentFile = DocumentFile.fromFile((File)folder);
            } else {
                String string3 = folder.getAbsolutePath();
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"folder.absolutePath");
                documentFile = DocumentFileCompat.getAccessibleRootDocumentFile$default(context, string3, false, false, 4, null);
            }
        }
        return documentFile;
    }

    @JvmStatic
    @NotNull
    public static final String getFileNameFromUrl(@NotNull String url) {
        String string2;
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        try {
            string2 = URLDecoder.decode(url, "UTF-8");
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"decode(url, \"UTF-8\")");
            string2 = StringsKt.substringAfterLast$default((String)string2, (char)'/', null, (int)2, null);
        }
        catch (Exception e) {
            string2 = url;
        }
        return string2;
    }

    @JvmStatic
    @JvmOverloads
    @Nullable
    public static final DocumentFile fromSimplePath(@NotNull Context context, @NotNull String storageId, @NotNull String basePath, @NotNull DocumentFileType documentType, boolean requiresWriteAccess) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)storageId, (String)"storageId");
        Intrinsics.checkNotNullParameter((Object)basePath, (String)"basePath");
        Intrinsics.checkNotNullParameter((Object)((Object)documentType), (String)"documentType");
        return DocumentFileCompat.fromSimplePath$default(context, storageId, basePath, documentType, requiresWriteAccess, false, 32, null);
    }

    @JvmStatic
    @JvmOverloads
    @Nullable
    public static final DocumentFile fromSimplePath(@NotNull Context context, @NotNull String storageId, @NotNull String basePath, @NotNull DocumentFileType documentType) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)storageId, (String)"storageId");
        Intrinsics.checkNotNullParameter((Object)basePath, (String)"basePath");
        Intrinsics.checkNotNullParameter((Object)((Object)documentType), (String)"documentType");
        return DocumentFileCompat.fromSimplePath$default(context, storageId, basePath, documentType, false, false, 48, null);
    }

    @JvmStatic
    @JvmOverloads
    @Nullable
    public static final DocumentFile fromSimplePath(@NotNull Context context, @NotNull String storageId, @NotNull String basePath) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)storageId, (String)"storageId");
        Intrinsics.checkNotNullParameter((Object)basePath, (String)"basePath");
        return DocumentFileCompat.fromSimplePath$default(context, storageId, basePath, null, false, false, 56, null);
    }

    @JvmStatic
    @JvmOverloads
    @Nullable
    public static final DocumentFile fromSimplePath(@NotNull Context context, @NotNull String storageId) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)storageId, (String)"storageId");
        return DocumentFileCompat.fromSimplePath$default(context, storageId, null, null, false, false, 60, null);
    }

    @JvmStatic
    @JvmOverloads
    @Nullable
    public static final DocumentFile fromSimplePath(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        return DocumentFileCompat.fromSimplePath$default(context, null, null, null, false, false, 62, null);
    }

    @JvmStatic
    @JvmOverloads
    @Nullable
    public static final DocumentFile fromFullPath(@NotNull Context context, @NotNull String fullPath, @NotNull DocumentFileType documentType, boolean requiresWriteAccess) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)fullPath, (String)"fullPath");
        Intrinsics.checkNotNullParameter((Object)((Object)documentType), (String)"documentType");
        return DocumentFileCompat.fromFullPath$default(context, fullPath, documentType, requiresWriteAccess, false, 16, null);
    }

    @JvmStatic
    @JvmOverloads
    @Nullable
    public static final DocumentFile fromFullPath(@NotNull Context context, @NotNull String fullPath, @NotNull DocumentFileType documentType) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)fullPath, (String)"fullPath");
        Intrinsics.checkNotNullParameter((Object)((Object)documentType), (String)"documentType");
        return DocumentFileCompat.fromFullPath$default(context, fullPath, documentType, false, false, 24, null);
    }

    @JvmStatic
    @JvmOverloads
    @Nullable
    public static final DocumentFile fromFullPath(@NotNull Context context, @NotNull String fullPath) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)fullPath, (String)"fullPath");
        return DocumentFileCompat.fromFullPath$default(context, fullPath, null, false, false, 28, null);
    }

    @JvmStatic
    @JvmOverloads
    @Nullable
    public static final DocumentFile fromFile(@NotNull Context context, @NotNull File file, @NotNull DocumentFileType documentType, boolean requiresWriteAccess) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)((Object)documentType), (String)"documentType");
        return DocumentFileCompat.fromFile$default(context, file, documentType, requiresWriteAccess, false, 16, null);
    }

    @JvmStatic
    @JvmOverloads
    @Nullable
    public static final DocumentFile fromFile(@NotNull Context context, @NotNull File file, @NotNull DocumentFileType documentType) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)((Object)documentType), (String)"documentType");
        return DocumentFileCompat.fromFile$default(context, file, documentType, false, false, 24, null);
    }

    @JvmStatic
    @JvmOverloads
    @Nullable
    public static final DocumentFile fromFile(@NotNull Context context, @NotNull File file) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        return DocumentFileCompat.fromFile$default(context, file, null, false, false, 28, null);
    }

    @JvmStatic
    @JvmOverloads
    @Nullable
    public static final DocumentFile fromPublicFolder(@NotNull Context context, @NotNull PublicDirectory type, @NotNull String subFile, boolean requiresWriteAccess) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
        Intrinsics.checkNotNullParameter((Object)subFile, (String)"subFile");
        return DocumentFileCompat.fromPublicFolder$default(context, type, subFile, requiresWriteAccess, false, 16, null);
    }

    @JvmStatic
    @JvmOverloads
    @Nullable
    public static final DocumentFile fromPublicFolder(@NotNull Context context, @NotNull PublicDirectory type, @NotNull String subFile) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
        Intrinsics.checkNotNullParameter((Object)subFile, (String)"subFile");
        return DocumentFileCompat.fromPublicFolder$default(context, type, subFile, false, false, 24, null);
    }

    @JvmStatic
    @JvmOverloads
    @Nullable
    public static final DocumentFile fromPublicFolder(@NotNull Context context, @NotNull PublicDirectory type) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
        return DocumentFileCompat.fromPublicFolder$default(context, type, null, false, false, 28, null);
    }

    @JvmStatic
    @JvmOverloads
    @Nullable
    public static final DocumentFile getRootDocumentFile(@NotNull Context context, @NotNull String storageId, boolean requiresWriteAccess) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)storageId, (String)"storageId");
        return DocumentFileCompat.getRootDocumentFile$default(context, storageId, requiresWriteAccess, false, 8, null);
    }

    @JvmStatic
    @JvmOverloads
    @Nullable
    public static final DocumentFile getRootDocumentFile(@NotNull Context context, @NotNull String storageId) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)storageId, (String)"storageId");
        return DocumentFileCompat.getRootDocumentFile$default(context, storageId, false, false, 12, null);
    }

    @JvmStatic
    @JvmOverloads
    @Nullable
    public static final DocumentFile getAccessibleRootDocumentFile(@NotNull Context context, @NotNull String fullPath, boolean requiresWriteAccess) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)fullPath, (String)"fullPath");
        return DocumentFileCompat.getAccessibleRootDocumentFile$default(context, fullPath, requiresWriteAccess, false, 8, null);
    }

    @JvmStatic
    @JvmOverloads
    @Nullable
    public static final DocumentFile getAccessibleRootDocumentFile(@NotNull Context context, @NotNull String fullPath) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)fullPath, (String)"fullPath");
        return DocumentFileCompat.getAccessibleRootDocumentFile$default(context, fullPath, false, false, 12, null);
    }

    @JvmStatic
    @JvmOverloads
    @Nullable
    public static final File getRootRawFile(@NotNull Context context, @NotNull String storageId) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)storageId, (String)"storageId");
        return DocumentFileCompat.getRootRawFile$default(context, storageId, false, 4, null);
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final Uri createDocumentUri(@NotNull String storageId) {
        Intrinsics.checkNotNullParameter((Object)storageId, (String)"storageId");
        return DocumentFileCompat.createDocumentUri$default(storageId, null, 2, null);
    }

    @JvmStatic
    @JvmOverloads
    public static final boolean isStorageUriPermissionGranted(@NotNull Context context, @NotNull String storageId) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)storageId, (String)"storageId");
        return DocumentFileCompat.isStorageUriPermissionGranted$default(context, storageId, null, 4, null);
    }

    @JvmStatic
    @JvmOverloads
    @Nullable
    public static final DocumentFile mkdirs(@NotNull Context context, @NotNull String fullPath, boolean requiresWriteAccess) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)fullPath, (String)"fullPath");
        return DocumentFileCompat.mkdirs$default(context, fullPath, requiresWriteAccess, false, 8, null);
    }

    @JvmStatic
    @JvmOverloads
    @Nullable
    public static final DocumentFile mkdirs(@NotNull Context context, @NotNull String fullPath) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)fullPath, (String)"fullPath");
        return DocumentFileCompat.mkdirs$default(context, fullPath, false, false, 12, null);
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final DocumentFile[] mkdirs(@NotNull Context context, @NotNull List<String> fullPaths, boolean requiresWriteAccess) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter(fullPaths, (String)"fullPaths");
        return DocumentFileCompat.mkdirs$default(context, fullPaths, requiresWriteAccess, false, 8, null);
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final DocumentFile[] mkdirs(@NotNull Context context, @NotNull List<String> fullPaths) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter(fullPaths, (String)"fullPaths");
        return DocumentFileCompat.mkdirs$default(context, fullPaths, false, false, 12, null);
    }

    @JvmStatic
    @JvmOverloads
    @Nullable
    public static final DocumentFile createFile(@NotNull Context context, @NotNull String storageId, @NotNull String basePath, @NotNull String mimeType) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)storageId, (String)"storageId");
        Intrinsics.checkNotNullParameter((Object)basePath, (String)"basePath");
        Intrinsics.checkNotNullParameter((Object)mimeType, (String)"mimeType");
        return DocumentFileCompat.createFile$default(context, storageId, basePath, mimeType, false, 16, null);
    }

    @JvmStatic
    @JvmOverloads
    @Nullable
    public static final DocumentFile createFile(@NotNull Context context, @NotNull String storageId, @NotNull String basePath) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)storageId, (String)"storageId");
        Intrinsics.checkNotNullParameter((Object)basePath, (String)"basePath");
        return DocumentFileCompat.createFile$default(context, storageId, basePath, null, false, 24, null);
    }

    @JvmStatic
    @JvmOverloads
    @Nullable
    public static final DocumentFile createFile(@NotNull Context context, @NotNull String basePath) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)basePath, (String)"basePath");
        return DocumentFileCompat.createFile$default(context, null, basePath, null, false, 26, null);
    }

    @JvmStatic
    @JvmOverloads
    @Nullable
    public static final DocumentFile recreate(@NotNull Context context, @NotNull String storageId, @NotNull String basePath, @NotNull String mimeType) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)storageId, (String)"storageId");
        Intrinsics.checkNotNullParameter((Object)basePath, (String)"basePath");
        Intrinsics.checkNotNullParameter((Object)mimeType, (String)"mimeType");
        return DocumentFileCompat.recreate$default(context, storageId, basePath, mimeType, false, 16, null);
    }

    @JvmStatic
    @JvmOverloads
    @Nullable
    public static final DocumentFile recreate(@NotNull Context context, @NotNull String storageId, @NotNull String basePath) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)storageId, (String)"storageId");
        Intrinsics.checkNotNullParameter((Object)basePath, (String)"basePath");
        return DocumentFileCompat.recreate$default(context, storageId, basePath, null, false, 24, null);
    }

    @JvmStatic
    @JvmOverloads
    @Nullable
    public static final DocumentFile recreate(@NotNull Context context, @NotNull String basePath) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)basePath, (String)"basePath");
        return DocumentFileCompat.recreate$default(context, null, basePath, null, false, 26, null);
    }
}

