/*
 * Decompiled with CFR 0.152.
 */
package com.anggrayudi.storage.file;

import android.content.Context;
import android.net.Uri;
import com.anggrayudi.storage.SimpleStorage;
import com.anggrayudi.storage.extension.TextUtils;
import com.anggrayudi.storage.file.DocumentFileCompat;
import com.anggrayudi.storage.file.FileUtils;
import java.io.File;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0017\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006B\u001f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0007\u001a\u00020\u0005\u0012\u0006\u0010\b\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\tB\u0017\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\fR\u0011\u0010\r\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\b\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u000fR\u0011\u0010\u0011\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u000fR\u0011\u0010\u0007\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u000fR\u0011\u0010\u0014\u001a\u00020\u00158F\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0017\u00a8\u0006\u0018"}, d2={"Lcom/anggrayudi/storage/file/FileFullPath;", "", "context", "Landroid/content/Context;", "fullPath", "", "(Landroid/content/Context;Ljava/lang/String;)V", "storageId", "basePath", "(Landroid/content/Context;Ljava/lang/String;Ljava/lang/String;)V", "file", "Ljava/io/File;", "(Landroid/content/Context;Ljava/io/File;)V", "absolutePath", "getAbsolutePath", "()Ljava/lang/String;", "getBasePath", "simplePath", "getSimplePath", "getStorageId", "uri", "Landroid/net/Uri;", "getUri", "()Landroid/net/Uri;", "storage_release"})
public final class FileFullPath {
    @NotNull
    private final String absolutePath;
    @NotNull
    private final String simplePath;
    @NotNull
    private final String storageId;
    @NotNull
    private final String basePath;

    @NotNull
    public final String getAbsolutePath() {
        return this.absolutePath;
    }

    @NotNull
    public final String getSimplePath() {
        return this.simplePath;
    }

    @NotNull
    public final String getStorageId() {
        return this.storageId;
    }

    @NotNull
    public final String getBasePath() {
        return this.basePath;
    }

    public FileFullPath(@NotNull Context context, @NotNull String fullPath) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)fullPath, (String)"fullPath");
        if (StringsKt.startsWith$default((CharSequence)fullPath, (char)'/', (boolean)false, (int)2, null)) {
            if (StringsKt.startsWith$default((String)fullPath, (String)SimpleStorage.Companion.getExternalStoragePath(), (boolean)false, (int)2, null)) {
                this.storageId = "primary";
                String externalPath = SimpleStorage.Companion.getExternalStoragePath();
                this.basePath = TextUtils.trimFileSeparator(StringsKt.substringAfter((String)fullPath, (String)externalPath, (String)""));
                this.simplePath = this.storageId + ':' + this.basePath;
                char[] cArray = new char[]{'/'};
                this.absolutePath = StringsKt.trimEnd((String)(externalPath + '/' + this.basePath), (char[])cArray);
            } else {
                String externalPath = FileUtils.getDataDirectory(context).getPath();
                Intrinsics.checkNotNullExpressionValue((Object)externalPath, (String)"context.dataDirectory.path");
                if (StringsKt.startsWith$default((String)fullPath, (String)externalPath, (boolean)false, (int)2, null)) {
                    this.storageId = "data";
                    String dataPath = FileUtils.getDataDirectory(context).getPath();
                    Intrinsics.checkNotNullExpressionValue((Object)dataPath, (String)"dataPath");
                    this.basePath = TextUtils.trimFileSeparator(StringsKt.substringAfter((String)fullPath, (String)dataPath, (String)""));
                    this.simplePath = this.storageId + ':' + this.basePath;
                    char[] cArray = new char[]{'/'};
                    this.absolutePath = StringsKt.trimEnd((String)(dataPath + '/' + this.basePath), (char[])cArray);
                } else {
                    this.storageId = StringsKt.substringBefore$default((String)StringsKt.substringAfter((String)fullPath, (String)"/storage/", (String)""), (char)'/', null, (int)2, null);
                    this.basePath = TextUtils.trimFileSeparator(StringsKt.substringAfter((String)fullPath, (String)Intrinsics.stringPlus((String)"/storage/", (Object)this.storageId), (String)""));
                    this.simplePath = this.storageId + ':' + this.basePath;
                    char[] cArray = new char[]{'/'};
                    this.absolutePath = StringsKt.trimEnd((String)("/storage/" + this.storageId + '/' + this.basePath), (char[])cArray);
                }
            }
        } else {
            String string2;
            this.simplePath = fullPath;
            this.storageId = StringsKt.substringAfterLast$default((String)StringsKt.substringBefore((String)fullPath, (char)':', (String)""), (char)'/', null, (int)2, null);
            this.basePath = TextUtils.trimFileSeparator(StringsKt.substringAfter((String)fullPath, (char)':', (String)""));
            String string3 = this.storageId;
            if (Intrinsics.areEqual((Object)string3, (Object)"primary")) {
                char[] cArray = new char[]{'/'};
                string2 = StringsKt.trimEnd((String)(SimpleStorage.Companion.getExternalStoragePath() + '/' + this.basePath), (char[])cArray);
            } else if (Intrinsics.areEqual((Object)string3, (Object)"data")) {
                char[] cArray = new char[]{'/'};
                string2 = StringsKt.trimEnd((String)(FileUtils.getDataDirectory(context).getPath() + '/' + this.basePath), (char[])cArray);
            } else {
                char[] cArray = new char[]{'/'};
                string2 = StringsKt.trimEnd((String)("/storage/" + this.storageId + '/' + this.basePath), (char[])cArray);
            }
            this.absolutePath = string2;
        }
    }

    public FileFullPath(@NotNull Context context, @NotNull String storageId, @NotNull String basePath) {
        String string2;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)storageId, (String)"storageId");
        Intrinsics.checkNotNullParameter((Object)basePath, (String)"basePath");
        this.storageId = storageId;
        this.basePath = TextUtils.trimFileSeparator(basePath);
        this.simplePath = storageId + ':' + basePath;
        String string3 = storageId;
        if (Intrinsics.areEqual((Object)string3, (Object)"primary")) {
            char[] cArray = new char[]{'/'};
            string2 = StringsKt.trimEnd((String)(SimpleStorage.Companion.getExternalStoragePath() + '/' + basePath), (char[])cArray);
        } else if (Intrinsics.areEqual((Object)string3, (Object)"data")) {
            char[] cArray = new char[]{'/'};
            string2 = StringsKt.trimEnd((String)(FileUtils.getDataDirectory(context).getPath() + '/' + basePath), (char[])cArray);
        } else {
            char[] cArray = new char[]{'/'};
            string2 = StringsKt.trimEnd((String)("/storage/" + storageId + '/' + basePath), (char[])cArray);
        }
        this.absolutePath = string2;
    }

    public FileFullPath(@NotNull Context context, @NotNull File file) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        String string2 = file.getPath();
        if (string2 == null) {
            string2 = "";
        }
        this(context, string2);
    }

    @NotNull
    public final Uri getUri() {
        return DocumentFileCompat.createDocumentUri(this.storageId, this.basePath);
    }
}

