/*
 * Decompiled with CFR 0.152.
 */
package com.anggrayudi.storage.media;

import android.annotation.SuppressLint;
import android.annotation.TargetApi;
import android.app.RecoverableSecurityException;
import android.content.ContentValues;
import android.content.Context;
import android.content.Intent;
import android.content.IntentSender;
import android.database.Cursor;
import android.net.Uri;
import android.os.Build;
import android.text.format.Formatter;
import androidx.annotation.RequiresApi;
import androidx.annotation.UiThread;
import androidx.annotation.WorkerThread;
import androidx.core.content.FileProvider;
import androidx.documentfile.provider.DocumentFile;
import com.anggrayudi.storage.SimpleStorage;
import com.anggrayudi.storage.callback.FileCallback;
import com.anggrayudi.storage.extension.CoroutineExtKt;
import com.anggrayudi.storage.extension.IOUtils;
import com.anggrayudi.storage.extension.PrimitivesExtKt;
import com.anggrayudi.storage.extension.TextUtils;
import com.anggrayudi.storage.extension.UriUtils;
import com.anggrayudi.storage.file.CreateMode;
import com.anggrayudi.storage.file.DocumentFileCompat;
import com.anggrayudi.storage.file.DocumentFileUtils;
import com.anggrayudi.storage.file.MimeType;
import com.anggrayudi.storage.media.FileDescription;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.Boxing;
import kotlin.coroutines.jvm.internal.DebugProbesKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.text.StringsKt;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CancellableContinuation;
import kotlinx.coroutines.CancellableContinuationImpl;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.Dispatchers;
import kotlinx.coroutines.Job;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u009a\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0010\n\u0002\u0010\u000b\n\u0002\b\n\n\u0002\u0010\t\n\u0002\b\u0015\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u000b\u0018\u00002\u00020\u0001:\u0001sB\u0017\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ@\u0010@\u001a\u00020A2\u0006\u0010B\u001a\u00020C2\u0006\u0010D\u001a\u00020E2\u0006\u0010F\u001a\u00020G2\u0006\u0010H\u001a\u00020 2\u0006\u0010I\u001a\u00020+2\u0006\u0010J\u001a\u00020 2\u0006\u0010K\u001a\u00020LH\u0002J$\u0010M\u001a\u00020A2\u0006\u0010N\u001a\u00020G2\n\b\u0002\u0010O\u001a\u0004\u0018\u00010P2\u0006\u0010K\u001a\u00020LH\u0007J3\u0010Q\u001a\u00020A2\u0006\u0010F\u001a\u00020G2\u0006\u0010K\u001a\u00020L2\u0018\u0010R\u001a\u0014\u0012\u0004\u0012\u00020C\u0012\u0004\u0012\u00020E\u0012\u0004\u0012\u00020A0SH\u0082\bJ4\u0010T\u001a\u0004\u0018\u00010G2\u0006\u0010U\u001a\u00020G2\u0006\u0010V\u001a\u00020\u000b2\b\u00102\u001a\u0004\u0018\u00010\u000b2\u0006\u0010W\u001a\u00020X2\u0006\u0010K\u001a\u00020LH\u0002J\u0006\u0010Y\u001a\u00020 J\u0013\u0010Z\u001a\u00020 2\b\u0010[\u001a\u0004\u0018\u00010\u0001H\u0096\u0002J\u0010\u0010\\\u001a\u00020]2\u0006\u0010^\u001a\u00020\u000bH\u0002J\u0010\u0010_\u001a\u00020+2\u0006\u0010^\u001a\u00020\u000bH\u0002J\u0012\u0010`\u001a\u0004\u0018\u00010\u000b2\u0006\u0010^\u001a\u00020\u000bH\u0002J \u0010a\u001a\u00020b2\u0006\u0010N\u001a\u00020G2\u0006\u0010V\u001a\u00020\u000b2\u0006\u0010K\u001a\u00020LH\u0002J\u001c\u0010c\u001a\u00020A2\u0006\u0010d\u001a\u00020e2\n\b\u0002\u0010K\u001a\u0004\u0018\u00010LH\u0002J\b\u0010f\u001a\u00020]H\u0016J$\u0010g\u001a\u00020A2\u0006\u0010N\u001a\u00020G2\n\b\u0002\u0010O\u001a\u0004\u0018\u00010P2\u0006\u0010K\u001a\u00020LH\u0007J\u0010\u0010g\u001a\u00020 2\u0006\u0010:\u001a\u00020\u000bH\u0007J\u0010\u0010h\u001a\u00020i2\u0006\u0010j\u001a\u00020\u000bH\u0007J\n\u0010k\u001a\u0004\u0018\u00010CH\u0007J\u0014\u0010l\u001a\u0004\u0018\u00010E2\b\b\u0002\u0010m\u001a\u00020 H\u0007J\u000e\u0010n\u001a\u00020 2\u0006\u0010o\u001a\u00020\u000bJ\b\u0010p\u001a\u0004\u0018\u00010GJ\n\u0010q\u001a\u0004\u0018\u00010\u0005H\u0007J\b\u0010r\u001a\u00020\u000bH\u0016R\u0011\u0010\n\u001a\u00020\u000b8G\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\rR\u001c\u0010\u000e\u001a\u0004\u0018\u00010\u000fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\u0011\"\u0004\b\u0012\u0010\u0013R\u0011\u0010\u0014\u001a\u00020\u000b8F\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\rR\u0011\u0010\u0016\u001a\u00020\u000b8F\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\rR\u0016\u0010\u0002\u001a\n \u0018*\u0004\u0018\u00010\u00030\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0019\u001a\u00020\u000b8F\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\rR\u0011\u0010\u001b\u001a\u00020\u000b8F\u00a2\u0006\u0006\u001a\u0004\b\u001c\u0010\rR\u0011\u0010\u001d\u001a\u00020\u000b8F\u00a2\u0006\u0006\u001a\u0004\b\u001e\u0010\rR\u0011\u0010\u001f\u001a\u00020 8F\u00a2\u0006\u0006\u001a\u0004\b!\u0010\"R\u0011\u0010#\u001a\u00020 8F\u00a2\u0006\u0006\u001a\u0004\b#\u0010\"R\u0011\u0010$\u001a\u00020 8F\u00a2\u0006\u0006\u001a\u0004\b$\u0010\"R$\u0010&\u001a\u00020 2\u0006\u0010%\u001a\u00020 8G@GX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b&\u0010\"\"\u0004\b'\u0010(R\u0011\u0010)\u001a\u00020 8F\u00a2\u0006\u0006\u001a\u0004\b)\u0010\"R\u0011\u0010*\u001a\u00020+8F\u00a2\u0006\u0006\u001a\u0004\b,\u0010-R$\u0010.\u001a\u00020+2\u0006\u0010%\u001a\u00020+8F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b/\u0010-\"\u0004\b0\u00101R\u0011\u00102\u001a\u00020\u000b8F\u00a2\u0006\u0006\u001a\u0004\b3\u0010\rR\u0013\u00104\u001a\u0004\u0018\u00010\u000b8F\u00a2\u0006\u0006\u001a\u0004\b5\u0010\rR\u0013\u00106\u001a\u0004\u0018\u00010\u000b8F\u00a2\u0006\u0006\u001a\u0004\b7\u0010\rR\u0011\u00108\u001a\u00020 8F\u00a2\u0006\u0006\u001a\u0004\b9\u0010\"R\u0011\u0010:\u001a\u00020\u000b8G\u00a2\u0006\u0006\u001a\u0004\b;\u0010\rR\u0013\u0010<\u001a\u0004\u0018\u00010\u000b8F\u00a2\u0006\u0006\u001a\u0004\b=\u0010\rR\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b>\u0010?\u00a8\u0006t"}, d2={"Lcom/anggrayudi/storage/media/MediaFile;", "", "context", "Landroid/content/Context;", "rawFile", "Ljava/io/File;", "(Landroid/content/Context;Ljava/io/File;)V", "uri", "Landroid/net/Uri;", "(Landroid/content/Context;Landroid/net/Uri;)V", "absolutePath", "", "getAbsolutePath", "()Ljava/lang/String;", "accessCallback", "Lcom/anggrayudi/storage/media/MediaFile$AccessCallback;", "getAccessCallback", "()Lcom/anggrayudi/storage/media/MediaFile$AccessCallback;", "setAccessCallback", "(Lcom/anggrayudi/storage/media/MediaFile$AccessCallback;)V", "baseName", "getBaseName", "basePath", "getBasePath", "kotlin.jvm.PlatformType", "extension", "getExtension", "formattedSize", "getFormattedSize", "fullName", "getFullName", "hasZeroLength", "", "getHasZeroLength", "()Z", "isEmpty", "isMine", "value", "isPending", "setPending", "(Z)V", "isRawFile", "lastModified", "", "getLastModified", "()J", "length", "getLength", "setLength", "(J)V", "mimeType", "getMimeType", "name", "getName", "owner", "getOwner", "presentsInSafDatabase", "getPresentsInSafDatabase", "relativePath", "getRelativePath", "type", "getType", "getUri", "()Landroid/net/Uri;", "copyFileStream", "", "inputStream", "Ljava/io/InputStream;", "outputStream", "Ljava/io/OutputStream;", "targetFile", "Landroidx/documentfile/provider/DocumentFile;", "watchProgress", "reportInterval", "deleteSourceFileWhenComplete", "callback", "Lcom/anggrayudi/storage/callback/FileCallback;", "copyTo", "targetFolder", "fileDescription", "Lcom/anggrayudi/storage/media/FileDescription;", "createFileStreams", "onStreamsReady", "Lkotlin/Function2;", "createTargetFile", "targetDirectory", "fileName", "mode", "Lcom/anggrayudi/storage/file/CreateMode;", "delete", "equals", "other", "getColumnInfoInt", "", "column", "getColumnInfoLong", "getColumnInfoString", "handleFileConflict", "Lcom/anggrayudi/storage/callback/FileCallback$ConflictResolution;", "handleSecurityException", "e", "Ljava/lang/SecurityException;", "hashCode", "moveTo", "openFileIntent", "Landroid/content/Intent;", "authority", "openInputStream", "openOutputStream", "append", "renameTo", "newName", "toDocumentFile", "toRawFile", "toString", "AccessCallback", "storage_release"})
public final class MediaFile {
    @NotNull
    private final Uri uri;
    private final Context context;
    @Nullable
    private AccessCallback accessCallback;

    public MediaFile(@NotNull Context context, @NotNull Uri uri) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)uri, (String)"uri");
        this.uri = uri;
        this.context = context.getApplicationContext();
    }

    @NotNull
    public final Uri getUri() {
        return this.uri;
    }

    public MediaFile(@NotNull Context context, @NotNull File rawFile) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)rawFile, (String)"rawFile");
        Uri uri = Uri.fromFile((File)rawFile);
        Intrinsics.checkNotNullExpressionValue((Object)uri, (String)"fromFile(rawFile)");
        this(context, uri);
    }

    @Nullable
    public final AccessCallback getAccessCallback() {
        return this.accessCallback;
    }

    public final void setAccessCallback(@Nullable AccessCallback accessCallback) {
        this.accessCallback = accessCallback;
    }

    @NotNull
    public final String getFullName() {
        String string2;
        if (this.isRawFile()) {
            File file = this.toRawFile();
            string2 = file == null ? null : file.getName();
            if (string2 == null) {
                string2 = "";
            }
        } else {
            String mimeType = this.getColumnInfoString("mime_type");
            String string3 = this.getColumnInfoString("_display_name");
            if (string3 == null) {
                string3 = "";
            }
            String displayName = string3;
            string2 = MimeType.getFullFileName(displayName, mimeType);
        }
        return string2;
    }

    @Nullable
    public final String getName() {
        File file = this.toRawFile();
        String string2 = file == null ? null : file.getName();
        if (string2 == null) {
            string2 = this.getColumnInfoString("_display_name");
        }
        return string2;
    }

    @NotNull
    public final String getBaseName() {
        return MimeType.getBaseFileName(this.getFullName());
    }

    @NotNull
    public final String getExtension() {
        return MimeType.getExtensionFromFileName(this.getFullName());
    }

    @Nullable
    public final String getType() {
        String string2;
        File file = this.toRawFile();
        if (file == null) {
            string2 = null;
        } else {
            String string3 = file.getName();
            if (string3 == null) {
                string2 = null;
            } else {
                String it = string3;
                boolean bl = false;
                string2 = MimeType.getMimeTypeFromExtension(MimeType.getExtensionFromFileName(it));
            }
        }
        String string4 = string2;
        return string4 == null ? this.getColumnInfoString("mime_type") : string4;
    }

    @NotNull
    public final String getMimeType() {
        String string2 = this.getColumnInfoString("mime_type");
        return string2 == null ? MimeType.getMimeTypeFromExtension(this.getExtension()) : string2;
    }

    public final long getLength() {
        File file = this.toRawFile();
        Long l = file == null ? null : Long.valueOf(file.length());
        return l == null ? this.getColumnInfoLong("_size") : l.longValue();
    }

    public final void setLength(long value) {
        try {
            ContentValues contentValues;
            ContentValues $this$_set_length__u24lambda_u2d1 = contentValues = new ContentValues(1);
            boolean bl = false;
            $this$_set_length__u24lambda_u2d1.put("_size", Long.valueOf(value));
            ContentValues contentValues2 = contentValues;
            this.context.getContentResolver().update(this.uri, contentValues2, null, null);
        }
        catch (SecurityException e) {
            MediaFile.handleSecurityException$default(this, e, null, 2, null);
        }
    }

    @NotNull
    public final String getFormattedSize() {
        String string2 = Formatter.formatFileSize((Context)this.context, (long)this.getLength());
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"formatFileSize(context, length)");
        return string2;
    }

    public final boolean isEmpty() {
        return this.getPresentsInSafDatabase() && this.getHasZeroLength();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean getPresentsInSafDatabase() {
        boolean bl;
        Cursor cursor = this.context.getContentResolver().query(this.uri, null, null, null, null);
        if (cursor == null) {
            bl = false;
        } else {
            boolean bl2;
            boolean bl3;
            Closeable closeable = (Closeable)cursor;
            Throwable throwable = null;
            try {
                Cursor it = (Cursor)closeable;
                boolean bl4 = false;
                bl3 = it.getCount() > 0;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
            bl = bl2 = bl3;
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean getHasZeroLength() {
        boolean bl;
        Object object = this.context;
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"context");
        InputStream inputStream = UriUtils.openInputStream(this.uri, object);
        if (inputStream == null) {
            bl = false;
        } else {
            boolean bl2;
            object = inputStream;
            Throwable throwable = null;
            try {
                InputStream stream = (InputStream)object;
                boolean bl3 = false;
                bl2 = stream.available() == 0;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)object, (Throwable)throwable);
            }
            bl = !bl2;
        }
        return !bl;
    }

    public final boolean isRawFile() {
        return UriUtils.isRawFile(this.uri);
    }

    public final long getLastModified() {
        File file = this.toRawFile();
        Long l = file == null ? null : Long.valueOf(file.lastModified());
        return l == null ? this.getColumnInfoLong("date_modified") : l.longValue();
    }

    @Nullable
    public final String getOwner() {
        return Build.VERSION.SDK_INT >= 29 ? this.getColumnInfoString("owner_package_name") : null;
    }

    public final boolean isMine() {
        return Intrinsics.areEqual((Object)this.getOwner(), (Object)this.context.getPackageName());
    }

    @Deprecated(message="Accessing files with java.io.File only works on app private directory since Android 10.")
    @Nullable
    public final File toRawFile() {
        File file;
        if (this.isRawFile()) {
            String string2 = this.uri.getPath();
            if (string2 == null) {
                file = null;
            } else {
                String it = string2;
                boolean bl = false;
                file = new File(it);
            }
        } else {
            file = null;
        }
        return file;
    }

    @Nullable
    public final DocumentFile toDocumentFile() {
        DocumentFile documentFile;
        String it = this.getAbsolutePath();
        boolean bl = false;
        if (((CharSequence)it).length() == 0) {
            documentFile = null;
        } else {
            Context context = this.context;
            Intrinsics.checkNotNullExpressionValue((Object)context, (String)"context");
            documentFile = DocumentFileCompat.fromFullPath$default(context, it, null, false, false, 28, null);
        }
        return documentFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SuppressLint(value={"InlinedApi"})
    @NotNull
    public final String getAbsolutePath() {
        String string2;
        File file = this.toRawFile();
        if (file != null) {
            String string3 = file.getPath();
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"file.path");
            string2 = string3;
        } else if (Build.VERSION.SDK_INT < 29) {
            String string4;
            try {
                String string5;
                Object object = new String[]{"_data"};
                Cursor cursor = this.context.getContentResolver().query(this.uri, object, null, null, null);
                if (cursor == null) {
                    string5 = null;
                } else {
                    object = (Closeable)cursor;
                    Throwable throwable = null;
                    try {
                        Cursor cursor2 = (Cursor)object;
                        boolean bl = false;
                        String string6 = cursor2.moveToFirst() ? cursor2.getString(cursor2.getColumnIndex("_data")) : "";
                        string5 = string6;
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        CloseableKt.closeFinally((Closeable)object, (Throwable)throwable);
                    }
                }
                String string7 = string5;
                if (string5 == null) {
                    string7 = "";
                }
                string4 = string7;
            }
            catch (Exception e) {
                string4 = "";
            }
            string2 = string4;
        } else {
            String string8;
            String[] stringArray = new String[]{"relative_path", "_display_name"};
            String[] projection = stringArray;
            Cursor cursor = this.context.getContentResolver().query(this.uri, projection, null, null, null);
            if (cursor == null) {
                string8 = null;
            } else {
                Closeable closeable = (Closeable)cursor;
                Throwable throwable = null;
                try {
                    String string9;
                    Cursor cursor3 = (Cursor)closeable;
                    boolean bl = false;
                    if (cursor3.moveToFirst()) {
                        String string10;
                        if (cursor3.getString(cursor3.getColumnIndex("relative_path")) == null) {
                            String string11 = "";
                            return string11;
                        }
                        String relativePath = string10;
                        String name = cursor3.getString(cursor3.getColumnIndex("_display_name"));
                        char[] cArray = new char[]{'/'};
                        string9 = TextUtils.replaceCompletely(StringsKt.trimEnd((String)(SimpleStorage.Companion.getExternalStoragePath() + '/' + relativePath + '/' + name), (char[])cArray), "//", "/");
                    } else {
                        string9 = "";
                    }
                    String string12 = string9;
                    string8 = string12;
                }
                catch (Throwable throwable3) {
                    throwable = throwable3;
                    throw throwable3;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
                }
            }
            string2 = string8;
            if (string8 == null) {
                string2 = "";
            }
        }
        return string2;
    }

    @NotNull
    public final String getBasePath() {
        return TextUtils.trimFileSeparator(StringsKt.substringAfter$default((String)this.getAbsolutePath(), (String)SimpleStorage.Companion.getExternalStoragePath(), null, (int)2, null));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SuppressLint(value={"InlinedApi"})
    @NotNull
    public final String getRelativePath() {
        String string2;
        File file = this.toRawFile();
        if (file != null) {
            String string3 = file.getPath();
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"file.path");
            string2 = Intrinsics.stringPlus((String)TextUtils.trimFileSeparator(StringsKt.replaceFirst$default((String)StringsKt.substringBeforeLast$default((String)string3, (char)'/', null, (int)2, null), (String)SimpleStorage.Companion.getExternalStoragePath(), (String)"", (boolean)false, (int)4, null)), (Object)"/");
        } else if (Build.VERSION.SDK_INT < 29) {
            String string4;
            try {
                String string5;
                Object object = new String[]{"_data"};
                Cursor cursor = this.context.getContentResolver().query(this.uri, object, null, null, null);
                if (cursor == null) {
                    string5 = null;
                } else {
                    object = (Closeable)cursor;
                    Throwable throwable = null;
                    try {
                        String string6;
                        Cursor cursor2 = (Cursor)object;
                        boolean bl = false;
                        if (cursor2.moveToFirst()) {
                            String string7 = cursor2.getString(cursor2.getColumnIndex("_data"));
                            Intrinsics.checkNotNullExpressionValue((Object)string7, (String)"cursor.getString(cursor.\u2026Store.MediaColumns.DATA))");
                            String realFolderAbsolutePath = StringsKt.substringBeforeLast$default((String)string7, (char)'/', null, (int)2, null);
                            string6 = Intrinsics.stringPlus((String)TextUtils.trimFileSeparator(StringsKt.replaceFirst$default((String)realFolderAbsolutePath, (String)SimpleStorage.Companion.getExternalStoragePath(), (String)"", (boolean)false, (int)4, null)), (Object)"/");
                        } else {
                            string6 = "";
                        }
                        String string8 = string6;
                        string5 = string8;
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        CloseableKt.closeFinally((Closeable)object, (Throwable)throwable);
                    }
                }
                String string9 = string5;
                if (string5 == null) {
                    string9 = "";
                }
                string4 = string9;
            }
            catch (Exception e) {
                string4 = "";
            }
            string2 = string4;
        } else {
            String string10;
            String[] stringArray = new String[]{"relative_path"};
            String[] projection = stringArray;
            Cursor cursor = this.context.getContentResolver().query(this.uri, projection, null, null, null);
            if (cursor == null) {
                string10 = null;
            } else {
                Closeable closeable = (Closeable)cursor;
                Throwable throwable = null;
                try {
                    Cursor cursor3 = (Cursor)closeable;
                    boolean bl = false;
                    String string11 = cursor3.moveToFirst() ? cursor3.getString(cursor3.getColumnIndex("relative_path")) : "";
                    string10 = string11;
                }
                catch (Throwable throwable3) {
                    throwable = throwable3;
                    throw throwable3;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
                }
            }
            string2 = string10;
            if (string10 == null) {
                string2 = "";
            }
        }
        return string2;
    }

    public final boolean delete() {
        boolean bl;
        File file = this.toRawFile();
        if (file != null) {
            bl = file.delete() || !file.exists();
        } else {
            boolean bl2;
            try {
                bl2 = this.context.getContentResolver().delete(this.uri, null, null) > 0;
            }
            catch (SecurityException e) {
                MediaFile.handleSecurityException$default(this, e, null, 2, null);
                bl2 = false;
            }
            bl = bl2;
        }
        return bl;
    }

    public final boolean renameTo(@NotNull String newName) {
        ContentValues contentValues;
        Intrinsics.checkNotNullParameter((Object)newName, (String)"newName");
        File file = this.toRawFile();
        ContentValues $this$renameTo_u24lambda_u2d10 = contentValues = new ContentValues(1);
        boolean bl = false;
        $this$renameTo_u24lambda_u2d10.put("_display_name", newName);
        ContentValues contentValues2 = contentValues;
        if (file == null) {
            throw new UnsupportedOperationException("Cannot rename media files on Android 10+");
        }
        this.context.getContentResolver().update(this.uri, contentValues2, null, null);
        return file.renameTo(new File(file.getParent(), newName));
    }

    @RequiresApi(value=29)
    public final boolean isPending() {
        return this.getColumnInfoInt("is_pending") == 1;
    }

    @RequiresApi(value=29)
    public final void setPending(boolean value) {
        ContentValues contentValues;
        ContentValues $this$_set_isPending__u24lambda_u2d11 = contentValues = new ContentValues(1);
        boolean bl = false;
        $this$_set_isPending__u24lambda_u2d11.put("is_pending", Integer.valueOf(PrimitivesExtKt.toInt(value)));
        ContentValues contentValues2 = contentValues;
        try {
            this.context.getContentResolver().update(this.uri, contentValues2, null, null);
        }
        catch (SecurityException e) {
            MediaFile.handleSecurityException$default(this, e, null, 2, null);
        }
    }

    private final void handleSecurityException(SecurityException e, FileCallback callback) {
        if (Build.VERSION.SDK_INT >= 29 && e instanceof RecoverableSecurityException) {
            AccessCallback accessCallback = this.accessCallback;
            if (accessCallback != null) {
                IntentSender intentSender = ((RecoverableSecurityException)e).getUserAction().getActionIntent().getIntentSender();
                Intrinsics.checkNotNullExpressionValue((Object)intentSender, (String)"e.userAction.actionIntent.intentSender");
                accessCallback.onWriteAccessDenied(this, intentSender);
            }
        } else {
            FileCallback fileCallback = callback;
            if (fileCallback != null) {
                CoroutineScope coroutineScope = fileCallback.getUiScope();
                if (coroutineScope != null) {
                    CoroutineScope $this$postToUi$iv = coroutineScope;
                    boolean $i$f$postToUi = false;
                    BuildersKt.launch$default((CoroutineScope)$this$postToUi$iv, (CoroutineContext)((CoroutineContext)Dispatchers.getMain()), null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(null, callback){
                        int label;
                        final /* synthetic */ FileCallback $callback$inlined;
                        {
                            this.$callback$inlined = fileCallback;
                            super(2, $completion);
                        }

                        @Nullable
                        public final Object invokeSuspend(@NotNull Object object) {
                            IntrinsicsKt.getCOROUTINE_SUSPENDED();
                            switch (this.label) {
                                case 0: {
                                    ResultKt.throwOnFailure((Object)object);
                                    boolean bl = false;
                                    this.$callback$inlined.onFailed(FileCallback.ErrorCode.STORAGE_PERMISSION_DENIED);
                                    return Unit.INSTANCE;
                                }
                            }
                            throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                        }

                        @NotNull
                        public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                            return (Continuation)new /* invalid duplicate definition of identical inner class */;
                        }

                        @Nullable
                        public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                            return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                        }
                    }), (int)2, null);
                }
            }
        }
    }

    static /* synthetic */ void handleSecurityException$default(MediaFile mediaFile, SecurityException securityException, FileCallback fileCallback, int n, Object object) {
        if ((n & 2) != 0) {
            fileCallback = null;
        }
        mediaFile.handleSecurityException(securityException, fileCallback);
    }

    @UiThread
    @NotNull
    public final Intent openFileIntent(@NotNull String authority) {
        Uri uri;
        Intrinsics.checkNotNullParameter((Object)authority, (String)"authority");
        Intent intent = new Intent("android.intent.action.VIEW");
        if (this.isRawFile()) {
            String string2 = this.uri.getPath();
            Intrinsics.checkNotNull((Object)string2);
            uri = FileProvider.getUriForFile((Context)this.context, (String)authority, (File)new File(string2));
        } else {
            uri = this.uri;
        }
        Intent intent2 = intent.setData(uri).addFlags(1).addFlags(0x10000000);
        Intrinsics.checkNotNullExpressionValue((Object)intent2, (String)"Intent(Intent.ACTION_VIE\u2026t.FLAG_ACTIVITY_NEW_TASK)");
        return intent2;
    }

    @WorkerThread
    @JvmOverloads
    @Nullable
    public final OutputStream openOutputStream(boolean append) {
        OutputStream outputStream;
        try {
            File file = this.toRawFile();
            outputStream = file != null ? (OutputStream)new FileOutputStream(file, append) : this.context.getContentResolver().openOutputStream(this.uri, append ? "wa" : "w");
        }
        catch (IOException e) {
            outputStream = null;
        }
        return outputStream;
    }

    public static /* synthetic */ OutputStream openOutputStream$default(MediaFile mediaFile, boolean bl, int n, Object object) {
        if ((n & 1) != 0) {
            bl = true;
        }
        return mediaFile.openOutputStream(bl);
    }

    @WorkerThread
    @Nullable
    public final InputStream openInputStream() {
        InputStream inputStream;
        try {
            File file = this.toRawFile();
            inputStream = file != null ? (InputStream)new FileInputStream(file) : this.context.getContentResolver().openInputStream(this.uri);
        }
        catch (IOException e) {
            inputStream = null;
        }
        return inputStream;
    }

    @TargetApi(value=29)
    public final boolean moveTo(@NotNull String relativePath) {
        boolean bl;
        ContentValues contentValues;
        Intrinsics.checkNotNullParameter((Object)relativePath, (String)"relativePath");
        ContentValues $this$moveTo_u24lambda_u2d13 = contentValues = new ContentValues(1);
        boolean bl2 = false;
        $this$moveTo_u24lambda_u2d13.put("relative_path", relativePath);
        ContentValues contentValues2 = contentValues;
        try {
            bl = this.context.getContentResolver().update(this.uri, contentValues2, null, null) > 0;
        }
        catch (SecurityException e) {
            MediaFile.handleSecurityException$default(this, e, null, 2, null);
            bl = false;
        }
        return bl;
    }

    /*
     * WARNING - void declaration
     */
    @WorkerThread
    public final void moveTo(@NotNull DocumentFile targetFolder, @Nullable FileDescription fileDescription, @NotNull FileCallback callback) {
        String cleanFileName;
        FileCallback.ConflictResolution conflictResolution;
        String string2;
        String $this$postToUi$iv;
        DocumentFile documentFile;
        Intrinsics.checkNotNullParameter((Object)targetFolder, (String)"targetFolder");
        Intrinsics.checkNotNullParameter((Object)callback, (String)"callback");
        DocumentFile sourceFile = this.toDocumentFile();
        if (sourceFile != null) {
            Context context = this.context;
            Intrinsics.checkNotNullExpressionValue((Object)context, (String)"context");
            DocumentFileUtils.moveFileTo(sourceFile, context, targetFolder, fileDescription, callback);
            return;
        }
        Context context = this.context;
        Intrinsics.checkNotNullExpressionValue((Object)context, (String)"context");
        Context context2 = context;
        context = this.context;
        Intrinsics.checkNotNullExpressionValue((Object)context, (String)"context");
        if (!callback.onCheckFreeSpace(DocumentFileCompat.getFreeSpace(context2, DocumentFileUtils.getStorageId(targetFolder, context)), this.getLength())) {
            CoroutineScope $this$postToUi$iv2 = callback.getUiScope();
            boolean $i$f$postToUi = false;
            BuildersKt.launch$default((CoroutineScope)$this$postToUi$iv2, (CoroutineContext)((CoroutineContext)Dispatchers.getMain()), null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(null, callback){
                int label;
                final /* synthetic */ FileCallback $callback$inlined;
                {
                    this.$callback$inlined = fileCallback;
                    super(2, $completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object object) {
                    IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)object);
                            boolean bl = false;
                            this.$callback$inlined.onFailed(FileCallback.ErrorCode.NO_SPACE_LEFT_ON_TARGET_PATH);
                            return Unit.INSTANCE;
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                @NotNull
                public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                }

                @Nullable
                public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                }
            }), (int)2, null);
            return;
        }
        FileDescription fileDescription2 = fileDescription;
        CharSequence $i$f$postToUi = (CharSequence)(fileDescription2 == null ? null : fileDescription2.getSubFolder());
        if ($i$f$postToUi == null || $i$f$postToUi.length() == 0) {
            documentFile = targetFolder;
        } else {
            DocumentFile directory;
            Context context3 = this.context;
            Intrinsics.checkNotNullExpressionValue((Object)context3, (String)"context");
            FileDescription fileDescription3 = fileDescription;
            String string3 = fileDescription3 == null ? null : fileDescription3.getSubFolder();
            if (string3 == null) {
                string3 = "";
            }
            if ((directory = DocumentFileUtils.makeFolder(targetFolder, context3, string3, CreateMode.REUSE)) == null) {
                $this$postToUi$iv = callback.getUiScope();
                boolean $i$f$postToUi2 = false;
                BuildersKt.launch$default((CoroutineScope)$this$postToUi$iv, (CoroutineContext)((CoroutineContext)Dispatchers.getMain()), null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(null, callback){
                    int label;
                    final /* synthetic */ FileCallback $callback$inlined;
                    {
                        this.$callback$inlined = fileCallback;
                        super(2, $completion);
                    }

                    @Nullable
                    public final Object invokeSuspend(@NotNull Object object) {
                        IntrinsicsKt.getCOROUTINE_SUSPENDED();
                        switch (this.label) {
                            case 0: {
                                ResultKt.throwOnFailure((Object)object);
                                boolean bl = false;
                                this.$callback$inlined.onFailed(FileCallback.ErrorCode.CANNOT_CREATE_FILE_IN_TARGET);
                                return Unit.INSTANCE;
                            }
                        }
                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                    }

                    @NotNull
                    public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                        return (Continuation)new /* invalid duplicate definition of identical inner class */;
                    }

                    @Nullable
                    public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                        return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                    }
                }), (int)2, null);
                return;
            }
            documentFile = directory;
        }
        DocumentFile targetDirectory = documentFile;
        FileDescription fileDescription4 = fileDescription;
        String string4 = $this$postToUi$iv = fileDescription4 == null ? null : fileDescription4.getName();
        if ($this$postToUi$iv == null) {
            string2 = this.getName();
            if (string2 == null) {
                string2 = "";
            }
        } else {
            string2 = $this$postToUi$iv;
        }
        FileDescription fileDescription5 = fileDescription;
        String string5 = fileDescription5 == null ? null : fileDescription5.getMimeType();
        if (string5 == null) {
            string5 = this.getType();
        }
        if ((conflictResolution = this.handleFileConflict(targetDirectory, cleanFileName = TextUtils.trimFileSeparator(DocumentFileCompat.INSTANCE.removeForbiddenCharsFromFilename$storage_release(MimeType.getFullFileName(string2, string5))), callback)) == FileCallback.ConflictResolution.SKIP) {
            return;
        }
        Thread thread = Thread.currentThread();
        CoroutineScope uiScope$iv = callback.getUiScope();
        boolean $i$f$awaitUiResult = false;
        long reportInterval = ((Number)BuildersKt.runBlocking$default(null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Long>, Object>(uiScope$iv, null, callback, this, thread){
            Object L$0;
            Object L$1;
            int label;
            final /* synthetic */ CoroutineScope $uiScope;
            final /* synthetic */ FileCallback $callback$inlined;
            final /* synthetic */ MediaFile this$0;
            final /* synthetic */ Thread $thread$inlined;
            {
                this.$uiScope = $uiScope;
                this.$callback$inlined = fileCallback;
                this.this$0 = mediaFile;
                this.$thread$inlined = thread;
                super(2, $completion);
            }

            /*
             * WARNING - void declaration
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Nullable
            public final Object invokeSuspend(@NotNull Object object) {
                Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        CoroutineScope coroutineScope = this.$uiScope;
                        boolean $i$f$suspendCancellableCoroutine = false;
                        this.L$0 = coroutineScope;
                        this.label = 1;
                        Continuation uCont$iv = (Continuation)this;
                        boolean bl = false;
                        CancellableContinuationImpl cancellable$iv = new CancellableContinuationImpl(IntrinsicsKt.intercepted((Continuation)uCont$iv), 1);
                        cancellable$iv.initCancellability();
                        CancellableContinuation it = (CancellableContinuation)cancellable$iv;
                        boolean bl2 = false;
                        BuildersKt.launch$default((CoroutineScope)coroutineScope, (CoroutineContext)((CoroutineContext)Dispatchers.getMain()), null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(it, null, this.$callback$inlined, this.this$0, this.$thread$inlined){
                            int label;
                            final /* synthetic */ CancellableContinuation $it;
                            final /* synthetic */ FileCallback $callback$inlined;
                            final /* synthetic */ MediaFile this$0;
                            final /* synthetic */ Thread $thread$inlined;
                            {
                                this.$it = $it;
                                this.$callback$inlined = fileCallback;
                                this.this$0 = mediaFile;
                                this.$thread$inlined = thread;
                                super(2, $completion);
                            }

                            @Nullable
                            public final Object invokeSuspend(@NotNull Object object) {
                                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                switch (this.label) {
                                    case 0: {
                                        ResultKt.throwOnFailure((Object)object);
                                        CancellableContinuation cancellableContinuation = this.$it;
                                        boolean bl = false;
                                        Intrinsics.checkNotNullExpressionValue((Object)this.$thread$inlined, (String)"thread");
                                        cancellableContinuation.resumeWith(Result.constructor-impl((Object)Boxing.boxLong((long)this.$callback$inlined.onStart(this.this$0, this.$thread$inlined))));
                                        return Unit.INSTANCE;
                                    }
                                }
                                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                            }

                            @NotNull
                            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                                return (Continuation)new /* invalid duplicate definition of identical inner class */;
                            }

                            @Nullable
                            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                            }
                        }), (int)2, null);
                        Object object3 = cancellable$iv.getResult();
                        if (object3 == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
                            DebugProbesKt.probeCoroutineSuspended((Continuation)((Continuation)this));
                        }
                        Object object4 = object3;
                        if (object3 != object2) return object4;
                        return object2;
                    }
                    case 1: {
                        void $result;
                        boolean $i$f$suspendCancellableCoroutine = false;
                        CoroutineScope cfr_ignored_0 = (CoroutineScope)this.L$0;
                        ResultKt.throwOnFailure((Object)$result);
                        Object object4 = $result;
                        return object4;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            @Nullable
            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Long> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)1, null)).longValue();
        boolean watchProgress = reportInterval > 0L;
        try {
            DocumentFile documentFile2;
            FileDescription fileDescription6 = fileDescription;
            String string6 = fileDescription6 == null ? null : fileDescription6.getMimeType();
            if (string6 == null) {
                string6 = this.getType();
            }
            if ((documentFile2 = this.createTargetFile(targetDirectory, cleanFileName, string6, conflictResolution.toCreateMode(), callback)) == null) {
                return;
            }
            DocumentFile targetFile = documentFile2;
            MediaFile this_$iv = this;
            boolean $i$f$createFileStreams = false;
            Context context4 = this_$iv.context;
            Intrinsics.checkNotNullExpressionValue((Object)context4, (String)"context");
            OutputStream outputStream$iv = DocumentFileUtils.openOutputStream$default(targetFile, context4, false, 2, null);
            if (outputStream$iv == null) {
                CoroutineScope $this$postToUi$iv$iv = callback.getUiScope();
                boolean $i$f$postToUi3 = false;
                BuildersKt.launch$default((CoroutineScope)$this$postToUi$iv$iv, (CoroutineContext)((CoroutineContext)Dispatchers.getMain()), null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(null, callback){
                    int label;
                    final /* synthetic */ FileCallback $callback$inlined;
                    {
                        this.$callback$inlined = fileCallback;
                        super(2, $completion);
                    }

                    @Nullable
                    public final Object invokeSuspend(@NotNull Object object) {
                        IntrinsicsKt.getCOROUTINE_SUSPENDED();
                        switch (this.label) {
                            case 0: {
                                ResultKt.throwOnFailure((Object)object);
                                boolean bl = false;
                                this.$callback$inlined.onFailed(FileCallback.ErrorCode.TARGET_FILE_NOT_FOUND);
                                return Unit.INSTANCE;
                            }
                        }
                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                    }

                    @Nullable
                    public final Object invokeSuspend$$forInline(@NotNull Object $result) {
                        boolean bl = false;
                        this.$callback$inlined.onFailed(FileCallback.ErrorCode.TARGET_FILE_NOT_FOUND);
                        return Unit.INSTANCE;
                    }

                    @NotNull
                    public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                        return (Continuation)new /* invalid duplicate definition of identical inner class */;
                    }

                    @Nullable
                    public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                        return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                    }
                }), (int)2, null);
            } else {
                InputStream inputStream$iv = this_$iv.openInputStream();
                if (inputStream$iv == null) {
                    CoroutineScope $this$postToUi$iv$iv = callback.getUiScope();
                    boolean $i$f$postToUi4 = false;
                    BuildersKt.launch$default((CoroutineScope)$this$postToUi$iv$iv, (CoroutineContext)((CoroutineContext)Dispatchers.getMain()), null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(null, callback){
                        int label;
                        final /* synthetic */ FileCallback $callback$inlined;
                        {
                            this.$callback$inlined = fileCallback;
                            super(2, $completion);
                        }

                        @Nullable
                        public final Object invokeSuspend(@NotNull Object object) {
                            IntrinsicsKt.getCOROUTINE_SUSPENDED();
                            switch (this.label) {
                                case 0: {
                                    ResultKt.throwOnFailure((Object)object);
                                    boolean bl = false;
                                    this.$callback$inlined.onFailed(FileCallback.ErrorCode.SOURCE_FILE_NOT_FOUND);
                                    return Unit.INSTANCE;
                                }
                            }
                            throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                        }

                        @Nullable
                        public final Object invokeSuspend$$forInline(@NotNull Object $result) {
                            boolean bl = false;
                            this.$callback$inlined.onFailed(FileCallback.ErrorCode.SOURCE_FILE_NOT_FOUND);
                            return Unit.INSTANCE;
                        }

                        @NotNull
                        public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                            return (Continuation)new /* invalid duplicate definition of identical inner class */;
                        }

                        @Nullable
                        public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                            return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                        }
                    }), (int)2, null);
                    IOUtils.closeStreamQuietly(outputStream$iv);
                } else {
                    void outputStream;
                    OutputStream outputStream2 = outputStream$iv;
                    InputStream inputStream = inputStream$iv;
                    boolean bl = false;
                    this.copyFileStream(inputStream, (OutputStream)outputStream, targetFile, watchProgress, reportInterval, true, callback);
                }
            }
        }
        catch (SecurityException e) {
            this.handleSecurityException(e, callback);
        }
        catch (Exception e) {
            CoroutineScope $this$postToUi$iv3 = callback.getUiScope();
            boolean $i$f$postToUi5 = false;
            BuildersKt.launch$default((CoroutineScope)$this$postToUi$iv3, (CoroutineContext)((CoroutineContext)Dispatchers.getMain()), null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(null, callback, e){
                int label;
                final /* synthetic */ FileCallback $callback$inlined;
                final /* synthetic */ Exception $e$inlined;
                {
                    this.$callback$inlined = fileCallback;
                    this.$e$inlined = exception;
                    super(2, $completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object object) {
                    IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)object);
                            boolean bl = false;
                            this.$callback$inlined.onFailed(DocumentFileUtils.toFileCallbackErrorCode(this.$e$inlined));
                            return Unit.INSTANCE;
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                @NotNull
                public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                }

                @Nullable
                public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                }
            }), (int)2, null);
        }
    }

    public static /* synthetic */ void moveTo$default(MediaFile mediaFile, DocumentFile documentFile, FileDescription fileDescription, FileCallback fileCallback, int n, Object object) {
        if ((n & 2) != 0) {
            fileDescription = null;
        }
        mediaFile.moveTo(documentFile, fileDescription, fileCallback);
    }

    /*
     * WARNING - void declaration
     */
    @WorkerThread
    public final void copyTo(@NotNull DocumentFile targetFolder, @Nullable FileDescription fileDescription, @NotNull FileCallback callback) {
        String cleanFileName;
        FileCallback.ConflictResolution conflictResolution;
        String string2;
        String $this$postToUi$iv;
        DocumentFile documentFile;
        Intrinsics.checkNotNullParameter((Object)targetFolder, (String)"targetFolder");
        Intrinsics.checkNotNullParameter((Object)callback, (String)"callback");
        DocumentFile sourceFile = this.toDocumentFile();
        if (sourceFile != null) {
            Context context = this.context;
            Intrinsics.checkNotNullExpressionValue((Object)context, (String)"context");
            DocumentFileUtils.copyFileTo(sourceFile, context, targetFolder, fileDescription, callback);
            return;
        }
        Context context = this.context;
        Intrinsics.checkNotNullExpressionValue((Object)context, (String)"context");
        Context context2 = context;
        context = this.context;
        Intrinsics.checkNotNullExpressionValue((Object)context, (String)"context");
        if (!callback.onCheckFreeSpace(DocumentFileCompat.getFreeSpace(context2, DocumentFileUtils.getStorageId(targetFolder, context)), this.getLength())) {
            CoroutineScope $this$postToUi$iv2 = callback.getUiScope();
            boolean $i$f$postToUi = false;
            BuildersKt.launch$default((CoroutineScope)$this$postToUi$iv2, (CoroutineContext)((CoroutineContext)Dispatchers.getMain()), null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(null, callback){
                int label;
                final /* synthetic */ FileCallback $callback$inlined;
                {
                    this.$callback$inlined = fileCallback;
                    super(2, $completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object object) {
                    IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)object);
                            boolean bl = false;
                            this.$callback$inlined.onFailed(FileCallback.ErrorCode.NO_SPACE_LEFT_ON_TARGET_PATH);
                            return Unit.INSTANCE;
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                @NotNull
                public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                }

                @Nullable
                public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                }
            }), (int)2, null);
            return;
        }
        FileDescription fileDescription2 = fileDescription;
        CharSequence $i$f$postToUi = (CharSequence)(fileDescription2 == null ? null : fileDescription2.getSubFolder());
        if ($i$f$postToUi == null || $i$f$postToUi.length() == 0) {
            documentFile = targetFolder;
        } else {
            DocumentFile directory;
            Context context3 = this.context;
            Intrinsics.checkNotNullExpressionValue((Object)context3, (String)"context");
            FileDescription fileDescription3 = fileDescription;
            String string3 = fileDescription3 == null ? null : fileDescription3.getSubFolder();
            if (string3 == null) {
                string3 = "";
            }
            if ((directory = DocumentFileUtils.makeFolder(targetFolder, context3, string3, CreateMode.REUSE)) == null) {
                $this$postToUi$iv = callback.getUiScope();
                boolean $i$f$postToUi2 = false;
                BuildersKt.launch$default((CoroutineScope)$this$postToUi$iv, (CoroutineContext)((CoroutineContext)Dispatchers.getMain()), null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(null, callback){
                    int label;
                    final /* synthetic */ FileCallback $callback$inlined;
                    {
                        this.$callback$inlined = fileCallback;
                        super(2, $completion);
                    }

                    @Nullable
                    public final Object invokeSuspend(@NotNull Object object) {
                        IntrinsicsKt.getCOROUTINE_SUSPENDED();
                        switch (this.label) {
                            case 0: {
                                ResultKt.throwOnFailure((Object)object);
                                boolean bl = false;
                                this.$callback$inlined.onFailed(FileCallback.ErrorCode.CANNOT_CREATE_FILE_IN_TARGET);
                                return Unit.INSTANCE;
                            }
                        }
                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                    }

                    @NotNull
                    public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                        return (Continuation)new /* invalid duplicate definition of identical inner class */;
                    }

                    @Nullable
                    public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                        return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                    }
                }), (int)2, null);
                return;
            }
            documentFile = directory;
        }
        DocumentFile targetDirectory = documentFile;
        FileDescription fileDescription4 = fileDescription;
        String string4 = $this$postToUi$iv = fileDescription4 == null ? null : fileDescription4.getName();
        if ($this$postToUi$iv == null) {
            string2 = this.getName();
            if (string2 == null) {
                string2 = "";
            }
        } else {
            string2 = $this$postToUi$iv;
        }
        FileDescription fileDescription5 = fileDescription;
        String string5 = fileDescription5 == null ? null : fileDescription5.getMimeType();
        if (string5 == null) {
            string5 = this.getType();
        }
        if ((conflictResolution = this.handleFileConflict(targetDirectory, cleanFileName = TextUtils.trimFileSeparator(DocumentFileCompat.INSTANCE.removeForbiddenCharsFromFilename$storage_release(MimeType.getFullFileName(string2, string5))), callback)) == FileCallback.ConflictResolution.SKIP) {
            return;
        }
        Thread thread = Thread.currentThread();
        CoroutineScope uiScope$iv = callback.getUiScope();
        boolean $i$f$awaitUiResult = false;
        long reportInterval = ((Number)BuildersKt.runBlocking$default(null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Long>, Object>(uiScope$iv, null, callback, this, thread){
            Object L$0;
            Object L$1;
            int label;
            final /* synthetic */ CoroutineScope $uiScope;
            final /* synthetic */ FileCallback $callback$inlined;
            final /* synthetic */ MediaFile this$0;
            final /* synthetic */ Thread $thread$inlined;
            {
                this.$uiScope = $uiScope;
                this.$callback$inlined = fileCallback;
                this.this$0 = mediaFile;
                this.$thread$inlined = thread;
                super(2, $completion);
            }

            /*
             * WARNING - void declaration
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Nullable
            public final Object invokeSuspend(@NotNull Object object) {
                Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        CoroutineScope coroutineScope = this.$uiScope;
                        boolean $i$f$suspendCancellableCoroutine = false;
                        this.L$0 = coroutineScope;
                        this.label = 1;
                        Continuation uCont$iv = (Continuation)this;
                        boolean bl = false;
                        CancellableContinuationImpl cancellable$iv = new CancellableContinuationImpl(IntrinsicsKt.intercepted((Continuation)uCont$iv), 1);
                        cancellable$iv.initCancellability();
                        CancellableContinuation it = (CancellableContinuation)cancellable$iv;
                        boolean bl2 = false;
                        BuildersKt.launch$default((CoroutineScope)coroutineScope, (CoroutineContext)((CoroutineContext)Dispatchers.getMain()), null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(it, null, this.$callback$inlined, this.this$0, this.$thread$inlined){
                            int label;
                            final /* synthetic */ CancellableContinuation $it;
                            final /* synthetic */ FileCallback $callback$inlined;
                            final /* synthetic */ MediaFile this$0;
                            final /* synthetic */ Thread $thread$inlined;
                            {
                                this.$it = $it;
                                this.$callback$inlined = fileCallback;
                                this.this$0 = mediaFile;
                                this.$thread$inlined = thread;
                                super(2, $completion);
                            }

                            @Nullable
                            public final Object invokeSuspend(@NotNull Object object) {
                                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                switch (this.label) {
                                    case 0: {
                                        ResultKt.throwOnFailure((Object)object);
                                        CancellableContinuation cancellableContinuation = this.$it;
                                        boolean bl = false;
                                        Intrinsics.checkNotNullExpressionValue((Object)this.$thread$inlined, (String)"thread");
                                        cancellableContinuation.resumeWith(Result.constructor-impl((Object)Boxing.boxLong((long)this.$callback$inlined.onStart(this.this$0, this.$thread$inlined))));
                                        return Unit.INSTANCE;
                                    }
                                }
                                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                            }

                            @NotNull
                            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                                return (Continuation)new /* invalid duplicate definition of identical inner class */;
                            }

                            @Nullable
                            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                            }
                        }), (int)2, null);
                        Object object3 = cancellable$iv.getResult();
                        if (object3 == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
                            DebugProbesKt.probeCoroutineSuspended((Continuation)((Continuation)this));
                        }
                        Object object4 = object3;
                        if (object3 != object2) return object4;
                        return object2;
                    }
                    case 1: {
                        void $result;
                        boolean $i$f$suspendCancellableCoroutine = false;
                        CoroutineScope cfr_ignored_0 = (CoroutineScope)this.L$0;
                        ResultKt.throwOnFailure((Object)$result);
                        Object object4 = $result;
                        return object4;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            @Nullable
            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Long> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)1, null)).longValue();
        boolean watchProgress = reportInterval > 0L;
        try {
            DocumentFile documentFile2;
            FileDescription fileDescription6 = fileDescription;
            String string6 = fileDescription6 == null ? null : fileDescription6.getMimeType();
            if (string6 == null) {
                string6 = this.getType();
            }
            if ((documentFile2 = this.createTargetFile(targetDirectory, cleanFileName, string6, conflictResolution.toCreateMode(), callback)) == null) {
                return;
            }
            DocumentFile targetFile = documentFile2;
            MediaFile this_$iv = this;
            boolean $i$f$createFileStreams = false;
            Context context4 = this_$iv.context;
            Intrinsics.checkNotNullExpressionValue((Object)context4, (String)"context");
            OutputStream outputStream$iv = DocumentFileUtils.openOutputStream$default(targetFile, context4, false, 2, null);
            if (outputStream$iv == null) {
                CoroutineScope $this$postToUi$iv$iv = callback.getUiScope();
                boolean $i$f$postToUi3 = false;
                BuildersKt.launch$default((CoroutineScope)$this$postToUi$iv$iv, (CoroutineContext)((CoroutineContext)Dispatchers.getMain()), null, (Function2)((Function2)new /* invalid duplicate definition of identical inner class */), (int)2, null);
            } else {
                InputStream inputStream$iv = this_$iv.openInputStream();
                if (inputStream$iv == null) {
                    CoroutineScope $this$postToUi$iv$iv = callback.getUiScope();
                    boolean $i$f$postToUi4 = false;
                    BuildersKt.launch$default((CoroutineScope)$this$postToUi$iv$iv, (CoroutineContext)((CoroutineContext)Dispatchers.getMain()), null, (Function2)((Function2)new /* invalid duplicate definition of identical inner class */), (int)2, null);
                    IOUtils.closeStreamQuietly(outputStream$iv);
                } else {
                    void outputStream;
                    OutputStream outputStream2 = outputStream$iv;
                    InputStream inputStream = inputStream$iv;
                    boolean bl = false;
                    this.copyFileStream(inputStream, (OutputStream)outputStream, targetFile, watchProgress, reportInterval, false, callback);
                }
            }
        }
        catch (SecurityException e) {
            this.handleSecurityException(e, callback);
        }
        catch (Exception e) {
            CoroutineScope $this$postToUi$iv3 = callback.getUiScope();
            boolean $i$f$postToUi5 = false;
            BuildersKt.launch$default((CoroutineScope)$this$postToUi$iv3, (CoroutineContext)((CoroutineContext)Dispatchers.getMain()), null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(null, callback, e){
                int label;
                final /* synthetic */ FileCallback $callback$inlined;
                final /* synthetic */ Exception $e$inlined;
                {
                    this.$callback$inlined = fileCallback;
                    this.$e$inlined = exception;
                    super(2, $completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object object) {
                    IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)object);
                            boolean bl = false;
                            this.$callback$inlined.onFailed(DocumentFileUtils.toFileCallbackErrorCode(this.$e$inlined));
                            return Unit.INSTANCE;
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                @NotNull
                public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                }

                @Nullable
                public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                }
            }), (int)2, null);
        }
    }

    public static /* synthetic */ void copyTo$default(MediaFile mediaFile, DocumentFile documentFile, FileDescription fileDescription, FileCallback fileCallback, int n, Object object) {
        if ((n & 2) != 0) {
            fileDescription = null;
        }
        mediaFile.copyTo(documentFile, fileDescription, fileCallback);
    }

    private final DocumentFile createTargetFile(DocumentFile targetDirectory, String fileName, String mimeType, CreateMode mode, FileCallback callback) {
        try {
            Context context = this.context;
            Intrinsics.checkNotNullExpressionValue((Object)context, (String)"context");
            Context context2 = context;
            context = this.context;
            Intrinsics.checkNotNullExpressionValue((Object)context, (String)"context");
            String string2 = DocumentFileUtils.getStorageId(targetDirectory, context);
            context = this.context;
            Intrinsics.checkNotNullExpressionValue((Object)context, (String)"context");
            String absolutePath = DocumentFileCompat.buildAbsolutePath(context2, string2, DocumentFileUtils.getBasePath(targetDirectory, context));
            Context context3 = this.context;
            Intrinsics.checkNotNullExpressionValue((Object)context3, (String)"context");
            DocumentFile targetFolder = DocumentFileCompat.mkdirs$default(context3, absolutePath, false, false, 12, null);
            if (targetFolder == null) {
                CoroutineScope $this$postToUi$iv = callback.getUiScope();
                boolean $i$f$postToUi = false;
                BuildersKt.launch$default((CoroutineScope)$this$postToUi$iv, (CoroutineContext)((CoroutineContext)Dispatchers.getMain()), null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(null, callback){
                    int label;
                    final /* synthetic */ FileCallback $callback$inlined;
                    {
                        this.$callback$inlined = fileCallback;
                        super(2, $completion);
                    }

                    @Nullable
                    public final Object invokeSuspend(@NotNull Object object) {
                        IntrinsicsKt.getCOROUTINE_SUSPENDED();
                        switch (this.label) {
                            case 0: {
                                ResultKt.throwOnFailure((Object)object);
                                boolean bl = false;
                                this.$callback$inlined.onFailed(FileCallback.ErrorCode.STORAGE_PERMISSION_DENIED);
                                return Unit.INSTANCE;
                            }
                        }
                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                    }

                    @NotNull
                    public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                        return (Continuation)new /* invalid duplicate definition of identical inner class */;
                    }

                    @Nullable
                    public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                        return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                    }
                }), (int)2, null);
                return null;
            }
            Context $i$f$postToUi = this.context;
            Intrinsics.checkNotNullExpressionValue((Object)$i$f$postToUi, (String)"context");
            DocumentFile targetFile = DocumentFileUtils.makeFile(targetFolder, $i$f$postToUi, fileName, mimeType, mode);
            if (targetFile != null) {
                return targetFile;
            }
            CoroutineScope $this$postToUi$iv = callback.getUiScope();
            boolean $i$f$postToUi2 = false;
            BuildersKt.launch$default((CoroutineScope)$this$postToUi$iv, (CoroutineContext)((CoroutineContext)Dispatchers.getMain()), null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(null, callback){
                int label;
                final /* synthetic */ FileCallback $callback$inlined;
                {
                    this.$callback$inlined = fileCallback;
                    super(2, $completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object object) {
                    IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)object);
                            boolean bl = false;
                            this.$callback$inlined.onFailed(FileCallback.ErrorCode.CANNOT_CREATE_FILE_IN_TARGET);
                            return Unit.INSTANCE;
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                @NotNull
                public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                }

                @Nullable
                public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                }
            }), (int)2, null);
        }
        catch (SecurityException e) {
            this.handleSecurityException(e, callback);
        }
        catch (Exception e) {
            CoroutineScope $this$postToUi$iv = callback.getUiScope();
            boolean $i$f$postToUi = false;
            BuildersKt.launch$default((CoroutineScope)$this$postToUi$iv, (CoroutineContext)((CoroutineContext)Dispatchers.getMain()), null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(null, callback, e){
                int label;
                final /* synthetic */ FileCallback $callback$inlined;
                final /* synthetic */ Exception $e$inlined;
                {
                    this.$callback$inlined = fileCallback;
                    this.$e$inlined = exception;
                    super(2, $completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object object) {
                    IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)object);
                            boolean bl = false;
                            this.$callback$inlined.onFailed(DocumentFileUtils.toFileCallbackErrorCode(this.$e$inlined));
                            return Unit.INSTANCE;
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                @NotNull
                public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                }

                @Nullable
                public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                }
            }), (int)2, null);
        }
        return null;
    }

    private final void createFileStreams(DocumentFile targetFile, FileCallback callback, Function2<? super InputStream, ? super OutputStream, Unit> onStreamsReady) {
        boolean $i$f$createFileStreams = false;
        Context context = this.context;
        Intrinsics.checkNotNullExpressionValue((Object)context, (String)"context");
        OutputStream outputStream = DocumentFileUtils.openOutputStream$default(targetFile, context, false, 2, null);
        if (outputStream == null) {
            CoroutineScope $this$postToUi$iv = callback.getUiScope();
            boolean $i$f$postToUi = false;
            BuildersKt.launch$default((CoroutineScope)$this$postToUi$iv, (CoroutineContext)((CoroutineContext)Dispatchers.getMain()), null, (Function2)((Function2)new /* invalid duplicate definition of identical inner class */), (int)2, null);
            return;
        }
        InputStream inputStream = this.openInputStream();
        if (inputStream == null) {
            CoroutineScope $this$postToUi$iv = callback.getUiScope();
            boolean $i$f$postToUi = false;
            BuildersKt.launch$default((CoroutineScope)$this$postToUi$iv, (CoroutineContext)((CoroutineContext)Dispatchers.getMain()), null, (Function2)((Function2)new /* invalid duplicate definition of identical inner class */), (int)2, null);
            IOUtils.closeStreamQuietly(outputStream);
            return;
        }
        onStreamsReady.invoke((Object)inputStream, (Object)outputStream);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void copyFileStream(InputStream inputStream, OutputStream outputStream, DocumentFile targetFile, boolean watchProgress, long reportInterval, boolean deleteSourceFileWhenComplete, FileCallback callback) {
        Job job;
        Job timer2 = null;
        try {
            Ref.LongRef bytesMoved = new Ref.LongRef();
            Ref.IntRef writeSpeed = new Ref.IntRef();
            long srcSize = this.getLength();
            if (watchProgress && srcSize > 0xA00000L) {
                timer2 = CoroutineExtKt.startCoroutineTimer$default(0L, reportInterval, false, (Function0)new Function0<Unit>(bytesMoved, srcSize, writeSpeed, callback){
                    final /* synthetic */ Ref.LongRef $bytesMoved;
                    final /* synthetic */ long $srcSize;
                    final /* synthetic */ Ref.IntRef $writeSpeed;
                    final /* synthetic */ FileCallback $callback;
                    {
                        this.$bytesMoved = $bytesMoved;
                        this.$srcSize = $srcSize;
                        this.$writeSpeed = $writeSpeed;
                        this.$callback = $callback;
                        super(0);
                    }

                    /*
                     * WARNING - void declaration
                     */
                    public final void invoke() {
                        void $this$postToUi$iv;
                        FileCallback.Report report = new FileCallback.Report((float)this.$bytesMoved.element * 100.0f / (float)this.$srcSize, this.$bytesMoved.element, this.$writeSpeed.element);
                        CoroutineScope coroutineScope = this.$callback.getUiScope();
                        FileCallback fileCallback = this.$callback;
                        boolean $i$f$postToUi = false;
                        BuildersKt.launch$default((CoroutineScope)$this$postToUi$iv, (CoroutineContext)((CoroutineContext)Dispatchers.getMain()), null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(null, fileCallback, report){
                            int label;
                            final /* synthetic */ FileCallback $callback$inlined;
                            final /* synthetic */ FileCallback.Report $report$inlined;
                            {
                                this.$callback$inlined = fileCallback;
                                this.$report$inlined = report;
                                super(2, $completion);
                            }

                            @Nullable
                            public final Object invokeSuspend(@NotNull Object object) {
                                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                switch (this.label) {
                                    case 0: {
                                        ResultKt.throwOnFailure((Object)object);
                                        boolean bl = false;
                                        this.$callback$inlined.onReport(this.$report$inlined);
                                        return Unit.INSTANCE;
                                    }
                                }
                                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                            }

                            @NotNull
                            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                                return (Continuation)new /* invalid duplicate definition of identical inner class */;
                            }

                            @Nullable
                            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                            }
                        }), (int)2, null);
                        this.$writeSpeed.element = 0;
                    }
                }, 5, null);
            }
            byte[] buffer = new byte[8192];
            int read = inputStream.read(buffer);
            while (read != -1) {
                outputStream.write(buffer, 0, read);
                bytesMoved.element += (long)read;
                writeSpeed.element += read;
                read = inputStream.read(buffer);
            }
            Job job2 = timer2;
            if (job2 != null) {
                Job.DefaultImpls.cancel$default(job2, null, (int)1, null);
            }
            if (deleteSourceFileWhenComplete) {
                this.delete();
            }
            CoroutineScope $this$postToUi$iv = callback.getUiScope();
            boolean $i$f$postToUi = false;
            BuildersKt.launch$default((CoroutineScope)$this$postToUi$iv, (CoroutineContext)((CoroutineContext)Dispatchers.getMain()), null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(null, callback, targetFile){
                int label;
                final /* synthetic */ FileCallback $callback$inlined;
                final /* synthetic */ DocumentFile $targetFile$inlined;
                {
                    this.$callback$inlined = fileCallback;
                    this.$targetFile$inlined = documentFile;
                    super(2, $completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object object) {
                    IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)object);
                            boolean bl = false;
                            this.$callback$inlined.onCompleted(this.$targetFile$inlined);
                            return Unit.INSTANCE;
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                @NotNull
                public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                }

                @Nullable
                public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                }
            }), (int)2, null);
            job = timer2;
        }
        catch (Throwable throwable) {
            Job job3 = timer2;
            if (job3 != null) {
                Job.DefaultImpls.cancel$default(job3, null, (int)1, null);
            }
            IOUtils.closeStreamQuietly(inputStream);
            IOUtils.closeStreamQuietly(outputStream);
            throw throwable;
        }
        if (job != null) {
            Job.DefaultImpls.cancel$default((Job)job, null, (int)1, null);
        }
        IOUtils.closeStreamQuietly(inputStream);
        IOUtils.closeStreamQuietly(outputStream);
    }

    private final FileCallback.ConflictResolution handleFileConflict(DocumentFile targetFolder, String fileName, FileCallback callback) {
        Context context = this.context;
        Intrinsics.checkNotNullExpressionValue((Object)context, (String)"context");
        DocumentFile documentFile = DocumentFileUtils.child$default(targetFolder, context, fileName, false, 4, null);
        if (documentFile != null) {
            DocumentFile targetFile = documentFile;
            boolean bl = false;
            CoroutineScope uiScope$iv = callback.getUiScope();
            boolean $i$f$awaitUiResultWithPending = false;
            FileCallback.ConflictResolution resolution = (FileCallback.ConflictResolution)((Object)BuildersKt.runBlocking$default(null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super FileCallback.ConflictResolution>, Object>(uiScope$iv, null, callback, targetFile){
                Object L$0;
                Object L$1;
                int label;
                final /* synthetic */ CoroutineScope $uiScope;
                final /* synthetic */ FileCallback $callback$inlined;
                final /* synthetic */ DocumentFile $targetFile$inlined;
                {
                    this.$uiScope = $uiScope;
                    this.$callback$inlined = fileCallback;
                    this.$targetFile$inlined = documentFile;
                    super(2, $completion);
                }

                /*
                 * WARNING - void declaration
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                @Nullable
                public final Object invokeSuspend(@NotNull Object object) {
                    Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)object);
                            CoroutineScope coroutineScope = this.$uiScope;
                            boolean $i$f$suspendCancellableCoroutine = false;
                            this.L$0 = coroutineScope;
                            this.label = 1;
                            Continuation uCont$iv = (Continuation)this;
                            boolean bl = false;
                            CancellableContinuationImpl cancellable$iv = new CancellableContinuationImpl(IntrinsicsKt.intercepted((Continuation)uCont$iv), 1);
                            cancellable$iv.initCancellability();
                            CancellableContinuation it = (CancellableContinuation)cancellable$iv;
                            boolean bl2 = false;
                            BuildersKt.launch$default((CoroutineScope)coroutineScope, (CoroutineContext)((CoroutineContext)Dispatchers.getMain()), null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(it, null, this.$callback$inlined, this.$targetFile$inlined){
                                int label;
                                final /* synthetic */ CancellableContinuation $it;
                                final /* synthetic */ FileCallback $callback$inlined;
                                final /* synthetic */ DocumentFile $targetFile$inlined;
                                {
                                    this.$it = $it;
                                    this.$callback$inlined = fileCallback;
                                    this.$targetFile$inlined = documentFile;
                                    super(2, $completion);
                                }

                                @Nullable
                                public final Object invokeSuspend(@NotNull Object object) {
                                    IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                    switch (this.label) {
                                        case 0: {
                                            ResultKt.throwOnFailure((Object)object);
                                            CancellableContinuation it = this.$it;
                                            boolean bl = false;
                                            this.$callback$inlined.onConflict(this.$targetFile$inlined, new FileCallback.FileConflictAction((CancellableContinuation<? super FileCallback.ConflictResolution>)it));
                                            return Unit.INSTANCE;
                                        }
                                    }
                                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                                }

                                @NotNull
                                public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                                }

                                @Nullable
                                public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                                }
                            }), (int)2, null);
                            Object object3 = cancellable$iv.getResult();
                            if (object3 == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
                                DebugProbesKt.probeCoroutineSuspended((Continuation)((Continuation)this));
                            }
                            Object object4 = object3;
                            if (object3 != object2) return object4;
                            return object2;
                        }
                        case 1: {
                            void $result;
                            boolean $i$f$suspendCancellableCoroutine = false;
                            CoroutineScope cfr_ignored_0 = (CoroutineScope)this.L$0;
                            ResultKt.throwOnFailure((Object)$result);
                            Object object4 = $result;
                            return object4;
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                @NotNull
                public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                }

                @Nullable
                public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super FileCallback.ConflictResolution> p2) {
                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                }
            }), (int)1, null));
            if (resolution == FileCallback.ConflictResolution.REPLACE) {
                uiScope$iv = this.context;
                Intrinsics.checkNotNullExpressionValue((Object)uiScope$iv, (String)"context");
                if (!DocumentFileUtils.forceDelete$default(targetFile, (Context)uiScope$iv, false, 2, null)) {
                    CoroutineScope $this$postToUi$iv = callback.getUiScope();
                    boolean $i$f$postToUi = false;
                    BuildersKt.launch$default((CoroutineScope)$this$postToUi$iv, (CoroutineContext)((CoroutineContext)Dispatchers.getMain()), null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(null, callback){
                        int label;
                        final /* synthetic */ FileCallback $callback$inlined;
                        {
                            this.$callback$inlined = fileCallback;
                            super(2, $completion);
                        }

                        @Nullable
                        public final Object invokeSuspend(@NotNull Object object) {
                            IntrinsicsKt.getCOROUTINE_SUSPENDED();
                            switch (this.label) {
                                case 0: {
                                    ResultKt.throwOnFailure((Object)object);
                                    boolean bl = false;
                                    this.$callback$inlined.onFailed(FileCallback.ErrorCode.CANNOT_CREATE_FILE_IN_TARGET);
                                    return Unit.INSTANCE;
                                }
                            }
                            throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                        }

                        @NotNull
                        public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                            return (Continuation)new /* invalid duplicate definition of identical inner class */;
                        }

                        @Nullable
                        public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                            return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                        }
                    }), (int)2, null);
                    return FileCallback.ConflictResolution.SKIP;
                }
            }
            return resolution;
        }
        return FileCallback.ConflictResolution.CREATE_NEW;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final String getColumnInfoString(String column) {
        Object object = new String[]{column};
        Cursor cursor = this.context.getContentResolver().query(this.uri, object, null, null, null);
        if (cursor != null) {
            object = (Closeable)cursor;
            Throwable throwable = null;
            try {
                int columnIndex;
                Cursor cursor2 = (Cursor)object;
                boolean bl = false;
                if (cursor2.moveToFirst() && (columnIndex = cursor2.getColumnIndex(column)) != -1) {
                    String string2 = cursor2.getString(columnIndex);
                    return string2;
                }
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)object, (Throwable)throwable);
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final long getColumnInfoLong(String column) {
        Object object = new String[]{column};
        Cursor cursor = this.context.getContentResolver().query(this.uri, object, null, null, null);
        if (cursor != null) {
            object = (Closeable)cursor;
            Throwable throwable = null;
            try {
                int columnIndex;
                Cursor cursor2 = (Cursor)object;
                boolean bl = false;
                if (cursor2.moveToFirst() && (columnIndex = cursor2.getColumnIndex(column)) != -1) {
                    long l = cursor2.getLong(columnIndex);
                    return l;
                }
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)object, (Throwable)throwable);
            }
        }
        return 0L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final int getColumnInfoInt(String column) {
        Object object = new String[]{column};
        Cursor cursor = this.context.getContentResolver().query(this.uri, object, null, null, null);
        if (cursor != null) {
            object = (Closeable)cursor;
            Throwable throwable = null;
            try {
                int columnIndex;
                Cursor cursor2 = (Cursor)object;
                boolean bl = false;
                if (cursor2.moveToFirst() && (columnIndex = cursor2.getColumnIndex(column)) != -1) {
                    int n = cursor2.getInt(columnIndex);
                    return n;
                }
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)object, (Throwable)throwable);
            }
        }
        return 0;
    }

    public boolean equals(@Nullable Object other) {
        return other == this || other instanceof MediaFile && Intrinsics.areEqual((Object)((MediaFile)other).uri, (Object)this.uri);
    }

    public int hashCode() {
        return this.uri.hashCode();
    }

    @NotNull
    public String toString() {
        String string2 = this.uri.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"uri.toString()");
        return string2;
    }

    @WorkerThread
    @JvmOverloads
    @Nullable
    public final OutputStream openOutputStream() {
        return MediaFile.openOutputStream$default(this, false, 1, null);
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\bf\u0018\u00002\u00020\u0001J\u0018\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H&\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\b\u00c0\u0006\u0001"}, d2={"Lcom/anggrayudi/storage/media/MediaFile$AccessCallback;", "", "onWriteAccessDenied", "", "mediaFile", "Lcom/anggrayudi/storage/media/MediaFile;", "sender", "Landroid/content/IntentSender;", "storage_release"})
    public static interface AccessCallback {
        public void onWriteAccessDenied(@NotNull MediaFile var1, @NotNull IntentSender var2);
    }
}

