/*
 * Decompiled with CFR 0.152.
 */
package com.applovin.impl.mediation;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.os.Bundle;
import android.text.TextUtils;
import android.util.Log;
import android.view.ViewGroup;
import androidx.annotation.Nullable;
import androidx.lifecycle.Lifecycle;
import com.applovin.impl.mediation.MaxAdapterParametersImpl;
import com.applovin.impl.mediation.MaxErrorImpl;
import com.applovin.impl.mediation.a.c;
import com.applovin.impl.mediation.a.e;
import com.applovin.impl.mediation.a.g;
import com.applovin.impl.mediation.a.h;
import com.applovin.impl.mediation.ads.a;
import com.applovin.impl.mediation.b.d;
import com.applovin.impl.mediation.b.f;
import com.applovin.impl.mediation.b.g;
import com.applovin.impl.sdk.AppLovinBroadcastManager;
import com.applovin.impl.sdk.d.b;
import com.applovin.impl.sdk.f.o;
import com.applovin.impl.sdk.f.z;
import com.applovin.impl.sdk.n;
import com.applovin.impl.sdk.utils.BundleUtils;
import com.applovin.impl.sdk.utils.CollectionUtils;
import com.applovin.impl.sdk.utils.StringUtils;
import com.applovin.impl.sdk.utils.Utils;
import com.applovin.impl.sdk.utils.k;
import com.applovin.impl.sdk.w;
import com.applovin.mediation.MaxAd;
import com.applovin.mediation.MaxAdFormat;
import com.applovin.mediation.MaxAdListener;
import com.applovin.mediation.MaxAdRevenueListener;
import com.applovin.mediation.MaxAdViewAdListener;
import com.applovin.mediation.MaxError;
import com.applovin.mediation.MaxReward;
import com.applovin.mediation.MaxRewardedAdListener;
import com.applovin.mediation.adapter.MaxAdapter;
import com.applovin.mediation.adapter.MaxAdapterError;
import com.applovin.mediation.adapter.listeners.MaxSignalCollectionListener;
import com.applovin.sdk.AppLovinSdkUtils;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import org.json.JSONObject;

public class MediationServiceImpl
implements AppLovinBroadcastManager.Receiver {
    private final n a;
    private final w b;
    private final AtomicReference<JSONObject> c = new AtomicReference();

    public MediationServiceImpl(n n2) {
        this.a = n2;
        this.b = n2.C();
        n2.al().registerReceiver(this, new IntentFilter("com.applovin.render_process_gone"));
    }

    public void loadAd(String string2, @Nullable String string3, MaxAdFormat maxAdFormat, Map<String, Object> map, Map<String, Object> map2, Context context, a.a a2) {
        if (TextUtils.isEmpty((CharSequence)string2)) {
            throw new IllegalArgumentException("No ad unit ID specified");
        }
        if (context == null) {
            throw new IllegalArgumentException("No context specified");
        }
        if (a2 == null) {
            throw new IllegalArgumentException("No listener specified");
        }
        if (TextUtils.isEmpty((CharSequence)this.a.t())) {
            w.i("AppLovinSdk", "Mediation provider is null. Please set AppLovin SDK mediation provider via AppLovinSdk.getInstance(context).setMediationProvider()");
        }
        if (!this.a.d()) {
            w.h("AppLovinSdk", "Attempted to load ad before SDK initialization. Please wait until after the SDK has initialized, e.g. AppLovinSdk.initializeSdk(Context, SdkInitializationListener).");
        }
        this.a.a();
        if (string2.length() != 16 && !string2.startsWith("test_mode") && !this.a.B().startsWith("05TMD")) {
            w.i("MediationService", "Please double-check the ad unit " + string2 + " for " + maxAdFormat.getLabel() + " : " + Log.getStackTraceString((Throwable)new Throwable("")));
        }
        if (this.a.a(maxAdFormat)) {
            w.i("MediationService", "Ad load failed due to disabled ad format " + maxAdFormat.getLabel());
            MaxErrorImpl maxErrorImpl = new MaxErrorImpl(-1, "Disabled ad format " + maxAdFormat.getLabel());
            k.a((MaxAdListener)a2, string2, (MaxError)maxErrorImpl);
            return;
        }
        k.a(a2, string2, true);
        this.a.L().a(string2, string3, maxAdFormat, map, map2, context, a2);
    }

    public void showFullscreenAd(final c c2, final Activity activity, final a.a a2) {
        if (c2 == null) {
            throw new IllegalArgumentException("No ad specified");
        }
        if (activity == null && MaxAdFormat.APP_OPEN != c2.getFormat()) {
            throw new IllegalArgumentException("No activity specified");
        }
        this.a.ag().a(true);
        final com.applovin.impl.mediation.g g2 = this.a(c2);
        long l2 = c2.D();
        MediationServiceImpl mediationServiceImpl = this;
        if (mediationServiceImpl.b.a()) {
            this.b.c("MediationService", "Showing ad " + c2.getAdUnitId() + " with delay of " + l2 + "ms...");
        }
        AppLovinSdkUtils.runOnUiThreadDelayed(new Runnable(){

            @Override
            public void run() {
                c2.a(true);
                MediationServiceImpl.this.b(c2);
                g2.a(c2, activity);
                MediationServiceImpl.this.a(c2, a2);
            }
        }, l2);
    }

    public void showFullscreenAd(final c c2, final ViewGroup viewGroup, final Lifecycle lifecycle, final Activity activity, final a.a a2) {
        if (c2 == null) {
            throw new IllegalArgumentException("No ad specified");
        }
        if (activity == null) {
            throw new IllegalArgumentException("No activity specified");
        }
        this.a.ag().a(true);
        final com.applovin.impl.mediation.g g2 = this.a(c2);
        long l2 = c2.D();
        MediationServiceImpl mediationServiceImpl = this;
        if (mediationServiceImpl.b.a()) {
            this.b.c("MediationService", "Showing ad " + c2.getAdUnitId() + " with delay of " + l2 + "ms...");
        }
        AppLovinSdkUtils.runOnUiThreadDelayed(new Runnable(){

            @Override
            public void run() {
                c2.a(true);
                MediationServiceImpl.this.b(c2);
                g2.a(c2, viewGroup, lifecycle, activity);
                MediationServiceImpl.this.a(c2, a2);
            }
        }, l2);
    }

    private com.applovin.impl.mediation.g a(c c2) {
        com.applovin.impl.mediation.g g2 = c2.g();
        if (g2 == null) {
            this.a.ag().a(false);
            MediationServiceImpl mediationServiceImpl = this;
            if (mediationServiceImpl.b.a()) {
                this.b.d("MediationService", "Failed to show " + c2 + ": adapter not found");
            }
            w.i("MediationService", "There may be an integration problem with the adapter for ad unit id '" + c2.getAdUnitId() + "'. Please check if you have a supported version of that SDK integrated into your project.");
            throw new IllegalStateException("Could not find adapter for provided ad");
        }
        return g2;
    }

    private void b(c c2) {
        if (c2.getFormat() == MaxAdFormat.REWARDED || c2.getFormat() == MaxAdFormat.REWARDED_INTERSTITIAL) {
            g g2 = new g(c2, this.a);
            this.a.U().a(g2, o.a.s);
        }
    }

    private void a(c c2, a.a a2) {
        this.a.ag().a(false);
        this.a(c2, (MaxAdListener)a2);
        MediationServiceImpl mediationServiceImpl = this;
        if (mediationServiceImpl.b.a()) {
            this.b.b("MediationService", "Scheduling impression for ad manually...");
        }
        this.processRawAdImpressionPostback(c2, a2);
        this.a.am().a(c2);
        if (c2.v().get()) {
            MediationServiceImpl mediationServiceImpl2 = this;
            if (mediationServiceImpl2.b.a()) {
                this.b.b("MediationService", "Running ad displayed logic");
            }
            this.a.ai().a(c2, "DID_DISPLAY");
            this.a.ag().a(c2);
            k.b(a2, (MaxAd)c2, true);
        }
    }

    public void destroyAd(MaxAd maxAd) {
        com.applovin.impl.mediation.a.a a2;
        com.applovin.impl.mediation.g g2;
        if (!(maxAd instanceof com.applovin.impl.mediation.a.a)) {
            return;
        }
        MediationServiceImpl mediationServiceImpl = this;
        if (mediationServiceImpl.b.a()) {
            this.b.c("MediationService", "Destroying " + maxAd);
        }
        if ((g2 = (a2 = (com.applovin.impl.mediation.a.a)maxAd).g()) != null) {
            g2.j();
            a2.x();
        }
        this.a.D().b(a2.f());
    }

    public void loadThirdPartyMediatedAd(String string2, com.applovin.impl.mediation.a.a a2, Activity activity, a.a a3) {
        if (a2 == null) {
            throw new IllegalArgumentException("No mediated ad specified");
        }
        MediationServiceImpl mediationServiceImpl = this;
        if (mediationServiceImpl.b.a()) {
            this.b.b("MediationService", "Loading " + a2 + "...");
        }
        this.a.ai().a(a2, "WILL_LOAD");
        com.applovin.impl.mediation.g g2 = this.a.E().a(a2);
        if (g2 != null) {
            MaxAdapterParametersImpl maxAdapterParametersImpl = MaxAdapterParametersImpl.a(a2);
            if (this.a.a(com.applovin.impl.sdk.d.a.S).booleanValue()) {
                this.a.F().a(a2, activity);
            }
            com.applovin.impl.mediation.a.a a4 = a2.a(g2);
            g2.a(string2, a4);
            a4.s();
            g2.a(string2, maxAdapterParametersImpl, a4, activity, new a(a4, a3));
        } else {
            String string3 = "Failed to load " + a2 + ": adapter not loaded";
            w.i("MediationService", string3);
            MaxErrorImpl maxErrorImpl = new MaxErrorImpl(-5001, string3);
            this.a(a2, maxErrorImpl, a3);
        }
    }

    public void collectSignal(MaxAdFormat maxAdFormat, final h h2, Context context, final g.a a2) {
        if (h2 == null) {
            throw new IllegalArgumentException("No spec specified");
        }
        if (context == null) {
            throw new IllegalArgumentException("No context specified");
        }
        if (a2 == null) {
            throw new IllegalArgumentException("No callback specified");
        }
        boolean bl = h2.b();
        final com.applovin.impl.mediation.g g2 = this.a.E().a(h2, bl);
        if (g2 != null) {
            Activity activity = context instanceof Activity ? (Activity)context : this.a.aq();
            MaxAdapterParametersImpl maxAdapterParametersImpl = MaxAdapterParametersImpl.a(h2, maxAdFormat);
            if (this.a.a(com.applovin.impl.sdk.d.a.R).booleanValue()) {
                this.a.F().a(h2, activity);
            }
            MaxSignalCollectionListener maxSignalCollectionListener = new MaxSignalCollectionListener(){

                @Override
                public void onSignalCollected(String string2) {
                    a2.a(com.applovin.impl.mediation.a.g.a(h2, g2, string2));
                    g2.j();
                }

                @Override
                public void onSignalCollectionFailed(String string2) {
                    MediationServiceImpl.this.a(string2, h2, g2);
                    a2.a(com.applovin.impl.mediation.a.g.b(h2, g2, string2));
                    g2.j();
                }
            };
            if (h2.a()) {
                if (this.a.F().a(h2)) {
                    MediationServiceImpl mediationServiceImpl = this;
                    if (mediationServiceImpl.b.a()) {
                        this.b.b("MediationService", "Collecting signal for now-initialized adapter: " + g2.d());
                    }
                    g2.a(maxAdapterParametersImpl, h2, activity, maxSignalCollectionListener);
                } else {
                    MediationServiceImpl mediationServiceImpl = this;
                    if (mediationServiceImpl.b.a()) {
                        this.b.e("MediationService", "Skip collecting signal for not-initialized adapter: " + g2.d());
                    }
                    a2.a(com.applovin.impl.mediation.a.g.a(h2, "Adapter not initialized yet"));
                }
            } else {
                MediationServiceImpl mediationServiceImpl = this;
                if (mediationServiceImpl.b.a()) {
                    this.b.b("MediationService", "Collecting signal for adapter: " + g2.d());
                }
                g2.a(maxAdapterParametersImpl, h2, activity, maxSignalCollectionListener);
            }
        } else {
            a2.a(com.applovin.impl.mediation.a.g.a(h2, "Could not load adapter"));
        }
    }

    private void a(final c c2, final MaxAdListener maxAdListener) {
        final long l2 = this.a.a(com.applovin.impl.sdk.d.a.G);
        if (l2 <= 0L) {
            return;
        }
        AppLovinSdkUtils.runOnUiThreadDelayed(new Runnable(){

            @Override
            public void run() {
                if (c2.v().get()) {
                    return;
                }
                String string2 = "Ad (" + c2.R() + ") has not been displayed after " + l2 + "ms. Failing ad display...";
                w.i("MediationService", string2);
                MaxErrorImpl maxErrorImpl = new MaxErrorImpl(-1, string2);
                MediationServiceImpl.this.b(c2, maxErrorImpl, maxAdListener);
                MediationServiceImpl.this.a.ag().b(c2);
                MediationServiceImpl.this.a.am().a();
            }
        }, l2);
    }

    public void setCustomPostBodyData(JSONObject jSONObject) {
        this.c.set(jSONObject);
    }

    public JSONObject getAndResetCustomPostBodyData() {
        return this.c.getAndSet(null);
    }

    private void a(com.applovin.impl.mediation.a.a a2, MaxError maxError, MaxAdListener maxAdListener) {
        this.a(maxError, a2);
        this.destroyAd(a2);
        k.a(maxAdListener, a2.getAdUnitId(), maxError);
    }

    private void b(com.applovin.impl.mediation.a.a a2, MaxError maxError, MaxAdListener maxAdListener) {
        if (a2.l() != null) {
            MediationServiceImpl mediationServiceImpl = this;
            if (mediationServiceImpl.b.a()) {
                this.b.e("MediationService", "Ignoring ad display failure for hybrid ad...");
            }
            return;
        }
        this.a.ai().a(a2, "DID_FAIL_DISPLAY");
        this.processAdDisplayErrorPostback(maxError, a2);
        if (a2.v().compareAndSet(false, true)) {
            k.a(maxAdListener, (MaxAd)a2, maxError);
        }
    }

    public void processAdLossPostback(com.applovin.impl.mediation.a.a a2, @Nullable Float f2) {
        String string2 = f2 != null ? f2.toString() : "";
        Map<String, String> map = CollectionUtils.map(1);
        map.put("{MBR}", string2);
        this.a("mloss", map, a2);
    }

    private void a(com.applovin.impl.mediation.a.a a2) {
        this.a.ai().a(a2, "DID_LOAD");
        if (a2.d().endsWith("load")) {
            this.a.ai().a(a2);
        }
        long l2 = a2.r();
        Map<String, String> map = CollectionUtils.map(1);
        map.put("{LOAD_TIME_MS}", String.valueOf(l2));
        this.a("load", map, a2);
    }

    private void a(MaxError maxError, com.applovin.impl.mediation.a.a a2) {
        long l2 = a2.r();
        Map<String, String> map = CollectionUtils.map(1);
        map.put("{LOAD_TIME_MS}", String.valueOf(l2));
        this.a("mlerr", map, maxError, a2);
    }

    public void processAdapterInitializationPostback(com.applovin.impl.mediation.a.f f2, long l2, MaxAdapter.InitializationStatus initializationStatus, String string2) {
        Map<String, String> map = CollectionUtils.map(2);
        map.put("{INIT_STATUS}", String.valueOf(initializationStatus.getCode()));
        map.put("{INIT_TIME_MS}", String.valueOf(l2));
        this.a("minit", map, new MaxErrorImpl(string2), f2);
    }

    public void processRawAdImpressionPostback(final com.applovin.impl.mediation.a.a a2, final a.a a3) {
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                Object object;
                MediationServiceImpl.this.a.ai().a(a2, "WILL_DISPLAY");
                if (a2.d().endsWith("mimp")) {
                    MediationServiceImpl.this.a.ai().a(a2);
                    k.a(a3, (MaxAd)a2);
                }
                Map<String, Object> map = CollectionUtils.map(2);
                if (a2 instanceof c) {
                    object = (c)a2;
                    map.put("{TIME_TO_SHOW_MS}", String.valueOf(((c)object).C()));
                }
                object = StringUtils.emptyIfNull(MediationServiceImpl.this.a.m());
                map.put("{CUID}", MediationServiceImpl.this.a.a(com.applovin.impl.sdk.d.b.dE) != false ? object : "");
                MediationServiceImpl.this.a("mimp", map, a2);
            }
        };
        if (this.a.a(com.applovin.impl.sdk.d.a.V).booleanValue()) {
            this.a.U().a(new z(this.a, runnable), o.a.m);
        } else {
            runnable.run();
        }
    }

    public void processViewabilityAdImpressionPostback(final e e2, final long l2, final a.a a2) {
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                if (e2.d().endsWith("vimp")) {
                    MediationServiceImpl.this.a.ai().a(e2);
                    k.a(a2, (MaxAd)e2);
                }
                Map<String, String> map = CollectionUtils.map(3);
                map.put("{VIEWABILITY_FLAGS}", String.valueOf(l2));
                map.put("{USED_VIEWABILITY_TIMER}", String.valueOf(e2.L()));
                String string2 = StringUtils.emptyIfNull(MediationServiceImpl.this.a.m());
                map.put("{CUID}", MediationServiceImpl.this.a.a(com.applovin.impl.sdk.d.b.dE) != false ? string2 : "");
                MediationServiceImpl.this.a("mvimp", map, e2);
            }
        };
        if (this.a.a(com.applovin.impl.sdk.d.a.V).booleanValue()) {
            this.a.U().a(new z(this.a, runnable), o.a.m);
        } else {
            runnable.run();
        }
    }

    public void processCallbackAdImpressionPostback(final com.applovin.impl.mediation.a.a a2, final a.a a3) {
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                if (a2.d().endsWith("cimp")) {
                    MediationServiceImpl.this.a.ai().a(a2);
                    k.a(a3, (MaxAd)a2);
                }
                Map<String, String> map = CollectionUtils.map(1);
                String string2 = StringUtils.emptyIfNull(MediationServiceImpl.this.a.m());
                map.put("{CUID}", MediationServiceImpl.this.a.a(com.applovin.impl.sdk.d.b.dE) != false ? string2 : "");
                MediationServiceImpl.this.a("mcimp", map, a2);
            }
        };
        if (this.a.a(com.applovin.impl.sdk.d.a.V).booleanValue()) {
            this.a.U().a(new z(this.a, runnable), o.a.m);
        } else {
            runnable.run();
        }
    }

    private void a(final com.applovin.impl.mediation.a.a a2, final a.a a3) {
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                MediationServiceImpl.this.a.ai().a(a2, "DID_CLICKED");
                MediationServiceImpl.this.a.ai().a(a2, "DID_CLICK");
                if (a2.d().endsWith("click")) {
                    MediationServiceImpl.this.a.ai().a(a2);
                    k.a(a3, (MaxAd)a2);
                }
                Map<String, String> map = CollectionUtils.map(1);
                String string2 = StringUtils.emptyIfNull(MediationServiceImpl.this.a.m());
                map.put("{CUID}", MediationServiceImpl.this.a.a(com.applovin.impl.sdk.d.b.dE) != false ? string2 : "");
                MediationServiceImpl.this.a("mclick", map, a2);
            }
        };
        if (this.a.a(com.applovin.impl.sdk.d.a.V).booleanValue()) {
            this.a.U().a(new z(this.a, runnable), o.a.m);
        } else {
            runnable.run();
        }
    }

    public void processAdDisplayErrorPostback(MaxError maxError, com.applovin.impl.mediation.a.a a2) {
        this.a("mierr", Collections.EMPTY_MAP, maxError, a2);
    }

    private void a(String string2, h h2, com.applovin.impl.mediation.g g2) {
        Map<String, String> map = CollectionUtils.map(2);
        Utils.putObjectForStringIfValid("{ADAPTER_VERSION}", g2.i(), map);
        Utils.putObjectForStringIfValid("{SDK_VERSION}", g2.h(), map);
        this.a("serr", map, new MaxErrorImpl(string2), h2);
    }

    private void a(String string2, Map<String, String> map, com.applovin.impl.mediation.a.f f2) {
        this.a(string2, map, null, f2);
    }

    private void a(String string2, Map<String, String> map, MaxError maxError, com.applovin.impl.mediation.a.f f2) {
        Object object;
        Map<String, String> map2 = CollectionUtils.map(map);
        map2.put("{PLACEMENT}", StringUtils.emptyIfNull(f2.getPlacement()));
        map2.put("{CUSTOM_DATA}", StringUtils.emptyIfNull(f2.ae()));
        if (f2 instanceof com.applovin.impl.mediation.a.a) {
            object = (com.applovin.impl.mediation.a.a)f2;
            map2.put("{CREATIVE_ID}", StringUtils.emptyIfNull(((com.applovin.impl.mediation.a.a)object).getCreativeId()));
        }
        object = new d(string2, map2, maxError, f2, this.a);
        this.a.U().a((com.applovin.impl.sdk.f.a)object, o.a.m);
    }

    @Override
    public void onReceive(Context context, Intent intent, @Nullable Map<String, Object> map) {
        Object object;
        if ("com.applovin.render_process_gone".equals(intent.getAction()) && (object = this.a.ag().c()) instanceof com.applovin.impl.mediation.a.a) {
            com.applovin.impl.mediation.a.a a2 = (com.applovin.impl.mediation.a.a)object;
            this.processAdDisplayErrorPostback(MaxAdapterError.WEBVIEW_ERROR, a2);
        }
    }

    public class a
    implements a.a,
    MaxAdListener,
    MaxAdRevenueListener,
    MaxAdViewAdListener,
    MaxRewardedAdListener {
        private final com.applovin.impl.mediation.a.a b;
        private a.a c;

        public a(com.applovin.impl.mediation.a.a a2, a.a a3) {
            this.b = a2;
            this.c = a3;
        }

        public void a(a.a a2) {
            this.c = a2;
        }

        @Override
        public void onAdLoaded(MaxAd maxAd) {
            this.a(maxAd, null);
        }

        public void a(MaxAd maxAd, @Nullable Bundle bundle) {
            this.b.u();
            this.b.a(bundle);
            MediationServiceImpl.this.a(this.b);
            k.a(this.c, maxAd);
        }

        @Override
        public void onAdLoadFailed(String string2, MaxError maxError) {
            this.b.u();
            MediationServiceImpl.this.a(this.b, maxError, this.c);
        }

        @Override
        public void onAdDisplayed(MaxAd maxAd) {
            this.b(maxAd, null);
        }

        public void b(MaxAd maxAd, @Nullable Bundle bundle) {
            MediationServiceImpl.this.b;
            if (w.a()) {
                MediationServiceImpl.this.b.b("MediationService", "Scheduling impression for ad via callback...");
            }
            MediationServiceImpl.this.processCallbackAdImpressionPostback(this.b, this.c);
            MediationServiceImpl.this.a.V().a(com.applovin.impl.sdk.e.f.c);
            MediationServiceImpl.this.a.V().a(com.applovin.impl.sdk.e.f.f);
            this.b.a(bundle);
            if (maxAd.getFormat().isFullscreenAd()) {
                c c2 = (c)maxAd;
                if (c2.M()) {
                    MediationServiceImpl.this.a.ai().a(this.b, "DID_DISPLAY");
                    MediationServiceImpl.this.a.ag().a(this.b);
                    k.b(this.c, maxAd);
                } else {
                    MediationServiceImpl.this.b;
                    if (w.a()) {
                        MediationServiceImpl.this.b.d("MediationService", "Received ad display callback before attempting show" + (c2.l() != null ? " for hybrid ad" : ""));
                    }
                }
            } else {
                MediationServiceImpl.this.a.ai().a(this.b, "DID_DISPLAY");
                k.b(this.c, maxAd);
            }
        }

        @Override
        public void onAdHidden(MaxAd maxAd) {
            this.c(maxAd, null);
        }

        public void c(final MaxAd maxAd, @Nullable Bundle bundle) {
            if (bundle != null && bundle.size() > 0) {
                Bundle bundle2 = bundle.getBundle("ad_values");
                ((com.applovin.impl.mediation.a.a)maxAd).a(BundleUtils.toJSONObject(bundle2));
            }
            MediationServiceImpl.this.a.ai().a((com.applovin.impl.mediation.a.a)maxAd, "DID_HIDE");
            long l2 = 0L;
            if (maxAd instanceof c) {
                l2 = ((c)maxAd).E();
            }
            AppLovinSdkUtils.runOnUiThreadDelayed(new Runnable(){

                @Override
                public void run() {
                    if (maxAd.getFormat().isFullscreenAd()) {
                        MediationServiceImpl.this.a.ag().b(maxAd);
                        MediationServiceImpl.this.a.am().a();
                    }
                    k.c(a.this.c, maxAd);
                }
            }, l2);
        }

        @Override
        public void onAdClicked(MaxAd maxAd) {
            this.d(maxAd, null);
        }

        public void d(MaxAd maxAd, @Nullable Bundle bundle) {
            if (bundle != null && bundle.size() > 0) {
                Bundle bundle2 = bundle.getBundle("ad_values");
                ((com.applovin.impl.mediation.a.a)maxAd).a(BundleUtils.toJSONObject(bundle2));
            }
            MediationServiceImpl.this.a(this.b, this.c);
            k.d(this.c, maxAd);
        }

        @Override
        public void onAdDisplayFailed(MaxAd maxAd, MaxError maxError) {
            MediationServiceImpl.this.b(this.b, maxError, this.c);
            if ((maxAd.getFormat() == MaxAdFormat.REWARDED || maxAd.getFormat() == MaxAdFormat.REWARDED_INTERSTITIAL) && maxAd instanceof c) {
                ((c)maxAd).J();
            }
        }

        @Override
        public void onRewardedVideoStarted(MaxAd maxAd) {
            k.e(this.c, maxAd);
        }

        @Override
        public void onRewardedVideoCompleted(MaxAd maxAd) {
            k.f(this.c, maxAd);
        }

        @Override
        public void onUserRewarded(MaxAd maxAd, MaxReward maxReward) {
            k.a((MaxAdListener)this.c, maxAd, maxReward);
            f f2 = new f((c)maxAd, MediationServiceImpl.this.a);
            MediationServiceImpl.this.a.U().a(f2, o.a.s);
        }

        @Override
        public void onAdRevenuePaid(MaxAd maxAd) {
        }

        @Override
        public void onAdExpanded(MaxAd maxAd) {
            k.g(this.c, maxAd);
        }

        @Override
        public void onAdCollapsed(MaxAd maxAd) {
            k.h(this.c, maxAd);
        }

        @Override
        public void onAdRequestStarted(String string2) {
        }
    }
}

