/*
 * Decompiled with CFR 0.152.
 */
package com.applovin.exoplayer2.common.base;

import com.applovin.exoplayer2.common.base.Preconditions;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.checkerframework.checker.nullness.compatqual.NullableDecl;

public final class Strings {
    private Strings() {
    }

    public static String padStart(String string2, int n2, char c2) {
        Preconditions.checkNotNull(string2);
        if (string2.length() >= n2) {
            return string2;
        }
        StringBuilder stringBuilder = new StringBuilder(n2);
        for (int i2 = string2.length(); i2 < n2; ++i2) {
            stringBuilder.append(c2);
        }
        stringBuilder.append(string2);
        return stringBuilder.toString();
    }

    public static String padEnd(String string2, int n2, char c2) {
        Preconditions.checkNotNull(string2);
        if (string2.length() >= n2) {
            return string2;
        }
        StringBuilder stringBuilder = new StringBuilder(n2);
        stringBuilder.append(string2);
        for (int i2 = string2.length(); i2 < n2; ++i2) {
            stringBuilder.append(c2);
        }
        return stringBuilder.toString();
    }

    public static String repeat(String string2, int n2) {
        int n3;
        Preconditions.checkNotNull(string2);
        if (n2 <= 1) {
            Preconditions.checkArgument(n2 >= 0, "invalid count: %s", n2);
            return n2 == 0 ? "" : string2;
        }
        int n4 = string2.length();
        long l2 = (long)n4 * (long)n2;
        int n5 = (int)l2;
        if ((long)n5 != l2) {
            throw new ArrayIndexOutOfBoundsException("Required array size too large: " + l2);
        }
        char[] cArray = new char[n5];
        string2.getChars(0, n4, cArray, 0);
        for (n3 = n4; n3 < n5 - n3; n3 <<= 1) {
            System.arraycopy(cArray, 0, cArray, n3, n3);
        }
        System.arraycopy(cArray, 0, cArray, n3, n5 - n3);
        return new String(cArray);
    }

    public static String commonPrefix(CharSequence charSequence, CharSequence charSequence2) {
        int n2;
        Preconditions.checkNotNull(charSequence);
        Preconditions.checkNotNull(charSequence2);
        int n3 = Math.min(charSequence.length(), charSequence2.length());
        for (n2 = 0; n2 < n3 && charSequence.charAt(n2) == charSequence2.charAt(n2); ++n2) {
        }
        if (Strings.validSurrogatePairAt(charSequence, n2 - 1) || Strings.validSurrogatePairAt(charSequence2, n2 - 1)) {
            --n2;
        }
        return charSequence.subSequence(0, n2).toString();
    }

    public static String commonSuffix(CharSequence charSequence, CharSequence charSequence2) {
        int n2;
        Preconditions.checkNotNull(charSequence);
        Preconditions.checkNotNull(charSequence2);
        int n3 = Math.min(charSequence.length(), charSequence2.length());
        for (n2 = 0; n2 < n3 && charSequence.charAt(charSequence.length() - n2 - 1) == charSequence2.charAt(charSequence2.length() - n2 - 1); ++n2) {
        }
        if (Strings.validSurrogatePairAt(charSequence, charSequence.length() - n2 - 1) || Strings.validSurrogatePairAt(charSequence2, charSequence2.length() - n2 - 1)) {
            --n2;
        }
        return charSequence.subSequence(charSequence.length() - n2, charSequence.length()).toString();
    }

    static boolean validSurrogatePairAt(CharSequence charSequence, int n2) {
        return n2 >= 0 && n2 <= charSequence.length() - 2 && Character.isHighSurrogate(charSequence.charAt(n2)) && Character.isLowSurrogate(charSequence.charAt(n2 + 1));
    }

    public static String lenientFormat(@NullableDecl String string2, Object ... objectArray) {
        int n2;
        string2 = String.valueOf(string2);
        if (objectArray == null) {
            objectArray = new Object[]{"(Object[])null"};
        } else {
            for (int i2 = 0; i2 < objectArray.length; ++i2) {
                objectArray[i2] = Strings.lenientToString(objectArray[i2]);
            }
        }
        StringBuilder stringBuilder = new StringBuilder(string2.length() + 16 * objectArray.length);
        int n3 = 0;
        int n4 = 0;
        while (n4 < objectArray.length && (n2 = string2.indexOf("%s", n3)) != -1) {
            stringBuilder.append(string2, n3, n2);
            stringBuilder.append(objectArray[n4++]);
            n3 = n2 + 2;
        }
        stringBuilder.append(string2, n3, string2.length());
        if (n4 < objectArray.length) {
            stringBuilder.append(" [");
            stringBuilder.append(objectArray[n4++]);
            while (n4 < objectArray.length) {
                stringBuilder.append(", ");
                stringBuilder.append(objectArray[n4++]);
            }
            stringBuilder.append(']');
        }
        return stringBuilder.toString();
    }

    private static String lenientToString(@NullableDecl Object object) {
        try {
            return String.valueOf(object);
        }
        catch (Exception exception) {
            String string2 = object.getClass().getName() + '@' + Integer.toHexString(System.identityHashCode(object));
            Logger.getLogger("com.applovin.exoplayer2.common.base.Strings").log(Level.WARNING, "Exception during lenientFormat for " + string2, exception);
            return "<" + string2 + " threw " + exception.getClass().getName() + ">";
        }
    }
}

