/*
 * Decompiled with CFR 0.152.
 */
package com.applovin.impl.sdk.array;

import android.app.Activity;
import android.content.ComponentName;
import android.content.Intent;
import android.content.ServiceConnection;
import android.content.pm.ResolveInfo;
import android.os.Bundle;
import android.os.IBinder;
import android.os.RemoteException;
import androidx.annotation.Nullable;
import com.applovin.array.apphub.aidl.IAppHubDirectDownloadServiceCallback;
import com.applovin.array.apphub.aidl.IAppHubService;
import com.applovin.impl.sdk.array.ArrayDataCollector;
import com.applovin.impl.sdk.array.ArrayDirectDownloadAd;
import com.applovin.impl.sdk.p;
import com.applovin.impl.sdk.utils.a;
import com.applovin.impl.sdk.y;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;

public class ArrayService
extends IAppHubDirectDownloadServiceCallback.Stub {
    private static final String TAG = "ArrayService";
    private static final String SERVICE_INTENT_FILTER_ACTION = "com.applovin.am.intent.action.APPHUB_SERVICE";
    private static final String SERVICE_INTENT_CLASS_NAME = "com.applovin.oem.am.android.external.AppHubService";
    private static final int MAX_RECONNECT_RETRY_COUNT = 3;
    private int currentRetryCount;
    private final p sdk;
    private final y logger;
    private final ArrayDataCollector dataCollector;
    @Nullable
    private final Intent appHubServiceIntent;
    @Nullable
    private IAppHubService appHubService;
    private long appHubVersionCode = -1L;
    private boolean isDirectDownloadEnabled;
    @Nullable
    private String randomUserToken;
    @Nullable
    private DirectDownloadState currentDownloadState;

    public ArrayService(p p2) {
        this.sdk = p2;
        this.logger = p2.J();
        this.dataCollector = new ArrayDataCollector(p2);
        this.appHubServiceIntent = this.createAppHubServiceIntent();
        if (this.appHubServiceIntent != null) {
            this.bindAppHubService();
        }
        p2.v().a(new a(){

            @Override
            public void onActivityStopped(Activity activity) {
                block4: {
                    DirectDownloadState directDownloadState = ArrayService.this.currentDownloadState;
                    if (!ArrayService.this.isAppHubInstalled() || directDownloadState == null) {
                        return;
                    }
                    try {
                        ArrayService.this.logger;
                        if (y.a()) {
                            ArrayService.this.logger.b(ArrayService.TAG, "Dismissing Direct Download Activity");
                        }
                        ArrayService.this.appHubService.dismissDirectDownloadAppDetails(directDownloadState.adToken);
                        directDownloadState.listener.onAppDetailsDismissed();
                        ArrayService.this.currentDownloadState = null;
                    }
                    catch (RemoteException remoteException) {
                        ArrayService.this.logger;
                        if (!y.a()) break block4;
                        ArrayService.this.logger.b(ArrayService.TAG, "Failed dismiss Direct Download Activity", remoteException);
                    }
                }
            }
        });
    }

    public void startDirectInstallOrDownloadProcess(ArrayDirectDownloadAd arrayDirectDownloadAd, DirectDownloadListener directDownloadListener) {
        if (!this.isAppHubInstalled()) {
            ArrayService arrayService = this;
            if (arrayService.logger.a()) {
                this.logger.e(TAG, "Cannot begin Direct Install / Download process - service disconnected");
            }
            directDownloadListener.onFailure();
            return;
        }
        if (!arrayDirectDownloadAd.isDirectDownloadEnabled()) {
            ArrayService arrayService = this;
            if (arrayService.logger.a()) {
                this.logger.e(TAG, "Cannot begin Direct Install / Download process - missing token");
            }
            directDownloadListener.onFailure();
            return;
        }
        try {
            this.currentDownloadState = new DirectDownloadState(arrayDirectDownloadAd.getDirectDownloadToken(), arrayDirectDownloadAd.getDirectDownloadParameters(), directDownloadListener);
            if (this.appHubVersionCode >= 33L && this.isOneClickDownloadEnabled()) {
                ArrayService arrayService = this;
                if (arrayService.logger.a()) {
                    this.logger.b(TAG, "Starting Direct Install process");
                }
                this.appHubService.directInstall(this.currentDownloadState.adToken, this.currentDownloadState.parameters, this);
                ArrayService arrayService2 = this;
                if (arrayService2.logger.a()) {
                    this.logger.b(TAG, "Direct Install started");
                }
            } else {
                ArrayService arrayService = this;
                if (arrayService.logger.a()) {
                    this.logger.b(TAG, "Starting Direct Download Activity");
                }
                if (this.appHubVersionCode >= 21L) {
                    this.appHubService.showDirectDownloadAppDetailsWithExtra(this.currentDownloadState.adToken, this.currentDownloadState.parameters, this);
                } else {
                    this.appHubService.showDirectDownloadAppDetails(this.currentDownloadState.adToken, this);
                }
                ArrayService arrayService3 = this;
                if (arrayService3.logger.a()) {
                    this.logger.b(TAG, "Activity started");
                }
            }
        }
        catch (Throwable throwable) {
            ArrayService arrayService = this;
            if (arrayService.logger.a()) {
                this.logger.b(TAG, "Failed to begin Direct Install / Download process", throwable);
            }
            this.currentDownloadState = null;
            directDownloadListener.onFailure();
        }
    }

    public void collectAppHubData() {
        if (!this.isAppHubInstalled()) {
            return;
        }
        ArrayService arrayService = this;
        if (arrayService.logger.a()) {
            this.logger.b(TAG, "Collecting data...");
        }
        this.appHubVersionCode = this.dataCollector.maybeCollectAppHubVersionCode(this.appHubService);
        this.isDirectDownloadEnabled = this.dataCollector.maybeCollectDirectDownloadEnabled(this.appHubService);
        this.randomUserToken = this.dataCollector.maybeCollectRandomUserToken(this.appHubService);
    }

    @Override
    public void onError(String string2, String string3) {
        DirectDownloadState directDownloadState;
        ArrayService arrayService = this;
        if (arrayService.logger.a()) {
            this.logger.e(TAG, "Encountered error: " + string3);
        }
        if ((directDownloadState = this.currentDownloadState) == null) {
            return;
        }
        if (directDownloadState.errorCallbackInvoked.compareAndSet(false, true)) {
            directDownloadState.listener.onFailure();
            this.currentDownloadState = null;
        }
    }

    @Override
    public void onAppDetailsShown(String string2) {
        DirectDownloadState directDownloadState;
        ArrayService arrayService = this;
        if (arrayService.logger.a()) {
            this.logger.b(TAG, "App details shown");
        }
        if ((directDownloadState = this.currentDownloadState) == null) {
            return;
        }
        directDownloadState.listener.onAppDetailsDisplayed();
    }

    @Override
    public void onAppDetailsDismissed(String string2) {
        DirectDownloadState directDownloadState;
        ArrayService arrayService = this;
        if (arrayService.logger.a()) {
            this.logger.b(TAG, "App details dismissed");
        }
        if ((directDownloadState = this.currentDownloadState) == null) {
            return;
        }
        directDownloadState.listener.onAppDetailsDismissed();
        this.currentDownloadState = null;
    }

    @Override
    public void onDownloadStarted(String string2) {
        ArrayService arrayService = this;
        if (arrayService.logger.a()) {
            this.logger.b(TAG, "Download started");
        }
    }

    public boolean isAppHubInstalled() {
        return this.appHubService != null;
    }

    private boolean isOneClickDownloadEnabled() {
        DirectDownloadState directDownloadState = this.currentDownloadState;
        if (directDownloadState == null || directDownloadState.parameters == null) {
            return false;
        }
        return directDownloadState.parameters.getBoolean("array_one_click_download", false);
    }

    @Nullable
    private Intent createAppHubServiceIntent() {
        Intent intent = new Intent(SERVICE_INTENT_FILTER_ACTION);
        ArrayService arrayService = this;
        List list = arrayService.sdk.x().getPackageManager().queryIntentServices(intent, 0);
        if (list == null || list.isEmpty()) {
            ArrayService arrayService2 = this;
            if (arrayService2.logger.a()) {
                this.logger.e(TAG, "App Hub not available");
            }
            return null;
        }
        ResolveInfo resolveInfo = (ResolveInfo)list.get(0);
        String string2 = resolveInfo.serviceInfo.packageName;
        intent.setClassName(string2, SERVICE_INTENT_CLASS_NAME);
        return intent;
    }

    private void bindAppHubService() {
        block7: {
            if (this.currentRetryCount > 3) {
                ArrayService arrayService = this;
                if (arrayService.logger.a()) {
                    this.logger.d(TAG, "Exceeded maximum retry count");
                }
                return;
            }
            ArrayService arrayService = this;
            if (arrayService.logger.a()) {
                this.logger.b(TAG, "Attempting connection to App Hub service...");
            }
            ++this.currentRetryCount;
            try {
                ArrayService arrayService2 = this;
                boolean bl = arrayService2.sdk.x().bindService(this.appHubServiceIntent, new ServiceConnection(){

                    public void onServiceConnected(ComponentName componentName, IBinder iBinder) {
                        ArrayService.this.logger;
                        if (y.a()) {
                            ArrayService.this.logger.b(ArrayService.TAG, "Connection successful: " + componentName);
                        }
                        ArrayService.this.appHubService = IAppHubService.Stub.asInterface(iBinder);
                    }

                    public void onServiceDisconnected(ComponentName componentName) {
                        ArrayService.this.logger;
                        if (y.a()) {
                            ArrayService.this.logger.e(ArrayService.TAG, "Service disconnected: " + componentName);
                        }
                        ArrayService.this.appHubService = null;
                        ArrayService.this.logger;
                        if (y.a()) {
                            ArrayService.this.logger.e(ArrayService.TAG, "Retrying...");
                        }
                        ArrayService.this.bindAppHubService();
                    }
                }, 1);
                if (!bl) {
                    ArrayService arrayService3 = this;
                    if (arrayService3.logger.a()) {
                        this.logger.e(TAG, "App Hub not available");
                    }
                }
            }
            catch (Throwable throwable) {
                ArrayService arrayService4 = this;
                if (!arrayService4.logger.a()) break block7;
                this.logger.b(TAG, "Failed to bind to service", throwable);
            }
        }
    }

    public long getAppHubVersionCode() {
        return this.appHubVersionCode;
    }

    public boolean isDirectDownloadEnabled() {
        return this.isDirectDownloadEnabled;
    }

    @Nullable
    public String getRandomUserToken() {
        return this.randomUserToken;
    }

    public static interface DirectDownloadListener {
        public void onAppDetailsDisplayed();

        public void onAppDetailsDismissed();

        public void onFailure();
    }

    private static class DirectDownloadState {
        private final AtomicBoolean errorCallbackInvoked = new AtomicBoolean();
        private final String adToken;
        @Nullable
        private final Bundle parameters;
        private final DirectDownloadListener listener;

        public AtomicBoolean getErrorCallbackInvoked() {
            return this.errorCallbackInvoked;
        }

        public String getAdToken() {
            return this.adToken;
        }

        @Nullable
        public Bundle getParameters() {
            return this.parameters;
        }

        public DirectDownloadListener getListener() {
            return this.listener;
        }

        public boolean equals(Object object) {
            if (object == this) {
                return true;
            }
            if (!(object instanceof DirectDownloadState)) {
                return false;
            }
            DirectDownloadState directDownloadState = (DirectDownloadState)object;
            if (!directDownloadState.canEqual(this)) {
                return false;
            }
            AtomicBoolean atomicBoolean = this.getErrorCallbackInvoked();
            AtomicBoolean atomicBoolean2 = directDownloadState.getErrorCallbackInvoked();
            if (atomicBoolean == null ? atomicBoolean2 != null : !atomicBoolean.equals(atomicBoolean2)) {
                return false;
            }
            String string2 = this.getAdToken();
            String string3 = directDownloadState.getAdToken();
            if (string2 == null ? string3 != null : !string2.equals(string3)) {
                return false;
            }
            Bundle bundle = this.getParameters();
            Bundle bundle2 = directDownloadState.getParameters();
            if (bundle == null ? bundle2 != null : !bundle.equals(bundle2)) {
                return false;
            }
            DirectDownloadListener directDownloadListener = this.getListener();
            DirectDownloadListener directDownloadListener2 = directDownloadState.getListener();
            return !(directDownloadListener == null ? directDownloadListener2 != null : !directDownloadListener.equals(directDownloadListener2));
        }

        protected boolean canEqual(Object object) {
            return object instanceof DirectDownloadState;
        }

        public int hashCode() {
            int n2 = 59;
            int n3 = 1;
            AtomicBoolean atomicBoolean = this.getErrorCallbackInvoked();
            n3 = n3 * 59 + (atomicBoolean == null ? 43 : atomicBoolean.hashCode());
            String string2 = this.getAdToken();
            n3 = n3 * 59 + (string2 == null ? 43 : string2.hashCode());
            Bundle bundle = this.getParameters();
            n3 = n3 * 59 + (bundle == null ? 43 : bundle.hashCode());
            DirectDownloadListener directDownloadListener = this.getListener();
            n3 = n3 * 59 + (directDownloadListener == null ? 43 : directDownloadListener.hashCode());
            return n3;
        }

        public String toString() {
            return "ArrayService.DirectDownloadState(errorCallbackInvoked=" + this.getErrorCallbackInvoked() + ", adToken=" + this.getAdToken() + ", parameters=" + this.getParameters() + ", listener=" + this.getListener() + ")";
        }

        public DirectDownloadState(String string2, @Nullable Bundle bundle, DirectDownloadListener directDownloadListener) {
            this.adToken = string2;
            this.parameters = bundle;
            this.listener = directDownloadListener;
        }
    }
}

