/*
 * Decompiled with CFR 0.152.
 */
package com.applovin.impl.sdk.nativeAd;

import android.annotation.SuppressLint;
import android.app.Activity;
import android.content.Context;
import android.graphics.drawable.AnimatedVectorDrawable;
import android.graphics.drawable.Drawable;
import android.net.Uri;
import android.os.Bundle;
import android.os.Handler;
import android.os.Looper;
import android.os.StrictMode;
import android.os.SystemClock;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import android.widget.ImageView;
import android.widget.LinearLayout;
import androidx.annotation.Nullable;
import com.applovin.communicator.AppLovinCommunicator;
import com.applovin.communicator.AppLovinCommunicatorMessage;
import com.applovin.communicator.AppLovinCommunicatorSubscriber;
import com.applovin.exoplayer2.ab;
import com.applovin.exoplayer2.ak;
import com.applovin.exoplayer2.an;
import com.applovin.exoplayer2.aw;
import com.applovin.exoplayer2.h.u;
import com.applovin.exoplayer2.l.ai;
import com.applovin.exoplayer2.ui.f;
import com.applovin.exoplayer2.ui.g;
import com.applovin.impl.adview.j;
import com.applovin.impl.b.a;
import com.applovin.impl.b.f;
import com.applovin.impl.b.k;
import com.applovin.impl.b.l;
import com.applovin.impl.b.m;
import com.applovin.impl.b.o;
import com.applovin.impl.sdk.nativeAd.AppLovinMediaView;
import com.applovin.impl.sdk.nativeAd.AppLovinNativeAdImpl;
import com.applovin.impl.sdk.p;
import com.applovin.impl.sdk.utils.Utils;
import com.applovin.impl.sdk.utils.h;
import com.applovin.impl.sdk.utils.r;
import com.applovin.sdk.AppLovinSdkUtils;
import com.applovin.sdk.R;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;

@SuppressLint(value={"ViewConstructor"})
public class AppLovinVastMediaView
extends AppLovinMediaView
implements AppLovinCommunicatorSubscriber {
    private static final String TAG = "AppLovinVastExoPlayerMediaView";
    private static final String COUNTDOWN_IDENTIFIER_PROGRESS_TRACKING = "PROGRESS_TRACKING";
    private static final long FADE_ANIMATION_DURATION_MILLIS = 250L;
    private final g videoView;
    private final aw mediaPlayer;
    @Nullable
    private LinearLayout videoWidgetLinearLayout;
    @Nullable
    private ImageView playPauseButtonImageView;
    @Nullable
    private ImageView muteButtonImageView;
    @Nullable
    private ImageView industryIconImageView;
    @Nullable
    private FrameLayout replayIconContainer;
    private final Handler countdownHandler = new Handler(Looper.getMainLooper());
    private final j countdownManager = new j(this.countdownHandler, this.sdk);
    private final AtomicBoolean videoEndListenerNotified = new AtomicBoolean();
    private final AtomicBoolean mediaErrorHandled = new AtomicBoolean();
    private final AtomicBoolean initialOnAttachedToWindowHandled = new AtomicBoolean();
    private final AtomicBoolean automaticPauseHandled = new AtomicBoolean();
    private final AtomicBoolean automaticResumeHandled = new AtomicBoolean();
    private final boolean isVideoStream;
    private long startTimeMillis;
    private Activity viewActivity;
    private boolean isVideoMuted = true;
    private boolean isVideoPausedByUser;
    private boolean videoWasCompleted;
    private int savedVideoPercentViewed;
    private long lastVideoPositionFromPauseMillis = -1L;
    private long videoDurationMillis;
    private final com.applovin.impl.b.a vastAd;
    private final Set<k> videoProgressTrackers = new HashSet<k>();
    private final com.applovin.impl.sdk.utils.a lifecycleCallbacksAdapter = new com.applovin.impl.sdk.utils.a(){

        @Override
        public void onActivityResumed(Activity activity) {
            if (activity.equals(AppLovinVastMediaView.this.viewActivity) && !AppLovinVastMediaView.this.isVideoPausedByUser) {
                AppLovinVastMediaView.this.maybeHandleResume();
            }
        }

        @Override
        public void onActivityPaused(Activity activity) {
            if (activity.equals(AppLovinVastMediaView.this.viewActivity)) {
                AppLovinVastMediaView.this.maybeHandlePause();
            }
        }
    };

    public AppLovinVastMediaView(AppLovinNativeAdImpl appLovinNativeAdImpl, p p2, Context context) {
        super(appLovinNativeAdImpl, p2, context);
        int n2;
        this.vastAd = appLovinNativeAdImpl.getVastAd();
        this.isVideoStream = this.vastAd.f();
        if (this.isVideoStream) {
            AppLovinCommunicator.getInstance(context).subscribe((AppLovinCommunicatorSubscriber)this, "video_caching_failed");
        }
        if (this.vastAd.aS()) {
            this.industryIconImageView = com.applovin.impl.b.g.a(this.vastAd.aR().a(), context, p2);
            int n3 = AppLovinSdkUtils.dpToPx(context, p2.a(com.applovin.impl.sdk.c.b.eQ));
            this.industryIconImageView.setLayoutParams((ViewGroup.LayoutParams)new FrameLayout.LayoutParams(n3, n3, p2.a(com.applovin.impl.sdk.c.b.eS).intValue()));
            this.industryIconImageView.setOnClickListener((View.OnClickListener)new a());
            this.addView((View)this.industryIconImageView);
        }
        if (p2.a(com.applovin.impl.sdk.c.b.eX).booleanValue()) {
            this.videoWidgetLinearLayout = new LinearLayout(context);
            this.videoWidgetLinearLayout.setOrientation(0);
            this.videoWidgetLinearLayout.setBackgroundResource(R.drawable.applovin_rounded_black_background);
            this.videoWidgetLinearLayout.setAlpha(p2.a(com.applovin.impl.sdk.c.b.eW).floatValue());
            this.playPauseButtonImageView = new ImageView(context);
            this.playPauseButtonImageView.setClickable(true);
            d d2 = new d();
            this.playPauseButtonImageView.setOnClickListener((View.OnClickListener)d2);
            int n4 = AppLovinSdkUtils.dpToPx(context, p2.a(com.applovin.impl.sdk.c.b.eU));
            this.playPauseButtonImageView.setLayoutParams((ViewGroup.LayoutParams)new FrameLayout.LayoutParams(n4, n4));
            this.populatePlayPauseImage(false);
            this.videoWidgetLinearLayout.addView((View)this.playPauseButtonImageView);
            this.muteButtonImageView = new ImageView(context);
            n2 = 0;
            boolean bl = this.populateMuteImage(this.isVideoMuted);
            if (bl) {
                n2 = AppLovinSdkUtils.dpToPx(context, p2.a(com.applovin.impl.sdk.c.b.eT));
                this.muteButtonImageView.setClickable(true);
                this.muteButtonImageView.setOnClickListener((View.OnClickListener)d2);
                this.muteButtonImageView.setLayoutParams((ViewGroup.LayoutParams)new FrameLayout.LayoutParams(n2, n2));
                this.videoWidgetLinearLayout.addView((View)this.muteButtonImageView);
            }
            int n5 = AppLovinSdkUtils.dpToPx(context, p2.a(com.applovin.impl.sdk.c.b.eV));
            this.videoWidgetLinearLayout.setPadding(n5, n5, n5, n5);
            int n6 = n4 + n2 + n5 * 2;
            int n7 = Math.max(n4, n2) + n5 * 2;
            this.videoWidgetLinearLayout.setLayoutParams((ViewGroup.LayoutParams)new FrameLayout.LayoutParams(n6, n7, 8388691));
            this.addView((View)this.videoWidgetLinearLayout);
        }
        if (p2.a(com.applovin.impl.sdk.c.b.eY).booleanValue()) {
            this.replayIconContainer = new FrameLayout(this.getContext());
            this.replayIconContainer.setBackgroundColor(-16777216);
            this.replayIconContainer.setLayoutParams((ViewGroup.LayoutParams)new FrameLayout.LayoutParams(-1, -1));
            this.replayIconContainer.setVisibility(4);
            d d3 = new d();
            this.replayIconContainer.setOnClickListener((View.OnClickListener)d3);
            ImageView imageView = new ImageView(this.getContext());
            n2 = AppLovinSdkUtils.dpToPx(context, p2.a(com.applovin.impl.sdk.c.b.eZ));
            imageView.setLayoutParams((ViewGroup.LayoutParams)new FrameLayout.LayoutParams(n2, n2, 17));
            imageView.setImageResource(R.drawable.applovin_ic_replay_icon);
            imageView.setAdjustViewBounds(true);
            imageView.setMaxHeight(this.replayIconContainer.getHeight());
            imageView.setMaxWidth(this.replayIconContainer.getWidth());
            this.replayIconContainer.addView((View)imageView);
            this.addView((View)this.replayIconContainer);
        }
        this.mediaPlayer = new aw.a(this.getContext()).a();
        c c2 = new c();
        this.mediaPlayer.a(c2);
        this.mediaPlayer.c(0);
        this.videoView = new g(this.getContext());
        this.videoView.b();
        this.videoView.setControllerVisibilityListener(c2);
        this.videoView.setPlayer(this.mediaPlayer);
        this.videoView.setOnClickListener(new b(appLovinNativeAdImpl.getClickHandler()));
        this.addView((View)this.videoView);
        this.bringChildToFront((View)this.industryIconImageView);
        this.bringChildToFront((View)this.videoWidgetLinearLayout);
        this.prepareMediaPlayer();
        appLovinNativeAdImpl.setVideoView((View)this.videoView);
        Set<k> set = this.vastAd.a(a.c.d, l.a);
        this.videoProgressTrackers.addAll(set);
    }

    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
        this.maybeHandleOnAttachedToWindow();
        if (!this.isVideoPausedByUser) {
            this.maybeHandleResume();
        }
    }

    protected void onDetachedFromWindow() {
        this.maybeHandlePause();
        super.onDetachedFromWindow();
    }

    @Override
    public void destroy() {
        this.finishVideo();
        if (this.industryIconImageView != null) {
            this.industryIconImageView.setOnClickListener(null);
        }
        if (this.playPauseButtonImageView != null) {
            this.playPauseButtonImageView.setOnClickListener(null);
        }
        if (this.muteButtonImageView != null) {
            this.muteButtonImageView.setOnClickListener(null);
        }
        if (this.replayIconContainer != null) {
            this.replayIconContainer.setOnClickListener(null);
        }
        this.videoView.setOnClickListener(null);
        this.viewActivity = null;
        this.mediaPlayer.E();
        this.vastAd.g().e();
        this.countdownManager.b();
        this.countdownHandler.removeCallbacksAndMessages(null);
        if (this.isVideoStream) {
            AppLovinCommunicator.getInstance(this.getContext()).unsubscribe((AppLovinCommunicatorSubscriber)this, "video_caching_failed");
        }
        super.destroy();
    }

    @Override
    public void onMessageReceived(AppLovinCommunicatorMessage appLovinCommunicatorMessage) {
        if (!"video_caching_failed".equals(appLovinCommunicatorMessage.getTopic())) {
            return;
        }
        Bundle bundle = appLovinCommunicatorMessage.getMessageData();
        long l2 = bundle.getLong("ad_id");
        if (this.sdk.a(com.applovin.impl.sdk.c.b.fy).booleanValue() && l2 == this.vastAd.getAdIdNumber() && this.isVideoStream) {
            int n2 = bundle.getInt("load_response_code");
            String string2 = bundle.getString("load_exception_message");
            if (!(string2 == null && n2 >= 200 && n2 < 300 || this.videoWasCompleted || this.mediaPlayer.a())) {
                this.handleMediaError("Video cache error during stream. ResponseCode=" + n2 + ", exception=" + string2);
            }
        }
    }

    @Override
    public String getCommunicatorId() {
        return TAG;
    }

    private void prepareMediaPlayer() {
        this.checkCachedAdResources(!this.isVideoStream);
        com.applovin.exoplayer2.k.p p2 = new com.applovin.exoplayer2.k.p(this.getContext(), ai.a(this.getContext(), "com.applovin.sdk"));
        u u2 = new u.a(p2).a(ab.a(this.vastAd.h()));
        boolean bl = !this.isVideoMuted;
        this.mediaPlayer.a((float)bl);
        this.mediaPlayer.a(u2);
        this.mediaPlayer.w();
        this.mediaPlayer.a(false);
    }

    private void maybeHandleOnAttachedToWindow() {
        if (!this.initialOnAttachedToWindowHandled.compareAndSet(false, true)) {
            return;
        }
        if (this.industryIconImageView != null && this.vastAd.aS()) {
            this.maybeFireTrackers(a.c.f);
            this.industryIconImageView.setVisibility(0);
        }
        this.startTimeMillis = SystemClock.elapsedRealtime();
        this.maybeFireTrackers(a.c.a);
        this.maybeFireTrackers(a.c.d, "creativeView");
        this.vastAd.g().d();
        this.vastAd.setHasShown(true);
        this.sdk.D().trackImpression(this.vastAd);
        this.viewActivity = com.applovin.impl.sdk.utils.b.a(Utils.getRootView((View)this));
        this.sdk.v().a(this.lifecycleCallbacksAdapter);
        this.mediaPlayer.a(true);
        this.countdownManager.a(COUNTDOWN_IDENTIFIER_PROGRESS_TRACKING, TimeUnit.SECONDS.toMillis(1L), new j.a(){

            @Override
            public void a() {
                long l2 = AppLovinVastMediaView.this.mediaPlayer.H() - AppLovinVastMediaView.this.mediaPlayer.I();
                long l3 = TimeUnit.MILLISECONDS.toSeconds(AppLovinVastMediaView.this.videoDurationMillis - l2);
                int n2 = AppLovinVastMediaView.this.getVideoPercentViewed();
                HashSet<k> hashSet = new HashSet<k>();
                HashSet hashSet2 = new HashSet(AppLovinVastMediaView.this.videoProgressTrackers);
                for (k k2 : hashSet2) {
                    if (!k2.a(l3, n2)) continue;
                    hashSet.add(k2);
                    AppLovinVastMediaView.this.videoProgressTrackers.remove(k2);
                }
                AppLovinVastMediaView.this.maybeFireTrackers(hashSet);
                if (n2 >= 25 && n2 < 50) {
                    AppLovinVastMediaView.this.vastAd.g().f();
                } else if (n2 >= 50 && n2 < 75) {
                    AppLovinVastMediaView.this.vastAd.g().g();
                } else if (n2 >= 75) {
                    AppLovinVastMediaView.this.vastAd.g().h();
                }
            }

            @Override
            public boolean b() {
                return !AppLovinVastMediaView.this.videoWasCompleted;
            }
        });
    }

    private void maybeHandlePause() {
        if (!this.automaticPauseHandled.compareAndSet(false, true)) {
            return;
        }
        this.maybeFireTrackers(a.c.d, "pause");
        this.vastAd.g().j();
        this.pauseVideo();
        this.populatePlayPauseImage(true);
        this.automaticResumeHandled.set(false);
    }

    private void maybeHandleResume() {
        if (!this.automaticResumeHandled.compareAndSet(false, true)) {
            return;
        }
        this.maybeFireTrackers(a.c.d, "resume");
        this.vastAd.g().k();
        if (this.lastVideoPositionFromPauseMillis >= 0L) {
            AppLovinVastMediaView appLovinVastMediaView = this;
            if (appLovinVastMediaView.logger.a()) {
                this.logger.b(TAG, "Resuming video at position " + this.lastVideoPositionFromPauseMillis);
            }
            this.mediaPlayer.a(true);
            this.countdownManager.a();
            this.lastVideoPositionFromPauseMillis = -1L;
        } else {
            AppLovinVastMediaView appLovinVastMediaView = this;
            if (appLovinVastMediaView.logger.a()) {
                this.logger.b(TAG, "Invalid last video position, isVideoPlaying=" + this.mediaPlayer.a());
            }
        }
        this.populatePlayPauseImage(false);
        this.automaticPauseHandled.set(false);
    }

    private void finishVideo() {
        this.maybeFireTrackers(a.c.d, "close");
        this.maybeHandlePause();
        this.sdk.v().b(this.lifecycleCallbacksAdapter);
        if (this.videoWasCompleted) {
            this.maybeFireRemainingCompletionTrackers();
            this.vastAd.g().i();
        }
        if (this.videoEndListenerNotified.compareAndSet(false, true)) {
            long l2 = SystemClock.elapsedRealtime() - this.startTimeMillis;
            this.sdk.D().trackVideoEnd(this.vastAd, TimeUnit.MILLISECONDS.toSeconds(l2), this.getVideoPercentViewed(), this.isVideoStream);
        }
    }

    private void pauseVideo() {
        AppLovinVastMediaView appLovinVastMediaView = this;
        if (appLovinVastMediaView.logger.a()) {
            this.logger.b(TAG, "Pausing video");
        }
        this.savedVideoPercentViewed = this.getVideoPercentViewed();
        this.lastVideoPositionFromPauseMillis = this.mediaPlayer.I();
        this.mediaPlayer.a(false);
        this.countdownManager.c();
        AppLovinVastMediaView appLovinVastMediaView2 = this;
        if (appLovinVastMediaView2.logger.a()) {
            this.logger.b(TAG, "Paused video at position " + this.lastVideoPositionFromPauseMillis + " ms");
        }
    }

    private void checkCachedAdResources(boolean bl) {
        List<Uri> list = Utils.checkCachedResourcesExist(bl, this.vastAd, this.sdk, this.getContext());
        if (list.isEmpty()) {
            return;
        }
        AppLovinVastMediaView appLovinVastMediaView = this;
        if (appLovinVastMediaView.logger.a()) {
            this.logger.e(TAG, "Video failed due to missing resources: " + list);
        }
        this.finishVideo();
        this.showMediaImageView();
    }

    private void handleMediaError(String string2) {
        AppLovinVastMediaView appLovinVastMediaView = this;
        if (appLovinVastMediaView.logger.a()) {
            this.logger.e(TAG, string2);
        }
        this.maybeFireTrackers(a.c.h, f.m);
        this.vastAd.g().a(string2);
        if (this.mediaErrorHandled.compareAndSet(false, true)) {
            this.finishVideo();
            this.showMediaImageView();
        }
    }

    private void showMediaImageView() {
        if (this.imageView.getDrawable() == null) {
            return;
        }
        this.imageView.setVisibility(0);
        this.videoView.setVisibility(8);
        if (this.videoWidgetLinearLayout != null) {
            this.videoWidgetLinearLayout.setVisibility(8);
        }
        if (this.industryIconImageView != null) {
            this.industryIconImageView.setVisibility(8);
        }
    }

    private void maybeFireRemainingCompletionTrackers() {
        if (this.getVideoPercentViewed() >= this.vastAd.Q() && !this.videoProgressTrackers.isEmpty()) {
            AppLovinVastMediaView appLovinVastMediaView = this;
            if (appLovinVastMediaView.logger.a()) {
                this.logger.d(TAG, "Firing " + this.videoProgressTrackers.size() + " un-fired video progress trackers when video was completed.");
            }
            this.maybeFireTrackers(this.videoProgressTrackers);
        }
    }

    private int getVideoPercentViewed() {
        long l2 = this.mediaPlayer.I();
        if (this.videoWasCompleted) {
            return 100;
        }
        if (l2 > 0L) {
            return (int)((float)l2 / (float)this.videoDurationMillis * 100.0f);
        }
        return this.savedVideoPercentViewed;
    }

    private void populatePlayPauseImage(boolean bl) {
        Uri uri;
        if (this.playPauseButtonImageView == null) {
            return;
        }
        Uri uri2 = uri = bl ? this.vastAd.aC() : this.vastAd.aD();
        if (uri != null) {
            StrictMode.ThreadPolicy threadPolicy = StrictMode.allowThreadDiskReads();
            this.playPauseButtonImageView.setImageURI(uri);
            StrictMode.setThreadPolicy((StrictMode.ThreadPolicy)threadPolicy);
            return;
        }
        int n2 = bl ? R.drawable.applovin_ic_play_icon : R.drawable.applovin_ic_pause_icon;
        this.playPauseButtonImageView.setImageResource(n2);
    }

    private boolean populateMuteImage(boolean bl) {
        Uri uri;
        if (this.muteButtonImageView == null) {
            return false;
        }
        Uri uri2 = uri = bl ? this.vastAd.aE() : this.vastAd.aF();
        if (uri != null) {
            StrictMode.ThreadPolicy threadPolicy = StrictMode.allowThreadDiskReads();
            this.muteButtonImageView.setImageURI(uri);
            StrictMode.setThreadPolicy((StrictMode.ThreadPolicy)threadPolicy);
            return true;
        }
        if (!h.d()) {
            return false;
        }
        AnimatedVectorDrawable animatedVectorDrawable = (AnimatedVectorDrawable)this.getContext().getDrawable(bl ? R.drawable.applovin_ic_unmute_to_mute : R.drawable.applovin_ic_mute_to_unmute);
        if (animatedVectorDrawable == null) {
            return false;
        }
        this.muteButtonImageView.setImageDrawable((Drawable)animatedVectorDrawable);
        animatedVectorDrawable.start();
        return true;
    }

    private void maybeFireTrackers(Set<k> set) {
        this.maybeFireTrackers(set, f.a);
    }

    private void maybeFireTrackers(a.c c2) {
        this.maybeFireTrackers(c2, f.a);
    }

    private void maybeFireTrackers(a.c c2, String string2) {
        this.maybeFireTrackers(c2, string2, f.a);
    }

    private void maybeFireTrackers(a.c c2, f f2) {
        this.maybeFireTrackers(c2, "", f2);
    }

    private void maybeFireTrackers(a.c c2, String string2, f f2) {
        Set<k> set = this.vastAd.a(c2, string2);
        this.maybeFireTrackers(set, f2);
    }

    private void maybeFireTrackers(Set<k> set, f f2) {
        if (set == null || set.isEmpty()) {
            return;
        }
        long l2 = TimeUnit.MILLISECONDS.toSeconds(this.mediaPlayer.I());
        o o2 = this.vastAd.aP();
        Uri uri = o2 != null ? o2.a() : null;
        AppLovinVastMediaView appLovinVastMediaView = this;
        if (appLovinVastMediaView.logger.a()) {
            this.logger.b(TAG, "Firing " + set.size() + " tracker(s): " + set);
        }
        m.a(set, l2, uri, f2, this.sdk);
    }

    private class d
    implements View.OnClickListener {
        private d() {
        }

        public void onClick(View view) {
            if (view == AppLovinVastMediaView.this.playPauseButtonImageView) {
                if (AppLovinVastMediaView.this.mediaPlayer.a()) {
                    AppLovinVastMediaView.this.isVideoPausedByUser = true;
                    AppLovinVastMediaView.this.maybeHandlePause();
                } else {
                    AppLovinVastMediaView.this.isVideoPausedByUser = false;
                    AppLovinVastMediaView.this.maybeHandleResume();
                }
            } else if (view == AppLovinVastMediaView.this.muteButtonImageView) {
                boolean bl = !AppLovinVastMediaView.this.isVideoMuted;
                AppLovinVastMediaView.this.isVideoMuted = bl;
                boolean bl2 = !bl;
                AppLovinVastMediaView.this.mediaPlayer.a((float)bl2);
                AppLovinVastMediaView.this.populateMuteImage(bl);
            } else if (view == AppLovinVastMediaView.this.replayIconContainer) {
                r.b((View)AppLovinVastMediaView.this.replayIconContainer, 250L, new Runnable(){

                    @Override
                    public void run() {
                        AppLovinVastMediaView.this.videoWasCompleted = false;
                        AppLovinVastMediaView.this.automaticResumeHandled.set(false);
                        AppLovinVastMediaView.this.sdk.v().a(AppLovinVastMediaView.this.lifecycleCallbacksAdapter);
                        AppLovinVastMediaView.this.maybeHandleResume();
                    }
                });
            }
        }
    }

    private class a
    implements View.OnClickListener {
        private a() {
        }

        public void onClick(View view) {
            com.applovin.impl.b.g g2 = AppLovinVastMediaView.this.vastAd.aR();
            if (g2 == null) {
                return;
            }
            Uri uri = g2.b();
            if (uri == null) {
                return;
            }
            AppLovinVastMediaView appLovinVastMediaView = AppLovinVastMediaView.this;
            if (appLovinVastMediaView.logger.a()) {
                AppLovinVastMediaView.this.logger.b(AppLovinVastMediaView.TAG, "Industry icon clicked, opening URL: " + uri);
            }
            AppLovinVastMediaView.this.maybeFireTrackers(a.c.g);
            Utils.openUri(view.getContext(), uri, AppLovinVastMediaView.this.sdk);
        }
    }

    private class b
    implements View.OnClickListener {
        private final View.OnClickListener b;

        public void onClick(View view) {
            AppLovinVastMediaView.this.maybeFireTrackers(a.c.b);
            AppLovinVastMediaView.this.vastAd.g().o();
            this.b.onClick(view);
        }

        public b(View.OnClickListener onClickListener) {
            this.b = onClickListener;
        }
    }

    private class c
    implements an.b,
    f.d {
        private c() {
        }

        @Override
        public void b(int n2) {
            AppLovinVastMediaView appLovinVastMediaView = AppLovinVastMediaView.this;
            if (appLovinVastMediaView.logger.a()) {
                AppLovinVastMediaView.this.logger.b(AppLovinVastMediaView.TAG, "Player state changed to state " + n2 + " and will play when ready: " + AppLovinVastMediaView.this.mediaPlayer.x());
            }
            if (n2 == 3) {
                boolean bl = !AppLovinVastMediaView.this.isVideoMuted;
                AppLovinVastMediaView.this.mediaPlayer.a((float)bl);
                AppLovinVastMediaView.this.videoDurationMillis = AppLovinVastMediaView.this.mediaPlayer.H();
                AppLovinVastMediaView.this.vastAd.g().a(TimeUnit.MILLISECONDS.toSeconds(AppLovinVastMediaView.this.videoDurationMillis), Utils.isVideoMutedInitially(AppLovinVastMediaView.this.sdk));
                AppLovinVastMediaView appLovinVastMediaView2 = AppLovinVastMediaView.this;
                if (appLovinVastMediaView2.logger.a()) {
                    AppLovinVastMediaView.this.logger.b(AppLovinVastMediaView.TAG, "MediaPlayer prepared: " + AppLovinVastMediaView.this.mediaPlayer);
                }
                AppLovinVastMediaView.this.countdownManager.a();
            } else if (n2 == 4) {
                AppLovinVastMediaView appLovinVastMediaView3 = AppLovinVastMediaView.this;
                if (appLovinVastMediaView3.logger.a()) {
                    AppLovinVastMediaView.this.logger.b(AppLovinVastMediaView.TAG, "Video completed");
                }
                AppLovinVastMediaView.this.videoWasCompleted = true;
                AppLovinVastMediaView.this.finishVideo();
                if (AppLovinVastMediaView.this.replayIconContainer != null) {
                    r.a((View)AppLovinVastMediaView.this.replayIconContainer, 250L, new Runnable(){

                        @Override
                        public void run() {
                            AppLovinVastMediaView.this.mediaPlayer.a(0L);
                        }
                    });
                } else {
                    AppLovinVastMediaView.this.showMediaImageView();
                }
            }
        }

        @Override
        public void a(ak ak2) {
            AppLovinVastMediaView.this.handleMediaError("Video view error (" + ak2 + ")");
        }

        @Override
        public void a(int n2) {
            if (n2 == 0) {
                AppLovinVastMediaView.this.videoView.b();
            }
        }
    }
}

