/*
 * Decompiled with CFR 0.152.
 */
package com.applovin.exoplayer2.common.base;

import com.applovin.exoplayer2.common.base.Function;
import com.applovin.exoplayer2.common.base.Preconditions;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.ForOverride;
import com.google.errorprone.annotations.concurrent.LazyInit;
import java.io.Serializable;
import java.util.Iterator;
import org.checkerframework.checker.nullness.compatqual.MonotonicNonNullDecl;
import org.checkerframework.checker.nullness.compatqual.NullableDecl;

public abstract class Converter<A, B>
implements Function<A, B> {
    private final boolean handleNullAutomatically;
    @LazyInit
    @MonotonicNonNullDecl
    private transient Converter<B, A> reverse;

    protected Converter() {
        this(true);
    }

    Converter(boolean bl) {
        this.handleNullAutomatically = bl;
    }

    @ForOverride
    protected abstract B doForward(A var1);

    @ForOverride
    protected abstract A doBackward(B var1);

    @NullableDecl
    @CanIgnoreReturnValue
    public final B convert(@NullableDecl A a2) {
        return this.correctedDoForward(a2);
    }

    @NullableDecl
    B correctedDoForward(@NullableDecl A a2) {
        if (this.handleNullAutomatically) {
            return a2 == null ? null : (B)Preconditions.checkNotNull(this.doForward(a2));
        }
        return this.doForward(a2);
    }

    @NullableDecl
    A correctedDoBackward(@NullableDecl B b2) {
        if (this.handleNullAutomatically) {
            return b2 == null ? null : (A)Preconditions.checkNotNull(this.doBackward(b2));
        }
        return this.doBackward(b2);
    }

    @CanIgnoreReturnValue
    public Iterable<B> convertAll(final Iterable<? extends A> iterable) {
        Preconditions.checkNotNull(iterable, "fromIterable");
        return new Iterable<B>(){

            @Override
            public Iterator<B> iterator() {
                return new Iterator<B>(){
                    private final Iterator<? extends A> ol;
                    {
                        this.ol = iterable.iterator();
                    }

                    @Override
                    public boolean hasNext() {
                        return this.ol.hasNext();
                    }

                    @Override
                    public B next() {
                        return Converter.this.convert(this.ol.next());
                    }

                    @Override
                    public void remove() {
                        this.ol.remove();
                    }
                };
            }
        };
    }

    @CanIgnoreReturnValue
    public Converter<B, A> reverse() {
        Converter<A, B> converter = this.reverse;
        return converter == null ? (this.reverse = new d(this)) : converter;
    }

    public final <C> Converter<A, C> andThen(Converter<B, C> converter) {
        return this.doAndThen(converter);
    }

    <C> Converter<A, C> doAndThen(Converter<B, C> converter) {
        return new a(this, Preconditions.checkNotNull(converter));
    }

    @Override
    @Deprecated
    @NullableDecl
    @CanIgnoreReturnValue
    public final B apply(@NullableDecl A a2) {
        return this.convert(a2);
    }

    @Override
    public boolean equals(@NullableDecl Object object) {
        return super.equals(object);
    }

    public static <A, B> Converter<A, B> from(Function<? super A, ? extends B> function, Function<? super B, ? extends A> function2) {
        return new b(function, function2);
    }

    public static <T> Converter<T, T> identity() {
        return c.os;
    }

    private static final class c<T>
    extends Converter<T, T>
    implements Serializable {
        static final c os = new c();

        private c() {
        }

        @Override
        protected T doForward(T t2) {
            return t2;
        }

        @Override
        protected T doBackward(T t2) {
            return t2;
        }

        public c<T> eX() {
            return this;
        }

        @Override
        <S> Converter<T, S> doAndThen(Converter<T, S> converter) {
            return Preconditions.checkNotNull(converter, "otherConverter");
        }

        public String toString() {
            return "Converter.identity()";
        }

        @Override
        public /* synthetic */ Converter reverse() {
            return this.eX();
        }
    }

    private static final class b<A, B>
    extends Converter<A, B>
    implements Serializable {
        private final Function<? super A, ? extends B> oq;
        private final Function<? super B, ? extends A> or;

        private b(Function<? super A, ? extends B> function, Function<? super B, ? extends A> function2) {
            this.oq = Preconditions.checkNotNull(function);
            this.or = Preconditions.checkNotNull(function2);
        }

        @Override
        protected B doForward(A a2) {
            return this.oq.apply(a2);
        }

        @Override
        protected A doBackward(B b2) {
            return this.or.apply(b2);
        }

        @Override
        public boolean equals(@NullableDecl Object object) {
            if (object instanceof b) {
                b b2 = (b)object;
                return this.oq.equals(b2.oq) && this.or.equals(b2.or);
            }
            return false;
        }

        public int hashCode() {
            return this.oq.hashCode() * 31 + this.or.hashCode();
        }

        public String toString() {
            return "Converter.from(" + this.oq + ", " + this.or + ")";
        }
    }

    private static final class a<A, B, C>
    extends Converter<A, C>
    implements Serializable {
        final Converter<A, B> oo;
        final Converter<B, C> op;

        a(Converter<A, B> converter, Converter<B, C> converter2) {
            this.oo = converter;
            this.op = converter2;
        }

        @Override
        protected C doForward(A a2) {
            throw new AssertionError();
        }

        @Override
        protected A doBackward(C c2) {
            throw new AssertionError();
        }

        @Override
        @NullableDecl
        C correctedDoForward(@NullableDecl A a2) {
            return this.op.correctedDoForward(this.oo.correctedDoForward(a2));
        }

        @Override
        @NullableDecl
        A correctedDoBackward(@NullableDecl C c2) {
            return this.oo.correctedDoBackward(this.op.correctedDoBackward(c2));
        }

        @Override
        public boolean equals(@NullableDecl Object object) {
            if (object instanceof a) {
                a a2 = (a)object;
                return this.oo.equals(a2.oo) && this.op.equals(a2.op);
            }
            return false;
        }

        public int hashCode() {
            return 31 * this.oo.hashCode() + this.op.hashCode();
        }

        public String toString() {
            return this.oo + ".andThen(" + this.op + ")";
        }
    }

    private static final class d<A, B>
    extends Converter<B, A>
    implements Serializable {
        final Converter<A, B> ot;

        d(Converter<A, B> converter) {
            this.ot = converter;
        }

        @Override
        protected A doForward(B b2) {
            throw new AssertionError();
        }

        @Override
        protected B doBackward(A a2) {
            throw new AssertionError();
        }

        @Override
        @NullableDecl
        A correctedDoForward(@NullableDecl B b2) {
            return this.ot.correctedDoBackward(b2);
        }

        @Override
        @NullableDecl
        B correctedDoBackward(@NullableDecl A a2) {
            return this.ot.correctedDoForward(a2);
        }

        @Override
        public Converter<A, B> reverse() {
            return this.ot;
        }

        @Override
        public boolean equals(@NullableDecl Object object) {
            if (object instanceof d) {
                d d2 = (d)object;
                return this.ot.equals(d2.ot);
            }
            return false;
        }

        public int hashCode() {
            return ~this.ot.hashCode();
        }

        public String toString() {
            return this.ot + ".reverse()";
        }
    }
}

