/*
 * Decompiled with CFR 0.152.
 */
package com.applovin.impl.sdk;

import android.graphics.Color;
import androidx.annotation.Nullable;
import com.applovin.impl.sdk.a.a;
import com.applovin.impl.sdk.array.ArrayDirectDownloadAd;
import com.applovin.impl.sdk.c.b;
import com.applovin.impl.sdk.m;
import com.applovin.impl.sdk.utils.JsonUtils;
import com.applovin.impl.sdk.utils.StringUtils;
import com.applovin.impl.sdk.utils.q;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONObject;

public abstract class AppLovinAdBase
implements a,
ArrayDirectDownloadAd {
    @Nullable
    protected final JSONObject adObject;
    @Nullable
    protected final JSONObject fullResponse;
    @Nullable
    protected final q synchronizedAdObject;
    @Nullable
    protected final q synchronizedFullResponse;
    protected final m sdk;
    protected final Object adObjectLock = new Object();
    protected final Object fullResponseLock = new Object();
    private final long createdAtMillis;

    protected AppLovinAdBase(JSONObject jSONObject, JSONObject jSONObject2, m m2) {
        if (jSONObject == null) {
            throw new IllegalArgumentException("No ad object specified");
        }
        if (jSONObject2 == null) {
            throw new IllegalArgumentException("No response specified");
        }
        if (m2 == null) {
            throw new IllegalArgumentException("No sdk specified");
        }
        this.sdk = m2;
        if (m2.a(b.aRV).booleanValue()) {
            this.synchronizedAdObject = new q(jSONObject);
            this.synchronizedFullResponse = new q(jSONObject2);
            this.adObject = null;
            this.fullResponse = null;
        } else {
            this.adObject = jSONObject;
            this.fullResponse = jSONObject2;
            this.synchronizedAdObject = null;
            this.synchronizedFullResponse = null;
        }
        this.createdAtMillis = System.currentTimeMillis();
    }

    public m getSdk() {
        return this.sdk;
    }

    public long getCreatedAtMillis() {
        return this.createdAtMillis;
    }

    public abstract long getAdIdNumber();

    public String getClCode() {
        String string2 = this.getStringFromAdObject("clcode", "");
        if (StringUtils.isValidString(string2)) {
            return string2;
        }
        return this.getStringFromFullResponse("clcode", "");
    }

    public String getDspName() {
        return this.getStringFromFullResponse("dsp_name", "");
    }

    public String getDspId() {
        return this.getStringFromFullResponse("dsp_id", "");
    }

    public String getAdDomain() {
        return this.getStringFromFullResponse("adomain", "");
    }

    public long getFetchLatencyMillis() {
        return this.getLongFromFullResponse("ad_fetch_latency_millis", -1L);
    }

    public long getFetchResponseSize() {
        return this.getLongFromFullResponse("ad_fetch_response_size", -1L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean containsKeyForAdObject(String string2) {
        if (this.synchronizedAdObject != null) {
            return this.synchronizedAdObject.dL(string2);
        }
        Object object = this.adObjectLock;
        synchronized (object) {
            return this.adObject.has(string2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean getBooleanFromAdObject(String string2, Boolean bl) {
        if (this.synchronizedAdObject != null) {
            return this.synchronizedAdObject.c(string2, bl);
        }
        Object object = this.adObjectLock;
        synchronized (object) {
            return JsonUtils.getBoolean(this.adObject, string2, bl);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected float getFloatFromAdObject(String string2, float f2) {
        if (this.synchronizedAdObject != null) {
            return this.synchronizedAdObject.b(string2, f2);
        }
        Object object = this.adObjectLock;
        synchronized (object) {
            return JsonUtils.getFloat(this.adObject, string2, f2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int getIntFromAdObject(String string2, int n2) {
        if (this.synchronizedAdObject != null) {
            return this.synchronizedAdObject.h(string2, n2);
        }
        Object object = this.adObjectLock;
        synchronized (object) {
            return JsonUtils.getInt(this.adObject, string2, n2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected JSONObject getJsonObjectFromAdObject(String string2, JSONObject jSONObject) {
        if (this.synchronizedAdObject != null) {
            return this.synchronizedAdObject.b(string2, jSONObject);
        }
        Object object = this.adObjectLock;
        synchronized (object) {
            return JsonUtils.getJSONObject(this.adObject, string2, jSONObject);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected JSONArray getJsonArrayFromAdObject(String string2, JSONArray jSONArray) {
        if (this.synchronizedAdObject != null) {
            return this.synchronizedAdObject.b(string2, jSONArray);
        }
        Object object = this.adObjectLock;
        synchronized (object) {
            return JsonUtils.getJSONArray(this.adObject, string2, jSONArray);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected long getLongFromAdObject(String string2, long l2) {
        if (this.synchronizedAdObject != null) {
            return this.synchronizedAdObject.f(string2, l2);
        }
        Object object = this.adObjectLock;
        synchronized (object) {
            return JsonUtils.getLong(this.adObject, string2, l2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String getStringFromAdObject(String string2, String string3) {
        if (this.synchronizedAdObject != null) {
            return this.synchronizedAdObject.O(string2, string3);
        }
        Object object = this.adObjectLock;
        synchronized (object) {
            return JsonUtils.getString(this.adObject, string2, string3);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected List<String> getStringListFromAdObject(String string2, List<String> list) {
        if (this.synchronizedAdObject != null) {
            return this.synchronizedAdObject.d(string2, list);
        }
        Object object = this.adObjectLock;
        synchronized (object) {
            return JsonUtils.getStringList(this.adObject, string2, list);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected List<Integer> getIntegerListFromAdObject(String string2, List<Integer> list) {
        if (this.synchronizedAdObject != null) {
            return this.synchronizedAdObject.c(string2, list);
        }
        Object object = this.adObjectLock;
        synchronized (object) {
            return JsonUtils.getIntegerList(this.adObject, string2, list);
        }
    }

    protected int getColorFromAdObject(String string2, int n2) {
        String string3 = this.getStringFromAdObject(string2, null);
        return StringUtils.isValidString(string3) ? Color.parseColor((String)string3) : n2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean getBooleanFromFullResponse(String string2, boolean bl) {
        if (this.synchronizedFullResponse != null) {
            return this.synchronizedFullResponse.c(string2, bl);
        }
        Object object = this.fullResponseLock;
        synchronized (object) {
            return JsonUtils.getBoolean(this.fullResponse, string2, bl);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected long getLongFromFullResponse(String string2, long l2) {
        if (this.synchronizedFullResponse != null) {
            return this.synchronizedFullResponse.f(string2, l2);
        }
        Object object = this.fullResponseLock;
        synchronized (object) {
            return JsonUtils.getLong(this.fullResponse, string2, l2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String getStringFromFullResponse(String string2, String string3) {
        if (this.synchronizedFullResponse != null) {
            return this.synchronizedFullResponse.O(string2, string3);
        }
        Object object = this.fullResponseLock;
        synchronized (object) {
            return JsonUtils.getString(this.fullResponse, string2, string3);
        }
    }
}

