/*
 * Decompiled with CFR 0.152.
 */
package com.applovin.impl.sdk;

import android.content.Context;
import android.net.Uri;
import android.os.Bundle;
import android.os.StrictMode;
import android.text.TextUtils;
import android.view.InputEvent;
import android.view.MotionEvent;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.applovin.adview.AppLovinAdView;
import com.applovin.impl.sdk.AppLovinError;
import com.applovin.impl.sdk.ad.AppLovinAdImpl;
import com.applovin.impl.sdk.ad.c;
import com.applovin.impl.sdk.ad.d;
import com.applovin.impl.sdk.ad.e;
import com.applovin.impl.sdk.ad.f;
import com.applovin.impl.sdk.ad.i;
import com.applovin.impl.sdk.array.ArrayService;
import com.applovin.impl.sdk.b;
import com.applovin.impl.sdk.e.m;
import com.applovin.impl.sdk.e.n;
import com.applovin.impl.sdk.e.o;
import com.applovin.impl.sdk.e.q;
import com.applovin.impl.sdk.e.r;
import com.applovin.impl.sdk.g;
import com.applovin.impl.sdk.network.h;
import com.applovin.impl.sdk.utils.CollectionUtils;
import com.applovin.impl.sdk.utils.JsonUtils;
import com.applovin.impl.sdk.utils.StringUtils;
import com.applovin.impl.sdk.utils.l;
import com.applovin.impl.sdk.utils.s;
import com.applovin.impl.sdk.utils.u;
import com.applovin.impl.sdk.w;
import com.applovin.sdk.AppLovinAd;
import com.applovin.sdk.AppLovinAdLoadListener;
import com.applovin.sdk.AppLovinAdService;
import com.applovin.sdk.AppLovinAdSize;
import com.applovin.sdk.AppLovinAdType;
import com.applovin.sdk.AppLovinBidTokenCollectionListener;
import com.applovin.sdk.AppLovinSdkUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import org.json.JSONArray;
import org.json.JSONObject;

public class AppLovinAdServiceImpl
implements b.a,
AppLovinAdService {
    private final com.applovin.impl.sdk.m sdk;
    private final w logger;
    private final Map<d, c> alA;
    private final Object alB = new Object();
    private final Map<String, String> aAk = Collections.synchronizedMap(new HashMap());
    private final AtomicReference<JSONObject> aAl = new AtomicReference();

    AppLovinAdServiceImpl(com.applovin.impl.sdk.m m2) {
        this.sdk = m2;
        this.logger = m2.Cv();
        this.alA = new HashMap<d, c>(6);
        this.alA.put(d.GJ(), new c());
        this.alA.put(d.GK(), new c());
        this.alA.put(d.GL(), new c());
        this.alA.put(d.GM(), new c());
        this.alA.put(d.GN(), new c());
        this.alA.put(d.GO(), new c());
    }

    @Override
    public void loadNextAd(AppLovinAdSize appLovinAdSize, AppLovinAdLoadListener appLovinAdLoadListener) {
        this.a(d.a(appLovinAdSize, AppLovinAdType.REGULAR), appLovinAdLoadListener);
    }

    @Override
    public void loadNextAdForZoneId(String string2, AppLovinAdLoadListener appLovinAdLoadListener) {
        if (TextUtils.isEmpty((CharSequence)string2)) {
            throw new IllegalArgumentException("No zone id specified");
        }
        AppLovinAdServiceImpl appLovinAdServiceImpl = this;
        if (appLovinAdServiceImpl.logger.FV()) {
            this.logger.f("AppLovinAdService", "Loading next ad of zone {" + string2 + "}");
        }
        d d2 = d.cT(string2);
        this.a(d2, appLovinAdLoadListener);
    }

    @Override
    public String getBidToken() {
        AppLovinAdServiceImpl appLovinAdServiceImpl = this;
        if (appLovinAdServiceImpl.logger.FV()) {
            this.logger.f("AppLovinAdService", "getBidToken()");
        }
        StrictMode.ThreadPolicy threadPolicy = StrictMode.allowThreadDiskReads();
        String string2 = this.sdk.CE() != null ? this.sdk.CE().getBidToken() : this.sdk.CD().getBidToken();
        StrictMode.setThreadPolicy((StrictMode.ThreadPolicy)threadPolicy);
        if (StringUtils.isValidString(string2)) {
            AppLovinAdServiceImpl appLovinAdServiceImpl2 = this;
            if (appLovinAdServiceImpl2.logger.FV()) {
                this.logger.f("AppLovinAdService", "Successfully retrieved bid token");
            }
        }
        return string2;
    }

    @Override
    public void collectBidToken(AppLovinBidTokenCollectionListener appLovinBidTokenCollectionListener) {
        AppLovinAdServiceImpl appLovinAdServiceImpl = this;
        if (appLovinAdServiceImpl.logger.FV()) {
            this.logger.f("AppLovinAdService", "collectBidToken(listener=" + appLovinBidTokenCollectionListener + ")");
        }
        if (this.sdk.CE() != null) {
            this.sdk.CE().collectBidToken(appLovinBidTokenCollectionListener);
        } else {
            this.sdk.CD().collectBidToken(appLovinBidTokenCollectionListener);
        }
    }

    @Override
    public void loadNextAdForAdToken(String string2, AppLovinAdLoadListener appLovinAdLoadListener) {
        String string3;
        String string4 = string3 = string2 != null ? string2.trim() : null;
        if (TextUtils.isEmpty((CharSequence)string3)) {
            w.I("AppLovinAdService", "Empty ad token");
            AppLovinError appLovinError = new AppLovinError(-8, "Empty ad token");
            this.a(appLovinError, appLovinAdLoadListener);
            return;
        }
        com.applovin.impl.sdk.ad.c c2 = new com.applovin.impl.sdk.ad.c(string3, this.sdk);
        AppLovinAdLoadListener appLovinAdLoadListener2 = this.sdk.a(com.applovin.impl.sdk.c.b.aLk) != false ? new a(appLovinAdLoadListener) : appLovinAdLoadListener;
        if (c2.GE() == c.a.aGH) {
            AppLovinAdServiceImpl appLovinAdServiceImpl = this;
            if (appLovinAdServiceImpl.logger.FV()) {
                this.logger.f("AppLovinAdService", "Loading next ad for token: " + c2);
            }
            o o2 = new o(c2, appLovinAdLoadListener2, this.sdk);
            this.a(o2);
        } else if (c2.GE() == c.a.aGI) {
            JSONObject jSONObject = c2.GG();
            if (jSONObject != null) {
                com.applovin.impl.sdk.utils.i.j(jSONObject, this.sdk);
                com.applovin.impl.sdk.utils.i.i(jSONObject, this.sdk);
                com.applovin.impl.sdk.utils.i.k(jSONObject, this.sdk);
                g.o(this.sdk);
                JSONArray jSONArray = JsonUtils.getJSONArray(jSONObject, "ads", new JSONArray());
                if (jSONArray.length() > 0) {
                    AppLovinAdServiceImpl appLovinAdServiceImpl = this;
                    if (appLovinAdServiceImpl.logger.FV()) {
                        this.logger.f("AppLovinAdService", "Rendering ad for token: " + c2);
                    }
                    d d2 = u.l(jSONObject, this.sdk);
                    r r2 = new r(jSONObject, d2, com.applovin.impl.sdk.ad.b.aGE, appLovinAdLoadListener2, this.sdk);
                    this.a(r2);
                } else {
                    AppLovinAdServiceImpl appLovinAdServiceImpl = this;
                    if (appLovinAdServiceImpl.logger.FV()) {
                        this.logger.i("AppLovinAdService", "No ad returned from the server for token: " + c2);
                    }
                    this.a(AppLovinError.NO_FILL, appLovinAdLoadListener);
                }
            } else {
                String string5 = "Unable to retrieve ad response JSON from token: " + c2.mP();
                AppLovinError appLovinError = new AppLovinError(-8, string5);
                w.I("AppLovinAdService", string5);
                this.a(appLovinError, appLovinAdLoadListener);
            }
        } else {
            String string6 = "Invalid token type";
            AppLovinError appLovinError = new AppLovinError(-8, "Invalid token type");
            w.I("AppLovinAdService", "Invalid token type");
            this.a(appLovinError, appLovinAdLoadListener);
        }
    }

    @Override
    public void loadNextAdForZoneIds(List<String> list, AppLovinAdLoadListener appLovinAdLoadListener) {
        List<String> list2 = CollectionUtils.removeTrimmedEmptyStrings(list);
        if (list2 == null || list2.isEmpty()) {
            w.I("AppLovinAdService", "No zones were provided");
            AppLovinError appLovinError = new AppLovinError(-7, "");
            this.b(appLovinError, appLovinAdLoadListener);
            return;
        }
        AppLovinAdServiceImpl appLovinAdServiceImpl = this;
        if (appLovinAdServiceImpl.logger.FV()) {
            this.logger.f("AppLovinAdService", "Loading next ad for zones: " + list2);
        }
        m m2 = new m(list2, appLovinAdLoadListener, this.sdk);
        this.a(m2);
    }

    public void loadNextIncentivizedAd(String string2, AppLovinAdLoadListener appLovinAdLoadListener) {
        AppLovinAdServiceImpl appLovinAdServiceImpl = this;
        if (appLovinAdServiceImpl.logger.FV()) {
            this.logger.f("AppLovinAdService", "Loading next incentivized ad of zone {" + string2 + "}");
        }
        d d2 = d.cU(string2);
        this.a(d2, appLovinAdLoadListener);
    }

    public void loadNextAd(String string2, AppLovinAdSize appLovinAdSize, AppLovinAdLoadListener appLovinAdLoadListener) {
        AppLovinAdServiceImpl appLovinAdServiceImpl = this;
        if (appLovinAdServiceImpl.logger.FV()) {
            this.logger.f("AppLovinAdService", "Loading next ad of zone {" + string2 + "} with size " + appLovinAdSize);
        }
        d d2 = d.a(appLovinAdSize, AppLovinAdType.REGULAR, string2);
        this.a(d2, appLovinAdLoadListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void a(d d2, AppLovinAdLoadListener appLovinAdLoadListener) {
        if (d2 == null) {
            throw new IllegalArgumentException("No zone specified");
        }
        if (appLovinAdLoadListener == null) {
            throw new IllegalArgumentException("No callback specified");
        }
        this.sdk.Cv();
        if (w.FV()) {
            this.sdk.Cv().f("AppLovinAdService", "Loading next ad of zone {" + d2 + "}...");
        }
        c c2 = this.g(d2);
        Object object = c2.aAu;
        synchronized (object) {
            c2.aAx.add(appLovinAdLoadListener);
            if (!c2.aAv) {
                c2.aAv = true;
                b b2 = new b(d2, c2);
                this.a(d2, b2);
            } else {
                AppLovinAdServiceImpl appLovinAdServiceImpl = this;
                if (appLovinAdServiceImpl.logger.FV()) {
                    this.logger.f("AppLovinAdService", "Already waiting on an ad load...");
                }
            }
        }
    }

    private void a(com.applovin.impl.sdk.e.d d2) {
        if (!this.sdk.isEnabled()) {
            w.G("AppLovinSdk", "Attempted to load ad before SDK initialization. Please wait until after the SDK has initialized, e.g. AppLovinSdk.initializeSdk(Context, SdkInitializationListener).");
        }
        this.sdk.BQ();
        this.sdk.Cx().a(d2, q.a.aVh);
    }

    private void a(AppLovinAd appLovinAd, AppLovinAdLoadListener appLovinAdLoadListener) {
        AppLovinSdkUtils.runOnUiThread(true, () -> {
            try {
                appLovinAdLoadListener.adReceived(appLovinAd);
            }
            catch (Throwable throwable) {
                w.e("AppLovinAdService", "Unable to notify listener about a newly loaded ad", throwable);
                this.sdk.Cw().d("AppLovinAdService", "notifyAdLoadedCallback", throwable);
            }
        });
    }

    private void a(AppLovinError appLovinError, AppLovinAdLoadListener appLovinAdLoadListener) {
        if (appLovinAdLoadListener instanceof i) {
            ((i)appLovinAdLoadListener).failedToReceiveAdV2(appLovinError);
        } else {
            appLovinAdLoadListener.failedToReceiveAd(appLovinError.getCode());
        }
    }

    private void b(AppLovinError appLovinError, AppLovinAdLoadListener appLovinAdLoadListener) {
        AppLovinSdkUtils.runOnUiThread(true, () -> {
            try {
                this.a(appLovinError, appLovinAdLoadListener);
            }
            catch (Throwable throwable) {
                w.e("AppLovinAdService", "Unable to notify listener about ad load failure", throwable);
                String string2 = "notifyAdLoadFailedCallback" + (appLovinAdLoadListener instanceof i ? "V2" : "");
                this.sdk.Cw().d("AppLovinAdService", string2, throwable);
            }
        });
    }

    public AppLovinAd dequeueAd(d d2) {
        AppLovinAdImpl appLovinAdImpl = this.sdk.CK().b(d2);
        AppLovinAdServiceImpl appLovinAdServiceImpl = this;
        if (appLovinAdServiceImpl.logger.FV()) {
            this.logger.f("AppLovinAdService", "Dequeued ad: " + appLovinAdImpl + " for zone: " + d2 + "...");
        }
        return appLovinAdImpl;
    }

    public void addCustomQueryParams(Map<String, String> map) {
        this.aAk.putAll(map);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getAndResetCustomQueryParams() {
        Map<String, String> map;
        Map<String, String> map2 = this.aAk;
        synchronized (map2) {
            map = CollectionUtils.map(this.aAk);
            this.aAk.clear();
        }
        return map;
    }

    public void setCustomPostBody(JSONObject jSONObject) {
        this.aAl.set(jSONObject);
    }

    public JSONObject getAndResetCustomPostBody() {
        return this.aAl.getAndSet(null);
    }

    public void trackAndLaunchVideoClick(final e e2, final Uri uri, MotionEvent motionEvent, @Nullable Bundle bundle, final com.applovin.impl.adview.activity.b.a a2, final Context context) {
        if (e2 == null) {
            AppLovinAdServiceImpl appLovinAdServiceImpl = this;
            if (appLovinAdServiceImpl.logger.FV()) {
                this.logger.i("AppLovinAdService", "Unable to track video click. No ad specified");
            }
            return;
        }
        if (bundle != null && Boolean.parseBoolean(bundle.getString("skip_click_tracking"))) {
            AppLovinAdServiceImpl appLovinAdServiceImpl = this;
            if (appLovinAdServiceImpl.logger.FV()) {
                this.logger.f("AppLovinAdService", "Skipping tracking for VIDEO click on an ad...");
            }
        } else {
            AppLovinAdServiceImpl appLovinAdServiceImpl = this;
            if (appLovinAdServiceImpl.logger.FV()) {
                this.logger.f("AppLovinAdService", "Tracking VIDEO click on an ad...");
            }
            boolean bl = bundle != null && Boolean.parseBoolean(bundle.getString("install_click"));
            this.maybeSubmitPersistentPostbacks(e2.a(motionEvent, bl));
            if (this.sdk.CG() != null) {
                List<String> list = e2.d(motionEvent, true, bl);
                this.sdk.CG().a(list, (InputEvent)motionEvent);
            }
        }
        if (e2.isDirectDownloadEnabled()) {
            this.sdk.CZ().startDirectInstallOrDownloadProcess(e2, bundle, new ArrayService.DirectDownloadListener(){

                @Override
                public void onAppDetailsDisplayed() {
                    AppLovinAdServiceImpl.this.sdk.CN().pauseForClick();
                }

                @Override
                public void onAppDetailsDismissed() {
                    AppLovinAdServiceImpl.this.sdk.CN().resumeForClick();
                }

                @Override
                public void onFailure() {
                    AppLovinAdServiceImpl.this.logger;
                    if (w.FV()) {
                        AppLovinAdServiceImpl.this.logger.f("AppLovinAdService", "Could not execute Direct Install/Direct Download - falling back to normal click logic");
                    }
                    AppLovinAdServiceImpl.this.a(e2, uri, a2, context);
                }
            });
        } else {
            this.a(e2, uri, a2, context);
        }
    }

    public void trackAndLaunchClick(final e e2, final AppLovinAdView appLovinAdView, final com.applovin.impl.adview.b b2, final Uri uri, @Nullable MotionEvent motionEvent, boolean bl, @Nullable Bundle bundle) {
        if (e2 == null) {
            AppLovinAdServiceImpl appLovinAdServiceImpl = this;
            if (appLovinAdServiceImpl.logger.FV()) {
                this.logger.i("AppLovinAdService", "Unable to track ad view click. No ad specified");
            }
            return;
        }
        if (bundle != null && Boolean.parseBoolean(bundle.getString("skip_click_tracking"))) {
            AppLovinAdServiceImpl appLovinAdServiceImpl = this;
            if (appLovinAdServiceImpl.logger.FV()) {
                this.logger.f("AppLovinAdService", "Skipping tracking for click on an ad...");
            }
        } else {
            AppLovinAdServiceImpl appLovinAdServiceImpl = this;
            if (appLovinAdServiceImpl.logger.FV()) {
                this.logger.f("AppLovinAdService", "Tracking click on an ad...");
            }
            boolean bl2 = bundle != null && Boolean.parseBoolean(bundle.getString("install_click"));
            this.maybeSubmitPersistentPostbacks(e2.a(motionEvent, bl, bl2));
            if (this.sdk.CG() != null) {
                List<String> list = e2.d(motionEvent, false, bl2);
                this.sdk.CG().a(list, (InputEvent)motionEvent);
            }
        }
        if (appLovinAdView != null && uri != null) {
            if (e2.isDirectDownloadEnabled()) {
                this.sdk.CZ().startDirectInstallOrDownloadProcess(e2, bundle, new ArrayService.DirectDownloadListener(){

                    @Override
                    public void onAppDetailsDisplayed() {
                        AppLovinAdServiceImpl.this.sdk.CN().pauseForClick();
                        if (b2 != null) {
                            b2.qV();
                            l.a(b2.rb(), (AppLovinAd)e2, appLovinAdView);
                        }
                    }

                    @Override
                    public void onAppDetailsDismissed() {
                        if (b2 != null) {
                            AppLovinAdServiceImpl.this.sdk.CN().resumeForClick();
                            l.b(b2.rb(), (AppLovinAd)e2, appLovinAdView);
                        }
                    }

                    @Override
                    public void onFailure() {
                        AppLovinAdServiceImpl.this.logger;
                        if (w.FV()) {
                            AppLovinAdServiceImpl.this.logger.f("AppLovinAdService", "Could not execute Direct Install/Direct Download - falling back to normal click logic");
                        }
                        AppLovinAdServiceImpl.this.a(e2, appLovinAdView, b2, uri);
                    }
                });
            } else {
                this.a(e2, appLovinAdView, b2, uri);
            }
        } else {
            AppLovinAdServiceImpl appLovinAdServiceImpl = this;
            if (appLovinAdServiceImpl.logger.FV()) {
                this.logger.i("AppLovinAdService", "Unable to launch click - adView has been prematurely destroyed");
            }
        }
    }

    private void a(e e2, Uri uri, com.applovin.impl.adview.activity.b.a a2, Context context) {
        if (this.cy(uri.getScheme())) {
            this.a(uri, e2, null, a2);
        } else if (s.s(uri)) {
            this.a(uri, e2, null, null, context, this.sdk);
        } else {
            s.a(uri, context, this.sdk);
        }
    }

    private void a(e e2, AppLovinAdView appLovinAdView, com.applovin.impl.adview.b b2, Uri uri) {
        if (this.cy(uri.getScheme())) {
            this.a(uri, e2, b2, null);
        } else if (s.s(uri)) {
            this.a(uri, e2, appLovinAdView, b2, appLovinAdView.getContext(), this.sdk);
        } else {
            this.a(uri, e2, appLovinAdView, b2);
        }
    }

    public void trackImpression(e e2) {
        if (e2 == null) {
            AppLovinAdServiceImpl appLovinAdServiceImpl = this;
            if (appLovinAdServiceImpl.logger.FV()) {
                this.logger.i("AppLovinAdService", "Unable to track impression click. No ad specified");
            }
            return;
        }
        AppLovinAdServiceImpl appLovinAdServiceImpl = this;
        if (appLovinAdServiceImpl.logger.FV()) {
            this.logger.f("AppLovinAdService", "Tracking impression on ad...");
        }
        this.maybeSubmitPersistentPostbacks(e2.Ie());
        if (this.sdk.CG() != null) {
            this.sdk.CG().I(e2.getPrivacySandboxImpressionAttributionUrls());
        }
    }

    public void trackVideoEnd(e e2, long l2, int n2, boolean bl) {
        List<com.applovin.impl.sdk.d.a> list;
        if (e2 == null) {
            AppLovinAdServiceImpl appLovinAdServiceImpl = this;
            if (appLovinAdServiceImpl.logger.FV()) {
                this.logger.i("AppLovinAdService", "Unable to track video end. No ad specified");
            }
            return;
        }
        AppLovinAdServiceImpl appLovinAdServiceImpl = this;
        if (appLovinAdServiceImpl.logger.FV()) {
            this.logger.f("AppLovinAdService", "Tracking video end on ad...");
        }
        if ((list = e2.Ib()) != null && !list.isEmpty()) {
            String string2 = Long.toString(System.currentTimeMillis());
            for (com.applovin.impl.sdk.d.a a2 : list) {
                if (StringUtils.isValidString(a2.KW())) {
                    String string3 = this.a(a2.KW(), l2, n2, string2, bl);
                    String string4 = this.a(a2.JG(), l2, n2, string2, bl);
                    if (string3 != null) {
                        com.applovin.impl.sdk.d.a a3 = new com.applovin.impl.sdk.d.a(string3, string4);
                        this.a(a3);
                        continue;
                    }
                    AppLovinAdServiceImpl appLovinAdServiceImpl2 = this;
                    if (!appLovinAdServiceImpl2.logger.FV()) continue;
                    this.logger.i("AppLovinAdService", "Failed to parse url: " + a2.KW());
                    continue;
                }
                AppLovinAdServiceImpl appLovinAdServiceImpl3 = this;
                if (!appLovinAdServiceImpl3.logger.FV()) continue;
                this.logger.h("AppLovinAdService", "Requested a postback dispatch for an empty video end URL; nothing to do...");
            }
        } else {
            AppLovinAdServiceImpl appLovinAdServiceImpl4 = this;
            if (appLovinAdServiceImpl4.logger.FV()) {
                this.logger.h("AppLovinAdService", "Unable to submit persistent postback for AD #" + e2.getAdIdNumber() + ". Missing video end tracking URL.");
            }
        }
    }

    private String a(String string2, long l2, int n2, String string3, boolean bl) {
        try {
            if (StringUtils.isValidString(string2)) {
                if (n2 < 0 || n2 > 100) {
                    n2 = 0;
                }
                Uri uri = Uri.parse((String)string2);
                Uri uri2 = uri.buildUpon().appendQueryParameter("et_s", Long.toString(l2)).appendQueryParameter("pv", Integer.toString(n2)).appendQueryParameter("vid_ts", string3).appendQueryParameter("uvs", Boolean.toString(bl)).build();
                return uri2.toString();
            }
            return null;
        }
        catch (Throwable throwable) {
            AppLovinAdServiceImpl appLovinAdServiceImpl = this;
            if (appLovinAdServiceImpl.logger.FV()) {
                this.logger.c("AppLovinAdService", "Unknown error parsing the video end url: " + string2, throwable);
            }
            this.sdk.Cw().d("AppLovinAdService", "buildVideoEndUrl", throwable);
            return null;
        }
    }

    private void a(Uri uri, e e2, AppLovinAdView appLovinAdView, com.applovin.impl.adview.b b2) {
        boolean bl = s.a(uri, appLovinAdView.getContext(), this.sdk);
        if (bl) {
            l.c(b2.rb(), (AppLovinAd)e2, appLovinAdView);
        }
        b2.qV();
    }

    public void trackCustomTabsNavigationStarted(e e2) {
        AppLovinAdServiceImpl appLovinAdServiceImpl = this;
        if (appLovinAdServiceImpl.logger.FV()) {
            this.logger.f("AppLovinAdService", "Tracking Custom Tabs navigation started on ad...");
        }
        this.maybeSubmitPersistentPostbacks(e2.Iv());
    }

    public void trackCustomTabsNavigationFinished(e e2) {
        AppLovinAdServiceImpl appLovinAdServiceImpl = this;
        if (appLovinAdServiceImpl.logger.FV()) {
            this.logger.f("AppLovinAdService", "Tracking Custom Tabs navigation finished on ad...");
        }
        this.maybeSubmitPersistentPostbacks(e2.Iw());
    }

    public void trackCustomTabsNavigationFailed(e e2) {
        AppLovinAdServiceImpl appLovinAdServiceImpl = this;
        if (appLovinAdServiceImpl.logger.FV()) {
            this.logger.f("AppLovinAdService", "Tracking Custom Tabs navigation failed on ad...");
        }
        this.maybeSubmitPersistentPostbacks(e2.Ix());
    }

    public void trackCustomTabsNavigationAborted(e e2) {
        AppLovinAdServiceImpl appLovinAdServiceImpl = this;
        if (appLovinAdServiceImpl.logger.FV()) {
            this.logger.f("AppLovinAdService", "Tracking Custom Tabs navigation aborted on ad...");
        }
        this.maybeSubmitPersistentPostbacks(e2.Iy());
    }

    public void trackCustomTabsTabShown(e e2) {
        AppLovinAdServiceImpl appLovinAdServiceImpl = this;
        if (appLovinAdServiceImpl.logger.FV()) {
            this.logger.f("AppLovinAdService", "Tracking Custom Tabs tab shown on ad...");
        }
        this.maybeSubmitPersistentPostbacks(e2.Iz());
    }

    public void trackCustomTabsTabHidden(e e2) {
        AppLovinAdServiceImpl appLovinAdServiceImpl = this;
        if (appLovinAdServiceImpl.logger.FV()) {
            this.logger.f("AppLovinAdService", "Tracking Custom Tabs tab hidden on ad...");
        }
        this.maybeSubmitPersistentPostbacks(e2.IA());
    }

    private boolean cy(String string2) {
        String string3 = this.sdk.getSettings().getExtraParameters().get("forwarding_click_scheme");
        return StringUtils.isValidString(string3) && StringUtils.isValidString(string2) && string2.equalsIgnoreCase(string3);
    }

    private void a(Uri uri, e e2, com.applovin.impl.adview.b b2, com.applovin.impl.adview.activity.b.a a2) {
        AppLovinAdServiceImpl appLovinAdServiceImpl = this;
        if (appLovinAdServiceImpl.logger.FV()) {
            this.logger.f("AppLovinAdService", "Forwarding click " + uri);
        }
        e2.setMaxAdValue("forwarding_clicked_url", uri.toString());
        String string2 = this.sdk.getSettings().getExtraParameters().get("close_ad_on_forwarding_click_scheme");
        if (StringUtils.isValidString(string2) && Boolean.parseBoolean(string2)) {
            if (a2 != null) {
                AppLovinSdkUtils.runOnUiThread(true, () -> {
                    if (a2 != null) {
                        AppLovinAdServiceImpl appLovinAdServiceImpl = this;
                        if (appLovinAdServiceImpl.logger.FV()) {
                            this.logger.f("AppLovinAdService", "Dismissing ad after forwarding click");
                        }
                        a2.dismiss();
                    }
                });
            } else if (b2 != null && !u.c(e2.getSize())) {
                AppLovinAdServiceImpl appLovinAdServiceImpl2 = this;
                if (appLovinAdServiceImpl2.logger.FV()) {
                    this.logger.f("AppLovinAdService", "Closing ad after forwarding click");
                }
                b2.qR();
            }
        }
    }

    private void a(Uri uri, e e2, @Nullable AppLovinAdView appLovinAdView, @Nullable com.applovin.impl.adview.b b2, Context context, com.applovin.impl.sdk.m m2) {
        if (uri != null && StringUtils.isValidString(uri.getQuery())) {
            Uri uri2 = this.a(uri, "primaryUrl");
            List<Uri> list = this.b(uri, "primaryTrackingUrl");
            Uri uri3 = this.a(uri, "fallbackUrl");
            List<Uri> list2 = this.b(uri, "fallbackTrackingUrl");
            if (uri2 == null && uri3 == null) {
                m2.Cv();
                if (w.FV()) {
                    m2.Cv().i("AppLovinAdService", "Failed to parse both primary and backup URLs for Deep Link+ command");
                }
                return;
            }
            if (!this.a(uri2, "primary", list, e2, appLovinAdView, b2, context, m2)) {
                this.a(uri3, "backup", list2, e2, appLovinAdView, b2, context, m2);
            }
            if (b2 != null) {
                b2.qV();
            }
        } else {
            m2.Cv();
            if (w.FV()) {
                m2.Cv().i("AppLovinAdService", "Failed to execute Deep Link+ command - no query parameters found");
            }
        }
    }

    private boolean a(Uri uri, String string2, List<Uri> list, e e2, @Nullable AppLovinAdView appLovinAdView, @Nullable com.applovin.impl.adview.b b2, Context context, com.applovin.impl.sdk.m m2) {
        boolean bl;
        m2.Cv();
        if (w.FV()) {
            m2.Cv().f("AppLovinAdService", "Opening " + string2 + " URL: " + uri);
        }
        if (bl = s.a(uri, context, m2)) {
            m2.Cv();
            if (w.FV()) {
                m2.Cv().f("AppLovinAdService", "URL opened successfully, dispatching tracking URLs: " + list);
            }
            for (Uri uri2 : list) {
                m2.Db().dispatchPostbackAsync(uri2.toString(), null);
            }
            if (b2 != null) {
                l.c(b2.rb(), (AppLovinAd)e2, appLovinAdView);
            }
        } else {
            m2.Cv();
            if (w.FV()) {
                m2.Cv().i("AppLovinAdService", "URL failed to open");
            }
        }
        return bl;
    }

    @Nullable
    private Uri a(Uri uri, String string2) {
        try {
            return Uri.parse((String)uri.getQueryParameter(string2));
        }
        catch (Throwable throwable) {
            this.sdk.Cv();
            if (w.FV()) {
                this.sdk.Cv().h("AppLovinAdService", "Unable to parse query parameter into Uri: " + string2);
            }
            this.sdk.Cw().d("AppLovinAdService", "buildDeepLinkPlusUrl", throwable);
            return null;
        }
    }

    private List<Uri> b(Uri uri, String string2) {
        List list = uri.getQueryParameters(string2);
        ArrayList<Uri> arrayList = new ArrayList<Uri>(list.size());
        for (String string3 : list) {
            try {
                arrayList.add(Uri.parse((String)string3));
            }
            catch (Throwable throwable) {
                this.sdk.Cv();
                if (w.FV()) {
                    this.sdk.Cv().h("AppLovinAdService", "Unable to parse query parameter into Uri: " + string2);
                }
                this.sdk.Cw().d("AppLovinAdService", "buildDeepLinkPlusUrlList", throwable);
            }
        }
        return arrayList;
    }

    public void trackFullScreenAdClosed(e e2, long l2, List<Long> list, long l3, boolean bl, int n2) {
        List<com.applovin.impl.sdk.d.a> list2;
        if (e2 == null) {
            AppLovinAdServiceImpl appLovinAdServiceImpl = this;
            if (appLovinAdServiceImpl.logger.FV()) {
                this.logger.i("AppLovinAdService", "Unable to track ad closed. No ad specified.");
            }
            return;
        }
        AppLovinAdServiceImpl appLovinAdServiceImpl = this;
        if (appLovinAdServiceImpl.logger.FV()) {
            this.logger.f("AppLovinAdService", "Tracking ad closed...");
        }
        if ((list2 = e2.Ic()) != null && !list2.isEmpty()) {
            for (com.applovin.impl.sdk.d.a a2 : list2) {
                String string2 = this.a(a2.KW(), l2, l3, list, bl, n2);
                String string3 = this.a(a2.JG(), l2, l3, list, bl, n2);
                if (StringUtils.isValidString(string2)) {
                    com.applovin.impl.sdk.d.a a3 = new com.applovin.impl.sdk.d.a(string2, string3);
                    this.a(a3);
                    continue;
                }
                AppLovinAdServiceImpl appLovinAdServiceImpl2 = this;
                if (!appLovinAdServiceImpl2.logger.FV()) continue;
                this.logger.i("AppLovinAdService", "Failed to parse url: " + a2.KW());
            }
        } else {
            AppLovinAdServiceImpl appLovinAdServiceImpl3 = this;
            if (appLovinAdServiceImpl3.logger.FV()) {
                this.logger.h("AppLovinAdService", "Unable to track ad closed for AD #" + e2.getAdIdNumber() + ". Missing ad close tracking URL." + e2.getAdIdNumber());
            }
        }
    }

    private String a(String string2, long l2, long l3, List<Long> list, boolean bl, int n2) {
        if (StringUtils.isValidString(string2)) {
            Uri.Builder builder = Uri.parse((String)string2).buildUpon().appendQueryParameter("et_ms", Long.toString(l2)).appendQueryParameter("vs_ms", Long.toString(l3));
            if (list != null && list.size() > 0) {
                builder.appendQueryParameter("ec_ms", list.toString());
            }
            if (n2 != com.applovin.impl.sdk.h.aBc) {
                builder.appendQueryParameter("musw_ch", Boolean.toString(bl));
                builder.appendQueryParameter("musw_st", Boolean.toString(com.applovin.impl.sdk.h.gx(n2)));
            }
            return builder.build().toString();
        }
        return null;
    }

    public void trackAppKilled(e e2) {
        List<com.applovin.impl.sdk.d.a> list;
        if (e2 == null) {
            AppLovinAdServiceImpl appLovinAdServiceImpl = this;
            if (appLovinAdServiceImpl.logger.FV()) {
                this.logger.i("AppLovinAdService", "Unable to track app killed. No ad specified");
            }
            return;
        }
        AppLovinAdServiceImpl appLovinAdServiceImpl = this;
        if (appLovinAdServiceImpl.logger.FV()) {
            this.logger.f("AppLovinAdService", "Tracking app killed during ad...");
        }
        if ((list = e2.Id()) != null && !list.isEmpty()) {
            for (com.applovin.impl.sdk.d.a a2 : list) {
                com.applovin.impl.sdk.d.a a3 = new com.applovin.impl.sdk.d.a(a2.KW(), a2.JG());
                this.a(a3);
            }
        } else {
            AppLovinAdServiceImpl appLovinAdServiceImpl2 = this;
            if (appLovinAdServiceImpl2.logger.FV()) {
                this.logger.h("AppLovinAdService", "Unable to track app killed during AD #" + e2.getAdIdNumber() + ". Missing app killed tracking URL.");
            }
        }
    }

    public void maybeSubmitPersistentPostbacks(List<com.applovin.impl.sdk.d.a> list) {
        if (list != null && !list.isEmpty()) {
            for (com.applovin.impl.sdk.d.a a2 : list) {
                this.a(a2);
            }
        }
    }

    private void a(com.applovin.impl.sdk.d.a a2) {
        if (StringUtils.isValidString(a2.KW())) {
            String string2 = a2.KW();
            String string3 = StringUtils.isValidString(a2.JG()) ? a2.JG() : null;
            this.sdk.Dc().a(h.JO().dh(string2).di(string3).n(a2.Jb()).aX(false).ba(a2.JI()).JQ());
        } else {
            AppLovinAdServiceImpl appLovinAdServiceImpl = this;
            if (appLovinAdServiceImpl.logger.FV()) {
                this.logger.h("AppLovinAdService", "Requested a postback dispatch for a null URL; nothing to do...");
            }
        }
    }

    private void a(d d2, b b2) {
        AppLovinAdImpl appLovinAdImpl = this.sdk.CK().a(d2);
        if (appLovinAdImpl != null && !appLovinAdImpl.isExpired()) {
            AppLovinAdServiceImpl appLovinAdServiceImpl = this;
            if (appLovinAdServiceImpl.logger.FV()) {
                this.logger.f("AppLovinAdService", "Using pre-loaded ad: " + appLovinAdImpl + " for " + d2);
            }
            b2.adReceived(appLovinAdImpl);
        } else {
            n n2 = new n(d2, b2, this.sdk);
            this.a(n2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private c g(d d2) {
        c c2;
        Object object = this.alB;
        synchronized (object) {
            c2 = this.alA.get(d2);
            if (c2 == null) {
                c2 = new c();
                this.alA.put(d2, c2);
            }
        }
        return c2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onAdExpired(com.applovin.impl.sdk.ad.g g2) {
        AppLovinAdImpl appLovinAdImpl = (AppLovinAdImpl)g2;
        d d2 = appLovinAdImpl.getAdZone();
        AppLovinAdServiceImpl appLovinAdServiceImpl = this;
        if (appLovinAdServiceImpl.logger.FV()) {
            this.logger.h("AppLovinAdService", "Ad expired for zone: " + d2);
        }
        this.sdk.CK().b(appLovinAdImpl);
        if (this.sdk.BU() || !this.sdk.a(com.applovin.impl.sdk.c.b.aMX).booleanValue()) {
            return;
        }
        c c2 = this.g(d2);
        Object object = c2.aAu;
        synchronized (object) {
            if (!c2.aAv) {
                this.sdk.Cv();
                if (w.FV()) {
                    this.sdk.Cv().f("AppLovinAdService", "Reloading ad after expiration for zone {" + d2 + "}...");
                }
                c2.aAv = true;
                c2.aAw = true;
                b b2 = new b(d2, c2);
                this.a(d2, b2);
            } else {
                AppLovinAdServiceImpl appLovinAdServiceImpl2 = this;
                if (appLovinAdServiceImpl2.logger.FV()) {
                    this.logger.f("AppLovinAdService", "Cancelled expired ad reload. Already waiting on an ad load...");
                }
            }
        }
    }

    @NonNull
    public String toString() {
        return "AppLovinAdService{adLoadStates=" + this.alA + '}';
    }

    private static class c {
        final Object aAu = new Object();
        boolean aAv;
        int ame;
        boolean aAw;
        final Collection<AppLovinAdLoadListener> aAx = new HashSet<AppLovinAdLoadListener>();

        private c() {
        }

        @NonNull
        public String toString() {
            return "AdLoadState{, isWaitingForAd=" + this.aAv + ", isReloadingExpiredAd=" + this.aAw + ", pendingAdListeners=" + this.aAx + '}';
        }
    }

    private class a
    implements i {
        private AppLovinAdLoadListener awI;

        @Override
        public void adReceived(AppLovinAd appLovinAd) {
            if (!(appLovinAd instanceof f)) {
                AppLovinAdImpl appLovinAdImpl = (AppLovinAdImpl)appLovinAd;
                AppLovinAdServiceImpl.this.sdk.CK().a(appLovinAdImpl);
                if (appLovinAdImpl.canExpire()) {
                    AppLovinAdServiceImpl.this.sdk.CL().a(appLovinAdImpl, AppLovinAdServiceImpl.this);
                }
                appLovinAd = new f(appLovinAdImpl.getAdZone(), AppLovinAdServiceImpl.this.sdk);
            }
            if (this.awI != null) {
                this.awI.adReceived(appLovinAd);
            } else if (AppLovinAdServiceImpl.this.sdk.a(com.applovin.impl.sdk.c.b.aLl).booleanValue()) {
                throw new IllegalStateException("Unable to notify listener about ad load");
            }
        }

        @Override
        public void failedToReceiveAd(int n2) {
            AppLovinError appLovinError = new AppLovinError(n2, "");
            this.failedToReceiveAdV2(appLovinError);
        }

        @Override
        public void failedToReceiveAdV2(AppLovinError appLovinError) {
            AppLovinAdServiceImpl.this.b(appLovinError, this.awI);
            this.awI = null;
        }

        public a(AppLovinAdLoadListener appLovinAdLoadListener) {
            this.awI = appLovinAdLoadListener;
        }
    }

    private class b
    implements i {
        private final d aAs;
        private final c aAt;
        private final int ama;

        private b(d d2, c c2) {
            this.aAs = d2;
            this.aAt = c2;
            String string2 = AppLovinAdServiceImpl.this.sdk.getSettings().getExtraParameters().get("disable_auto_retries");
            this.ama = Boolean.parseBoolean(string2) ? -1 : AppLovinAdServiceImpl.this.sdk.a(com.applovin.impl.sdk.c.b.aLo);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void adReceived(AppLovinAd appLovinAd) {
            HashSet<AppLovinAdLoadListener> hashSet;
            if (!(appLovinAd instanceof f)) {
                hashSet = (AppLovinAdImpl)appLovinAd;
                AppLovinAdServiceImpl.this.sdk.CK().a((AppLovinAdImpl)((Object)hashSet));
                if (((AppLovinAdImpl)((Object)hashSet)).canExpire()) {
                    AppLovinAdServiceImpl.this.sdk.CL().a((com.applovin.impl.sdk.ad.g)((Object)hashSet), AppLovinAdServiceImpl.this);
                }
                appLovinAd = new f(((AppLovinAdImpl)((Object)hashSet)).getAdZone(), AppLovinAdServiceImpl.this.sdk);
            }
            hashSet = Collections.emptySet();
            Iterator iterator = this.aAt.aAu;
            synchronized (iterator) {
                if (!this.aAt.aAw) {
                    hashSet = new HashSet<AppLovinAdLoadListener>(this.aAt.aAx);
                    this.aAt.aAx.clear();
                }
                this.aAt.ame = 0;
                this.aAt.aAv = false;
                this.aAt.aAw = false;
            }
            for (AppLovinAdLoadListener appLovinAdLoadListener : hashSet) {
                AppLovinAdServiceImpl.this.a(appLovinAd, appLovinAdLoadListener);
            }
        }

        @Override
        public void failedToReceiveAd(int n2) {
            AppLovinError appLovinError = new AppLovinError(n2, "");
            this.failedToReceiveAdV2(appLovinError);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void failedToReceiveAdV2(AppLovinError appLovinError) {
            Set<AppLovinAdLoadListener> set = Collections.emptySet();
            Object object = this.aAt.aAu;
            synchronized (object) {
                AppLovinAdSize appLovinAdSize = this.aAs.getSize();
                if (this.b(appLovinAdSize) && this.aAt.ame < this.ama) {
                    ++this.aAt.ame;
                    int n2 = (int)Math.pow(2.0, this.aAt.ame);
                    AppLovinAdServiceImpl.this.logger;
                    if (w.FV()) {
                        AppLovinAdServiceImpl.this.logger.f("AppLovinAdService", "Failed to load ad of zone {" + this.aAs.mP() + "} with size " + appLovinAdSize + ". Current retry attempt: " + this.aAt.ame + " of " + this.ama + ". Retrying again in " + n2 + " seconds...");
                    }
                    AppLovinSdkUtils.runOnUiThreadDelayed(() -> AppLovinAdServiceImpl.this.a(this.aAs, this), TimeUnit.SECONDS.toMillis(n2));
                } else {
                    set = new HashSet<AppLovinAdLoadListener>(this.aAt.aAx);
                    this.aAt.aAx.clear();
                    this.aAt.ame = 0;
                    this.aAt.aAv = false;
                    this.aAt.aAw = false;
                    for (AppLovinAdLoadListener appLovinAdLoadListener : set) {
                        AppLovinAdServiceImpl.this.b(appLovinError, appLovinAdLoadListener);
                    }
                }
            }
        }

        private boolean b(@Nullable AppLovinAdSize appLovinAdSize) {
            if (appLovinAdSize == null) {
                return AppLovinAdServiceImpl.this.sdk.a(com.applovin.impl.sdk.c.b.aLq);
            }
            return AppLovinAdServiceImpl.this.sdk.b(com.applovin.impl.sdk.c.b.aLp).contains(appLovinAdSize.getLabel());
        }
    }
}

