/*
 * Decompiled with CFR 0.152.
 */
package com.applovin.impl.sdk;

import android.text.TextUtils;
import androidx.annotation.Nullable;
import com.applovin.impl.sdk.utils.CollectionUtils;
import com.applovin.impl.sdk.utils.StringUtils;
import com.applovin.sdk.AppLovinTargetingData;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;

public class AppLovinTargetingDataImpl
implements AppLovinTargetingData {
    @Nullable
    private AppLovinTargetingData.Gender aAU;
    @Nullable
    private AppLovinTargetingData.AdContentRating aAV;
    @Nullable
    private Integer aAW;
    @Nullable
    private String aAX;
    @Nullable
    private String aAY;
    @Nullable
    private List<String> api;
    @Nullable
    private List<String> aAZ;
    private final Map<String, String> aBa = Collections.synchronizedMap(new HashMap());
    private final Map<String, String> aBb;

    private AppLovinTargetingDataImpl(BuilderImpl builderImpl) {
        this.aAU = builderImpl.aAU;
        this.aAV = builderImpl.aAV;
        this.aAW = builderImpl.aAW;
        this.aAX = builderImpl.aAX;
        this.aAY = builderImpl.aAY;
        this.api = builderImpl.api;
        this.aAZ = builderImpl.aAZ;
        this.aBb = builderImpl.aBb;
    }

    @Deprecated
    protected AppLovinTargetingDataImpl() {
        this.aBb = new HashMap<String, String>();
    }

    @Override
    public void setYearOfBirth(@Nullable Integer n2) {
        this.z("year_of_birth", n2 == null ? null : Integer.toString(n2));
        this.aAW = n2;
    }

    @Override
    public void setGender(@Nullable AppLovinTargetingData.Gender gender) {
        String string2 = null;
        if (gender != null) {
            if (gender == AppLovinTargetingData.Gender.FEMALE) {
                string2 = "F";
            } else if (gender == AppLovinTargetingData.Gender.MALE) {
                string2 = "M";
            } else if (gender == AppLovinTargetingData.Gender.OTHER) {
                string2 = "O";
            }
        }
        this.z("gender", string2);
        this.aAU = gender;
    }

    @Override
    public void setMaximumAdContentRating(@Nullable AppLovinTargetingData.AdContentRating adContentRating) {
        this.z("maximum_ad_content_rating", adContentRating == null || adContentRating == AppLovinTargetingData.AdContentRating.NONE ? null : Integer.toString(adContentRating.ordinal()));
        this.aAV = adContentRating;
    }

    @Override
    public void setEmail(@Nullable String string2) {
        String string3 = string2;
        if (string3 != null) {
            string3 = string3.toLowerCase().trim();
            string3 = StringUtils.toFullSHA1Hash(string3);
        }
        this.z("email", string3);
        this.aAX = string2;
    }

    @Override
    public void setPhoneNumber(@Nullable String string2) {
        String string3 = string2;
        if (string3 != null) {
            string3 = string3.replaceAll("[^0-9]", "");
            string3 = StringUtils.toFullSHA1Hash(string3);
        }
        this.z("phone_number", string3);
        this.aAY = string2;
    }

    @Override
    public void setKeywords(@Nullable List<String> list) {
        this.z("keywords", list == null ? null : CollectionUtils.implode(list, list.size()));
        this.api = list;
    }

    @Override
    public void setInterests(@Nullable List<String> list) {
        this.z("interests", list == null ? null : CollectionUtils.implode(list, list.size()));
        this.aAZ = list;
    }

    @Override
    public void clearAll() {
        this.aBa.clear();
        this.aAW = null;
        this.aAU = null;
        this.aAV = null;
        this.aAX = null;
        this.aAY = null;
        this.api = null;
        this.aAZ = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public Map<String, String> getAllData() {
        Map<String, String> map = this.aBa;
        synchronized (map) {
            return new HashMap<String, String>(this.aBa);
        }
    }

    private void z(String string2, @Nullable String string3) {
        if (TextUtils.isEmpty((CharSequence)string2)) {
            return;
        }
        if (StringUtils.isValidString(string3)) {
            this.aBa.put(string2, string3);
        } else {
            this.aBa.remove(string2);
        }
    }

    public String toString() {
        return "AppLovinTargetingDataImpl{gender=" + (Object)((Object)this.aAU) + ", maximumAdContentRating=" + (Object)((Object)this.aAV) + ", yearOfBirth=" + this.aAW + ", email='" + this.aAX + '\'' + ", phoneNumber='" + this.aAY + '\'' + ", keywords=" + this.api + ", interests=" + this.aAZ + ", parameters=" + this.aBb + "}";
    }

    @Override
    @Nullable
    public AppLovinTargetingData.Gender getGender() {
        return this.aAU;
    }

    @Override
    @Nullable
    public AppLovinTargetingData.AdContentRating getMaximumAdContentRating() {
        return this.aAV;
    }

    @Override
    @Nullable
    public Integer getYearOfBirth() {
        return this.aAW;
    }

    @Override
    @Nullable
    public String getEmail() {
        return this.aAX;
    }

    @Override
    @Nullable
    public String getPhoneNumber() {
        return this.aAY;
    }

    @Override
    @Nullable
    public List<String> getKeywords() {
        return this.api;
    }

    @Override
    @Nullable
    public List<String> getInterests() {
        return this.aAZ;
    }

    public Map<String, String> getJsonData() {
        return this.aBb;
    }

    public static class BuilderImpl
    implements AppLovinTargetingData.Builder {
        @Nullable
        private AppLovinTargetingData.Gender aAU;
        @Nullable
        private AppLovinTargetingData.AdContentRating aAV;
        @Nullable
        private Integer aAW;
        @Nullable
        private String aAX;
        @Nullable
        private String aAY;
        @Nullable
        private List<String> api;
        @Nullable
        private List<String> aAZ;
        private final Map<String, String> aBb = new HashMap<String, String>();

        @Override
        public AppLovinTargetingData.Builder setGender(@Nullable AppLovinTargetingData.Gender gender) {
            String string2 = null;
            if (gender != null) {
                if (gender == AppLovinTargetingData.Gender.FEMALE) {
                    string2 = "F";
                } else if (gender == AppLovinTargetingData.Gender.MALE) {
                    string2 = "M";
                } else if (gender == AppLovinTargetingData.Gender.OTHER) {
                    string2 = "O";
                }
            }
            this.z("gender", string2);
            this.aAU = gender;
            return this;
        }

        @Override
        public AppLovinTargetingData.Builder setMaximumAdContentRating(@Nullable AppLovinTargetingData.AdContentRating adContentRating) {
            this.z("maximum_ad_content_rating", adContentRating == null || adContentRating == AppLovinTargetingData.AdContentRating.NONE ? null : Integer.toString(adContentRating.ordinal()));
            this.aAV = adContentRating;
            return this;
        }

        @Override
        public AppLovinTargetingData.Builder setYearOfBirth(@Nullable Integer n2) {
            this.z("year_of_birth", n2 == null ? null : Integer.toString(n2));
            this.aAW = n2;
            return this;
        }

        @Override
        public AppLovinTargetingData.Builder setEmail(@Nullable String string2) {
            String string3 = string2;
            if (string3 != null) {
                string3 = string3.toLowerCase(Locale.getDefault()).trim();
                string3 = StringUtils.toFullSHA1Hash(string3);
            }
            this.z("email", string3);
            this.aAX = string2;
            return this;
        }

        @Override
        public AppLovinTargetingData.Builder setPhoneNumber(@Nullable String string2) {
            String string3 = string2;
            if (string3 != null) {
                string3 = string3.replaceAll("[^0-9]", "");
                string3 = StringUtils.toFullSHA1Hash(string3);
            }
            this.z("phone_number", string3);
            this.aAY = string2;
            return this;
        }

        @Override
        public AppLovinTargetingData.Builder setKeywords(@Nullable List<String> list) {
            this.z("keywords", list == null ? null : CollectionUtils.implode(list, list.size()));
            this.api = list;
            return this;
        }

        @Override
        public AppLovinTargetingData.Builder setInterests(@Nullable List<String> list) {
            this.z("interests", list == null ? null : CollectionUtils.implode(list, list.size()));
            this.aAZ = list;
            return this;
        }

        @Override
        public AppLovinTargetingData build() {
            return new AppLovinTargetingDataImpl(this);
        }

        private void z(String string2, @Nullable String string3) {
            if (TextUtils.isEmpty((CharSequence)string2)) {
                return;
            }
            if (StringUtils.isValidString(string3)) {
                this.aBb.put(string2, string3);
            } else {
                this.aBb.remove(string2);
            }
        }

        @Override
        @Nullable
        public AppLovinTargetingData.Gender getGender() {
            return this.aAU;
        }

        @Override
        @Nullable
        public AppLovinTargetingData.AdContentRating getMaximumAdContentRating() {
            return this.aAV;
        }

        @Override
        @Nullable
        public Integer getYearOfBirth() {
            return this.aAW;
        }

        @Override
        @Nullable
        public String getEmail() {
            return this.aAX;
        }

        @Override
        @Nullable
        public String getPhoneNumber() {
            return this.aAY;
        }

        @Override
        @Nullable
        public List<String> getKeywords() {
            return this.api;
        }

        @Override
        @Nullable
        public List<String> getInterests() {
            return this.aAZ;
        }

        public Map<String, String> getJsonData() {
            return this.aBb;
        }
    }
}

