/*
 * Decompiled with CFR 0.152.
 */
package com.applovin.impl.sdk;

import android.app.ActivityManager;
import android.content.ContentResolver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.graphics.Point;
import android.hardware.SensorManager;
import android.media.AudioDeviceInfo;
import android.media.AudioManager;
import android.net.ConnectivityManager;
import android.os.Build;
import android.os.Environment;
import android.os.LocaleList;
import android.os.PowerManager;
import android.os.SystemClock;
import android.provider.Settings;
import android.telephony.TelephonyManager;
import android.text.TextUtils;
import android.util.Base64;
import android.util.DisplayMetrics;
import androidx.annotation.Nullable;
import com.applovin.impl.sdk.ae;
import com.applovin.impl.sdk.array.ArrayService;
import com.applovin.impl.sdk.d.c;
import com.applovin.impl.sdk.e.ab;
import com.applovin.impl.sdk.e.d;
import com.applovin.impl.sdk.e.i;
import com.applovin.impl.sdk.e.q;
import com.applovin.impl.sdk.f;
import com.applovin.impl.sdk.m;
import com.applovin.impl.sdk.network.b;
import com.applovin.impl.sdk.utils.CollectionUtils;
import com.applovin.impl.sdk.utils.JsonUtils;
import com.applovin.impl.sdk.utils.StringUtils;
import com.applovin.impl.sdk.utils.d;
import com.applovin.impl.sdk.utils.h;
import com.applovin.impl.sdk.utils.l;
import com.applovin.impl.sdk.utils.o;
import com.applovin.impl.sdk.utils.t;
import com.applovin.impl.sdk.utils.u;
import com.applovin.impl.sdk.v;
import com.applovin.impl.sdk.w;
import com.applovin.impl.sdk.z;
import com.applovin.sdk.AppLovinBidTokenCollectionListener;
import com.applovin.sdk.AppLovinSdk;
import com.applovin.sdk.AppLovinSdkUtils;
import java.io.File;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicReference;
import org.json.JSONArray;
import org.json.JSONObject;

public class n {
    private final m sdk;
    private final w logger;
    private final Context D;
    private final Map<String, Object> aDe;
    private final Object aDf = new Object();
    private final Map<String, Object> awP;
    private boolean aDg;
    private static final AtomicReference<d.a> aDh = new AtomicReference();
    private final AtomicReference<Integer> aDi = new AtomicReference();
    private static final AtomicReference<a> aDj = new AtomicReference();

    protected n(m m2) {
        if (m2 == null) {
            throw new IllegalArgumentException("No sdk specified");
        }
        this.sdk = m2;
        this.logger = m2.Cv();
        this.D = m.getApplicationContext();
        this.aDe = this.DE();
        this.awP = this.DI();
    }

    protected String getBidToken() {
        JSONObject jSONObject = new JSONObject(this.Dy());
        byte[] byArray = jSONObject.toString().getBytes(Charset.defaultCharset());
        String string2 = Base64.encodeToString((byte[])byArray, (int)2);
        if (this.sdk.a(com.applovin.impl.sdk.c.b.aQR).booleanValue()) {
            long l2 = u.Q(this.sdk);
            return o.a(string2, l2, o.a.gX(this.sdk.a(com.applovin.impl.sdk.c.b.aQS)), this.sdk.getSdkKey(), this.sdk);
        }
        return string2;
    }

    protected void collectBidToken(AppLovinBidTokenCollectionListener appLovinBidTokenCollectionListener) {
        Boolean bl = this.sdk.a(com.applovin.impl.sdk.c.b.aPz);
        this.sdk.Cx().a((d)new ab(this.sdk, bl, "DataCollector", () -> {
            String string2;
            try {
                string2 = this.getBidToken();
            }
            catch (Throwable throwable) {
                String string3 = "Failed to collect bid token";
                n n2 = this;
                if (n2.logger.FV()) {
                    this.logger.c("DataCollector", "Failed to collect bid token", throwable);
                }
                this.sdk.Cw().d("DataCollector", "collectBidToken", throwable);
                l.b(appLovinBidTokenCollectionListener, "Failed to collect bid token");
                return;
            }
            if (StringUtils.isValidString(string2)) {
                this.sdk.Cv();
                if (w.FV()) {
                    this.sdk.Cv().f("DataCollector", "Successfully retrieved bid token");
                }
                l.a(appLovinBidTokenCollectionListener, string2);
            } else {
                String string4 = "Empty bid token";
                this.sdk.Cv();
                if (w.FV()) {
                    this.sdk.Cv().i("DataCollector", "Empty bid token");
                }
                l.b(appLovinBidTokenCollectionListener, "Empty bid token");
            }
        }), q.a.aVh);
    }

    private Map<String, String> Dy() {
        return u.r(this.a(null, true, false));
    }

    public Map<String, Object> a(@Nullable Map<String, String> map, boolean bl, boolean bl2) {
        Map<String, String> map2;
        HashMap<String, Object> hashMap = new HashMap<String, Object>(64);
        Map<String, Object> map3 = this.aM(bl);
        Map<String, Object> map4 = this.DH();
        Map<String, Object> map5 = this.DL();
        Map<String, Object> map6 = this.DM();
        Map<String, String> map7 = map2 = this.sdk.BT().get() ? this.sdk.Ch().getAllData() : this.sdk.Ch().getJsonData();
        if (bl2) {
            hashMap.put("device_info", map3);
            hashMap.put("app_info", map4);
            if (map5 != null) {
                hashMap.put("connection_info", map5);
            }
            if (map != null) {
                hashMap.put("ad_info", map);
            }
            if (map6 != null) {
                hashMap.put("location_info", map6);
            }
            if (map2 != null && !map2.isEmpty()) {
                hashMap.put("targeting_data", map2);
            }
        } else {
            hashMap.putAll(map3);
            hashMap.putAll(map4);
            if (map5 != null) {
                hashMap.putAll(map5);
            }
            if (map != null) {
                hashMap.putAll(map);
            }
            if (map6 != null) {
                hashMap.putAll(map6);
            }
            if (map2 != null && !map2.isEmpty()) {
                hashMap.putAll(map2);
            }
        }
        hashMap.put("accept", "custom_size,launch_app,video");
        hashMap.put("format", "json");
        CollectionUtils.putStringIfValid("mediation_provider", this.sdk.getMediationProvider(), hashMap);
        CollectionUtils.putStringIfValid("mediation_provider_v2", this.sdk.Do(), hashMap);
        CollectionUtils.putStringIfValid("plugin_version", this.sdk.a(com.applovin.impl.sdk.c.b.aPy), hashMap);
        CollectionUtils.putLongIfValid("tssf_ms", this.sdk.Cg(), hashMap);
        if (!this.sdk.a(com.applovin.impl.sdk.c.b.aQP).booleanValue()) {
            hashMap.put("sdk_key", this.sdk.getSdkKey());
        }
        hashMap.putAll(this.DK());
        if (this.sdk.a(com.applovin.impl.sdk.c.b.aQp).booleanValue()) {
            com.applovin.impl.sdk.d.d d2 = this.sdk.CA();
            hashMap.put("li", d2.b(c.aTq));
            hashMap.put("si", d2.b(c.aTt));
            hashMap.put("mad", d2.b(c.aTr));
            hashMap.put("msad", d2.b(c.aTu));
            hashMap.put("pf", d2.b(c.aTy));
            hashMap.put("mpf", d2.b(c.aTF));
            hashMap.put("gpf", d2.b(c.aTz));
            hashMap.put("asoac", d2.b(c.aTD));
        }
        hashMap.put("rid", UUID.randomUUID().toString());
        return hashMap;
    }

    public Map<String, Object> Dz() {
        return CollectionUtils.map(this.aDe);
    }

    public Map<String, Object> DA() {
        return CollectionUtils.map(this.awP);
    }

    public Map<String, Object> DB() {
        return this.aM(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, Object> aM(boolean bl) {
        Map<String, Object> map;
        Object object = this.aDf;
        synchronized (object) {
            map = CollectionUtils.map(this.aDe);
        }
        return this.a(map, bl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void DC() {
        Object object = this.aDf;
        synchronized (object) {
            this.g(this.aDe);
        }
    }

    public String DD() {
        return AppLovinSdkUtils.isFireOS(this.D) ? "fireos" : "android";
    }

    private Map<String, Object> DE() {
        HashMap<String, Object> hashMap = new HashMap<String, Object>(34);
        hashMap.put("api_level", Build.VERSION.SDK_INT);
        hashMap.put("brand", Build.MANUFACTURER);
        hashMap.put("brand_name", Build.BRAND);
        hashMap.put("hardware", Build.HARDWARE);
        hashMap.put("sim", AppLovinSdkUtils.isEmulator());
        hashMap.put("aida", com.applovin.impl.sdk.utils.d.LV());
        hashMap.put("locale", Locale.getDefault().toString());
        hashMap.put("model", Build.MODEL);
        hashMap.put("os", Build.VERSION.RELEASE);
        hashMap.put("platform", this.DD());
        hashMap.put("revision", Build.DEVICE);
        hashMap.put("tz_offset", this.DY());
        hashMap.put("gy", this.DZ());
        hashMap.put("country_code", this.Ea());
        hashMap.put("mcc", this.Eb());
        hashMap.put("mnc", this.Ec());
        hashMap.put("carrier", this.Ed());
        hashMap.put("is_tablet", AppLovinSdkUtils.isTablet(this.D));
        hashMap.put("tv", AppLovinSdkUtils.isTv(this.D));
        hashMap.put("pc", Runtime.getRuntime().availableProcessors());
        hashMap.put("hdr", this.Ef());
        hashMap.put("supported_abis", this.Eg());
        DisplayMetrics displayMetrics = this.D.getResources().getDisplayMetrics();
        if (displayMetrics != null) {
            hashMap.put("adns", Float.valueOf(displayMetrics.density));
            hashMap.put("adnsd", displayMetrics.densityDpi);
            hashMap.put("xdpi", Float.valueOf(displayMetrics.xdpi));
            hashMap.put("ydpi", Float.valueOf(displayMetrics.ydpi));
            Point point = h.X(this.D);
            double d2 = Math.sqrt(Math.pow(point.x, 2.0) + Math.pow(point.y, 2.0));
            hashMap.put("screen_size_in", d2 / (double)displayMetrics.xdpi);
            h.a a2 = h.a(this.D, this.sdk);
            if (a2 != null) {
                hashMap.put("tl_cr", a2.Mo());
                hashMap.put("tr_cr", a2.Mp());
                hashMap.put("bl_cr", a2.Mq());
                hashMap.put("br_cr", a2.Mr());
            }
        }
        hashMap.put("bt_ms", System.currentTimeMillis() - SystemClock.elapsedRealtime());
        hashMap.put("tbalsi_ms", this.sdk.Cp() - m.Cn());
        CollectionUtils.putBooleanIfValid("psase", z.L(this.D), hashMap);
        CollectionUtils.putStringIfValid("process_name", u.an(this.D), hashMap);
        CollectionUtils.putBooleanIfValid("is_main_process", u.ao(this.D), hashMap);
        this.g(hashMap);
        return hashMap;
    }

    private void g(Map<String, Object> map) {
        if (this.sdk.a(com.applovin.impl.sdk.c.b.aPG).booleanValue() && !map.containsKey("af")) {
            map.put("af", this.DR());
        }
        if (this.sdk.a(com.applovin.impl.sdk.c.b.aPH).booleanValue() && !map.containsKey("font")) {
            map.put("font", Float.valueOf(this.DS()));
        }
        if (this.sdk.a(com.applovin.impl.sdk.c.b.aPO).booleanValue() && u.U(this.sdk)) {
            ae.A(this.sdk);
        }
        if (this.sdk.a(com.applovin.impl.sdk.c.b.aQb).booleanValue()) {
            ae.B(this.sdk);
        }
        if (this.sdk.a(com.applovin.impl.sdk.c.b.aPN).booleanValue() && !map.containsKey("sua")) {
            map.put("sua", System.getProperty("http.agent"));
        }
        if (this.sdk.a(com.applovin.impl.sdk.c.b.aPJ).booleanValue() && !map.containsKey("network_restricted")) {
            map.put("network_restricted", this.DN());
        }
        if (this.sdk.a(com.applovin.impl.sdk.c.b.aPR).booleanValue()) {
            boolean bl = this.D.getResources().getConfiguration().keyboard == 2;
            boolean bl2 = this.D.getPackageManager().hasSystemFeature("com.google.android.play.feature.HPE_EXPERIENCE");
            boolean bl3 = this.D.getPackageManager().hasSystemFeature("android.hardware.type.pc");
            map.put("is_pc", bl && (bl2 || bl3));
        }
        if (this.sdk.a(com.applovin.impl.sdk.c.b.aQd).booleanValue()) {
            CollectionUtils.putStringIfValid("oglv", this.Eh(), map);
        }
    }

    private Map<String, Object> a(Map<String, Object> map, boolean bl) {
        ArrayService arrayService;
        PowerManager powerManager;
        String string2;
        Map<String, Object> map2;
        block38: {
            block37: {
                block36: {
                    Object object;
                    Boolean bl2;
                    Boolean bl3;
                    Boolean bl4;
                    Object object2;
                    Object object3;
                    map2 = CollectionUtils.map(map);
                    Point point = h.X(this.D);
                    map2.put("dx", point.x);
                    map2.put("dy", point.y);
                    if (bl) {
                        object3 = aDh.get();
                        if (object3 != null) {
                            object2 = object3;
                            this.Ek();
                        } else if (u.MF()) {
                            object2 = new d.a();
                            map2.put("inc", true);
                        } else {
                            object2 = this.DO();
                        }
                    } else {
                        object2 = this.DO();
                    }
                    object3 = ((d.a)object2).LX();
                    if (StringUtils.isValidString((String)object3)) {
                        map2.put("idfa", object3);
                    }
                    map2.put("dnt", ((d.a)object2).LW());
                    map2.put("dnt_code", ((d.a)object2).LY().LZ());
                    a a2 = aDj.get();
                    if (this.sdk.a(com.applovin.impl.sdk.c.b.aPn).booleanValue() && a2 != null) {
                        map2.put("idfv", a2.dn);
                        map2.put("idfv_scope", a2.aDl);
                    }
                    if ((bl4 = com.applovin.impl.privacy.a.Am().B(this.D)) != null) {
                        map2.put("huc", bl4);
                    }
                    if ((bl3 = com.applovin.impl.privacy.a.Al().B(this.D)) != null) {
                        map2.put("aru", bl3);
                    }
                    if ((bl2 = com.applovin.impl.privacy.a.An().B(this.D)) != null) {
                        map2.put("dns", bl2);
                    }
                    if (this.sdk.a(com.applovin.impl.sdk.c.b.aPA).booleanValue()) {
                        object = this.DQ();
                        CollectionUtils.putIntegerIfValid("act", ((b)object).aDm, map2);
                        CollectionUtils.putIntegerIfValid("acm", ((b)object).adm, map2);
                        CollectionUtils.putBooleanIfValid("sowpie", ((b)object).aDn, map2);
                    }
                    if (this.sdk.a(com.applovin.impl.sdk.c.b.aPI).booleanValue()) {
                        map2.put("mtl", this.sdk.CN().getLastTrimMemoryLevel());
                    }
                    if (this.sdk.a(com.applovin.impl.sdk.c.b.aPL).booleanValue()) {
                        map2.put("adr", this.Ee());
                    }
                    Object object4 = object = bl ? this.aDi.get() : this.DV();
                    if (object != null) {
                        map2.put("volume", object);
                    }
                    CollectionUtils.putBooleanIfValid("ma", this.DW(), map2);
                    CollectionUtils.putBooleanIfValid("spo", this.DX(), map2);
                    CollectionUtils.putBooleanIfValid("aif", !this.sdk.CN().isApplicationPaused(), map2);
                    CollectionUtils.putLongIfValid("af_ts_ms", this.sdk.CN().getAppEnteredForegroundTimeMillis(), map2);
                    CollectionUtils.putLongIfValid("ab_ts_ms", this.sdk.CN().getAppEnteredBackgroundTimeMillis(), map2);
                    try {
                        int n2 = Settings.System.getInt((ContentResolver)this.D.getContentResolver(), (String)"screen_brightness");
                        float f2 = (float)n2 / 255.0f;
                        map2.put("sb", (int)(f2 * 100.0f));
                    }
                    catch (Settings.SettingNotFoundException settingNotFoundException) {
                        n n3 = this;
                        if (!n3.logger.FV()) break block36;
                        this.logger.c("DataCollector", "Unable to collect screen brightness", settingNotFoundException);
                    }
                }
                if (this.sdk.a(com.applovin.impl.sdk.c.b.aPO).booleanValue() && u.U(this.sdk)) {
                    ae.A(this.sdk);
                    String string3 = ae.Gh();
                    if (StringUtils.isValidString(string3)) {
                        map2.put("ua", string3);
                    }
                }
                if (this.sdk.a(com.applovin.impl.sdk.c.b.aQb).booleanValue()) {
                    ae.B(this.sdk);
                    CollectionUtils.putIntegerIfValid("wvvc", ae.Gj(), map2);
                    CollectionUtils.putStringIfValid("wvv", ae.Gk(), map2);
                    CollectionUtils.putStringIfValid("wvpn", ae.Gl(), map2);
                }
                if (this.sdk.a(com.applovin.impl.sdk.c.b.aPC).booleanValue()) {
                    try {
                        map2.put("fs", Environment.getDataDirectory().getFreeSpace());
                        map2.put("tds", Environment.getDataDirectory().getTotalSpace());
                    }
                    catch (Throwable throwable) {
                        map2.put("fs", -1);
                        map2.put("tds", -1);
                        n n4 = this;
                        if (!n4.logger.FV()) break block37;
                        this.logger.c("DataCollector", "Unable to collect total & free space.", throwable);
                    }
                }
            }
            if (this.sdk.a(com.applovin.impl.sdk.c.b.aPD).booleanValue()) {
                ActivityManager activityManager = (ActivityManager)this.D.getSystemService("activity");
                ActivityManager.MemoryInfo memoryInfo = new ActivityManager.MemoryInfo();
                if (activityManager != null) {
                    try {
                        activityManager.getMemoryInfo(memoryInfo);
                        map2.put("fm", memoryInfo.availMem);
                        map2.put("tm", memoryInfo.totalMem);
                        map2.put("lmt", memoryInfo.threshold);
                        map2.put("lm", memoryInfo.lowMemory);
                    }
                    catch (Throwable throwable) {
                        map2.put("fm", -1);
                        map2.put("tm", -1);
                        map2.put("lmt", -1);
                        n n5 = this;
                        if (!n5.logger.FV()) break block38;
                        this.logger.c("DataCollector", "Unable to collect memory info.", throwable);
                    }
                }
            }
        }
        if (this.sdk.a(com.applovin.impl.sdk.c.b.aPE).booleanValue() && h.d("android.permission.READ_PHONE_STATE", this.D) && h.Mg()) {
            TelephonyManager telephonyManager = (TelephonyManager)this.D.getSystemService("phone");
            int n6 = telephonyManager.getDataNetworkType();
            map2.put("rat", n6);
        }
        if (this.sdk.a(com.applovin.impl.sdk.c.b.aPB).booleanValue() && !TextUtils.isEmpty((CharSequence)(string2 = this.DT()))) {
            map2.put("so", string2);
        }
        map2.put("orientation_lock", this.DF());
        if (this.sdk.a(com.applovin.impl.sdk.c.b.aPF).booleanValue()) {
            map2.put("vs", u.MH());
        }
        if (h.Me() && (powerManager = (PowerManager)this.D.getSystemService("power")) != null) {
            map2.put("lpm", powerManager.isPowerSaveMode() ? 1 : 0);
        }
        if (this.sdk.a(com.applovin.impl.sdk.c.b.aPP).booleanValue() && this.sdk.CS() != null) {
            map2.put("da", Float.valueOf(this.sdk.CS().Mz()));
        }
        if (this.sdk.a(com.applovin.impl.sdk.c.b.aPQ).booleanValue() && this.sdk.CS() != null) {
            map2.put("dm", Float.valueOf(this.sdk.CS().My()));
        }
        map2.put("mute_switch", this.sdk.CT().Bv());
        map2.put("network", com.applovin.impl.sdk.utils.i.J(this.sdk));
        String string4 = this.DU();
        if (StringUtils.isValidString(string4)) {
            map2.put("kb", string4);
        }
        if ((arrayService = this.sdk.CZ()).isAppHubInstalled()) {
            if (arrayService.getIsDirectDownloadEnabled() != null) {
                map2.put("ah_dd_enabled", arrayService.getIsDirectDownloadEnabled());
            }
            map2.put("ah_sdk_version_code", arrayService.getAppHubVersionCode());
            map2.put("ah_random_user_token", StringUtils.emptyIfNull(arrayService.getRandomUserToken()));
            map2.put("ah_sdk_package_name", StringUtils.emptyIfNull(arrayService.getAppHubPackageName()));
        }
        return map2;
    }

    private String DF() {
        String string2 = "none";
        int n2 = AppLovinSdkUtils.getOrientation(this.D);
        if (n2 == 1) {
            string2 = "portrait";
        } else if (n2 == 2) {
            string2 = "landscape";
        }
        return string2;
    }

    public boolean DG() {
        return this.aDg;
    }

    public Map<String, Object> DH() {
        String string2;
        Map<String, Object> map = CollectionUtils.map(this.awP);
        map.put("first_install", this.sdk.Dn());
        map.put("first_install_v2", !this.sdk.Cj());
        map.put("test_ads", this.aDg);
        map.put("muted", this.sdk.getSettings().isMuted());
        if (this.sdk.a(com.applovin.impl.sdk.c.b.aPo).booleanValue()) {
            CollectionUtils.putStringIfValid("cuid", this.sdk.CJ().Cm(), map);
        }
        if (this.sdk.a(com.applovin.impl.sdk.c.b.aPr).booleanValue()) {
            map.put("compass_random_token", this.sdk.Ce());
        }
        if (this.sdk.a(com.applovin.impl.sdk.c.b.aPt).booleanValue()) {
            map.put("applovin_random_token", this.sdk.Cf());
        }
        if (this.sdk.getUserSegment() != null && StringUtils.isValidString(string2 = this.sdk.getUserSegment().getName())) {
            map.put("user_segment_name", string2);
        }
        map.putAll(this.DJ());
        if (this.sdk.CG() != null) {
            CollectionUtils.putJsonArrayIfValid("ps_topics", this.sdk.CG().Gc(), map);
        }
        return map;
    }

    private Map<String, Object> DI() {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        PackageManager packageManager = this.D.getPackageManager();
        ApplicationInfo applicationInfo = this.D.getApplicationInfo();
        File file = new File(applicationInfo.sourceDir);
        long l2 = file.lastModified();
        PackageInfo packageInfo = null;
        String string2 = null;
        try {
            packageInfo = packageManager.getPackageInfo(this.D.getPackageName(), 0);
            string2 = packageManager.getInstallerPackageName(applicationInfo.packageName);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        hashMap.put("app_name", packageManager.getApplicationLabel(applicationInfo));
        hashMap.put("app_version", packageInfo != null ? packageInfo.versionName : "");
        hashMap.put("app_version_code", packageInfo != null ? packageInfo.versionCode : -1);
        hashMap.put("package_name", applicationInfo.packageName);
        hashMap.put("vz", StringUtils.toShortSHA1Hash(applicationInfo.packageName));
        hashMap.put("installer_name", string2 != null ? string2 : "");
        hashMap.put("tg", t.P(this.sdk));
        hashMap.put("debug", u.R(this.sdk));
        hashMap.put("ia", l2);
        hashMap.put("alts_ms", m.Cn());
        hashMap.put("j8", m.Co());
        hashMap.put("ps_tpg", z.N(this.D));
        hashMap.put("ps_apg", z.O(this.D));
        hashMap.put("ps_capg", z.P(this.D));
        hashMap.put("ps_aipg", z.Q(this.D));
        Long l3 = this.sdk.a(com.applovin.impl.sdk.c.d.aSp);
        if (l3 != null) {
            hashMap.put("ia_v2", l3);
        } else {
            this.sdk.a(com.applovin.impl.sdk.c.d.aSp, l2);
        }
        hashMap.put("sdk_version", AppLovinSdk.VERSION);
        hashMap.put("omid_sdk_version", this.sdk.CX().getSdkVersion());
        CollectionUtils.putStringIfValid("ad_review_sdk_version", f.getVersion(), hashMap);
        hashMap.put("api_did", this.sdk.a(com.applovin.impl.sdk.c.b.aKO));
        hashMap.put("first_install_v3_ms", packageInfo != null ? Long.valueOf(packageInfo.firstInstallTime) : "");
        hashMap.put("target_sdk", applicationInfo.targetSdkVersion);
        hashMap.put("epv", u.MK());
        return hashMap;
    }

    private Map<String, Object> DJ() {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        CollectionUtils.putIntegerIfValid("IABTCF_gdprApplies", this.sdk.CV().AR(), hashMap);
        CollectionUtils.putStringIfValid("IABTCF_TCString", this.sdk.CV().AS(), hashMap);
        CollectionUtils.putStringIfValid("IABTCF_AddtlConsent", this.sdk.CV().AT(), hashMap);
        return hashMap;
    }

    public Map<String, Object> DK() {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put("sc", this.sdk.a(com.applovin.impl.sdk.c.b.aKY));
        hashMap.put("sc2", this.sdk.a(com.applovin.impl.sdk.c.b.aKZ));
        hashMap.put("sc3", this.sdk.a(com.applovin.impl.sdk.c.b.aLa));
        hashMap.put("server_installed_at", this.sdk.a(com.applovin.impl.sdk.c.b.aLb));
        String string2 = this.sdk.a(com.applovin.impl.sdk.c.d.aSR);
        CollectionUtils.putStringIfValid("persisted_data", string2, hashMap);
        return hashMap;
    }

    @Nullable
    public Map<String, Object> DL() {
        b.c c2 = this.sdk.Cz().IT();
        if (c2 == null) {
            return null;
        }
        HashMap<String, Object> hashMap = new HashMap<String, Object>(4);
        hashMap.put("lrm_ts_ms", String.valueOf(c2.IV()));
        hashMap.put("lrm_url", c2.IW());
        hashMap.put("lrm_ct_ms", String.valueOf(c2.IY()));
        hashMap.put("lrm_rs", String.valueOf(c2.IX()));
        return hashMap;
    }

    @Nullable
    public Map<String, Object> DM() {
        if (!this.sdk.getSettings().isLocationCollectionEnabled()) {
            return null;
        }
        if (!this.sdk.a(com.applovin.impl.sdk.c.b.aQm).booleanValue()) {
            return null;
        }
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        v v2 = this.sdk.CY();
        boolean bl = v2.FQ();
        hashMap.put("loc_services_enabled", bl);
        if (!bl) {
            return hashMap;
        }
        hashMap.put("loc_auth", v2.FP());
        if (v2.FR()) {
            hashMap.put("loc_lat", u.a(v2.FT(), this.sdk.a(com.applovin.impl.sdk.c.b.aQo)));
            hashMap.put("loc_long", u.a(v2.FU(), this.sdk.a(com.applovin.impl.sdk.c.b.aQo)));
        }
        return hashMap;
    }

    private boolean DN() {
        block4: {
            if (!h.Mg()) {
                return false;
            }
            ConnectivityManager connectivityManager = (ConnectivityManager)this.D.getSystemService("connectivity");
            if (connectivityManager != null) {
                try {
                    int n2 = connectivityManager.getRestrictBackgroundStatus();
                    return n2 == 3;
                }
                catch (Throwable throwable) {
                    this.sdk.Cv();
                    if (!w.FV()) break block4;
                    this.sdk.Cv().c("DataCollector", "Unable to collect constrained network info.", throwable);
                }
            }
        }
        return false;
    }

    public d.a DO() {
        List<String> list;
        d.a a2 = com.applovin.impl.sdk.utils.d.T(this.D);
        if (a2 == null) {
            return new d.a();
        }
        if (this.sdk.a(com.applovin.impl.sdk.c.b.aPm).booleanValue()) {
            boolean bl = a2.LW();
            if (bl && !this.sdk.a(com.applovin.impl.sdk.c.b.aPl).booleanValue()) {
                a2.dF("");
            }
            aDh.set(a2);
        } else {
            a2 = new d.a();
        }
        List<String> list2 = list = this.sdk.BT().get() ? this.sdk.getSettings().getTestDeviceAdvertisingIds() : this.sdk.Dp().getTestDeviceAdvertisingIds();
        if (list != null) {
            a a3;
            String string2;
            String string3 = a2.LX();
            if (StringUtils.isValidString(string3)) {
                this.aDg = list.contains(string3);
            }
            String string4 = string2 = (a3 = this.DP()) != null ? a3.dn : null;
            if (StringUtils.isValidString(string2)) {
                this.aDg |= list.contains(string2);
            }
        } else {
            this.aDg = false;
        }
        return a2;
    }

    public static void a(d.a a2) {
        aDh.set(a2);
    }

    @Nullable
    public a DP() {
        return aDj.get();
    }

    public static void a(a a2) {
        aDj.set(a2);
    }

    private b DQ() {
        int n2;
        int n3;
        int n4;
        b b2 = new b();
        IntentFilter intentFilter = new IntentFilter("android.intent.action.BATTERY_CHANGED");
        Intent intent = this.D.registerReceiver(null, intentFilter);
        int n5 = intent != null ? intent.getIntExtra("level", -1) : -1;
        int n6 = n4 = intent != null ? intent.getIntExtra("scale", -1) : -1;
        if (n5 > 0 && n4 > 0) {
            float f2 = (float)n5 / (float)n4;
            b2.adm = (int)(f2 * 100.0f);
        } else {
            b2.adm = -1;
        }
        int n7 = b2.aDm = intent != null ? intent.getIntExtra("status", -1) : -1;
        b2.aDn = h.Mc() ? Boolean.valueOf(Settings.Global.getInt((ContentResolver)this.D.getContentResolver(), (String)"stay_on_while_plugged_in", (int)-1) > 0) : Boolean.valueOf((n3 = (n2 = intent.getIntExtra("plugged", -1)) & 1 | 2 | 4 | 8) > 0);
        return b2;
    }

    private long DR() {
        int n2;
        int n3;
        String string2 = StringUtils.emptyIfNull(Settings.Secure.getString((ContentResolver)this.D.getContentResolver(), (String)"enabled_accessibility_services"));
        List<String> list = Arrays.asList(string2.split(":"));
        long l2 = 0L;
        if (list.contains("AccessibilityMenuService")) {
            l2 |= 0x100L;
        }
        if (list.contains("SelectToSpeakService")) {
            l2 |= 0x200L;
        }
        if (list.contains("SoundAmplifierService")) {
            l2 |= 2L;
        }
        if (list.contains("SpeechToTextAccessibilityService")) {
            l2 |= 0x80L;
        }
        if (list.contains("SwitchAccessService")) {
            l2 |= 4L;
        }
        if ((n3 = this.D.getResources().getConfiguration().uiMode & 0x30) == 32) {
            l2 |= 0x400L;
        }
        if (this.cE("accessibility_enabled")) {
            l2 |= 8L;
        }
        if (this.cE("touch_exploration_enabled")) {
            l2 |= 0x10L;
        }
        if (h.Me()) {
            if (this.cE("accessibility_display_inversion_enabled")) {
                l2 |= 0x20L;
            }
            if (this.cE("skip_first_use_hints")) {
                l2 |= 0x40L;
            }
        }
        if (this.cE("lock_screen_allow_remote_input")) {
            l2 |= 0x800L;
        }
        if (this.cE("enabled_accessibility_audio_description_by_default")) {
            l2 |= 0x1000L;
        }
        if (this.cE("accessibility_shortcut_on_lock_screen")) {
            l2 |= 0x2000L;
        }
        if (this.cE("wear_talkback_enabled")) {
            l2 |= 0x4000L;
        }
        if (this.cE("hush_gesture_used")) {
            l2 |= 0x8000L;
        }
        if (this.cE("high_text_contrast_enabled")) {
            l2 |= 0x10000L;
        }
        if (this.cE("accessibility_display_magnification_enabled")) {
            l2 |= 0x20000L;
        }
        if (this.cE("accessibility_display_magnification_navbar_enabled")) {
            l2 |= 0x40000L;
        }
        if (this.cE("accessibility_captioning_enabled")) {
            l2 |= 0x80000L;
        }
        if (this.cE("accessibility_display_daltonizer_enabled")) {
            l2 |= 0x100000L;
        }
        if (this.cE("accessibility_autoclick_enabled")) {
            l2 |= 0x200000L;
        }
        if (this.cE("accessibility_large_pointer_icon")) {
            l2 |= 0x400000L;
        }
        if (this.cE("reduce_bright_colors_activated")) {
            l2 |= 0x800000L;
        }
        if (this.cE("reduce_bright_colors_persist_across_reboots")) {
            l2 |= 0x1000000L;
        }
        if (this.cE("tty_mode_enabled")) {
            l2 |= 0x2000000L;
        }
        if (this.cE("rtt_calling_mode")) {
            l2 |= 0x4000000L;
        }
        if (this.cE("accessibility_floating_menu_fade_enabled")) {
            l2 |= 0x8000000L;
        }
        if (this.cE("accessibility_show_window_magnification_prompt")) {
            l2 |= 0x10000000L;
        }
        if (this.cE("accessibility_floating_menu_migration_tooltip_prompt")) {
            l2 |= 0x20000000L;
        }
        if ((n2 = this.cF("accessibility_magnification_mode")) == 0) {
            l2 |= 0x40000000L;
        } else if (n2 == 1) {
            l2 |= 0x80000000L;
        } else if (n2 == 2) {
            l2 |= 0x100000000L;
        } else if (n2 == 3) {
            l2 |= 0x200000000L;
        }
        int n4 = this.cF("accessibility_button_mode");
        if (n4 == 0) {
            l2 |= 0x400000000L;
        } else if (n4 == 1) {
            l2 |= 0x800000000L;
        }
        int n5 = this.cF("accessibility_floating_menu_size");
        if (n5 == 0) {
            l2 |= 0x1000000000L;
        } else if (n5 == 1) {
            l2 |= 0x2000000000L;
        }
        int n6 = this.cF("accessibility_floating_menu_icon_type");
        if (n6 == 0) {
            l2 |= 0x4000000000L;
        } else if (n6 == 1) {
            l2 |= 0x8000000000L;
        }
        return l2;
    }

    private boolean cE(String string2) {
        return this.cF(string2) == 1;
    }

    private int cF(String string2) {
        try {
            return Settings.Secure.getInt((ContentResolver)this.D.getContentResolver(), (String)string2);
        }
        catch (Throwable throwable) {
            return -1;
        }
    }

    private float DS() {
        try {
            return Settings.System.getFloat((ContentResolver)this.D.getContentResolver(), (String)"font_scale");
        }
        catch (Settings.SettingNotFoundException settingNotFoundException) {
            n n2 = this;
            if (n2.logger.FV()) {
                this.logger.c("DataCollector", "Error collecting font scale", settingNotFoundException);
            }
            return -1.0f;
        }
    }

    private String DT() {
        AudioManager audioManager = (AudioManager)this.D.getSystemService("audio");
        if (audioManager != null) {
            Object object;
            StringBuilder stringBuilder = new StringBuilder();
            if (h.Mf()) {
                for (AudioDeviceInfo audioDeviceInfo : object = audioManager.getDevices(2)) {
                    stringBuilder.append(audioDeviceInfo.getType());
                    stringBuilder.append(",");
                }
            } else {
                if (audioManager.isWiredHeadsetOn()) {
                    stringBuilder.append(3);
                    stringBuilder.append(",");
                }
                if (audioManager.isBluetoothScoOn()) {
                    stringBuilder.append(7);
                    stringBuilder.append(",");
                }
                if (audioManager.isBluetoothA2dpOn()) {
                    stringBuilder.append(8);
                }
            }
            if (stringBuilder.length() > 0 && stringBuilder.charAt(stringBuilder.length() - 1) == ',') {
                stringBuilder.deleteCharAt(stringBuilder.length() - 1);
            }
            if (TextUtils.isEmpty((CharSequence)(object = stringBuilder.toString()))) {
                n n2 = this;
                if (n2.logger.FV()) {
                    this.logger.f("DataCollector", "No sound outputs detected");
                }
            }
            return object;
        }
        return null;
    }

    private String DU() {
        if (!h.Mg()) {
            return null;
        }
        try {
            StringBuilder stringBuilder = new StringBuilder();
            LocaleList localeList = this.D.getResources().getConfiguration().getLocales();
            for (int i2 = 0; i2 < localeList.size(); ++i2) {
                stringBuilder.append(localeList.get(i2));
                stringBuilder.append(",");
            }
            if (stringBuilder.length() > 0 && stringBuilder.charAt(stringBuilder.length() - 1) == ',') {
                stringBuilder.deleteCharAt(stringBuilder.length() - 1);
            }
            return stringBuilder.toString();
        }
        catch (Throwable throwable) {
            return null;
        }
    }

    @Nullable
    private Integer DV() {
        AudioManager audioManager = (AudioManager)this.D.getSystemService("audio");
        if (audioManager == null) {
            return null;
        }
        Float f2 = this.sdk.a(com.applovin.impl.sdk.c.b.aPM);
        try {
            return (int)((float)audioManager.getStreamVolume(3) * f2.floatValue());
        }
        catch (Throwable throwable) {
            this.sdk.Cv();
            if (w.FV()) {
                this.sdk.Cv().c("DataCollector", "Unable to collect device volume", throwable);
            }
            return null;
        }
    }

    @Nullable
    private Boolean DW() {
        AudioManager audioManager = (AudioManager)this.D.getSystemService("audio");
        if (audioManager == null) {
            return null;
        }
        return audioManager.isMusicActive();
    }

    @Nullable
    private Boolean DX() {
        AudioManager audioManager = (AudioManager)this.D.getSystemService("audio");
        if (audioManager == null) {
            return null;
        }
        return audioManager.isSpeakerphoneOn();
    }

    private double DY() {
        TimeZone timeZone = TimeZone.getDefault();
        Date date = new Date();
        double d2 = timeZone.getOffset(date.getTime());
        return (double)Math.round(10.0 * d2 / 3600000.0) / 10.0;
    }

    private boolean DZ() {
        SensorManager sensorManager = (SensorManager)this.D.getSystemService("sensor");
        return sensorManager != null && sensorManager.getDefaultSensor(4) != null;
    }

    private String Ea() {
        TelephonyManager telephonyManager = (TelephonyManager)this.D.getSystemService("phone");
        return telephonyManager != null ? telephonyManager.getSimCountryIso().toUpperCase(Locale.ENGLISH) : "";
    }

    private String Eb() {
        block3: {
            TelephonyManager telephonyManager = (TelephonyManager)this.D.getSystemService("phone");
            if (telephonyManager != null) {
                try {
                    String string2 = telephonyManager.getNetworkOperator();
                    int n2 = Math.min(3, string2.length());
                    return string2.substring(0, n2);
                }
                catch (Throwable throwable) {
                    n n3 = this;
                    if (!n3.logger.FV()) break block3;
                    this.logger.c("DataCollector", "Unable to collect mobile country code", throwable);
                }
            }
        }
        return "";
    }

    private String Ec() {
        block3: {
            TelephonyManager telephonyManager = (TelephonyManager)this.D.getSystemService("phone");
            if (telephonyManager != null) {
                try {
                    String string2 = telephonyManager.getNetworkOperator();
                    int n2 = Math.min(3, string2.length());
                    return string2.substring(n2);
                }
                catch (Throwable throwable) {
                    n n3 = this;
                    if (!n3.logger.FV()) break block3;
                    this.logger.c("DataCollector", "Unable to collect mobile network code", throwable);
                }
            }
        }
        return "";
    }

    private String Ed() {
        block3: {
            TelephonyManager telephonyManager = (TelephonyManager)this.D.getSystemService("phone");
            if (telephonyManager != null) {
                try {
                    return telephonyManager.getNetworkOperatorName();
                }
                catch (Throwable throwable) {
                    n n2 = this;
                    if (!n2.logger.FV()) break block3;
                    this.logger.c("DataCollector", "Unable to collect carrier", throwable);
                }
            }
        }
        return "";
    }

    private boolean Ee() {
        try {
            return this.Ei() || this.Ej();
        }
        catch (Throwable throwable) {
            return false;
        }
    }

    @Nullable
    private Boolean Ef() {
        if (!h.Mh()) {
            return null;
        }
        return this.D.getResources().getConfiguration().isScreenHdr();
    }

    private JSONArray Eg() {
        if (h.Me()) {
            return CollectionUtils.toJSONArray(Build.SUPPORTED_ABIS);
        }
        JSONArray jSONArray = new JSONArray();
        JsonUtils.putStringIfValid(jSONArray, Build.CPU_ABI);
        JsonUtils.putStringIfValid(jSONArray, Build.CPU_ABI2);
        return jSONArray;
    }

    @Nullable
    public String Eh() {
        ActivityManager activityManager = (ActivityManager)this.D.getSystemService("activity");
        if (activityManager == null) {
            return null;
        }
        return activityManager.getDeviceConfigurationInfo().getGlEsVersion();
    }

    private boolean Ei() {
        String string2 = "lz}$blpz";
        String string3 = Build.TAGS;
        return string3 != null && string3.contains(this.cG("lz}$blpz"));
    }

    private boolean Ej() {
        String[] stringArray;
        for (String string2 : stringArray = new String[]{"&zpz}ld&hyy&Z|yl{|zl{'hyb", "&zk`g&z|", "&zpz}ld&k`g&z|", "&zpz}ld&qk`g&z|", "&mh}h&efjhe&qk`g&z|", "&mh}h&efjhe&k`g&z|", "&zpz}ld&zm&qk`g&z|", "&zpz}ld&k`g&oh`ezhol&z|", "&mh}h&efjhe&z|"}) {
            String string3 = this.cG(string2);
            if (!new File(string3).exists()) continue;
            return true;
        }
        return false;
    }

    private String cG(String string2) {
        int n2 = string2.length();
        int[] nArray = new int[]{11, 12, 10, 3, 2, 1, 15, 10, 15, 14};
        int n3 = nArray.length;
        char[] cArray = new char[n2];
        for (int i2 = 0; i2 < n2; ++i2) {
            cArray[i2] = string2.charAt(i2);
            for (int i3 = n3 - 1; i3 >= 0; --i3) {
                int n4 = i2;
                cArray[n4] = (char)(cArray[n4] ^ nArray[i3]);
            }
        }
        return new String(cArray);
    }

    public void Ek() {
        this.sdk.Cx().a((d)new i(this.sdk, new i.a(){

            @Override
            public void b(d.a a2) {
                aDh.set(a2);
            }
        }), q.a.aVl);
        this.sdk.Cx().a((d)new ab(this.sdk, true, "setDeviceVolume", () -> this.aDi.set(this.DV())), q.a.aVl);
    }

    public static class b {
        public int aDm = -1;
        public int adm = -1;
        public Boolean aDn = null;
    }

    public static class a {
        public final String dn;
        public final int aDl;

        public a(String string2, int n2) {
            this.dn = string2;
            this.aDl = n2;
        }
    }
}

