/*
 * Decompiled with CFR 0.152.
 */
package com.applovin.impl.sdk.nativeAd;

import android.content.Context;
import android.net.Uri;
import android.os.Bundle;
import android.view.InputEvent;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.widget.Button;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.arch.core.util.Function;
import com.applovin.impl.adview.AppLovinTouchToClickListener;
import com.applovin.impl.sdk.AppLovinAdBase;
import com.applovin.impl.sdk.a.e;
import com.applovin.impl.sdk.a.g;
import com.applovin.impl.sdk.ac;
import com.applovin.impl.sdk.array.ArrayService;
import com.applovin.impl.sdk.m;
import com.applovin.impl.sdk.nativeAd.AppLovinMediaView;
import com.applovin.impl.sdk.nativeAd.AppLovinNativeAd;
import com.applovin.impl.sdk.nativeAd.AppLovinNativeAdEventListener;
import com.applovin.impl.sdk.nativeAd.AppLovinOptionsView;
import com.applovin.impl.sdk.nativeAd.AppLovinVastMediaView;
import com.applovin.impl.sdk.network.i;
import com.applovin.impl.sdk.utils.JsonUtils;
import com.applovin.impl.sdk.utils.StringUtils;
import com.applovin.impl.sdk.utils.h;
import com.applovin.impl.sdk.utils.l;
import com.applovin.impl.sdk.utils.s;
import com.applovin.impl.sdk.utils.u;
import com.applovin.impl.sdk.w;
import com.iab.omid.library.applovin.adsession.VerificationScriptResource;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.json.JSONArray;
import org.json.JSONObject;

public class AppLovinNativeAdImpl
extends AppLovinAdBase
implements View.OnClickListener,
AppLovinTouchToClickListener.OnClickListener,
AppLovinNativeAd {
    private static final String TAG = "AppLovinNativeAd";
    private static final String DEFAULT_APPLOVIN_PRIVACY_URL = "https://www.applovin.com/privacy/";
    private static final float MINIMUM_STARS_TO_RENDER = 3.0f;
    private static final String AD_RESPONSE_TYPE_APPLOVIN = "applovin";
    private static final String AD_RESPONSE_TYPE_ORTB = "ortb";
    private static final String AD_RESPONSE_TYPE_UNDEFINED = "undefined";
    private static final int VIEWABLE_MRC50_PERCENTAGE = 50;
    private static final int VIEWABLE_MRC100_PERCENTAGE = 100;
    private static final int VIEWABLE_MRC_REQUIRED_SECONDS = 1;
    private static final int VIEWABLE_VIDEO_MRC_REQUIRED_SECONDS = 2;
    private final String tag;
    private final AtomicBoolean impressionTracked = new AtomicBoolean();
    private final String title;
    private final String advertiser;
    private final String body;
    private final String callToAction;
    private final Double starRating;
    private final com.applovin.impl.b.a vastAd;
    private final Uri clickDestinationUri;
    private final Uri clickDestinationBackupUri;
    private final List<String> clickTrackingUrls;
    private final List<String> jsTrackers;
    private final List<i> impressionRequests;
    private final b viewableMRC50Callback;
    private final b viewableMRC100Callback;
    @Nullable
    private b viewableVideoMRC50Callback;
    private ac viewableMRC50Tracker;
    private ac viewableMRC100Tracker;
    @Nullable
    private ac viewableVideoMRC50Tracker;
    private final a onAttachStateChangeHandler;
    private AppLovinNativeAdEventListener eventListener;
    private ViewGroup nativeAdView;
    private Uri iconUri;
    private Uri mainImageUri;
    private Uri privacyIconUri;
    private Uri privacyDestinationUri;
    private AppLovinMediaView mediaView;
    @Nullable
    private View videoView;
    private AppLovinOptionsView optionsView;
    private final List<View> registeredViews = new ArrayList<View>();
    private final e adEventTracker;

    private AppLovinNativeAdImpl(Builder builder) {
        super(builder.adObject, builder.fullResponse, builder.sdk);
        this.onAttachStateChangeHandler = new a(this);
        this.adEventTracker = new e(this);
        this.title = builder.title;
        this.advertiser = builder.advertiser;
        this.body = builder.body;
        this.callToAction = builder.callToAction;
        this.iconUri = builder.iconUri;
        this.mainImageUri = builder.mainImageUri;
        this.privacyIconUri = builder.privacyIconUri;
        this.vastAd = builder.vastAd;
        this.clickDestinationUri = builder.clickDestinationUri;
        this.clickDestinationBackupUri = builder.clickDestinationBackupUri;
        this.clickTrackingUrls = builder.clickTrackingUrls;
        this.jsTrackers = builder.jsTrackers;
        this.impressionRequests = builder.impressionRequests;
        Double d2 = builder.starRating;
        Double d3 = this.starRating = d2 != null && d2 >= 3.0 ? d2 : null;
        if (builder.privacyDestinationUri != null) {
            this.privacyDestinationUri = builder.privacyDestinationUri;
        } else if (!this.isDspAd() || this.getSdk().Dm().isEnabled()) {
            this.privacyDestinationUri = Uri.parse((String)DEFAULT_APPLOVIN_PRIVACY_URL);
        }
        this.viewableMRC50Callback = new b(builder.viewableMRC50Requests);
        this.viewableMRC100Callback = new b(builder.viewableMRC100Requests);
        if (this.vastAd != null && this.vastAd.hasVideoUrl()) {
            this.viewableVideoMRC50Callback = new b(builder.viewableVideo50Requests);
        }
        this.tag = "AppLovinNativeAd:" + this.getAdIdNumber();
    }

    @Override
    public void registerViewsForInteraction(List<View> list, ViewGroup viewGroup) {
        this.nativeAdView = viewGroup;
        if (h.Md() && this.nativeAdView.isAttachedToWindow()) {
            this.maybeHandleOnAttachedToWindow((View)this.nativeAdView);
        } else if (!h.Md() && this.nativeAdView.getParent() != null) {
            this.maybeHandleOnAttachedToWindow((View)this.nativeAdView);
        } else {
            this.nativeAdView.addOnAttachStateChangeListener((View.OnAttachStateChangeListener)this.onAttachStateChangeHandler);
        }
        this.sdk.Cv();
        if (w.FV()) {
            this.sdk.Cv().f(this.tag, "Registered ad view for impressions: " + this.nativeAdView);
        }
        if (this.clickDestinationUri == null && this.clickDestinationBackupUri == null) {
            this.sdk.Cv();
            if (w.FV()) {
                this.sdk.Cv().f(this.tag, "Skipping click registration - no click URLs provided");
            }
            return;
        }
        for (View view : list) {
            if (view.hasOnClickListeners()) {
                this.sdk.Cv();
                if (w.FV()) {
                    this.sdk.Cv().h(this.tag, "View has an onClickListener already - " + view);
                }
            }
            if (!view.isClickable()) {
                this.sdk.Cv();
                if (w.FV()) {
                    this.sdk.Cv().h(this.tag, "View is not clickable - " + view);
                }
            }
            if (!view.isEnabled()) {
                this.sdk.Cv();
                if (w.FV()) {
                    this.sdk.Cv().i(this.tag, "View is not enabled - " + view);
                }
            }
            if (view instanceof Button) {
                this.sdk.Cv();
                if (w.FV()) {
                    this.sdk.Cv().f(this.tag, "Registering click for button: " + view);
                }
            } else {
                this.sdk.Cv();
                if (w.FV()) {
                    this.sdk.Cv().f(this.tag, "Registering click for view: " + view);
                }
            }
            if (this.sdk.a(com.applovin.impl.sdk.c.b.aOu).booleanValue()) {
                view.setOnTouchListener((View.OnTouchListener)new AppLovinTouchToClickListener(this.sdk, com.applovin.impl.sdk.c.b.aMk, viewGroup.getContext(), this));
            } else {
                view.setOnClickListener((View.OnClickListener)this);
            }
            this.registeredViews.add(view);
        }
        this.sdk.Cv();
        if (w.FV()) {
            this.sdk.Cv().f(this.tag, "Registered views: " + this.registeredViews);
        }
    }

    @Override
    public void unregisterViewsForInteraction() {
        for (View view : this.registeredViews) {
            view.setOnTouchListener(null);
            view.setOnClickListener(null);
        }
        this.sdk.Cv();
        if (w.FV()) {
            this.sdk.Cv().f(this.tag, "Unregistered views: " + this.registeredViews);
        }
        this.registeredViews.clear();
        if (this.viewableMRC50Tracker != null) {
            this.viewableMRC50Tracker.Gf();
        }
        if (this.viewableMRC100Tracker != null) {
            this.viewableMRC100Tracker.Gf();
        }
        if (this.viewableVideoMRC50Tracker != null) {
            this.viewableVideoMRC50Tracker.Gf();
        }
        if (this.nativeAdView != null) {
            this.nativeAdView.removeOnAttachStateChangeListener((View.OnAttachStateChangeListener)this.onAttachStateChangeHandler);
            this.nativeAdView = null;
        }
        if (this.mediaView != null) {
            this.mediaView.destroy();
        }
        if (this.optionsView != null) {
            this.optionsView.destroy();
        }
    }

    @Override
    public void destroy() {
        this.unregisterViewsForInteraction();
        this.eventListener = null;
        this.adEventTracker.JW();
    }

    public void setUpNativeAdViewComponents() {
        if (this.vastAd != null && this.vastAd.hasVideoUrl()) {
            try {
                AppLovinNativeAdImpl appLovinNativeAdImpl = this;
                this.mediaView = new AppLovinVastMediaView(this, this.sdk, appLovinNativeAdImpl.sdk.getApplicationContext());
            }
            catch (Throwable throwable) {
                this.sdk.Cv();
                if (w.FV()) {
                    this.sdk.Cv().b(this.tag, "Failed to create ExoPlayer VAST media view. Falling back to static image for media view.", throwable);
                }
                this.sdk.Cw().d(TAG, "createExoPlayerVASTMediaView", throwable);
                AppLovinNativeAdImpl appLovinNativeAdImpl = this;
                this.mediaView = new AppLovinMediaView(this, this.sdk, appLovinNativeAdImpl.sdk.getApplicationContext());
            }
        } else {
            AppLovinNativeAdImpl appLovinNativeAdImpl = this;
            this.mediaView = new AppLovinMediaView(this, this.sdk, appLovinNativeAdImpl.sdk.getApplicationContext());
        }
        if (this.privacyDestinationUri != null) {
            AppLovinNativeAdImpl appLovinNativeAdImpl = this;
            this.optionsView = new AppLovinOptionsView(this, this.sdk, appLovinNativeAdImpl.sdk.getApplicationContext());
        } else {
            this.sdk.Cv();
            if (w.FV()) {
                this.sdk.Cv().f(this.tag, "Privacy icon will not render because no native ad privacy URL is provided.");
            }
        }
    }

    private void maybeHandleOnAttachedToWindow(View view) {
        if (this.impressionTracked.compareAndSet(false, true)) {
            this.viewableMRC50Tracker = new ac((View)this.nativeAdView, this.sdk, this.viewableMRC50Callback);
            this.viewableMRC50Tracker.a(0, 50.0f, 50.0f, TimeUnit.SECONDS.toMillis(1L), (View)this.nativeAdView);
            this.viewableMRC100Tracker = new ac((View)this.nativeAdView, this.sdk, this.viewableMRC100Callback);
            this.viewableMRC100Tracker.a(0, 100.0f, 100.0f, TimeUnit.SECONDS.toMillis(1L), (View)this.nativeAdView);
            if (this.vastAd != null && this.vastAd.hasVideoUrl()) {
                this.viewableVideoMRC50Tracker = new ac((View)this.nativeAdView, this.sdk, this.viewableVideoMRC50Callback);
                this.viewableVideoMRC50Tracker.a(0, 50.0f, 50.0f, TimeUnit.SECONDS.toMillis(2L), this.videoView);
            }
            if (this.jsTrackers != null) {
                for (String object : this.jsTrackers) {
                    this.sdk.CP().cP(object);
                }
            }
            for (i i2 : this.impressionRequests) {
                this.sdk.Db().dispatchPostbackRequest(i2, null);
            }
            this.adEventTracker.x(view);
            this.adEventTracker.JV();
            if (this.sdk.CG() != null) {
                this.sdk.CG().I(this.getPrivacySandboxImpressionAttributionUrls());
            }
        }
    }

    private List<String> getPrivacySandboxImpressionAttributionUrls() {
        return this.getStringListFromAdObject("privacy_sandbox_impression_attribution_urls", Collections.emptyList());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<com.applovin.impl.sdk.d.a> getDirectClickTrackingPostbacks() {
        if (this.synchronizedAdObject != null) {
            return (List)this.synchronizedAdObject.a(q2 -> {
                JSONObject jSONObject = q2.b("click_tracking_urls", new JSONObject());
                String string2 = q2.O("click_tracking_url", null);
                return u.a(jSONObject, this.getClCode(), string2, this.sdk);
            });
        }
        Object object = this.adObjectLock;
        synchronized (object) {
            JSONObject jSONObject = this.getJsonObjectFromAdObject("click_tracking_urls", new JSONObject());
            String string2 = this.getStringFromAdObject("click_tracking_url", null);
            return u.a(jSONObject, this.getClCode(), string2, this.sdk);
        }
    }

    private List<String> getPrivacySandboxClickAttributionUrls() {
        return this.getStringListFromAdObject("privacy_sandbox_click_attribution_urls", Collections.emptyList());
    }

    private boolean isDspAd() {
        return AD_RESPONSE_TYPE_ORTB.equalsIgnoreCase(this.getType());
    }

    public String getType() {
        return this.getStringFromAdObject("type", AD_RESPONSE_TYPE_UNDEFINED);
    }

    @Override
    public long getAdIdNumber() {
        return this.getLongFromAdObject("ad_id", -1L);
    }

    @Override
    public String getTitle() {
        return this.title;
    }

    @Override
    public String getAdvertiser() {
        return this.advertiser;
    }

    @Override
    public String getBody() {
        return this.body;
    }

    @Override
    public String getCallToAction() {
        return this.callToAction;
    }

    @Override
    public Double getStarRating() {
        return this.starRating;
    }

    @Override
    public Uri getIconUri() {
        return this.iconUri;
    }

    @Override
    public AppLovinMediaView getMediaView() {
        return this.mediaView;
    }

    @Override
    public AppLovinOptionsView getOptionsView() {
        return this.optionsView;
    }

    public void onClick(View view) {
        this.sdk.Cv();
        if (w.FV()) {
            this.sdk.Cv().f(this.tag, "Handle view clicked");
        }
        this.sdk.Cq().maybeSubmitPersistentPostbacks(this.getDirectClickTrackingPostbacks());
        this.handleNativeAdClick(this.clickDestinationUri, this.clickDestinationBackupUri, view.getContext());
    }

    @Override
    public void onClick(View view, MotionEvent motionEvent) {
        this.sdk.Cv();
        if (w.FV()) {
            this.sdk.Cv().f(this.tag, "Handle view clicked");
        }
        this.sdk.Cq().maybeSubmitPersistentPostbacks(this.getDirectClickTrackingPostbacks());
        this.handleNativeAdClick(this.clickDestinationUri, this.clickDestinationBackupUri, motionEvent, view.getContext());
    }

    protected void handleNativeAdClick(Uri uri, @Nullable Uri uri2, MotionEvent motionEvent, Context context) {
        if (this.sdk.CG() != null) {
            this.sdk.CG().a(this.getPrivacySandboxClickAttributionUrls(), (InputEvent)motionEvent);
        }
        this.handleNativeAdClick(uri, uri2, context);
    }

    private void handleNativeAdClick(final Uri uri, final @Nullable Uri uri2, final Context context) {
        for (String string2 : this.clickTrackingUrls) {
            this.sdk.Db().dispatchPostbackAsync(string2, null);
        }
        l.a(this.eventListener, this);
        if (this.isDirectDownloadEnabled()) {
            this.sdk.CZ().startDirectInstallOrDownloadProcess(this, null, new ArrayService.DirectDownloadListener(){

                @Override
                public void onAppDetailsDisplayed() {
                }

                @Override
                public void onAppDetailsDismissed() {
                }

                @Override
                public void onFailure() {
                    AppLovinNativeAdImpl.this.launchUri(uri, uri2, context);
                }
            });
        } else {
            this.launchUri(uri, uri2, context);
        }
    }

    private void launchUri(Uri uri, @Nullable Uri uri2, Context context) {
        if (s.a(uri, context, this.sdk)) {
            this.sdk.Cv();
            if (w.FV()) {
                this.sdk.Cv().f(this.tag, "Opening URL: " + uri);
            }
        } else if (s.a(uri2, context, this.sdk)) {
            this.sdk.Cv();
            if (w.FV()) {
                this.sdk.Cv().f(this.tag, "Opening backup URL: " + uri2);
            }
        }
    }

    @Nullable
    public String getCachePrefix() {
        return this.getStringFromAdObject("cache_prefix", null);
    }

    public e getAdEventTracker() {
        return this.adEventTracker;
    }

    @Override
    public boolean isOpenMeasurementEnabled() {
        if (this.sdk.CX().isTesting()) {
            return true;
        }
        return this.getBooleanFromAdObject("omsdk_enabled", false);
    }

    @Override
    @Nullable
    public String getOpenMeasurementContentUrl() {
        return this.getStringFromAdObject("omid_content_url", null);
    }

    @Override
    public String getOpenMeasurementCustomReferenceData() {
        return this.getStringFromAdObject("omid_custom_ref_data", "");
    }

    @Override
    public List<VerificationScriptResource> getOpenMeasurementVerificationScriptResources() {
        if (this.sdk.CX().isTesting()) {
            URL uRL = g.Kh();
            String string2 = g.getVendorKey();
            String string3 = g.Ki();
            VerificationScriptResource verificationScriptResource = VerificationScriptResource.createVerificationScriptResourceWithParameters(string2, uRL, string3);
            return Collections.singletonList(verificationScriptResource);
        }
        Function function = jSONArray -> {
            if (jSONArray == null) {
                return Collections.emptyList();
            }
            ArrayList<VerificationScriptResource> arrayList = new ArrayList<VerificationScriptResource>();
            for (int i2 = 0; i2 < jSONArray.length(); ++i2) {
                JSONObject jSONObject = JsonUtils.getJSONObject(jSONArray, i2, null);
                try {
                    String string2 = JsonUtils.getString(jSONObject, "url", null);
                    URL uRL = new URL(string2);
                    String string3 = JsonUtils.getString(jSONObject, "vendor_key", null);
                    String string4 = JsonUtils.getString(jSONObject, "parameters", null);
                    if (StringUtils.isValidString(string3) && StringUtils.isValidString(string4)) {
                        arrayList.add(VerificationScriptResource.createVerificationScriptResourceWithParameters(string3, uRL, string4));
                        continue;
                    }
                    arrayList.add(VerificationScriptResource.createVerificationScriptResourceWithoutParameters(uRL));
                    continue;
                }
                catch (Throwable throwable) {
                    this.sdk.Cv();
                    if (!w.FV()) continue;
                    this.sdk.Cv().c(this.tag, "Failed to parse OMID verification script resource", throwable);
                }
            }
            return arrayList;
        };
        if (this.synchronizedAdObject != null) {
            return (List)this.synchronizedAdObject.a(q2 -> {
                JSONArray jSONArray = q2.b("omid_verification_script_resources", (JSONArray)null);
                return (List)function.apply((Object)jSONArray);
            });
        }
        JSONArray jSONArray2 = this.getJsonArrayFromAdObject("omid_verification_script_resources", null);
        return (List)function.apply((Object)jSONArray2);
    }

    @Override
    public boolean isDirectDownloadEnabled() {
        return StringUtils.isValidString(this.getDirectDownloadToken());
    }

    @Override
    @Nullable
    public String getDirectDownloadToken() {
        return this.getStringFromAdObject("ah_dd_token", null);
    }

    @Override
    public Bundle getDirectDownloadParameters() {
        if (this.synchronizedAdObject != null) {
            return (Bundle)this.synchronizedAdObject.a(q2 -> {
                JSONObject jSONObject = q2.b("ah_parameters", (JSONObject)null);
                return JsonUtils.toBundle(jSONObject);
            });
        }
        JSONObject jSONObject = this.getJsonObjectFromAdObject("ah_parameters", null);
        return JsonUtils.toBundle(jSONObject);
    }

    @NonNull
    public String toString() {
        return "AppLovinNativeAd{adIdNumber=" + this.getAdIdNumber() + " - " + this.getTitle() + "}";
    }

    public com.applovin.impl.b.a getVastAd() {
        return this.vastAd;
    }

    public void setEventListener(AppLovinNativeAdEventListener appLovinNativeAdEventListener) {
        this.eventListener = appLovinNativeAdEventListener;
    }

    public void setIconUri(Uri uri) {
        this.iconUri = uri;
    }

    public Uri getMainImageUri() {
        return this.mainImageUri;
    }

    public void setMainImageUri(Uri uri) {
        this.mainImageUri = uri;
    }

    public Uri getPrivacyIconUri() {
        return this.privacyIconUri;
    }

    public void setPrivacyIconUri(Uri uri) {
        this.privacyIconUri = uri;
    }

    public Uri getPrivacyDestinationUri() {
        return this.privacyDestinationUri;
    }

    public void setVideoView(@Nullable View view) {
        this.videoView = view;
    }

    public static class Builder {
        private final JSONObject adObject;
        private final JSONObject fullResponse;
        private final m sdk;
        private String title;
        private String advertiser;
        private String body;
        private String callToAction;
        private Double starRating;
        private Uri iconUri;
        private Uri mainImageUri;
        private Uri privacyIconUri;
        private com.applovin.impl.b.a vastAd;
        private Uri clickDestinationUri;
        private Uri clickDestinationBackupUri;
        private Uri privacyDestinationUri;
        private List<String> clickTrackingUrls;
        private List<String> jsTrackers;
        private List<i> impressionRequests;
        private List<i> viewableMRC50Requests;
        private List<i> viewableMRC100Requests;
        private List<i> viewableVideo50Requests;

        public Builder(JSONObject jSONObject, JSONObject jSONObject2, m m2) {
            this.adObject = jSONObject;
            this.fullResponse = jSONObject2;
            this.sdk = m2;
        }

        public Builder setTitle(String string2) {
            this.title = string2;
            return this;
        }

        public Builder setAdvertiser(String string2) {
            this.advertiser = string2;
            return this;
        }

        public Builder setBody(String string2) {
            this.body = string2;
            return this;
        }

        public Builder setCallToAction(String string2) {
            this.callToAction = string2;
            return this;
        }

        public Builder setStarRating(Double d2) {
            this.starRating = d2;
            return this;
        }

        public Builder setIconUri(Uri uri) {
            this.iconUri = uri;
            return this;
        }

        public Builder setMainImageUri(Uri uri) {
            this.mainImageUri = uri;
            return this;
        }

        public Builder setPrivacyIconUri(Uri uri) {
            this.privacyIconUri = uri;
            return this;
        }

        public Builder setVastAd(com.applovin.impl.b.a a2) {
            this.vastAd = a2;
            return this;
        }

        public Builder setPrivacyDestinationUri(Uri uri) {
            this.privacyDestinationUri = uri;
            return this;
        }

        public Builder setClickDestinationUri(Uri uri) {
            this.clickDestinationUri = uri;
            return this;
        }

        public Builder setClickDestinationBackupUri(Uri uri) {
            this.clickDestinationBackupUri = uri;
            return this;
        }

        public Builder setClickTrackingUrls(List<String> list) {
            this.clickTrackingUrls = list;
            return this;
        }

        public Builder setJsTrackers(List<String> list) {
            this.jsTrackers = list;
            return this;
        }

        public Builder setImpressionRequests(List<i> list) {
            this.impressionRequests = list;
            return this;
        }

        public Builder setViewableMRC50Requests(List<i> list) {
            this.viewableMRC50Requests = list;
            return this;
        }

        public Builder setViewableMRC100Requests(List<i> list) {
            this.viewableMRC100Requests = list;
            return this;
        }

        public Builder setViewableVideo50Requests(List<i> list) {
            this.viewableVideo50Requests = list;
            return this;
        }

        public AppLovinNativeAdImpl build() {
            return new AppLovinNativeAdImpl(this);
        }
    }

    private static class a
    implements View.OnAttachStateChangeListener {
        private final AppLovinNativeAdImpl aHv;

        public void onViewAttachedToWindow(View view) {
            this.aHv.maybeHandleOnAttachedToWindow(view);
        }

        public void onViewDetachedFromWindow(View view) {
        }

        public a(AppLovinNativeAdImpl appLovinNativeAdImpl) {
            this.aHv = appLovinNativeAdImpl;
        }

        public AppLovinNativeAdImpl IO() {
            return this.aHv;
        }

        public boolean equals(Object object) {
            if (object == this) {
                return true;
            }
            if (!(object instanceof a)) {
                return false;
            }
            a a2 = (a)object;
            if (!a2.canEqual(this)) {
                return false;
            }
            AppLovinNativeAdImpl appLovinNativeAdImpl = this.IO();
            AppLovinNativeAdImpl appLovinNativeAdImpl2 = a2.IO();
            return !(appLovinNativeAdImpl == null ? appLovinNativeAdImpl2 != null : !appLovinNativeAdImpl.equals(appLovinNativeAdImpl2));
        }

        protected boolean canEqual(Object object) {
            return object instanceof a;
        }

        public int hashCode() {
            int n2 = 59;
            int n3 = 1;
            AppLovinNativeAdImpl appLovinNativeAdImpl = this.IO();
            n3 = n3 * 59 + (appLovinNativeAdImpl == null ? 43 : appLovinNativeAdImpl.hashCode());
            return n3;
        }

        public String toString() {
            return "AppLovinNativeAdImpl.OnAttachStateChangeHandler(ad=" + this.IO() + ")";
        }
    }

    private class b
    implements ac.a {
        private final List<i> aHw;

        @Override
        public void onLogVisibilityImpression() {
            for (i i2 : this.aHw) {
                AppLovinNativeAdImpl.this.sdk.Db().dispatchPostbackRequest(i2, null);
            }
        }

        public b(List<i> list) {
            this.aHw = list;
        }

        public List<i> IP() {
            return this.aHw;
        }

        public boolean equals(Object object) {
            if (object == this) {
                return true;
            }
            if (!(object instanceof b)) {
                return false;
            }
            b b2 = (b)object;
            if (!b2.canEqual(this)) {
                return false;
            }
            List<i> list = this.IP();
            List<i> list2 = b2.IP();
            return !(list == null ? list2 != null : !((Object)list).equals(list2));
        }

        protected boolean canEqual(Object object) {
            return object instanceof b;
        }

        public int hashCode() {
            int n2 = 59;
            int n3 = 1;
            List<i> list = this.IP();
            n3 = n3 * 59 + (list == null ? 43 : ((Object)list).hashCode());
            return n3;
        }

        public String toString() {
            return "AppLovinNativeAdImpl.VisibilityCallback(requests=" + this.IP() + ")";
        }
    }
}

