/*
 * Decompiled with CFR 0.152.
 */
package com.applovin.mediation.adapters;

import android.app.Activity;
import android.os.Bundle;
import android.text.TextUtils;
import android.view.View;
import android.view.ViewGroup;
import androidx.annotation.Nullable;
import com.applovin.impl.mediation.c.b.a;
import com.applovin.impl.mediation.c.b.b;
import com.applovin.impl.sdk.AppLovinError;
import com.applovin.impl.sdk.ad.AppLovinAdImpl;
import com.applovin.impl.sdk.nativeAd.AppLovinNativeAd;
import com.applovin.impl.sdk.nativeAd.AppLovinNativeAdEventListener;
import com.applovin.impl.sdk.nativeAd.AppLovinNativeAdImpl;
import com.applovin.impl.sdk.nativeAd.AppLovinNativeAdLoadListener;
import com.applovin.impl.sdk.utils.BundleUtils;
import com.applovin.impl.sdk.utils.JsonUtils;
import com.applovin.impl.sdk.utils.StringUtils;
import com.applovin.mediation.MaxAdFormat;
import com.applovin.mediation.adapter.MaxAdapter;
import com.applovin.mediation.adapter.MaxAdapterError;
import com.applovin.mediation.adapter.MaxNativeAdAdapter;
import com.applovin.mediation.adapter.listeners.MaxNativeAdAdapterListener;
import com.applovin.mediation.adapter.parameters.MaxAdapterInitializationParameters;
import com.applovin.mediation.adapter.parameters.MaxAdapterResponseParameters;
import com.applovin.mediation.adapters.MediationAdapterBase;
import com.applovin.mediation.nativeAds.MaxNativeAd;
import com.applovin.mediation.nativeAds.MaxNativeAdView;
import com.applovin.sdk.AppLovinAd;
import com.applovin.sdk.AppLovinSdk;
import java.util.ArrayList;
import java.util.concurrent.atomic.AtomicBoolean;
import org.json.JSONException;
import org.json.JSONObject;

public class TaboolaMediationAdapter
extends MediationAdapterBase
implements MaxNativeAdAdapter {
    private static final String ADAPTER_VERSION = "2.0.0";
    private static final AtomicBoolean initialized = new AtomicBoolean();
    private static a taboolaApiService;
    private static MaxAdapter.InitializationStatus status;
    private AppLovinNativeAd loadedNativeAd;

    public TaboolaMediationAdapter(AppLovinSdk appLovinSdk) {
        super(appLovinSdk);
    }

    @Override
    public String getSdkVersion() {
        return "2.0";
    }

    @Override
    public String getAdapterVersion() {
        return ADAPTER_VERSION;
    }

    @Override
    public void onDestroy() {
        if (this.loadedNativeAd instanceof AppLovinNativeAdImpl) {
            AppLovinNativeAdImpl appLovinNativeAdImpl = (AppLovinNativeAdImpl)this.loadedNativeAd;
            appLovinNativeAdImpl.destroy();
            this.loadedNativeAd = null;
        }
    }

    @Override
    public void initialize(MaxAdapterInitializationParameters maxAdapterInitializationParameters, Activity activity, final MaxAdapter.OnCompletionListener onCompletionListener) {
        if (initialized.compareAndSet(false, true)) {
            String string2 = null;
            String string3 = null;
            String string4 = null;
            try {
                String string5 = maxAdapterInitializationParameters.getServerParameters().getString("app_id", "");
                JSONObject jSONObject = new JSONObject(string5);
                string2 = JsonUtils.getString(jSONObject, "pub_id", null);
                string3 = JsonUtils.getString(jSONObject, "api_key", null);
                string4 = JsonUtils.getString(jSONObject, "base_url", null);
            }
            catch (JSONException jSONException) {
                status = MaxAdapter.InitializationStatus.INITIALIZED_FAILURE;
                onCompletionListener.onCompletion(status, "Failed to serialize app id json string.");
                return;
            }
            if (TextUtils.isEmpty((CharSequence)string3) || TextUtils.isEmpty((CharSequence)string2)) {
                status = MaxAdapter.InitializationStatus.INITIALIZED_FAILURE;
                onCompletionListener.onCompletion(status, "API Key or Publisher ID cannot be null.");
                return;
            }
            status = MaxAdapter.InitializationStatus.INITIALIZING;
            taboolaApiService = new a(string3, string2, string4, this.getWrappingSdk().a());
            taboolaApiService.a(maxAdapterInitializationParameters, new b(){

                @Override
                public void onInitialized(boolean bl, @Nullable String string2) {
                    if (bl) {
                        TaboolaMediationAdapter.this.log("Taboola API successfully initialized");
                        status = MaxAdapter.InitializationStatus.INITIALIZED_SUCCESS;
                    } else {
                        TaboolaMediationAdapter.this.log("Taboola API failed to initialized");
                        status = MaxAdapter.InitializationStatus.INITIALIZED_FAILURE;
                    }
                    onCompletionListener.onCompletion(status, string2);
                }
            });
        } else {
            onCompletionListener.onCompletion(status, null);
        }
    }

    @Override
    public void loadNativeAd(final MaxAdapterResponseParameters maxAdapterResponseParameters, Activity activity, final MaxNativeAdAdapterListener maxNativeAdAdapterListener) {
        if (taboolaApiService == null) {
            this.log("Taboola Service is not initialized");
            maxNativeAdAdapterListener.onNativeAdLoadFailed(MaxAdapterError.NOT_INITIALIZED);
            return;
        }
        final String string2 = maxAdapterResponseParameters.getThirdPartyAdPlacementId();
        this.d("Loading native ad: " + string2 + "...");
        taboolaApiService.a(maxAdapterResponseParameters, new AppLovinNativeAdLoadListener(){

            @Override
            public void onNativeAdLoaded(AppLovinNativeAd appLovinNativeAd) {
                TaboolaMediationAdapter.this.d("Native ad loaded: " + string2);
                String string22 = BundleUtils.getString("template", "", maxAdapterResponseParameters.getServerParameters());
                boolean bl = StringUtils.isValidString(string22);
                if (bl && TextUtils.isEmpty((CharSequence)appLovinNativeAd.getTitle())) {
                    TaboolaMediationAdapter.this.e("Native ad does not have required assets: " + string2);
                    maxNativeAdAdapterListener.onNativeAdLoadFailed(MaxAdapterError.MISSING_REQUIRED_NATIVE_AD_ASSETS);
                    return;
                }
                ((AppLovinNativeAdImpl)appLovinNativeAd).setEventListener(new AppLovinNativeAdEventListener(){

                    @Override
                    public void onNativeAdClicked(AppLovinNativeAd appLovinNativeAd) {
                        TaboolaMediationAdapter.this.d("Native ad clicked: " + string2);
                        maxNativeAdAdapterListener.onNativeAdClicked();
                    }
                });
                TaboolaMediationAdapter.this.loadedNativeAd = appLovinNativeAd;
                MaxAppLovinNativeAd maxAppLovinNativeAd = new MaxAppLovinNativeAd(new MaxNativeAd.Builder().setAdFormat(MaxAdFormat.NATIVE).setTitle(appLovinNativeAd.getTitle()).setAdvertiser(appLovinNativeAd.getAdvertiser()).setBody(appLovinNativeAd.getBody()).setCallToAction(appLovinNativeAd.getCallToAction()).setIcon(new MaxNativeAd.MaxNativeAdImage(appLovinNativeAd.getIconUri())).setOptionsView((View)appLovinNativeAd.getOptionsView()).setMediaView((View)appLovinNativeAd.getMediaView()).setMainImage(new MaxNativeAd.MaxNativeAdImage(((AppLovinNativeAdImpl)appLovinNativeAd).getMainImageUri())).setMediaContentAspectRatio(appLovinNativeAd.getMediaView().getAspectRatio()));
                maxNativeAdAdapterListener.onNativeAdLoaded(maxAppLovinNativeAd, null);
            }

            @Override
            public void onNativeAdLoadFailed(AppLovinError appLovinError) {
                TaboolaMediationAdapter.this.d("Native ad: " + string2 + " failed to load with error: " + appLovinError.getMessage());
                maxNativeAdAdapterListener.onNativeAdLoadFailed(TaboolaMediationAdapter.toMaxError(appLovinError));
            }
        });
    }

    protected static MaxAdapterError toMaxError(AppLovinError appLovinError) {
        MaxAdapterError maxAdapterError = appLovinError.getCode() == -1009 ? MaxAdapterError.NO_CONNECTION : (appLovinError.getCode() == 204 ? MaxAdapterError.NO_FILL : (appLovinError.getCode() >= 500 ? MaxAdapterError.SERVER_ERROR : MaxAdapterError.UNSPECIFIED));
        return new MaxAdapterError(maxAdapterError.getCode(), maxAdapterError.getErrorMessage(), appLovinError.getCode(), appLovinError.getMessage());
    }

    protected static Bundle getExtraInfo(AppLovinAd appLovinAd) {
        Bundle bundle = new Bundle(1);
        bundle.putBundle("ad_values", ((AppLovinAdImpl)appLovinAd).getMAXAdValues());
        return bundle;
    }

    private class MaxAppLovinNativeAd
    extends MaxNativeAd {
        public MaxAppLovinNativeAd(MaxNativeAd.Builder builder) {
            super(builder);
        }

        @Override
        public void prepareViewForInteraction(MaxNativeAdView maxNativeAdView) {
            AppLovinNativeAdImpl appLovinNativeAdImpl = (AppLovinNativeAdImpl)TaboolaMediationAdapter.this.loadedNativeAd;
            if (appLovinNativeAdImpl == null) {
                TaboolaMediationAdapter.this.e("Failed to register native ad view for interaction. Native ad is null");
                return;
            }
            TaboolaMediationAdapter.this.d("Preparing view for interaction: " + (Object)((Object)maxNativeAdView));
            ArrayList<View> arrayList = new ArrayList<View>(4);
            if (StringUtils.isValidString(this.getTitle()) && maxNativeAdView.getTitleTextView() != null) {
                TaboolaMediationAdapter.this.d("Adding title TextView: " + maxNativeAdView.getTitleTextView());
                arrayList.add((View)maxNativeAdView.getTitleTextView());
            }
            if (StringUtils.isValidString(this.getBody()) && maxNativeAdView.getBodyTextView() != null) {
                TaboolaMediationAdapter.this.d("Adding body TextView: " + maxNativeAdView.getBodyTextView());
                arrayList.add((View)maxNativeAdView.getBodyTextView());
            }
            if (StringUtils.isValidString(this.getCallToAction()) && maxNativeAdView.getCallToActionButton() != null) {
                TaboolaMediationAdapter.this.d("Adding CTA button: " + maxNativeAdView.getCallToActionButton());
                TaboolaMediationAdapter.this.d("CTA button is clickable: " + maxNativeAdView.getCallToActionButton().isClickable());
                TaboolaMediationAdapter.this.d("CTA button is enabled: " + maxNativeAdView.getCallToActionButton().isEnabled());
                TaboolaMediationAdapter.this.d("CTA button has onClickListeners: " + maxNativeAdView.getCallToActionButton().hasOnClickListeners());
                arrayList.add((View)maxNativeAdView.getCallToActionButton());
            }
            if (this.getIcon() != null && maxNativeAdView.getIconImageView() != null) {
                TaboolaMediationAdapter.this.d("Adding icon image view: " + maxNativeAdView.getIconImageView());
                arrayList.add((View)maxNativeAdView.getIconImageView());
            }
            appLovinNativeAdImpl.registerViewsForInteraction(arrayList, (ViewGroup)maxNativeAdView);
        }
    }
}

