/*
 * Decompiled with CFR 0.152.
 */
package com.applovin.sdk;

import android.content.Context;
import android.text.TextUtils;
import androidx.annotation.Nullable;
import com.applovin.impl.mediation.MaxMediatedNetworkInfoImpl;
import com.applovin.impl.mediation.e.c;
import com.applovin.impl.sdk.m;
import com.applovin.impl.sdk.utils.CollectionUtils;
import com.applovin.impl.sdk.utils.JsonUtils;
import com.applovin.impl.sdk.utils.e;
import com.applovin.impl.sdk.w;
import com.applovin.mediation.MaxMediatedNetworkInfo;
import com.applovin.sdk.AppLovinAdService;
import com.applovin.sdk.AppLovinCmpService;
import com.applovin.sdk.AppLovinEventService;
import com.applovin.sdk.AppLovinPostbackService;
import com.applovin.sdk.AppLovinSdkConfiguration;
import com.applovin.sdk.AppLovinSdkInitializationConfiguration;
import com.applovin.sdk.AppLovinSdkSettings;
import com.applovin.sdk.AppLovinTargetingData;
import com.applovin.sdk.AppLovinUserSegment;
import com.applovin.sdk.AppLovinUserService;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.json.JSONArray;
import org.json.JSONObject;

public final class AppLovinSdk {
    public static final String VERSION = AppLovinSdk.getVersion();
    public static final int VERSION_CODE = AppLovinSdk.getVersionCode();
    private static final String TAG = "AppLovinSdk";
    private static AppLovinSdk instance;
    private static final Object instanceLock;
    private static final Map<String, AppLovinSdk> sdkInstances;
    private static final Object sdkInstancesLock;
    private final m coreSdk;

    public String getSdkKey() {
        return this.coreSdk.getSdkKey();
    }

    public AppLovinSdkSettings getSettings() {
        return this.coreSdk.getSettings();
    }

    public AppLovinSdkConfiguration getConfiguration() {
        return this.coreSdk.getConfiguration();
    }

    @Nullable
    public AppLovinUserSegment getUserSegment() {
        return this.coreSdk.getUserSegment();
    }

    @Nullable
    public AppLovinTargetingData getTargetingData() {
        return this.coreSdk.Ch();
    }

    public AppLovinAdService getAdService() {
        return this.coreSdk.Cq();
    }

    public AppLovinEventService getEventService() {
        return this.coreSdk.Cs();
    }

    public AppLovinCmpService getCmpService() {
        return this.coreSdk.Cu();
    }

    public AppLovinUserService getUserService() {
        return this.coreSdk.Ct();
    }

    public String getMediationProvider() {
        return this.coreSdk.getMediationProvider();
    }

    public List<MaxMediatedNetworkInfo> getAvailableMediatedNetworks() {
        JSONArray jSONArray = c.f(this.coreSdk);
        ArrayList<MaxMediatedNetworkInfo> arrayList = new ArrayList<MaxMediatedNetworkInfo>(jSONArray.length());
        for (int i2 = 0; i2 < jSONArray.length(); ++i2) {
            JSONObject jSONObject = JsonUtils.getJSONObject(jSONArray, i2, null);
            arrayList.add(new MaxMediatedNetworkInfoImpl(jSONObject));
        }
        return arrayList;
    }

    public void showMediationDebugger() {
        this.coreSdk.showMediationDebugger();
    }

    public void showMediationDebugger(@Nullable Map<String, List<?>> map) {
        this.coreSdk.showMediationDebugger(map);
    }

    public void showCreativeDebugger() {
        this.coreSdk.showCreativeDebugger();
    }

    public boolean isInitialized() {
        return this.coreSdk.isEnabled();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static AppLovinSdk getInstance(Context context) {
        if (context == null) {
            throw new IllegalArgumentException("No context specified");
        }
        String string2 = e.W(context).M("applovin.sdk.key", null);
        if (string2 != null) {
            return AppLovinSdk.getInstance(new a(context), context);
        }
        Object object = instanceLock;
        synchronized (object) {
            if (instance == null) {
                instance = new AppLovinSdk(context);
            }
            return instance;
        }
    }

    public void initialize(AppLovinSdkInitializationConfiguration appLovinSdkInitializationConfiguration, @Nullable SdkInitializationListener sdkInitializationListener) {
        this.coreSdk.initialize(appLovinSdkInitializationConfiguration, sdkInitializationListener);
    }

    private static String getVersion() {
        return "12.4.0";
    }

    private static int getVersionCode() {
        return 12040099;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void reinitializeAll(Boolean bl, Boolean bl2, Boolean bl3) {
        Object object = sdkInstancesLock;
        synchronized (object) {
            for (AppLovinSdk appLovinSdk : AppLovinSdk.getInstances()) {
                appLovinSdk.reinitialize(bl, bl2, bl3);
            }
        }
    }

    private void reinitialize(Boolean bl, Boolean bl2, Boolean bl3) {
        Map<String, String> map;
        this.coreSdk.BR();
        this.coreSdk.BX();
        if (bl != null) {
            this.coreSdk.Cv();
            if (w.FV()) {
                this.coreSdk.Cv().g(TAG, "Toggled 'huc' to " + bl);
            }
            map = CollectionUtils.map("value", bl.toString());
            this.getEventService().trackEvent("huc", map);
        }
        if (bl2 != null) {
            this.coreSdk.Cv();
            if (w.FV()) {
                this.coreSdk.Cv().g(TAG, "Toggled 'aru' to " + bl2);
            }
            map = CollectionUtils.map("value", bl2.toString());
            this.getEventService().trackEvent("aru", map);
        }
        if (bl3 != null) {
            this.coreSdk.Cv();
            if (w.FV()) {
                this.coreSdk.Cv().g(TAG, "Toggled 'dns' to " + bl3);
            }
            map = CollectionUtils.map("value", bl3.toString());
            this.getEventService().trackEvent("dns", map);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Collection<AppLovinSdk> getInstances() {
        if (instance != null) {
            return Arrays.asList(instance);
        }
        Object object = sdkInstancesLock;
        synchronized (object) {
            return sdkInstances.values();
        }
    }

    private AppLovinSdk(Context context) {
        this.coreSdk = new m(context);
        this.coreSdk.a(this);
    }

    public String toString() {
        return "AppLovinSdk{sdkKey='" + this.getSdkKey() + "', isInitialized=" + this.isInitialized() + ", isFirstSession=" + this.coreSdk.Dn() + '}';
    }

    public m a() {
        return this.coreSdk;
    }

    @Deprecated
    public void setPluginVersion(String string2) {
        this.coreSdk.setPluginVersion(string2);
    }

    @Deprecated
    public String getUserIdentifier() {
        return this.coreSdk.Cm();
    }

    @Deprecated
    public void setUserIdentifier(String string2) {
        this.coreSdk.cB(string2);
    }

    @Deprecated
    public void setMediationProvider(String string2) {
        this.coreSdk.setMediationProvider(string2);
    }

    @Deprecated
    public void initializeSdk() {
    }

    @Deprecated
    public void initializeSdk(SdkInitializationListener sdkInitializationListener) {
        this.coreSdk.initializeSdk(sdkInitializationListener);
    }

    @Deprecated
    public static void initializeSdk(Context context) {
        AppLovinSdk.initializeSdk(context, null);
    }

    @Deprecated
    public static void initializeSdk(Context context, SdkInitializationListener sdkInitializationListener) {
        if (context == null) {
            throw new IllegalArgumentException("No context specified");
        }
        AppLovinSdk appLovinSdk = AppLovinSdk.getInstance(context);
        if (appLovinSdk != null) {
            appLovinSdk.initializeSdk(sdkInitializationListener);
        } else {
            w.I(TAG, "Unable to initialize AppLovin SDK: SDK object not created");
        }
    }

    @Deprecated
    public static AppLovinSdk getInstance(AppLovinSdkSettings appLovinSdkSettings, Context context) {
        if (context == null) {
            throw new IllegalArgumentException("No context specified");
        }
        String string2 = e.W(context).M("applovin.sdk.key", "");
        return AppLovinSdk.getInstance(string2, appLovinSdkSettings, context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public static AppLovinSdk getInstance(String string2, AppLovinSdkSettings appLovinSdkSettings, Context context) {
        if (appLovinSdkSettings == null) {
            throw new IllegalArgumentException("No userSettings specified");
        }
        if (context == null) {
            throw new IllegalArgumentException("No context specified");
        }
        Object object = instanceLock;
        synchronized (object) {
            if (instance != null && string2.equals(instance.getSdkKey())) {
                return instance;
            }
        }
        object = sdkInstancesLock;
        synchronized (object) {
            AppLovinSdk appLovinSdk;
            if (sdkInstances.containsKey(string2)) {
                appLovinSdk = sdkInstances.get(string2);
            } else {
                Object object2;
                if (!TextUtils.isEmpty((CharSequence)string2) && string2.contains(File.separator)) {
                    object2 = "\n**************************************************\nINVALID SDK KEY: " + string2 + "\n**************************************************\n";
                    w.I(TAG, (String)object2);
                    if (!sdkInstances.isEmpty()) {
                        return sdkInstances.values().iterator().next();
                    }
                    string2 = string2.replace(File.separator, "");
                }
                object2 = new m(context);
                ((m)object2).a(string2, appLovinSdkSettings, context);
                AppLovinSdk appLovinSdk2 = new AppLovinSdk((m)object2);
                ((m)object2).a(appLovinSdk2);
                appLovinSdkSettings.attachAppLovinSdk((m)object2);
                sdkInstances.put(string2, appLovinSdk2);
                appLovinSdk = appLovinSdk2;
            }
            return appLovinSdk;
        }
    }

    @Deprecated
    private AppLovinSdk(m m2) {
        this.coreSdk = m2;
    }

    @Deprecated
    public AppLovinPostbackService getPostbackService() {
        return this.coreSdk.Db();
    }

    static {
        instanceLock = new Object();
        sdkInstances = new HashMap<String, AppLovinSdk>(1);
        sdkInstancesLock = new Object();
    }

    private static class a
    extends AppLovinSdkSettings {
        a(Context context) {
            super(context);
        }
    }

    public static interface SdkInitializationListener {
        public void onSdkInitialized(AppLovinSdkConfiguration var1);
    }
}

