package com.applovin.mediation;

import androidx.annotation.NonNull;

/**
 * This interface defines a listener to be notified about ad expiration events.
 */
public interface MaxAdExpirationListener
{
    /**
     * The SDK invokes this callback when a new ad has reloaded after expiration.
     * <p>
     * The SDK invokes this callback on the UI thread.
     *
     * @param expiredAd The previously expired ad.
     * @param newAd     The newly reloaded ad.
     */
    void onExpiredAdReloaded(@NonNull final MaxAd expiredAd, @NonNull final MaxAd newAd);
}
