/*
 * Decompiled with CFR 0.152.
 */
package com.applovin.impl.sdk.utils;

import android.os.Bundle;
import android.os.Parcelable;
import android.text.TextUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class BundleUtils {
    public static boolean getBoolean(String string2, Bundle bundle) {
        return BundleUtils.getBoolean(string2, false, bundle);
    }

    public static boolean getBoolean(String string2, boolean bl, Bundle bundle) {
        if (TextUtils.isEmpty((CharSequence)string2) || bundle == null || !bundle.containsKey(string2)) {
            return bl;
        }
        Object object = bundle.get(string2);
        if (object instanceof Boolean) {
            return (Boolean)object;
        }
        if (object instanceof Number) {
            int n2 = ((Number)object).intValue();
            return n2 != 0;
        }
        if (object instanceof String) {
            String string3 = (String)object;
            if (string3.equalsIgnoreCase("true") || string3.equalsIgnoreCase("1")) {
                return true;
            }
            if (string3.equalsIgnoreCase("false") || string3.equalsIgnoreCase("0")) {
                return false;
            }
            return bl;
        }
        return bl;
    }

    public static int getInt(String string2, Bundle bundle) {
        return BundleUtils.getInt(string2, 0, bundle);
    }

    public static int getInt(String string2, int n2, Bundle bundle) {
        if (TextUtils.isEmpty((CharSequence)string2) || bundle == null || !bundle.containsKey(string2)) {
            return n2;
        }
        Object object = bundle.get(string2);
        if (object instanceof Number) {
            return ((Number)object).intValue();
        }
        if (object instanceof String) {
            try {
                return Integer.parseInt((String)object);
            }
            catch (NumberFormatException numberFormatException) {
                return n2;
            }
        }
        return n2;
    }

    public static int getLong(String string2, Bundle bundle) {
        return BundleUtils.getInt(string2, 0, bundle);
    }

    public static long getLong(String string2, long l2, Bundle bundle) {
        if (TextUtils.isEmpty((CharSequence)string2) || bundle == null || !bundle.containsKey(string2)) {
            return l2;
        }
        Object object = bundle.get(string2);
        if (object instanceof Number) {
            return ((Number)object).longValue();
        }
        if (object instanceof String) {
            try {
                return Long.parseLong((String)object);
            }
            catch (NumberFormatException numberFormatException) {
                return l2;
            }
        }
        return l2;
    }

    public static String getString(String string2, Bundle bundle) {
        return BundleUtils.getString(string2, null, bundle);
    }

    public static String getString(String string2, String string3, Bundle bundle) {
        if (TextUtils.isEmpty((CharSequence)string2) || bundle == null || !bundle.containsKey(string2)) {
            return string3;
        }
        Object object = bundle.get(string2);
        if (object instanceof String) {
            return (String)object;
        }
        return String.valueOf(object);
    }

    public static Map<String, Object> toMap(Bundle bundle) {
        if (bundle == null) {
            return new HashMap<String, Object>();
        }
        HashMap<String, Object> hashMap = new HashMap<String, Object>(bundle.size());
        for (String string2 : bundle.keySet()) {
            Object object = bundle.get(string2);
            if (object == null) continue;
            if (object instanceof Bundle) {
                hashMap.put(string2, BundleUtils.toMap((Bundle)object));
                continue;
            }
            if (object instanceof Collection || object instanceof Parcelable[]) {
                List<Parcelable> list = object instanceof Collection ? (List<Parcelable>)object : Arrays.asList((Parcelable[])object);
                ArrayList<Map<String, Object>> arrayList = new ArrayList<Map<String, Object>>();
                for (Object e2 : list) {
                    if (e2 instanceof Bundle) {
                        arrayList.add(BundleUtils.toMap((Bundle)e2));
                        continue;
                    }
                    arrayList.add((Map<String, Object>)e2);
                }
                hashMap.put(string2, arrayList);
                continue;
            }
            hashMap.put(string2, object);
        }
        return hashMap;
    }
}

