/*
 * Decompiled with CFR 0.152.
 */
package com.applovin.mediation.adapters;

import android.app.Activity;
import android.content.Context;
import android.os.Build;
import android.os.Bundle;
import android.text.TextUtils;
import com.applovin.mediation.MaxReward;
import com.applovin.mediation.adapter.MaxAdapter;
import com.applovin.mediation.adapter.MaxAdapterError;
import com.applovin.mediation.adapter.MaxInterstitialAdapter;
import com.applovin.mediation.adapter.MaxRewardedAdapter;
import com.applovin.mediation.adapter.listeners.MaxInterstitialAdapterListener;
import com.applovin.mediation.adapter.listeners.MaxRewardedAdapterListener;
import com.applovin.mediation.adapter.parameters.MaxAdapterInitializationParameters;
import com.applovin.mediation.adapter.parameters.MaxAdapterParameters;
import com.applovin.mediation.adapter.parameters.MaxAdapterResponseParameters;
import com.applovin.mediation.adapters.MediationAdapterBase;
import com.applovin.mediation.adapters.MediationAdapterRouter;
import com.applovin.sdk.AppLovinSdk;
import com.applovin.sdk.AppLovinSdkConfiguration;
import com.chartboost.sdk.Chartboost;
import com.chartboost.sdk.ChartboostDelegate;
import com.chartboost.sdk.Libraries.CBLogging;
import com.chartboost.sdk.Model.CBError;
import com.chartboost.sdk.Privacy.model.CCPA;
import com.chartboost.sdk.Privacy.model.DataUseConsent;
import com.chartboost.sdk.Privacy.model.GDPR;
import java.lang.reflect.Method;
import java.util.concurrent.atomic.AtomicBoolean;

public class ChartboostMediationAdapter
extends MediationAdapterBase
implements MaxInterstitialAdapter,
MaxRewardedAdapter {
    private static final ChartboostMediationAdapterRouter ROUTER;
    private static final AtomicBoolean INITIALIZED;
    private static MaxAdapter.InitializationStatus sStatus;
    private String mLocation;

    public ChartboostMediationAdapter(AppLovinSdk sdk) {
        super(sdk);
    }

    public void initialize(MaxAdapterInitializationParameters parameters, Activity activity, MaxAdapter.OnCompletionListener onCompletionListener) {
        this.checkExistence(new Class[]{Chartboost.class});
        if (INITIALIZED.compareAndSet(false, true)) {
            sStatus = MaxAdapter.InitializationStatus.INITIALIZING;
            Bundle serverParameters = parameters.getServerParameters();
            String appId = serverParameters.getString("app_id");
            this.log("Initializing Chartboost SDK with app id: " + appId + "...");
            ROUTER.setOnCompletionListener(onCompletionListener);
            this.updateConsentStatus((MaxAdapterParameters)parameters, activity.getApplicationContext());
            String appSignature = serverParameters.getString("app_signature");
            Chartboost.startWithAppId((Context)activity.getApplicationContext(), (String)appId, (String)appSignature);
            Chartboost.setDelegate((ChartboostDelegate)ROUTER.getDelegate());
            Chartboost.setMediation((Chartboost.CBMediation)Chartboost.CBMediation.CBMediationOther, (String)AppLovinSdk.VERSION, (String)this.getAdapterVersion());
            boolean autoCacheAds = serverParameters.getBoolean("auto_cache_ads");
            Chartboost.setAutoCacheAds((boolean)autoCacheAds);
            if (parameters.isTesting()) {
                Chartboost.setLoggingLevel((CBLogging.Level)CBLogging.Level.ALL);
            }
            if (serverParameters.containsKey("prefetch_video_content")) {
                boolean prefetchVideoContent = serverParameters.getBoolean("prefetch_video_content");
                Chartboost.setShouldPrefetchVideoContent((boolean)prefetchVideoContent);
            }
        } else {
            this.log("Chartboost SDK already initialized...");
            if (Chartboost.getDelegate() == null) {
                Chartboost.setDelegate((ChartboostDelegate)ROUTER.getDelegate());
            }
            onCompletionListener.onCompletion(sStatus, null);
        }
    }

    public String getSdkVersion() {
        return Chartboost.getSDKVersion();
    }

    public String getAdapterVersion() {
        return "8.2.1.0";
    }

    public void onDestroy() {
        ROUTER.removeAdapter((MaxAdapter)this, this.mLocation);
    }

    public void loadInterstitialAd(MaxAdapterResponseParameters parameters, Activity activity, MaxInterstitialAdapterListener listener) {
        this.mLocation = this.retrieveLocation(parameters);
        this.log("Loading interstitial ad for location \"" + this.mLocation + "\"...");
        this.updateConsentStatus((MaxAdapterParameters)parameters, activity.getApplicationContext());
        ROUTER.addInterstitialAdapter((MaxAdapter)this, listener, this.mLocation);
        if (Chartboost.hasInterstitial((String)this.mLocation)) {
            this.log("Ad is available already");
            ROUTER.onAdLoaded(this.mLocation);
        } else if (Build.VERSION.SDK_INT >= 21) {
            Chartboost.cacheInterstitial((String)this.mLocation);
        } else {
            this.log("Ad load failed: Chartboost does not support showing interstitial ads for devices with Android versions lower than 21");
            ROUTER.onAdLoadFailed(parameters.getThirdPartyAdPlacementId(), MaxAdapterError.INVALID_CONFIGURATION);
        }
    }

    public void showInterstitialAd(MaxAdapterResponseParameters parameters, Activity activity, MaxInterstitialAdapterListener listener) {
        this.log("Showing interstitial ad for location \"" + this.mLocation + "\"...");
        ROUTER.addShowingAdapter((MaxAdapter)this);
        this.updateShowConfigurations(parameters);
        if (Chartboost.hasInterstitial((String)this.mLocation)) {
            Chartboost.showInterstitial((String)this.mLocation);
        } else {
            this.log("Interstitial ad not ready");
            ROUTER.onAdDisplayFailed(this.mLocation, MaxAdapterError.AD_NOT_READY);
        }
    }

    public void loadRewardedAd(MaxAdapterResponseParameters parameters, Activity activity, MaxRewardedAdapterListener listener) {
        this.mLocation = this.retrieveLocation(parameters);
        this.log("Loading rewarded ad for location \"" + this.mLocation + "\"...");
        this.updateConsentStatus((MaxAdapterParameters)parameters, activity.getApplicationContext());
        ROUTER.addRewardedAdapter((MaxAdapter)this, listener, this.mLocation);
        if (Chartboost.hasRewardedVideo((String)this.mLocation)) {
            this.log("Ad is available already");
            ROUTER.onAdLoaded(this.mLocation);
        } else if (Build.VERSION.SDK_INT >= 21) {
            Chartboost.cacheRewardedVideo((String)this.mLocation);
        } else {
            this.log("Ad load failed: Chartboost does not support showing rewarded ads for devices with Android versions lower than 21");
            ROUTER.onAdLoadFailed(parameters.getThirdPartyAdPlacementId(), MaxAdapterError.INVALID_CONFIGURATION);
        }
    }

    public void showRewardedAd(MaxAdapterResponseParameters parameters, Activity activity, MaxRewardedAdapterListener listener) {
        this.log("Showing rewarded ad for location \"" + this.mLocation + "\"...");
        ROUTER.addShowingAdapter((MaxAdapter)this);
        this.updateShowConfigurations(parameters);
        if (Chartboost.hasRewardedVideo((String)this.mLocation)) {
            this.configureReward(parameters);
            Chartboost.showRewardedVideo((String)this.mLocation);
        } else {
            this.log("Rewarded ad not ready");
            ROUTER.onAdDisplayFailed(this.mLocation, MaxAdapterError.AD_NOT_READY);
        }
    }

    void updateConsentStatus(MaxAdapterParameters parameters, Context applicationContext) {
        Boolean isDoNotSell;
        Boolean hasUserConsent;
        if (this.getWrappingSdk().getConfiguration().getConsentDialogState() == AppLovinSdkConfiguration.ConsentDialogState.APPLIES && (hasUserConsent = this.getPrivacySetting("hasUserConsent", parameters)) != null) {
            GDPR gdprConsent = new GDPR(hasUserConsent != false ? GDPR.GDPR_CONSENT.BEHAVIORAL : GDPR.GDPR_CONSENT.NON_BEHAVIORAL);
            Chartboost.addDataUseConsent((Context)applicationContext, (DataUseConsent)gdprConsent);
        }
        if (AppLovinSdk.VERSION_CODE >= 91100 && (isDoNotSell = this.getPrivacySetting("isDoNotSell", parameters)) != null) {
            CCPA ccpaConsent = new CCPA(isDoNotSell != false ? CCPA.CCPA_CONSENT.OPT_OUT_SALE : CCPA.CCPA_CONSENT.OPT_IN_SALE);
            Chartboost.addDataUseConsent((Context)applicationContext, (DataUseConsent)ccpaConsent);
        }
    }

    private Boolean getPrivacySetting(String privacySetting, MaxAdapterParameters parameters) {
        try {
            Class<?> parametersClass = parameters.getClass();
            Method privacyMethod = parametersClass.getMethod(privacySetting, new Class[0]);
            return (Boolean)privacyMethod.invoke((Object)parameters, new Object[0]);
        }
        catch (Exception exception) {
            this.log("Error getting privacy setting " + privacySetting + " with exception: ", exception);
            return AppLovinSdk.VERSION_CODE >= 9140000 ? null : Boolean.valueOf(false);
        }
    }

    private String retrieveLocation(MaxAdapterResponseParameters parameters) {
        if (!TextUtils.isEmpty((CharSequence)parameters.getThirdPartyAdPlacementId())) {
            return parameters.getThirdPartyAdPlacementId();
        }
        return "Default";
    }

    private void updateShowConfigurations(MaxAdapterResponseParameters parameters) {
        Bundle serverParameters = parameters.getServerParameters();
        if (serverParameters.containsKey("hide_system_ui")) {
            boolean hideSystemUi = serverParameters.getBoolean("hide_system_ui");
            Chartboost.setShouldHideSystemUI((Boolean)hideSystemUi);
        }
    }

    static {
        INITIALIZED = new AtomicBoolean();
        ROUTER = AppLovinSdk.VERSION_CODE >= 90802 ? (ChartboostMediationAdapterRouter)MediationAdapterRouter.getSharedInstance(ChartboostMediationAdapterRouter.class) : new ChartboostMediationAdapterRouter();
    }

    private static class ChartboostMediationAdapterRouter
    extends MediationAdapterRouter {
        private final AtomicBoolean isShowingAd = new AtomicBoolean();
        private MaxAdapter.OnCompletionListener onCompletionListener;
        private boolean hasGrantedReward;
        private final ChartboostDelegate chartboostDelegate = new ChartboostDelegate(){

            public void didInitialize() {
                ChartboostMediationAdapterRouter.this.log("Chartboost SDK initialized");
                sStatus = MaxAdapter.InitializationStatus.INITIALIZED_UNKNOWN;
                if (ChartboostMediationAdapterRouter.this.onCompletionListener != null) {
                    ChartboostMediationAdapterRouter.this.onCompletionListener.onCompletion(sStatus, null);
                    ChartboostMediationAdapterRouter.this.onCompletionListener = null;
                }
            }

            public void didCacheInterstitial(String location) {
                ChartboostMediationAdapterRouter.this.log("Interstitial loaded");
                ChartboostMediationAdapterRouter.this.onAdLoaded(location);
            }

            public void didFailToLoadInterstitial(String location, CBError.CBImpressionError error) {
                MaxAdapterError adapterError = ChartboostMediationAdapterRouter.toMaxError(error);
                if (ChartboostMediationAdapterRouter.this.isShowingAd.compareAndSet(true, false)) {
                    ChartboostMediationAdapterRouter.this.log("Interstitial failed to show with error: " + error);
                    ChartboostMediationAdapterRouter.this.onAdDisplayFailed(location, adapterError);
                } else {
                    ChartboostMediationAdapterRouter.this.log("Interstitial failed to load with error: " + error);
                    ChartboostMediationAdapterRouter.this.onAdLoadFailed(location, adapterError);
                }
            }

            public void didDisplayInterstitial(String location) {
                ChartboostMediationAdapterRouter.this.log("Interstitial shown");
                ChartboostMediationAdapterRouter.this.onAdDisplayed(location);
            }

            public void didClickInterstitial(String location) {
                ChartboostMediationAdapterRouter.this.log("Interstitial clicked");
                ChartboostMediationAdapterRouter.this.onAdClicked(location);
            }

            public void didDismissInterstitial(String location) {
                ChartboostMediationAdapterRouter.this.isShowingAd.set(false);
                ChartboostMediationAdapterRouter.this.log("Interstitial hidden");
                ChartboostMediationAdapterRouter.this.onAdHidden(location);
            }

            public void didCacheRewardedVideo(String location) {
                ChartboostMediationAdapterRouter.this.log("Rewarded ad loaded");
                ChartboostMediationAdapterRouter.this.onAdLoaded(location);
            }

            public void didFailToLoadRewardedVideo(String location, CBError.CBImpressionError error) {
                MaxAdapterError adapterError = ChartboostMediationAdapterRouter.toMaxError(error);
                if (ChartboostMediationAdapterRouter.this.isShowingAd.compareAndSet(true, false)) {
                    ChartboostMediationAdapterRouter.this.log("Rewarded ad failed to show with error: " + error);
                    ChartboostMediationAdapterRouter.this.onAdDisplayFailed(location, adapterError);
                } else {
                    ChartboostMediationAdapterRouter.this.log("Rewarded ad failed to load with error: " + error);
                    ChartboostMediationAdapterRouter.this.onAdLoadFailed(location, adapterError);
                }
            }

            public void didDisplayRewardedVideo(String location) {
                ChartboostMediationAdapterRouter.this.log("Rewarded ad shown");
                ChartboostMediationAdapterRouter.this.onAdDisplayed(location);
                ChartboostMediationAdapterRouter.this.onRewardedAdVideoStarted(location);
            }

            public void didClickRewardedVideo(String location) {
                ChartboostMediationAdapterRouter.this.log("Rewarded ad clicked");
                ChartboostMediationAdapterRouter.this.onAdClicked(location);
            }

            public void didDismissRewardedVideo(String location) {
                ChartboostMediationAdapterRouter.this.isShowingAd.set(false);
                if (ChartboostMediationAdapterRouter.this.hasGrantedReward || ChartboostMediationAdapterRouter.this.shouldAlwaysRewardUser(location)) {
                    MaxReward reward = ChartboostMediationAdapterRouter.this.getReward(location);
                    ChartboostMediationAdapterRouter.this.log("Rewarded ad user with reward: " + reward);
                    ChartboostMediationAdapterRouter.this.onUserRewarded(location, reward);
                    ChartboostMediationAdapterRouter.this.hasGrantedReward = false;
                }
                ChartboostMediationAdapterRouter.this.log("Rewarded ad hidden");
                ChartboostMediationAdapterRouter.this.onAdHidden(location);
            }

            public void didCompleteRewardedVideo(String location, int rewardAmount) {
                ChartboostMediationAdapterRouter.this.log("Rewarded ad video completed");
                ChartboostMediationAdapterRouter.this.onRewardedAdVideoCompleted(location);
                ChartboostMediationAdapterRouter.this.hasGrantedReward = true;
            }

            public void didFailToRecordClick(String uri, CBError.CBClickError error) {
                ChartboostMediationAdapterRouter.this.log("Failed to record click at \"" + uri + "\" because of error: " + error);
            }
        };

        private ChartboostMediationAdapterRouter() {
        }

        ChartboostDelegate getDelegate() {
            return this.chartboostDelegate;
        }

        void setOnCompletionListener(MaxAdapter.OnCompletionListener onCompletionListener) {
            this.onCompletionListener = onCompletionListener;
        }

        void initialize(MaxAdapterInitializationParameters parameters, Activity activity, MaxAdapter.OnCompletionListener onCompletionListener) {
        }

        public void addShowingAdapter(MaxAdapter adapter) {
            super.addShowingAdapter(adapter);
            this.isShowingAd.set(true);
        }

        private static MaxAdapterError toMaxError(CBError.CBImpressionError chartboostError) {
            MaxAdapterError adapterError = chartboostError == CBError.CBImpressionError.INTERNAL ? MaxAdapterError.INTERNAL_ERROR : (chartboostError == CBError.CBImpressionError.INTERNET_UNAVAILABLE ? MaxAdapterError.NO_CONNECTION : (chartboostError == CBError.CBImpressionError.TOO_MANY_CONNECTIONS ? MaxAdapterError.INTERNAL_ERROR : (chartboostError == CBError.CBImpressionError.WRONG_ORIENTATION ? MaxAdapterError.INVALID_CONFIGURATION : (chartboostError == CBError.CBImpressionError.FIRST_SESSION_INTERSTITIALS_DISABLED ? MaxAdapterError.INVALID_CONFIGURATION : (chartboostError == CBError.CBImpressionError.NETWORK_FAILURE ? MaxAdapterError.NO_CONNECTION : (chartboostError == CBError.CBImpressionError.NO_AD_FOUND ? MaxAdapterError.NO_FILL : (chartboostError == CBError.CBImpressionError.SESSION_NOT_STARTED ? MaxAdapterError.NOT_INITIALIZED : (chartboostError == CBError.CBImpressionError.IMPRESSION_ALREADY_VISIBLE ? MaxAdapterError.INVALID_LOAD_STATE : (chartboostError == CBError.CBImpressionError.USER_CANCELLATION ? MaxAdapterError.UNSPECIFIED : (chartboostError == CBError.CBImpressionError.INVALID_LOCATION ? MaxAdapterError.UNSPECIFIED : (chartboostError == CBError.CBImpressionError.ASSETS_DOWNLOAD_FAILURE ? MaxAdapterError.BAD_REQUEST : (chartboostError == CBError.CBImpressionError.ASSET_PREFETCH_IN_PROGRESS ? MaxAdapterError.AD_NOT_READY : (chartboostError == CBError.CBImpressionError.ERROR_LOADING_WEB_VIEW || chartboostError == CBError.CBImpressionError.WEB_VIEW_PAGE_LOAD_TIMEOUT || chartboostError == CBError.CBImpressionError.WEB_VIEW_CLIENT_RECEIVED_ERROR ? MaxAdapterError.WEBVIEW_ERROR : (chartboostError == CBError.CBImpressionError.INTERNET_UNAVAILABLE_AT_SHOW ? MaxAdapterError.NO_CONNECTION : (chartboostError == CBError.CBImpressionError.NO_HOST_ACTIVITY ? MaxAdapterError.INTERNAL_ERROR : MaxAdapterError.UNSPECIFIED)))))))))))))));
            return new MaxAdapterError(adapterError.getErrorCode(), adapterError.getErrorMessage(), chartboostError.ordinal(), chartboostError.name());
        }
    }
}

