/*
 * Decompiled with CFR 0.152.
 */
package com.applovin.mediation.adapters;

import android.app.Activity;
import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.os.Bundle;
import android.text.TextUtils;
import android.util.DisplayMetrics;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import com.applovin.impl.sdk.utils.BundleUtils;
import com.applovin.mediation.MaxAdFormat;
import com.applovin.mediation.MaxReward;
import com.applovin.mediation.adapter.MaxAdViewAdapter;
import com.applovin.mediation.adapter.MaxAdapter;
import com.applovin.mediation.adapter.MaxAdapterError;
import com.applovin.mediation.adapter.MaxInterstitialAdapter;
import com.applovin.mediation.adapter.MaxRewardedAdapter;
import com.applovin.mediation.adapter.listeners.MaxAdViewAdapterListener;
import com.applovin.mediation.adapter.listeners.MaxInterstitialAdapterListener;
import com.applovin.mediation.adapter.listeners.MaxNativeAdAdapterListener;
import com.applovin.mediation.adapter.listeners.MaxRewardedAdapterListener;
import com.applovin.mediation.adapter.parameters.MaxAdapterInitializationParameters;
import com.applovin.mediation.adapter.parameters.MaxAdapterResponseParameters;
import com.applovin.mediation.adapters.MediationAdapterBase;
import com.applovin.mediation.nativeAds.MaxNativeAd;
import com.applovin.mediation.nativeAds.MaxNativeAdView;
import com.applovin.sdk.AppLovinSdk;
import com.applovin.sdk.AppLovinSdkUtils;
import com.five_corp.ad.FiveAd;
import com.five_corp.ad.FiveAdConfig;
import com.five_corp.ad.FiveAdCustomLayout;
import com.five_corp.ad.FiveAdCustomLayoutEventListener;
import com.five_corp.ad.FiveAdErrorCode;
import com.five_corp.ad.FiveAdInterface;
import com.five_corp.ad.FiveAdInterstitial;
import com.five_corp.ad.FiveAdInterstitialEventListener;
import com.five_corp.ad.FiveAdLoadListener;
import com.five_corp.ad.FiveAdNative;
import com.five_corp.ad.FiveAdNativeEventListener;
import com.five_corp.ad.FiveAdState;
import com.five_corp.ad.FiveAdVideoReward;
import com.five_corp.ad.FiveAdVideoRewardEventListener;
import com.five_corp.ad.NeedChildDirectedTreatment;
import com.five_corp.ad.NeedGdprNonPersonalizedAdsTreatment;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;

public class LineMediationAdapter
extends MediationAdapterBase
implements MaxInterstitialAdapter,
MaxRewardedAdapter,
MaxAdViewAdapter {
    private static final AtomicBoolean INITIALIZED = new AtomicBoolean();
    private FiveAdInterstitial interstitialAd;
    private FiveAdVideoReward rewardedAd;
    private FiveAdCustomLayout adView;
    private FiveAdNative nativeAd;

    public LineMediationAdapter(AppLovinSdk sdk) {
        super(sdk);
    }

    public String getSdkVersion() {
        return FiveAd.getSdkSemanticVersion();
    }

    public String getAdapterVersion() {
        return "2024.1.12.0";
    }

    public void initialize(MaxAdapterInitializationParameters parameters, Activity activity, MaxAdapter.OnCompletionListener onCompletionListener) {
        if (INITIALIZED.compareAndSet(false, true)) {
            Boolean isAgeRestrictedUser;
            Boolean hasUserConsent;
            String appId = parameters.getServerParameters().getString("app_id");
            this.log("Initializing Line SDK with app id: " + appId + "...");
            FiveAdConfig config = new FiveAdConfig(appId);
            config.isTest = parameters.isTesting();
            Bundle serverParameters = parameters.getServerParameters();
            if (serverParameters.containsKey("is_muted")) {
                boolean muted = serverParameters.getBoolean("is_muted");
                config.enableSoundByDefault(!muted);
            }
            if ((hasUserConsent = parameters.hasUserConsent()) != null) {
                NeedGdprNonPersonalizedAdsTreatment needGdprNonPersonalizedAdsTreatment = config.needGdprNonPersonalizedAdsTreatment = hasUserConsent != false ? NeedGdprNonPersonalizedAdsTreatment.FALSE : NeedGdprNonPersonalizedAdsTreatment.TRUE;
            }
            if ((isAgeRestrictedUser = parameters.isAgeRestrictedUser()) != null) {
                config.needChildDirectedTreatment = isAgeRestrictedUser != false ? NeedChildDirectedTreatment.TRUE : NeedChildDirectedTreatment.FALSE;
            }
            Context context = activity != null ? activity.getApplicationContext() : this.getApplicationContext();
            FiveAd.initialize((Context)context, (FiveAdConfig)config);
            onCompletionListener.onCompletion(MaxAdapter.InitializationStatus.INITIALIZED_UNKNOWN, null);
        } else if (FiveAd.isInitialized()) {
            this.log("Line SDK is already initialized");
            onCompletionListener.onCompletion(MaxAdapter.InitializationStatus.INITIALIZED_UNKNOWN, null);
        } else {
            this.log("Line SDK still initializing");
            onCompletionListener.onCompletion(MaxAdapter.InitializationStatus.INITIALIZING, null);
        }
    }

    public void onDestroy() {
        this.interstitialAd = null;
        this.rewardedAd = null;
        this.adView = null;
        this.nativeAd = null;
    }

    public void loadInterstitialAd(MaxAdapterResponseParameters parameters, Activity activity, MaxInterstitialAdapterListener listener) {
        String slotId = parameters.getThirdPartyAdPlacementId();
        this.log("Loading interstitial ad for slot id: " + slotId + "...");
        this.interstitialAd = new FiveAdInterstitial((Context)activity, slotId);
        InterstitialListener interstitialListener = new InterstitialListener(listener);
        this.interstitialAd.setLoadListener((FiveAdLoadListener)interstitialListener);
        this.interstitialAd.setEventListener((FiveAdInterstitialEventListener)interstitialListener);
        this.interstitialAd.loadAdAsync();
    }

    public void showInterstitialAd(MaxAdapterResponseParameters parameters, Activity activity, MaxInterstitialAdapterListener listener) {
        String slotId = parameters.getThirdPartyAdPlacementId();
        this.log("Showing interstitial ad for slot id: " + slotId + "...");
        this.interstitialAd.showAd();
    }

    public void loadRewardedAd(MaxAdapterResponseParameters parameters, Activity activity, MaxRewardedAdapterListener listener) {
        String slotId = parameters.getThirdPartyAdPlacementId();
        this.log("Loading rewarded ad for slot id: " + slotId + "...");
        this.rewardedAd = new FiveAdVideoReward((Context)activity, slotId);
        RewardedListener rewardedListener = new RewardedListener(listener);
        this.rewardedAd.setLoadListener((FiveAdLoadListener)rewardedListener);
        this.rewardedAd.setEventListener((FiveAdVideoRewardEventListener)rewardedListener);
        this.rewardedAd.loadAdAsync();
    }

    public void showRewardedAd(MaxAdapterResponseParameters parameters, Activity activity, MaxRewardedAdapterListener listener) {
        String slotId = parameters.getThirdPartyAdPlacementId();
        this.log("Showing rewarded ad for slot id: " + slotId + "...");
        this.configureReward(parameters);
        this.rewardedAd.showAd();
    }

    public void loadAdViewAd(MaxAdapterResponseParameters parameters, MaxAdFormat adFormat, Activity activity, MaxAdViewAdapterListener listener) {
        boolean isNative = parameters.getServerParameters().getBoolean("is_native");
        String slotId = parameters.getThirdPartyAdPlacementId();
        this.log("Loading " + (isNative ? "native " : "") + adFormat.getLabel() + " ad for slot id: " + slotId + "...");
        if (isNative) {
            this.nativeAd = new FiveAdNative((Context)activity, slotId, new DisplayMetrics().widthPixels);
            NativeAdViewListener nativeAdViewListener = new NativeAdViewListener(listener, adFormat, parameters.getServerParameters(), activity);
            this.nativeAd.setLoadListener((FiveAdLoadListener)nativeAdViewListener);
            this.nativeAd.setEventListener((FiveAdNativeEventListener)nativeAdViewListener);
            this.nativeAd.enableSound(false);
            this.nativeAd.loadAdAsync();
        } else {
            this.adView = new FiveAdCustomLayout((Context)activity, slotId, new DisplayMetrics().widthPixels);
            AdViewListener adViewListener = new AdViewListener(listener, adFormat);
            this.adView.setLoadListener((FiveAdLoadListener)adViewListener);
            this.adView.setEventListener((FiveAdCustomLayoutEventListener)adViewListener);
            this.adView.enableSound(false);
            this.adView.loadAdAsync();
        }
    }

    public void loadNativeAd(MaxAdapterResponseParameters parameters, Activity activity, MaxNativeAdAdapterListener listener) {
        String slotId = parameters.getThirdPartyAdPlacementId();
        this.log("Loading native ad for slot id: " + slotId + "...");
        this.nativeAd = new FiveAdNative((Context)activity, slotId, new DisplayMetrics().widthPixels);
        NativeAdListener nativeAdListener = new NativeAdListener(listener, parameters.getServerParameters(), activity);
        this.nativeAd.setLoadListener((FiveAdLoadListener)nativeAdListener);
        this.nativeAd.setEventListener((FiveAdNativeEventListener)nativeAdListener);
        this.nativeAd.enableSound(false);
        this.nativeAd.loadAdAsync();
    }

    private static MaxAdapterError toMaxError(FiveAdErrorCode lineAdsError) {
        MaxAdapterError adapterError = MaxAdapterError.UNSPECIFIED;
        String thirdPartySdkErrorMessage = "Please contact us.";
        switch (lineAdsError) {
            case NETWORK_ERROR: {
                adapterError = MaxAdapterError.NO_CONNECTION;
                thirdPartySdkErrorMessage = "Please try again in a stable network environment.";
                break;
            }
            case NO_AD: {
                adapterError = MaxAdapterError.NO_FILL;
                thirdPartySdkErrorMessage = "Ad was not ready at display time. Please try again.";
                break;
            }
            case BAD_APP_ID: {
                adapterError = MaxAdapterError.INVALID_CONFIGURATION;
                thirdPartySdkErrorMessage = "Check if the OS type, PackageName, and issued AppID registered in FIVE Dashboard and the application settings match. Please be careful about blanks.";
                break;
            }
            case STORAGE_ERROR: {
                adapterError = MaxAdapterError.UNSPECIFIED;
                thirdPartySdkErrorMessage = "There is a problem with the device storage. Please try again with another device.";
                break;
            }
            case INTERNAL_ERROR: {
                adapterError = MaxAdapterError.INTERNAL_ERROR;
                thirdPartySdkErrorMessage = "Please contact us.";
                break;
            }
            case INVALID_STATE: {
                adapterError = MaxAdapterError.INVALID_LOAD_STATE;
                thirdPartySdkErrorMessage = "There is a problem with the implementation. Please check the following. Whether the initialization process (FiveAd.initialize) is executed before the creation of the ad object or loadAdAsync. Are you calling loadAdAsync multiple times for one ad object?";
                break;
            }
            case BAD_SLOT_ID: {
                adapterError = MaxAdapterError.INVALID_CONFIGURATION;
                thirdPartySdkErrorMessage = "Make sure you are using the SlotID issued on the FIVE Dashboard.";
                break;
            }
            case SUPPRESSED: 
            case PLAYER_ERROR: {
                adapterError = MaxAdapterError.UNSPECIFIED;
                thirdPartySdkErrorMessage = "Please contact us.";
            }
        }
        return new MaxAdapterError(adapterError.getErrorCode(), adapterError.getErrorMessage(), lineAdsError.ordinal(), thirdPartySdkErrorMessage);
    }

    private class MaxLineNativeAd
    extends MaxNativeAd {
        private MaxLineNativeAd(MaxNativeAd.Builder builder) {
            super(builder);
        }

        public void prepareViewForInteraction(MaxNativeAdView maxNativeAdView) {
            ArrayList<View> clickableViews = new ArrayList<View>(6);
            if (AppLovinSdkUtils.isValidString((String)this.getTitle()) && maxNativeAdView.getTitleTextView() != null) {
                clickableViews.add((View)maxNativeAdView.getTitleTextView());
            }
            if (AppLovinSdkUtils.isValidString((String)this.getAdvertiser()) && maxNativeAdView.getAdvertiserTextView() != null) {
                clickableViews.add((View)maxNativeAdView.getAdvertiserTextView());
            }
            if (AppLovinSdkUtils.isValidString((String)this.getBody()) && maxNativeAdView.getBodyTextView() != null) {
                clickableViews.add((View)maxNativeAdView.getBodyTextView());
            }
            if (AppLovinSdkUtils.isValidString((String)this.getCallToAction()) && maxNativeAdView.getCallToActionButton() != null) {
                clickableViews.add((View)maxNativeAdView.getCallToActionButton());
            }
            if (this.getIcon() != null && maxNativeAdView.getIconImageView() != null) {
                clickableViews.add((View)maxNativeAdView.getIconImageView());
            }
            if (this.getMediaView() != null && maxNativeAdView.getMediaContentViewGroup() != null) {
                clickableViews.add((View)maxNativeAdView.getMediaContentViewGroup());
            }
            this.prepareForInteraction(clickableViews, (ViewGroup)maxNativeAdView);
        }

        public boolean prepareForInteraction(List<View> clickableViews, ViewGroup container) {
            FiveAdNative nativeAd = LineMediationAdapter.this.nativeAd;
            if (nativeAd == null) {
                LineMediationAdapter.this.e("Failed to register native ad views: native ad is null.");
                return false;
            }
            LineMediationAdapter.this.d("Preparing views for interaction: " + clickableViews + " with container: " + container);
            ImageView iconImageView = null;
            for (View clickableView : clickableViews) {
                if (!(clickableView instanceof ImageView)) continue;
                iconImageView = (ImageView)clickableView;
                break;
            }
            nativeAd.registerViews((View)container, iconImageView, clickableViews);
            return true;
        }
    }

    private class NativeAdListener
    implements FiveAdLoadListener,
    FiveAdNativeEventListener {
        private final MaxNativeAdAdapterListener listener;
        private final Bundle serverParameters;
        private final WeakReference<Activity> activityRef;

        NativeAdListener(MaxNativeAdAdapterListener listener, Bundle serverParameters, Activity activity) {
            this.listener = listener;
            this.serverParameters = serverParameters;
            this.activityRef = new WeakReference<Activity>(activity);
        }

        public void onFiveAdLoad(final FiveAdInterface ad) {
            LineMediationAdapter.this.log("Native ad loaded for slot id: " + ad.getSlotId() + "...");
            FiveAdNative loadedNativeAd = LineMediationAdapter.this.nativeAd;
            if (loadedNativeAd == null) {
                LineMediationAdapter.this.log("Native ad destroyed before the ad successfully loaded: " + ad.getSlotId() + "...");
                this.listener.onNativeAdLoadFailed(MaxAdapterError.INVALID_LOAD_STATE);
                return;
            }
            final Activity activity = (Activity)this.activityRef.get();
            if (activity == null) {
                LineMediationAdapter.this.log("Native ad (" + ad.getSlotId() + ") failed to load: activity reference is null when ad is loaded");
                this.listener.onNativeAdLoadFailed(new MaxAdapterError(-5601, "Missing Activity"));
                return;
            }
            String templateName = BundleUtils.getString((String)"template", (String)"", (Bundle)this.serverParameters);
            boolean isTemplateAd = AppLovinSdkUtils.isValidString((String)templateName);
            if (isTemplateAd && TextUtils.isEmpty((CharSequence)loadedNativeAd.getAdTitle())) {
                LineMediationAdapter.this.e("Native ad (" + ad + ") does not have required assets.");
                this.listener.onNativeAdLoadFailed(new MaxAdapterError(-5400, "Missing Native Ad Assets"));
                return;
            }
            loadedNativeAd.loadIconImageAsync(new FiveAdNative.LoadImageCallback(){

                public void onImageLoad(Bitmap bitmap) {
                    FiveAdNative nativeAd = LineMediationAdapter.this.nativeAd;
                    if (nativeAd == null) {
                        LineMediationAdapter.this.log("Native ad destroyed before assets finished load for slot id: " + ad.getSlotId());
                        return;
                    }
                    MaxNativeAd.Builder builder = new MaxNativeAd.Builder().setAdFormat(MaxAdFormat.NATIVE).setTitle(nativeAd.getAdTitle()).setAdvertiser(nativeAd.getAdvertiserName()).setBody(nativeAd.getDescriptionText()).setCallToAction(nativeAd.getButtonText()).setIcon(new MaxNativeAd.MaxNativeAdImage((Drawable)new BitmapDrawable(activity.getResources(), bitmap))).setMediaView(nativeAd.getAdMainView());
                    MaxLineNativeAd maxNativeAd = new MaxLineNativeAd(builder);
                    NativeAdListener.this.listener.onNativeAdLoaded((MaxNativeAd)maxNativeAd, null);
                }
            });
        }

        public void onFiveAdLoadError(FiveAdInterface ad, FiveAdErrorCode errorCode) {
            LineMediationAdapter.this.log("Native ad failed to load for slot id: " + ad.getSlotId() + " with error: " + errorCode);
            MaxAdapterError error = LineMediationAdapter.toMaxError(errorCode);
            this.listener.onNativeAdLoadFailed(error);
        }

        public void onViewError(FiveAdNative ad, FiveAdErrorCode errorCode) {
            LineMediationAdapter.this.log("Native ad failed to show for slot id: " + ad.getSlotId() + " with error: " + errorCode);
        }

        public void onImpression(FiveAdNative ad) {
            LineMediationAdapter.this.log("Native ad impression tracked for slot id: " + ad.getSlotId() + "...");
            this.listener.onNativeAdDisplayed(null);
        }

        public void onClick(FiveAdNative ad) {
            LineMediationAdapter.this.log("Native ad clicked for slot id: " + ad.getSlotId());
            this.listener.onNativeAdClicked();
        }

        public void onRemove(FiveAdNative ad) {
            LineMediationAdapter.this.log("Native ad hidden for slot id: " + ad.getSlotId() + "...");
        }

        public void onPlay(FiveAdNative ad) {
            LineMediationAdapter.this.log("Native ad did play for slot id: " + ad.getSlotId() + "...");
        }

        public void onPause(FiveAdNative ad) {
            LineMediationAdapter.this.log("Native ad did pause for slot id: " + ad.getSlotId() + "...");
        }

        public void onViewThrough(FiveAdNative ad) {
            LineMediationAdapter.this.log("Native ad completed for slot id: " + ad.getSlotId() + "...");
        }
    }

    private class NativeAdViewListener
    implements FiveAdLoadListener,
    FiveAdNativeEventListener {
        private final MaxAdViewAdapterListener listener;
        private final MaxAdFormat adFormat;
        private final Bundle serverParameters;
        private final WeakReference<Activity> activityRef;

        NativeAdViewListener(MaxAdViewAdapterListener listener, MaxAdFormat adFormat, Bundle serverParameters, Activity activity) {
            this.listener = listener;
            this.adFormat = adFormat;
            this.serverParameters = serverParameters;
            this.activityRef = new WeakReference<Activity>(activity);
        }

        public void onFiveAdLoad(FiveAdInterface ad) {
            LineMediationAdapter.this.log("Native " + this.adFormat.getLabel() + " ad loaded for slot id: " + ad.getSlotId() + "...");
            if (LineMediationAdapter.this.nativeAd == null) {
                LineMediationAdapter.this.log("Native " + this.adFormat.getLabel() + " ad failed to load: no fill for slot id: " + ad.getSlotId() + "...");
                this.listener.onAdViewAdLoadFailed(MaxAdapterError.NO_FILL);
                return;
            }
            this.renderCustomNativeBanner(ad.getSlotId(), (Activity)this.activityRef.get());
        }

        public void onFiveAdLoadError(FiveAdInterface ad, FiveAdErrorCode errorCode) {
            LineMediationAdapter.this.log("Native " + this.adFormat.getLabel() + " ad failed to load for slot id: " + ad.getSlotId() + " with error: " + errorCode);
            MaxAdapterError error = LineMediationAdapter.toMaxError(errorCode);
            this.listener.onAdViewAdLoadFailed(error);
        }

        public void onViewError(FiveAdNative ad, FiveAdErrorCode errorCode) {
            LineMediationAdapter.this.log("Native " + this.adFormat.getLabel() + " ad failed to show for slot id: " + ad.getSlotId() + " with error: " + errorCode);
            MaxAdapterError error = new MaxAdapterError(-4205, "Ad Display Failed", errorCode.value, "Please Contact Us");
            this.listener.onAdViewAdDisplayFailed(error);
        }

        public void onImpression(FiveAdNative ad) {
            LineMediationAdapter.this.log("Native " + this.adFormat.getLabel() + " ad impression tracked for slot id: " + ad.getSlotId() + "...");
            this.listener.onAdViewAdDisplayed();
        }

        public void onClick(FiveAdNative ad) {
            LineMediationAdapter.this.log("Native " + this.adFormat.getLabel() + " ad clicked for slot id: " + ad.getSlotId());
            this.listener.onAdViewAdClicked();
        }

        public void onRemove(FiveAdNative ad) {
            LineMediationAdapter.this.log("Native " + this.adFormat.getLabel() + " ad hidden for slot id: " + ad.getSlotId() + "...");
            this.listener.onAdViewAdHidden();
        }

        public void onPlay(FiveAdNative ad) {
            LineMediationAdapter.this.log("Native " + this.adFormat.getLabel() + " ad did play for slot id: " + ad.getSlotId() + "...");
        }

        public void onPause(FiveAdNative ad) {
            LineMediationAdapter.this.log("Native " + this.adFormat.getLabel() + " ad did pause for slot id: " + ad.getSlotId() + "...");
        }

        public void onViewThrough(FiveAdNative ad) {
            LineMediationAdapter.this.log("Native " + this.adFormat.getLabel() + " ad completed for slot id: " + ad.getSlotId() + "...");
        }

        private void renderCustomNativeBanner(final String slotId, final Activity activity) {
            LineMediationAdapter.this.nativeAd.loadIconImageAsync(new FiveAdNative.LoadImageCallback(){

                public void onImageLoad(final Bitmap bitmap) {
                    AppLovinSdkUtils.runOnUiThread((Runnable)new Runnable(){

                        @Override
                        public void run() {
                            ViewGroup mediaContentView;
                            MaxNativeAdView maxNativeAdView;
                            FiveAdNative nativeAd = LineMediationAdapter.this.nativeAd;
                            if (nativeAd == null) {
                                LineMediationAdapter.this.log("Native " + NativeAdViewListener.this.adFormat.getLabel() + " ad destroyed before assets finished load for slot id: " + slotId);
                                return;
                            }
                            MaxNativeAd maxNativeAd = new MaxNativeAd.Builder().setAdFormat(NativeAdViewListener.this.adFormat).setTitle(nativeAd.getAdTitle()).setBody(nativeAd.getDescriptionText()).setCallToAction(nativeAd.getButtonText()).setIcon(new MaxNativeAd.MaxNativeAdImage((Drawable)new BitmapDrawable(activity.getResources(), bitmap))).setMediaView(nativeAd.getAdMainView()).build();
                            String templateName = BundleUtils.getString((String)"template", (String)"", (Bundle)NativeAdViewListener.this.serverParameters);
                            if (templateName.contains("vertical") && AppLovinSdk.VERSION_CODE < 9140500) {
                                LineMediationAdapter.this.log("Vertical native banners are only supported on MAX SDK 9.14.5 and above. Default native template will be used.");
                            }
                            if (templateName.equals("vertical")) {
                                String verticalTemplateName;
                                String string = verticalTemplateName = NativeAdViewListener.this.adFormat == MaxAdFormat.LEADER ? "vertical_leader_template" : "vertical_media_banner_template";
                                maxNativeAdView = AppLovinSdk.VERSION_CODE >= 11010000 ? new MaxNativeAdView(maxNativeAd, verticalTemplateName, LineMediationAdapter.this.getApplicationContext()) : new MaxNativeAdView(maxNativeAd, verticalTemplateName, activity);
                            } else {
                                maxNativeAdView = AppLovinSdk.VERSION_CODE >= 11010000 ? new MaxNativeAdView(maxNativeAd, templateName, LineMediationAdapter.this.getApplicationContext()) : new MaxNativeAdView(maxNativeAd, templateName, activity);
                            }
                            ArrayList<Object> clickableViews = new ArrayList<Object>(5);
                            if (AppLovinSdkUtils.isValidString((String)maxNativeAd.getTitle()) && maxNativeAdView.getTitleTextView() != null) {
                                clickableViews.add(maxNativeAdView.getTitleTextView());
                            }
                            if (AppLovinSdkUtils.isValidString((String)maxNativeAd.getBody()) && maxNativeAdView.getBodyTextView() != null) {
                                clickableViews.add(maxNativeAdView.getBodyTextView());
                            }
                            if (AppLovinSdkUtils.isValidString((String)maxNativeAd.getCallToAction()) && maxNativeAdView.getCallToActionButton() != null) {
                                clickableViews.add(maxNativeAdView.getCallToActionButton());
                            }
                            if (maxNativeAd.getIcon() != null && maxNativeAdView.getIconImageView() != null) {
                                clickableViews.add(maxNativeAdView.getIconImageView());
                            }
                            Object object = mediaContentView = AppLovinSdk.VERSION_CODE >= 11000000 ? maxNativeAdView.getMediaContentViewGroup() : maxNativeAdView.getMediaContentView();
                            if (maxNativeAd.getMediaView() != null && mediaContentView != null) {
                                clickableViews.add(mediaContentView);
                            }
                            nativeAd.registerViews((View)maxNativeAdView, (View)maxNativeAdView.getIconImageView(), clickableViews);
                            NativeAdViewListener.this.listener.onAdViewAdLoaded((View)maxNativeAdView);
                        }
                    });
                }
            });
        }
    }

    private class AdViewListener
    implements FiveAdLoadListener,
    FiveAdCustomLayoutEventListener {
        private final MaxAdViewAdapterListener listener;
        private final MaxAdFormat adFormat;

        AdViewListener(MaxAdViewAdapterListener listener, MaxAdFormat adFormat) {
            this.listener = listener;
            this.adFormat = adFormat;
        }

        public void onFiveAdLoad(FiveAdInterface ad) {
            LineMediationAdapter.this.log(this.adFormat.getLabel() + " ad loaded for slot id: " + ad.getSlotId() + "...");
            this.listener.onAdViewAdLoaded((View)LineMediationAdapter.this.adView);
        }

        public void onFiveAdLoadError(FiveAdInterface ad, FiveAdErrorCode errorCode) {
            LineMediationAdapter.this.log(this.adFormat.getLabel() + " ad failed to load for slot id: " + ad.getSlotId() + " with error: " + errorCode);
            MaxAdapterError error = LineMediationAdapter.toMaxError(errorCode);
            this.listener.onAdViewAdLoadFailed(error);
        }

        public void onViewError(FiveAdCustomLayout ad, FiveAdErrorCode errorCode) {
            LineMediationAdapter.this.log(this.adFormat.getLabel() + " ad failed to show for slot id: " + ad.getSlotId() + " with error: " + errorCode);
            MaxAdapterError error = new MaxAdapterError(-4205, "Ad Display Failed", errorCode.value, "Please Contact Us");
            this.listener.onAdViewAdDisplayFailed(error);
        }

        public void onImpression(FiveAdCustomLayout ad) {
            LineMediationAdapter.this.log(this.adFormat.getLabel() + " ad impression tracked for slot id: " + ad.getSlotId() + "...");
            this.listener.onAdViewAdDisplayed();
        }

        public void onClick(FiveAdCustomLayout ad) {
            LineMediationAdapter.this.log(this.adFormat.getLabel() + " ad clicked for slot id: " + ad.getSlotId() + "...");
            this.listener.onAdViewAdClicked();
        }

        public void onRemove(FiveAdCustomLayout ad) {
            LineMediationAdapter.this.log(this.adFormat.getLabel() + " ad hidden for slot id: " + ad.getSlotId() + "...");
            this.listener.onAdViewAdHidden();
        }

        public void onPlay(FiveAdCustomLayout ad) {
            LineMediationAdapter.this.log(this.adFormat.getLabel() + " ad did play for slot id: " + ad.getSlotId() + "...");
        }

        public void onPause(FiveAdCustomLayout ad) {
            LineMediationAdapter.this.log(this.adFormat.getLabel() + " ad did pause for slot id: " + ad.getSlotId() + "...");
        }

        public void onViewThrough(FiveAdCustomLayout ad) {
            LineMediationAdapter.this.log(this.adFormat.getLabel() + " ad completed for slot id: " + ad.getSlotId() + "...");
        }
    }

    private class RewardedListener
    implements FiveAdLoadListener,
    FiveAdVideoRewardEventListener {
        private final MaxRewardedAdapterListener listener;
        private boolean hasGrantedReward;

        RewardedListener(MaxRewardedAdapterListener listener) {
            this.listener = listener;
        }

        public void onFiveAdLoad(FiveAdInterface ad) {
            LineMediationAdapter.this.log("Rewarded ad loaded for slot id: " + ad.getSlotId() + "...");
            this.listener.onRewardedAdLoaded();
        }

        public void onFiveAdLoadError(FiveAdInterface ad, FiveAdErrorCode errorCode) {
            LineMediationAdapter.this.log("Rewarded ad failed to load for slot id: " + ad.getSlotId() + " with error: " + errorCode);
            MaxAdapterError error = LineMediationAdapter.toMaxError(errorCode);
            this.listener.onRewardedAdLoadFailed(error);
        }

        public void onViewError(FiveAdVideoReward ad, FiveAdErrorCode errorCode) {
            LineMediationAdapter.this.log("Rewarded ad failed to show for slot id: " + ad.getSlotId() + " with error: " + errorCode);
            MaxAdapterError error = new MaxAdapterError(-4205, "Ad Display Failed", errorCode.value, "Please Contact Us");
            this.listener.onRewardedAdDisplayFailed(error);
        }

        public void onImpression(FiveAdVideoReward ad) {
            LineMediationAdapter.this.log("Rewarded ad impression tracked for slot id: " + ad.getSlotId() + "...");
            this.listener.onRewardedAdDisplayed();
        }

        public void onClick(FiveAdVideoReward ad) {
            LineMediationAdapter.this.log("Rewarded ad clicked for slot id: " + ad.getSlotId() + "...");
            this.listener.onRewardedAdClicked();
        }

        public void onFullScreenClose(FiveAdVideoReward ad) {
            this.listener.onRewardedAdVideoCompleted();
            if (ad.getState() != FiveAdState.ERROR && (this.hasGrantedReward || LineMediationAdapter.this.shouldAlwaysRewardUser())) {
                MaxReward reward = LineMediationAdapter.this.getReward();
                LineMediationAdapter.this.log("Rewarded ad user with reward: " + reward + " for slot id: " + ad.getSlotId() + "...");
                this.listener.onUserRewarded(reward);
            }
            LineMediationAdapter.this.log("Rewarded ad hidden for slot id: " + ad.getSlotId() + "...");
            this.listener.onRewardedAdHidden();
        }

        public void onFullScreenOpen(FiveAdVideoReward ad) {
            LineMediationAdapter.this.log("Rewarded ad shown for slot id: " + ad.getSlotId() + "...");
            this.listener.onRewardedAdVideoStarted();
        }

        public void onPlay(FiveAdVideoReward ad) {
            LineMediationAdapter.this.log("Rewarded ad did play for slot id: " + ad.getSlotId() + "...");
        }

        public void onPause(FiveAdVideoReward ad) {
            LineMediationAdapter.this.log("Rewarded ad did pause for slot id: " + ad.getSlotId() + "...");
        }

        public void onViewThrough(FiveAdVideoReward ad) {
            LineMediationAdapter.this.log("Rewarded ad completed for slot id: " + ad.getSlotId() + "...");
        }

        public void onReward(FiveAdVideoReward ad) {
            LineMediationAdapter.this.log("Rewarded ad granted reward for slot id: " + ad.getSlotId());
            this.hasGrantedReward = true;
        }
    }

    private class InterstitialListener
    implements FiveAdLoadListener,
    FiveAdInterstitialEventListener {
        private final MaxInterstitialAdapterListener listener;

        InterstitialListener(MaxInterstitialAdapterListener listener) {
            this.listener = listener;
        }

        public void onFiveAdLoad(FiveAdInterface ad) {
            LineMediationAdapter.this.log("Interstitial ad loaded for slot id: " + ad.getSlotId() + "...");
            this.listener.onInterstitialAdLoaded();
        }

        public void onFiveAdLoadError(FiveAdInterface ad, FiveAdErrorCode errorCode) {
            LineMediationAdapter.this.log("Interstitial ad failed to load for slot id: " + ad.getSlotId() + " with error: " + errorCode);
            MaxAdapterError error = LineMediationAdapter.toMaxError(errorCode);
            this.listener.onInterstitialAdLoadFailed(error);
        }

        public void onViewError(FiveAdInterstitial ad, FiveAdErrorCode errorCode) {
            LineMediationAdapter.this.log("Interstitial ad failed to show for slot id: " + ad.getSlotId() + " with error: " + errorCode);
            MaxAdapterError error = new MaxAdapterError(-4205, "Ad Display Failed", errorCode.value, "Please Contact Us");
            this.listener.onInterstitialAdDisplayFailed(error);
        }

        public void onImpression(FiveAdInterstitial ad) {
            LineMediationAdapter.this.log("Interstitial ad impression tracked for slot id: " + ad.getSlotId() + "...");
            this.listener.onInterstitialAdDisplayed();
        }

        public void onClick(FiveAdInterstitial ad) {
            LineMediationAdapter.this.log("Interstitial ad clicked for slot id: " + ad.getSlotId() + "...");
            this.listener.onInterstitialAdClicked();
        }

        public void onFullScreenClose(FiveAdInterstitial ad) {
            LineMediationAdapter.this.log("Interstitial ad hidden for slot id: " + ad.getSlotId() + "...");
            this.listener.onInterstitialAdHidden();
        }

        public void onFullScreenOpen(FiveAdInterstitial ad) {
            LineMediationAdapter.this.log("Interstitial ad shown for slot id: " + ad.getSlotId() + "...");
        }

        public void onPlay(FiveAdInterstitial ad) {
            LineMediationAdapter.this.log("Interstitial ad did play for slot id: " + ad.getSlotId() + "...");
        }

        public void onPause(FiveAdInterstitial ad) {
            LineMediationAdapter.this.log("Interstitial ad did pause for slot id: " + ad.getSlotId() + "...");
        }

        public void onViewThrough(FiveAdInterstitial ad) {
            LineMediationAdapter.this.log("Interstitial ad completed for slot id: " + ad.getSlotId() + "...");
        }
    }
}

