/*
 * Decompiled with CFR 0.152.
 */
package com.applovin.mediation.adapters;

import android.app.Activity;
import android.content.Context;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.net.Uri;
import android.os.Bundle;
import android.text.TextUtils;
import android.view.View;
import android.view.ViewGroup;
import androidx.annotation.NonNull;
import com.applovin.impl.sdk.utils.BundleUtils;
import com.applovin.mediation.MaxAdFormat;
import com.applovin.mediation.MaxReward;
import com.applovin.mediation.adapter.MaxAdViewAdapter;
import com.applovin.mediation.adapter.MaxAdapter;
import com.applovin.mediation.adapter.MaxAdapterError;
import com.applovin.mediation.adapter.MaxInterstitialAdapter;
import com.applovin.mediation.adapter.MaxRewardedAdapter;
import com.applovin.mediation.adapter.MaxSignalProvider;
import com.applovin.mediation.adapter.listeners.MaxAdViewAdapterListener;
import com.applovin.mediation.adapter.listeners.MaxInterstitialAdapterListener;
import com.applovin.mediation.adapter.listeners.MaxNativeAdAdapterListener;
import com.applovin.mediation.adapter.listeners.MaxRewardedAdapterListener;
import com.applovin.mediation.adapter.listeners.MaxSignalCollectionListener;
import com.applovin.mediation.adapter.parameters.MaxAdapterInitializationParameters;
import com.applovin.mediation.adapter.parameters.MaxAdapterParameters;
import com.applovin.mediation.adapter.parameters.MaxAdapterResponseParameters;
import com.applovin.mediation.adapter.parameters.MaxAdapterSignalCollectionParameters;
import com.applovin.mediation.adapters.MediationAdapterBase;
import com.applovin.mediation.nativeAds.MaxNativeAd;
import com.applovin.mediation.nativeAds.MaxNativeAdView;
import com.applovin.sdk.AppLovinSdk;
import com.applovin.sdk.AppLovinSdkUtils;
import com.my.target.ads.InterstitialAd;
import com.my.target.ads.MyTargetView;
import com.my.target.ads.Reward;
import com.my.target.ads.RewardedAd;
import com.my.target.common.MyTargetManager;
import com.my.target.common.MyTargetPrivacy;
import com.my.target.common.models.ImageData;
import com.my.target.nativeads.NativeAd;
import com.my.target.nativeads.banners.NativePromoBanner;
import com.my.target.nativeads.factories.NativeViewsFactory;
import com.my.target.nativeads.views.MediaAdView;
import com.my.target.nativeads.views.NativeAdView;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;

public class MyTargetMediationAdapter
extends MediationAdapterBase
implements MaxSignalProvider,
MaxInterstitialAdapter,
MaxRewardedAdapter,
MaxAdViewAdapter {
    private static final AtomicBoolean initialized = new AtomicBoolean();
    private InterstitialAd interstitialAd;
    private RewardedAd rewardedAd;
    private MyTargetView adView;
    private NativeAd nativeAd;
    private NativeAdView nativeAdView;

    public MyTargetMediationAdapter(AppLovinSdk sdk) {
        super(sdk);
    }

    public String getSdkVersion() {
        return "5.17.0";
    }

    public String getAdapterVersion() {
        return "5.17.0.0";
    }

    public void onDestroy() {
        if (this.interstitialAd != null) {
            this.interstitialAd.destroy();
            this.interstitialAd = null;
        }
        if (this.rewardedAd != null) {
            this.rewardedAd.destroy();
            this.rewardedAd = null;
        }
        if (this.adView != null) {
            this.adView.destroy();
            this.adView = null;
        }
        if (this.nativeAd != null) {
            this.nativeAd.setListener(null);
            this.nativeAd.unregisterView();
            this.nativeAd = null;
            this.nativeAdView = null;
        }
    }

    public void initialize(MaxAdapterInitializationParameters parameters, Activity activity, MaxAdapter.OnCompletionListener onCompletionListener) {
        if (initialized.compareAndSet(false, true)) {
            if (parameters.isTesting()) {
                MyTargetManager.setDebugMode((boolean)true);
            }
            this.log("Initializing myTarget SDK... ");
            Context context = this.getContext(activity);
            MyTargetManager.initSdk((Context)context);
        }
        onCompletionListener.onCompletion(MaxAdapter.InitializationStatus.DOES_NOT_APPLY, null);
    }

    public void collectSignal(MaxAdapterSignalCollectionParameters parameters, Activity activity, MaxSignalCollectionListener callback) {
        this.log("Collecting signal...");
        this.updatePrivacyStates((MaxAdapterParameters)parameters);
        String signal = MyTargetManager.getBidderToken((Context)this.getContext(activity));
        callback.onSignalCollected(signal);
    }

    public void loadInterstitialAd(MaxAdapterResponseParameters parameters, Activity activity, MaxInterstitialAdapterListener listener) {
        int slotId = Integer.parseInt(parameters.getThirdPartyAdPlacementId());
        this.log("Loading " + (AppLovinSdkUtils.isValidString((String)parameters.getBidResponse()) ? "bidding " : "") + " interstitial ad for slot id: " + slotId + "...");
        this.interstitialAd = new InterstitialAd(slotId, (Context)activity);
        this.interstitialAd.setListener((InterstitialAd.InterstitialAdListener)new InterstitialListener(listener));
        this.interstitialAd.getCustomParams().setCustomParam("mediation", "7");
        this.updatePrivacyStates((MaxAdapterParameters)parameters);
        String bidResponse = parameters.getBidResponse();
        if (!TextUtils.isEmpty((CharSequence)bidResponse)) {
            this.interstitialAd.loadFromBid(bidResponse);
        } else {
            this.interstitialAd.load();
        }
    }

    public void showInterstitialAd(MaxAdapterResponseParameters parameters, Activity activity, MaxInterstitialAdapterListener listener) {
        this.log("Showing interstitial ad...");
        if (this.interstitialAd != null) {
            this.interstitialAd.show();
        } else {
            this.log("Interstitial ad is null");
            listener.onInterstitialAdDisplayFailed(new MaxAdapterError(-4205, "Ad Display Failed", 0, "Interstitial ad is null"));
        }
    }

    public void loadRewardedAd(MaxAdapterResponseParameters parameters, Activity activity, MaxRewardedAdapterListener listener) {
        int slotId = Integer.parseInt(parameters.getThirdPartyAdPlacementId());
        this.log("Loading " + (AppLovinSdkUtils.isValidString((String)parameters.getBidResponse()) ? "bidding " : "") + " rewarded ad for slot id: " + slotId + "...");
        this.rewardedAd = new RewardedAd(slotId, (Context)activity);
        this.rewardedAd.setListener((RewardedAd.RewardedAdListener)new RewardedAdListener(listener));
        this.rewardedAd.getCustomParams().setCustomParam("mediation", "7");
        this.updatePrivacyStates((MaxAdapterParameters)parameters);
        String bidResponse = parameters.getBidResponse();
        if (!TextUtils.isEmpty((CharSequence)bidResponse)) {
            this.rewardedAd.loadFromBid(bidResponse);
        } else {
            this.rewardedAd.load();
        }
    }

    public void showRewardedAd(MaxAdapterResponseParameters parameters, Activity activity, MaxRewardedAdapterListener listener) {
        this.log("Showing rewarded ad...");
        if (this.rewardedAd != null) {
            this.configureReward(parameters);
            this.rewardedAd.show();
        } else {
            this.log("Rewarded ad is null");
            listener.onRewardedAdDisplayFailed(new MaxAdapterError(-4205, "Ad Display Failed", 0, "Rewarded ad is null"));
        }
    }

    public void loadAdViewAd(MaxAdapterResponseParameters parameters, MaxAdFormat adFormat, Activity activity, MaxAdViewAdapterListener listener) {
        int slotId = Integer.parseInt(parameters.getThirdPartyAdPlacementId());
        this.log("Loading " + (AppLovinSdkUtils.isValidString((String)parameters.getBidResponse()) ? "bidding " : "") + " ad view with format: " + adFormat.getLabel() + " for slot id: " + slotId + "...");
        this.adView = new MyTargetView(this.getContext(activity));
        this.adView.setSlotId(slotId);
        this.adView.setAdSize(MyTargetMediationAdapter.getBannerSize(adFormat));
        this.adView.setRefreshAd(false);
        this.adView.setListener((MyTargetView.MyTargetViewListener)new AdViewListener(listener));
        this.adView.getCustomParams().setCustomParam("mediation", "7");
        this.updatePrivacyStates((MaxAdapterParameters)parameters);
        String bidResponse = parameters.getBidResponse();
        if (!TextUtils.isEmpty((CharSequence)bidResponse)) {
            this.adView.loadFromBid(bidResponse);
        } else {
            this.adView.load();
        }
    }

    public void loadNativeAd(MaxAdapterResponseParameters parameters, Activity activity, MaxNativeAdAdapterListener listener) {
        int slotId = Integer.parseInt(parameters.getThirdPartyAdPlacementId());
        this.log("Loading " + (AppLovinSdkUtils.isValidString((String)parameters.getBidResponse()) ? "bidding " : "") + " native ad for slot id: " + slotId + "...");
        NativeAdListener adListener = new NativeAdListener(parameters, this.getContext(activity), listener);
        this.nativeAd = new NativeAd(slotId, this.getContext(activity));
        this.nativeAd.setListener((NativeAd.NativeAdListener)adListener);
        this.nativeAd.setMediaListener((NativeAd.NativeAdMediaListener)adListener);
        this.nativeAd.getCustomParams().setCustomParam("mediation", "7");
        this.nativeAd.setAdChoicesPlacement(parameters.getServerParameters().getInt("ad_choices_placement", 0));
        this.nativeAd.setCachePolicy(parameters.getServerParameters().getInt("cache_policy", 0));
        this.updatePrivacyStates((MaxAdapterParameters)parameters);
        String bidResponse = parameters.getBidResponse();
        if (!TextUtils.isEmpty((CharSequence)bidResponse)) {
            this.nativeAd.loadFromBid(bidResponse);
        } else {
            this.nativeAd.load();
        }
    }

    private void updatePrivacyStates(MaxAdapterParameters parameters) {
        Boolean isDoNotSell;
        Boolean hasUserConsent;
        Boolean isAgeRestrictedUser = parameters.isAgeRestrictedUser();
        if (isAgeRestrictedUser != null) {
            MyTargetPrivacy.setUserAgeRestricted((boolean)isAgeRestrictedUser);
        }
        if ((hasUserConsent = parameters.hasUserConsent()) != null) {
            MyTargetPrivacy.setUserConsent((boolean)hasUserConsent);
        }
        if ((isDoNotSell = parameters.isDoNotSell()) != null) {
            MyTargetPrivacy.setCcpaUserConsent((boolean)isDoNotSell);
        }
    }

    private Context getContext(Activity activity) {
        return activity != null ? activity.getApplicationContext() : this.getApplicationContext();
    }

    private static MyTargetView.AdSize getBannerSize(MaxAdFormat maxAdFormat) {
        if (maxAdFormat == MaxAdFormat.BANNER) {
            return MyTargetView.AdSize.ADSIZE_320x50;
        }
        if (maxAdFormat == MaxAdFormat.MREC) {
            return MyTargetView.AdSize.ADSIZE_300x250;
        }
        if (maxAdFormat == MaxAdFormat.LEADER) {
            return MyTargetView.AdSize.ADSIZE_728x90;
        }
        return MyTargetView.AdSize.ADSIZE_320x50;
    }

    private static MaxAdapterError toMaxError(String myTargetError) {
        return new MaxAdapterError(MaxAdapterError.NO_FILL.getErrorCode(), MaxAdapterError.NO_FILL.getErrorMessage(), 0, myTargetError);
    }

    private class MaxMyTargetNativeAd
    extends MaxNativeAd {
        private MaxMyTargetNativeAd(MaxNativeAd.Builder builder) {
            super(builder);
        }

        public void prepareViewForInteraction(MaxNativeAdView maxNativeAdView) {
            ArrayList<View> clickableViews = new ArrayList<View>(6);
            if (AppLovinSdkUtils.isValidString((String)this.getTitle()) && maxNativeAdView.getTitleTextView() != null) {
                clickableViews.add((View)maxNativeAdView.getTitleTextView());
            }
            if (AppLovinSdkUtils.isValidString((String)this.getAdvertiser()) && maxNativeAdView.getAdvertiserTextView() != null) {
                clickableViews.add((View)maxNativeAdView.getAdvertiserTextView());
            }
            if (AppLovinSdkUtils.isValidString((String)this.getBody()) && maxNativeAdView.getBodyTextView() != null) {
                clickableViews.add((View)maxNativeAdView.getBodyTextView());
            }
            if (AppLovinSdkUtils.isValidString((String)this.getCallToAction()) && maxNativeAdView.getCallToActionButton() != null) {
                clickableViews.add((View)maxNativeAdView.getCallToActionButton());
            }
            if (this.getIcon() != null && maxNativeAdView.getIconImageView() != null) {
                clickableViews.add((View)maxNativeAdView.getIconImageView());
            }
            if (this.getMediaView() != null && maxNativeAdView.getMediaContentViewGroup() != null) {
                clickableViews.add((View)maxNativeAdView.getMediaContentViewGroup());
            }
            this.prepareForInteraction(clickableViews, (ViewGroup)maxNativeAdView);
        }

        public boolean prepareForInteraction(List<View> clickableViews, ViewGroup container) {
            NativeAd nativeAd = MyTargetMediationAdapter.this.nativeAd;
            if (nativeAd == null) {
                MyTargetMediationAdapter.this.e("Failed to register native ad views: native ad is null.");
                return false;
            }
            MyTargetMediationAdapter.this.d("Preparing views for interaction: " + clickableViews + " with container: " + container);
            nativeAd.registerView((View)container, clickableViews);
            return true;
        }
    }

    private class NativeAdListener
    implements NativeAd.NativeAdListener,
    NativeAd.NativeAdMediaListener {
        private final String slotId;
        private final Bundle serverParameters;
        private final Context context;
        private final MaxNativeAdAdapterListener listener;

        NativeAdListener(MaxAdapterResponseParameters parameters, Context context, MaxNativeAdAdapterListener listener) {
            this.slotId = parameters.getThirdPartyAdPlacementId();
            this.serverParameters = parameters.getServerParameters();
            this.context = context;
            this.listener = listener;
        }

        public void onLoad(@NonNull NativePromoBanner nativePromoBanner, @NonNull NativeAd nativeAd) {
            MyTargetMediationAdapter.this.log("Native ad loaded: " + this.slotId);
            if (MyTargetMediationAdapter.this.nativeAd != nativeAd) {
                MyTargetMediationAdapter.this.e("Mismatched instance of native ads - adapter: " + MyTargetMediationAdapter.this.nativeAd + " and listener: " + nativeAd);
                this.listener.onNativeAdLoadFailed(MaxAdapterError.INVALID_LOAD_STATE);
                return;
            }
            String templateName = BundleUtils.getString((String)"template", (String)"", (Bundle)this.serverParameters);
            boolean isTemplateAd = AppLovinSdkUtils.isValidString((String)templateName);
            NativePromoBanner nativeBanner = nativeAd.getBanner();
            if (isTemplateAd && TextUtils.isEmpty((CharSequence)nativeBanner.getTitle())) {
                MyTargetMediationAdapter.this.e("Native ad (" + nativeAd + ") does not have required assets.");
                this.listener.onNativeAdLoadFailed(new MaxAdapterError(-5400, "Missing Native Ad Assets"));
                return;
            }
            ImageData icon = nativeBanner.getIcon();
            ImageData mainImageData = nativeBanner.getImage();
            MediaAdView mediaView = NativeViewsFactory.getMediaAdView((Context)this.context);
            MaxNativeAd.MaxNativeAdImage iconImage = null;
            MaxNativeAd.MaxNativeAdImage mainImage = null;
            if (icon != null) {
                iconImage = icon.getBitmap() != null ? new MaxNativeAd.MaxNativeAdImage((Drawable)new BitmapDrawable(this.context.getResources(), icon.getBitmap())) : new MaxNativeAd.MaxNativeAdImage(Uri.parse((String)icon.getUrl()));
            }
            if (mainImageData != null) {
                mainImage = mainImageData.getBitmap() != null ? new MaxNativeAd.MaxNativeAdImage((Drawable)new BitmapDrawable(this.context.getResources(), mainImageData.getBitmap())) : new MaxNativeAd.MaxNativeAdImage(Uri.parse((String)mainImageData.getUrl()));
            }
            MyTargetMediationAdapter.this.nativeAdView = NativeViewsFactory.getNativeAdView((Context)this.context);
            MyTargetMediationAdapter.this.nativeAdView.setupView(nativeAd.getBanner());
            MaxNativeAd.Builder builder = new MaxNativeAd.Builder().setAdFormat(MaxAdFormat.NATIVE).setTitle(nativeBanner.getTitle()).setBody(nativeBanner.getDescription()).setCallToAction(nativeBanner.getCtaText()).setIcon(iconImage).setMediaView((View)mediaView).setAdvertiser(nativeBanner.getAdvertisingLabel());
            if (AppLovinSdk.VERSION_CODE >= 11040399) {
                builder.setMainImage(mainImage);
            }
            if (AppLovinSdk.VERSION_CODE >= 11040000) {
                builder.setMediaContentAspectRatio(mediaView.getMediaAspectRatio());
            }
            MaxMyTargetNativeAd maxNativeAd = new MaxMyTargetNativeAd(builder);
            this.listener.onNativeAdLoaded((MaxNativeAd)maxNativeAd, null);
        }

        public void onNoAd(@NonNull String reason, @NonNull NativeAd nativeAd) {
            MyTargetMediationAdapter.this.log("Native ad (" + this.slotId + ") failed to load with reason: " + reason);
            this.listener.onNativeAdLoadFailed(MyTargetMediationAdapter.toMaxError(reason));
        }

        public void onShow(@NonNull NativeAd nativeAd) {
            MyTargetMediationAdapter.this.log("Native ad shown: " + this.slotId);
            this.listener.onNativeAdDisplayed(null);
        }

        public void onClick(@NonNull NativeAd nativeAd) {
            MyTargetMediationAdapter.this.log("Native ad clicked: " + this.slotId);
            this.listener.onNativeAdClicked();
        }

        public void onVideoPlay(@NonNull NativeAd nativeAd) {
            MyTargetMediationAdapter.this.log("Native ad video started: " + this.slotId);
        }

        public void onVideoPause(@NonNull NativeAd nativeAd) {
            MyTargetMediationAdapter.this.log("Native ad video paused: " + this.slotId);
        }

        public void onVideoComplete(@NonNull NativeAd nativeAd) {
            MyTargetMediationAdapter.this.log("Native ad video completed: " + this.slotId);
        }

        public void onIconLoad(@NonNull NativeAd nativeAd) {
            MyTargetMediationAdapter.this.log("Native ad icon loaded: " + this.slotId);
        }

        public void onImageLoad(@NonNull NativeAd nativeAd) {
            MyTargetMediationAdapter.this.log("Native ad image loaded: " + this.slotId);
        }
    }

    private class AdViewListener
    implements MyTargetView.MyTargetViewListener {
        private final MaxAdViewAdapterListener listener;

        AdViewListener(MaxAdViewAdapterListener listener) {
            this.listener = listener;
        }

        public void onLoad(@NonNull MyTargetView myTargetView) {
            MyTargetMediationAdapter.this.log("Ad view loaded");
            this.listener.onAdViewAdLoaded((View)myTargetView);
        }

        public void onNoAd(@NonNull String reason, @NonNull MyTargetView myTargetView) {
            MyTargetMediationAdapter.this.log("Ad view failed to load with reason: " + reason);
            this.listener.onAdViewAdLoadFailed(MyTargetMediationAdapter.toMaxError(reason));
        }

        public void onShow(@NonNull MyTargetView myTargetView) {
            MyTargetMediationAdapter.this.log("Ad view displayed");
            this.listener.onAdViewAdDisplayed();
        }

        public void onClick(@NonNull MyTargetView myTargetView) {
            MyTargetMediationAdapter.this.log("Ad view clicked");
            this.listener.onAdViewAdClicked();
        }
    }

    private class RewardedAdListener
    implements RewardedAd.RewardedAdListener {
        private final MaxRewardedAdapterListener listener;
        private boolean hasGrantedReward = false;

        RewardedAdListener(MaxRewardedAdapterListener listener) {
            this.listener = listener;
        }

        public void onLoad(@NonNull RewardedAd rewardedAd) {
            MyTargetMediationAdapter.this.log("Rewarded ad loaded");
            this.listener.onRewardedAdLoaded();
        }

        public void onNoAd(@NonNull String reason, @NonNull RewardedAd rewardedAd) {
            MyTargetMediationAdapter.this.log("Rewarded ad failed to load with reason: " + reason);
            this.listener.onRewardedAdLoadFailed(MyTargetMediationAdapter.toMaxError(reason));
        }

        public void onDisplay(@NonNull RewardedAd rewardedAd) {
            MyTargetMediationAdapter.this.log("Rewarded ad displayed");
            this.listener.onRewardedAdDisplayed();
            this.listener.onRewardedAdVideoStarted();
        }

        public void onClick(@NonNull RewardedAd rewardedAd) {
            MyTargetMediationAdapter.this.log("Rewarded ad clicked");
            this.listener.onRewardedAdClicked();
        }

        public void onReward(@NonNull Reward reward, @NonNull RewardedAd rewardedAd) {
            MyTargetMediationAdapter.this.log("Rewarded ad reward granted");
            this.hasGrantedReward = true;
        }

        public void onDismiss(@NonNull RewardedAd rewardedAd) {
            if (this.hasGrantedReward || MyTargetMediationAdapter.this.shouldAlwaysRewardUser()) {
                MaxReward reward = MyTargetMediationAdapter.this.getReward();
                MyTargetMediationAdapter.this.log("Rewarded user with reward: " + reward);
                this.listener.onUserRewarded(reward);
            }
            MyTargetMediationAdapter.this.log("Rewarded ad dismissed");
            this.listener.onRewardedAdHidden();
        }
    }

    private class InterstitialListener
    implements InterstitialAd.InterstitialAdListener {
        private final MaxInterstitialAdapterListener listener;

        InterstitialListener(MaxInterstitialAdapterListener listener) {
            this.listener = listener;
        }

        public void onLoad(@NonNull InterstitialAd interstitialAd) {
            MyTargetMediationAdapter.this.log("Interstitial loaded");
            this.listener.onInterstitialAdLoaded();
        }

        public void onNoAd(@NonNull String reason, @NonNull InterstitialAd interstitialAd) {
            MyTargetMediationAdapter.this.log("Interstitial failed to load with reason: " + reason);
            this.listener.onInterstitialAdLoadFailed(MyTargetMediationAdapter.toMaxError(reason));
        }

        public void onDisplay(@NonNull InterstitialAd interstitialAd) {
            MyTargetMediationAdapter.this.log("Interstitial displayed");
            this.listener.onInterstitialAdDisplayed();
        }

        public void onClick(@NonNull InterstitialAd interstitialAd) {
            MyTargetMediationAdapter.this.log("Interstitial clicked");
            this.listener.onInterstitialAdClicked();
        }

        public void onVideoCompleted(@NonNull InterstitialAd interstitialAd) {
            MyTargetMediationAdapter.this.log("Interstitial video completed");
        }

        public void onDismiss(@NonNull InterstitialAd interstitialAd) {
            MyTargetMediationAdapter.this.log("Interstitial dismissed");
            this.listener.onInterstitialAdHidden();
        }
    }
}

