/*
 * Decompiled with CFR 0.152.
 */
package com.applovin.mediation.adapters;

import android.annotation.SuppressLint;
import android.app.Activity;
import android.content.Context;
import android.os.Bundle;
import android.view.View;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.applovin.impl.sdk.utils.BundleUtils;
import com.applovin.mediation.MaxAdFormat;
import com.applovin.mediation.MaxReward;
import com.applovin.mediation.adapter.MaxAdViewAdapter;
import com.applovin.mediation.adapter.MaxAdapter;
import com.applovin.mediation.adapter.MaxAdapterError;
import com.applovin.mediation.adapter.MaxInterstitialAdapter;
import com.applovin.mediation.adapter.MaxRewardedAdapter;
import com.applovin.mediation.adapter.MaxSignalProvider;
import com.applovin.mediation.adapter.listeners.MaxAdViewAdapterListener;
import com.applovin.mediation.adapter.listeners.MaxInterstitialAdapterListener;
import com.applovin.mediation.adapter.listeners.MaxRewardedAdapterListener;
import com.applovin.mediation.adapter.listeners.MaxSignalCollectionListener;
import com.applovin.mediation.adapter.parameters.MaxAdapterInitializationParameters;
import com.applovin.mediation.adapter.parameters.MaxAdapterParameters;
import com.applovin.mediation.adapter.parameters.MaxAdapterResponseParameters;
import com.applovin.mediation.adapter.parameters.MaxAdapterSignalCollectionParameters;
import com.applovin.mediation.adapters.MediationAdapterBase;
import com.applovin.sdk.AppLovinSdk;
import com.pubmatic.sdk.common.OpenWrapSDK;
import com.pubmatic.sdk.common.OpenWrapSDKConfig;
import com.pubmatic.sdk.common.OpenWrapSDKInitializer;
import com.pubmatic.sdk.common.POBAdFormat;
import com.pubmatic.sdk.common.POBAdSize;
import com.pubmatic.sdk.common.POBError;
import com.pubmatic.sdk.openwrap.banner.POBBannerView;
import com.pubmatic.sdk.openwrap.core.POBReward;
import com.pubmatic.sdk.openwrap.core.signal.POBBiddingHost;
import com.pubmatic.sdk.openwrap.core.signal.POBSignalConfig;
import com.pubmatic.sdk.openwrap.core.signal.POBSignalGenerator;
import com.pubmatic.sdk.openwrap.interstitial.POBInterstitial;
import com.pubmatic.sdk.rewardedad.POBRewardedAd;
import java.util.Collections;
import java.util.concurrent.atomic.AtomicBoolean;

public class PubMaticMediationAdapter
extends MediationAdapterBase
implements MaxSignalProvider,
MaxInterstitialAdapter,
MaxRewardedAdapter,
MaxAdViewAdapter {
    private static final AtomicBoolean initialized = new AtomicBoolean();
    private static MaxAdapter.InitializationStatus status;
    private POBInterstitial interstitialAd;
    private POBRewardedAd rewardedAd;
    private POBBannerView adView;

    public PubMaticMediationAdapter(AppLovinSdk sdk) {
        super(sdk);
    }

    public void initialize(MaxAdapterInitializationParameters parameters, Activity activity, final MaxAdapter.OnCompletionListener onCompletionListener) {
        if (initialized.compareAndSet(false, true)) {
            status = MaxAdapter.InitializationStatus.INITIALIZING;
            String publisherId = PubMaticMediationAdapter.getPublisherId((MaxAdapterParameters)parameters);
            int profileId = PubMaticMediationAdapter.getProfileId((MaxAdapterParameters)parameters);
            this.log("Initializing PubMatic SDK with publisherId: " + publisherId + ", profileId: " + profileId + "...");
            OpenWrapSDKConfig config = new OpenWrapSDKConfig.Builder(publisherId, Collections.singletonList(profileId)).build();
            OpenWrapSDK.initialize((Context)this.getApplicationContext(), (OpenWrapSDKConfig)config, (OpenWrapSDKInitializer.Listener)new OpenWrapSDKInitializer.Listener(){

                public void onSuccess() {
                    PubMaticMediationAdapter.this.log("PubMatic SDK initialized");
                    status = MaxAdapter.InitializationStatus.INITIALIZED_SUCCESS;
                    onCompletionListener.onCompletion(status, null);
                }

                public void onFailure(POBError pobError) {
                    PubMaticMediationAdapter.this.log("PubMatic SDK failed to initialize with error: " + pobError);
                    status = MaxAdapter.InitializationStatus.INITIALIZED_FAILURE;
                    onCompletionListener.onCompletion(status, pobError.getErrorMessage());
                }
            });
        } else {
            this.log("PubMatic SDK already initializing");
            onCompletionListener.onCompletion(status, null);
        }
    }

    public String getSdkVersion() {
        return OpenWrapSDK.getVersion();
    }

    public String getAdapterVersion() {
        return "3.9.0.1";
    }

    public void collectSignal(MaxAdapterSignalCollectionParameters parameters, Activity activity, MaxSignalCollectionListener callback) {
        this.log("Collecting signal...");
        POBAdFormat adFormat = PubMaticMediationAdapter.toPubMaticAdFormat(parameters.getAdFormat());
        if (adFormat == null) {
            callback.onSignalCollectionFailed("Invalid ad format");
            return;
        }
        this.updateAdSettings((MaxAdapterParameters)parameters);
        POBSignalConfig config = new POBSignalConfig.Builder(adFormat).build();
        String bidToken = POBSignalGenerator.generateSignal((Context)this.getApplicationContext(), (POBBiddingHost)POBBiddingHost.ALMAX, (POBSignalConfig)config);
        callback.onSignalCollected(bidToken);
    }

    @Nullable
    public Boolean shouldLoadAdsOnUiThread(MaxAdFormat adFormat) {
        return true;
    }

    @Nullable
    public Boolean shouldShowAdsOnUiThread(MaxAdFormat adFormat) {
        return true;
    }

    public void onDestroy() {
        if (this.interstitialAd != null) {
            this.interstitialAd.destroy();
            this.interstitialAd = null;
        }
        if (this.rewardedAd != null) {
            this.rewardedAd.destroy();
            this.rewardedAd = null;
        }
        if (this.adView != null) {
            this.adView.destroy();
            this.adView = null;
        }
    }

    @SuppressLint(value={"MissingPermission"})
    public void loadInterstitialAd(MaxAdapterResponseParameters parameters, Activity activity, MaxInterstitialAdapterListener listener) {
        String publisherId = PubMaticMediationAdapter.getPublisherId((MaxAdapterParameters)parameters);
        int profileId = PubMaticMediationAdapter.getProfileId((MaxAdapterParameters)parameters);
        String adUnitId = PubMaticMediationAdapter.getAdUnitId(parameters);
        String bidResponse = parameters.getBidResponse();
        this.log("Loading interstitial ad: " + adUnitId + "...");
        this.updateAdSettings((MaxAdapterParameters)parameters);
        this.interstitialAd = new POBInterstitial(this.getApplicationContext(), publisherId, profileId, adUnitId);
        this.interstitialAd.setListener((POBInterstitial.POBInterstitialListener)new InterstitialListener(listener));
        this.interstitialAd.loadAd(bidResponse);
    }

    public void showInterstitialAd(MaxAdapterResponseParameters parameters, Activity activity, MaxInterstitialAdapterListener listener) {
        String adUnitId = PubMaticMediationAdapter.getAdUnitId(parameters);
        this.log("Showing interstitial ad: " + adUnitId + "...");
        if (this.interstitialAd == null) {
            this.log("Interstitial ad failed to load - ad not ready");
            listener.onInterstitialAdDisplayFailed(new MaxAdapterError(MaxAdapterError.AD_DISPLAY_FAILED, 0, "Interstitial ad not ready"));
            return;
        }
        this.interstitialAd.show();
    }

    public void loadRewardedAd(MaxAdapterResponseParameters parameters, Activity activity, MaxRewardedAdapterListener listener) {
        String publisherId = PubMaticMediationAdapter.getPublisherId((MaxAdapterParameters)parameters);
        int profileId = PubMaticMediationAdapter.getProfileId((MaxAdapterParameters)parameters);
        String adUnitId = PubMaticMediationAdapter.getAdUnitId(parameters);
        String bidResponse = parameters.getBidResponse();
        this.log("Loading rewarded ad: " + adUnitId + "...");
        this.updateAdSettings((MaxAdapterParameters)parameters);
        this.rewardedAd = POBRewardedAd.getRewardedAd((Context)this.getApplicationContext(), (String)publisherId, (int)profileId, (String)adUnitId);
        this.rewardedAd.setListener((POBRewardedAd.POBRewardedAdListener)new RewardedListener(listener));
        this.rewardedAd.loadAd(bidResponse);
    }

    public void showRewardedAd(MaxAdapterResponseParameters parameters, Activity activity, MaxRewardedAdapterListener listener) {
        String adUnitId = PubMaticMediationAdapter.getAdUnitId(parameters);
        this.log("Showing rewarded ad: " + adUnitId + "...");
        if (this.rewardedAd == null) {
            this.log("Rewarded ad failed to load - ad not ready");
            listener.onRewardedAdDisplayFailed(new MaxAdapterError(MaxAdapterError.AD_DISPLAY_FAILED, 0, "Rewarded ad not ready"));
            return;
        }
        this.configureReward(parameters);
        this.rewardedAd.show();
    }

    @SuppressLint(value={"MissingPermission"})
    public void loadAdViewAd(MaxAdapterResponseParameters parameters, MaxAdFormat adFormat, Activity activity, MaxAdViewAdapterListener listener) {
        String publisherId = PubMaticMediationAdapter.getPublisherId((MaxAdapterParameters)parameters);
        int profileId = PubMaticMediationAdapter.getProfileId((MaxAdapterParameters)parameters);
        String adUnitId = PubMaticMediationAdapter.getAdUnitId(parameters);
        POBAdSize adSize = PubMaticMediationAdapter.toPubMaticAdSize(adFormat);
        String bidResponse = parameters.getBidResponse();
        this.log("Loading " + adFormat.getLabel() + " ad: " + adUnitId + "...");
        this.updateAdSettings((MaxAdapterParameters)parameters);
        this.adView = new POBBannerView(this.getApplicationContext(), publisherId, profileId, adUnitId, new POBAdSize[]{adSize});
        this.adView.setListener((POBBannerView.POBBannerViewListener)new AdViewListener(listener));
        this.adView.loadAd(bidResponse);
        this.adView.pauseAutoRefresh();
    }

    private void updateAdSettings(MaxAdapterParameters parameters) {
        Boolean isAgeRestrictedUser = parameters.isAgeRestrictedUser();
        if (isAgeRestrictedUser != null) {
            OpenWrapSDK.setCoppa((boolean)isAgeRestrictedUser);
        }
    }

    private static String getPublisherId(MaxAdapterParameters parameters) {
        return BundleUtils.getString((String)"publisher_id", (Bundle)parameters.getServerParameters());
    }

    private static int getProfileId(MaxAdapterParameters parameters) {
        return BundleUtils.getInt((String)"profile_id", (Bundle)parameters.getServerParameters());
    }

    private static String getAdUnitId(MaxAdapterResponseParameters parameters) {
        return parameters.getThirdPartyAdPlacementId();
    }

    private static POBAdSize toPubMaticAdSize(MaxAdFormat maxAdFormat) {
        if (maxAdFormat == MaxAdFormat.BANNER) {
            return POBAdSize.BANNER_SIZE_320x50;
        }
        if (maxAdFormat == MaxAdFormat.LEADER) {
            return POBAdSize.BANNER_SIZE_728x90;
        }
        if (maxAdFormat == MaxAdFormat.MREC) {
            return POBAdSize.BANNER_SIZE_300x250;
        }
        throw new IllegalArgumentException("Invalid ad format: " + maxAdFormat);
    }

    @Nullable
    private static POBAdFormat toPubMaticAdFormat(MaxAdFormat maxAdFormat) {
        if (maxAdFormat == MaxAdFormat.BANNER) {
            return POBAdFormat.BANNER;
        }
        if (maxAdFormat == MaxAdFormat.LEADER) {
            return POBAdFormat.BANNER;
        }
        if (maxAdFormat == MaxAdFormat.MREC) {
            return POBAdFormat.MREC;
        }
        if (maxAdFormat == MaxAdFormat.INTERSTITIAL) {
            return POBAdFormat.INTERSTITIAL;
        }
        if (maxAdFormat == MaxAdFormat.REWARDED) {
            return POBAdFormat.REWARDEDAD;
        }
        return null;
    }

    private static MaxAdapterError toMaxError(POBError error) {
        MaxAdapterError adapterError = MaxAdapterError.UNSPECIFIED;
        switch (error.getErrorCode()) {
            case 1001: 
            case 1012: {
                adapterError = MaxAdapterError.BAD_REQUEST;
                break;
            }
            case 1002: {
                adapterError = MaxAdapterError.NO_FILL;
                break;
            }
            case 1003: {
                adapterError = MaxAdapterError.NO_CONNECTION;
                break;
            }
            case 1004: {
                adapterError = MaxAdapterError.SERVER_ERROR;
                break;
            }
            case 1005: {
                adapterError = MaxAdapterError.TIMEOUT;
                break;
            }
            case 1006: 
            case 1007: 
            case 1008: 
            case 1010: 
            case 2001: 
            case 3001: {
                adapterError = MaxAdapterError.INTERNAL_ERROR;
                break;
            }
            case 1009: {
                adapterError = MaxAdapterError.WEBVIEW_ERROR;
                break;
            }
            case 1011: {
                adapterError = MaxAdapterError.AD_EXPIRED;
                break;
            }
            case 2002: {
                adapterError = MaxAdapterError.AD_NOT_READY;
                break;
            }
            case 1013: 
            case 5001: 
            case 5002: {
                adapterError = MaxAdapterError.INVALID_CONFIGURATION;
            }
        }
        return new MaxAdapterError(adapterError, error.getErrorCode(), error.getErrorMessage());
    }

    private class InterstitialListener
    extends POBInterstitial.POBInterstitialListener {
        private final MaxInterstitialAdapterListener listener;

        public InterstitialListener(MaxInterstitialAdapterListener listener) {
            this.listener = listener;
        }

        public void onAdReceived(POBInterstitial ad) {
            PubMaticMediationAdapter.this.log("Interstitial received");
            this.listener.onInterstitialAdLoaded();
        }

        public void onAdFailedToLoad(POBInterstitial ad, POBError error) {
            MaxAdapterError adapterError = PubMaticMediationAdapter.toMaxError(error);
            PubMaticMediationAdapter.this.log("Interstitial failed to load with error: " + adapterError);
            this.listener.onInterstitialAdLoadFailed(adapterError);
        }

        public void onAdImpression(POBInterstitial ad) {
            PubMaticMediationAdapter.this.log("Interstitial impression");
            this.listener.onInterstitialAdDisplayed();
        }

        public void onAdFailedToShow(POBInterstitial ad, POBError error) {
            MaxAdapterError adapterError = PubMaticMediationAdapter.toMaxError(error);
            PubMaticMediationAdapter.this.log("Interstitial failed to show with error: " + adapterError);
            this.listener.onInterstitialAdDisplayFailed(adapterError);
        }

        public void onAdClicked(POBInterstitial ad) {
            PubMaticMediationAdapter.this.log("Interstitial clicked");
            this.listener.onInterstitialAdClicked();
        }

        public void onAdClosed(POBInterstitial ad) {
            PubMaticMediationAdapter.this.log("Interstitial closed");
            this.listener.onInterstitialAdHidden();
        }
    }

    private class RewardedListener
    extends POBRewardedAd.POBRewardedAdListener {
        private final MaxRewardedAdapterListener listener;
        private boolean hasGrantedReward = false;

        public RewardedListener(MaxRewardedAdapterListener listener) {
            this.listener = listener;
        }

        public void onAdReceived(POBRewardedAd ad) {
            PubMaticMediationAdapter.this.log("Rewarded ad received");
            this.listener.onRewardedAdLoaded();
        }

        public void onAdFailedToLoad(POBRewardedAd ad, POBError error) {
            MaxAdapterError adapterError = PubMaticMediationAdapter.toMaxError(error);
            PubMaticMediationAdapter.this.log("Rewarded ad failed to load with error: " + adapterError);
            this.listener.onRewardedAdLoadFailed(adapterError);
        }

        public void onAdImpression(POBRewardedAd ad) {
            PubMaticMediationAdapter.this.log("Rewarded ad impression");
            this.listener.onRewardedAdDisplayed();
        }

        public void onAdFailedToShow(POBRewardedAd ad, POBError error) {
            MaxAdapterError adapterError = PubMaticMediationAdapter.toMaxError(error);
            PubMaticMediationAdapter.this.log("Rewarded ad failed to show with error: " + adapterError);
            this.listener.onRewardedAdDisplayFailed(adapterError);
        }

        public void onAdClicked(POBRewardedAd ad) {
            PubMaticMediationAdapter.this.log("Rewarded ad clicked");
            this.listener.onRewardedAdClicked();
        }

        public void onReceiveReward(@NonNull POBRewardedAd rewardedAd, @NonNull POBReward reward) {
            PubMaticMediationAdapter.this.log("Rewarded ad reward granted");
            this.hasGrantedReward = true;
        }

        public void onAdClosed(POBRewardedAd ad) {
            if (this.hasGrantedReward || PubMaticMediationAdapter.this.shouldAlwaysRewardUser()) {
                MaxReward reward = PubMaticMediationAdapter.this.getReward();
                PubMaticMediationAdapter.this.log("Rewarded user with reward: " + reward);
                this.listener.onUserRewarded(reward);
            }
            PubMaticMediationAdapter.this.log("Rewarded ad closed");
            this.listener.onRewardedAdHidden();
        }
    }

    private class AdViewListener
    extends POBBannerView.POBBannerViewListener {
        private final MaxAdViewAdapterListener listener;

        public AdViewListener(MaxAdViewAdapterListener listener) {
            this.listener = listener;
        }

        public void onAdReceived(POBBannerView view) {
            PubMaticMediationAdapter.this.log("Ad view received");
            this.listener.onAdViewAdLoaded((View)view);
        }

        public void onAdFailed(POBBannerView view, POBError error) {
            MaxAdapterError adapterError = PubMaticMediationAdapter.toMaxError(error);
            PubMaticMediationAdapter.this.log("Ad view failed to load with error: " + adapterError);
            this.listener.onAdViewAdLoadFailed(adapterError);
        }

        public void onAdImpression(POBBannerView view) {
            PubMaticMediationAdapter.this.log("Ad view impression");
            this.listener.onAdViewAdDisplayed();
        }

        public void onAdClicked(POBBannerView view) {
            PubMaticMediationAdapter.this.log("Ad view clicked");
            this.listener.onAdViewAdClicked();
        }
    }
}

