/*
 * Decompiled with CFR 0.152.
 */
package com.applovin.mediation.adapters;

import android.app.Activity;
import android.content.Context;
import android.view.View;
import com.applovin.mediation.MaxAdFormat;
import com.applovin.mediation.adapter.MaxAdViewAdapter;
import com.applovin.mediation.adapter.MaxAdapter;
import com.applovin.mediation.adapter.MaxAdapterError;
import com.applovin.mediation.adapter.MaxInterstitialAdapter;
import com.applovin.mediation.adapter.MaxRewardedAdapter;
import com.applovin.mediation.adapter.MaxSignalProvider;
import com.applovin.mediation.adapter.listeners.MaxAdViewAdapterListener;
import com.applovin.mediation.adapter.listeners.MaxInterstitialAdapterListener;
import com.applovin.mediation.adapter.listeners.MaxRewardedAdapterListener;
import com.applovin.mediation.adapter.listeners.MaxSignalCollectionListener;
import com.applovin.mediation.adapter.parameters.MaxAdapterInitializationParameters;
import com.applovin.mediation.adapter.parameters.MaxAdapterParameters;
import com.applovin.mediation.adapter.parameters.MaxAdapterResponseParameters;
import com.applovin.mediation.adapter.parameters.MaxAdapterSignalCollectionParameters;
import com.applovin.mediation.adapters.MediationAdapterBase;
import com.applovin.mediation.adapters.MediationAdapterRouter;
import com.applovin.sdk.AppLovinSdk;
import com.applovin.sdk.AppLovinSdkConfiguration;
import com.applovin.sdk.AppLovinSdkUtils;
import com.unity3d.ads.IUnityAdsInitializationListener;
import com.unity3d.ads.IUnityAdsListener;
import com.unity3d.ads.IUnityAdsLoadListener;
import com.unity3d.ads.UnityAds;
import com.unity3d.ads.UnityAdsLoadOptions;
import com.unity3d.ads.UnityAdsShowOptions;
import com.unity3d.ads.mediation.IUnityAdsExtendedListener;
import com.unity3d.ads.metadata.MediationMetaData;
import com.unity3d.ads.metadata.MetaData;
import com.unity3d.services.banners.BannerErrorCode;
import com.unity3d.services.banners.BannerErrorInfo;
import com.unity3d.services.banners.BannerView;
import com.unity3d.services.banners.UnityBannerSize;
import java.lang.reflect.Method;
import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicBoolean;

public class UnityAdsMediationAdapter
extends MediationAdapterBase
implements MaxSignalProvider,
MaxInterstitialAdapter,
MaxRewardedAdapter,
MaxAdViewAdapter {
    private static final String KEY_GAME_ID = "game_id";
    private static final String KEY_SET_MEDIATION_IDENTIFIER = "set_mediation_identifier";
    private static final UnityAdsMediationAdapterRouter ROUTER;
    private static final AtomicBoolean INITIALIZED;
    private static final Set<String> DISPLAYED_PLACEMENTS;
    private static MaxAdapter.InitializationStatus initializationStatus;
    private String placementId;
    private String biddingAdId;
    private BannerView bannerView;

    public UnityAdsMediationAdapter(AppLovinSdk sdk) {
        super(sdk);
    }

    public void initialize(MaxAdapterInitializationParameters parameters, Activity activity, final MaxAdapter.OnCompletionListener onCompletionListener) {
        this.updatePrivacyConsent((MaxAdapterParameters)parameters, activity.getApplicationContext());
        if (INITIALIZED.compareAndSet(false, true)) {
            String gameId = parameters.getServerParameters().getString(KEY_GAME_ID, null);
            this.log("Initializing UnityAds SDK with game id: " + gameId + "...");
            initializationStatus = MaxAdapter.InitializationStatus.INITIALIZING;
            if (parameters.getServerParameters().getBoolean(KEY_SET_MEDIATION_IDENTIFIER)) {
                MediationMetaData mediationMetaData = new MediationMetaData((Context)activity);
                mediationMetaData.setName(UnityAdsMediationAdapter.mediationTag());
                mediationMetaData.setVersion(AppLovinSdk.VERSION);
                mediationMetaData.commit();
            }
            UnityAds.setDebugMode((boolean)parameters.isTesting());
            UnityAds.addListener((IUnityAdsListener)ROUTER);
            UnityAds.initialize((Context)activity.getApplicationContext(), (String)gameId, (boolean)parameters.isTesting(), (boolean)true, (IUnityAdsInitializationListener)new IUnityAdsInitializationListener(){

                public void onInitializationComplete() {
                    UnityAdsMediationAdapter.this.log("UnityAds SDK initialized");
                    initializationStatus = MaxAdapter.InitializationStatus.INITIALIZED_SUCCESS;
                    onCompletionListener.onCompletion(MaxAdapter.InitializationStatus.INITIALIZED_SUCCESS, null);
                }

                public void onInitializationFailed(UnityAds.UnityAdsInitializationError error, String message) {
                    UnityAdsMediationAdapter.this.log("UnityAds SDK failed to initialize with error: " + message);
                    initializationStatus = MaxAdapter.InitializationStatus.INITIALIZED_FAILURE;
                    onCompletionListener.onCompletion(MaxAdapter.InitializationStatus.INITIALIZED_FAILURE, message);
                }
            });
        } else {
            this.log("UnityAds SDK already initialized");
            onCompletionListener.onCompletion(initializationStatus, null);
        }
    }

    public String getSdkVersion() {
        return UnityAds.getVersion();
    }

    public String getAdapterVersion() {
        return "3.6.0.1";
    }

    public void onDestroy() {
        ROUTER.removeAdapter((MaxAdapter)this, this.placementId);
        if (this.bannerView != null) {
            this.bannerView.destroy();
            this.bannerView = null;
        }
    }

    public void collectSignal(MaxAdapterSignalCollectionParameters parameters, Activity activity, MaxSignalCollectionListener callback) {
        this.log("Collecting signal...");
        String signal = UnityAds.getToken();
        callback.onSignalCollected(signal);
    }

    public void loadInterstitialAd(MaxAdapterResponseParameters parameters, Activity activity, final MaxInterstitialAdapterListener listener) {
        this.placementId = parameters.getThirdPartyAdPlacementId();
        this.log("Loading " + (AppLovinSdkUtils.isValidString((String)parameters.getBidResponse()) ? "bidding " : "") + "interstitial ad for placement \"" + this.placementId + "\"...");
        this.updatePrivacyConsent((MaxAdapterParameters)parameters, activity.getApplicationContext());
        ROUTER.addInterstitialAdapter((MaxAdapter)this, listener, this.placementId);
        if (AppLovinSdkUtils.isValidString((String)parameters.getBidResponse())) {
            this.biddingAdId = UUID.randomUUID().toString();
        }
        UnityAds.load((String)this.placementId, (UnityAdsLoadOptions)this.createAdLoadOptions(parameters), (IUnityAdsLoadListener)new IUnityAdsLoadListener(){

            public void onUnityAdsAdLoaded(String placementId) {
                UnityAdsMediationAdapter.this.log("Interstitial placement \"" + placementId + "\" loaded");
                listener.onInterstitialAdLoaded();
            }

            public void onUnityAdsFailedToLoad(String placementId) {
                MaxAdapterError loadError = UnityAdsMediationAdapter.this.getLoadError(placementId);
                UnityAdsMediationAdapter.this.log("Interstitial placement \"" + placementId + "\" failed to load with error: " + loadError);
                listener.onInterstitialAdLoadFailed(loadError);
            }
        });
    }

    public void showInterstitialAd(MaxAdapterResponseParameters parameters, Activity activity, MaxInterstitialAdapterListener listener) {
        this.log("Showing interstitial ad for placement \"" + this.placementId + "\"...");
        ROUTER.addShowingAdapter((MaxAdapter)this);
        if (UnityAds.isReady((String)this.placementId)) {
            UnityAds.show((Activity)activity, (String)this.placementId, (UnityAdsShowOptions)this.createAdShowOptions());
        } else {
            this.log("Interstitial ad not ready");
            ROUTER.onAdDisplayFailed(this.placementId, MaxAdapterError.AD_NOT_READY);
        }
    }

    public void loadRewardedAd(MaxAdapterResponseParameters parameters, Activity activity, final MaxRewardedAdapterListener listener) {
        this.placementId = parameters.getThirdPartyAdPlacementId();
        this.log("Loading " + (AppLovinSdkUtils.isValidString((String)parameters.getBidResponse()) ? "bidding " : "") + "rewarded ad for placement \"" + this.placementId + "\"...");
        this.updatePrivacyConsent((MaxAdapterParameters)parameters, activity.getApplicationContext());
        ROUTER.addRewardedAdapter((MaxAdapter)this, listener, this.placementId);
        if (AppLovinSdkUtils.isValidString((String)parameters.getBidResponse())) {
            this.biddingAdId = UUID.randomUUID().toString();
        }
        UnityAds.load((String)this.placementId, (UnityAdsLoadOptions)this.createAdLoadOptions(parameters), (IUnityAdsLoadListener)new IUnityAdsLoadListener(){

            public void onUnityAdsAdLoaded(String placementId) {
                UnityAdsMediationAdapter.this.log("Rewarded ad placement \"" + placementId + "\" loaded");
                listener.onRewardedAdLoaded();
            }

            public void onUnityAdsFailedToLoad(String placementId) {
                MaxAdapterError loadError = UnityAdsMediationAdapter.this.getLoadError(placementId);
                UnityAdsMediationAdapter.this.log("Rewarded ad placement \"" + placementId + "\" failed to load with error: " + loadError);
                listener.onRewardedAdLoadFailed(loadError);
            }
        });
    }

    public void showRewardedAd(MaxAdapterResponseParameters parameters, Activity activity, MaxRewardedAdapterListener listener) {
        this.log("Showing rewarded ad for placement \"" + this.placementId + "\"...");
        ROUTER.addShowingAdapter((MaxAdapter)this);
        if (UnityAds.isReady((String)this.placementId)) {
            this.configureReward(parameters);
            UnityAds.show((Activity)activity, (String)this.placementId, (UnityAdsShowOptions)this.createAdShowOptions());
        } else {
            this.log("Rewarded ad not ready");
            ROUTER.onAdDisplayFailed(this.placementId, MaxAdapterError.AD_NOT_READY);
        }
    }

    public void loadAdViewAd(MaxAdapterResponseParameters parameters, MaxAdFormat adFormat, Activity activity, final MaxAdViewAdapterListener listener) {
        String placementId = parameters.getThirdPartyAdPlacementId();
        this.log("Loading banner ad for placement \"" + placementId + "\"...");
        this.updatePrivacyConsent((MaxAdapterParameters)parameters, activity.getApplicationContext());
        this.bannerView = new BannerView(activity, placementId, this.toUnityBannerSize(adFormat));
        this.bannerView.setListener(new BannerView.IListener(){

            public void onBannerLoaded(BannerView bannerAdView) {
                UnityAdsMediationAdapter.this.log("Banner ad loaded");
                listener.onAdViewAdLoaded((View)bannerAdView);
            }

            public void onBannerFailedToLoad(BannerView bannerAdView, BannerErrorInfo errorInfo) {
                UnityAdsMediationAdapter.this.log("Banner ad failed to load");
                listener.onAdViewAdLoadFailed(UnityAdsMediationAdapter.toMaxError(errorInfo));
            }

            public void onBannerClick(BannerView bannerAdView) {
                UnityAdsMediationAdapter.this.log("Banner ad clicked");
                listener.onAdViewAdClicked();
            }

            public void onBannerLeftApplication(BannerView bannerView) {
                UnityAdsMediationAdapter.this.log("Banner ad left application");
            }
        });
        this.bannerView.load();
    }

    private UnityAdsLoadOptions createAdLoadOptions(MaxAdapterResponseParameters parameters) {
        UnityAdsLoadOptions options = new UnityAdsLoadOptions();
        String bidResponse = parameters.getBidResponse();
        if (AppLovinSdkUtils.isValidString((String)bidResponse) && AppLovinSdkUtils.isValidString((String)this.biddingAdId)) {
            options.setObjectId(this.biddingAdId);
            options.setAdMarkup(bidResponse);
        }
        return options;
    }

    private UnityAdsShowOptions createAdShowOptions() {
        UnityAdsShowOptions options = new UnityAdsShowOptions();
        if (AppLovinSdkUtils.isValidString((String)this.biddingAdId)) {
            options.setObjectId(this.biddingAdId);
        }
        return options;
    }

    private UnityBannerSize toUnityBannerSize(MaxAdFormat adFormat) {
        if (adFormat == MaxAdFormat.BANNER) {
            return new UnityBannerSize(320, 50);
        }
        if (adFormat == MaxAdFormat.LEADER) {
            return new UnityBannerSize(728, 90);
        }
        throw new IllegalArgumentException("Unsupported ad format: " + adFormat);
    }

    private MaxAdapterError getLoadError(String placementId) {
        UnityAds.PlacementState placementState = UnityAds.getPlacementState((String)placementId);
        if (placementState == UnityAds.PlacementState.NOT_AVAILABLE) {
            return new MaxAdapterError(-5202, "Invalid configuration", placementState.ordinal(), placementState.toString());
        }
        if (placementState == UnityAds.PlacementState.DISABLED) {
            return new MaxAdapterError(-5202, "Invalid configuration", placementState.ordinal(), placementState.toString());
        }
        if (placementState == UnityAds.PlacementState.NO_FILL) {
            return new MaxAdapterError(204, "No fill", placementState.ordinal(), placementState.toString());
        }
        if (placementState == UnityAds.PlacementState.WAITING) {
            return new MaxAdapterError(-5205, "Ad not ready", placementState.ordinal(), placementState.toString());
        }
        return MaxAdapterError.UNSPECIFIED;
    }

    private static MaxAdapterError toMaxError(BannerErrorInfo unityAdsBannerError) {
        MaxAdapterError adapterError = unityAdsBannerError.errorCode == BannerErrorCode.NO_FILL ? MaxAdapterError.NO_FILL : (unityAdsBannerError.errorCode == BannerErrorCode.NATIVE_ERROR ? MaxAdapterError.INTERNAL_ERROR : (unityAdsBannerError.errorCode == BannerErrorCode.WEBVIEW_ERROR ? MaxAdapterError.WEBVIEW_ERROR : MaxAdapterError.UNSPECIFIED));
        return new MaxAdapterError(adapterError.getErrorCode(), adapterError.getErrorMessage(), unityAdsBannerError.errorCode.ordinal(), unityAdsBannerError.errorMessage);
    }

    void updatePrivacyConsent(MaxAdapterParameters parameters, Context context) {
        Boolean isDoNotSell;
        Boolean hasUserConsent;
        MetaData privacyMetaData = new MetaData(context);
        if (this.getWrappingSdk().getConfiguration().getConsentDialogState() == AppLovinSdkConfiguration.ConsentDialogState.APPLIES && (hasUserConsent = this.getPrivacySetting("hasUserConsent", parameters)) != null) {
            privacyMetaData.set("gdpr.consent", (Object)hasUserConsent);
        }
        if (AppLovinSdk.VERSION_CODE >= 91100 && (isDoNotSell = this.getPrivacySetting("isDoNotSell", parameters)) != null) {
            privacyMetaData.set("privacy.consent", (Object)(isDoNotSell == false ? 1 : 0));
        }
        privacyMetaData.commit();
    }

    private Boolean getPrivacySetting(String privacySetting, MaxAdapterParameters parameters) {
        try {
            Class<?> parametersClass = parameters.getClass();
            Method privacyMethod = parametersClass.getMethod(privacySetting, new Class[0]);
            return (Boolean)privacyMethod.invoke((Object)parameters, new Object[0]);
        }
        catch (Exception exception) {
            this.log("Error getting privacy setting " + privacySetting + " with exception: ", exception);
            return AppLovinSdk.VERSION_CODE >= 9140000 ? null : Boolean.valueOf(false);
        }
    }

    static {
        INITIALIZED = new AtomicBoolean();
        DISPLAYED_PLACEMENTS = new HashSet<String>();
        ROUTER = AppLovinSdk.VERSION_CODE >= 90802 ? (UnityAdsMediationAdapterRouter)MediationAdapterRouter.getSharedInstance(UnityAdsMediationAdapterRouter.class) : new UnityAdsMediationAdapterRouter();
    }

    private static class UnityAdsMediationAdapterRouter
    extends MediationAdapterRouter
    implements IUnityAdsListener,
    IUnityAdsExtendedListener {
        private UnityAdsMediationAdapterRouter() {
        }

        void initialize(MaxAdapterInitializationParameters parameters, Activity activity, MaxAdapter.OnCompletionListener onCompletionListener) {
        }

        public void onUnityAdsReady(String placementId) {
        }

        public void onUnityAdsStart(String placementId) {
            this.onAdDisplayed(placementId);
            this.onRewardedAdVideoStarted(placementId);
            DISPLAYED_PLACEMENTS.add(placementId);
        }

        public void onUnityAdsFinish(String placementId, UnityAds.FinishState result) {
            if (result == UnityAds.FinishState.COMPLETED) {
                this.onRewardedAdVideoCompleted(placementId);
                this.onUserRewarded(placementId, this.getReward(placementId));
                this.onAdHidden(placementId);
            } else if (result == UnityAds.FinishState.SKIPPED) {
                this.onRewardedAdVideoCompleted(placementId);
                if (this.shouldAlwaysRewardUser(placementId)) {
                    this.onUserRewarded(placementId, this.getReward(placementId));
                }
                this.onAdHidden(placementId);
            } else if (result == UnityAds.FinishState.ERROR) {
                this.log("UnityAds failed to finish ad for placement " + placementId);
                this.onAdDisplayFailed(placementId, MaxAdapterError.INTERNAL_ERROR);
                if (DISPLAYED_PLACEMENTS.contains(placementId)) {
                    this.onRewardedAdVideoCompleted(placementId);
                    if (this.shouldAlwaysRewardUser(placementId)) {
                        this.onUserRewarded(placementId, this.getReward(placementId));
                    }
                    this.onAdHidden(placementId);
                }
            }
            DISPLAYED_PLACEMENTS.remove(placementId);
        }

        public void onUnityAdsError(UnityAds.UnityAdsError error, String message) {
            String adapterError = error != null ? error.name() : "UNKNOWN";
            this.log("UnityAds did error " + error.name() + " with message: " + message);
        }

        public void onUnityAdsClick(String placementId) {
            this.onAdClicked(placementId);
        }

        public void onUnityAdsPlacementStateChanged(String placementId, UnityAds.PlacementState oldState, UnityAds.PlacementState newState) {
            if (newState == UnityAds.PlacementState.READY) {
                this.log("Placement \"" + placementId + "\" is ready");
                this.onAdLoaded(placementId);
            } else if (newState == UnityAds.PlacementState.WAITING) {
                this.log("Placement \"" + placementId + "\" is loading...");
            } else if (newState == UnityAds.PlacementState.NOT_AVAILABLE) {
                this.log("Placement \"" + placementId + "\" is not available");
                MaxAdapterError error = new MaxAdapterError(-5202, "Invalid Configuration", newState.ordinal(), newState.toString());
                this.onAdLoadFailed(placementId, error);
            } else if (newState == UnityAds.PlacementState.DISABLED) {
                this.log("Placement \"" + placementId + "\" is disabled - please check your Unity admin tools.");
                MaxAdapterError error = new MaxAdapterError(-5202, "Invalid Configuration", newState.ordinal(), newState.toString());
                this.onAdLoadFailed(placementId, error);
            } else if (newState == UnityAds.PlacementState.NO_FILL) {
                this.log("Placement \"" + placementId + "\" NO FILL'd");
                this.onAdLoadFailed(placementId, MaxAdapterError.NO_FILL);
            }
        }
    }
}

