/*
 * Decompiled with CFR 0.152.
 */
package com.appsflyer.internal;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.appsflyer.AFLogger;
import com.appsflyer.internal.AFb1kSDK;
import com.appsflyer.internal.AFd1sSDK;
import java.nio.charset.Charset;
import java.security.GeneralSecurityException;
import java.security.InvalidKeyException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Locale;
import java.util.Map;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import org.json.JSONObject;

public final class AFb1lSDK {
    public static String AFKeystoreWrapper(String string) {
        String string2 = null;
        try {
            MessageDigest messageDigest = MessageDigest.getInstance("SHA-256");
            messageDigest.update(string.getBytes(Charset.defaultCharset()));
            string2 = AFb1lSDK.AFInAppEventParameterName(messageDigest.digest());
        }
        catch (Exception exception) {
            AFLogger.afErrorLog("Error turning data to SHA-256 string", exception);
        }
        return string2;
    }

    private static String AFInAppEventParameterName(byte[] byArray) {
        StringBuilder stringBuilder = new StringBuilder();
        for (byte by : byArray) {
            stringBuilder.append(Integer.toString((by & 0xFF) + 256, 16).substring(1));
        }
        return ((Object)stringBuilder).toString();
    }

    @Nullable
    public static byte[] values(@NonNull String string) {
        try {
            MessageDigest messageDigest = MessageDigest.getInstance("SHA-256");
            messageDigest.update(string.getBytes(Charset.defaultCharset()));
            return messageDigest.digest();
        }
        catch (Exception exception) {
            AFLogger.afErrorLog("Error turning string to SHA-256 byte array", exception);
            return null;
        }
    }

    public static String AFKeystoreWrapper(String string, String string2) {
        try {
            Mac mac = Mac.getInstance("HmacSHA256");
            mac.init(new SecretKeySpec(string2.getBytes(Charset.defaultCharset()), "HmacSHA256"));
            return AFb1lSDK.AFInAppEventParameterName(mac.doFinal(string.getBytes(Charset.defaultCharset()))).toLowerCase(Locale.getDefault());
        }
        catch (InvalidKeyException | NoSuchAlgorithmException generalSecurityException) {
            GeneralSecurityException generalSecurityException2 = generalSecurityException;
            AFLogger.afErrorLog(generalSecurityException.getMessage(), generalSecurityException2, true);
            return generalSecurityException2.getMessage();
        }
    }

    /*
     * WARNING - void declaration
     */
    public static boolean AFInAppEventParameterName(Map<String, Object> object, String[] object2, AFd1sSDK aFd1sSDK) throws IllegalStateException {
        void var2_3;
        Object object32;
        if (object == null || object.isEmpty()) {
            return false;
        }
        for (Object object32 : object2) {
            if (object.containsKey(object32)) continue;
            return false;
        }
        String string = (String)object.remove("sig");
        if (string == null) {
            return false;
        }
        String string2 = AFd1sSDK.registerClient();
        String string3 = new JSONObject((Map)object) + string2;
        object = var2_3;
        object32 = AFb1kSDK.valueOf(((AFd1sSDK)object).valueOf, ((AFd1sSDK)object).AFKeystoreWrapper);
        return AFb1lSDK.AFKeystoreWrapper(string3, (String)object32).equals(string);
    }
}

