/*
 * Decompiled with CFR 0.152.
 */
package com.blacksquircle.ui.language.base.span;

import android.text.TextPaint;
import android.text.style.CharacterStyle;
import com.blacksquircle.ui.language.base.span.StyleSpan;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000f\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u000f\n\u0002\u0010\u000b\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\b\u0018\u00002\u00020\u00012\b\u0012\u0004\u0012\u00020\u00000\u0002B\u001d\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\bJ\u0011\u0010\u000f\u001a\u00020\u00062\u0006\u0010\u0010\u001a\u00020\u0000H\u0096\u0002J\t\u0010\u0011\u001a\u00020\u0004H\u00c2\u0003J\t\u0010\u0012\u001a\u00020\u0006H\u00c6\u0003J\t\u0010\u0013\u001a\u00020\u0006H\u00c6\u0003J'\u0010\u0014\u001a\u00020\u00002\b\b\u0002\u0010\u0003\u001a\u00020\u00042\b\b\u0002\u0010\u0005\u001a\u00020\u00062\b\b\u0002\u0010\u0007\u001a\u00020\u0006H\u00c6\u0001J\u0013\u0010\u0015\u001a\u00020\u00162\b\u0010\u0010\u001a\u0004\u0018\u00010\u0017H\u00d6\u0003J\t\u0010\u0018\u001a\u00020\u0006H\u00d6\u0001J\t\u0010\u0019\u001a\u00020\u001aH\u00d6\u0001J\u0012\u0010\u001b\u001a\u00020\u001c2\b\u0010\u001d\u001a\u0004\u0018\u00010\u001eH\u0016R\u001a\u0010\u0007\u001a\u00020\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\t\u0010\n\"\u0004\b\u000b\u0010\fR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0005\u001a\u00020\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\n\"\u0004\b\u000e\u0010\f\u00a8\u0006\u001f"}, d2={"Lcom/blacksquircle/ui/language/base/span/SyntaxHighlightSpan;", "Landroid/text/style/CharacterStyle;", "", "span", "Lcom/blacksquircle/ui/language/base/span/StyleSpan;", "start", "", "end", "(Lcom/blacksquircle/ui/language/base/span/StyleSpan;II)V", "getEnd", "()I", "setEnd", "(I)V", "getStart", "setStart", "compareTo", "other", "component1", "component2", "component3", "copy", "equals", "", "", "hashCode", "toString", "", "updateDrawState", "", "textPaint", "Landroid/text/TextPaint;", "language-base_release"})
public final class SyntaxHighlightSpan
extends CharacterStyle
implements Comparable<SyntaxHighlightSpan> {
    @NotNull
    private final StyleSpan span;
    private int start;
    private int end;

    public SyntaxHighlightSpan(@NotNull StyleSpan span, int start, int end) {
        Intrinsics.checkNotNullParameter((Object)span, (String)"span");
        this.span = span;
        this.start = start;
        this.end = end;
    }

    public final int getStart() {
        return this.start;
    }

    public final void setStart(int n) {
        this.start = n;
    }

    public final int getEnd() {
        return this.end;
    }

    public final void setEnd(int n) {
        this.end = n;
    }

    public void updateDrawState(@Nullable TextPaint textPaint) {
        TextPaint textPaint2 = textPaint;
        if (textPaint2 != null) {
            textPaint2.setColor(this.span.getColor());
        }
        textPaint2 = textPaint;
        if (textPaint2 != null) {
            textPaint2.setFakeBoldText(this.span.getBold());
        }
        textPaint2 = textPaint;
        if (textPaint2 != null) {
            textPaint2.setUnderlineText(this.span.getUnderline());
        }
        if (this.span.getItalic() && (textPaint2 = textPaint) != null) {
            textPaint2.setTextSkewX(-0.1f);
        }
        if (this.span.getStrikethrough() && (textPaint2 = textPaint) != null) {
            textPaint2.setFlags(16);
        }
    }

    @Override
    public int compareTo(@NotNull SyntaxHighlightSpan other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        return this.start - other.start;
    }

    private final StyleSpan component1() {
        return this.span;
    }

    public final int component2() {
        return this.start;
    }

    public final int component3() {
        return this.end;
    }

    @NotNull
    public final SyntaxHighlightSpan copy(@NotNull StyleSpan span, int start, int end) {
        Intrinsics.checkNotNullParameter((Object)span, (String)"span");
        return new SyntaxHighlightSpan(span, start, end);
    }

    public static /* synthetic */ SyntaxHighlightSpan copy$default(SyntaxHighlightSpan syntaxHighlightSpan, StyleSpan styleSpan, int n, int n2, int n3, Object object) {
        if ((n3 & 1) != 0) {
            styleSpan = syntaxHighlightSpan.span;
        }
        if ((n3 & 2) != 0) {
            n = syntaxHighlightSpan.start;
        }
        if ((n3 & 4) != 0) {
            n2 = syntaxHighlightSpan.end;
        }
        return syntaxHighlightSpan.copy(styleSpan, n, n2);
    }

    @NotNull
    public String toString() {
        return "SyntaxHighlightSpan(span=" + this.span + ", start=" + this.start + ", end=" + this.end + ')';
    }

    public int hashCode() {
        int result = this.span.hashCode();
        result = result * 31 + Integer.hashCode(this.start);
        result = result * 31 + Integer.hashCode(this.end);
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof SyntaxHighlightSpan)) {
            return false;
        }
        SyntaxHighlightSpan syntaxHighlightSpan = (SyntaxHighlightSpan)other;
        if (!Intrinsics.areEqual((Object)this.span, (Object)syntaxHighlightSpan.span)) {
            return false;
        }
        if (this.start != syntaxHighlightSpan.start) {
            return false;
        }
        return this.end == syntaxHighlightSpan.end;
    }
}

