/*
 * Decompiled with CFR 0.152.
 */
package com.blacksquircle.ui.language.base.utils;

import com.blacksquircle.ui.language.base.model.Suggestion;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\u0018\u0000 \u00152\u00020\u0001:\u0001\u0015B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\f\u001a\u00020\rJ\u000e\u0010\u000e\u001a\u00020\r2\u0006\u0010\u000f\u001a\u00020\u0005J\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00070\u0011J\u0016\u0010\u0012\u001a\u00020\r2\u0006\u0010\u000f\u001a\u00020\u00052\u0006\u0010\u0013\u001a\u00020\u0014R6\u0010\u0003\u001a*\u0012\u0004\u0012\u00020\u0005\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070\u00060\u0004j\u0014\u0012\u0004\u0012\u00020\u0005\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070\u0006`\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\t\u001a\n \u000b*\u0004\u0018\u00010\n0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lcom/blacksquircle/ui/language/base/utils/WordsManager;", "", "()V", "lineMap", "Ljava/util/HashMap;", "", "Ljava/util/LinkedList;", "Lcom/blacksquircle/ui/language/base/model/Suggestion;", "Lkotlin/collections/HashMap;", "wordsPattern", "Ljava/util/regex/Pattern;", "kotlin.jvm.PlatformType", "clearLines", "", "deleteLine", "lineNumber", "getWords", "", "processLine", "text", "", "Companion", "language-base_release"})
public final class WordsManager {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final Pattern wordsPattern = Pattern.compile("\\w((\\w|-)*(\\w))?");
    @NotNull
    private final HashMap<Integer, LinkedList<Suggestion>> lineMap;
    @NotNull
    private static final String WORDS_REGEX = "\\w((\\w|-)*(\\w))?";

    public WordsManager() {
        boolean bl = false;
        this.lineMap = new HashMap();
    }

    @NotNull
    public final Set<Suggestion> getWords() {
        boolean bl = false;
        HashSet<Suggestion> wordsSet = new HashSet<Suggestion>();
        for (LinkedList<Suggestion> line : this.lineMap.values()) {
            for (Suggestion word : line) {
                wordsSet.add(word);
            }
        }
        return wordsSet;
    }

    public final void processLine(int lineNumber, @NotNull String text) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        LinkedList<Suggestion> linkedList = this.lineMap.get(lineNumber);
        if (linkedList != null) {
            linkedList.clear();
        }
        Matcher matcher = this.wordsPattern.matcher(text);
        while (matcher.find()) {
            LinkedList<Suggestion> linkedList2 = text;
            int n = matcher.start();
            int n2 = matcher.end();
            boolean bl = false;
            String string = ((String)((Object)linkedList2)).substring(n, n2);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
            Suggestion word = new Suggestion(Suggestion.Type.WORD, string, "");
            if (this.lineMap.containsKey(lineNumber)) {
                linkedList2 = this.lineMap.get(lineNumber);
                if (linkedList2 == null) continue;
                linkedList2.add(word);
                continue;
            }
            linkedList2 = this.lineMap;
            Integer n3 = lineNumber;
            LinkedList<Suggestion> linkedList3 = new LinkedList<Suggestion>();
            bl = false;
            boolean bl2 = false;
            LinkedList<Suggestion> it = linkedList3;
            boolean bl3 = false;
            it.add(word);
            bl = false;
            linkedList2.put(n3, linkedList3);
        }
    }

    public final void deleteLine(int lineNumber) {
        this.lineMap.remove(lineNumber);
    }

    public final void clearLines() {
        this.lineMap.clear();
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/blacksquircle/ui/language/base/utils/WordsManager$Companion;", "", "()V", "WORDS_REGEX", "", "language-base_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

