/*
 * Decompiled with CFR 0.152.
 */
package com.bluelinelabs.conductor;

import android.os.Bundle;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewParent;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.bluelinelabs.conductor.Controller;
import com.bluelinelabs.conductor.ControllerChangeType;
import com.bluelinelabs.conductor.changehandler.SimpleSwapChangeHandler;
import com.bluelinelabs.conductor.internal.ClassUtils;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public abstract class ControllerChangeHandler {
    private static final String KEY_CLASS_NAME = "ControllerChangeHandler.className";
    private static final String KEY_SAVED_STATE = "ControllerChangeHandler.savedState";
    static final Map<String, ChangeHandlerData> inProgressChangeHandlers = new HashMap<String, ChangeHandlerData>();
    boolean forceRemoveViewOnPush;
    private boolean hasBeenUsed;

    public abstract void performChange(@NonNull ViewGroup var1, @Nullable View var2, @Nullable View var3, boolean var4, @NonNull ControllerChangeCompletedListener var5);

    public ControllerChangeHandler() {
        this.ensureDefaultConstructor();
    }

    public void saveToBundle(@NonNull Bundle bundle) {
    }

    public void restoreFromBundle(@NonNull Bundle bundle) {
    }

    public void onAbortPush(@NonNull ControllerChangeHandler newHandler, @Nullable Controller newTop) {
    }

    public void completeImmediately() {
    }

    @NonNull
    public ControllerChangeHandler copy() {
        return ControllerChangeHandler.fromBundle(this.toBundle());
    }

    public boolean isReusable() {
        return false;
    }

    @NonNull
    final Bundle toBundle() {
        Bundle bundle = new Bundle();
        bundle.putString(KEY_CLASS_NAME, this.getClass().getName());
        Bundle savedState = new Bundle();
        this.saveToBundle(savedState);
        bundle.putBundle(KEY_SAVED_STATE, savedState);
        return bundle;
    }

    private void ensureDefaultConstructor() {
        try {
            this.getClass().getConstructor(new Class[0]);
        }
        catch (Exception e) {
            throw new RuntimeException(this.getClass() + " does not have a default constructor.");
        }
    }

    @Nullable
    public static ControllerChangeHandler fromBundle(@Nullable Bundle bundle) {
        if (bundle != null) {
            String className = bundle.getString(KEY_CLASS_NAME);
            ControllerChangeHandler changeHandler = (ControllerChangeHandler)ClassUtils.newInstance(className);
            changeHandler.restoreFromBundle(bundle.getBundle(KEY_SAVED_STATE));
            return changeHandler;
        }
        return null;
    }

    static boolean completeHandlerImmediately(@NonNull String controllerInstanceId) {
        ChangeHandlerData changeHandlerData = inProgressChangeHandlers.get(controllerInstanceId);
        if (changeHandlerData != null) {
            changeHandlerData.changeHandler.completeImmediately();
            inProgressChangeHandlers.remove(controllerInstanceId);
            return true;
        }
        return false;
    }

    static void abortOrComplete(@NonNull Controller toAbort, @Nullable Controller newController, @NonNull ControllerChangeHandler newChangeHandler) {
        ChangeHandlerData changeHandlerData = inProgressChangeHandlers.get(toAbort.getInstanceId());
        if (changeHandlerData != null) {
            if (changeHandlerData.isPush) {
                changeHandlerData.changeHandler.onAbortPush(newChangeHandler, newController);
            } else {
                changeHandlerData.changeHandler.completeImmediately();
            }
            inProgressChangeHandlers.remove(toAbort.getInstanceId());
        }
    }

    static void executeChange(@NonNull ChangeTransaction transaction) {
        ControllerChangeHandler.executeChange(transaction.to, transaction.from, transaction.isPush, transaction.container, transaction.changeHandler, transaction.listeners);
    }

    private static void executeChange(@Nullable Controller to, @Nullable Controller from, boolean isPush, @Nullable ViewGroup container, @Nullable ControllerChangeHandler inHandler, @NonNull List<ControllerChangeListener> listeners) {
        if (container != null) {
            View fromView;
            View toView;
            ControllerChangeType fromChangeType;
            ControllerChangeHandler handler = inHandler == null ? new SimpleSwapChangeHandler() : (inHandler.hasBeenUsed && !inHandler.isReusable() ? inHandler.copy() : inHandler);
            handler.hasBeenUsed = true;
            if (from != null) {
                if (isPush) {
                    ControllerChangeHandler.completeHandlerImmediately(from.getInstanceId());
                } else {
                    ControllerChangeHandler.abortOrComplete(from, to, handler);
                }
            }
            if (to != null) {
                inProgressChangeHandlers.put(to.getInstanceId(), new ChangeHandlerData(handler, isPush));
            }
            for (ControllerChangeListener listener : listeners) {
                listener.onChangeStarted(to, from, isPush, container, handler);
            }
            ControllerChangeType toChangeType = isPush ? ControllerChangeType.PUSH_ENTER : ControllerChangeType.POP_ENTER;
            ControllerChangeType controllerChangeType = fromChangeType = isPush ? ControllerChangeType.PUSH_EXIT : ControllerChangeType.POP_EXIT;
            if (to != null) {
                toView = to.inflate(container);
                to.changeStarted(handler, toChangeType);
            } else {
                toView = null;
            }
            if (from != null) {
                fromView = from.getView();
                from.changeStarted(handler, fromChangeType);
            } else {
                fromView = null;
            }
            handler.performChange(container, fromView, toView, isPush, () -> {
                ViewParent fromParent;
                if (from != null) {
                    from.changeEnded(handler, fromChangeType);
                }
                if (to != null) {
                    inProgressChangeHandlers.remove(to.getInstanceId());
                    to.changeEnded(handler, toChangeType);
                }
                for (ControllerChangeListener listener : listeners) {
                    listener.onChangeCompleted(to, from, isPush, container, handler);
                }
                if (handler.forceRemoveViewOnPush && fromView != null && (fromParent = fromView.getParent()) != null && fromParent instanceof ViewGroup) {
                    ((ViewGroup)fromParent).removeView(fromView);
                }
                if (handler.removesFromViewOnPush() && from != null) {
                    from.setNeedsAttach(false);
                }
            });
        }
    }

    protected void onEnd() {
    }

    public boolean removesFromViewOnPush() {
        return true;
    }

    public void setForceRemoveViewOnPush(boolean force) {
        this.forceRemoveViewOnPush = force;
    }

    private static class ChangeHandlerData {
        public final ControllerChangeHandler changeHandler;
        public final boolean isPush;

        public ChangeHandlerData(ControllerChangeHandler changeHandler, boolean isPush) {
            this.changeHandler = changeHandler;
            this.isPush = isPush;
        }
    }

    public static interface ControllerChangeCompletedListener {
        public void onChangeCompleted();
    }

    static class ChangeTransaction {
        @Nullable
        final Controller to;
        @Nullable
        final Controller from;
        final boolean isPush;
        @Nullable
        final ViewGroup container;
        @Nullable
        final ControllerChangeHandler changeHandler;
        @NonNull
        final List<ControllerChangeListener> listeners;

        public ChangeTransaction(@Nullable Controller to, @Nullable Controller from, boolean isPush, @Nullable ViewGroup container, @Nullable ControllerChangeHandler changeHandler, @NonNull List<ControllerChangeListener> listeners) {
            this.to = to;
            this.from = from;
            this.isPush = isPush;
            this.container = container;
            this.changeHandler = changeHandler;
            this.listeners = listeners;
        }
    }

    public static interface ControllerChangeListener {
        default public void onChangeStarted(@Nullable Controller to, @Nullable Controller from, boolean isPush, @NonNull ViewGroup container, @NonNull ControllerChangeHandler handler) {
        }

        default public void onChangeCompleted(@Nullable Controller to, @Nullable Controller from, boolean isPush, @NonNull ViewGroup container, @NonNull ControllerChangeHandler handler) {
        }
    }
}

