/*
 * Decompiled with CFR 0.152.
 */
package com.ss.ttm.net;

import android.util.Log;
import com.ss.ttm.player.AVThreadPool;
import com.ss.ttm.player.CalledByNative;
import com.ss.ttm.player.Keep;
import java.net.InetAddress;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

@Keep
public class AVResolver {
    private static final String TAG = "ttmj";
    private String mHostName;
    private boolean mRet = false;
    private Thread mThread = null;
    private String mError;
    private String[] mIPStr;
    private HostInfo mHostInfo;
    public static int HOST_MAX_CACHE_TIME = 600000;
    private static final int MAX_CACHED = 128;
    private static final Hashtable<String, HostInfo> mCacheHosts = new Hashtable();

    @CalledByNative
    public void getAddressInfo(String hostname) {
        this.mHostName = hostname;
        if (hostname == null || hostname.length() < 1 || "".equals(hostname)) {
            this.mRet = true;
            return;
        }
        if (AVResolver.isIP(this.mHostName)) {
            this.mIPStr = new String[1];
            this.mIPStr[0] = this.mHostName;
            this.mRet = true;
            return;
        }
        this.mHostInfo = mCacheHosts.get(hostname);
        if (this.mHostInfo != null) {
            if (this.mHostInfo.ip != null && System.currentTimeMillis() - this.mHostInfo.time < (long)HOST_MAX_CACHE_TIME) {
                this.mIPStr = new String[1];
                this.mIPStr[0] = this.mHostInfo.ip;
                this.mRet = true;
                return;
            }
            mCacheHosts.remove(hostname);
            this.mHostInfo = null;
        }
        try {
            AVThreadPool.addTask(new ParserHost(this, this.mHostName));
        }
        catch (Exception e) {
            this.mRet = true;
            this.mError = e.getMessage();
        }
    }

    @CalledByNative
    public int isSuccess() {
        if (this.mRet) {
            if (this.mIPStr != null && this.mIPStr[0] != null) {
                return 1;
            }
            return -1;
        }
        return 0;
    }

    @CalledByNative
    public String getAddress() {
        if (this.mRet && this.mIPStr != null && this.mIPStr[0] != null) {
            return this.mIPStr[0];
        }
        return "parser host name: " + this.mHostName + " error.err msg:" + this.mError;
    }

    @CalledByNative
    public void freeAddress() {
        if (this.mThread != null) {
            try {
                this.mThread.interrupt();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    static synchronized void putHostInfo(String host, HostInfo info) {
        long dropHostTime = System.currentTimeMillis();
        String key = null;
        HostInfo dropHostInfo = null;
        HostInfo cur = null;
        if (mCacheHosts.size() > 128) {
            Set<Map.Entry<String, HostInfo>> set = mCacheHosts.entrySet();
            Iterator<Map.Entry<String, HostInfo>> it = set.iterator();
            while (it.hasNext()) {
                cur = it.next().getValue();
                key = it.next().getKey();
                if (cur == null || cur.time >= dropHostTime) continue;
                dropHostInfo = cur;
                dropHostTime = cur.time;
            }
        }
        if (dropHostInfo != null && key != null) {
            mCacheHosts.remove(key);
        }
        mCacheHosts.put(host, info);
    }

    public static final boolean isIP(String addr) {
        if (addr.length() < 7 || addr.length() > 15) {
            return addr.charAt(0) == '[' && addr.charAt(addr.length() - 1) == ']';
        }
        String rexp = "([1-9]|[1-9]\\d|1\\d{2}|2[0-4]\\d|25[0-5])(\\.(\\d|[1-9]\\d|1\\d{2}|2[0-4]\\d|25[0-5])){3}";
        Pattern pat = Pattern.compile(rexp);
        Matcher mat = pat.matcher(addr);
        boolean ipAddress = mat.find();
        return ipAddress;
    }

    static /* synthetic */ String[] access$202(AVResolver x0, String[] x1) {
        x0.mIPStr = x1;
        return x1;
    }

    static class ParserHost
    implements Runnable {
        AVResolver mResolver = null;
        String mHostName;

        public ParserHost(AVResolver resolver, String hostName) {
            this.mResolver = resolver;
            this.mHostName = hostName;
        }

        @Override
        public void run() {
            Log.i((String)AVResolver.TAG, (String)"start ParserHost task");
            InetAddress mAddress = null;
            String strIP = null;
            try {
                mAddress = InetAddress.getByName(this.mHostName);
                strIP = mAddress.getHostAddress();
            }
            catch (Throwable e) {
                e.printStackTrace();
                this.mResolver.mError = e.getMessage();
            }
            this.mResolver.mRet = true;
            if (mAddress == null || strIP == null) {
                return;
            }
            AVResolver.access$202(this.mResolver, new String[1]);
            ((AVResolver)this.mResolver).mIPStr[0] = strIP;
            HostInfo hostInfo = new HostInfo();
            hostInfo.time = System.currentTimeMillis();
            hostInfo.ip = strIP;
            AVResolver.putHostInfo(this.mHostName, hostInfo);
            hostInfo.time = System.currentTimeMillis();
        }
    }

    static class HostInfo {
        public String ip;
        public long time;

        HostInfo() {
        }
    }
}

