/*
 * Decompiled with CFR 0.152.
 */
package com.ss.ttm.player;

import android.annotation.TargetApi;
import android.media.MediaCodec;
import android.media.MediaCodecInfo;
import android.media.MediaCodecList;
import android.media.MediaFormat;
import android.os.Bundle;
import android.text.TextUtils;
import android.util.Log;
import android.util.Pair;
import android.view.Surface;
import com.ss.ttm.player.AJMediaCodecFrame;
import com.ss.ttm.player.AJMediaCodecRank;
import com.ss.ttm.player.AVThreadPool;
import com.ss.ttm.player.CalledByNative;
import com.ss.ttm.player.DummySurface;
import com.ss.ttm.player.Keep;
import com.ss.ttm.player.MediaCodecUtil;
import com.ss.ttm.player.VendorQTI;
import com.ss.ttm.utils.Util;
import java.lang.reflect.Method;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Locale;

@TargetApi(value=16)
@Keep
class AJMediaCodec {
    private static final String TAG = "aj_media_codec";
    private static final long INPUT_TIMEOUT_US = 30000L;
    private static final int PIXEL_FORMAT_NV12 = 3;
    private static final int PIXEL_FORMAT_YUV420P = 0;
    private static final int NO_VALUE = -1;
    private static final String KEY_CROP_LEFT = "crop-left";
    private static final String KEY_CROP_RIGHT = "crop-right";
    private static final String KEY_CROP_BOTTOM = "crop-bottom";
    private static final String KEY_CROP_TOP = "crop-top";
    private ByteBuffer[] mOutputBuffers;
    private ByteBuffer[] mInputBuffers;
    private boolean mInputBuffersValid = false;
    private static ArrayList<MediaCodecInfo> mVideoHWDecoderCodecs = new ArrayList();
    private static Object mCodecListLock = new Object();
    private static boolean mEvaluatedDeviceNeedsSetOutputSurfaceWorkaround = false;
    private static boolean mDeviceNeedsSetOutputSurfaceWorkaround = false;
    private MediaCodec mMediaCodec;
    private MediaCodec.BufferInfo mBufferInfo;
    private MediaFormat mOutputMediaFormat = null;
    private static boolean mIsInitDetected = false;
    private static boolean mIsByteVC1Blocklist = false;
    private static final String VERSION_PROPERTY = "ro.config.hw_codec_support";
    private static final double FIX_VERSION = 0.18041;
    private static final String VENDOR_OPPO_PROPERTY = "persist.sys.aweme.hdsupport";
    private Surface mDummySurface;
    private static boolean mNeedByteVC1WorkAround = false;
    private static final int CODEC_ERROR = -10000;
    private static final int CODEC_EXCEPTION_ERROR = -10001;
    private static final int CODEC_ILLEGAL_STATE = -10002;
    private static final int CODEC_ILLEGAL_ARGUMENT = -10003;
    private static final int AV_TRC_SMPTE2084 = 16;
    private static final int AV_TRC_ARIB_STD_B67 = 18;
    private String mExceptionInfo;

    public boolean MTKByteVC1NeedWorkAround() {
        return mNeedByteVC1WorkAround;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getProperty(String key, String defaultValue) {
        String value = defaultValue;
        try {
            Class<?> c = Class.forName("android.os.SystemProperties");
            Method get = c.getMethod("get", String.class, String.class);
            value = (String)get.invoke(c, key, defaultValue);
            return value;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            return value;
        }
    }

    @CalledByNative
    public AJMediaCodec() {
        if (!mIsInitDetected) {
            boolean bl = mNeedByteVC1WorkAround = Util.HARDWARE.toLowerCase(Locale.US).startsWith("mt") && Util.SDK_INT < 26;
            if (this.isHisiByteVC1BlockList() || this.isMtkByteVC1BlockList()) {
                mIsByteVC1Blocklist = true;
            }
        }
        AJMediaCodec.codecNeedsSetOutputSurfaceWorkaround();
        mIsInitDetected = true;
        Log.i((String)TAG, (String)("initialize, need workaround " + mDeviceNeedsSetOutputSurfaceWorkaround));
    }

    @CalledByNative
    public String getErrorInfo() {
        return this.mExceptionInfo;
    }

    private boolean isHisiByteVC1BlockList() {
        String platform = null;
        platform = AJMediaCodec.getProperty("ro.board.platform", null);
        if (Util.SDK_INT == 26 && platform != null && (platform.startsWith("kirin960") || platform.startsWith("hi3660"))) {
            String ret = null;
            double versionCode = 0.0;
            ret = AJMediaCodec.getProperty(VERSION_PROPERTY, "0.0");
            try {
                versionCode = Double.parseDouble(ret);
            }
            catch (NumberFormatException e) {
                Log.w((String)TAG, (String)"vendor property abnormal");
            }
            if (versionCode < 0.18041) {
                return true;
            }
        }
        return false;
    }

    @CalledByNative
    private boolean supportSetSurface() {
        return !mDeviceNeedsSetOutputSurfaceWorkaround;
    }

    private boolean isMtkByteVC1BlockList() {
        String hardware = Util.HARDWARE.toLowerCase(Locale.US);
        return hardware.startsWith("mt6763") || hardware.startsWith("mt6757") || hardware.startsWith("mt6739") || hardware.startsWith("mt6750");
    }

    @CalledByNative
    public int vendorOppoHWEnable() {
        int ret = 1;
        if (Util.BARND.equals("OPPO")) {
            String value = null;
            value = AJMediaCodec.getProperty(VENDOR_OPPO_PROPERTY, "1");
            Log.i((String)TAG, (String)("oppo property = " + value));
            try {
                ret = Integer.parseInt(value);
            }
            catch (NumberFormatException e) {
                Log.w((String)TAG, (String)"vendor oppo property abnormal");
            }
        }
        return ret;
    }

    @CalledByNative
    public int createByCodecName(String codecName) {
        Log.i((String)TAG, (String)("createByCodecName = " + codecName));
        try {
            this.mMediaCodec = MediaCodec.createByCodecName((String)codecName);
        }
        catch (Exception e) {
            this.handleCodecException(e);
            Log.d((String)TAG, (String)("createByCodecName fail = " + e.toString()));
            return -1;
        }
        return 0;
    }

    private static void maybeSetInteger(MediaFormat format, String key, int value) {
        if (value != -1) {
            format.setInteger(key, value);
        }
    }

    private static void maybeSetCsdBuffers(MediaFormat format, ByteBuffer csd, int idx) {
        if (csd == null) {
            return;
        }
        format.setByteBuffer("csd-" + idx, csd);
    }

    private void createDummySurface() {
        Log.d((String)TAG, (String)"create dummy surface");
        this.mDummySurface = DummySurface.newInstanceV17(false);
    }

    @CalledByNative
    public int configure(int width, int height, int rotation, int sampleRate, int channelCount, String codecType, ByteBuffer csd0, ByteBuffer csd1, ByteBuffer csd2, Surface surface, boolean surfaceConfigure, boolean realTime, int maxWidth, int maxHeight, boolean enableVpp, int vppLevel, boolean debugVpp, boolean lowLatency, int doviProfile, int doviLevel) {
        Log.i((String)TAG, (String)("configure =" + surface + ", surfaceConfigure =" + surfaceConfigure));
        MediaFormat inputFormat = new MediaFormat();
        int csdIdx = 0;
        inputFormat.setString("mime", codecType);
        AJMediaCodec.maybeSetInteger(inputFormat, "width", width);
        AJMediaCodec.maybeSetInteger(inputFormat, "height", height);
        if (maxWidth != -1 && maxHeight != -1) {
            AJMediaCodec.maybeSetInteger(inputFormat, "max-width", maxWidth > width ? maxWidth : width);
            AJMediaCodec.maybeSetInteger(inputFormat, "max-height", maxHeight > height ? maxHeight : height);
        }
        AJMediaCodec.maybeSetInteger(inputFormat, "sample-rate", sampleRate);
        AJMediaCodec.maybeSetInteger(inputFormat, "channel-count", channelCount);
        Log.i((String)TAG, (String)("format  = " + inputFormat));
        int maxInputSize = AJMediaCodec.getMaxInputSize(codecType, width, height);
        Log.i((String)TAG, (String)("max input = " + maxInputSize));
        AJMediaCodec.maybeSetInteger(inputFormat, "max-input-size", maxInputSize);
        AJMediaCodec.maybeSetCsdBuffers(inputFormat, csd0, csdIdx);
        AJMediaCodec.maybeSetCsdBuffers(inputFormat, csd1, ++csdIdx);
        AJMediaCodec.maybeSetCsdBuffers(inputFormat, csd2, ++csdIdx);
        if (surfaceConfigure) {
            if (Util.SDK_INT >= 21) {
                AJMediaCodec.maybeSetInteger(inputFormat, "rotation-degrees", rotation);
            }
            if (!(surface != null && surface.isValid() || this.mDummySurface != null || Util.SDK_INT < 23 || mDeviceNeedsSetOutputSurfaceWorkaround)) {
                Log.i((String)TAG, (String)"create dummy surface");
                this.createDummySurface();
                surface = this.mDummySurface;
            }
            if (surface == null) {
                this.mExceptionInfo = "Error: configure with null surface";
                return -10003;
            }
        }
        if (Util.SDK_INT >= 23 && realTime) {
            inputFormat.setInteger("priority", 0);
        }
        if (enableVpp) {
            VendorQTI.setupVpp(inputFormat, vppLevel);
        }
        if (debugVpp) {
            VendorQTI.debugEffect(inputFormat);
        }
        if (lowLatency) {
            VendorQTI.enableLowLatency(inputFormat);
        }
        if (doviLevel > 0 && doviProfile >= 0) {
            String codecs = MediaCodecUtil.getDolbyCodecs(doviProfile, doviLevel);
            Log.d((String)TAG, (String)("dv codecs = " + codecs));
            String[] parts = codecs.split("\\.");
            Pair<Integer, Integer> codecProfileAndLevel = MediaCodecUtil.getDolbyVisionProfileAndLevel(codecs, parts);
            if (codecProfileAndLevel != null) {
                Log.d((String)TAG, (String)("dv profile & level  = " + codecProfileAndLevel.toString()));
                AJMediaCodec.maybeSetInteger(inputFormat, "profile", (Integer)codecProfileAndLevel.first);
            }
        }
        try {
            this.mMediaCodec.configure(inputFormat, surface, null, 0);
        }
        catch (Exception e) {
            this.handleCodecException(e);
            Log.d((String)TAG, (String)("configure failed = " + this.mMediaCodec + ", ex=" + e.toString()));
            if (e instanceof IllegalArgumentException) {
                return -10003;
            }
            return -1;
        }
        return 0;
    }

    @CalledByNative
    public int start() {
        Log.i((String)TAG, (String)"start");
        try {
            this.mMediaCodec.start();
            this.mInputBuffers = this.mMediaCodec.getInputBuffers();
            if (Util.SDK_INT >= 21) {
                this.mOutputBuffers = this.mMediaCodec.getOutputBuffers();
            }
            this.mInputBuffersValid = true;
            this.mBufferInfo = new MediaCodec.BufferInfo();
        }
        catch (Exception e) {
            this.handleCodecException(e);
            return -1;
        }
        Log.i((String)TAG, (String)"start end");
        return 0;
    }

    public int open(int width, int height, int rotation, String codecName, String codecType, ByteBuffer spspps, Surface surface) {
        Log.i((String)TAG, (String)("open, rotation = " + rotation + "; codecName = " + codecName + "; codecType =" + codecType));
        try {
            this.mMediaCodec = MediaCodec.createByCodecName((String)codecName);
        }
        catch (Exception e) {
            Log.d((String)TAG, (String)e.toString());
            return -1;
        }
        Log.i((String)TAG, (String)"configure mediacodec");
        MediaFormat inputFormat = new MediaFormat();
        inputFormat.setString("mime", codecType);
        AJMediaCodec.maybeSetInteger(inputFormat, "width", width);
        AJMediaCodec.maybeSetInteger(inputFormat, "height", height);
        if (spspps != null) {
            inputFormat.setByteBuffer("csd-0", spspps);
        }
        if (surface != null && Util.SDK_INT >= 21) {
            AJMediaCodec.maybeSetInteger(inputFormat, "rotation-degrees", rotation);
        }
        try {
            this.mMediaCodec.configure(inputFormat, surface, null, 0);
        }
        catch (Exception e) {
            Log.d((String)TAG, (String)e.toString());
            return -1;
        }
        Log.i((String)TAG, (String)"mediacodec start");
        try {
            this.mMediaCodec.start();
        }
        catch (Exception e) {
            Log.d((String)TAG, (String)e.toString());
            return -1;
        }
        this.mInputBuffers = this.mMediaCodec.getInputBuffers();
        this.mInputBuffersValid = true;
        String printStr = String.format(Locale.US, "open() input params. width:%d,height:%d", width, height);
        Log.d((String)TAG, (String)printStr);
        return 0;
    }

    @CalledByNative
    public int stop() {
        if (this.mInputBuffersValid) {
            Log.i((String)TAG, (String)"stop");
            try {
                this.mInputBuffersValid = false;
                this.mMediaCodec.stop();
            }
            catch (Exception e) {
                Log.d((String)TAG, (String)"mediacodec stop exception");
                return -1;
            }
        }
        return 0;
    }

    private void releaseCodec(MediaCodec codec) {
        if (codec == null) {
            return;
        }
        try {
            codec.release();
        }
        catch (Exception exception) {
        }
        finally {
            if (this.mDummySurface != null) {
                this.mDummySurface.release();
                this.mDummySurface = null;
            }
            Log.i((String)TAG, (String)"codec release end");
        }
    }

    @CalledByNative
    public void close() {
        Log.i((String)TAG, (String)"close start");
        if (this.mMediaCodec != null) {
            this.stop();
            final MediaCodec mediaCodec = this.mMediaCodec;
            this.mInputBuffers = null;
            this.mOutputBuffers = null;
            this.mMediaCodec = null;
            try {
                AVThreadPool.addTask(new Runnable(){

                    @Override
                    public void run() {
                        Log.i((String)AJMediaCodec.TAG, (String)"start releaseCodec task");
                        AJMediaCodec.this.releaseCodec(mediaCodec);
                    }
                });
            }
            catch (Throwable e) {
                Log.w((String)TAG, (String)"new thread failed");
                this.releaseCodec(mediaCodec);
            }
        }
        Log.i((String)TAG, (String)"close end");
    }

    @TargetApi(value=21)
    private int renderOutputBufferV21(int idx, long relaseNanoTime) {
        try {
            this.mMediaCodec.releaseOutputBuffer(idx, relaseNanoTime);
        }
        catch (Exception e) {
            return -10000;
        }
        return 0;
    }

    @TargetApi(value=21)
    public int handleCodecExceptionV21(Exception e) {
        if (e instanceof MediaCodec.CodecException) {
            MediaCodec.CodecException codecExc = (MediaCodec.CodecException)e;
            if (Util.SDK_INT >= 23) {
                Log.d((String)TAG, (String)("exception codecExc isRecoverable: " + codecExc.isRecoverable() + ", errorcode: " + codecExc.getErrorCode()));
                if (!codecExc.isRecoverable()) {
                    if (codecExc.getErrorCode() != 1100) {
                        if (codecExc.getErrorCode() != 1101) {
                            return -10001;
                        }
                    }
                }
            } else {
                Log.d((String)TAG, (String)("exception codecExc isRecoverable: " + codecExc.isRecoverable()));
                if (!codecExc.isRecoverable()) {
                    return -10001;
                }
            }
        }
        if (e instanceof IllegalStateException) {
            return -10002;
        }
        return -10000;
    }

    public int handleCodecException(Exception e) {
        this.mExceptionInfo = e.toString();
        if (Util.SDK_INT >= 21) {
            return this.handleCodecExceptionV21(e);
        }
        if (e instanceof IllegalStateException) {
            return -10002;
        }
        return -10000;
    }

    @CalledByNative
    public int dequeueInputBuffer(long timeoutUs) {
        try {
            return this.mMediaCodec.dequeueInputBuffer(timeoutUs);
        }
        catch (Exception e) {
            Log.d((String)TAG, (String)("dequeueInputBuffer failed, exception: " + e));
            return this.handleCodecException(e);
        }
    }

    @CalledByNative
    public ByteBuffer[] getInputBuffers() {
        if (this.mInputBuffersValid) {
            return this.mInputBuffers;
        }
        return null;
    }

    @CalledByNative
    public int queueInputBuffer(int idx, int offset, int size, long presentationTimeUs, int flags) {
        try {
            this.mMediaCodec.queueInputBuffer(idx, offset, size, presentationTimeUs, flags);
        }
        catch (Exception e) {
            Log.d((String)TAG, (String)("queueInputBuffer failed, exception: " + e));
            return this.handleCodecException(e);
        }
        return 0;
    }

    @CalledByNative
    public int setOutputSurface(Surface surface) {
        Log.d((String)TAG, (String)("setoutput surface = " + surface));
        if (!mDeviceNeedsSetOutputSurfaceWorkaround && this.mInputBuffersValid) {
            if (surface == null) {
                if (this.mDummySurface == null) {
                    this.createDummySurface();
                }
                surface = this.mDummySurface;
                Log.i((String)TAG, (String)"use dummy surface");
            }
            Log.d((String)TAG, (String)("setoutputSurface = " + surface));
            return this.setOutputSurfaceV23(this.mMediaCodec, surface);
        }
        return -1;
    }

    @CalledByNative
    public int write(AJMediaCodecFrame buffer) {
        if (buffer == null || buffer.data == null) {
            Log.d((String)TAG, (String)"buffer is nullpoint");
            return -1;
        }
        try {
            int idx = this.mMediaCodec.dequeueInputBuffer(30000L);
            if (idx >= 0) {
                ByteBuffer codecBuffer = this.mInputBuffers[idx];
                codecBuffer.put(buffer.data);
                this.mMediaCodec.queueInputBuffer(idx, 0, buffer.size, buffer.pts, 0);
                return 0;
            }
            if (idx == -1) {
                return 4;
            }
            return -1;
        }
        catch (Exception e) {
            Log.e((String)TAG, (String)("write meet exception =" + e));
            return -1;
        }
    }

    @CalledByNative
    public int read(AJMediaCodecFrame frame, long timeoutUs) {
        block12: {
            int idx = -1;
            while (true) {
                try {
                    idx = this.mMediaCodec.dequeueOutputBuffer(this.mBufferInfo, timeoutUs);
                }
                catch (Exception e) {
                    Log.i((String)TAG, (String)("dequeueOutputBuffer e :" + e));
                    return this.handleCodecException(e);
                }
                if (idx >= 0) {
                    ByteBuffer outBuffer;
                    frame.data = outBuffer = this.mOutputBuffers[idx];
                    frame.pts = this.mBufferInfo.presentationTimeUs;
                    frame.index = idx;
                    frame.size = this.mBufferInfo.size;
                    frame.flags = this.mBufferInfo.flags;
                    return 0;
                }
                if (idx != -3) break;
                Log.i((String)TAG, (String)"INFO_OUTPUT_BUFFERS_CHANGED");
                try {
                    this.mOutputBuffers = this.mMediaCodec.getOutputBuffers();
                }
                catch (Exception e) {
                    Log.i((String)TAG, (String)("getOutputBuffers e = " + e));
                    return this.handleCodecException(e);
                }
            }
            if (idx == -2) {
                Log.i((String)TAG, (String)"INFO_OUTPUT_FORMAT_CHANGED");
                try {
                    this.mOutputMediaFormat = this.mMediaCodec.getOutputFormat();
                }
                catch (Exception e) {
                    Log.i((String)TAG, (String)("getOutputFormat e =" + e));
                    return this.handleCodecException(e);
                }
                if (this.mOutputBuffers == null) {
                    try {
                        this.mOutputBuffers = this.mMediaCodec.getOutputBuffers();
                    }
                    catch (Exception e) {
                        Log.i((String)TAG, (String)("getOutputBuffers e = " + e));
                        return this.handleCodecException(e);
                    }
                }
                return idx;
            }
            if (idx == -1) break block12;
            Log.e((String)TAG, (String)("error, idx = " + idx));
        }
        return -1;
    }

    @CalledByNative
    public void flush() {
        Log.i((String)TAG, (String)"flush");
        try {
            this.mMediaCodec.flush();
        }
        catch (Exception exception) {
            // empty catch block
        }
        Log.i((String)TAG, (String)"flush done");
    }

    @CalledByNative
    public int releaseBuffer(int idx, boolean render, long releaseNanoTime) {
        if (Util.SDK_INT >= 21 && render) {
            return this.renderOutputBufferV21(idx, releaseNanoTime);
        }
        try {
            this.mMediaCodec.releaseOutputBuffer(idx, render);
        }
        catch (Exception e) {
            return this.handleCodecException(e);
        }
        return 0;
    }

    @CalledByNative
    public int getFormatWidth() {
        if (this.mOutputMediaFormat != null) {
            try {
                boolean hasCrop = this.mOutputMediaFormat.containsKey(KEY_CROP_RIGHT) && this.mOutputMediaFormat.containsKey(KEY_CROP_LEFT) && this.mOutputMediaFormat.containsKey(KEY_CROP_BOTTOM) && this.mOutputMediaFormat.containsKey(KEY_CROP_TOP);
                int currentWidth = hasCrop ? this.mOutputMediaFormat.getInteger(KEY_CROP_RIGHT) - this.mOutputMediaFormat.getInteger(KEY_CROP_LEFT) + 1 : this.mOutputMediaFormat.getInteger("width");
                return currentWidth;
            }
            catch (Exception e) {
                return 0;
            }
        }
        return 0;
    }

    @CalledByNative
    public int getFormatHeight() {
        if (this.mOutputMediaFormat != null) {
            try {
                boolean hasCrop = this.mOutputMediaFormat.containsKey(KEY_CROP_RIGHT) && this.mOutputMediaFormat.containsKey(KEY_CROP_LEFT) && this.mOutputMediaFormat.containsKey(KEY_CROP_BOTTOM) && this.mOutputMediaFormat.containsKey(KEY_CROP_TOP);
                int currentHeight = hasCrop ? this.mOutputMediaFormat.getInteger(KEY_CROP_BOTTOM) - this.mOutputMediaFormat.getInteger(KEY_CROP_TOP) + 1 : this.mOutputMediaFormat.getInteger("height");
                return currentHeight;
            }
            catch (Exception e) {
                return 0;
            }
        }
        return 0;
    }

    @CalledByNative
    public int getStride() {
        if (this.mOutputMediaFormat != null) {
            try {
                return this.mOutputMediaFormat.getInteger("stride");
            }
            catch (Exception e) {
                return 0;
            }
        }
        return 0;
    }

    @CalledByNative
    public int getSliceHeight() {
        if (this.mOutputMediaFormat != null) {
            try {
                return this.mOutputMediaFormat.getInteger("slice-height");
            }
            catch (Exception e) {
                return 0;
            }
        }
        return 0;
    }

    @CalledByNative
    public int getSampleRate() {
        if (this.mOutputMediaFormat != null) {
            try {
                return this.mOutputMediaFormat.getInteger("sample-rate");
            }
            catch (Exception e) {
                return 0;
            }
        }
        return 0;
    }

    @CalledByNative
    public int getChannelCount() {
        if (this.mOutputMediaFormat != null) {
            try {
                return this.mOutputMediaFormat.getInteger("channel-count");
            }
            catch (Exception e) {
                return 0;
            }
        }
        return 0;
    }

    @CalledByNative
    public int getColorFormat() {
        if (this.mOutputMediaFormat != null) {
            try {
                int format = this.mOutputMediaFormat.getInteger("color-format");
                switch (format) {
                    case 21: 
                    case 2130706688: 
                    case 2141391872: {
                        return 3;
                    }
                }
                return 0;
            }
            catch (Exception e) {
                return 0;
            }
        }
        return 0;
    }

    @CalledByNative
    public int getColorTransfer() {
        if (this.mOutputMediaFormat != null) {
            try {
                int ct = this.mOutputMediaFormat.getInteger("color-transfer");
                switch (ct) {
                    case 6: {
                        return 16;
                    }
                    case 7: {
                        return 18;
                    }
                }
                return 0;
            }
            catch (Exception e) {
                return 0;
            }
        }
        return 0;
    }

    @CalledByNative
    public int getOSVerion() {
        return Util.SDK_INT;
    }

    @TargetApi(value=23)
    @CalledByNative
    public void speedEnhance(float rate) {
        if (this.mMediaCodec != null && this.mInputBuffersValid && Util.SDK_INT >= 23 && rate > 30.0f) {
            Log.i((String)TAG, (String)("rate " + rate));
            Bundle bundle = new Bundle();
            bundle.putFloat("operating-rate", rate);
            try {
                this.mMediaCodec.setParameters(bundle);
            }
            catch (Exception e) {
                Log.w((String)TAG, (String)("setParameters failed ret = " + e));
            }
        }
    }

    @TargetApi(value=23)
    @CalledByNative
    public void decodeFRC(int level) {
        if (this.mMediaCodec != null && this.mInputBuffersValid && Util.SDK_INT >= 23) {
            Log.i((String)TAG, (String)("frc level = " + level));
            Bundle param = new Bundle();
            param.putInt("vivo.video-dec.dynamic-frc", level);
            try {
                this.mMediaCodec.setParameters(param);
            }
            catch (Exception e) {
                Log.w((String)TAG, (String)("setParameters failed ret = " + e));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @CalledByNative
    public String getBestCodecName(String codecType) {
        if (Util.SDK_INT < 16) {
            Log.d((String)TAG, (String)"API < 16");
            return null;
        }
        if (TextUtils.isEmpty((CharSequence)codecType)) {
            return null;
        }
        if (codecType.equals("video/hevc") && mIsByteVC1Blocklist) {
            Log.w((String)TAG, (String)("the device is hw decoder blocklist," + Util.HARDWARE));
            return null;
        }
        Log.i((String)TAG, (String)("detect hardware codec by codecType = " + codecType));
        boolean alreadyCached = false;
        ArrayList<AJMediaCodecRank> rankCodecList = new ArrayList<AJMediaCodecRank>();
        Object object = mCodecListLock;
        synchronized (object) {
            if (!mVideoHWDecoderCodecs.isEmpty()) {
                alreadyCached = true;
            }
            int numCodecs = -1;
            try {
                numCodecs = alreadyCached ? mVideoHWDecoderCodecs.size() : MediaCodecList.getCodecCount();
            }
            catch (Exception e) {
                Log.w((String)TAG, (String)"mediaserver died");
                return null;
            }
            for (int i = 0; i < numCodecs && (!alreadyCached || rankCodecList.isEmpty()); ++i) {
                String[] types;
                MediaCodecInfo codecInfo = alreadyCached ? mVideoHWDecoderCodecs.get(i) : MediaCodecList.getCodecInfoAt((int)i);
                String codecName = codecInfo.getName();
                Log.d((String)TAG, (String)("found codec name : " + codecName));
                if (codecInfo.isEncoder() || codecName.startsWith("OMX.google") || codecName.startsWith("c2.android") || (types = codecInfo.getSupportedTypes()) == null) continue;
                for (String type : types) {
                    AJMediaCodecRank codecRank;
                    if (TextUtils.isEmpty((CharSequence)type)) continue;
                    if (!alreadyCached && type.startsWith("video/")) {
                        mVideoHWDecoderCodecs.add(codecInfo);
                    }
                    if (!type.equalsIgnoreCase(codecType)) continue;
                    Log.d((String)TAG, (String)("codec types : " + type));
                    if (!codecName.startsWith("OMX.") && !codecName.startsWith("c2.") || codecName.startsWith("OMX.pv") || codecName.startsWith("OMX.ittiam") || codecName.contains("ffmpeg") || codecName.contains("avcodec") || codecName.contains("secure") || codecName.startsWith("OMX.MTK.") && Util.SDK_INT < 18 || AJMediaCodec.codecNeedsFlushWorkaround(codecName) || (codecRank = AJMediaCodecRank.setupRank(codecInfo, codecType)) == null) continue;
                    Log.i((String)TAG, (String)("codec : " + codecRank.mMediaCodecInfo.getName() + ",  rank : " + codecRank.mRank));
                    if (codecRank.mRank == 40 && Util.SDK_INT < 21) {
                        Log.w((String)TAG, (String)"skip vendor mediacodec api impl ambiguous");
                        continue;
                    }
                    if (codecRank.mRank == 20) {
                        Log.w((String)TAG, (String)"skip vendor software codec");
                        continue;
                    }
                    rankCodecList.add(codecRank);
                }
            }
            if (rankCodecList.isEmpty()) {
                return null;
            }
            AJMediaCodecRank bestCodec = (AJMediaCodecRank)rankCodecList.get(0);
            for (AJMediaCodecRank rankCodec : rankCodecList) {
                if (rankCodec.mRank <= bestCodec.mRank) continue;
                bestCodec = rankCodec;
            }
            return bestCodec.mMediaCodecInfo.getName();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean codecNeedsSetOutputSurfaceWorkaround() {
        Class<AJMediaCodec> clazz = AJMediaCodec.class;
        synchronized (AJMediaCodec.class) {
            if (!mEvaluatedDeviceNeedsSetOutputSurfaceWorkaround) {
                if (Util.SDK_INT <= 27 && "dangal".equals(Util.DEVICE)) {
                    mDeviceNeedsSetOutputSurfaceWorkaround = true;
                } else if (Util.SDK_INT < 27) {
                    switch (Util.DEVICE) {
                        case "deb": 
                        case "mido": 
                        case "santoni": {
                            mDeviceNeedsSetOutputSurfaceWorkaround = true;
                            break;
                        }
                    }
                    switch (Util.MODEL) {
                        case "AFTA": 
                        case "AFTN": {
                            mDeviceNeedsSetOutputSurfaceWorkaround = true;
                            break;
                        }
                    }
                }
                mEvaluatedDeviceNeedsSetOutputSurfaceWorkaround = true;
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return mDeviceNeedsSetOutputSurfaceWorkaround;
        }
    }

    @TargetApi(value=23)
    private int setOutputSurfaceV23(MediaCodec codec, Surface surface) {
        try {
            codec.setOutputSurface(surface);
        }
        catch (Exception e) {
            this.handleCodecException(e);
            Log.w((String)TAG, (String)("setoutputsurface failed = " + e));
            return -1;
        }
        return 0;
    }

    public static int ceilDivide(int numerator, int denominator) {
        return (numerator + denominator - 1) / denominator;
    }

    private static int getMaxInputSize(String sampleMimeType, int width, int height) {
        int minCompressionRatio;
        int maxPixels;
        if (width == -1 || height == -1) {
            return -1;
        }
        if (sampleMimeType.equals("video/3gpp") || sampleMimeType.equals("video/mp4v-es")) {
            maxPixels = width * height;
            minCompressionRatio = 2;
        } else if (sampleMimeType.equals("video/avc")) {
            if ("BRAVIA 4K 2015".equals(Util.MODEL)) {
                return -1;
            }
            maxPixels = AJMediaCodec.ceilDivide(width, 16) * AJMediaCodec.ceilDivide(height, 16) * 16 * 16;
            minCompressionRatio = 2;
        } else if (sampleMimeType.equals("video/x-vnd.on2.vp8")) {
            maxPixels = width * height;
            minCompressionRatio = 2;
        } else if (sampleMimeType.equals("video/hevc") || sampleMimeType.equals("video/x-vnd.on2.vp9")) {
            maxPixels = width * height;
            minCompressionRatio = 4;
        } else {
            return -1;
        }
        return maxPixels * 3 / (2 * minCompressionRatio);
    }

    private static boolean codecNeedsFlushWorkaround(String name) {
        boolean ret = Util.SDK_INT < 18 || Util.SDK_INT == 18 && ("OMX.SEC.avc.dec".equals(name) || "OMX.SEC.avc.dec.secure".equals(name)) || Util.SDK_INT == 19 && Util.MODEL.startsWith("SM-G800") && ("OMX.Exynos.avc.dec".equals(name) || "OMX.Exynos.avc.dec.secure".equals(name));
        return ret;
    }
}

