/*
 * Decompiled with CFR 0.152.
 */
package com.ss.ttm.player;

import android.annotation.TargetApi;
import android.media.MediaCodecInfo;
import android.text.TextUtils;
import java.util.Map;
import java.util.TreeMap;

@TargetApi(value=16)
public class AJMediaCodecRank {
    private static final String TAG = "AJMediaCodecRank";
    public static final int RANK_TESTED = 100;
    public static final int RANK_ACCEPTABLE = 70;
    public static final int RANK_NO_CAPS = 60;
    public static final int RANK_IMPL_AMBIGUOUS = 40;
    public static final int RANK_SOFTWARE = 20;
    public MediaCodecInfo mMediaCodecInfo;
    public int mRank = 0;
    public String mCodecType;
    private static Map<String, Integer> mTestHWCodecs;

    private static Map<String, Integer> getTestHWcodecs() {
        if (mTestHWCodecs != null) {
            return mTestHWCodecs;
        }
        mTestHWCodecs = new TreeMap<String, Integer>(String.CASE_INSENSITIVE_ORDER);
        mTestHWCodecs.put("OMX.qcom.video.decoder.avc", 100);
        mTestHWCodecs.put("OMX.qcom.video.decoder.hevc", 100);
        mTestHWCodecs.put("OMX.qcom.video.decoder.hevcswvdec", 20);
        mTestHWCodecs.put("OMX.MTK.VIDEO.DECODER.HEVC", 100);
        mTestHWCodecs.put("OMX.MTK.VIDEO.DECODER.AVC", 100);
        mTestHWCodecs.put("OMX.Nvidia.h264.decode", 100);
        mTestHWCodecs.put("OMX.Intel.hw_vd.h264", 100);
        mTestHWCodecs.put("OMX.Intel.VideoDecoder.AVC", 99);
        mTestHWCodecs.put("OMX.SEC.avc.dec", 100);
        mTestHWCodecs.put("OMX.SEC.AVC.Decoder", 99);
        mTestHWCodecs.put("OMX.SEC.avcdec", 98);
        mTestHWCodecs.put("OMX.SEC.avc.sw.dec", 20);
        mTestHWCodecs.put("OMX.SEC.hevc.sw.dec", 20);
        mTestHWCodecs.put("OMX.Exynos.avc.dec", 100);
        mTestHWCodecs.put("OMX.Exynos.AVC.Decoder", 99);
        mTestHWCodecs.put("OMX.TI.DUCATI1.VIDEO.DECODER", 100);
        mTestHWCodecs.put("OMX.rk.video_decoder.avc", 100);
        mTestHWCodecs.put("OMX.amlogic.avc.decoder.awesome", 100);
        mTestHWCodecs.put("OMX.MARVELL.VIDEO.HW.CODA7542DECODER", 100);
        mTestHWCodecs.put("OMX.brcm.video.h264.hw.decoder", 40);
        mTestHWCodecs.put("OMX.k3.video.decoder.avc", 40);
        mTestHWCodecs.put("OMX.IMG.MSVDX.Decoder.AVC", 100);
        mTestHWCodecs.put("OMX.hisi.video.decoder.avc", 100);
        mTestHWCodecs.put("OMX.hisi.video.decoder.hevc", 100);
        mTestHWCodecs.put("OMX.MARVELL.VIDEO.H264DECODER", 20);
        mTestHWCodecs.put("OMX.sprd.soft.h264.decoder", 20);
        return mTestHWCodecs;
    }

    public static AJMediaCodecRank setupRank(MediaCodecInfo codecInfo, String codecType) {
        if (codecInfo == null) {
            return null;
        }
        String codecName = codecInfo.getName();
        if (TextUtils.isEmpty((CharSequence)codecName)) {
            return null;
        }
        int rank = 0;
        Integer codecRank = AJMediaCodecRank.getTestHWcodecs().get(codecName);
        if (codecRank != null) {
            rank = codecRank;
        } else {
            try {
                MediaCodecInfo.CodecCapabilities caps = codecInfo.getCapabilitiesForType(codecType);
                rank = caps != null ? 70 : 60;
            }
            catch (Exception e) {
                rank = 60;
            }
        }
        AJMediaCodecRank mediaCodecRank = new AJMediaCodecRank();
        mediaCodecRank.mMediaCodecInfo = codecInfo;
        mediaCodecRank.mCodecType = codecType;
        mediaCodecRank.mRank = rank;
        return mediaCodecRank;
    }
}

