/*
 * Decompiled with CFR 0.152.
 */
package com.ss.ttm.player;

import android.annotation.SuppressLint;
import android.media.AudioManager;
import android.media.AudioTrack;
import android.os.Build;
import android.os.ConditionVariable;
import android.os.SystemClock;
import android.support.annotation.RequiresApi;
import android.util.Log;
import com.ss.ttm.player.AVThreadPool;
import com.ss.ttm.player.AudioTrackPositionTracker;
import com.ss.ttm.player.CalledByNative;
import com.ss.ttm.player.Keep;
import com.ss.ttm.player.TTPlayer;
import com.ss.ttm.utils.AVLogger;
import com.ss.ttm.utils.Util;
import java.lang.reflect.Method;
import java.nio.ByteBuffer;
import java.util.Locale;

@Keep
public class AJVoice
implements AudioTrack.OnPlaybackPositionUpdateListener {
    private static final String TAG = AJVoice.class.getSimpleName();
    private static final int kNoSettingVolume = -1;
    private static final int S_OK = 0;
    private static final int S_FAIL = -1;
    private static final int MS_UNIT = 1000;
    private static final int MAX_LATENCY_MS = 5000;
    private static final int MIN_LATENCY_CHECK_MS = 500;
    private static final long TIME_UNSET = -9223372036854775807L;
    private static final long FORCE_RESET_WORKAROUND_TIMEOUT_MS = 200L;
    private static final long RELEASE_WORKAROUND_TIME_MS = 80L;
    private static final int SDK_INT = Build.VERSION.SDK_INT;
    private static final int ERROR_NULL_BUFFER = -10;
    private static final int ERROR_SIZE_ILLEGAL = -11;
    private static final int ERROR_FORMAT_ILLEGAL = -12;
    private static final int START_NO_SET = -1;
    private static final int DISCONTINGUNITY_MS = 200;
    private AudioTrack mAudioTrack = null;
    private TTPlayer mPlayer = null;
    private int mBlockSize = 2048;
    private int mSampleRate = 44100;
    private int mChannels = 2;
    private int mSampleBytes = 2;
    private int mSampleFormat = 0;
    private int mFrameSamples = 0;
    private AudioManager mAudioManager = null;
    private int mChannelsLayout = 0;
    private int mAudioFormat = 2;
    private float mLeftVolume = -1.0f;
    private int mMaxVolume = 0;
    private volatile boolean mStoped = true;
    private byte[] mMinBytes;
    private int mSerial = -1;
    private Method getLatencyMethod = null;
    private int mTrackBufferSize = 0;
    private int mLatencyMs = 0;
    private int mBufferSizeMs = 0;
    private long mLastGetLatencyMs = 0L;
    private long mWrittenPcmBytes = 0L;
    private long lastRawPlaybackHeadPosition = 0L;
    private long forceResetWorkaroundTimeMs = -9223372036854775807L;
    private static boolean mNeedReleaseWorkAround = false;
    private static String mDeviceName = null;
    private long mStartTime = 0L;
    private int mStreamType = 3;
    private AudioTrackPositionTracker audioTrackPositionTracker;
    private ConditionVariable mReleasingConditionVariable;
    private int mStartMediaTimeMs = -1;
    private int mEnableAudioTrackSmoothClock = 0;
    private int mSessionId = -1;
    @Keep
    private long mNativeObject = 0L;

    @CalledByNative
    public AJVoice() {
        if (mDeviceName == null && (mDeviceName = Build.DEVICE).equals("OnePlus6T")) {
            Log.d((String)TAG, (String)"device need workaround");
            mNeedReleaseWorkAround = true;
        }
    }

    @CalledByNative
    public int open(long nativeObject, TTPlayer player) {
        int ret = 0;
        this.mPlayer = player;
        ret = this.reconfigure();
        if (ret == 0) {
            if (this.mLeftVolume != -1.0f) {
                this.setVolume(this.mLeftVolume, this.mLeftVolume);
            }
            if (Build.VERSION.SDK_INT >= 18) {
                try {
                    this.getLatencyMethod = AudioTrack.class.getMethod("getLatency", null);
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    // empty catch block
                }
            }
        }
        return ret;
    }

    public void releaseTrack(AudioTrack toRelease) {
        if (toRelease == null) {
            return;
        }
        try {
            long trackRunningTime;
            if (mNeedReleaseWorkAround && (trackRunningTime = SystemClock.elapsedRealtime() - this.mStartTime) <= 80L) {
                Thread.sleep(80L - trackRunningTime);
            }
        }
        catch (Exception trackRunningTime) {
            // empty catch block
        }
        try {
            toRelease.release();
        }
        catch (Exception e) {
            Log.w((String)TAG, (String)("release in invalid state = " + e));
        }
    }

    @CalledByNative
    public void close() {
        if (this.mAudioTrack != null) {
            final AudioTrack toRelease = this.mAudioTrack;
            this.mAudioTrack = null;
            try {
                AVThreadPool.addTask(new Runnable(){

                    @Override
                    public void run() {
                        Log.i((String)TAG, (String)"start release task");
                        AJVoice.this.releaseTrack(toRelease);
                    }
                });
            }
            catch (Throwable e) {
                Log.w((String)TAG, (String)("create close thread fail = " + e));
                this.releaseTrack(toRelease);
            }
        }
    }

    @CalledByNative
    public int start() {
        if (this.mAudioTrack == null) {
            Log.e((String)TAG, (String)"audiotrack start before created");
            return -2;
        }
        this.mStoped = false;
        try {
            if (this.audioTrackPositionTracker != null) {
                this.audioTrackPositionTracker.setAudioTrack(this.mAudioTrack, this.mAudioFormat, AJVoice.getPcmFrameSize(this.mAudioFormat, this.mChannels), this.mTrackBufferSize);
            }
            this.mAudioTrack.play();
            this.mSerial = -1;
        }
        catch (Throwable e) {
            Log.e((String)TAG, (String)("audioTrack start failed = " + e));
            return -3;
        }
        if (mNeedReleaseWorkAround) {
            this.mStartTime = SystemClock.elapsedRealtime();
        }
        return 0;
    }

    @CalledByNative
    public void pause() {
        try {
            if (this.audioTrackPositionTracker != null) {
                this.audioTrackPositionTracker.pause();
            }
            this.mAudioTrack.pause();
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }

    @CalledByNative
    public void resume() {
        try {
            if (this.audioTrackPositionTracker != null) {
                this.audioTrackPositionTracker.setAudioTrack(this.mAudioTrack, this.mAudioFormat, AJVoice.getPcmFrameSize(this.mAudioFormat, this.mChannels), this.mTrackBufferSize);
                this.audioTrackPositionTracker.start();
            }
            this.mAudioTrack.play();
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }

    @CalledByNative
    public void flush() {
        try {
            if (this.audioTrackPositionTracker != null) {
                this.audioTrackPositionTracker.reset();
            }
            this.mStartMediaTimeMs = -1;
            this.mAudioTrack.flush();
            if (this.mWrittenPcmBytes > 0L) {
                this.mWrittenPcmBytes = 0L;
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }

    @CalledByNative
    public void stop() {
        if (this.mStoped) {
            return;
        }
        this.mStoped = true;
        try {
            if (this.audioTrackPositionTracker != null) {
                this.audioTrackPositionTracker.pause();
            }
            this.mAudioTrack.pause();
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }

    @CalledByNative
    public int write(byte[] buffer, int offset, int size, int serial) {
        if (buffer == null || buffer.length == 0) {
            AVLogger.e(TAG, "buffer is nullpoint");
            return -10;
        }
        if (this.mStoped) {
            return 0;
        }
        if (this.mSerial != serial) {
            this.mSerial = serial;
            if (this.mWrittenPcmBytes > 0L) {
                this.mAudioTrack.flush();
            }
        }
        int wSize = 0;
        try {
            wSize = this.mAudioTrack.write(buffer, offset, size);
        }
        catch (Exception e) {
            Log.d((String)TAG, (String)("write fail = " + e));
            e.printStackTrace();
            return -1;
        }
        if (wSize < 0) {
            Log.e((String)TAG, (String)("write failed : ret: " + wSize + ", size = " + size));
            return wSize;
        }
        this.mWrittenPcmBytes += (long)wSize;
        int ret = 0;
        if (this.needsReset() && this.reset() == 0) {
            ret = this.start();
        }
        return ret == 0 ? wSize : ret;
    }

    @RequiresApi(api=21)
    @CalledByNative
    public int write(byte[] buffer, int offset, int size, int serial, long pts) {
        if (buffer == null || buffer.length == 0) {
            AVLogger.e(TAG, "buffer is nullpoint");
            return -10;
        }
        if (this.mStoped) {
            return 0;
        }
        if (this.mSerial != serial) {
            this.mSerial = serial;
            if (this.audioTrackPositionTracker != null && this.mReleasingConditionVariable != null) {
                if (this.mWrittenPcmBytes > 0L) {
                    if (this.audioTrackPositionTracker.isPlaying()) {
                        this.mAudioTrack.pause();
                    }
                    this.audioTrackPositionTracker.reset();
                    this.mStartMediaTimeMs = -1;
                    this.mReleasingConditionVariable.close();
                    this.mWrittenPcmBytes = 0L;
                    final AudioTrack releaseTrack = this.mAudioTrack;
                    this.mAudioTrack = null;
                    AVThreadPool.addTask(new Runnable(){

                        @Override
                        public void run() {
                            try {
                                Log.d((String)TAG, (String)"release old track");
                                releaseTrack.flush();
                                releaseTrack.release();
                                Log.d((String)TAG, (String)"release old track done");
                            }
                            finally {
                                AJVoice.this.mReleasingConditionVariable.open();
                            }
                        }
                    });
                    this.mReleasingConditionVariable.block();
                    this.reconfigure();
                    this.start();
                    this.mSerial = serial;
                }
            } else if (this.mWrittenPcmBytes > 0L) {
                this.mAudioTrack.flush();
            }
        }
        if (this.mStartMediaTimeMs == -1) {
            this.mStartMediaTimeMs = (int)Math.max(0L, pts);
        } else {
            long expectedPresentationTimeMs = (long)this.mStartMediaTimeMs + this.getWrittenDurationMs();
            if (Math.abs(expectedPresentationTimeMs - pts) > 200L) {
                Log.e((String)TAG, (String)("Discontinuity detected [expected " + expectedPresentationTimeMs + ", got " + pts + "]"));
                long adjustmentUs = pts - expectedPresentationTimeMs;
                this.mStartMediaTimeMs = (int)((long)this.mStartMediaTimeMs + adjustmentUs);
            }
        }
        int wSize = 0;
        try {
            wSize = this.mAudioTrack.write(buffer, offset, size);
        }
        catch (Exception e) {
            Log.d((String)TAG, (String)("write fail = " + e));
            e.printStackTrace();
            return -1;
        }
        if (wSize < 0) {
            Log.e((String)TAG, (String)("write failed : ret: " + wSize + ", size = " + size));
            return wSize;
        }
        this.mWrittenPcmBytes += (long)wSize;
        int ret = 0;
        if (this.needsReset() && this.reset() == 0) {
            ret = this.start();
            this.mSerial = serial;
        }
        return ret == 0 ? wSize : ret;
    }

    @SuppressLint(value={"NewApi"})
    public int write(ByteBuffer buffer, int serial) {
        if (buffer == null) {
            AVLogger.e(TAG, "buffer is nullpoint");
            return -1;
        }
        int size = this.mAudioTrack.write(buffer, 0, buffer.capacity());
        if (size != buffer.capacity()) {
            return -1;
        }
        buffer.flip();
        return 0;
    }

    @CalledByNative
    public void setTrackVolume(float leftVolume, float rightVolume) {
        if (this.mAudioTrack != null) {
            this.mAudioTrack.setStereoVolume(leftVolume, rightVolume);
        }
    }

    @CalledByNative
    public void setVolume(float leftVolume, float rightVolume) {
        try {
            if ((float)this.mMaxVolume < leftVolume) {
                leftVolume = this.mMaxVolume;
            }
            if (rightVolume == -1048575.0f && this.mAudioTrack != null) {
                this.mAudioTrack.setStereoVolume(leftVolume, rightVolume);
            } else if (this.mAudioManager != null) {
                this.mAudioManager.setStreamVolume(this.mStreamType, (int)leftVolume, 0);
            }
            this.mLeftVolume = leftVolume;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @CalledByNative
    public float getVolume() {
        int max = 0;
        int current = 0;
        if (this.mPlayer != null && this.mLeftVolume == -1.0f && this.mAudioManager != null) {
            try {
                max = this.mAudioManager.getStreamMaxVolume(this.mStreamType);
                current = this.mAudioManager.getStreamVolume(this.mStreamType);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (current >= 0) {
            return current;
        }
        if (max > 0) {
            return max / 4;
        }
        return 10.0f;
    }

    @CalledByNative
    public int getMaxVolume() {
        Log.i((String)"ttmn", (String)("getMaxVolume:" + this.mMaxVolume));
        return this.mMaxVolume;
    }

    @CalledByNative
    public void setSampleInfo(int format, int sampleRate, int channels, int bufferSize, int frameSampleNumber, int sampleBits) {
        this.mSampleRate = sampleRate;
        this.mChannels = channels;
        this.mBlockSize = bufferSize;
        this.mSampleBytes = sampleBits;
        this.mSampleFormat = format;
        this.mFrameSamples = frameSampleNumber;
    }

    @CalledByNative
    public void setStreamType(int streamType) {
        Log.d((String)TAG, (String)("set Stream type : " + streamType));
        this.mStreamType = streamType;
        if (this.mPlayer == null) {
            return;
        }
        if (this.reset() == 0) {
            this.start();
        }
    }

    @CalledByNative
    public void setSessionId(int sessionId) {
        Log.d((String)TAG, (String)("setSessionId : " + sessionId));
        this.mSessionId = sessionId;
        if (this.mPlayer == null) {
            return;
        }
        if (this.reset() == 0) {
            this.start();
        }
    }

    @CalledByNative
    public int getSessionId() {
        int sessionId = this.mSessionId;
        if (sessionId == -1 && this.mAudioTrack != null) {
            sessionId = this.mAudioTrack.getAudioSessionId();
        }
        return sessionId;
    }

    public void onMarkerReached(AudioTrack arg0) {
    }

    public void onPeriodicNotification(AudioTrack arg0) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int reconfigure() {
        this.mAudioManager = (AudioManager)this.mPlayer.getContext().getSystemService("audio");
        if (this.mAudioManager != null) {
            this.mMaxVolume = this.mAudioManager.getStreamMaxVolume(this.mStreamType);
        }
        this.mChannelsLayout = AJVoice.getAudioTrackChannelConfig(this.mChannels);
        if (this.mChannelsLayout == 0) {
            AVLogger.k(TAG, String.format(Locale.US, "not supoort channel:%d", this.mChannels));
            return -1;
        }
        if (this.mSampleBytes == 1) {
            this.mAudioFormat = 3;
        } else if (this.mSampleBytes == 2) {
            this.mAudioFormat = 2;
        } else {
            return -12;
        }
        int minBufSize = AudioTrack.getMinBufferSize((int)this.mSampleRate, (int)this.mChannelsLayout, (int)this.mAudioFormat);
        if (minBufSize <= 0) {
            Log.e((String)TAG, (String)("getMinBufferSize failed, trace: sampleRate = " + this.mSampleRate + ", mChannelsLayout = " + this.mChannelsLayout + ", mAudioFormat = " + this.mAudioFormat));
            return minBufSize;
        }
        this.mTrackBufferSize = minBufSize;
        try {
            this.mMinBytes = new byte[minBufSize];
        }
        catch (OutOfMemoryError e) {
            Log.e((String)TAG, (String)"out of memory error when new audio buffer for audiotrack");
            return -10;
        }
        this.mBufferSizeMs = this.mTrackBufferSize / AJVoice.getPcmFrameSize(this.mAudioFormat, this.mChannels) * 1000 / this.mSampleRate;
        Log.d((String)TAG, (String)("minbuffersize = " + minBufSize + ", buffersizeMs = " + this.mBufferSizeMs));
        try {
            this.mAudioTrack = this.mSessionId == -1 ? new AudioTrack(this.mStreamType, this.mSampleRate, this.mChannelsLayout, this.mAudioFormat, minBufSize, 1) : new AudioTrack(this.mStreamType, this.mSampleRate, this.mChannelsLayout, this.mAudioFormat, minBufSize, 1, this.mSessionId);
        }
        catch (Throwable e) {
            Log.e((String)TAG, (String)("create audio track failed ,detail = " + e));
            return -1;
        }
        int state = this.mAudioTrack.getState();
        if (state != 1) {
            try {
                this.mAudioTrack.release();
            }
            catch (Exception exception) {}
            finally {
                this.mAudioTrack = null;
                Log.e((String)TAG, (String)"create audiotrack but failed to initialize");
                return -3;
            }
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int reset() {
        int ret = 0;
        this.mWrittenPcmBytes = 0L;
        this.mLatencyMs = 0;
        this.forceResetWorkaroundTimeMs = -9223372036854775807L;
        this.mLastGetLatencyMs = 0L;
        this.lastRawPlaybackHeadPosition = 0L;
        this.mLeftVolume = -1.0f;
        AudioTrack stalledTrack = this.mAudioTrack;
        this.mAudioTrack = null;
        try {
            stalledTrack.flush();
            stalledTrack.release();
        }
        catch (Exception exception) {
        }
        finally {
            ret = this.reconfigure();
        }
        return ret;
    }

    @CalledByNative
    public int getCurrentPositionMs() {
        if (this.audioTrackPositionTracker != null) {
            int currentPosition = this.mStartMediaTimeMs + (int)(this.audioTrackPositionTracker.getCurrentPositionUs(false) / 1000L);
            return currentPosition;
        }
        return 0;
    }

    @CalledByNative
    public int getLatency() {
        long systemClockMs;
        this.getPlaybackHeadPosition();
        if (this.getLatencyMethod != null && (systemClockMs = System.nanoTime() / 1000000L) - this.mLastGetLatencyMs > 500L) {
            try {
                int latency = 0;
                this.mLatencyMs = latency = ((Integer)this.getLatencyMethod.invoke((Object)this.mAudioTrack, (Object[])null)).intValue();
                this.mLatencyMs = Math.max(this.mLatencyMs, 0);
                if (this.mLatencyMs > 5000) {
                    Log.w((String)TAG, (String)("Ignoring impossibly large audio latency: " + this.mLatencyMs));
                    this.mLatencyMs = 0;
                }
            }
            catch (Exception e) {
                this.getLatencyMethod = null;
            }
            this.mLastGetLatencyMs = systemClockMs;
        }
        return this.mLatencyMs;
    }

    private boolean needsReset() {
        return this.forceResetWorkaroundTimeMs != -9223372036854775807L && this.mWrittenPcmBytes > 0L && SystemClock.elapsedRealtime() - this.forceResetWorkaroundTimeMs >= 200L;
    }

    private long getPlaybackHeadPosition() {
        int state = this.mAudioTrack.getPlayState();
        if (state == 1) {
            return 0L;
        }
        long rawPlaybackHeadPosition = 0xFFFFFFFFL & (long)this.mAudioTrack.getPlaybackHeadPosition();
        if (rawPlaybackHeadPosition == 0L && this.lastRawPlaybackHeadPosition > 0L && state == 3) {
            if (this.forceResetWorkaroundTimeMs == -9223372036854775807L) {
                this.forceResetWorkaroundTimeMs = SystemClock.elapsedRealtime();
            }
            return this.lastRawPlaybackHeadPosition;
        }
        this.forceResetWorkaroundTimeMs = -9223372036854775807L;
        this.lastRawPlaybackHeadPosition = rawPlaybackHeadPosition;
        long playbackPostion = rawPlaybackHeadPosition;
        return playbackPostion;
    }

    private long getWrittenDurationMs() {
        return this.mWrittenPcmBytes / (long)AJVoice.getPcmFrameSize(this.mAudioFormat, this.mChannels) * 1000L / (long)this.mSampleRate;
    }

    private long getPlaybackPositionMs() {
        return this.getPlaybackHeadPosition() * 1000L / (long)this.mSampleRate;
    }

    private long getPlaybackBytes() {
        return this.getPlaybackHeadPosition() * (long)AJVoice.getPcmFrameSize(this.mAudioFormat, this.mChannels);
    }

    @CalledByNative
    public int getEOSDelayMs() {
        long writtenDurationMs = this.getWrittenDurationMs();
        long playbackDurationMs = this.getPlaybackPositionMs();
        long outputLatencyMs = this.getLatency() > 0 ? (long)(this.mLatencyMs - this.mBufferSizeMs) : 0L;
        int eosDelayMs = (int)(writtenDurationMs - playbackDurationMs + outputLatencyMs);
        return eosDelayMs;
    }

    public static int getPcmFrameSize(int pcmEncoding, int channelCount) {
        switch (pcmEncoding) {
            case 3: {
                return channelCount;
            }
            case 2: {
                return channelCount * 2;
            }
        }
        throw new IllegalArgumentException();
    }

    @CalledByNative
    public int getTrackBufferSize() {
        return this.mTrackBufferSize;
    }

    public static int getAudioTrackChannelConfig(int channelCount) {
        switch (channelCount) {
            case 1: {
                return 4;
            }
            case 2: {
                return 12;
            }
            case 3: {
                return 28;
            }
            case 4: {
                return 204;
            }
            case 5: {
                return 220;
            }
            case 6: {
                return 252;
            }
            case 7: {
                return 1276;
            }
            case 8: {
                if (Build.VERSION.SDK_INT >= 23) {
                    return 6396;
                }
                if (Build.VERSION.SDK_INT >= 21) {
                    return 6396;
                }
                return 0;
            }
        }
        return 0;
    }

    @CalledByNative
    public void setAudioTrackSmoothClock(int enableAudioTrackSmoothClock) {
        if (Util.SDK_INT >= 21) {
            this.mEnableAudioTrackSmoothClock = enableAudioTrackSmoothClock;
            if (this.mEnableAudioTrackSmoothClock > 0) {
                this.audioTrackPositionTracker = new AudioTrackPositionTracker(null);
                this.mReleasingConditionVariable = new ConditionVariable(true);
            }
        }
    }
}

