/*
 * Decompiled with CFR 0.152.
 */
package com.ss.ttm.player;

import android.media.audiofx.AudioEffect;
import android.os.Build;
import com.ss.ttm.player.CalledByNative;
import com.ss.ttm.player.Keep;

@Keep
public class AudioFormats {
    private static final int[] validSampleRates = new int[]{4000, 8000, 11025, 16000, 22050, 32000, 37800, 44056, 44100, 47250, 48000, 50000, 50400, 88200, 96000, 176400, 192000, 352800, 2822400, 5644800};
    private static boolean sDetectDlbDevices = false;
    private static boolean sDlbDevice = false;

    public static int getDefaultSampleRatesNB() {
        return validSampleRates.length;
    }

    public static int getMaxSupportedSampleRates(int[] sampleRate) {
        int maxNum = validSampleRates.length;
        maxNum = Build.VERSION.SDK_INT >= 23 ? (maxNum -= 3) : (Build.VERSION.SDK_INT >= 21 ? (maxNum -= 5) : (maxNum -= 9));
        for (int i = 0; i < maxNum; ++i) {
            sampleRate[i] = validSampleRates[i];
        }
        return maxNum;
    }

    @CalledByNative
    public static boolean isLicencedDolbyDevice() {
        if (sDetectDlbDevices) {
            return sDlbDevice;
        }
        for (AudioEffect.Descriptor des : AudioEffect.queryEffects()) {
            if (!des.implementor.contains("Dolby Laboratories")) continue;
            sDlbDevice = true;
            break;
        }
        sDetectDlbDevices = true;
        return sDlbDevice;
    }
}

